/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.bn;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.tigr.microarray.mev.cluster.gui.impl.bn.BifNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class BifDOMBuilder {
    private DocumentBuilder builder;
    private ArrayList<BifNode> bifAL = new ArrayList();

    public BifDOMBuilder() {
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            this.builder = docBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException pce) {
            System.out.println("BifDOMBuilder() exception...");
            pce.printStackTrace();
        }
    }

    public ArrayList<BifNode> build(InputSource source) throws SAXException, IOException {
        this.bifAL.clear();
        int BIN = 0;
        Document document = this.builder.parse(source);
        return this.build(document, BIN);
    }

    public ArrayList<BifNode> build(String fileName_bif) throws SAXException, IOException {
        this.bifAL.clear();
        int BIN = 0;
        Document document = this.builder.parse(fileName_bif);
        return this.build(document, BIN);
    }

    private ArrayList<BifNode> build(Document document, int BIN) throws SAXException, IOException {
        NodeList nodes_variables = document.getElementsByTagName("VARIABLE");
        if (nodes_variables.getLength() == 0) {
            throw new SAXException("Invalid XML file content");
        }
        Node var = nodes_variables.item(0);
        Node var1 = nodes_variables.item(1);
        ArrayList<Integer> binsInNode = new ArrayList<Integer>();
        for (int nodeIndex = 0; nodeIndex < nodes_variables.getLength(); ++nodeIndex) {
            binsInNode.add(((Element)nodes_variables.item(nodeIndex)).getElementsByTagName("OUTCOME").getLength());
        }
        NodeList nodes_def = document.getElementsByTagName("DEFINITION");
        for (int i = 0; i < nodes_def.getLength(); ++i) {
            Node def = nodes_def.item(i);
            BifNode bnode = new BifNode();
            bnode.setBins((Integer)binsInNode.get(i));
            NodeList nodes_j = def.getChildNodes();
            for (int j = 0; j < nodes_j.getLength(); ++j) {
                Node node_j = nodes_j.item(j);
                if (node_j.getNodeType() == 1 && ((Element)node_j).getTagName().equals("FOR")) {
                    Element child = (Element)node_j;
                    bnode.setChild(child.getChildNodes().item(0).getNodeValue().trim());
                }
                if (node_j.getNodeType() == 1 && ((Element)node_j).getTagName().equals("GIVEN")) {
                    Element given = (Element)node_j;
                    bnode.addParent(given.getChildNodes().item(0).getNodeValue().trim());
                }
                if (node_j.getNodeType() != 1 || !((Element)node_j).getTagName().equals("TABLE")) continue;
                Element table = (Element)node_j;
                String strTable = table.getChildNodes().item(0).getNodeValue();
                String[] _tmp = strTable.trim().split(" ");
                bnode.initCPTnD(this.nDArrayFromStringCPT(_tmp, (Integer)binsInNode.get(i)));
                bnode.initCPT(this.ArrayFromStringCPT(_tmp));
            }
            if (bnode.getChild() == null) continue;
            this.bifAL.add(bnode);
        }
        return this.bifAL;
    }

    public HashMap buildHashMap(String fileName_bif) throws SAXException, IOException {
        HashMap<String, BifNode> bifNodes = new HashMap<String, BifNode>();
        int BIN = 0;
        Document document = this.builder.parse(fileName_bif);
        NodeList nodes_variables = document.getElementsByTagName("VARIABLE");
        if (nodes_variables.getLength() == 0) {
            throw new SAXException("Invalid XML file content");
        }
        Node var = nodes_variables.item(0);
        Node var1 = nodes_variables.item(1);
        if (var.getNodeType() == 1) {
            BIN = ((Element)var).getElementsByTagName("OUTCOME").getLength();
        } else if (var1.getNodeType() == 1) {
            BIN = ((Element)var1).getElementsByTagName("OUTCOME").getLength();
        } else {
            throw new SAXException("Number of discrete states could not be determined");
        }
        NodeList nodes_def = document.getElementsByTagName("DEFINITION");
        for (int i = 0; i < nodes_def.getLength(); ++i) {
            Node def = nodes_def.item(i);
            BifNode bnode = new BifNode();
            bnode.setBins(BIN);
            NodeList nodes_j = def.getChildNodes();
            for (int j = 0; j < nodes_j.getLength(); ++j) {
                Node node_j = nodes_j.item(j);
                if (node_j.getNodeType() == 1 && ((Element)node_j).getTagName().equals("FOR")) {
                    Element child = (Element)node_j;
                    bnode.setChild(child.getChildNodes().item(0).getNodeValue().trim());
                }
                if (node_j.getNodeType() == 1 && ((Element)node_j).getTagName().equals("GIVEN")) {
                    Element given = (Element)node_j;
                    bnode.addParent(given.getChildNodes().item(0).getNodeValue().trim());
                }
                if (node_j.getNodeType() != 1 || !((Element)node_j).getTagName().equals("TABLE")) continue;
                Element table = (Element)node_j;
                String strTable = table.getChildNodes().item(0).getNodeValue();
                String[] _tmp = strTable.trim().split(" ");
                bnode.initCPTnD(this.nDArrayFromStringCPT(_tmp, BIN));
                bnode.initCPT(this.ArrayFromStringCPT(_tmp));
            }
            if (bnode.getChild() == null) continue;
            bifNodes.put(bnode.getChild(), bnode);
        }
        return bifNodes;
    }

    public BifNode getBifNode(String name) {
        for (int i = 0; i < this.bifAL.size(); ++i) {
            if (!this.bifAL.get(i).getChild().equals(name)) continue;
            return this.bifAL.get(i);
        }
        return null;
    }

    public ArrayList<BifNode> getParents(BifNode bifNode) {
        ArrayList<BifNode> bifNodeParents = new ArrayList<BifNode>();
        ArrayList<String> parents = bifNode.getParents();
        if (parents != null) {
            for (int i = 0; i < parents.size(); ++i) {
                if (parents.get(i) == null) continue;
                bifNodeParents.add(this.getBifNode(parents.get(i)));
            }
        }
        return bifNodeParents;
    }

    private float[] ArrayFromStringCPT(String[] _cpt) {
        float[] arr_1 = new float[_cpt.length];
        for (int k = 0; k < _cpt.length; ++k) {
            arr_1[k] = Float.parseFloat(_cpt[k]);
        }
        return arr_1;
    }

    private float[][][] nDArrayFromStringCPT(String[] _cpt, int binSize) {
        float[][][] arr_1 = new float[_cpt.length][binSize][binSize];
        for (int k = 0; k < _cpt.length; k += binSize) {
            for (int l = 0; l < binSize; ++l) {
                arr_1[k][l][l] = Float.parseFloat(_cpt[k + l]);
            }
        }
        return arr_1;
    }

    public static void main(String[] args) {
        BifDOMBuilder bdb = new BifDOMBuilder();
        try {
            bdb.build("C:/Projects/MeV/MeV_SVN/data/BN_files/affy_HG-U133_Plus_2_BN/results/FixedNetWithCPT.xml");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

