/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.bn;

import ftp.FtpBean;
import ftp.FtpListResult;
import ftp.FtpObserver;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.cluster.gui.impl.bn.BNFileUpdateDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.HTMLMessageFileChooser;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.Progress;

public class BNUpdateManager {
    private String FTP_CONFIG_URL = "http://www.tm4.org/bn/ftp_config.txt";
    private String FTP_SERVER;
    private String REPOSITORY_ROOT;
    private JFrame frame;
    private Hashtable animalHash;
    private Hashtable plantHash;
    private Vector animalKeys;
    private Vector plantKeys;
    private String destLoc;
    private int BUFFERSIZE = 1024;
    private byte[] buffer;
    private Progress progress;
    private boolean needSeparateImpliesZip = true;
    private boolean okStatus = true;
    private ProgressListener listener;
    String path;

    public BNUpdateManager(JFrame parent, String apath) {
        this.frame = parent;
        this.path = apath;
        this.listener = new ProgressListener();
        this.progress = new Progress((Frame)parent, "File Update Progress", this.listener);
    }

    public void updateFiles() {
        try {
            BNFileUpdateDialog dialog;
            this.progress.setDescription("Retreving Repository Information");
            this.progress.setUnits(2);
            this.progress.show();
            Vector tabPropertyHashes = this.getRepositoryInfo();
            this.progress.setDescription("Visiting Repsoitory for Resource Checks");
            this.progress.setUnits(tabPropertyHashes.size());
            this.populateMenuHashes(tabPropertyHashes);
            this.progress.dispose();
            if (this.okStatus && (dialog = new BNFileUpdateDialog(this.frame, tabPropertyHashes)).showModal() == 0) {
                this.FTP_SERVER = (String)dialog.getRepositoryProperties().get("ftp-server");
                this.REPOSITORY_ROOT = (String)dialog.getRepositoryProperties().get("base-dir");
                this.updateBNFiles(dialog.getSpeciesName(), dialog.getArrayName());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.print("Message" + e.getMessage());
            JOptionPane.showMessageDialog(this.frame, "<html>An error occurred when retrieving information onavailable<br>species and clone set files.  Update request cannot be fulfilled.", "BN Update Error", 0);
            this.okStatus = false;
            this.progress.dispose();
        }
    }

    private Vector getRepositoryInfo() {
        Vector repHashes = new Vector();
        try {
            URLConnection conn = new URL(this.FTP_CONFIG_URL).openConnection();
            this.progress.setValue(1);
            repHashes = this.parseConfig(conn.getInputStream());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return repHashes;
    }

    private Vector parseConfig(InputStream is) throws IOException {
        String line;
        Vector hashVector = new Vector();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        int numTabs = 0;
        Hashtable<String, String> currHash = null;
        while ((line = br.readLine()) != null) {
            if (line.startsWith("#")) continue;
            String[] keyValue = line.split("\t");
            if (keyValue[0].equals("tab-label")) {
                if (numTabs > 0) {
                    hashVector.add(currHash);
                }
                currHash = new Hashtable<String, String>();
                ++numTabs;
            }
            currHash.put(keyValue[0], keyValue[1]);
        }
        hashVector.add(currHash);
        this.progress.setValue(2);
        return hashVector;
    }

    private void populateMenuHashes(Vector tabHashes) {
        for (int i = 0; i < tabHashes.size(); ++i) {
            this.getMenuInfo((Hashtable)tabHashes.get(i));
            this.progress.setValue(i + 1);
        }
    }

    private void getMenuInfo(Hashtable tabHash) {
        String server = (String)tabHash.get("ftp-server");
        String baseLoc = (String)tabHash.get("base-dir");
        String orgFile = (String)tabHash.get("taxon-file");
        String label = (String)tabHash.get("tab-label");
        Vector<String> upperLevelKeys = new Vector<String>();
        Hashtable upperToLowerHash = new Hashtable();
        try {
            FtpBean ftp = new FtpBean();
            ftp.ftpConnect(server, "anonymous");
            byte[] content = ftp.getBinaryFile(baseLoc + orgFile);
            String text = new String(content);
            ftp.close();
            StringTokenizer stok = new StringTokenizer(text, "\n");
            while (stok.hasMoreElements()) {
                String tabName;
                StringTokenizer stok2 = new StringTokenizer((String)stok.nextElement(), "\t");
                if (stok2.countTokens() != 3 || !(tabName = stok2.nextToken()).equalsIgnoreCase(label)) continue;
                String upperLabel = stok2.nextToken();
                String lowerLabel = stok2.nextToken();
                lowerLabel = lowerLabel.trim();
                if (!upperLevelKeys.contains(upperLabel)) {
                    upperLevelKeys.add(upperLabel);
                }
                if (upperToLowerHash.containsKey(upperLabel)) {
                    ((Vector)upperToLowerHash.get(upperLabel)).add(lowerLabel);
                    continue;
                }
                Vector<String> fileVector = new Vector<String>();
                fileVector.add(lowerLabel);
                upperToLowerHash.put(upperLabel, fileVector);
            }
            tabHash.put("main-keys", upperLevelKeys);
            tabHash.put("menu-hash", upperToLowerHash);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.print("Message" + e.getMessage());
            JOptionPane.showMessageDialog(this.frame, "<html>An error occurred when retrieving information onavailable<br>species and clone set files.  Update request cannot be fulfilled.", "BN Update Error", 0);
            this.okStatus = false;
            this.progress.dispose();
        }
    }

    private void updateBNFiles(String species, String array) {
        Thread thread = new Thread(new Runner(species, array));
        thread.start();
    }

    private File getOutputFileLocation() {
        File file = null;
        String msg = "<html><center><h1>Literature Mining Files Location</h1></center>";
        msg = msg + "For literature mining 3 sources of articles(Resourcerer, Entrez Gene, Pubmed) can be download to the directory \"bn\"<br>";
        msg = msg + "</html>";
        HTMLMessageFileChooser chooser = new HTMLMessageFileChooser((Frame)this.frame, "BN Files Location", msg, TMEV.getFile((String)"data"), true);
        JFileChooser baseChooser = chooser.getFileChooser();
        baseChooser.setFileSelectionMode(1);
        chooser.setSize(550, 550);
        if (chooser.showModal() == 0) {
            file = chooser.getSelectedFile();
        }
        return file;
    }

    private void getBaseFiles(String species, String array) {
        boolean pass1 = true;
        boolean pass2 = true;
        File baseDir = new File(this.path);
        File outputFile = new File(baseDir.getAbsolutePath() + "/" + array + "_RE.zip");
        this.progress.setTitle("BN File Download");
        this.progress.setDescription("Download Base Zip File");
        this.progress.show();
        pass1 = this.downloadFile(species, array + "_BN.zip", outputFile);
        if (pass1) {
            pass1 = this.extractZipFile(outputFile);
        }
        if (pass2 = this.downloadFile(species, "symArts.zip", outputFile = new File(baseDir.getAbsolutePath() + "/" + array + "_Ar.zip"))) {
            pass2 = this.extractZipFile(outputFile);
        }
        this.progress.dispose();
        if (pass1 && pass2) {
            JOptionPane.showMessageDialog(this.frame, "The BN file system update is complete.", "BN File System Update", 1);
        } else {
            JOptionPane.showMessageDialog(this.frame, "The BN file system update was terminated due to the reported error.", "BN File System Update", 0);
        }
    }

    private boolean downloadFile(String species, String slide, File dest) {
        boolean length = false;
        try {
            int overallLength = 0;
            boolean currentLength = false;
            this.progress.setValue(0);
            FtpBean ftp = new FtpBean();
            ftp.ftpConnect(this.FTP_SERVER, "anonymous");
            ftp.setDirectory(this.REPOSITORY_ROOT + "/" + species);
            FtpListResult list = ftp.getDirectoryContent();
            while (list.next()) {
                if (!list.getName().equals(slide)) continue;
                overallLength = (int)list.getSize();
            }
            this.progress.setUnits(overallLength);
            this.listener.reset();
            this.listener.setMax(overallLength);
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(dest));
            bos.write(ftp.getBinaryFile(slide, (FtpObserver)this.listener), 0, overallLength);
            bos.flush();
            bos.close();
            ftp.close();
        }
        catch (Exception ioe) {
            this.progress.dispose();
            ioe.printStackTrace();
            JOptionPane.showMessageDialog(this.frame, "<html>An Error occured when downloading " + species + ".<br>The update request cannot be fulfilled.</html>", "BN Update Download Error", 0);
            return false;
        }
        return true;
    }

    private boolean extractZipFile(File outputFile) {
        this.progress.setTitle("Extracting zip file");
        this.progress.setDescription("Extracting zip file: " + outputFile.getAbsolutePath());
        try {
            ZipFile zipFile = new ZipFile(outputFile);
            this.progress.setUnits(zipFile.size());
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            File baseDir = outputFile.getParentFile();
            byte[] buffer = new byte[this.BUFFERSIZE];
            int length = 0;
            int cnt = 0;
            while (entries.hasMoreElements()) {
                this.progress.setValue(cnt);
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory()) {
                    ++cnt;
                    continue;
                }
                String entryName = entry.getName();
                String entryFolder = new File(entryName).getParent();
                File entryDirectory = new File(baseDir.getAbsolutePath() + "/" + entryFolder);
                if (!entryDirectory.exists()) {
                    entryDirectory.mkdirs();
                }
                BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(baseDir.getAbsolutePath() + "/" + entry.getName()));
                BufferedInputStream bis = new BufferedInputStream(zipFile.getInputStream(entry));
                while ((length = bis.read(buffer, 0, this.BUFFERSIZE)) > 0) {
                    bos.write(buffer, 0, length);
                }
                ++cnt;
                bos.flush();
                bos.close();
                bis.close();
            }
        }
        catch (Exception e) {
            this.progress.dispose();
            e.printStackTrace();
            JOptionPane.showMessageDialog(this.frame, "<html>An Error occured when extracting " + outputFile.getAbsolutePath() + ".<br>The update request cannot be fulfilled.</html>", "BN Update Download Error", 0);
            return false;
        }
        return true;
    }

    private class ProgressListener
    extends DialogListener
    implements WindowListener,
    FtpObserver {
        private int maxProgress = 0;
        private int currProgress = 0;
        private boolean isStopped = false;

        private ProgressListener() {
        }

        public void setMax(int max) {
            this.maxProgress = 0;
        }

        public void reset() {
            this.maxProgress = 0;
            this.currProgress = 0;
            this.isStopped = false;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("cancel-command")) {
                this.isStopped = true;
                BNUpdateManager.this.progress.dispose();
            }
        }

        @Override
        public void windowClosing(WindowEvent e) {
            this.isStopped = true;
            BNUpdateManager.this.progress.dispose();
        }

        public void byteRead(int bytes) {
            this.currProgress += bytes;
            if (BNUpdateManager.this.progress != null) {
                BNUpdateManager.this.progress.setValue(this.currProgress);
            }
        }

        public void byteWrite(int bytes) {
            this.currProgress += bytes;
            if (BNUpdateManager.this.progress != null) {
                BNUpdateManager.this.progress.setValue(bytes);
            }
        }

        public boolean isStopped() {
            return this.isStopped;
        }
    }

    private class Runner
    implements Runnable {
        private String species;
        private String array;

        public Runner(String species, String array) {
            this.species = species;
            this.array = array;
        }

        @Override
        public void run() {
            BNUpdateManager.this.getBaseFiles(this.species, this.array);
        }
    }
}

