/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.bn;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.tigr.microarray.mev.cluster.gui.impl.bn.BifDOMBuilder;
import org.tigr.microarray.mev.cluster.gui.impl.bn.BifNode;

public class BNProbTableCalculator {
    private float[][] origProbTable;
    private float[][] difProbTable;
    private float[][] probTable;
    private int[] setNodes;
    private boolean[] ptFound;
    private BifDOMBuilder bdb;
    ArrayList<BifNode> bif = new ArrayList();
    private int numNodes;

    public BNProbTableCalculator(BifDOMBuilder bdb) {
        this.bdb = bdb;
        try {
            this.bif = this.bdb.build("C:/workspace/MeV_trunk_11_11/data/BN_files/FixedNetWithCPT.xml");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.numNodes = this.bif.size();
        this.origProbTable = new float[3][this.numNodes];
        this.difProbTable = new float[3][this.numNodes];
        this.probTable = new float[3][this.numNodes];
        this.ptFound = new boolean[this.numNodes];
        this.setNodes = new int[this.numNodes];
        this.calculateTables();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < this.numNodes; ++j) {
                this.origProbTable[i][j] = this.probTable[i][j];
            }
        }
        this.getDifTable();
    }

    private void calculateTables() {
        int i;
        for (i = 0; i < this.numNodes; ++i) {
            this.ptFound[i] = false;
        }
        for (i = 0; i < this.numNodes; ++i) {
            if (this.havePT(this.bif.get(i))) continue;
            this.getPT(this.bif.get(i));
        }
        this.getDifTable();
    }

    private void resetNodes() {
        for (int i = 0; i < this.setNodes.length; ++i) {
            this.setNodes[i] = 0;
        }
    }

    private void setNode(BifNode bifNode, int set) {
        this.setNodes[this.bif.indexOf((Object)bifNode)] = set;
    }

    private void getDifTable() {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < this.numNodes; ++j) {
                this.difProbTable[i][j] = this.probTable[i][j] - this.origProbTable[i][j];
            }
        }
    }

    private void getPT(BifNode bifNode) {
        for (int i = 0; i < this.bdb.getParents(bifNode).size(); ++i) {
            BifNode parent = this.bdb.getParents(bifNode).get(i);
            if (this.havePT(parent)) continue;
            this.getPT(parent);
        }
        this.calcPTWithParents(bifNode);
    }

    private void calcPTWithParents(BifNode bifNode) {
        ArrayList<BifNode> parentNodes = this.bdb.getParents(bifNode);
        if (this.setNodes[this.bif.indexOf(bifNode)] != 0) {
            for (int bin = 0; bin < 3; ++bin) {
                this.probTable[bin][this.bif.indexOf((Object)bifNode)] = 0.0f;
            }
            this.probTable[this.setNodes[this.bif.indexOf((Object)bifNode)] - 1][this.bif.indexOf((Object)bifNode)] = 1.0f;
            this.ptFound[this.bif.indexOf((Object)bifNode)] = true;
            return;
        }
        if (parentNodes.size() == 0) {
            for (int bin = 0; bin < 3; ++bin) {
                try {
                    this.probTable[bin][this.bif.indexOf((Object)bifNode)] = bifNode.getCPT()[bin];
                    continue;
                }
                catch (NullPointerException npe) {
                    System.out.println(bifNode.getChild());
                    npe.printStackTrace();
                }
            }
            this.ptFound[this.bif.indexOf((Object)bifNode)] = true;
            return;
        }
        for (int bin = 0; bin < 3; ++bin) {
            int i;
            float prob = 0.0f;
            int[] indices = new int[parentNodes.size()];
            for (i = 0; i < parentNodes.size(); ++i) {
                indices[i] = 0;
            }
            i = 0;
            while ((double)i < Math.pow(3.0, parentNodes.size())) {
                float p = 1.0f;
                for (int parentCounter = 0; parentCounter < parentNodes.size(); ++parentCounter) {
                    p *= this.probTable[indices[parentCounter]][this.bif.indexOf(parentNodes.get(parentCounter))];
                }
                prob += p * bifNode.getCPT()[3 * i + bin];
                int lastIndex = indices.length - 1;
                for (int numP = 0; numP < parentNodes.size(); ++numP) {
                    int n = lastIndex;
                    indices[n] = indices[n] + 1;
                    if (indices[lastIndex] <= 2) break;
                    indices[lastIndex] = 0;
                    --lastIndex;
                }
                ++i;
            }
            this.probTable[bin][this.bif.indexOf((Object)bifNode)] = prob;
        }
        this.ptFound[this.bif.indexOf((Object)bifNode)] = true;
    }

    private boolean havePT(BifNode bifNode) {
        return this.ptFound[this.bif.indexOf(bifNode)];
    }

    private void printCurrentPTs() {
        System.out.println();
        System.out.println("  ********Results*******");
        for (int i = 0; i < this.numNodes; ++i) {
            System.out.print("Node: " + this.bif.get(i).getChild() + ":     \t");
            for (int j = 0; j < 3; ++j) {
                System.out.print(this.probTable[j][i] + "\t");
            }
            System.out.println();
        }
    }

    private void printOriginalPTs() {
        System.out.println();
        System.out.println("  ********Original*******");
        for (int i = 0; i < this.numNodes; ++i) {
            System.out.print("Node: " + this.bif.get(i).getChild() + ":     \t");
            for (int j = 0; j < 3; ++j) {
                System.out.print(this.origProbTable[j][i] + "\t");
            }
            System.out.println();
        }
    }

    private void printDifPTs() {
        System.out.println();
        System.out.println("  ********Difference*******");
        for (int i = 0; i < this.numNodes; ++i) {
            System.out.print("Node: " + this.bif.get(i).getChild() + ":     \t");
            for (int j = 0; j < 3; ++j) {
                System.out.print(this.difProbTable[j][i] + "\t");
            }
            System.out.println();
        }
    }

    private void printbdb() {
        int count = 0;
        for (int i = 0; i < this.bif.size(); ++i) {
            int j;
            System.out.println("\n" + i);
            float[] a = this.bif.get(i).getCPT();
            String b = this.bif.get(i).getChild();
            ArrayList<String> c = this.bif.get(i).getParents();
            if (b != null) {
                System.out.println("Child = " + b);
            }
            if (c != null) {
                System.out.print("Parents:\t");
                for (j = 0; j < c.size(); ++j) {
                    System.out.print(c.get(j) + "\t");
                }
                System.out.println();
            }
            if (a == null) continue;
            System.out.print("Node " + count + "\t");
            ++count;
            for (j = 0; j < a.length; ++j) {
                System.out.print(a[j] + "\t");
            }
            System.out.println();
        }
    }

    private void showDialog() {
        JPanel jp = new JPanel();
        jp.setLayout(new GridBagLayout());
        for (int i = 0; i < this.numNodes; ++i) {
            jp.add((Component)new JLabel("Node: " + this.bif.get(i).getChild() + ": "), new GridBagConstraints(0, i, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 5, 0), 0, 0));
            JButton jb = new JButton("Down");
            jb.setActionCommand(String.valueOf(i));
            jb.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    BNProbTableCalculator.this.setNode(BNProbTableCalculator.this.bif.get(Integer.parseInt(evt.getActionCommand())), 1);
                    BNProbTableCalculator.this.calculateTables();
                    BNProbTableCalculator.this.printCurrentPTs();
                    BNProbTableCalculator.this.printDifPTs();
                }
            });
            jp.add((Component)jb, new GridBagConstraints(1, i, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 5, 0), 0, 0));
            jb = new JButton("Neutral");
            jb.setActionCommand(String.valueOf(i));
            jb.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    BNProbTableCalculator.this.setNode(BNProbTableCalculator.this.bif.get(Integer.parseInt(evt.getActionCommand())), 2);
                    BNProbTableCalculator.this.calculateTables();
                    BNProbTableCalculator.this.printCurrentPTs();
                    BNProbTableCalculator.this.printDifPTs();
                }
            });
            jp.add((Component)jb, new GridBagConstraints(2, i, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 5, 0), 0, 0));
            jb = new JButton("Up");
            jb.setActionCommand(String.valueOf(i));
            jb.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    BNProbTableCalculator.this.setNode(BNProbTableCalculator.this.bif.get(Integer.parseInt(evt.getActionCommand())), 3);
                    BNProbTableCalculator.this.calculateTables();
                    BNProbTableCalculator.this.printCurrentPTs();
                    BNProbTableCalculator.this.printDifPTs();
                }
            });
            jp.add((Component)jb, new GridBagConstraints(3, i, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 5, 0), 0, 0));
        }
        JButton jb = new JButton("Reset");
        jb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BNProbTableCalculator.this.resetNodes();
                BNProbTableCalculator.this.calculateTables();
                BNProbTableCalculator.this.printCurrentPTs();
                BNProbTableCalculator.this.printDifPTs();
            }
        });
        jp.add((Component)jb, new GridBagConstraints(1, this.numNodes, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 5, 0), 0, 0));
        JDialog jd = new JDialog();
        jd.add(jp);
        jd.pack();
        jd.setSize(400, 800);
        jd.setVisible(true);
    }

    public static void main(String[] args) {
        BifDOMBuilder bdb = new BifDOMBuilder();
        BNProbTableCalculator tableCalc = new BNProbTableCalculator(bdb);
        tableCalc.printbdb();
        tableCalc.calculateTables();
        tableCalc.showDialog();
        System.out.println("Set " + tableCalc.bif.get(3).getChild());
        tableCalc.printCurrentPTs();
        tableCalc.printOriginalPTs();
        tableCalc.printDifPTs();
    }
}

