/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.bn;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.cluster.clusterUtil.Cluster;
import org.tigr.microarray.mev.cluster.clusterUtil.ClusterRepository;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.helpers.ClusterBrowser;
import org.tigr.microarray.mev.cluster.gui.impl.bn.BNConstants;
import org.tigr.microarray.mev.cluster.gui.impl.bn.BNDownloadManager;
import org.tigr.microarray.mev.cluster.gui.impl.bn.BNSupportDataFile;
import org.tigr.microarray.mev.cluster.gui.impl.bn.BNUpdateManager;
import org.tigr.microarray.mev.cluster.gui.impl.bn.Useful;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.ParameterPanel;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;
import org.tigr.microarray.mev.resources.IResourceManager;
import org.tigr.microarray.mev.resources.ISupportFileDefinition;
import org.tigr.microarray.mev.resources.ResourcererAnnotationFileDefinition;
import org.tigr.microarray.mev.resources.SupportFileAccessError;

public class BNInitDialog
extends AlgorithmDialog {
    private int result = 2;
    ConfigPanel configPanel;
    CustomSeedDialog customSeedDialog;
    PriorSelectionPanel priorsPanel;
    NetworkSeedPanel networkSeedPanel;
    DiscretizingPanel discPanel;
    ClassNumPanel classnumPanel;
    XmlBifPanel useGoPanel;
    RunBNPanel runBNPanel;
    BootStrapPanel bootStrapPanel;
    ClusterBrowser browser;
    EventListener listener;
    BNParameterPanel bnParamPanel;
    JTabbedPane tabbedPane;
    Font font;
    String sep;
    Frame parent;
    IFramework framework;
    String searchAlgorithm = "TabuSearch";
    String scoreType = "BAYES";
    boolean useArc = true;
    boolean useCreated = false;
    File fileDir = null;
    String kegg_sp = null;
    protected String arrayName;
    protected String speciesName;
    protected Hashtable<String, Vector<String>> speciestoarrays;
    protected IResourceManager resourceManager;
    protected boolean useLoadedAnnotationFile = false;
    ClusterRepository cr;
    File annotationFile;

    public BNInitDialog(IFramework frame, ClusterRepository repository, String[] annotationLabels, IResourceManager rm, String speciesName, String arrayName, Hashtable<String, Vector<String>> speciestoarrays) {
        super(frame.getFrame(), "BN: Bayesian Network Analysis", true);
        this.parent = frame.getFrame();
        this.framework = frame;
        this.cr = repository;
        this.speciesName = speciesName;
        this.arrayName = arrayName;
        this.resourceManager = rm;
        this.speciestoarrays = speciestoarrays;
        this.font = new Font("Dialog", 1, 12);
        this.listener = new EventListener();
        this.addWindowListener(this.listener);
        this.tabbedPane = new JTabbedPane();
        this.configPanel = new ConfigPanel();
        JPanel popNClusterPanel = new JPanel(new GridBagLayout());
        popNClusterPanel.setPreferredSize(new Dimension(600, 450));
        popNClusterPanel.setBackground(Color.white);
        this.browser = new ClusterBrowser(repository);
        popNClusterPanel.add((Component)this.browser, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.tabbedPane.add("Population and Cluster Selection", popNClusterPanel);
        this.bnParamPanel = new BNParameterPanel(annotationLabels);
        JPanel parameters = new JPanel(new GridBagLayout());
        parameters.setBackground(Color.white);
        JPanel verticalOne = new JPanel(new GridBagLayout());
        JPanel verticalTwo = new JPanel(new GridBagLayout());
        this.priorsPanel = new PriorSelectionPanel(repository != null && !repository.isEmpty());
        this.networkSeedPanel = new NetworkSeedPanel();
        this.bootStrapPanel = new BootStrapPanel();
        this.discPanel = new DiscretizingPanel();
        this.classnumPanel = new ClassNumPanel();
        this.useGoPanel = new XmlBifPanel();
        this.runBNPanel = new RunBNPanel();
        verticalOne.add((Component)this.priorsPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        verticalOne.add((Component)this.bootStrapPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        verticalTwo.add((Component)this.discPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        verticalTwo.add((Component)this.classnumPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        verticalTwo.add((Component)this.useGoPanel, new GridBagConstraints(1, 0, 1, 2, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.tabbedPane.add("Running BN Parameters", this.runBNPanel);
        parameters.add((Component)this.configPanel, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        parameters.add((Component)this.networkSeedPanel, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        parameters.add((Component)verticalOne, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        parameters.add((Component)verticalTwo, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        parameters.add((Component)this.tabbedPane, new GridBagConstraints(0, 4, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.addContent(parameters);
        this.setActionListeners(this.listener);
        if (repository == null || repository.isEmpty()) {
            Component comp = this.tabbedPane.getComponentAt(0);
            JPanel panel = (JPanel)comp;
            panel.removeAll();
            panel.validate();
            panel.setOpaque(false);
            panel.add((Component)new JLabel("Empty Cluster Repository"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(15, 0, 10, 0), 0, 0));
            panel.add((Component)new JLabel("Please create a gene cluster and launch BN again."), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.tabbedPane.setSelectedIndex(0);
            this.okButton.setEnabled(false);
        }
        this.setSize(650, 842);
    }

    public BNInitDialog(Frame parent, String[] annotationLabels) {
        super(parent, "BN:  Bayes Network Analysis", true);
        this.parent = parent;
        this.font = new Font("Dialog", 1, 12);
        this.listener = new EventListener();
        this.addWindowListener(this.listener);
        this.tabbedPane = new JTabbedPane();
        this.configPanel = new ConfigPanel();
        JPanel popNClusterPanel = new JPanel(new GridBagLayout());
        popNClusterPanel.setPreferredSize(new Dimension(600, 450));
        popNClusterPanel.setBackground(Color.white);
        JPanel emptyClusterPanel = new JPanel(new GridBagLayout());
        String text = "<center><b>Note: When running BN in script mode the cluster<br>";
        text = text + "under analysis is determined by the preceding algorithm<br>";
        text = text + "that feeds source data into BN.</center>";
        JTextPane textArea = new JTextPane();
        textArea.setEditable(false);
        textArea.setBackground(Color.white);
        textArea.setContentType("text/html");
        textArea.setText(text);
        emptyClusterPanel.add((Component)textArea, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        popNClusterPanel.add((Component)emptyClusterPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.tabbedPane.add("Population and Cluster Selection", popNClusterPanel);
        JPanel parameters = new JPanel(new GridBagLayout());
        parameters.setBackground(Color.white);
        JPanel verticalOne = new JPanel(new GridBagLayout());
        JPanel verticalTwo = new JPanel(new GridBagLayout());
        this.priorsPanel = new PriorSelectionPanel(true);
        this.networkSeedPanel = new NetworkSeedPanel();
        this.bootStrapPanel = new BootStrapPanel();
        this.discPanel = new DiscretizingPanel();
        this.classnumPanel = new ClassNumPanel();
        this.useGoPanel = new XmlBifPanel();
        this.runBNPanel = new RunBNPanel();
        this.tabbedPane.add("Running Bayesian Network Parameters", this.runBNPanel);
        verticalOne.add((Component)this.priorsPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        verticalOne.add((Component)this.bootStrapPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        verticalTwo.add((Component)this.discPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        verticalTwo.add((Component)this.classnumPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        verticalTwo.add((Component)this.useGoPanel, new GridBagConstraints(1, 0, 1, 2, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        parameters.add((Component)this.configPanel, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        parameters.add((Component)this.networkSeedPanel, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        parameters.add((Component)verticalOne, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        parameters.add((Component)verticalTwo, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        parameters.add((Component)this.tabbedPane, new GridBagConstraints(0, 4, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.addContent(parameters);
        this.setActionListeners(this.listener);
        this.setSize(650, 842);
    }

    public int showModal() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    private void resetControls() {
    }

    public boolean isClusterModeSelected() {
        return this.priorsPanel.litSourceCheckbox.isSelected();
    }

    public Cluster getSelectedCluster() {
        return this.browser.getSelectedCluster();
    }

    public String getConverterFileName() {
        return this.bnParamPanel.getConverterFileName();
    }

    public int getMinClusterSize() {
        String value = this.bnParamPanel.minClusterSizeField.getText();
        try {
            int size = Integer.parseInt(value);
            return size;
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public String getBaseFileLocation() {
        return this.configPanel.getBaseFileLocation();
    }

    public int getNumberClass() {
        return this.classnumPanel.getNumClasses();
    }

    public int getNumberBin() {
        return this.discPanel.getNumLevels();
    }

    public boolean isLit() {
        return this.priorsPanel.litSourceCheckbox.isSelected();
    }

    public boolean isPPI() {
        return this.priorsPanel.ppiSourceCheckbox.isSelected();
    }

    public boolean isKEGG() {
        return this.priorsPanel.keggSourceCheckbox.isSelected();
    }

    public void setLit() {
        this.priorsPanel.litSourceCheckbox.setSelected(true);
    }

    public boolean isAll() {
        return this.isLit() && this.isPPI() && this.isKEGG();
    }

    public boolean isLitAndKegg() {
        return this.isLit() && this.isKEGG();
    }

    public boolean isPpiAndKegg() {
        return this.isKEGG() && this.isPPI() && !this.isLit();
    }

    public boolean isBoth() {
        return this.isLit() && this.isPPI();
    }

    public boolean isNone() {
        return !this.isLit() && !this.isPPI() && !this.isKEGG();
    }

    public boolean useGoTerm() {
        return this.useGoPanel.useGoButton.isSelected();
    }

    public String numParents() {
        return this.runBNPanel.numParents();
    }

    public String getAlgorithm() {
        return this.searchAlgorithm;
    }

    public void setAlgorithm(String sa) {
        this.searchAlgorithm = sa;
    }

    public String getScoreType() {
        return this.scoreType;
    }

    public void setScoreType(String st) {
        this.scoreType = st;
    }

    public boolean useArcRev() {
        return this.useArc;
    }

    public void setUseArcRev(boolean ua) {
        this.useArc = ua;
    }

    public int getNumIterations() {
        return this.bootStrapPanel.getNumIterations();
    }

    public float getConfThreshold() {
        return this.bootStrapPanel.getConfThreshold();
    }

    public boolean isBootstrapping() {
        return this.bootStrapPanel.isBootstrapping();
    }

    public int getKFolds() {
        return Integer.parseInt(this.runBNPanel.kFolds());
    }

    public String getKeggSpecies() {
        return this.kegg_sp;
    }

    public boolean useNetworkSeed() {
        return this.networkSeedPanel.netSeedCheckbox.isSelected();
    }

    public boolean useNetworkSeedWithPrior() {
        return this.networkSeedPanel.netSeedCheckbox.isSelected() && this.networkSeedPanel.usePriorsRadio.isSelected();
    }

    public boolean useNetworkSeedWithoutPrior() {
        return this.networkSeedPanel.netSeedCheckbox.isSelected() && this.networkSeedPanel.noPriorsRadio.isSelected();
    }

    public boolean useNetworkSeedForCptOnly() {
        return this.networkSeedPanel.netSeedCheckbox.isSelected() && this.networkSeedPanel.onlyCptRadio.isSelected();
    }

    public String getNetSeedUID() {
        return this.networkSeedPanel.netSeedUID;
    }

    boolean validateNetSeedUID() {
        System.out.println("Net Seed UID: " + this.networkSeedPanel.netSeedUID);
        return !this.networkSeedPanel.netSeedUID.equals(this.networkSeedPanel.netSeedUIDList[0]);
    }

    String getNetSeedFileLoc() {
        return this.networkSeedPanel.seedFileLocField.getText().trim();
    }

    public String[] getAnnToGOFileList() {
        return this.bnParamPanel.getAnnToGOFileList();
    }

    public static void main(String[] args) {
        String[] labels = new String[]{"TC#", "GB#", "Role"};
        BNInitDialog eid = new BNInitDialog((Frame)new JFrame(), labels);
        eid.showModal();
    }

    private class EventListener
    extends DialogListener
    implements ItemListener {
        private EventListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("use-converter-command")) {
                if (BNInitDialog.this.bnParamPanel.useAnnBox.isSelected()) {
                    BNInitDialog.this.bnParamPanel.browserButton.setEnabled(true);
                    BNInitDialog.this.bnParamPanel.converterFileField.setEnabled(true);
                    BNInitDialog.this.bnParamPanel.converterFileField.setBackground(Color.white);
                    BNInitDialog.this.bnParamPanel.fileLabel.setEnabled(true);
                } else {
                    BNInitDialog.this.bnParamPanel.browserButton.setEnabled(false);
                    BNInitDialog.this.bnParamPanel.converterFileField.setEnabled(false);
                    BNInitDialog.this.bnParamPanel.converterFileField.setBackground(Color.white);
                    BNInitDialog.this.bnParamPanel.fileLabel.setEnabled(false);
                }
            } else {
                if (command.equals("converter-file-browser-command")) {
                    File convertFile = new File(BNInitDialog.this.getBaseFileLocation() + "/Data/Convert");
                    JFileChooser chooser = new JFileChooser(convertFile);
                    chooser.setDialogTitle("Annotation Converter Selection");
                    chooser.setMultiSelectionEnabled(false);
                    if (chooser.showOpenDialog(BNInitDialog.this.parent) == 0) {
                        BNInitDialog.this.bnParamPanel.updateConverterFileField(chooser.getSelectedFile().getPath());
                    }
                    return;
                }
                if (command.equals("ann-file-browser-command")) {
                    File classFile = new File(BNInitDialog.this.getBaseFileLocation() + "/Data/Class/");
                    JFileChooser chooser = new JFileChooser(classFile);
                    chooser.setDialogTitle("Annotation --> GO Term, File(s) Selection");
                    chooser.setMultiSelectionEnabled(true);
                    if (chooser.showOpenDialog(BNInitDialog.this.parent) == 0) {
                        BNInitDialog.this.bnParamPanel.updateAnnFileList(chooser.getSelectedFiles());
                        BNInitDialog.this.bnParamPanel.removeButton.setEnabled(true);
                        BNInitDialog.this.okButton.setEnabled(true);
                    }
                } else if (command.equals("remove-ann-file-command")) {
                    BNInitDialog.this.bnParamPanel.removeSelectedFiles();
                } else if (command.equals("select-file-base-command")) {
                    BNInitDialog.this.configPanel.selectFileSystem();
                } else if (command.equals("update-files-command")) {
                    BNUpdateManager manager = new BNUpdateManager((JFrame)BNInitDialog.this.parent, BNInitDialog.this.configPanel.getBaseFileLocation());
                    manager.updateFiles();
                } else if (command.equals("ok-command")) {
                    String fileName;
                    BNInitDialog.this.result = 0;
                    Hashtable<String, String> repInfo = BNDownloadManager.getRepositoryInfoCytoscape();
                    String codeBase = repInfo.get("cytoscape_webstart").trim();
                    String libDir = repInfo.get("cytoscape_lib_dir").trim();
                    String pluginsDir = repInfo.get("cytoscape_plugins_dir").trim();
                    if (codeBase == null || libDir == null) {
                        JOptionPane.showMessageDialog(new JFrame(), "Internet Connection error or Error reading properties file, will try with default values", "Cytoscape may not launch", 0);
                        return;
                    }
                    System.out.println("Jnlp codeBase: " + codeBase);
                    System.out.println("Jnlp libDir: " + libDir);
                    System.out.println("Jnlp pluginsDir: " + pluginsDir);
                    BNConstants.setCodeBaseLocation(codeBase);
                    BNConstants.setLibDirLocation(libDir);
                    BNConstants.setPluginsDirLocation(pluginsDir);
                    if (BNInitDialog.this.getSelectedCluster().getSize() > 250) {
                        JOptionPane.showMessageDialog(BNInitDialog.this.parent, "Cluster size exceeds max gene limit of 250. Please select or create a different one.", "Error!", 0);
                        return;
                    }
                    System.out.println("configPanel.is_getBNFileButtonClicked() & configPanel.is_cngFilesButtonClicked()" + BNInitDialog.this.configPanel.is_getBNFileButtonClicked() + ":" + BNInitDialog.this.configPanel.is_cngFilesButtonClicked());
                    if (!(BNInitDialog.this.configPanel.is_getBNFileButtonClicked() ^ BNInitDialog.this.configPanel.is_cngFilesButtonClicked())) {
                        String statusLbl = BNInitDialog.this.configPanel.statusLabel.getText();
                        JOptionPane.showMessageDialog(BNInitDialog.this.parent, "Please use appropriate button below the label \"" + statusLbl + "\" to select \n and/or download species and array specfic BN files", "Missing Selection for Files", 0);
                        return;
                    }
                    String fileBase = BNInitDialog.this.getBaseFileLocation();
                    boolean priors = false;
                    boolean netseed = false;
                    if (BNInitDialog.this.networkSeedPanel.netSeedCheckbox.isSelected()) {
                        netseed = true;
                        File netSeedFile = new File(BNInitDialog.this.networkSeedPanel.seedFileLocField.getText().trim());
                        if (!netSeedFile.exists()) {
                            JOptionPane.showMessageDialog(BNInitDialog.this.parent, "File: " + netSeedFile.getAbsolutePath() + " is missing or unreadable", "BN Initialization: Missing Network Seed File", 0);
                            return;
                        }
                        if (!BNInitDialog.this.validateNetSeedUID()) {
                            JOptionPane.showMessageDialog(BNInitDialog.this.parent, "Please select a UID for Network Seed File", "Error", 0);
                            BNInitDialog.this.networkSeedPanel.netSeedComboUID.grabFocus();
                            return;
                        }
                        if (BNInitDialog.this.networkSeedPanel.usePriorsRadio.isSelected()) {
                            priors = true;
                        } else if (BNInitDialog.this.networkSeedPanel.noPriorsRadio.isSelected()) {
                            priors = false;
                        }
                    } else {
                        boolean bl = priors = !priors;
                    }
                    if (priors && BNInitDialog.this.isLit()) {
                        if (!new File(fileBase + BNConstants.SEP + "res.txt").exists()) {
                            JOptionPane.showMessageDialog(BNInitDialog.this.parent, "File: " + fileBase + BNConstants.SEP + "res.txt" + " is missing", "BN Initialization: Missing File", 0);
                            return;
                        }
                        if (!new File(fileBase + BNConstants.SEP + "affyID_accession.txt").exists()) {
                            JOptionPane.showMessageDialog(BNInitDialog.this.parent, "File: " + fileBase + BNConstants.SEP + "affyID_accession.txt" + " is missing", "BN Initialization: Missing File", 0);
                            return;
                        }
                        if (!new File(fileBase + BNConstants.SEP + "symArtsGeneDb.txt").exists()) {
                            JOptionPane.showMessageDialog(BNInitDialog.this.parent, "File: " + fileBase + BNConstants.SEP + "symArtsGeneDb.txt" + " is missing", "BN Initialization: Missing File", 0);
                            return;
                        }
                        if (!new File(fileBase + BNConstants.SEP + "symArtsPubmed.txt").exists()) {
                            JOptionPane.showMessageDialog(BNInitDialog.this.parent, "File: " + fileBase + BNConstants.SEP + "symArtsPubmed.txt" + " is missing", "BN Initialization: Missing File", 0);
                            return;
                        }
                    }
                    if (priors && BNInitDialog.this.isPPI() && !new File(fileBase + BNConstants.SEP + "all_ppi.txt").exists()) {
                        JOptionPane.showMessageDialog(BNInitDialog.this.parent, "File: " + fileBase + BNConstants.SEP + "all_ppi.txt" + " is missing", "BN Initialization: Missing File", 0);
                        return;
                    }
                    if (priors && BNInitDialog.this.isKEGG()) {
                        boolean success;
                        BNInitDialog.this.kegg_sp = null;
                        if (BNInitDialog.this.framework.getData().isAnnotationLoaded()) {
                            BNInitDialog.this.kegg_sp = BNInitDialog.this.framework.getData().getChipAnnotation().getSpeciesName().trim();
                        }
                        if (BNInitDialog.this.kegg_sp == null) {
                            BNInitDialog.this.kegg_sp = (String)JOptionPane.showInputDialog(null, "Select a Species", "Annotation Unknown", 2, null, BNConstants.KEGG_ORG, BNConstants.KEGG_ORG[0]);
                        } else if (!this.isKeggOrgSupported(BNInitDialog.this.kegg_sp) && JOptionPane.showConfirmDialog(new JFrame(), "Do you want to continue ? ", "Species " + BNInitDialog.this.kegg_sp + " not Supported for KEGG", 0) == 1) {
                            return;
                        }
                        if (BNInitDialog.this.kegg_sp.equalsIgnoreCase("Human")) {
                            BNInitDialog.this.kegg_sp = "hsa";
                        } else if (BNInitDialog.this.kegg_sp.equalsIgnoreCase("Mouse")) {
                            BNInitDialog.this.kegg_sp = "mmu";
                        } else if (BNInitDialog.this.kegg_sp.equalsIgnoreCase("Rat")) {
                            BNInitDialog.this.kegg_sp = "rno";
                        }
                        if (!new File(BNConstants.KEGG_FILE_BASE).exists() && !(success = new File(BNConstants.KEGG_FILE_BASE).mkdir())) {
                            JOptionPane.showMessageDialog(BNInitDialog.this.parent, "Failed to create directory", "Error", 0);
                            return;
                        }
                        String keggFileName = BNInitDialog.this.kegg_sp + "_kegg_edges.txt";
                        if (!new File(BNConstants.KEGG_FILE_BASE + BNConstants.SEP + keggFileName).exists()) {
                            JOptionPane.showMessageDialog(BNInitDialog.this.parent, "KEGG file is missing, will try to download", "BN Initialization: Missing File", 0);
                            BNDownloadManager dwnMgr = new BNDownloadManager((JFrame)BNInitDialog.this.parent, BNConstants.KEGG_FILE_BASE, "Trying to Download KEGG File", keggFileName, false);
                            if (!dwnMgr.updateFiles()) {
                                return;
                            }
                        }
                    }
                    if (priors && BNInitDialog.this.isNone()) {
                        JOptionPane.showMessageDialog(BNInitDialog.this.parent, "Network Priors Source(s) not selected", "BN Initialization: Missing Selection", 0);
                        return;
                    }
                    if (BNInitDialog.this.useGoTerm() && !new File(fileBase + BNConstants.SEP + "gbGO.txt").exists()) {
                        JOptionPane.showMessageDialog(BNInitDialog.this.parent, "File: " + fileBase + BNConstants.SEP + "gbGO.txt" + " is missing", "BN Initialization: Missing File", 0);
                        return;
                    }
                    if (BNInitDialog.this.bnParamPanel.useAnnBox.isSelected() && ((fileName = BNInitDialog.this.bnParamPanel.getConverterFileName()) == null || fileName.equals("") || fileName.equals(" "))) {
                        JOptionPane.showMessageDialog(BNInitDialog.this.parent, "You have selected to use an annotation conversion file but have not made a file selection.\nPlease enter a file name or browse to select a file.", "BN Initialization: Missing Parameter", 2);
                        BNInitDialog.this.tabbedPane.setSelectedIndex(1);
                        BNInitDialog.this.bnParamPanel.browserButton.grabFocus();
                        return;
                    }
                    String val = BNInitDialog.this.runBNPanel.kFolds().trim();
                    int fld = -1;
                    try {
                        fld = Integer.parseInt(val);
                    }
                    catch (NumberFormatException nfe) {
                        JOptionPane.showMessageDialog(BNInitDialog.this.parent, "Numbers only Pls", "Error", 0);
                        BNInitDialog.this.runBNPanel.kFolds.grabFocus();
                        return;
                    }
                    int sampleCnt = BNInitDialog.this.framework.getData().getFeaturesCount();
                    if (fld < 2 | fld > sampleCnt) {
                        JOptionPane.showMessageDialog(BNInitDialog.this.parent, "Min is 2 and cannot be greater than # of sample.", "Error", 0);
                        BNInitDialog.this.runBNPanel.kFolds.grabFocus();
                        return;
                    }
                    if (BNInitDialog.this.bootStrapPanel.isBootstrappingCheckbox.isEnabled()) {
                        float flt = 0.0f;
                        try {
                            flt = Float.parseFloat(BNInitDialog.this.bootStrapPanel.confThresholdField.getText().trim());
                        }
                        catch (NumberFormatException nfe) {
                            JOptionPane.showMessageDialog(BNInitDialog.this.parent, "Float value only", "Error", 0);
                            BNInitDialog.this.bootStrapPanel.confThresholdField.grabFocus();
                            return;
                        }
                        if (flt < 0.5f | flt > 0.99f) {
                            JOptionPane.showMessageDialog(BNInitDialog.this.parent, "Value expected between 0.50 & 0.99", "Error", 0);
                            BNInitDialog.this.bootStrapPanel.confThresholdField.grabFocus();
                            return;
                        }
                        int itr = 0;
                        try {
                            itr = Integer.parseInt(BNInitDialog.this.bootStrapPanel.numIterationsField.getText().trim());
                        }
                        catch (NumberFormatException nfe) {
                            JOptionPane.showMessageDialog(BNInitDialog.this.parent, "Integers only", "Error", 0);
                            BNInitDialog.this.bootStrapPanel.numIterationsField.grabFocus();
                            return;
                        }
                    }
                    if (!new File(fileBase + BNConstants.SEP + "results").exists()) {
                        boolean success = new File(fileBase + BNConstants.SEP + "results").mkdir();
                        if (!success) {
                            JOptionPane.showMessageDialog(BNInitDialog.this.parent, "Dir: " + fileBase + BNConstants.SEP + "results" + " cannot be created", "BN Initialization: Dir create error", 0);
                            return;
                        }
                        System.out.println("Dir: " + fileBase + BNConstants.SEP + "results" + " created successfully !!");
                    }
                    if (!new File(fileBase + BNConstants.SEP + "tmp").exists()) {
                        boolean success = new File(fileBase + BNConstants.SEP + "tmp").mkdir();
                        if (!success) {
                            JOptionPane.showMessageDialog(BNInitDialog.this.parent, "Dir: " + fileBase + BNConstants.SEP + "tmp" + " cannot be created", "BN Initialization: Dir create error", 0);
                            return;
                        }
                        System.out.println("Dir: " + fileBase + BNConstants.SEP + "tmp" + " created successfully !!");
                    }
                    BNConstants.setBaseFileLocation(fileBase);
                    TMEV.storeProperty((String)BNConstants.BN_LM_LOC_PROP, (String)fileBase);
                    BNInitDialog.this.dispose();
                } else if (command.equals("cancel-command")) {
                    BNInitDialog.this.result = 2;
                    BNInitDialog.this.dispose();
                } else {
                    if (command.equals("reset-command")) {
                        BNInitDialog.this.resetControls();
                        BNInitDialog.this.result = 2;
                        return;
                    }
                    if (command.equals("info-command")) {
                        HelpWindow.launchBrowser(BNInitDialog.this, "BN Initialization Dialog");
                    } else if (command.equals("organism-selected-command")) {
                        BNInitDialog.this.configPanel.selectSpecies();
                        BNInitDialog.this.configPanel.updateSelection();
                    } else if (command.equals("array-selected-command")) {
                        BNInitDialog.this.configPanel.updateSelection();
                    } else if (command.equals("download-support-file-command")) {
                        BNInitDialog.this.configPanel.onDownloadSupportFile();
                    }
                }
            }
        }

        private boolean isKeggOrgSupported(String sp) {
            for (int i = 0; i < BNConstants.KEGG_ORG.length; ++i) {
                if (!sp.equalsIgnoreCase(BNConstants.KEGG_ORG[i])) continue;
                return true;
            }
            return false;
        }

        private void setLoadingSeedsButtons() {
            if (BNInitDialog.this.networkSeedPanel.netSeedComboUID.getSelectedIndex() != 0) {
                BNInitDialog.this.networkSeedPanel.createSeedButton.setEnabled(true);
                BNInitDialog.this.networkSeedPanel.uploadSeedButton.setEnabled(true);
            } else {
                BNInitDialog.this.networkSeedPanel.createSeedButton.setEnabled(false);
                BNInitDialog.this.networkSeedPanel.uploadSeedButton.setEnabled(false);
            }
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            BNInitDialog.this.result = -1;
            BNInitDialog.this.dispose();
        }

        void toggleState(Container item, boolean state) {
            Component[] cmp = item.getComponents();
            for (int i = 0; i < cmp.length; ++i) {
                cmp[i].setEnabled(state);
            }
        }
    }

    private class ConfigPanel
    extends ParameterPanel {
        JTextField defaultFileBaseLocation;
        JComboBox organismListBox;
        JComboBox arrayListBox;
        JLabel chooseOrg;
        JLabel chooseArray;
        JLabel browseLabel;
        JLabel statusLabel;
        JButton getBNFileButton;
        JButton cngFilesButton;
        boolean getBNFileButtonClicked;
        boolean cngFilesButtonClicked;

        public ConfigPanel() {
            super("Location of Support File(s)");
            this.setLayout(new GridBagLayout());
            this.cngFilesButton = new JButton("Change");
            this.cngFilesButton.setActionCommand("select-file-base-command");
            this.cngFilesButton.addActionListener(BNInitDialog.this.listener);
            this.cngFilesButton.setToolTipText("<html>Select the directory where BN  files reside.</html>");
            this.cngFilesButtonClicked = false;
            JLabel fileLocation = new JLabel("File(s) Location:");
            String _loc = TMEV.getSettingForOption((String)BNConstants.BN_LM_LOC_PROP);
            if (_loc == null) {
                _loc = TMEV.getDataPath();
            }
            if (_loc.equals("") || _loc.equals("")) {
                _loc = TMEV.getDataPath();
            }
            this.defaultFileBaseLocation = new JTextField(new File(_loc).getAbsolutePath());
            this.defaultFileBaseLocation.setEditable(true);
            this.getBNFileButton = new JButton("(Download)");
            this.getBNFileButton.setActionCommand("download-support-file-command");
            this.getBNFileButton.addActionListener(BNInitDialog.this.listener);
            this.getBNFileButton.setToolTipText("<html>Downloads BN support files<br>for a selected species and array type.</html>");
            this.getBNFileButtonClicked = false;
            this.chooseOrg = new JLabel("                     Organism");
            this.chooseArray = new JLabel("            Array Platform");
            this.browseLabel = new JLabel("Or browse for BN file:");
            this.statusLabel = new JLabel("Click to download");
            if (BNInitDialog.this.speciestoarrays == null || BNInitDialog.this.speciestoarrays.size() == 0) {
                this.organismListBox = new JComboBox();
                this.organismListBox.addItem("No organisms listed");
                this.organismListBox.setEnabled(false);
                this.arrayListBox = new JComboBox();
                this.arrayListBox.addItem("No species listed");
                this.arrayListBox.setEnabled(false);
            } else {
                if (BNInitDialog.this.speciestoarrays.size() > 0) {
                    this.organismListBox = new JComboBox<String>(new Vector<String>(BNInitDialog.this.speciestoarrays.keySet()));
                    try {
                        this.organismListBox.setSelectedItem(BNInitDialog.this.speciesName);
                    }
                    catch (NullPointerException npe) {
                        this.organismListBox.setSelectedIndex(0);
                    }
                    if (this.organismListBox.getSelectedItem() == null) {
                        this.arrayListBox = new JComboBox();
                    } else {
                        this.arrayListBox = new JComboBox();
                        Vector<String> arraysForThisSpecies = BNInitDialog.this.speciestoarrays.get(this.organismListBox.getSelectedItem());
                        for (int i = 0; i < arraysForThisSpecies.size(); ++i) {
                            this.arrayListBox.addItem(arraysForThisSpecies.elementAt(i));
                        }
                    }
                    try {
                        this.arrayListBox.setSelectedItem(BNInitDialog.this.arrayName);
                    }
                    catch (NullPointerException npe) {
                        this.arrayListBox.setSelectedIndex(0);
                    }
                }
                this.arrayListBox.setEnabled(true);
            }
            this.arrayListBox.addActionListener(BNInitDialog.this.listener);
            this.arrayListBox.setActionCommand("array-selected-command");
            this.organismListBox.addActionListener(BNInitDialog.this.listener);
            this.organismListBox.setActionCommand("organism-selected-command");
            this.add((Component)this.chooseOrg, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 20, 0, 0), 0, 0));
            this.add((Component)this.organismListBox, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 20, 0, 0), 0, 0));
            this.add((Component)this.statusLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 1, new Insets(5, 20, 0, 20), 0, 0));
            this.add((Component)this.chooseArray, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 20, 0, 0), 0, 0));
            this.add((Component)this.arrayListBox, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 20, 0, 0), 0, 0));
            this.add((Component)this.getBNFileButton, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 13, 1, new Insets(5, 20, 0, 20), 0, 0));
            this.add((Component)this.cngFilesButton, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 13, 1, new Insets(5, 20, 5, 20), 0, 0));
            this.add((Component)this.browseLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(10, 20, 0, 0), 0, 0));
            this.add((Component)this.defaultFileBaseLocation, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(10, 20, 5, 0), 0, 0));
            try {
                boolean b = BNInitDialog.this.resourceManager.fileIsInRepository((ISupportFileDefinition)new BNSupportDataFile(this.organismListBox.getSelectedItem().toString(), this.arrayListBox.getSelectedItem().toString()));
                if (b) {
                    this.getBNFileButton.setText("(Select This)");
                } else {
                    this.getBNFileButton.setText("Download");
                }
            }
            catch (NullPointerException npe) {
                this.getBNFileButton.setText("Download");
            }
            this.updateSelection();
        }

        public void selectFileSystem() {
            this.cngFilesButtonClicked = true;
            String startDir = this.defaultFileBaseLocation.getText();
            File file = new File(startDir);
            if (!file.exists()) {
                file = new File(TMEV.getDataPath());
            }
            JFileChooser chooser = new JFileChooser(file);
            chooser.setFileSelectionMode(1);
            if (chooser.showOpenDialog(BNInitDialog.this) == 0) {
                String dir = chooser.getSelectedFile().getAbsolutePath().trim();
                this.defaultFileBaseLocation.setText(chooser.getSelectedFile().getAbsolutePath());
                TMEV.storeProperty((String)BNConstants.BN_LM_LOC_PROP, (String)this.defaultFileBaseLocation.getText());
            } else {
                this.cngFilesButtonClicked = false;
            }
        }

        public String getBaseFileLocation() {
            return this.defaultFileBaseLocation.getText();
        }

        public void selectSpecies() {
            this.arrayListBox.removeAllItems();
            Vector<String> arraysForThisSpecies = BNInitDialog.this.speciestoarrays.get(this.organismListBox.getSelectedItem());
            for (int i = 0; i < arraysForThisSpecies.size(); ++i) {
                this.arrayListBox.addItem(arraysForThisSpecies.elementAt(i));
            }
        }

        public void updateSelection() {
            if (this.arrayListBox.getSelectedItem() == null) {
                return;
            }
            String selectedOrganism = this.organismListBox.getSelectedItem().toString();
            String selectedArray = this.arrayListBox.getSelectedItem().toString();
            if (selectedOrganism != null && selectedArray != null) {
                if (BNInitDialog.this.resourceManager.fileIsInRepository((ISupportFileDefinition)new BNSupportDataFile(selectedOrganism, selectedArray))) {
                    this.statusLabel.setText("Click to Select");
                    this.getBNFileButton.setText("Select");
                } else {
                    this.statusLabel.setText("Click to Download");
                    this.getBNFileButton.setText("Download");
                }
                this.getBNFileButton.setEnabled(true);
                try {
                    ResourcererAnnotationFileDefinition def = new ResourcererAnnotationFileDefinition(BNInitDialog.this.speciesName, BNInitDialog.this.arrayName);
                    BNInitDialog.this.annotationFile = BNInitDialog.this.resourceManager.getSupportFile((ISupportFileDefinition)def, false);
                }
                catch (SupportFileAccessError sfae) {
                    BNInitDialog.this.useLoadedAnnotationFile = false;
                }
            } else {
                this.getBNFileButton.setEnabled(false);
            }
        }

        public boolean is_getBNFileButtonClicked() {
            return this.getBNFileButtonClicked;
        }

        public boolean is_cngFilesButtonClicked() {
            return this.cngFilesButtonClicked;
        }

        private void setCursor(boolean state) {
            if (!state) {
                Cursor hourglassCursor = new Cursor(3);
                this.setCursor(hourglassCursor);
            }
            if (state) {
                Cursor normalCursor = new Cursor(0);
                this.setCursor(normalCursor);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onDownloadSupportFile() {
            try {
                this.setCursor(false);
                BNSupportDataFile bnSuppFile = new BNSupportDataFile(this.organismListBox.getSelectedItem().toString(), this.arrayListBox.getSelectedItem().toString());
                if (bnSuppFile == null) {
                    System.out.println("BNSuppFile obj is null");
                } else {
                    System.out.println("bnSuppFile.isSingleFile(): " + bnSuppFile.isSingleFile());
                    System.out.println("bnSuppFile.getUniqueName(): " + bnSuppFile.getUniqueName());
                    try {
                        System.out.println("bnSuppFile.getURL(): " + bnSuppFile.getURL().toString());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    System.out.println("bnSuppFile.isSingleFile(): " + bnSuppFile.isSingleFile());
                }
                File f = BNInitDialog.this.resourceManager.getSupportFile((ISupportFileDefinition)bnSuppFile, true);
                System.out.println("FTP & unzipping Complete: " + f.getAbsolutePath());
                String srcDirPath = f.getAbsolutePath() + BNConstants.SEP + bnSuppFile.getUniqueName();
                File srcDir = new File(srcDirPath);
                String dstDirPath = System.getProperty("user.dir") + BNConstants.SEP + "data" + BNConstants.SEP + "BN_files" + BNConstants.SEP + bnSuppFile.getUniqueName();
                File dstDir = new File(dstDirPath);
                Useful.copyDirectory(srcDir, dstDir);
                this.defaultFileBaseLocation.setText(dstDir.getAbsolutePath());
                TMEV.storeProperty((String)BNConstants.BN_LM_LOC_PROP, (String)this.defaultFileBaseLocation.getText());
                this.getBNFileButton.setText("Select This");
                this.statusLabel.setText("Selected");
                this.getBNFileButton.setEnabled(false);
                this.getBNFileButtonClicked = true;
                this.setCursor(true);
            }
            catch (IOException ioe) {
                this.statusLabel.setText("Failure");
                ioe.printStackTrace();
                System.out.println("LMDialog.onDownloadSupportFile() - File Copy Failed");
            }
            catch (SupportFileAccessError sfae) {
                this.statusLabel.setText("Failure");
                sfae.printStackTrace();
            }
            catch (NullPointerException npe) {
                this.statusLabel.setText("Failure");
                npe.printStackTrace();
                System.out.println("LMDialog.onDownloadSupportFile() - NullPointerException");
            }
            finally {
                Cursor normalCursor = new Cursor(0);
                this.setCursor(normalCursor);
            }
        }
    }

    private class CustomSeedDialog
    extends JDialog {
        private static final long serialVersionUID = 1L;
        NodeButtons[] nodeButtons;
        JLabel instructionsLabel;
        GridBagConstraints constraints;
        GridBagLayout gridbag;
        JTextField selectedParent;
        JTextField selectedChild;
        JButton removeSelectedParentButton;
        JButton removeInteractionButton;
        JList interactionsList;
        DefaultListModel interactionModel;
        boolean currentParentFilled;
        boolean currentChildFilled;
        int currentParentNode;
        int currentChildNode;
        Vector<Integer> parentNodes;
        Vector<Integer> childNodes;
        String[] nodeNames;
        JButton OKButton;
        JButton cancelButton;
        boolean success = false;

        public CustomSeedDialog(String[] strarr) {
            this.setSize(800, 600);
            this.setTitle("Create Network Seed");
            this.nodeNames = strarr;
            this.OKButton = new JButton("Create Network Seed");
            this.OKButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    String fileloc = CustomSeedDialog.this.createSeedFile();
                    if (fileloc == null) {
                        return;
                    }
                    BNInitDialog.this.networkSeedPanel.seedFileLocField.setText(fileloc);
                    CustomSeedDialog.this.dispose();
                }
            });
            this.cancelButton = new JButton("Cancel");
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    CustomSeedDialog.this.dispose();
                }
            });
            this.currentParentNode = -1;
            this.currentChildNode = -1;
            int numPanels = 0;
            this.currentParentFilled = false;
            this.currentChildFilled = false;
            this.parentNodes = new Vector();
            this.childNodes = new Vector();
            this.constraints = new GridBagConstraints();
            this.gridbag = new GridBagLayout();
            this.setLayout(this.gridbag);
            this.interactionModel = new DefaultListModel();
            this.interactionsList = new JList(this.interactionModel);
            this.nodeButtons = new NodeButtons[this.nodeNames.length];
            numPanels = this.nodeNames.length / 512 + 1;
            JPanel[] panels = new JPanel[numPanels];
            int currPanel = 0;
            for (int i = 0; i < panels.length; ++i) {
                panels[i] = new JPanel(this.gridbag);
            }
            int maxWidth = 0;
            int i = 0;
            int maxNameLength = 0;
            for (i = 0; i < this.nodeNames.length; ++i) {
                String s;
                int currentNameLength;
                this.nodeButtons[i] = new NodeButtons(i);
                if (this.nodeButtons[i].getPreferredSize().getWidth() > (double)maxWidth) {
                    maxWidth = (int)Math.ceil(this.nodeButtons[i].getPreferredSize().getWidth());
                }
                if ((currentNameLength = (s = this.nodeNames[i]).length()) > maxNameLength) {
                    maxNameLength = currentNameLength;
                }
                currPanel = i / 512;
                this.buildConstraints(this.constraints, 0, i % 512, 1, 1, 100, 100);
                this.gridbag.setConstraints(this.nodeButtons[i], this.constraints);
                panels[currPanel].add(this.nodeButtons[i]);
            }
            this.selectedParent = new JTextField("", maxNameLength + 2);
            this.selectedChild = new JTextField("", maxNameLength + 2);
            this.selectedParent.setBackground(Color.white);
            this.selectedChild.setBackground(Color.white);
            this.selectedParent.setEditable(false);
            this.selectedChild.setEditable(false);
            JPanel bigPanel = new JPanel(new GridBagLayout());
            for (int m = 0; m < numPanels; ++m) {
                bigPanel.add((Component)panels[m], new GridBagConstraints(0, m, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            }
            JScrollPane scroll = new JScrollPane(bigPanel);
            scroll.setVerticalScrollBarPolicy(22);
            scroll.getHorizontalScrollBar().setUnitIncrement(20);
            scroll.getVerticalScrollBar().setUnitIncrement(20);
            this.buildConstraints(this.constraints, 0, 1, 1, 1, 40, 100);
            this.constraints.fill = 1;
            this.gridbag.setConstraints(scroll, this.constraints);
            this.add(scroll);
            this.constraints.fill = 0;
            JPanel currentSelectionPanel = new JPanel();
            GridBagLayout grid2 = new GridBagLayout();
            currentSelectionPanel.setLayout(grid2);
            this.removeSelectedParentButton = new JButton("Clear");
            this.removeInteractionButton = new JButton("<< Remove Interaction");
            this.removeSelectedParentButton.setEnabled(false);
            this.removeInteractionButton.setEnabled(false);
            this.removeSelectedParentButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    CustomSeedDialog.this.nodeButtons[CustomSeedDialog.this.currentParentNode].setEnabled(true);
                    CustomSeedDialog.this.currentParentNode = -1;
                    CustomSeedDialog.this.selectedParent.setText("");
                    CustomSeedDialog.this.currentParentFilled = false;
                    CustomSeedDialog.this.removeSelectedParentButton.setEnabled(false);
                }
            });
            this.removeInteractionButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    int index = CustomSeedDialog.this.interactionsList.getSelectedIndex();
                    CustomSeedDialog.this.interactionModel.removeElementAt(index);
                    int removedAIndex = CustomSeedDialog.this.parentNodes.remove(index);
                    int removedBIndex = CustomSeedDialog.this.childNodes.remove(index);
                    CustomSeedDialog.this.nodeButtons[removedAIndex].setEnabled(true);
                    CustomSeedDialog.this.nodeButtons[removedBIndex].setEnabled(true);
                    if (CustomSeedDialog.this.interactionModel.isEmpty()) {
                        CustomSeedDialog.this.removeInteractionButton.setEnabled(false);
                    } else {
                        CustomSeedDialog.this.interactionsList.setSelectedIndex(CustomSeedDialog.this.interactionModel.size() - 1);
                    }
                }
            });
            JScrollPane selectedParentScr = new JScrollPane(this.selectedParent);
            selectedParentScr.setMinimumSize(new Dimension(90, 50));
            JScrollPane currentBScroll = new JScrollPane(this.selectedChild);
            currentBScroll.setMinimumSize(new Dimension(90, 50));
            selectedParentScr.setHorizontalScrollBarPolicy(30);
            selectedParentScr.setVerticalScrollBarPolicy(21);
            selectedParentScr.getHorizontalScrollBar().setUnitIncrement(20);
            selectedParentScr.getVerticalScrollBar().setUnitIncrement(20);
            currentBScroll.setHorizontalScrollBarPolicy(30);
            currentBScroll.setVerticalScrollBarPolicy(21);
            currentBScroll.getHorizontalScrollBar().setUnitIncrement(20);
            currentBScroll.getVerticalScrollBar().setUnitIncrement(20);
            this.buildConstraints(this.constraints, 2, 1, 1, 1, 20, 50);
            grid2.setConstraints(this.removeSelectedParentButton, this.constraints);
            currentSelectionPanel.add(this.removeSelectedParentButton);
            this.instructionsLabel = new JLabel("Select the parent node of an interaction... ");
            this.buildConstraints(this.constraints, 1, 0, 1, 1, 20, 0);
            grid2.setConstraints(this.instructionsLabel, this.constraints);
            currentSelectionPanel.add(this.instructionsLabel);
            JLabel selectedParentLabel = new JLabel(" Selected Parent: ");
            this.buildConstraints(this.constraints, 0, 1, 1, 1, 20, 0);
            grid2.setConstraints(selectedParentLabel, this.constraints);
            currentSelectionPanel.add(selectedParentLabel);
            this.buildConstraints(this.constraints, 1, 1, 1, 1, 60, 0);
            this.constraints.fill = 1;
            grid2.setConstraints(selectedParentScr, this.constraints);
            currentSelectionPanel.add(selectedParentScr);
            this.constraints.fill = 0;
            this.buildConstraints(this.constraints, 0, 0, 1, 1, 10, 0);
            this.gridbag.setConstraints(currentSelectionPanel, this.constraints);
            this.add(currentSelectionPanel);
            this.constraints.fill = 0;
            JPanel pairButtonsPanel = new JPanel();
            GridBagLayout grid3 = new GridBagLayout();
            pairButtonsPanel.setLayout(grid3);
            this.buildConstraints(this.constraints, 0, 1, 1, 1, 0, 50);
            grid3.setConstraints(this.removeInteractionButton, this.constraints);
            pairButtonsPanel.add(this.removeInteractionButton);
            this.buildConstraints(this.constraints, 1, 0, 1, 1, 5, 0);
            this.gridbag.setConstraints(pairButtonsPanel, this.constraints);
            this.add(pairButtonsPanel);
            this.buildConstraints(this.constraints, 1, 1, 1, 1, 45, 0);
            this.constraints.fill = 1;
            JScrollPane pairScroll = new JScrollPane(this.interactionsList);
            pairScroll.setBorder(new TitledBorder("Interactions"));
            this.gridbag.setConstraints(pairScroll, this.constraints);
            this.add(pairScroll);
            this.buildConstraints(this.constraints, 0, 2, 1, 1, 45, 0);
            this.constraints.fill = 0;
            this.gridbag.setConstraints(this.cancelButton, this.constraints);
            this.add(this.cancelButton);
            this.buildConstraints(this.constraints, 1, 2, 1, 1, 45, 0);
            this.constraints.fill = 0;
            this.gridbag.setConstraints(this.OKButton, this.constraints);
            this.add(this.OKButton);
        }

        public boolean display() {
            this.setModal(true);
            this.setVisible(true);
            return this.success;
        }

        void buildConstraints(GridBagConstraints gbc, int gx, int gy, int gw, int gh, int wx, int wy) {
            gbc.gridx = gx;
            gbc.gridy = gy;
            gbc.gridwidth = gw;
            gbc.gridheight = gh;
            gbc.weightx = wx;
            gbc.weighty = wy;
        }

        public void reset() {
            for (int i = 0; i < this.nodeButtons.length; ++i) {
                this.nodeButtons[i].setEnabled(true);
                this.selectedParent.setText("");
                this.selectedChild.setText("");
                this.removeSelectedParentButton.setEnabled(false);
                this.removeInteractionButton.setEnabled(false);
                this.interactionModel.clear();
                this.currentParentFilled = false;
                this.currentChildFilled = false;
                this.currentParentNode = -1;
                this.currentChildNode = -1;
                this.parentNodes.clear();
                this.childNodes.clear();
            }
        }

        private String createSeedFile() {
            JFileChooser fileChooser = new JFileChooser(TMEV.getDataPath());
            if (fileChooser.showSaveDialog(this) == 0) {
                File file = fileChooser.getSelectedFile();
                try {
                    PrintWriter pw = new PrintWriter(new FileWriter(file));
                    for (int i = 0; i < this.parentNodes.size(); ++i) {
                        pw.println(this.nodeNames[this.parentNodes.get(i)] + "\t" + this.nodeNames[this.childNodes.get(i)]);
                        System.out.println(this.nodeNames[this.parentNodes.get(i)] + "\t" + this.nodeNames[this.childNodes.get(i)]);
                    }
                    pw.flush();
                    pw.close();
                    this.success = true;
                    return file.getAbsolutePath();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return null;
        }

        class NodeButtons
        extends JButton {
            private static final long serialVersionUID = 1L;
            String s;
            int index;

            public NodeButtons(int i) {
                this.index = i;
                this.s = CustomSeedDialog.this.nodeNames[i];
                this.setText(this.s);
                this.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        if (CustomSeedDialog.this.currentParentFilled && CustomSeedDialog.this.currentChildFilled) {
                            JOptionPane.showMessageDialog(null, "Please clear at least one current field first.", "Error", 0);
                        } else if (!CustomSeedDialog.this.currentParentFilled) {
                            CustomSeedDialog.this.currentParentNode = NodeButtons.this.index;
                            CustomSeedDialog.this.selectedParent.setText(NodeButtons.this.s);
                            CustomSeedDialog.this.currentParentFilled = true;
                            NodeButtons.this.setEnabled(false);
                            CustomSeedDialog.this.removeSelectedParentButton.setEnabled(true);
                            CustomSeedDialog.this.instructionsLabel.setText("Select the child node of an interaction... ");
                        } else if (!CustomSeedDialog.this.currentChildFilled) {
                            CustomSeedDialog.this.currentChildNode = NodeButtons.this.index;
                            CustomSeedDialog.this.selectedChild.setText(NodeButtons.this.s);
                            CustomSeedDialog.this.currentChildFilled = true;
                            NodeButtons.this.setEnabled(false);
                        }
                        if (CustomSeedDialog.this.currentParentFilled && CustomSeedDialog.this.currentChildFilled) {
                            String currentPair = " Parent: " + CustomSeedDialog.this.nodeNames[CustomSeedDialog.this.currentParentNode] + " -> Child: " + CustomSeedDialog.this.nodeNames[CustomSeedDialog.this.currentChildNode];
                            if (CustomSeedDialog.this.interactionModel.contains(currentPair)) {
                                JOptionPane.showMessageDialog(null, "This interaction has already been loaded.", "Error", 0);
                                CustomSeedDialog.this.nodeButtons[CustomSeedDialog.this.currentChildNode].setEnabled(true);
                                CustomSeedDialog.this.currentChildNode = -1;
                                CustomSeedDialog.this.selectedChild.setText("");
                                CustomSeedDialog.this.currentChildFilled = false;
                                return;
                            }
                            CustomSeedDialog.this.interactionModel.addElement(currentPair);
                            CustomSeedDialog.this.parentNodes.add(new Integer(CustomSeedDialog.this.currentParentNode));
                            CustomSeedDialog.this.childNodes.add(new Integer(CustomSeedDialog.this.currentChildNode));
                            CustomSeedDialog.this.nodeButtons[CustomSeedDialog.this.currentParentNode].setEnabled(true);
                            CustomSeedDialog.this.nodeButtons[CustomSeedDialog.this.currentChildNode].setEnabled(true);
                            CustomSeedDialog.this.currentParentNode = -1;
                            CustomSeedDialog.this.currentChildNode = -1;
                            CustomSeedDialog.this.selectedParent.setText("");
                            CustomSeedDialog.this.selectedChild.setText("");
                            CustomSeedDialog.this.currentParentFilled = false;
                            CustomSeedDialog.this.currentChildFilled = false;
                            CustomSeedDialog.this.removeSelectedParentButton.setEnabled(false);
                            CustomSeedDialog.this.removeInteractionButton.setEnabled(true);
                            CustomSeedDialog.this.interactionsList.setSelectedIndex(CustomSeedDialog.this.interactionModel.size() - 1);
                            CustomSeedDialog.this.instructionsLabel.setText("Select the parent node of an interaction... ");
                        }
                    }
                });
            }
        }
    }

    private class BNParameterPanel
    extends JPanel {
        JTextField converterFileField;
        JList fileList;
        JButton browserButton;
        JTextField minClusterSizeField;
        JComboBox fieldNamesBox;
        JList annFileList;
        Vector annVector;
        JButton removeButton;
        JCheckBox useAnnBox;
        JLabel fileLabel;

        public BNParameterPanel(String[] fieldNames) {
            JPanel convPanel = new JPanel(new GridBagLayout());
            convPanel.setBackground(Color.white);
            convPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Annotation Conversion File", 0, 0, BNInitDialog.this.font, Color.black));
            this.useAnnBox = new JCheckBox("use annotation converter", false);
            this.useAnnBox.setActionCommand("use-converter-command");
            this.useAnnBox.addActionListener(BNInitDialog.this.listener);
            this.useAnnBox.setBackground(Color.white);
            this.useAnnBox.setFocusPainted(false);
            this.useAnnBox.setEnabled(false);
            this.converterFileField = new JTextField(30);
            this.converterFileField.setBorder(BorderFactory.createBevelBorder(1, Color.lightGray, Color.gray));
            this.converterFileField.setEnabled(false);
            this.converterFileField.setBackground(Color.white);
            this.browserButton = new JButton("File Browser");
            this.browserButton.setActionCommand("converter-file-browser-command");
            this.browserButton.setFocusPainted(false);
            this.browserButton.setPreferredSize(new Dimension(150, 25));
            this.browserButton.setSize(150, 25);
            this.browserButton.addActionListener(BNInitDialog.this.listener);
            this.browserButton.setEnabled(false);
            JLabel converterNotAvailableLabel = new JLabel("Annotation conversion is not yet available");
            converterNotAvailableLabel.setForeground(Color.red);
            this.fileLabel = new JLabel("File :");
            this.fileLabel.setEnabled(false);
            convPanel.add((Component)converterNotAvailableLabel, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 13, 3, new Insets(0, 0, 10, 5), 0, 0));
            convPanel.add((Component)this.useAnnBox, new GridBagConstraints(0, 1, 3, 1, 0.0, 0.0, 17, 1, new Insets(0, 15, 15, 0), 0, 0));
            convPanel.add((Component)this.fileLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 15, 15, 0), 0, 0));
            convPanel.add((Component)this.browserButton, new GridBagConstraints(0, 3, 3, 1, 0.0, 0.0, 17, 3, new Insets(0, 15, 0, 0), 0, 0));
            convPanel.add((Component)this.converterFileField, new GridBagConstraints(1, 2, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 15, 15, 0), 0, 0));
            JPanel annPanel = new JPanel(new GridBagLayout());
            annPanel.setBackground(Color.white);
            annPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Gene Annotation / Gene Ontology Linking Files", 0, 0, BNInitDialog.this.font, Color.black));
            JLabel filesLabel = new JLabel("Files: ");
            this.annVector = new Vector();
            this.annFileList = new JList(new DefaultListModel());
            this.annFileList.setCellRenderer(new ListRenderer());
            this.annFileList.setBorder(BorderFactory.createBevelBorder(1));
            JScrollPane annPane = new JScrollPane(this.annFileList);
            JButton annButton = new JButton("Add Files");
            annButton.setActionCommand("ann-file-browser-command");
            annButton.addActionListener(BNInitDialog.this.listener);
            annButton.setFocusPainted(false);
            annButton.setPreferredSize(new Dimension(150, 25));
            annButton.setSize(150, 25);
            this.removeButton = new JButton("Remove Selected");
            this.removeButton.setActionCommand("remove-ann-file-command");
            this.removeButton.addActionListener(BNInitDialog.this.listener);
            this.removeButton.setFocusPainted(false);
            this.removeButton.setPreferredSize(new Dimension(150, 25));
            this.removeButton.setSize(150, 25);
            this.removeButton.setEnabled(false);
            JPanel fillPanel = new JPanel();
            fillPanel.setBackground(Color.white);
            JLabel annPanelNotAvailable = new JLabel("GO Annotation Linking is not yet available.");
            annPanelNotAvailable.setForeground(Color.red);
            annButton.setEnabled(false);
            annPane.setEnabled(false);
            filesLabel.setForeground(Color.gray);
            annPanel.add((Component)annPanelNotAvailable, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            annPanel.add((Component)fillPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            annPanel.add((Component)annButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 13, 3, new Insets(0, 0, 10, 5), 0, 0));
            annPanel.add((Component)this.removeButton, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 3, new Insets(0, 5, 10, 0), 0, 0));
            annPanel.add((Component)filesLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
            annPanel.add((Component)annPane, new GridBagConstraints(1, 2, 2, 1, 0.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            BNInitDialog.this.sep = System.getProperty("file.separator");
            File file = new File(BNInitDialog.this.getBaseFileLocation() + "/Data/Convert/");
            String tempPath = file.getPath();
            Vector<String> fileVector = new Vector<String>();
            this.fileList = new JList(fileVector);
            if (file.exists()) {
                String[] listFileNames = file.list();
                for (int i = 0; i < listFileNames.length; ++i) {
                    File tempFile = new File(tempPath + BNInitDialog.this.sep + listFileNames[i]);
                    if (!tempFile.isFile()) continue;
                    fileVector.add(listFileNames[i]);
                }
                if (fileVector.size() > 0) {
                    this.converterFileField.setText(tempPath + BNInitDialog.this.sep + (String)fileVector.elementAt(0));
                }
            }
            this.minClusterSizeField = new JTextField(5);
            this.minClusterSizeField.setText("5");
            JPanel contentPanel = new JPanel(new GridBagLayout());
            JPanel bnFilePanel = new JPanel(new GridBagLayout());
            this.setLayout(new GridBagLayout());
            this.add((Component)convPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)annPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }

        private void updateFileDirectoryField() {
            File file = new File((String)this.fileList.getSelectedValue());
            if (file == null) {
                return;
            }
            String tempPath = file.getParent();
            int fileIndex = this.fileList.getSelectedIndex();
            String fileName = (String)this.fileList.getModel().getElementAt(this.fileList.getSelectedIndex());
            this.converterFileField.setText(tempPath + BNInitDialog.this.sep + fileName);
        }

        private void updateAnnFileList(File[] files) {
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                if (((DefaultListModel)this.annFileList.getModel()).contains(file)) continue;
                ((DefaultListModel)this.annFileList.getModel()).addElement(file);
            }
            this.annFileList.validate();
        }

        public String getConverterFileName() {
            if (this.useAnnBox.isSelected()) {
                return this.converterFileField.getText();
            }
            return null;
        }

        private void updateConverterFileField(String field) {
            this.converterFileField.setText(field);
        }

        public String[] getAnnToGOFileList() {
            String[] fileNames = new String[((DefaultListModel)this.annFileList.getModel()).size()];
            for (int i = 0; i < fileNames.length; ++i) {
                fileNames[i] = ((File)((DefaultListModel)this.annFileList.getModel()).elementAt(i)).getPath();
            }
            return fileNames;
        }

        public void removeSelectedFiles() {
            int[] indices = this.annFileList.getSelectedIndices();
            for (int i = 0; i < indices.length; ++i) {
                ((DefaultListModel)this.annFileList.getModel()).removeElementAt(indices[i]);
            }
            if (this.annFileList.getModel().getSize() < 1) {
                this.removeButton.setEnabled(false);
                BNInitDialog.this.okButton.setEnabled(false);
            }
            this.annFileList.validate();
        }

        private class ListRenderer
        extends DefaultListCellRenderer {
            private ListRenderer() {
            }

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                File file = (File)value;
                this.setText(file.getName());
                return this;
            }
        }

        private class BNListListener
        implements ListSelectionListener {
            private BNListListener() {
            }

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                BNParameterPanel.this.updateFileDirectoryField();
            }
        }
    }

    private class RunBNPanel
    extends JPanel {
        private JLabel numLabel;
        private JLabel slabel;
        private JLabel scorelabel;
        private JLabel arclabel;
        private JTextField nParents;
        private JLabel foldLabel;
        private JTextField kFolds;
        private JLabel foldWarning;
        String[] sOption;
        JComboBox searchOptionBox;
        String[] scoreOption;
        JComboBox scoreOptionBox;
        String[] arcOption;
        JComboBox arcOptionBox;

        public RunBNPanel() {
            super(new GridBagLayout());
            this.numLabel = new JLabel(" Max Number of Parents:");
            this.slabel = new JLabel("               Search Algorithm");
            this.scorelabel = new JLabel("                Scoring Scheme");
            this.arclabel = new JLabel("              Use Arc Reversal");
            this.nParents = new JTextField("3");
            this.foldLabel = new JLabel("Cross Validation Folds(K):");
            this.kFolds = new JTextField("10");
            this.foldWarning = new JLabel("     (Fold min is 2 & can't be greater than #samples.)");
            this.sOption = new String[]{"K2", "HillClimber", "SimulatedAnnealing", "TabuSearch", "GeneticSearch"};
            this.searchOptionBox = new JComboBox<String>(this.sOption);
            this.scoreOption = new String[]{"BAYES", "BDeu", "ENTROPY", "MDL"};
            this.scoreOptionBox = new JComboBox<String>(this.scoreOption);
            this.arcOption = new String[]{"True", "False"};
            this.arcOptionBox = new JComboBox<String>(this.arcOption);
            int sampleCnt = BNInitDialog.this.framework.getData().getFeaturesCount();
            if (sampleCnt < 10) {
                this.kFolds.setText(String.valueOf(sampleCnt));
            }
            this.foldWarning.setForeground(Color.RED);
            this.setLayout(new GridBagLayout());
            this.setBackground(Color.white);
            this.searchOptionBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    String sa = (String)RunBNPanel.this.searchOptionBox.getSelectedItem();
                    BNInitDialog.this.setAlgorithm(sa);
                }
            });
            this.searchOptionBox.setSelectedIndex(3);
            this.scoreOptionBox.setSelectedIndex(0);
            this.scoreOptionBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    String st = (String)RunBNPanel.this.scoreOptionBox.getSelectedItem();
                    BNInitDialog.this.setScoreType(st);
                }
            });
            this.arcOptionBox.setSelectedIndex(0);
            this.arcOptionBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    boolean at = (Boolean)RunBNPanel.this.arcOptionBox.getSelectedItem();
                    BNInitDialog.this.setUseArcRev(at);
                }
            });
            this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Running Bayesian Network Parameters ", 0, 0, BNInitDialog.this.font, Color.black));
            this.add((Component)this.slabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 0, 0, 0), 0, 0));
            this.add((Component)this.searchOptionBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 1, new Insets(5, 10, 0, 0), 0, 0));
            this.add((Component)this.scorelabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 0, 0, 0), 0, 0));
            this.add((Component)this.scoreOptionBox, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 13, 1, new Insets(5, 10, 0, 0), 0, 0));
            this.add((Component)this.arclabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 0, 0, 0), 0, 0));
            this.add((Component)this.arcOptionBox, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 13, 1, new Insets(5, 10, 0, 0), 0, 0));
            this.add((Component)this.numLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 0, 0, 0), 0, 0));
            this.add((Component)this.nParents, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 13, 1, new Insets(5, 10, 0, 0), 0, 0));
            this.add((Component)this.foldLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 0, 0, 0), 0, 0));
            this.add((Component)this.kFolds, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 13, 1, new Insets(5, 10, 0, 0), 0, 0));
            this.add((Component)this.foldWarning, new GridBagConstraints(0, 5, 2, 1, 0.0, 0.0, 13, 1, new Insets(5, 0, 0, 0), 0, 0));
        }

        public String numParents() {
            return this.nParents.getText();
        }

        public String kFolds() {
            return this.kFolds.getText();
        }
    }

    private class XmlBifPanel
    extends JPanel {
        private JRadioButton useGoButton;
        private JRadioButton useDFSButton;
        private ButtonGroup bGroup;

        public XmlBifPanel() {
            super(new GridBagLayout());
            this.setLayout(new GridBagLayout());
            this.setBackground(Color.white);
            this.useGoButton = new JRadioButton("Use GO Terms to direct edges");
            this.useGoButton.setHorizontalAlignment(0);
            this.useGoButton.setBackground(Color.white);
            this.useDFSButton = new JRadioButton("Use Depth-First Search to direct edges", true);
            this.useDFSButton.setHorizontalAlignment(0);
            this.useDFSButton.setBackground(Color.white);
            this.useGoButton.setEnabled(false);
            this.bGroup = new ButtonGroup();
            this.bGroup.add(this.useGoButton);
            this.bGroup.add(this.useDFSButton);
            this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "How to direct edges for graph", 0, 0, BNInitDialog.this.font, Color.black));
            this.add((Component)this.useDFSButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.useGoButton, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 50), 0, 0));
        }

        public boolean useGoTerms() {
            return this.useGoButton.isEnabled();
        }
    }

    private class BootStrapPanel
    extends JPanel {
        private JTextField numIterationsField;
        private JLabel numIterationsLabel;
        private JTextField confThresholdField;
        private JLabel confThresholdLabel;
        private JCheckBox isBootstrappingCheckbox;
        private JLabel isBootStrappingLabel;

        public BootStrapPanel() {
            super(new GridBagLayout());
            this.setLayout(new GridBagLayout());
            this.setBackground(Color.white);
            this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Bootstrapping Parameters", 0, 0, BNInitDialog.this.font, Color.black));
            this.isBootstrappingCheckbox = new JCheckBox("Bootstrapping");
            this.isBootstrappingCheckbox.setSelected(true);
            this.isBootstrappingCheckbox.setEnabled(true);
            this.isBootstrappingCheckbox.setBackground(Color.white);
            this.isBootstrappingCheckbox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    BNInitDialog.this.bootStrapPanel.setEnableControls(BootStrapPanel.this.isBootstrappingCheckbox.isSelected());
                }
            });
            this.numIterationsField = new JTextField("20", 3);
            this.numIterationsField.setBackground(Color.white);
            this.numIterationsLabel = new JLabel(" Number of Iterations");
            this.numIterationsLabel.setBackground(Color.white);
            this.confThresholdField = new JTextField("0.7", 3);
            this.confThresholdField.setBackground(Color.white);
            this.confThresholdLabel = new JLabel(" Confidence Threshold");
            this.confThresholdLabel.setBackground(Color.white);
            this.isBootstrappingCheckbox.setEnabled(true);
            this.numIterationsField.setEnabled(true);
            this.confThresholdField.setEnabled(true);
            this.add((Component)this.isBootstrappingCheckbox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 1, new Insets(0, 0, 0, 50), 0, 0));
            this.add((Component)this.numIterationsLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(4, 0, 0, 15), 0, 0));
            this.add((Component)this.numIterationsField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(4, 0, 0, 50), 0, 0));
            this.add((Component)this.confThresholdLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(4, 0, 0, 15), 0, 0));
            this.add((Component)this.confThresholdField, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(4, 0, 4, 50), 0, 0));
        }

        public void setEnableControls(boolean enableControls) {
            this.numIterationsField.setEnabled(enableControls);
            this.confThresholdField.setEnabled(enableControls);
        }

        public int getNumIterations() {
            return new Integer(this.numIterationsField.getText());
        }

        public float getConfThreshold() {
            return new Float(this.confThresholdField.getText()).floatValue();
        }

        public boolean isBootstrapping() {
            return this.isBootstrappingCheckbox.isSelected();
        }
    }

    private class ClassNumPanel
    extends JPanel {
        private JTextField numClassesField;
        private JLabel numClassesLabel;

        public ClassNumPanel() {
            super(new GridBagLayout());
            this.setLayout(new GridBagLayout());
            this.setBackground(Color.white);
            this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Sample Classification", 0, 0, BNInitDialog.this.font, Color.black));
            this.numClassesField = new JTextField("1", 2);
            this.numClassesField.setBackground(Color.white);
            this.numClassesLabel = new JLabel(" Number of Sample Classes");
            this.numClassesLabel.setBackground(Color.white);
            this.numClassesField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                }
            });
            this.add((Component)this.numClassesLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 13, 1, new Insets(4, 8, 0, 0), 0, 0));
            this.add((Component)this.numClassesField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(4, 7, 4, 26), 0, 0));
        }

        public int getNumClasses() {
            return new Integer(this.numClassesField.getText());
        }
    }

    private class DiscretizingPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private JTextField numLevelsField;
        private JLabel numLevelsLabel;

        public DiscretizingPanel() {
            super(new GridBagLayout());
            this.setLayout(new GridBagLayout());
            this.setBackground(Color.white);
            this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Discretize Expression Values", 0, 0, BNInitDialog.this.font, Color.black));
            this.numLevelsField = new JTextField("3", 2);
            this.numLevelsField.setBackground(Color.white);
            this.numLevelsLabel = new JLabel(" Number of States");
            this.numLevelsLabel.setBackground(Color.white);
            this.numLevelsField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                }
            });
            this.add((Component)this.numLevelsLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 13, 1, new Insets(4, 15, 0, 40), 0, 0));
            this.add((Component)this.numLevelsField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(4, 15, 4, 25), 0, 0));
        }

        public int getNumLevels() {
            return new Integer(this.numLevelsField.getText());
        }

        static /* synthetic */ JTextField access$3000(DiscretizingPanel x0) {
            return x0.numLevelsField;
        }
    }

    private class NetworkSeedPanel
    extends ParameterPanel {
        private JCheckBox netSeedCheckbox;
        private JComboBox netSeedComboUID;
        private JButton uploadSeedButton;
        private JButton createSeedButton;
        private JButton cancelCreatedSeed;
        private JTextField seedFileLocField;
        private JLabel loadedLabel;
        private ButtonGroup priorsGroup;
        private JRadioButton usePriorsRadio;
        private JRadioButton noPriorsRadio;
        private JRadioButton onlyCptRadio;
        private String netSeedUID;
        private String[] netSeedUIDList;

        public NetworkSeedPanel() {
            super("Network Seed");
            this.loadedLabel = new JLabel("");
            String[] stringArray = new String[4];
            stringArray[0] = "Select Seed UID";
            stringArray[1] = "PROBE_ID";
            stringArray[2] = "GENBANK_ACC";
            stringArray[3] = "GENE_SYMBOL";
            this.netSeedUIDList = stringArray;
            this.setLayout(new GridBagLayout());
            this.netSeedCheckbox = new JCheckBox("Use Custom Network Seed", false);
            this.netSeedCheckbox.setFocusPainted(false);
            this.netSeedCheckbox.setBackground(Color.white);
            this.netSeedCheckbox.setHorizontalAlignment(0);
            this.netSeedCheckbox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent ie) {
                    Enumeration<AbstractButton> e;
                    if (ie.getStateChange() == 1) {
                        NetworkSeedPanel.this.seedFileLocField.setEnabled(true);
                        NetworkSeedPanel.this.netSeedComboUID.setEnabled(true);
                        NetworkSeedPanel.this.setLoadingSeedsButtons();
                        NetworkSeedPanel.this.loadedLabel.setEnabled(true);
                        NetworkSeedPanel.this.loadedLabel.setForeground(Color.red);
                        e = NetworkSeedPanel.this.priorsGroup.getElements();
                        while (e.hasMoreElements()) {
                            ((JRadioButton)e.nextElement()).setEnabled(true);
                        }
                        if (NetworkSeedPanel.this.usePriorsRadio.isSelected()) {
                            BNInitDialog.this.priorsPanel.keggSourceCheckbox.setEnabled(true);
                            BNInitDialog.this.priorsPanel.litSourceCheckbox.setEnabled(true);
                            BNInitDialog.this.priorsPanel.ppiSourceCheckbox.setEnabled(true);
                        } else {
                            BNInitDialog.this.priorsPanel.keggSourceCheckbox.setEnabled(false);
                            BNInitDialog.this.priorsPanel.litSourceCheckbox.setEnabled(false);
                            BNInitDialog.this.priorsPanel.ppiSourceCheckbox.setEnabled(false);
                        }
                    }
                    if (ie.getStateChange() == 2) {
                        NetworkSeedPanel.this.uploadSeedButton.setEnabled(false);
                        NetworkSeedPanel.this.seedFileLocField.setEnabled(false);
                        NetworkSeedPanel.this.netSeedComboUID.setEnabled(false);
                        NetworkSeedPanel.this.cancelCreatedSeed.setEnabled(false);
                        NetworkSeedPanel.this.createSeedButton.setEnabled(false);
                        NetworkSeedPanel.this.loadedLabel.setEnabled(false);
                        e = NetworkSeedPanel.this.priorsGroup.getElements();
                        while (e.hasMoreElements()) {
                            ((JRadioButton)e.nextElement()).setEnabled(false);
                        }
                        BNInitDialog.this.priorsPanel.keggSourceCheckbox.setEnabled(true);
                        BNInitDialog.this.priorsPanel.litSourceCheckbox.setEnabled(true);
                        BNInitDialog.this.priorsPanel.ppiSourceCheckbox.setEnabled(true);
                    }
                }
            });
            this.netSeedComboUID = new JComboBox<String>(this.netSeedUIDList);
            this.netSeedComboUID.setEnabled(false);
            this.netSeedUID = this.netSeedUIDList[0];
            this.netSeedComboUID.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    NetworkSeedPanel.this.netSeedUID = (String)((JComboBox)ae.getSource()).getSelectedItem();
                    NetworkSeedPanel.this.setLoadingSeedsButtons();
                }
            });
            this.seedFileLocField = new JTextField(200);
            this.seedFileLocField.setEnabled(false);
            this.seedFileLocField.setPreferredSize(new Dimension(200, this.seedFileLocField.getHeight()));
            this.seedFileLocField.setEditable(false);
            this.uploadSeedButton = new JButton("Upload");
            this.uploadSeedButton.setEnabled(false);
            this.uploadSeedButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    String startDir = NetworkSeedPanel.this.seedFileLocField.getText();
                    File file = new File(startDir);
                    if (!file.exists()) {
                        file = new File(TMEV.getDataPath());
                    }
                    JFileChooser chooser = new JFileChooser(file);
                    chooser.setFileSelectionMode(0);
                    if (chooser.showOpenDialog(BNInitDialog.this) == 0) {
                        String dir = chooser.getSelectedFile().getAbsolutePath().trim();
                        NetworkSeedPanel.this.seedFileLocField.setText(chooser.getSelectedFile().getAbsolutePath());
                        System.out.println("Net Seed Loc Prop" + NetworkSeedPanel.this.seedFileLocField.getText());
                        System.out.println("Net Seed Loc " + NetworkSeedPanel.this.seedFileLocField.getText());
                        TMEV.storeProperty((String)"bn_net_seed_loc_prop", (String)NetworkSeedPanel.this.seedFileLocField.getText());
                        NetworkSeedPanel.this.loadedLabel.setText("File Loaded");
                    }
                }
            });
            this.createSeedButton = new JButton("Create Network Seed");
            this.createSeedButton.setEnabled(false);
            this.createSeedButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    if (BNInitDialog.this.cr == null || BNInitDialog.this.cr.isEmpty()) {
                        JOptionPane.showMessageDialog(BNInitDialog.this.parent, "Please create and choose a cluster from which to draw seeds.", "Cluster Not Selected", 2);
                        return;
                    }
                    String[] exptNames = new String[BNInitDialog.this.getSelectedCluster().getSize()];
                    exptNames = BNInitDialog.this.framework.getData().getAnnotationList(NetworkSeedPanel.this.netSeedUID, BNInitDialog.this.getSelectedCluster().getIndices());
                    BNInitDialog.this.customSeedDialog = new CustomSeedDialog(exptNames);
                    if (BNInitDialog.this.customSeedDialog.display()) {
                        BNInitDialog.this.useCreated = true;
                        NetworkSeedPanel.this.loadedLabel.setText("File Loaded");
                    }
                }
            });
            this.cancelCreatedSeed = new JButton("Remove Created Network Seed");
            this.cancelCreatedSeed.setEnabled(false);
            this.cancelCreatedSeed.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    BNInitDialog.this.useCreated = false;
                    NetworkSeedPanel.this.cancelCreatedSeed.setEnabled(false);
                    NetworkSeedPanel.this.createSeedButton.setEnabled(true);
                }
            });
            this.usePriorsRadio = new JRadioButton("With LM Priors");
            this.usePriorsRadio.setBackground(Color.white);
            this.usePriorsRadio.setEnabled(false);
            this.usePriorsRadio.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent ie) {
                    if (ie.getStateChange() == 1) {
                        NetworkSeedPanel.this.toggleState(BNInitDialog.this.priorsPanel, true);
                        NetworkSeedPanel.this.toggleState(BNInitDialog.this.bootStrapPanel, true);
                    }
                }
            });
            this.noPriorsRadio = new JRadioButton("Without LM Priors", true);
            this.noPriorsRadio.setBackground(Color.white);
            this.noPriorsRadio.setEnabled(false);
            this.noPriorsRadio.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent ie) {
                    if (ie.getStateChange() == 1) {
                        NetworkSeedPanel.this.toggleState(BNInitDialog.this.priorsPanel, false);
                        NetworkSeedPanel.this.toggleState(BNInitDialog.this.bootStrapPanel, true);
                    }
                }
            });
            this.onlyCptRadio = new JRadioButton("Learn CPT only", true);
            this.onlyCptRadio.setBackground(Color.white);
            this.onlyCptRadio.setEnabled(false);
            this.onlyCptRadio.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent ie) {
                    if (ie.getStateChange() == 1) {
                        NetworkSeedPanel.this.toggleState(BNInitDialog.this.priorsPanel, false);
                        BNInitDialog.this.bootStrapPanel.isBootstrappingCheckbox.setSelected(false);
                        NetworkSeedPanel.this.toggleState(BNInitDialog.this.bootStrapPanel, false);
                    }
                }
            });
            this.priorsGroup = new ButtonGroup();
            this.priorsGroup.add(this.usePriorsRadio);
            this.priorsGroup.add(this.noPriorsRadio);
            this.priorsGroup.add(this.onlyCptRadio);
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 2;
            c.gridx = 0;
            c.gridy = 0;
            c.gridwidth = 1;
            c.insets = new Insets(0, 18, 4, 5);
            c.weightx = 1.0;
            this.add((Component)this.netSeedCheckbox, c);
            c.fill = 2;
            c.gridx = 1;
            c.gridy = 0;
            c.gridwidth = 1;
            c.insets = new Insets(0, 5, 4, 5);
            c.weightx = 1.0;
            this.add((Component)this.usePriorsRadio, c);
            c.fill = 2;
            c.gridx = 2;
            c.gridy = 0;
            c.gridwidth = 1;
            c.insets = new Insets(0, 5, 4, 5);
            c.weightx = 1.0;
            this.add((Component)this.noPriorsRadio, c);
            c.fill = 2;
            c.gridx = 3;
            c.gridy = 0;
            c.gridwidth = 1;
            c.insets = new Insets(0, 5, 4, 0);
            c.weightx = 1.0;
            this.add((Component)this.onlyCptRadio, c);
            c.fill = 2;
            c.gridx = 0;
            c.gridy = 1;
            c.gridwidth = 1;
            c.insets = new Insets(0, 18, 4, 5);
            c.weightx = 1.0;
            this.add((Component)this.netSeedComboUID, c);
            c.fill = 2;
            c.gridx = 1;
            c.gridy = 1;
            c.gridwidth = 1;
            c.insets = new Insets(0, 5, 4, 5);
            c.weightx = 1.0;
            this.add((Component)this.uploadSeedButton, c);
            c.fill = 2;
            c.gridx = 2;
            c.gridy = 1;
            c.gridwidth = 1;
            c.insets = new Insets(0, 5, 4, 5);
            c.weightx = 1.0;
            this.add((Component)this.createSeedButton, c);
            c.fill = 1;
            c.gridx = 3;
            c.gridy = 1;
            c.gridwidth = 1;
            c.insets = new Insets(0, 5, 4, 0);
            c.weightx = 1.0;
            this.add((Component)this.seedFileLocField, c);
            c.fill = 2;
            c.gridx = 4;
            c.gridy = 1;
            c.gridwidth = 1;
            c.insets = new Insets(0, 5, 4, 5);
            c.weightx = 1.0;
            this.add((Component)this.loadedLabel, c);
        }

        protected void setLoadingSeedsButtons() {
            if (BNInitDialog.this.networkSeedPanel.netSeedComboUID.getSelectedIndex() != 0) {
                BNInitDialog.this.networkSeedPanel.createSeedButton.setEnabled(true);
                BNInitDialog.this.networkSeedPanel.uploadSeedButton.setEnabled(true);
            } else {
                BNInitDialog.this.networkSeedPanel.createSeedButton.setEnabled(false);
                BNInitDialog.this.networkSeedPanel.uploadSeedButton.setEnabled(false);
            }
        }

        protected void toggleState(Container item, boolean state) {
            Component[] cmp = item.getComponents();
            for (int i = 0; i < cmp.length; ++i) {
                cmp[i].setEnabled(state);
            }
        }
    }

    private class PriorSelectionPanel
    extends JPanel {
        private JCheckBox litSourceCheckbox;
        private JCheckBox ppiSourceCheckbox;
        private JCheckBox keggSourceCheckbox;

        public PriorSelectionPanel(boolean haveClusters) {
            super(new GridBagLayout());
            this.setLayout(new GridBagLayout());
            this.setBackground(Color.white);
            this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Network Priors Sources", 0, 0, BNInitDialog.this.font, Color.black));
            this.litSourceCheckbox = new JCheckBox("Literature Mining", true);
            this.litSourceCheckbox.setFocusPainted(false);
            this.litSourceCheckbox.setBackground(Color.white);
            this.litSourceCheckbox.setHorizontalAlignment(0);
            this.litSourceCheckbox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                }
            });
            this.ppiSourceCheckbox = new JCheckBox("Protein-Protein Interactions");
            this.ppiSourceCheckbox.setToolTipText("Uses protein-protein interaction data to create a seed network.");
            this.ppiSourceCheckbox.setFocusPainted(false);
            this.ppiSourceCheckbox.setBackground(Color.white);
            this.ppiSourceCheckbox.setHorizontalAlignment(0);
            this.ppiSourceCheckbox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                }
            });
            this.keggSourceCheckbox = new JCheckBox("KEGG Interactions");
            this.keggSourceCheckbox.setToolTipText("Uses KEGG pathway interactions to create a seed network.");
            this.keggSourceCheckbox.setFocusPainted(false);
            this.keggSourceCheckbox.setBackground(Color.white);
            this.keggSourceCheckbox.setHorizontalAlignment(0);
            this.keggSourceCheckbox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                }
            });
            this.ppiSourceCheckbox.setSelected(false);
            this.ppiSourceCheckbox.setEnabled(true);
            this.litSourceCheckbox.setEnabled(true);
            this.keggSourceCheckbox.setEnabled(true);
            this.add((Component)this.litSourceCheckbox, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 95), 0, 0));
            this.add((Component)this.keggSourceCheckbox, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 91), 0, 0));
            this.add((Component)this.ppiSourceCheckbox, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 4, 35), 0, 0));
        }
    }
}

