/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.bn;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.tree.DefaultMutableTreeNode;
import org.systemsbiology.gaggle.core.datatypes.Interaction;
import org.systemsbiology.gaggle.core.datatypes.Network;
import org.tigr.microarray.mev.HistoryViewer;
import org.tigr.microarray.mev.annotation.IAnnotation;
import org.tigr.microarray.mev.annotation.MevAnnotation;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.clusterUtil.Cluster;
import org.tigr.microarray.mev.cluster.clusterUtil.ClusterRepository;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IClusterGUI;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.LeafInfo;
import org.tigr.microarray.mev.cluster.gui.impl.bn.BNClassificationEditor;
import org.tigr.microarray.mev.cluster.gui.impl.bn.BNConstants;
import org.tigr.microarray.mev.cluster.gui.impl.bn.BNInitDialog;
import org.tigr.microarray.mev.cluster.gui.impl.bn.BNSupportDataFile;
import org.tigr.microarray.mev.cluster.gui.impl.bn.CytoscapeWebstart;
import org.tigr.microarray.mev.cluster.gui.impl.bn.FromWekaToSif;
import org.tigr.microarray.mev.cluster.gui.impl.bn.LMBNViewer;
import org.tigr.microarray.mev.cluster.gui.impl.bn.NotDAGException;
import org.tigr.microarray.mev.cluster.gui.impl.bn.NullArgumentException;
import org.tigr.microarray.mev.cluster.gui.impl.bn.OutOfRangeException;
import org.tigr.microarray.mev.cluster.gui.impl.bn.PrepareArrayDataModule;
import org.tigr.microarray.mev.cluster.gui.impl.bn.SimpleGeneEdge;
import org.tigr.microarray.mev.cluster.gui.impl.bn.Useful;
import org.tigr.microarray.mev.cluster.gui.impl.bn.UsefulInteractions;
import org.tigr.microarray.mev.cluster.gui.impl.bn.algs.Cyclic;
import org.tigr.microarray.mev.cluster.gui.impl.bn.getInteractions.GetInteractionsModule;
import org.tigr.microarray.mev.cluster.gui.impl.bn.prepareXMLBif.PrepareXMLBifModule;
import org.tigr.microarray.mev.cluster.gui.impl.bn.prepareXMLBif.SifToXMLBif;
import org.tigr.microarray.mev.cluster.gui.impl.lm.LMGUI;
import org.tigr.microarray.mev.resources.PipelinedAnnotationsFileDefinition;
import org.tigr.microarray.mev.resources.SupportFileAccessError;
import org.xml.sax.SAXException;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.classifiers.bayes.BayesNet;

public class BNGUI
implements IClusterGUI,
ActionListener {
    protected HashMap<String, String> probeIndexAssocHash = new HashMap();
    protected HistoryViewer wekaOutputViewer;
    protected LMBNViewer fileViewer;
    protected LMBNViewer badNetSeedViewer;
    protected IData data;
    protected IFramework framework;
    private JDialog resultFrame;
    private JFrame mainFrame;
    private JCheckBox finalThreshBox;
    private JTextField confThreshField;
    private JButton updateNetwork;
    private String basePath;
    private String tmpPath;
    private String resultPath;
    private String evalStr = null;
    private String XmlBifStr = null;
    private String[] evalStrs = null;
    private String[] XmlBifStrs = null;
    private Vector<String> networkFiles = new Vector();
    private String bootNetFile = null;
    private Vector<String> interactionsfinal = null;
    private String finalBootFile = null;
    private ArrayList<SimpleGeneEdge> networkSeedEdgeList;
    private ArrayList<String> unMappedNetworkSeedEdgeList = null;
    private ProgressMonitor pbar;
    private Timer pBarTimer = null;
    private int counter = 0;
    private String pBarMsg = "Bn Module Initializing";
    private File labelFile;
    private BNClassificationEditor.BNClassTableModel kModel;
    private boolean isBootstraping;
    private int numIterations;
    private String numBin;
    private int numStates;
    private String sType;
    private String sAlgorithm;
    private String numParents;
    private int kfold;
    private boolean useArc;
    private int numClasses;
    private float confThreshold;
    private static boolean cancel = false;

    public DefaultMutableTreeNode execute(IFramework framework) throws AlgorithmException {
        DefaultMutableTreeNode node;
        this.framework = framework;
        this.mainFrame = (JFrame)framework.getFrame();
        this.data = framework.getData();
        Experiment exp = this.data.getExperiment();
        ClusterRepository repository = framework.getClusterRepository(0);
        String chipType = null;
        String species = null;
        Vector<BNSupportDataFile> defs = new Vector<BNSupportDataFile>();
        BNSupportDataFile bnSuppFileHandle = null;
        if (!framework.getData().isAnnotationLoaded()) {
            if (chipType == null || species == null) {
                JOptionPane.showMessageDialog(framework.getFrame(), "Organism and/or Array information unavailable", "Aborting execution...", 0);
                return null;
            }
            JOptionPane.showMessageDialog(framework.getFrame(), "Annotation unavailable", "Aborting execution...", 0);
            return null;
        }
        chipType = framework.getData().getChipAnnotation().getChipType();
        species = framework.getData().getChipAnnotation().getSpeciesName();
        bnSuppFileHandle = new BNSupportDataFile(species, chipType);
        defs.add(bnSuppFileHandle);
        Hashtable speciestoarrays = null;
        PipelinedAnnotationsFileDefinition aafd = new PipelinedAnnotationsFileDefinition();
        defs.add((BNSupportDataFile)aafd);
        try {
            Hashtable supportFiles = framework.getSupportFiles(defs, true);
            File speciesarraymapping = (File)supportFiles.get(aafd);
            speciestoarrays = aafd.parseAnnotationListFile(speciesarraymapping);
        }
        catch (SupportFileAccessError sfae) {
            sfae.printStackTrace();
            return null;
        }
        catch (IOException ioe) {
            speciestoarrays = null;
            ioe.printStackTrace();
            return null;
        }
        BNInitDialog dialog = new BNInitDialog(framework, repository, framework.getData().getFieldNames(), framework.getResourceManager(), species, chipType, speciestoarrays);
        if (dialog.showModal() != 0) {
            return null;
        }
        if (dialog.isNone()) {
            return null;
        }
        if (dialog.getSelectedCluster().getIndices().length > 250) {
            JOptionPane.showMessageDialog(framework.getFrame(), "Cluster size exceeds max gene limit of 250. Please reduce cluster size.", "Error!", 0);
            LMGUI.done = false;
            return null;
        }
        BNClassificationEditor bnEditor = new BNClassificationEditor(framework, false, dialog.getNumberClass(), dialog.getBaseFileLocation());
        if (dialog.getNumberClass() > 1 && bnEditor.showModal(true) != 0) {
            return null;
        }
        this.labelFile = bnEditor.getLabelFile();
        this.kModel = bnEditor.getClassTableModel();
        this.basePath = dialog.getBaseFileLocation();
        this.tmpPath = this.basePath + BNConstants.SEP + "tmp" + BNConstants.SEP;
        this.resultPath = this.basePath + BNConstants.SEP + "results" + BNConstants.SEP;
        this.isBootstraping = dialog.isBootstrapping();
        this.numIterations = dialog.getNumIterations();
        this.numBin = String.valueOf(dialog.getNumberBin());
        this.numStates = dialog.getNumberBin();
        this.sType = dialog.getScoreType();
        this.sAlgorithm = dialog.getAlgorithm();
        this.numParents = dialog.numParents();
        this.kfold = dialog.getKFolds();
        this.useArc = dialog.useArcRev();
        this.numClasses = dialog.getNumberClass();
        this.confThreshold = dialog.getConfThreshold();
        bnEditor.dispose();
        this.pBarInit("Bayesian Network search", "Initializing . . .");
        try {
            Thread.sleep(900L);
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        try {
            this.updatePBarProgress("Checking tmp folder", this.counter + 5);
            Useful.cleanUpDir(this.tmpPath);
            this.updatePBarProgress("Mapping Genes to UID", this.counter + 10);
            this.probeIndexAssocHash = Useful.converter(dialog.getSelectedCluster(), framework, dialog.getBaseFileLocation());
            if (cancel) {
                return null;
            }
            if (this.probeIndexAssocHash == null) {
                throw new Exception("Error in mapping Unique identifiers to Accession");
            }
            if (this.probeIndexAssocHash.size() == 0) {
                throw new Exception("Error in mapping Unique identifiers to Accession");
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(framework.getFrame(), e.getMessage(), "Error!", 0);
            LMGUI.done = false;
            this.disposePBar();
            return null;
        }
        this.updatePBarCounter(this.counter + 10);
        try {
            if (dialog.useNetworkSeed() && (dialog.useNetworkSeedWithoutPrior() || dialog.useNetworkSeedForCptOnly() || dialog.useNetworkSeedWithPrior())) {
                this.updatePBarMsg("Mapping and validating Network seed");
                this.updatePBarCounter(this.counter + 10);
                ArrayList<String> netEdges = this.loadNetSeedFile(dialog.getNetSeedUID(), dialog.getNetSeedFileLoc());
                System.out.println("Netseed file loaded");
                this.networkSeedEdgeList = this.mapNetSeedEdgesToSimpleEdges(dialog.getNetSeedUID(), netEdges, dialog.getSelectedCluster().getIndices());
                System.out.println("Netseed interactions mapped and validated");
                System.out.println(this.networkSeedEdgeList.size() + " Netseed edges mapped");
                System.out.println(this.unMappedNetworkSeedEdgeList.size() + " Netseed edges un-mapped");
                if (Cyclic.isCyclic(this.networkSeedEdgeList)) {
                    throw new NotDAGException("Cycles detected in the loaded network!\n" + dialog.getNetSeedFileLoc());
                }
                String propFile = this.tmpPath + "prepareXMLBifMod.props";
                Useful.createXmlBifPropFile(propFile, this.numClasses, this.numStates);
            }
            if (cancel) {
                return null;
            }
            if (dialog.useNetworkSeedWithoutPrior()) {
                System.out.println("<-------- Net witn Net seed Only ------->");
                this.do_NetworkSeedWithoutPrior(dialog.getSelectedCluster(), false);
                if (cancel) {
                    return null;
                }
            } else if (dialog.useNetworkSeedForCptOnly()) {
                System.out.println("<-------- Net For CPT Only ------->");
                System.out.println("CPT only status true");
                this.do_NetworkSeedWithoutPrior(dialog.getSelectedCluster(), true);
                if (cancel) {
                    return null;
                }
            } else {
                this.updatePBarMsg("Initiating Literature Search");
                ArrayList<SimpleGeneEdge> interactions = this.do_lit_miningNetwork(dialog);
                if (dialog.useNetworkSeedWithPrior()) {
                    System.out.println("<-------- Net seed With Priors ------->");
                    this.pbar.setMaximum(this.pbar.getMaximum() + 15);
                    this.do_NetworkSeedWithPrior(interactions);
                    if (cancel) {
                        return null;
                    }
                } else {
                    System.out.println("<-------- Net With Priors ------->");
                    this.pbar.setProgress(3);
                    this.pbar.setNote("Generating Priors");
                    this.prepareXMLBifFile(dialog.getBaseFileLocation());
                    if (cancel) {
                        return null;
                    }
                }
                this.updatePBarCounter(this.counter + 2);
                this.updatePBarProgress("Network Search", this.counter + 10);
                this.onOk(dialog.getSelectedCluster(), this.labelFile, this.kModel, this.isBootstraping, this.numBin, this.numClasses, this.sType, this.sAlgorithm, this.numParents, this.kfold, this.useArc, this.numIterations, this.confThreshold);
                if (cancel) {
                    return null;
                }
                this.updatePBarProgress("Creating Viewers", this.counter + 5);
            }
        }
        catch (OutOfMemoryError ofm) {
            this.disposePBar();
            System.out.println("Out of Memory. Aborting...");
            JOptionPane.showMessageDialog(framework.getFrame(), ofm.getMessage() + "\n Out of Memory", "Error - Out of Memory. Aborting!", 0);
            return null;
        }
        catch (NullArgumentException e) {
            this.disposePBar();
            JOptionPane.showMessageDialog(framework.getFrame(), e.getMessage(), "Bad Arg(s). Aborting!", 0);
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            this.disposePBar();
            JOptionPane.showMessageDialog(framework.getFrame(), e.getMessage(), "IO Error. Aborting!", 0);
            e.printStackTrace();
            return null;
        }
        catch (InterruptedException e) {
            this.disposePBar();
            JOptionPane.showMessageDialog(framework.getFrame(), e.getMessage(), "Error, Aborting!", 0);
            e.printStackTrace();
            return null;
        }
        catch (SAXException e) {
            this.disposePBar();
            JOptionPane.showMessageDialog(framework.getFrame(), "Error processing Weka Bif DOM", "XML parsing Error", 0);
            e.printStackTrace();
            return null;
        }
        catch (Exception e) {
            this.disposePBar();
            JOptionPane.showMessageDialog(framework.getFrame(), e.getMessage(), "Error, Aborting!", 0);
            e.printStackTrace();
            return null;
        }
        this.wekaOutputViewer = new HistoryViewer();
        this.wekaOutputViewer.addHistory(this.evalStr);
        GeneralInfo info = new GeneralInfo();
        if (dialog.isPPI()) {
            info.prior = "PPI";
        }
        if (dialog.isLit()) {
            info.prior = "Literature Mining";
        }
        if (dialog.isKEGG()) {
            info.prior = "KEGG";
        }
        if (dialog.isBoth()) {
            info.prior = "LM & PPI";
        }
        if (dialog.isLitAndKegg()) {
            info.prior = "LM & KEGG";
        }
        if (dialog.isPpiAndKegg()) {
            info.prior = "PPI & KEGG";
        }
        if (dialog.isAll()) {
            info.prior = "LM, PPI & KEGG";
        }
        if (dialog.useGoTerm()) {
            info.useGoTerms = "Use GO Terms";
        }
        info.algorithm = dialog.getAlgorithm();
        info.numBin = dialog.getNumberBin();
        info.numClass = dialog.getNumberClass();
        info.numParents = dialog.numParents();
        info.numGene = dialog.getSelectedCluster().getIndices().length;
        info.kFolds = dialog.getKFolds();
        info.score = dialog.getScoreType();
        this.fileViewer = this.createLMBNViewer(this.networkFiles);
        if (this.unMappedNetworkSeedEdgeList != null && this.unMappedNetworkSeedEdgeList.size() > 0) {
            this.badNetSeedViewer = new LMBNViewer(this.unMappedNetworkSeedEdgeList);
            node = this.createResultTree(exp, this.fileViewer, this.badNetSeedViewer, this.wekaOutputViewer, info);
        } else {
            node = this.createResultTree(exp, this.fileViewer, this.wekaOutputViewer, info);
        }
        this.disposePBar();
        return node;
    }

    ArrayList<SimpleGeneEdge> do_lit_miningNetwork(BNInitDialog dialog) throws OutOfRangeException, IOException, NullArgumentException, InterruptedException {
        String kegg_sp = dialog.getKeggSpecies();
        kegg_sp = kegg_sp != null ? kegg_sp.trim() : "na";
        this.updatePBarProgress("Building Property File", this.counter + 5);
        Useful.buildPropertyFile(dialog.isLit(), dialog.isPPI(), dialog.isKEGG(), dialog.isBoth(), dialog.isLitAndKegg(), dialog.isPpiAndKegg(), dialog.isAll(), dialog.useGoTerm(), dialog.getBaseFileLocation(), kegg_sp, this.numClasses, this.numStates);
        this.updatePBarProgress("Getting LM interactions", this.counter + 5);
        ArrayList interactions = null;
        interactions = this.literatureMining(dialog.isLit(), dialog.isPPI(), dialog.isKEGG(), dialog.isBoth(), dialog.isLitAndKegg(), dialog.isPpiAndKegg(), dialog.isAll(), dialog.getBaseFileLocation(), this.data);
        System.out.println("literatureMining() returned");
        if (interactions != null) {
            if (interactions.size() > 50 && JOptionPane.showConfirmDialog(this.framework.getFrame(), "Too many interactions found. \n The process might run out of memory! \n Do you want to continue ? ", "Interaction found: " + interactions.size() + "!", 0) == 1) {
                this.disposePBar();
                return null;
            }
        } else {
            this.disposePBar();
            return null;
        }
        return interactions;
    }

    void do_usePartialNetworkSeed(ArrayList<SimpleGeneEdge> interactions) throws NullArgumentException, NotDAGException, InterruptedException, IOException {
        this.updatePBarProgress("Creating DAG from LM interactions", this.counter + 5);
        ArrayList lmDirEdges = PrepareXMLBifModule.getDAGFromUndirectedGraph(interactions);
        System.out.println("DAG created from LM edges");
        this.updatePBarProgress("Merging LM and seed Network edges", this.counter + 5);
        ArrayList<SimpleGeneEdge> mergedInteractions = UsefulInteractions.mergeInteractions(this.networkSeedEdgeList, lmDirEdges, true);
        System.out.println("Net Seed edges merged with LM edges");
        this.updatePBarProgress("Creating Priors Bif File", this.counter + 5);
        ArrayList<String> nodeNames = Useful.readNamesFromFile(this.tmpPath + "list.txt");
        SifToXMLBif.createXMLBifGivenSifFile(mergedInteractions, nodeNames, false, this.numStates, this.numClasses, this.tmpPath + "resultBif.xml");
        this.updatePBarProgress("Writing Seed Network", this.counter + 5);
        String fname_seed = this.writeUserSeedNetwork();
        this.networkFiles.add(0, fname_seed);
    }

    void do_NetworkSeedWithPrior(ArrayList<SimpleGeneEdge> interactions) throws NullArgumentException, NotDAGException, InterruptedException, IOException {
        this.updatePBarProgress("Generating DAG from LM interactions", this.counter + 5);
        ArrayList lmDirEdges = PrepareXMLBifModule.getDAGFromUndirectedGraph(interactions);
        System.out.println("DAG created from LM edges");
        this.updatePBarProgress("Merging LM and Seed Network interactions", this.counter + 5);
        ArrayList<SimpleGeneEdge> mergedInteractions = UsefulInteractions.mergeInteractions(this.networkSeedEdgeList, lmDirEdges, true);
        System.out.println("Net Seed edges merged with LM edges");
        this.updatePBarProgress("Generating XML Bif File", this.counter + 5);
        ArrayList<String> nodeNames = Useful.readNamesFromFile(this.tmpPath + "list.txt");
        SifToXMLBif.createXMLBifGivenSifFile(mergedInteractions, nodeNames, false, this.numStates, this.numClasses, this.tmpPath + "resultBif.xml");
        this.updatePBarProgress("Writing Seed Network", this.counter + 5);
        String fname_seed = this.writeUserSeedNetwork();
        this.networkFiles.add(0, fname_seed);
    }

    void do_NetworkSeedWithoutPrior(Cluster cl, boolean asFixedNetForCptOnly) throws InterruptedException, NullArgumentException, IOException, Exception {
        String[] label = this.saveToFile(this.kModel, this.numClasses, this.data.getFeaturesCount(), this.tmpPath + "label");
        if (this.labelFile != null) {
            this.saveToFile(this.kModel, this.numClasses, this.labelFile);
        }
        this.updatePBarProgress("Mapping and encoding groups", this.counter + 10);
        this.saveWekaData(cl, this.framework, label, this.tmpPath);
        this.updatePBarProgress("Dicretizing Data and making ARFF file", this.counter + 10);
        Properties props = PrepareArrayDataModule.prepareArrayData(this.tmpPath + "wekaData", this.numBin, this.isBootstraping, this.numIterations, this.numClasses);
        String bifFile = this.tmpPath + "resultBif.xml";
        String outArffFileName = this.tmpPath + "outExpression.arff";
        String namesFileName = this.tmpPath + "list.txt";
        this.updatePBarProgress("Generating XML Bif File", this.counter + 10);
        PrepareXMLBifModule.createXMLBifFromSimpleGeneEdge(namesFileName, bifFile, this.tmpPath + "prepareXMLBifMod.props", this.networkSeedEdgeList);
        this.updatePBarProgress("Evaluating Baysian Model", this.counter + 10);
        BayesNet bnNet = new BayesNet();
        this.evalStr = asFixedNetForCptOnly ? Evaluation.evaluateModel((Classifier)bnNet, (String[])Useful.getWekaArgsArrayForFixedFile(outArffFileName, bifFile, this.kfold)) : Evaluation.evaluateModel((Classifier)bnNet, (String[])Useful.getWekaArgsArray(outArffFileName, bifFile, this.sAlgorithm, this.useArc, this.numParents, this.sType, this.kfold));
        bnNet.estimateCPTs();
        this.XmlBifStr = bnNet.toXMLBIF03();
        this.updatePBarProgress("Generating Cytoscape File", this.counter + 10);
        String fname_seed = this.writeUserSeedNetwork();
        this.updatePBarProgress("Writing Network Files", this.counter + 10);
        this.networkFiles.add(0, fname_seed);
        String obsNetFile = this.resultPath + Useful.getUniqueFileID() + this.sAlgorithm + "_" + this.sType + "_";
        String obsCptFile = obsNetFile + "CPT.xml";
        this.writeCptFile(this.XmlBifStr, obsCptFile);
        obsNetFile = this.writeWekaNetwork(obsNetFile, this.XmlBifStr, obsCptFile);
        this.networkFiles.add(0, obsNetFile);
        if (this.isBootstraping) {
            this.do_bootStrapNetworks(props);
        }
        if (cancel) {
            return;
        }
        this.updatePBarProgress("Launching Cytoscape", this.pbar.getMaximum() - 1);
        this.pbar.close();
        CytoscapeWebstart.onWebstartCytoscapeBN(this.networkFiles);
    }

    private ArrayList<String> loadNetSeedFile(String netSeedUID, String netSeedFileLoc) throws IOException {
        File netSeedFile = new File(netSeedFileLoc);
        if (!netSeedFile.exists()) {
            throw new IOException("File not found: " + netSeedFileLoc);
        }
        BufferedReader buff = new BufferedReader(new FileReader(netSeedFile));
        String line = new String();
        ArrayList<String> edges = new ArrayList<String>();
        while ((line = buff.readLine()) != null) {
            String[] tmp = line.split("\t");
            if (tmp.length != 2) {
                edges = null;
                throw new IOException(line + "\n in network seed file, is in invalid format");
            }
            edges.add(tmp[0].trim() + "-" + tmp[1].trim());
        }
        return edges;
    }

    private String writeUserSeedNetwork() throws NullArgumentException, IOException {
        String fname_seed = "";
        if (!this.data.isAnnotationLoaded()) {
            fname_seed = Useful.getUniqueFileID() + "_" + "Seed.sif";
            UsefulInteractions.writeSifFileUndir(this.networkSeedEdgeList, this.resultPath + fname_seed);
        } else {
            fname_seed = Useful.getUniqueFileID() + "_" + "Seed.xgmml";
            if (this.probeIndexAssocHash != null) {
                if (this.probeIndexAssocHash.size() <= 0) {
                    throw new NullArgumentException("Given Probe-Index Hash was empty!");
                }
            } else {
                throw new NullArgumentException("Given Probe-Index Hash was null!");
            }
            UsefulInteractions.writeXgmmlFileUndir(this.networkSeedEdgeList, this.resultPath + fname_seed, this.probeIndexAssocHash, this.data);
        }
        return this.resultPath + fname_seed;
    }

    private String writeWekaNetwork(String obsNetFile, String cptString, String obsCptFile) throws SAXException, IOException, NullArgumentException {
        if (!this.data.isAnnotationLoaded()) {
            obsNetFile = obsNetFile + ".sif";
            FileOutputStream fos = new FileOutputStream(obsNetFile);
            PrintWriter pw = new PrintWriter(fos, true);
            FromWekaToSif.fromWekaBifToSif(cptString, pw);
            fos.flush();
            fos.close();
            pw.close();
        } else {
            obsNetFile = obsNetFile + ".xgmml";
            FromWekaToSif.fromWekaBifToXgmml(true, cptString, obsNetFile, obsCptFile, this.probeIndexAssocHash, this.data);
        }
        return obsNetFile;
    }

    private void writeCptFile(String XmlBifStr, String obsCptFile) throws IOException {
        FileOutputStream fos = new FileOutputStream(obsCptFile);
        PrintWriter pw = new PrintWriter(fos, true);
        pw.print(XmlBifStr);
        pw.close();
        fos.close();
    }

    private ArrayList<SimpleGeneEdge> mapNetSeedEdgesToSimpleEdges(String netSeedUID, ArrayList<String> netEdges, int[] probeIndices) throws Exception {
        this.unMappedNetworkSeedEdgeList = new ArrayList();
        Hashtable<String, MevAnnotation> _tmpTable = new Hashtable<String, MevAnnotation>();
        ArrayList<SimpleGeneEdge> edgeList = new ArrayList<SimpleGeneEdge>();
        Iterator<String> it = netEdges.iterator();
        int row = 0;
        while (it.hasNext()) {
            block6: {
                MevAnnotation annotationTo;
                MevAnnotation annotationFrm;
                block9: {
                    String[] __tmp;
                    block7: {
                        String _tmp;
                        block8: {
                            block5: {
                                block3: {
                                    block4: {
                                        _tmp = it.next();
                                        __tmp = _tmp.split("-");
                                        annotationFrm = null;
                                        annotationTo = null;
                                        if (_tmpTable.get(__tmp[0]) != null) break block3;
                                        annotationFrm = (MevAnnotation)this.mapAnnotationGivenIdices(__tmp[0], probeIndices, netSeedUID);
                                        if (annotationFrm == null) break block4;
                                        _tmpTable.put(__tmp[0], annotationFrm);
                                        break block5;
                                    }
                                    this.unMappedNetworkSeedEdgeList.add(_tmp);
                                    break block6;
                                }
                                annotationFrm = (MevAnnotation)_tmpTable.get(__tmp[0]);
                            }
                            if (_tmpTable.get(__tmp[1]) != null) break block7;
                            annotationTo = (MevAnnotation)this.mapAnnotationGivenIdices(__tmp[1], probeIndices, netSeedUID);
                            if (annotationTo == null) break block8;
                            _tmpTable.put(__tmp[1], annotationTo);
                            break block9;
                        }
                        this.unMappedNetworkSeedEdgeList.add(_tmp);
                        break block6;
                    }
                    annotationTo = (MevAnnotation)_tmpTable.get(__tmp[1]);
                }
                edgeList.add(new SimpleGeneEdge(annotationFrm.getGenBankAcc(), annotationTo.getGenBankAcc(), (IAnnotation)annotationFrm, (IAnnotation)annotationTo));
            }
            ++row;
        }
        _tmpTable = null;
        if (edgeList == null) {
            throw new Exception("No seed network nodes mapped to selected cluster nodes.\nUID used: " + netSeedUID);
        }
        if (edgeList.size() == 0) {
            throw new Exception("No seed network nodes mapped to selected cluster nodes.\nUID used: " + netSeedUID);
        }
        return edgeList;
    }

    private IAnnotation mapAnnotationGivenIdices(String value, int[] probeIndices, String netSeedUID) {
        for (int i = 0; i < probeIndices.length; ++i) {
            MevAnnotation annotation = (MevAnnotation)this.data.getSlideDataElement(0, probeIndices[i]).getElementAnnotation();
            String[] _tmp = annotation.getAttribute(netSeedUID);
            if (_tmp == null) {
                System.out.println("MevAnnotation not found for: " + value);
                return null;
            }
            for (int ii = 0; ii < _tmp.length; ++ii) {
                if (!_tmp[ii].trim().toUpperCase().equals(value.trim().toUpperCase())) continue;
                System.out.println("MevAnnotation found for: " + value + " Gene Name: " + annotation.getGeneSymbol());
                return annotation;
            }
        }
        return null;
    }

    protected void onOk(Cluster cl, File labelFile, BNClassificationEditor.BNClassTableModel kModel, boolean isBootstraping, String numBin, int numClasses, String sType, String sAlgorithm, String numParents, int kfold, boolean useArc, int numIterations, float confThreshold) throws InterruptedException, IOException, SAXException, NullArgumentException, Exception {
        String[] label = this.saveToFile(kModel, numClasses, this.data.getFeaturesCount(), this.tmpPath + "label");
        if (labelFile != null) {
            this.saveToFile(kModel, numClasses, labelFile);
        }
        this.updatePBarProgress("Encoding matrix by class labels", this.counter + 5);
        this.updatePBarProgress("Discretizing Data and creating ARFF file", this.counter + 5);
        this.saveWekaData(cl, this.framework, label, this.tmpPath);
        if (cancel) {
            return;
        }
        this.updatePBarProgress("Transposing matrix", this.counter + 5);
        Properties props = this.tranSaveWeka(isBootstraping, numBin, numClasses, numIterations, this.tmpPath);
        if (cancel) {
            return;
        }
        String outarff = "outExpression.arff";
        this.updatePBarProgress("Evaluating Model on Observed data", this.counter + 5);
        String[] argsWeka = Useful.getWekaArgsArray(this.tmpPath + outarff, this.tmpPath + "resultBif.xml", sAlgorithm, useArc, numParents, sType, kfold);
        BayesNet bnNetOrg = new BayesNet();
        this.evalStr = Evaluation.evaluateModel((Classifier)bnNetOrg, (String[])argsWeka);
        if (cancel) {
            return;
        }
        this.updatePBarProgress("Learning CPT for Observed Network", this.counter + 5);
        bnNetOrg.estimateCPTs();
        this.XmlBifStr = bnNetOrg.toXMLBIF03();
        String lmNetFile = this.resultPath + System.getProperty("LM_ONLY");
        this.networkFiles.add(0, lmNetFile);
        String obsNetFile = this.resultPath + Useful.getUniqueFileID() + sAlgorithm + "_" + sType + "_";
        String obsCptFile = obsNetFile + "CPT.xml";
        this.updatePBarProgress("Writing CPT file", this.counter + 5);
        this.writeCptFile(bnNetOrg.toXMLBIF03(), obsCptFile);
        if (cancel) {
            return;
        }
        this.updatePBarProgress("Writting Network Files", this.counter + 5);
        obsNetFile = this.writeWekaNetwork(obsNetFile, this.XmlBifStr, obsCptFile);
        if (cancel) {
            return;
        }
        this.networkFiles.add(0, obsNetFile);
        if (isBootstraping) {
            this.do_bootStrapNetworks(props);
        }
        if (cancel) {
            return;
        }
        this.disposePBar();
        CytoscapeWebstart.onWebstartCytoscapeBN(this.networkFiles);
    }

    private void do_bootStrapNetworks(Properties props) throws InterruptedException, Exception {
        String outarff = "outExpression.arff";
        this.pbar.setMaximum(this.pbar.getMaximum() + 2 * this.numIterations);
        this.updatePBarProgress("Starting Bootstrap", this.counter + 2);
        String outarffbase = props.getProperty("rootOutputFileName");
        String outarffext = ".arff";
        this.evalStrs = new String[this.numIterations];
        this.XmlBifStrs = new String[this.numIterations];
        int ctr = 0;
        for (int i = 0; i < this.numIterations; ++i) {
            this.updatePBarProgress("Bootstrap " + ++ctr + " of " + this.numIterations, this.counter + 2);
            outarff = outarffbase + i + outarffext;
            String[] argsWeka = Useful.getWekaArgsArray(this.tmpPath + outarff, this.tmpPath + "resultBif.xml", this.sAlgorithm, this.useArc, this.numParents, this.sType, this.kfold);
            BayesNet bnNetOrg = new BayesNet();
            this.evalStrs[i] = Evaluation.evaluateModel((Classifier)bnNetOrg, (String[])argsWeka);
            bnNetOrg.estimateCPTs();
            this.XmlBifStrs[i] = bnNetOrg.toXMLBIF03();
            if (this.pbar.isCanceled()) {
                return;
            }
            this.pbar.setProgress(5 + i + 1);
            if (!cancel) continue;
            return;
        }
        this.updatePBarProgress("Creating Network from Bootstrap Models", this.counter + 5);
        Hashtable<String, Integer> edgesTable = new Hashtable<String, Integer>();
        this.bootNetFile = this.createNetworkFromBootstraps(this.XmlBifStrs, this.evalStrs, this.numIterations, outarffbase, this.sType, this.sAlgorithm, this.kfold, this.numIterations, this.confThreshold, edgesTable);
        if (cancel) {
            return;
        }
        this.updatePBarProgress("Launching Cytoscape..", this.pbar.getMaximum() - 1);
        this.updatePBarCounter(this.pbar.getMaximum() + 1);
        this.displayScrollPane(this.getScrollPanePanel(this.isBootstraping, this.sType, this.sAlgorithm, this.kfold, this.numIterations, edgesTable));
    }

    public void displayScrollPane(JPanel panel) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.resultFrame = new JDialog(this.mainFrame, "Results from Weka", false);
        this.resultFrame.getContentPane().add(panel);
        this.resultFrame.pack();
        this.resultFrame.setLocation((screenSize.width - panel.getSize().width) / 2, (screenSize.height - panel.getSize().height) / 2);
        this.resultFrame.setVisible(true);
    }

    public JPanel getScrollPanePanel(boolean isBootstraping, final String sType, final String sAlgorithm, final int kfold, final int numIterations, final Hashtable<String, Integer> edgesTable) throws SAXException, IOException, NullArgumentException, Exception {
        if (isBootstraping) {
            this.networkFiles.add(0, this.bootNetFile);
            this.updateNetwork = new JButton("Update Network");
            this.confThreshField = new JTextField("0.8");
            this.confThreshField.setPreferredSize(new Dimension(35, 10));
            this.finalThreshBox = new JCheckBox("Final");
            this.finalThreshBox.setBackground(Color.white);
            this.finalThreshBox.setFocusPainted(false);
        }
        JPanel evalPanel = new JPanel();
        evalPanel.setLayout(new BorderLayout());
        evalPanel.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
        if (isBootstraping) {
            this.updateNetwork.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    String cptFile;
                    try {
                        cptFile = BNGUI.this.onUpdateNetwork(sType, sAlgorithm, kfold, numIterations, edgesTable);
                    }
                    catch (SAXException e1) {
                        e1.printStackTrace();
                        JOptionPane.showMessageDialog(null, "Could not update network. Error in pasing XML doc", "SAX parsing Error", 0);
                        BNGUI.this.resultFrame.dispose();
                        return;
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                        JOptionPane.showMessageDialog(null, "Could not update network. Error in reading/writing file", "IO Error", 0);
                        BNGUI.this.resultFrame.dispose();
                        return;
                    }
                    catch (NullArgumentException e1) {
                        e1.printStackTrace();
                        JOptionPane.showMessageDialog(null, "Could not update network.", "Error", 0);
                        BNGUI.this.resultFrame.dispose();
                        return;
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                        JOptionPane.showMessageDialog(null, "Could not update network.", "Error", 0);
                        BNGUI.this.resultFrame.dispose();
                        return;
                    }
                    if (!BNGUI.this.framework.isGaggleConnected()) {
                        BNGUI.this.framework.requestGaggleConnect();
                    }
                    if (!BNGUI.this.framework.isGaggleConnected()) {
                        JOptionPane.showMessageDialog(null, "Could not connect to Gaggle", "Error", 0);
                        BNGUI.this.resultFrame.dispose();
                        return;
                    }
                    try {
                        BNGUI.this.broadcastNetworkGaggle(BNGUI.this.interactionsfinal, cptFile);
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(null, "Error Using Gaggle Broadcast", "Error", 0);
                        e.printStackTrace();
                        System.out.println("Dumping Content of probeIndexAssocHash");
                        Set<String> sit = BNGUI.this.probeIndexAssocHash.keySet();
                        for (String key : sit) {
                            System.out.println("Key: " + key + " Value: " + BNGUI.this.probeIndexAssocHash.get(key));
                        }
                        if (BNGUI.this.finalThreshBox.isSelected()) {
                            BNGUI.this.resultFrame.dispose();
                        }
                        BNGUI.this.resultFrame.show();
                    }
                }
            });
        }
        if (isBootstraping) {
            evalPanel.add((Component)this.finalThreshBox, "West");
            evalPanel.add((Component)this.confThreshField, "Center");
            evalPanel.add((Component)this.updateNetwork, "East");
        }
        return evalPanel;
    }

    protected String onUpdateNetwork(String sType, String sAlgorithm, int kfold, int numIterations, Hashtable<String, Integer> edgesTable) throws SAXException, IOException, NullArgumentException, Exception {
        String outCPTBifXML = "";
        Vector<String> interactionsPrefinal = null;
        interactionsPrefinal = this.interactionsfinal;
        this.interactionsfinal = new Vector();
        float confThres = Float.parseFloat(this.confThreshField.getText().trim());
        this.interactionsfinal = this.createInteractions(edgesTable, confThres, numIterations);
        String bifCpt = "";
        bifCpt = this.learnCPTFromFixedNetwork(this.interactionsfinal, kfold);
        String _bootNetFile = this.resultPath + Useful.getUniqueFileID() + sAlgorithm + "_" + sType + "_" + "boot_result_" + numIterations + "_" + confThres;
        outCPTBifXML = _bootNetFile + "_CPT.xml";
        _bootNetFile = this.writeWekaNetwork(_bootNetFile, bifCpt, outCPTBifXML);
        if (this.finalThreshBox.isSelected()) {
            this.finalBootFile = _bootNetFile;
            this.networkFiles.add(0, this.finalBootFile);
            if (this.interactionsfinal.size() == 0) {
                JOptionPane.showMessageDialog(this.mainFrame, "No valid network for selected threshold.\n Will try to use last selected threshold.", "Warning", 1);
                if (interactionsPrefinal != null) {
                    if (interactionsPrefinal.size() > 0) {
                        JOptionPane.showMessageDialog(this.mainFrame, "Last network not avaialble. Aborting.", "Warning", 1);
                        return null;
                    }
                } else {
                    JOptionPane.showMessageDialog(this.mainFrame, "Last network not avaialble. Aborting.", "Warning", 1);
                    return null;
                }
            }
            this.resultFrame.hide();
        }
        this.writeCptFile(bifCpt, outCPTBifXML);
        return outCPTBifXML;
    }

    private void saveToFile(BNClassificationEditor.BNClassTableModel kModel, int numClasses, File file) throws FileNotFoundException {
        PrintWriter out = new PrintWriter(new FileOutputStream(file));
        for (int i = 0; i < kModel.getRowCount(); ++i) {
            int j;
            out.print((Integer)kModel.getValueAt(i, 0));
            out.print("\t");
            for (j = 1; j <= numClasses; ++j) {
                if (!((Boolean)kModel.getValueAt(i, j)).booleanValue()) continue;
                out.print(j);
                break;
            }
            if (((Boolean)kModel.getValueAt(i, numClasses)).booleanValue()) {
                out.print(-1);
            }
            for (j = numClasses + 1; j < kModel.getColumnCount(); ++j) {
                out.print("\t");
                out.print(kModel.getValueAt(i, j));
            }
            out.print("\n");
        }
        out.flush();
        out.close();
    }

    private String[] saveToFile(BNClassificationEditor.BNClassTableModel kModel, int numClasses, int numLabels, String fileName) {
        String[] label = new String[numLabels];
        try {
            PrintWriter out = new PrintWriter(new FileOutputStream(new File(fileName)));
            for (int i = 0; i < kModel.getRowCount(); ++i) {
                int j;
                out.print((Integer)kModel.getValueAt(i, 0));
                out.print("\t");
                for (j = 1; j <= numClasses; ++j) {
                    if (!((Boolean)kModel.getValueAt(i, j)).booleanValue()) continue;
                    out.print(j);
                    label[i] = new Integer(j).toString();
                    break;
                }
                if (((Boolean)kModel.getValueAt(i, numClasses)).booleanValue()) {
                    label[i] = new Integer(-1).toString();
                    out.print(-1);
                }
                for (j = numClasses + 1; j < kModel.getColumnCount(); ++j) {
                    out.print("\t");
                    out.print(kModel.getValueAt(i, j));
                }
                out.print("\n");
            }
            out.flush();
            out.close();
            return label;
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this.framework.getFrame(), "Error saving sample labels.  Labels not saved.", "Save Error", 2);
            return null;
        }
    }

    private void saveWekaData(Cluster cl, IFramework frame, String[] label, String path) throws FileNotFoundException {
        int i;
        int genes = cl.getIndices().length;
        IData data = frame.getData();
        int[] rows = new int[genes];
        rows = cl.getIndices();
        String[] accList = new String[genes];
        PrintWriter out = new PrintWriter(new FileOutputStream(new File(this.tmpPath + "wekaData")));
        String[] fieldNames = data.getFieldNames();
        String val = new String();
        if (fieldNames == null) {
            return;
        }
        out.print("CLASS");
        out.print("\t");
        for (i = 0; i < data.getFeaturesCount(); ++i) {
            if (new Integer(label[i]) != -1) {
                out.print("class" + label[i]);
            } else {
                out.print("-class");
            }
            out.print("\t");
        }
        out.print("\n");
        accList = this.convertFromFile(path);
        for (i = 0; i < rows.length; ++i) {
            String s = data.getSlideDataElement(0, rows[i]).getFieldAt(0);
            if (s == "") {
                out.print("gene" + (i + 1));
            } else {
                out.print(accList[i]);
            }
            for (int j = 0; j < data.getFeaturesCount(); ++j) {
                out.print("\t");
                out.print(Float.toString(data.getRatio(j, rows[i], 1)));
            }
            out.print("\n");
        }
        out.flush();
        out.close();
    }

    public Properties tranSaveWeka(boolean isBootstraping, String numBin, int numClasses, int numIterations, String path) {
        return PrepareArrayDataModule.prepareArrayData(path + "wekaData", numBin, isBootstraping, numIterations, numClasses);
    }

    private String createNetworkFromBootstraps(String[] xmlBifStrs, String[] evalStrs, int numItr, String outarffbase, String sType, String sAlgorithm, int kfold, int numIterations, float confThreshold, Hashtable<String, Integer> edgesTable) throws SAXException, IOException, NullArgumentException, Exception {
        int i;
        String path = this.tmpPath;
        String fileName = path + outarffbase;
        for (i = 0; i < numItr; ++i) {
            FileOutputStream fos = new FileOutputStream(fileName + i + ".sif");
            PrintWriter pw = new PrintWriter(fos, true);
            FromWekaToSif.fromWekaBifToSif(xmlBifStrs[i], pw);
            pw.flush();
            pw.close();
        }
        for (i = 0; i < numItr; ++i) {
            BufferedReader br = new BufferedReader(new FileReader(fileName + i + ".sif"));
            String line = br.readLine();
            while (line != null) {
                Integer count = edgesTable.get(line.trim());
                if (count != null) {
                    edgesTable.remove(line.trim());
                    edgesTable.put(line.trim(), count + new Integer(1));
                } else {
                    edgesTable.put(line.trim(), new Integer(1));
                }
                line = br.readLine();
            }
            br.close();
        }
        Vector<String> interactions = new Vector();
        interactions = this.createInteractions(edgesTable, confThreshold, numItr);
        String bifCpt = "";
        bifCpt = this.learnCPTFromFixedNetwork(interactions, kfold);
        String _bootNetFile = this.resultPath + Useful.getUniqueFileID() + sAlgorithm + "_" + sType + "_" + "boot_result_" + numIterations + "_" + confThreshold;
        String _bootCptFile = _bootNetFile + "_CPT.xml";
        this.writeCptFile(bifCpt, _bootCptFile);
        _bootNetFile = this.writeWekaNetwork(_bootNetFile, bifCpt, _bootCptFile);
        return _bootNetFile;
    }

    private String[] convertFromFile(String path) {
        String filePath = path + "list.txt";
        String lineRead = "";
        Vector<String> store = new Vector<String>();
        String[] accList = null;
        try {
            File file = new File(filePath);
            FileReader fr = new FileReader(file);
            BufferedReader br = new BufferedReader(fr);
            while ((lineRead = br.readLine()) != null) {
                store.add(lineRead);
            }
            accList = new String[store.size()];
            for (int i = 0; i < store.size(); ++i) {
                accList[i] = (String)store.get(i);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return accList;
    }

    protected Vector<String> createInteractions(Hashtable edges, float thresh, int itr) {
        Vector<String> _tmp = new Vector<String>();
        Enumeration enumerate = edges.keys();
        while (enumerate.hasMoreElements()) {
            String edge = (String)enumerate.nextElement();
            Integer count = (Integer)edges.get(edge);
            float presence = count.floatValue() / (float)itr;
            if (!(presence >= thresh)) continue;
            _tmp.add(edge);
        }
        return _tmp;
    }

    private String learnCPTFromFixedNetwork(Vector<String> interactions, int kfold) throws Exception {
        String propsFile = this.tmpPath + "prepareXMLBifMod.props";
        PrepareXMLBifModule.createXMLBifFromList(propsFile, interactions);
        String bifFileFinal = this.tmpPath + "out_bif_final.xml";
        BayesNet bnNet = new BayesNet();
        String outarff = this.tmpPath + "outExpression.arff";
        Evaluation.evaluateModel((Classifier)bnNet, (String[])Useful.getWekaArgsArrayForFixedFile(outarff, bifFileFinal, kfold));
        bnNet.estimateCPTs();
        return bnNet.toXMLBIF03();
    }

    protected void broadcastNetworkGaggle(Vector<String> interacts, String cptFile) {
        Vector<int[]> interactions = new Vector<int[]>();
        for (int j = 0; j < interacts.size(); ++j) {
            String[] edgeLabels = interacts.get(j).split(" ");
            System.out.println("Encoding edge: " + edgeLabels[0] + " - " + edgeLabels[2]);
            int[] fromTo = new int[2];
            String[] tmp = this.probeIndexAssocHash.get(edgeLabels[0]).split("-");
            fromTo[0] = Integer.parseInt(tmp[0]);
            tmp = this.probeIndexAssocHash.get(edgeLabels[2]).split("-");
            fromTo[1] = Integer.parseInt(tmp[0]);
            interactions.add(fromTo);
        }
        Network nt = this.getGaggleNetwork(interactions, "pd", true, cptFile);
        System.out.println("Broadcasting " + nt.getName());
        this.framework.broadcastNet(nt);
    }

    public Network getGaggleNetwork(Vector<int[]> interactions, String type, boolean directionals, String title) {
        Network nt = new Network();
        nt.setSpecies("");
        String[] allFields = this.data.getFieldNames();
        Hashtable<String, String[]> nodeAnnotations = new Hashtable<String, String[]>();
        for (int i = 0; i < interactions.size(); ++i) {
            String source = interactions.get(i)[0] == 9999 ? "CLASS" : this.data.getAnnotationList("GENBANK_ACC", new int[]{interactions.get(i)[0]})[0];
            String target = interactions.get(i)[1] == 9999 ? "CLASS" : this.data.getAnnotationList("GENBANK_ACC", new int[]{interactions.get(i)[1]})[0];
            Interaction tempInt = new Interaction(source, target, type, directionals);
            nt.add(tempInt);
            if (!nodeAnnotations.containsKey(source)) {
                nodeAnnotations.put(source, new String[0]);
                if (source.equals("CLASS")) {
                    for (String field : allFields) {
                        nt.addNodeAttribute(source, field, (Object)"CLASS");
                    }
                } else {
                    for (String field : allFields) {
                        nt.addNodeAttribute(source, field, (Object)this.data.getElementAnnotation(interactions.get(i)[0], field)[0]);
                    }
                }
            }
            if (nodeAnnotations.containsKey(target)) continue;
            nodeAnnotations.put(target, new String[0]);
            if (target.equals("CLASS")) {
                for (String field : allFields) {
                    nt.addNodeAttribute(target, field, (Object)"CLASS");
                }
                continue;
            }
            for (String field : allFields) {
                nt.addNodeAttribute(target, field, (Object)this.data.getElementAnnotation(interactions.get(i)[1], field)[0]);
            }
        }
        nt.setName(title);
        return nt;
    }

    private DefaultMutableTreeNode createResultTree(Experiment experiment, LMBNViewer fileViewer, HistoryViewer out, GeneralInfo info) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("BN");
        root.add(new DefaultMutableTreeNode(new LeafInfo("Networks", (IViewer)fileViewer)));
        root.add(new DefaultMutableTreeNode(new LeafInfo("BN Details", (IViewer)out)));
        this.addGeneralInfo(root, info);
        return root;
    }

    private DefaultMutableTreeNode createResultTree(Experiment experiment, LMBNViewer fileViewer, LMBNViewer badEntries, HistoryViewer out, GeneralInfo info) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("BN");
        root.add(new DefaultMutableTreeNode(new LeafInfo("Networks", (IViewer)fileViewer)));
        root.add(new DefaultMutableTreeNode(new LeafInfo("Error Net Seed", (IViewer)badEntries)));
        root.add(new DefaultMutableTreeNode(new LeafInfo("BN Details", (IViewer)out)));
        this.addGeneralInfo(root, info);
        return root;
    }

    private LMBNViewer createLMBNViewer(Vector files) {
        LMBNViewer viewer = new LMBNViewer(files);
        return viewer;
    }

    private void addGeneralInfo(DefaultMutableTreeNode root, GeneralInfo info) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("General Information");
        node.add(new DefaultMutableTreeNode("Number of Genes: " + info.numGene));
        node.add(new DefaultMutableTreeNode("Prior: " + info.prior));
        node.add(new DefaultMutableTreeNode("Number of Discretizing Expression Values: " + info.numBin));
        node.add(new DefaultMutableTreeNode("Number of Sample Classes: " + info.numClass));
        node.add(new DefaultMutableTreeNode("Number of Parents: " + info.numParents));
        node.add(new DefaultMutableTreeNode("Algorithm: " + info.algorithm));
        node.add(new DefaultMutableTreeNode("Score: " + info.score));
        node.add(new DefaultMutableTreeNode("K-Folds: " + info.kFolds));
        root.add(node);
    }

    public ArrayList literatureMining(boolean lit, boolean ppi, boolean kegg, boolean LitPpi, boolean LitKegg, boolean KeggPpi, boolean LitPpiKegg, String path, IData data) throws OutOfRangeException, IOException, NullArgumentException {
        GetInteractionsModule getModule = new GetInteractionsModule(path, this.probeIndexAssocHash);
        if (LitPpiKegg) {
            return GetInteractionsModule.getInteractions(this.tmpPath + "getInterModLitPpiKegg.props", data);
        }
        if (LitKegg) {
            return GetInteractionsModule.getInteractions(this.tmpPath + "getInterModLitKegg.props", data);
        }
        if (KeggPpi) {
            return GetInteractionsModule.getInteractions(this.tmpPath + "getInterModPpiKegg.props", data);
        }
        if (LitPpi) {
            return GetInteractionsModule.getInteractions(this.tmpPath + "getInterModBoth.props", data);
        }
        if (lit) {
            return GetInteractionsModule.getInteractions(this.tmpPath + "getInterModLit.props", data);
        }
        if (ppi) {
            return GetInteractionsModule.getInteractions(this.tmpPath + "getInterModPPIDirectly.props", data);
        }
        if (kegg) {
            return GetInteractionsModule.getInteractions(this.tmpPath + "getInterModKegg.props", data);
        }
        return null;
    }

    public void prepareXMLBifFile(String path) {
        PrepareXMLBifModule getModule = new PrepareXMLBifModule();
        PrepareXMLBifModule.test(this.tmpPath + "prepareXMLBifMod.props");
    }

    public void setLMBNViewer(LMBNViewer fileViewer) {
        this.fileViewer = fileViewer;
    }

    public LMBNViewer getLMBNViewerViewer() {
        return this.fileViewer;
    }

    public void setHistoryViewer(HistoryViewer histViewer) {
        this.wekaOutputViewer = histViewer;
    }

    public HistoryViewer getHistoryViewer() {
        return this.wekaOutputViewer;
    }

    public String getWekaEvalString() {
        return this.evalStr;
    }

    public String getBootNetworkFile() {
        return this.bootNetFile;
    }

    public Vector getNetworkFiles() {
        return this.networkFiles;
    }

    public void setWekaEvalString(String s) {
        this.evalStr = s;
    }

    public void setBootNetworkFile(String file) {
        this.bootNetFile = file;
    }

    public void setNetworkFiles(Vector netFiles) {
        this.networkFiles = netFiles;
    }

    void pBarInit(String msg, String note) {
        this.pbar = null;
        this.pbar = new ProgressMonitor(this.framework.getFrame(), msg, note, 0, 100);
        this.pbar.setMillisToDecideToPopup(0);
        this.pbar.setMillisToPopup(0);
        this.pbar.setProgress(0);
        if (this.pBarTimer == null) {
            this.pBarTimer = new Timer(500, this);
        }
        this.pBarTimer.start();
    }

    void updatePBarProgress(String msg, int ctr) throws InterruptedException {
        this.updatePBarMsg(msg);
        this.updatePBarCounter(ctr);
        Thread.sleep(1000L);
    }

    void updatePBarMsg(String msg) throws InterruptedException {
        this.pBarMsg = msg;
        Thread.sleep(500L);
    }

    void updatePBarCounter(int ctr) {
        this.counter = ctr;
    }

    void disposePBar() {
        if (this.pbar == null) {
            return;
        }
        this.pbar.setProgress(this.pbar.getMaximum() + 1);
        this.updatePBarCounter(0);
        this.pBarMsg = "Bn Module Initializing";
        this.pBarTimer.stop();
        this.pBarTimer = null;
        this.pbar.close();
        this.pbar = null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        SwingUtilities.invokeLater(new UpdatePBar());
    }

    class UpdatePBar
    implements Runnable {
        UpdatePBar() {
        }

        @Override
        public void run() {
            if (BNGUI.this.pbar == null) {
                return;
            }
            if (BNGUI.this.pbar.isCanceled()) {
                System.out.println("Bn Cancelled");
                BNGUI.this.disposePBar();
                cancel = true;
                return;
            }
            BNGUI.this.pbar.setProgress(BNGUI.this.counter);
            BNGUI.this.pbar.setNote(BNGUI.this.pBarMsg);
        }
    }

    public static class GeneralInfo {
        public String score;
        String prior = "NO Priors";
        String useGoTerms = "Use modification of DFS";
        String numParents;
        int numClass;
        int numBin;
        int numGene;
        String algorithm;
        int kFolds;
    }
}

