/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.bn;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;

public class BNFileUpdateDialog
extends AlgorithmDialog {
    private JTabbedPane pane = new JTabbedPane();
    private int result = 2;
    private Vector repositoryHashes;

    public BNFileUpdateDialog(JFrame parent, Vector repositoryPropertyHashes) {
        super(parent, "BN File Update Selection", true);
        Listener listener = new Listener();
        this.addTabs(this.pane, repositoryPropertyHashes, listener);
        this.addContent(this.pane);
        this.setActionListeners(listener);
        this.pack();
    }

    public void addTabs(JTabbedPane pane, Vector propVector, Listener listener) {
        int numTabs = propVector.size();
        for (int i = 0; i < numTabs; ++i) {
            this.addNewTab(pane, i, (Hashtable)propVector.get(i), listener);
        }
    }

    public void addNewTab(JTabbedPane pane, int tabIndex, Hashtable props, Listener listener) {
        String tabLabel = (String)props.get("tab-label");
        String directoryLabel = (String)props.get("level-1-label");
        String fileLabel = (String)props.get("level-2-label");
        Vector mainKeys = (Vector)props.get("main-keys");
        Hashtable itemHash = (Hashtable)props.get("menu-hash");
        JComboBox box1 = new JComboBox(mainKeys);
        box1.setActionCommand("upper-level-selection");
        box1.addActionListener(listener);
        JComboBox box2 = new JComboBox();
        box2.setActionCommand("lower-level-selection");
        box2.addActionListener(listener);
        pane.addTab(tabLabel, new TabPanel(directoryLabel, box1, fileLabel, box2, itemHash, props));
    }

    public int showModal() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        this.show();
        return this.result;
    }

    private void resetControls() {
    }

    public String getSpeciesName() {
        TabPanel panel = (TabPanel)this.pane.getSelectedComponent();
        return (String)panel.getBox1().getSelectedItem();
    }

    public String getArrayName() {
        TabPanel panel = (TabPanel)this.pane.getSelectedComponent();
        return (String)panel.getBox2().getSelectedItem();
    }

    public int getRepositoryIndex() {
        return this.pane.getSelectedIndex();
    }

    public Hashtable getRepositoryProperties() {
        TabPanel panel = (TabPanel)this.pane.getSelectedComponent();
        return panel.getRepositoryProperties();
    }

    private class Listener
    extends DialogListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            String command = e.getActionCommand();
            if (command.equals("upper-level-selection")) {
                TabPanel panel = (TabPanel)BNFileUpdateDialog.this.pane.getSelectedComponent();
                panel.updateBox2();
            } else if (!command.equals("lower-level-selection")) {
                if (source == BNFileUpdateDialog.this.okButton) {
                    BNFileUpdateDialog.this.result = 0;
                    BNFileUpdateDialog.this.dispose();
                } else if (source == BNFileUpdateDialog.this.cancelButton) {
                    BNFileUpdateDialog.this.result = 2;
                    BNFileUpdateDialog.this.dispose();
                } else if (source == BNFileUpdateDialog.this.resetButton) {
                    BNFileUpdateDialog.this.resetControls();
                } else if (source == BNFileUpdateDialog.this.infoButton) {
                    HelpWindow.launchBrowser(BNFileUpdateDialog.this, "BN File Update Dialog");
                }
            }
        }

        @Override
        public void windowClosing(WindowEvent e) {
            BNFileUpdateDialog.this.result = -1;
            BNFileUpdateDialog.this.dispose();
        }
    }

    private class TabPanel
    extends JPanel {
        private JComboBox box1;
        private JComboBox box2;
        private JLabel box2JLabel;
        private String box2Label;
        private Hashtable box1ToBox2Hash;
        private Hashtable repositoryProperties;

        TabPanel(String box1Label, JComboBox b1, String box2Label, JComboBox b2, Hashtable menuHash, Hashtable repProps) {
            this.setLayout(new GridBagLayout());
            this.setBackground(Color.white);
            this.box1 = b1;
            this.box2 = b2;
            this.box1ToBox2Hash = menuHash;
            this.box2Label = box2Label;
            this.repositoryProperties = repProps;
            JLabel label = new JLabel(box1Label);
            this.add((Component)label, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(20, 0, 5, 0), 0, 0));
            this.add((Component)this.box1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 20, 0), 0, 0));
            this.box2JLabel = new JLabel(box2Label);
            this.add((Component)this.box2JLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
            this.add((Component)this.box2, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 20, 0), 0, 0));
            this.updateBox2();
        }

        public JComboBox getBox1() {
            return this.box1;
        }

        public JComboBox getBox2() {
            return this.box2;
        }

        public Hashtable getRepositoryProperties() {
            return this.repositoryProperties;
        }

        public void updateBox2() {
            this.box2.removeAllItems();
            String key = (String)this.box1.getSelectedItem();
            Vector box2Items = (Vector)this.box1ToBox2Hash.get(key);
            for (int i = 0; i < box2Items.size(); ++i) {
                this.box2.addItem(box2Items.elementAt(i));
            }
            this.box2JLabel.setText(this.box2Label + " " + key);
        }
    }
}

