/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.bn;

import ftp.FtpBean;
import ftp.FtpListResult;
import ftp.FtpObserver;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.Progress;

public class BNDownloadManager {
    private String FTP_REMOTE_FILE_OR_DIR;
    private boolean isDir = false;
    private static String FTP_CONFIG_URL = "http://compbio.dfci.harvard.edu/webstart/cytoscape/cyto_props.txt";
    private static String FTP_CONFIG_URL_TEST = "http://cbwebdev.dfci.harvard.edu/webstart/cytoscape/cyto_props.txt";
    private String FTP_SERVER;
    private String REPOSITORY_ROOT;
    private JFrame frame;
    private int BUFFERSIZE = 1024;
    private Progress progress;
    private boolean okStatus = true;
    private ProgressListener listener;
    String destPath;

    public BNDownloadManager(JFrame parent, String destPath, String title, String resourceName, boolean isDir) {
        this.frame = parent;
        this.destPath = destPath;
        this.FTP_REMOTE_FILE_OR_DIR = resourceName;
        this.isDir = isDir;
        this.listener = new ProgressListener();
        this.progress = new Progress((Frame)this.frame, title, this.listener);
        this.progress.setLocationRelativeTo(this.frame.getOwner());
        this.progress.setAlwaysOnTop(true);
    }

    public boolean updateFiles() {
        try {
            this.progress.setDescription("Retreving Repository Information");
            this.progress.setUnits(2);
            this.progress.show();
            Hashtable propertyHashes = this.getRepositoryInfo();
            this.progress.setDescription("Visiting Repository for Resource Checks");
            this.progress.setUnits(propertyHashes.size());
            this.progress.dispose();
            if (this.okStatus) {
                this.FTP_SERVER = ((String)propertyHashes.get("kegg_server")).trim();
                if (this.FTP_SERVER.endsWith("/")) {
                    this.FTP_SERVER = this.FTP_SERVER.substring(0, this.FTP_SERVER.length() - 1);
                }
                this.REPOSITORY_ROOT = ((String)propertyHashes.get("kegg_dir")).trim();
                if (this.REPOSITORY_ROOT.endsWith("/")) {
                    this.REPOSITORY_ROOT = this.REPOSITORY_ROOT.substring(0, this.REPOSITORY_ROOT.length() - 1);
                }
                return this.updateBNFiles(this.FTP_REMOTE_FILE_OR_DIR);
            }
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.print("Message" + e.getMessage());
            JOptionPane.showMessageDialog(this.frame, "<html>An error occurred when retrieving information onavailable<br>species and clone set files.  Update request cannot be fulfilled.", "BN Update Error", 0);
            this.okStatus = false;
            this.progress.dispose();
            return this.okStatus;
        }
    }

    public static Hashtable getConfigInfo() {
        Hashtable<String, String> props = new Hashtable<String, String>();
        try {
            String line;
            URLConnection conn = new URL(FTP_CONFIG_URL).openConnection();
            BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            while ((line = br.readLine()) != null) {
                if (line.startsWith("#")) continue;
                String[] keyValue = line.split("=");
                props.put(keyValue[0], keyValue[1]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return props;
    }

    private Hashtable getRepositoryInfo() {
        Hashtable<Object, Object> repHash = new Hashtable();
        try {
            URLConnection conn = new URL(FTP_CONFIG_URL).openConnection();
            this.progress.setValue(1);
            repHash = this.parseConfig(conn.getInputStream());
            Enumeration<Object> keySet = repHash.keys();
            while (keySet.hasMoreElements()) {
                String key = (String)keySet.nextElement();
                TMEV.storeProperty((String)key, (String)((String)repHash.get(key)));
            }
        }
        catch (Exception e) {
            System.out.println("Could not retreive Web Repository Info. Using cached value instead.");
            String cytoURL = TMEV.getSettingForOption((String)"cytoscape_webstart").trim();
            String cytoLibDir = TMEV.getSettingForOption((String)"cytoscape_lib_dir").trim();
            String keggServer = TMEV.getSettingForOption((String)"kegg_server").trim();
            String keggDir = TMEV.getSettingForOption((String)"kegg_dir").trim();
            if (cytoURL.equals("") || cytoURL == null || cytoLibDir.equals("") || cytoLibDir == null || keggServer.equals("") || keggServer == null || keggDir.equals("") || keggDir == null) {
                JOptionPane.showMessageDialog(new Frame(), "An error occurred when retrieving Web Repository Info.\n  Previously cached info not avaialble", "Cytoscape Launch Error", 0);
            }
            repHash.put("cytoscape_webstart", cytoURL);
            repHash.put("cytoscape_lib_dir", cytoLibDir);
            repHash.put("kegg_server", keggServer);
            repHash.put("kegg_dir", keggDir);
            return repHash;
        }
        return repHash;
    }

    public static Hashtable<String, String> getRepositoryInfoCytoscape() {
        Hashtable<Object, Object> repHash = new Hashtable();
        try {
            URLConnection conn = new URL(FTP_CONFIG_URL).openConnection();
            repHash = BNDownloadManager.parseConfigCytoscape(conn.getInputStream());
            Enumeration<Object> keySet = repHash.keys();
            while (keySet.hasMoreElements()) {
                String key = (String)keySet.nextElement();
                TMEV.storeProperty((String)key, (String)((String)repHash.get(key)));
            }
        }
        catch (Exception e) {
            System.out.println("Could not tereive Web Repository Info. Using cached value instead.");
            String cytoURL = TMEV.getSettingForOption((String)"cytoscape_webstart").trim();
            String cytoLibDir = TMEV.getSettingForOption((String)"cytoscape_lib_dir").trim();
            String keggServer = TMEV.getSettingForOption((String)"kegg_server").trim();
            String keggDir = TMEV.getSettingForOption((String)"kegg_dir").trim();
            String pluginsDir = TMEV.getSettingForOption((String)"cytoscape_plugins_dir").trim();
            if (cytoURL.equals("") || cytoURL == null || cytoLibDir.equals("") || cytoLibDir == null || keggServer.equals("") || keggServer == null || keggDir.equals("") || keggDir == null || pluginsDir.equals("") || pluginsDir == null) {
                JOptionPane.showMessageDialog(new Frame(), "An error occurred when retrieving Web Repository Info.\n  Previously cached info not avaialble", "Cytoscape Launch Error", 0);
            }
            repHash.put("cytoscape_webstart", cytoURL);
            repHash.put("cytoscape_lib_dir", cytoLibDir);
            repHash.put("kegg_server", keggServer);
            repHash.put("kegg_dir", keggDir);
            repHash.put("cytoscape_plugins_dir", pluginsDir);
            return repHash;
        }
        return repHash;
    }

    private static Hashtable<String, String> parseConfigCytoscape(InputStream is) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        Hashtable<String, String> currHash = new Hashtable<String, String>();
        while ((line = br.readLine()) != null) {
            if (line.startsWith("#")) continue;
            String[] keyValue = line.split("=");
            System.out.println("URL Config: " + keyValue[0] + "-" + keyValue[1]);
            currHash.put(keyValue[0], keyValue[1]);
        }
        return currHash;
    }

    private Hashtable<String, String> parseConfig(InputStream is) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        Hashtable<String, String> currHash = new Hashtable<String, String>();
        while ((line = br.readLine()) != null) {
            if (line.startsWith("#")) continue;
            String[] keyValue = line.split("=");
            System.out.println("URL Config: " + keyValue[0] + "-" + keyValue[1]);
            currHash.put(keyValue[0], keyValue[1]);
        }
        this.progress.setValue(2);
        return currHash;
    }

    private boolean updateBNFiles(String file) {
        return this.getBaseFiles(file);
    }

    private boolean getBaseFiles(String file) {
        boolean pass1 = true;
        File baseDir = new File(this.destPath);
        File outputFile = new File(baseDir.getAbsolutePath() + "/" + file);
        this.progress.setTitle("BN Download");
        this.progress.setDescription("Download KEGG Interaction File");
        this.progress.show();
        pass1 = this.downloadFile(file, outputFile);
        this.progress.dispose();
        if (pass1) {
            JOptionPane.showMessageDialog(this.frame, "The BN file system update is complete.", "BN File System Update", 1);
        } else {
            JOptionPane.showMessageDialog(this.frame, "The BN file system update was terminated due to the reported error.", "BN File System Update", 0);
        }
        return pass1;
    }

    private boolean downloadFile(String file, File dest) {
        boolean length = false;
        try {
            int overallLength = 0;
            boolean currentLength = false;
            this.progress.setValue(0);
            FtpBean ftp = new FtpBean();
            ftp.ftpConnect(this.FTP_SERVER, "anonymous");
            ftp.setDirectory(this.REPOSITORY_ROOT);
            FtpListResult list = ftp.getDirectoryContent();
            while (list.next()) {
                if (!list.getName().equals(file)) continue;
                overallLength = (int)list.getSize();
            }
            this.progress.setUnits(overallLength);
            this.listener.reset();
            this.listener.setMax(overallLength);
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(dest));
            bos.write(ftp.getBinaryFile(file, (FtpObserver)this.listener), 0, overallLength);
            bos.flush();
            bos.close();
            ftp.close();
        }
        catch (Exception ioe) {
            this.progress.dispose();
            ioe.printStackTrace();
            JOptionPane.showMessageDialog(this.frame, "<html>An Error occured when downloading " + file + ".<br>The update request cannot be fulfilled.</html>", "BN Update Download Error", 0);
            return false;
        }
        return true;
    }

    private boolean extractZipFile(File outputFile) {
        this.progress.setTitle("Extracting zip file");
        this.progress.setDescription("Extracting zip file: " + outputFile.getAbsolutePath());
        try {
            ZipFile zipFile = new ZipFile(outputFile);
            this.progress.setUnits(zipFile.size());
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            File baseDir = outputFile.getParentFile();
            byte[] buffer = new byte[this.BUFFERSIZE];
            int length = 0;
            int cnt = 0;
            while (entries.hasMoreElements()) {
                this.progress.setValue(cnt);
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory()) {
                    ++cnt;
                    continue;
                }
                String entryName = entry.getName();
                String entryFolder = new File(entryName).getParent();
                File entryDirectory = new File(baseDir.getAbsolutePath() + "/" + entryFolder);
                if (!entryDirectory.exists()) {
                    entryDirectory.mkdirs();
                }
                BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(baseDir.getAbsolutePath() + "/" + entry.getName()));
                BufferedInputStream bis = new BufferedInputStream(zipFile.getInputStream(entry));
                while ((length = bis.read(buffer, 0, this.BUFFERSIZE)) > 0) {
                    bos.write(buffer, 0, length);
                }
                ++cnt;
                bos.flush();
                bos.close();
                bis.close();
            }
        }
        catch (Exception e) {
            this.progress.dispose();
            e.printStackTrace();
            JOptionPane.showMessageDialog(this.frame, "<html>An Error occured when extracting " + outputFile.getAbsolutePath() + ".<br>The update request cannot be fulfilled.</html>", "BN Update Download Error", 0);
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
    }

    private class ProgressListener
    extends DialogListener
    implements WindowListener,
    FtpObserver {
        private int maxProgress = 0;
        private int currProgress = 0;
        private boolean isStopped = false;

        private ProgressListener() {
        }

        public void setMax(int max) {
            this.maxProgress = 0;
        }

        public void reset() {
            this.maxProgress = 0;
            this.currProgress = 0;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("cancel-command")) {
                this.isStopped = true;
                BNDownloadManager.this.progress.dispose();
            }
        }

        @Override
        public void windowClosing(WindowEvent e) {
            this.isStopped = true;
            BNDownloadManager.this.progress.dispose();
        }

        public void byteRead(int bytes) {
            this.currProgress += bytes;
            if (BNDownloadManager.this.progress != null) {
                BNDownloadManager.this.progress.setValue(this.currProgress);
            }
        }

        public void byteWrite(int bytes) {
            this.currProgress += bytes;
            if (BNDownloadManager.this.progress != null) {
                BNDownloadManager.this.progress.setValue(bytes);
            }
        }

        public boolean isStopped() {
            return this.isStopped;
        }
    }

    private class Runner
    implements Runnable {
        private String file;

        public Runner(String file) {
            this.file = file;
        }

        @Override
        public void run() {
            BNDownloadManager.this.getBaseFiles(this.file);
        }
    }
}

