/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.bn;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.border.EtchedBorder;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.cgh.CGHGuiObj.CharmDialogs.ExampleFileFilter;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.impl.bn.BNConstants;
import org.tigr.microarray.mev.cluster.gui.impl.bn.PrepareArrayDataModule;
import org.tigr.util.StringSplitter;

public class BNClassificationEditor
extends JDialog {
    private int result = 2;
    final IFramework framework;
    IData data;
    boolean classifyGenes;
    private boolean stopHere = true;
    private boolean nextPressed = false;
    private boolean incompatible = false;
    private JTable BNClassTable;
    private BNClassTableModel kModel;
    private JMenuItem[] classItem;
    private JMenuItem[] labelsAscItem;
    private JMenuItem[] labelsDescItem;
    private JButton nextButton;
    private JButton cancelButton;
    private JButton loadButton;
    private JButton saveSettingsButton;
    private Object[][] origData;
    private final String basePath;
    private int numClasses;
    private int numExps;
    private int numGenes;
    private String[] fieldNames;
    private File labelFile = null;

    public BNClassificationEditor(IFramework framework, boolean classifyGenes, int numClasses, String path) {
        super(framework.getFrame(), true);
        int i;
        this.setTitle("Classification Editor: Assign Samples to group(s)");
        int width = 300;
        int height = 300;
        this.setBackground(Color.white);
        this.setDefaultCloseOperation(0);
        this.framework = framework;
        this.data = framework.getData();
        this.numGenes = this.data.getFeaturesSize();
        this.numExps = this.data.getFeaturesCount();
        this.fieldNames = this.data.getFieldNames();
        this.classifyGenes = classifyGenes;
        this.numClasses = numClasses;
        width = numClasses <= 1 ? 360 : (numClasses > 1 && numClasses <= 2 ? 390 : (numClasses > 2 && numClasses <= 3 ? 450 : (numClasses > 3 && numClasses <= 5 ? 550 : 600)));
        height = this.numExps <= 5 ? 200 : (this.numExps > 5 && this.numExps <= 10 ? 250 : (this.numExps > 10 && this.numExps <= 15 ? 300 : (this.numExps > 15 && this.numExps < 20 ? 350 : 450)));
        this.setBounds(0, 0, width, height);
        this.basePath = path + System.getProperty("file.separator");
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 1;
        JPanel pane = new JPanel();
        pane.setLayout(gridbag);
        JPanel tablePanel = new JPanel();
        GridBagLayout grid1 = new GridBagLayout();
        tablePanel.setLayout(grid1);
        this.kModel = new BNClassTableModel();
        this.BNClassTable = new JTable(this.kModel);
        this.BNClassTable.setAutoResizeMode(0);
        TableColumn column = null;
        for (int i2 = 0; i2 < this.kModel.getColumnCount(); ++i2) {
            column = this.BNClassTable.getColumnModel().getColumn(i2);
            if (i2 == this.kModel.getColumnCount() - 1) {
                column.setMinWidth(190);
                continue;
            }
            column.setMinWidth(30);
        }
        this.BNClassTable.setColumnModel(new BNClassTableColumnModel(this.BNClassTable.getColumnModel()));
        this.BNClassTable.getModel().addTableModelListener(new ClassSelectionListener());
        JScrollPane scroll = new JScrollPane(this.BNClassTable);
        this.buildConstraints(constraints, 0, 0, 1, 1, 100, 100);
        grid1.setConstraints(scroll, constraints);
        tablePanel.add(scroll);
        this.buildConstraints(constraints, 0, 0, 2, 1, 100, 90);
        gridbag.setConstraints(tablePanel, constraints);
        pane.add(tablePanel);
        final JFileChooser fc1 = new JFileChooser();
        final JFileChooser fc2 = new JFileChooser();
        ExampleFileFilter filter = new ExampleFileFilter("txt");
        fc2.setFileFilter((FileFilter)filter);
        String dataPath = TMEV.getDataPath();
        File pathFile = TMEV.getFile((String)"data/bn");
        if (dataPath != null && !(pathFile = new File(dataPath)).exists()) {
            pathFile = TMEV.getFile((String)"data/bn");
        }
        fc1.setCurrentDirectory(new File(this.basePath));
        fc1.setDialogTitle("Open Classification");
        fc2.setCurrentDirectory(new File(this.basePath));
        fc2.setDialogTitle("Save Classification");
        JPanel bottomPanel = new JPanel();
        bottomPanel.setBorder(new EtchedBorder());
        bottomPanel.setBackground(Color.white);
        GridBagLayout grid2 = new GridBagLayout();
        bottomPanel.setLayout(grid2);
        this.loadButton = new JButton("Load Settings");
        this.loadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int returnVal = fc1.showOpenDialog(BNClassificationEditor.this);
                if (returnVal == 0) {
                    File file = fc1.getSelectedFile();
                    BNClassificationEditor.this.loadFromFile(file);
                }
            }
        });
        this.saveSettingsButton = new JButton("Save Settings");
        this.saveSettingsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int returnVal = fc2.showOpenDialog(BNClassificationEditor.this);
                if (returnVal == 0) {
                    BNClassificationEditor.this.labelFile = fc2.getSelectedFile();
                }
            }
        });
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BNClassificationEditor.this.result = 2;
                BNClassificationEditor.this.dispose();
            }
        });
        this.nextButton = new JButton("OK");
        this.nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BNClassificationEditor.this.onOk();
            }
        });
        constraints.fill = 2;
        this.buildConstraints(constraints, 0, 0, 1, 1, 0, 0);
        grid2.setConstraints(this.loadButton, constraints);
        bottomPanel.add(this.loadButton);
        this.buildConstraints(constraints, 1, 0, 1, 1, 0, 0);
        grid2.setConstraints(this.saveSettingsButton, constraints);
        bottomPanel.add(this.saveSettingsButton);
        this.buildConstraints(constraints, 2, 0, 1, 1, 0, 0);
        grid2.setConstraints(this.cancelButton, constraints);
        bottomPanel.add(this.cancelButton);
        this.buildConstraints(constraints, 3, 0, 1, 1, 0, 0);
        grid2.setConstraints(this.nextButton, constraints);
        bottomPanel.add(this.nextButton);
        constraints.fill = 2;
        this.buildConstraints(constraints, 0, 1, 1, 1, 0, 0);
        gridbag.setConstraints(bottomPanel, constraints);
        pane.add(bottomPanel);
        this.setContentPane(pane);
        if (classifyGenes) {
            this.labelsAscItem = new JMenuItem[this.fieldNames.length];
            this.labelsDescItem = new JMenuItem[this.fieldNames.length];
            for (i = 0; i < this.fieldNames.length; ++i) {
                this.labelsAscItem[i] = new JMenuItem(this.fieldNames[i]);
                this.labelsDescItem[i] = new JMenuItem(this.fieldNames[i]);
            }
        } else {
            this.labelsAscItem = new JMenuItem[1];
            this.labelsAscItem[0] = new JMenuItem("Sample Name");
            this.labelsDescItem = new JMenuItem[1];
            this.labelsDescItem[0] = new JMenuItem("Sample Name");
        }
        for (i = 0; i < this.labelsAscItem.length; ++i) {
            this.labelsAscItem[i].addActionListener(new SortListener(true, false));
            this.labelsDescItem[i].addActionListener(new SortListener(false, false));
        }
        this.classItem = new JMenuItem[numClasses];
        for (i = 0; i < numClasses; ++i) {
            this.classItem[i] = new JMenuItem("Class " + (i + 1));
        }
        for (i = 0; i < this.classItem.length; ++i) {
            this.classItem[i].addActionListener(new AssignListener());
        }
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    protected void onOk() {
        this.result = 0;
        this.dispose();
    }

    public Properties tranSaveWeka(String binNum, String path, boolean bootStrap, int numIter) {
        return PrepareArrayDataModule.prepareArrayData(path + BNConstants.SEP + "wekaData", binNum, bootStrap, numIter, this.numClasses);
    }

    void buildConstraints(GridBagConstraints gbc, int gx, int gy, int gw, int gh, int wx, int wy) {
        gbc.gridx = gx;
        gbc.gridy = gy;
        gbc.gridwidth = gw;
        gbc.gridheight = gh;
        gbc.weightx = wx;
        gbc.weighty = wy;
    }

    public int showModal(boolean visible) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        super.setVisible(visible);
        return this.result;
    }

    public void sortByColumn(int column, boolean ascending, boolean originalOrder) {
        int j;
        int i;
        if (originalOrder) {
            int j2;
            int i2;
            Object[][] sortedData = new Object[this.kModel.getRowCount()][this.kModel.getColumnCount()];
            for (i2 = 0; i2 < sortedData.length; ++i2) {
                for (j2 = 0; j2 < sortedData[0].length; ++j2) {
                    sortedData[i2][j2] = this.origData[i2][j2];
                }
            }
            for (i2 = 0; i2 < sortedData.length; ++i2) {
                for (j2 = 0; j2 < sortedData[0].length; ++j2) {
                    this.kModel.setValueAt(sortedData[i2][j2], i2, j2);
                }
                this.validateTable(sortedData, i2);
            }
            return;
        }
        if (column < 0 || column > this.kModel.getColumnCount()) {
            return;
        }
        Object[][] sortedData = new Object[this.kModel.getRowCount()][this.kModel.getColumnCount()];
        Object[] sortFields = new SortableField[this.kModel.getRowCount()];
        for (int i3 = 0; i3 < sortFields.length; ++i3) {
            int origDataRow = (Integer)this.kModel.getValueAt(i3, 0);
            sortFields[i3] = new SortableField(origDataRow, column);
        }
        Arrays.sort(sortFields);
        int[] sortedIndices = new int[sortFields.length];
        for (i = 0; i < sortedIndices.length; ++i) {
            sortedIndices[i] = ((SortableField)sortFields[i]).getIndex();
        }
        if (!ascending) {
            sortedIndices = this.reverse(sortedIndices);
        }
        for (i = 0; i < sortedData.length; ++i) {
            for (j = 0; j < sortedData[i].length; ++j) {
                sortedData[i][j] = this.origData[sortedIndices[i]][j];
            }
        }
        for (i = 0; i < sortedData.length; ++i) {
            for (j = 0; j < sortedData[i].length; ++j) {
                this.kModel.setValueAt(sortedData[i][j], i, j);
            }
            this.validateTable(sortedData, i);
        }
        this.BNClassTable.removeRowSelectionInterval(0, this.BNClassTable.getRowCount() - 1);
    }

    private int[] reverse(int[] arr) {
        int[] revArr = new int[arr.length];
        int revCount = 0;
        int count = arr.length - 1;
        for (int i = 0; i < arr.length; ++i) {
            revArr[revCount] = arr[count];
            ++revCount;
            --count;
        }
        return revArr;
    }

    private void sortByClassification() {
        int j;
        int i;
        int i2;
        Vector[] classVectors = new Vector[this.numClasses];
        for (i2 = 0; i2 < classVectors.length; ++i2) {
            classVectors[i2] = new Vector();
        }
        block1: for (i2 = 0; i2 < this.kModel.getRowCount(); ++i2) {
            for (int j2 = 1; j2 <= this.numClasses; ++j2) {
                boolean b = (Boolean)this.kModel.getValueAt(i2, j2);
                if (!b) continue;
                classVectors[j2 - 1].add(new Integer(i2));
                continue block1;
            }
        }
        int[] sortedIndices = new int[this.kModel.getRowCount()];
        int counter = 0;
        for (int i3 = 0; i3 < classVectors.length; ++i3) {
            for (int j3 = 0; j3 < classVectors[i3].size(); ++j3) {
                sortedIndices[counter] = (Integer)classVectors[i3].get(j3);
                ++counter;
            }
        }
        Object[][] sortedData = new Object[this.kModel.getRowCount()][this.kModel.getColumnCount()];
        for (i = 0; i < sortedData.length; ++i) {
            for (j = 0; j < sortedData[0].length; ++j) {
                sortedData[i][j] = this.kModel.getValueAt(sortedIndices[i], j);
            }
        }
        for (i = 0; i < this.kModel.getRowCount(); ++i) {
            for (j = 0; j < this.kModel.getColumnCount(); ++j) {
                this.kModel.setValueAt(sortedData[i][j], i, j);
            }
            this.validateTable(sortedData, i);
        }
        this.BNClassTable.removeRowSelectionInterval(0, this.BNClassTable.getRowCount() - 1);
    }

    private void validateTable(Object[][] tabData, int row) {
        for (int i = 1; i <= this.numClasses; ++i) {
            boolean check = (Boolean)tabData[row][i];
            if (!check) continue;
            this.kModel.setValueAt(new Boolean(true), row, i);
            break;
        }
    }

    public void loadFromFile(File file) {
        Vector<Integer> indicesVector = new Vector<Integer>();
        Vector<Integer> classVector = new Vector<Integer>();
        try {
            BufferedReader buff = new BufferedReader(new FileReader(file));
            String line = new String();
            while ((line = buff.readLine()) != null) {
                StringSplitter st = new StringSplitter('\t');
                st.init(line);
                String currIndex = st.nextToken();
                indicesVector.add(new Integer(currIndex));
                String currClass = st.nextToken();
                classVector.add(new Integer(currClass));
            }
            for (int i = 0; i < indicesVector.size(); ++i) {
                int currInd = (Integer)indicesVector.get(i);
                int currCl = (Integer)classVector.get(i);
                if (currCl == -1) {
                    this.kModel.setValueAt(new Boolean(true), currInd, this.numClasses);
                    continue;
                }
                this.kModel.setValueAt(new Boolean(true), currInd, currCl);
            }
            this.showModal(true);
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this.framework.getFrame(), "Incompatible file!", "Error", 2);
            this.incompatible = true;
        }
    }

    public Vector[] getClassification() {
        Vector<Integer> indicesVector = new Vector<Integer>();
        Vector<Integer> classVector = new Vector<Integer>();
        Vector[] vectArray = new Vector[2];
        for (int i = 0; i < this.kModel.getRowCount(); ++i) {
            if (((Boolean)this.kModel.getValueAt(i, this.numClasses)).booleanValue()) continue;
            indicesVector.add((Integer)this.kModel.getValueAt(i, 0));
            classVector.add(new Integer(this.getClass(i)));
        }
        vectArray[0] = indicesVector;
        vectArray[1] = classVector;
        return vectArray;
    }

    public boolean isNextPressed() {
        return this.nextPressed;
    }

    private int getClass(int row) {
        int i;
        for (i = 1; i <= this.numClasses && !((Boolean)this.kModel.getValueAt(row, i)).booleanValue(); ++i) {
        }
        return i;
    }

    public boolean proceed() {
        return !this.stopHere;
    }

    public boolean fileIsIncompatible() {
        return this.incompatible;
    }

    public File getLabelFile() {
        return this.labelFile;
    }

    public BNClassTableModel getClassTableModel() {
        return (BNClassTableModel)this.BNClassTable.getModel();
    }

    static /* synthetic */ Object[][] access$602(BNClassificationEditor x0, Object[][] x1) {
        x0.origData = x1;
        return x1;
    }

    public class SortListener
    implements ActionListener {
        boolean asc;
        boolean origOrd;

        public SortListener(boolean asc, boolean origOrd) {
            this.asc = asc;
            this.origOrd = origOrd;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            Object source = evt.getSource();
            if (source instanceof JMenuItem) {
                String key = ((JMenuItem)source).getText();
                int colToSort = BNClassificationEditor.this.kModel.getColumnIndex(key);
                BNClassificationEditor.this.sortByColumn(colToSort, this.asc, this.origOrd);
            }
        }
    }

    public class AssignListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent evt) {
            Object source = evt.getSource();
            if (source instanceof JMenuItem) {
                String key = ((JMenuItem)source).getText();
                int classCol = BNClassificationEditor.this.kModel.getColumnIndex(key);
                int[] selectedRows = BNClassificationEditor.this.BNClassTable.getSelectedRows();
                int[] selectedIndices = new int[selectedRows.length];
                for (int i = 0; i < selectedRows.length; ++i) {
                    BNClassificationEditor.this.kModel.setValueAt(new Boolean(true), selectedRows[i], classCol);
                }
            }
        }
    }

    private class SortableField
    implements Comparable {
        private String field;
        private int index;

        SortableField(int index, int column) {
            this.index = index;
            this.field = (String)BNClassificationEditor.this.origData[index][column];
        }

        public int compareTo(Object other) {
            SortableField otherField = (SortableField)other;
            return this.field.compareTo(otherField.getField());
        }

        public int getIndex() {
            return this.index;
        }

        public String getField() {
            return this.field;
        }
    }

    class ClassSelectionListener
    implements TableModelListener {
        ClassSelectionListener() {
        }

        @Override
        public void tableChanged(TableModelEvent tme) {
            int selectedCol = tme.getColumn();
            int selectedRow = tme.getFirstRow();
            if (selectedCol < 1 || selectedCol > BNClassificationEditor.this.numClasses) {
                return;
            }
            if (this.verifySelected(selectedRow, selectedCol)) {
                this.changeNeighbors(selectedRow, selectedCol);
            }
            int origDataRow = (Integer)BNClassificationEditor.this.kModel.getValueAt(selectedRow, 0);
            ((BNClassificationEditor)BNClassificationEditor.this).origData[origDataRow][selectedCol] = new Boolean(true);
            for (int i = 1; i <= BNClassificationEditor.this.numClasses; ++i) {
                if (i == selectedCol) continue;
                ((BNClassificationEditor)BNClassificationEditor.this).origData[origDataRow][i] = new Boolean(false);
            }
        }

        private void changeNeighbors(int first, int col) {
            for (int i = 1; i <= BNClassificationEditor.this.numClasses; ++i) {
                if (i == col) continue;
                BNClassificationEditor.this.BNClassTable.setValueAt(new Boolean(false), first, i);
            }
        }

        private boolean verifySelected(int row, int col) {
            boolean selVal = (Boolean)BNClassificationEditor.this.BNClassTable.getValueAt(row, col);
            if (selVal) {
                return true;
            }
            Vector<Boolean> truthValues = new Vector<Boolean>();
            for (int i = 1; i <= BNClassificationEditor.this.numClasses; ++i) {
                if (i == col) continue;
                boolean value = (Boolean)BNClassificationEditor.this.BNClassTable.getValueAt(row, i);
                truthValues.add(new Boolean(value));
            }
            boolean val1 = true;
            for (int i = 0; i < truthValues.size(); ++i) {
                boolean val2 = (Boolean)truthValues.get(i);
                if (!val2) continue;
                val1 = false;
                break;
            }
            if (val1) {
                BNClassificationEditor.this.BNClassTable.setValueAt(new Boolean(true), row, col);
            }
            return false;
        }
    }

    class BNClassTableColumnModel
    implements TableColumnModel {
        TableColumnModel tcm;

        public BNClassTableColumnModel(TableColumnModel TCM) {
            this.tcm = TCM;
        }

        @Override
        public void addColumn(TableColumn tableColumn) {
            this.tcm.addColumn(tableColumn);
        }

        @Override
        public void addColumnModelListener(TableColumnModelListener tableColumnModelListener) {
            this.tcm.addColumnModelListener(tableColumnModelListener);
        }

        @Override
        public TableColumn getColumn(int param) {
            return this.tcm.getColumn(param);
        }

        @Override
        public int getColumnCount() {
            return this.tcm.getColumnCount();
        }

        @Override
        public int getColumnIndex(Object obj) {
            return this.tcm.getColumnIndex(obj);
        }

        @Override
        public int getColumnIndexAtX(int param) {
            return this.tcm.getColumnIndexAtX(param);
        }

        @Override
        public int getColumnMargin() {
            return this.tcm.getColumnMargin();
        }

        @Override
        public boolean getColumnSelectionAllowed() {
            return this.tcm.getColumnSelectionAllowed();
        }

        public Enumeration getColumns() {
            return this.tcm.getColumns();
        }

        @Override
        public int getSelectedColumnCount() {
            return this.tcm.getSelectedColumnCount();
        }

        @Override
        public int[] getSelectedColumns() {
            return this.tcm.getSelectedColumns();
        }

        @Override
        public ListSelectionModel getSelectionModel() {
            return this.tcm.getSelectionModel();
        }

        @Override
        public int getTotalColumnWidth() {
            return this.tcm.getTotalColumnWidth();
        }

        @Override
        public void moveColumn(int from, int to) {
            if (from <= BNClassificationEditor.this.numClasses || to <= BNClassificationEditor.this.numClasses) {
                return;
            }
            this.tcm.moveColumn(from, to);
        }

        @Override
        public void removeColumn(TableColumn tableColumn) {
            this.tcm.removeColumn(tableColumn);
        }

        @Override
        public void removeColumnModelListener(TableColumnModelListener tableColumnModelListener) {
            this.tcm.removeColumnModelListener(tableColumnModelListener);
        }

        @Override
        public void setColumnMargin(int param) {
            this.tcm.setColumnMargin(param);
        }

        @Override
        public void setColumnSelectionAllowed(boolean param) {
            this.tcm.setColumnSelectionAllowed(param);
        }

        @Override
        public void setSelectionModel(ListSelectionModel listSelectionModel) {
            this.tcm.setSelectionModel(listSelectionModel);
        }
    }

    class BNClassTableModel
    extends AbstractTableModel {
        String[] columnNames;
        Object[][] tableData;
        int indexLastClass;

        public BNClassTableModel() {
            int j;
            int i;
            this.indexLastClass = BNClassificationEditor.this.numClasses - 1;
            if (BNClassificationEditor.this.classifyGenes) {
                this.columnNames = new String[BNClassificationEditor.this.fieldNames.length + BNClassificationEditor.this.numClasses + 1];
                this.columnNames[0] = "Index";
                for (i = 0; i < BNClassificationEditor.this.numClasses; ++i) {
                    this.columnNames[i + 1] = "Class " + (i + 1);
                }
                for (i = 0; i < BNClassificationEditor.this.fieldNames.length; ++i) {
                    this.columnNames[((BNClassificationEditor)BNClassificationEditor.this).numClasses + 1 + i] = BNClassificationEditor.this.fieldNames[i];
                }
                this.tableData = new Object[BNClassificationEditor.this.numGenes][this.columnNames.length];
                for (i = 0; i < this.tableData.length; ++i) {
                    for (j = 0; j < this.columnNames.length; ++j) {
                        this.tableData[i][j] = j == 0 ? new Integer(i) : (j > 0 && j < BNClassificationEditor.this.numClasses ? new Boolean(false) : (j == BNClassificationEditor.this.numClasses ? new Boolean(true) : BNClassificationEditor.this.data.getElementAttribute(i, j - (BNClassificationEditor.this.numClasses + 1))));
                    }
                }
            } else {
                this.columnNames = new String[BNClassificationEditor.this.numClasses + 2];
                this.columnNames[0] = "Index";
                for (i = 0; i < BNClassificationEditor.this.numClasses; ++i) {
                    this.columnNames[i + 1] = "Class " + (i + 1);
                }
                this.columnNames[((BNClassificationEditor)BNClassificationEditor.this).numClasses + 1] = "Sample Name";
                this.tableData = new Object[BNClassificationEditor.this.numExps][this.columnNames.length];
                for (i = 0; i < this.tableData.length; ++i) {
                    for (j = 0; j < this.columnNames.length; ++j) {
                        if (j == 0) {
                            this.tableData[i][j] = new Integer(i);
                            continue;
                        }
                        if (j > 0 && j < BNClassificationEditor.this.numClasses) {
                            this.tableData[i][j] = new Boolean(false);
                            continue;
                        }
                        if (j == BNClassificationEditor.this.numClasses) {
                            this.tableData[i][j] = new Boolean(true);
                            continue;
                        }
                        if (j != BNClassificationEditor.this.numClasses + 1) continue;
                        this.tableData[i][j] = BNClassificationEditor.this.data.getFullSampleName(i);
                    }
                }
            }
            BNClassificationEditor.access$602(BNClassificationEditor.this, new Object[this.tableData.length][this.tableData[0].length]);
            for (i = 0; i < this.tableData.length; ++i) {
                for (j = 0; j < this.tableData[0].length; ++j) {
                    ((BNClassificationEditor)BNClassificationEditor.this).origData[i][j] = this.tableData[i][j];
                }
            }
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.tableData.length;
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        public int getColumnIndex(String name) {
            int i;
            for (i = 0; i < this.columnNames.length && !this.columnNames[i].equals(name); ++i) {
            }
            if (i < this.columnNames.length) {
                return i;
            }
            return -1;
        }

        @Override
        public Object getValueAt(int row, int col) {
            return this.tableData[row][col];
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            this.tableData[row][col] = value;
            this.fireTableChanged(new TableModelEvent(this, row, row, col));
        }

        public Class getColumnClass(int c) {
            if (c == 0) {
                return Integer.class;
            }
            if (c > 0 && c <= BNClassificationEditor.this.numClasses) {
                return Boolean.class;
            }
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col > 0 && col <= BNClassificationEditor.this.numClasses;
        }
    }
}

