/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.betr;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.cluster.clusterUtil.ClusterRepository;
import org.tigr.microarray.mev.cluster.gui.helpers.ClusterSelector;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;

public class BETRInitBox
extends AlgorithmDialog {
    private static final long serialVersionUID = 1L;
    public static final int JUST_ALPHA = 1;
    public static final int STD_BONFERRONI = 2;
    public static final int ADJ_BONFERRONI = 3;
    public static final int MAX_T = 9;
    public static final int FALSE_NUM = 12;
    public static final int FALSE_PROP = 13;
    public static final int BUTTON_SELECTION = 14;
    public static final int CLUSTER_SELECTION = 15;
    boolean okPressed = false;
    boolean okReady = false;
    boolean step2 = false;
    Vector<String> exptNames;
    MultiClassPanel mPanel;
    JTabbedPane selectionPanel;
    PermOrFDistPanel permPanel;
    PValuePanel pPanel;
    HCLoptionPanel hclOpsPanel;
    ClusterRepository repository;
    JButton step2Button = new JButton("Continue...");

    public BETRInitBox(JFrame parentFrame, boolean modality, Vector<String> exptNames, ClusterRepository repository) {
        super(parentFrame, "BETR Initialization", modality);
        this.exptNames = exptNames;
        this.repository = repository;
        this.setBounds(0, 0, 1000, 850);
        this.setBackground(Color.white);
        this.setDefaultCloseOperation(2);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 1;
        JPanel pane = new JPanel();
        pane.setLayout(gridbag);
        this.okButton.setEnabled(false);
        this.mPanel = new MultiClassPanel();
        JTabbedPane consolidatedPane = new JTabbedPane();
        this.permPanel = new PermOrFDistPanel();
        consolidatedPane.add("Permutations of F-Distribution", this.permPanel);
        this.pPanel = new PValuePanel();
        consolidatedPane.add("P-Value/False Discovery Parameters", this.pPanel);
        this.buildConstraints(constraints, 0, 0, 1, 1, 100, 80);
        gridbag.setConstraints(this.mPanel, constraints);
        pane.add(this.mPanel);
        this.addContent(pane);
        EventListener listener = new EventListener();
        this.setActionListeners(listener);
        this.addWindowListener(listener);
    }

    @Override
    public void setVisible(boolean visible) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        super.setVisible(visible);
        if (visible) {
            // empty if block
        }
    }

    void buildConstraints(GridBagConstraints gbc, int gx, int gy, int gw, int gh, int wx, int wy) {
        gbc.gridx = gx;
        gbc.gridy = gy;
        gbc.gridwidth = gw;
        gbc.gridheight = gh;
        gbc.weightx = wx;
        gbc.weighty = wy;
    }

    public boolean isOkPressed() {
        return this.okPressed;
    }

    public void enableOK() {
        this.okButton.setEnabled(true);
    }

    public boolean drawTrees() {
        return this.hclOpsPanel.isHCLSelected();
    }

    public boolean drawSigTreesOnly() {
        return this.hclOpsPanel.drawSigTreesOnly();
    }

    public int[] getTimeAssignments() {
        int[] timeAssignments = new int[this.exptNames.size()];
        block0: for (int i = 0; i < this.exptNames.size(); ++i) {
            if (this.mPanel.mulgPanel.notInTimeGroupRadioButtons[i].isSelected()) {
                timeAssignments[i] = 0;
                continue;
            }
            for (int j = 0; j < this.mPanel.mulgPanel.exptTimeRadioButtons.length; ++j) {
                if (!this.mPanel.mulgPanel.exptTimeRadioButtons[j][i].isSelected()) continue;
                timeAssignments[i] = j + 1;
                continue block0;
            }
        }
        return timeAssignments;
    }

    public int[][] getTimeMatrix() {
        int[] timeAssignments = this.getTestDesign() == 15 ? this.getClusterTimeAssignments() : this.getTimeAssignments();
        int[] numEachTime = new int[this.getNumTimePoints()];
        for (int i = 0; i < timeAssignments.length; ++i) {
            if (timeAssignments[i] == 0) continue;
            int n = timeAssignments[i] - 1;
            numEachTime[n] = numEachTime[n] + 1;
        }
        int[][] timeMatrix = new int[this.getNumTimePoints()][];
        for (int i = 0; i < this.getNumTimePoints(); ++i) {
            timeMatrix[i] = new int[numEachTime[i]];
        }
        int[] nextEntry = new int[this.getNumTimePoints()];
        for (int i = 0; i < timeAssignments.length; ++i) {
            if (timeAssignments[i] == 0) continue;
            timeMatrix[timeAssignments[i] - 1][nextEntry[timeAssignments[i] - 1]] = i;
            int n = timeAssignments[i] - 1;
            nextEntry[n] = nextEntry[n] + 1;
        }
        return timeMatrix;
    }

    public int[][] getConditionsMatrix() {
        int[] conditionAssignments = this.getTestDesign() == 15 ? this.getClusterConditionAssignments() : this.getConditionAssignments();
        int[] numEachTime = new int[2];
        for (int i = 0; i < conditionAssignments.length; ++i) {
            if (conditionAssignments[i] == 0) continue;
            numEachTime[conditionAssignments[i] - 1] = numEachTime[conditionAssignments[i] - 1] + 1;
        }
        Object conditionMatrix = null;
        if (this.getDataDesign() == 2) {
            conditionMatrix = new int[2][];
            for (int i = 0; i < 2; ++i) {
                conditionMatrix[i] = new int[numEachTime[i]];
            }
            int[] nextEntry = new int[this.getNumTimePoints()];
            for (int i = 0; i < conditionAssignments.length; ++i) {
                if (conditionAssignments[i] == 0) continue;
                conditionMatrix[conditionAssignments[i] - 1][nextEntry[conditionAssignments[i] - 1]] = i;
                int n = conditionAssignments[i] - 1;
                nextEntry[n] = nextEntry[n] + 1;
            }
        } else {
            conditionMatrix = this.getDataDesign() == 1 ? (int[][])null : (int[][])null;
        }
        return conditionMatrix;
    }

    public int[] getConditionAssignments() {
        int[] conditionAssignments = new int[this.exptNames.size()];
        block0: for (int i = 0; i < this.exptNames.size(); ++i) {
            if (this.mPanel.mulgPanel.notInTimeGroupRadioButtons[i].isSelected()) {
                conditionAssignments[i] = 0;
                continue;
            }
            for (int j = 0; j < this.mPanel.mulgPanel.exptConditionRadioButtons.length; ++j) {
                if (!this.mPanel.mulgPanel.exptConditionRadioButtons[j][i].isSelected()) continue;
                conditionAssignments[i] = j + 1;
                continue block0;
            }
        }
        return conditionAssignments;
    }

    public int getDataDesign() {
        int design = -1;
        if (this.mPanel.ngPanel.oneCondition.isSelected()) {
            design = 1;
        }
        if (this.mPanel.ngPanel.twoConditions.isSelected()) {
            design = 2;
        }
        if (this.mPanel.ngPanel.pairedData.isSelected()) {
            design = 3;
        }
        return design;
    }

    public int getTestDesign() {
        int design = -1;
        design = this.mPanel.tabbedmulg.getSelectedIndex() == 0 ? 14 : 15;
        return design;
    }

    public int[] getClusterTimeAssignments() {
        int j;
        int i;
        int[] groupAssignments = new int[this.exptNames.size()];
        ArrayList[] arraylistArray = new ArrayList[this.mPanel.numTimePoints];
        for (i = 0; i < this.mPanel.numTimePoints; ++i) {
            j = i + 1;
            arraylistArray[i] = this.mPanel.clusterSelectorTime.getGroupSamples("Time " + j);
        }
        for (i = 0; i < this.exptNames.size(); ++i) {
            boolean doubleAssigned = false;
            groupAssignments[i] = 0;
            for (j = 0; j < this.mPanel.numTimePoints; ++j) {
                if (!arraylistArray[j].contains(i)) continue;
                if (doubleAssigned) {
                    Object[] optionst = new Object[]{"OK"};
                    JOptionPane.showOptionDialog(null, "The clusters you have chosen have overlapping samples. \n Each group must contain unique samples.", "Multiple Ownership Error", 1, 3, null, optionst, optionst[0]);
                    return null;
                }
                groupAssignments[i] = j + 1;
                doubleAssigned = true;
            }
        }
        return groupAssignments;
    }

    public int[] getClusterConditionAssignments() {
        int j;
        int i;
        int[] groupAssignments = new int[this.exptNames.size()];
        ArrayList[] arraylistArray = new ArrayList[2];
        for (i = 0; i < 2; ++i) {
            j = i + 1;
            arraylistArray[i] = this.mPanel.clusterSelectorCondition.getGroupSamples("Condition " + j);
        }
        for (i = 0; i < this.exptNames.size(); ++i) {
            boolean doubleAssigned = false;
            groupAssignments[i] = 0;
            for (j = 0; j < 2; ++j) {
                if (!arraylistArray[j].contains(i)) continue;
                if (doubleAssigned) {
                    Object[] optionst = new Object[]{"OK"};
                    JOptionPane.showOptionDialog(null, "The clusters you have chosen have overlapping samples. \n Each group must contain unique samples.", "Multiple Ownership Error", 1, 3, null, optionst, optionst[0]);
                    return null;
                }
                groupAssignments[i] = j + 1;
                doubleAssigned = true;
            }
        }
        return groupAssignments;
    }

    public int getNumTimePoints() {
        return this.mPanel.numTimePoints;
    }

    public boolean usePerms() {
        return this.permPanel.permutButton.isSelected();
    }

    public int getNumPerms() {
        return Integer.parseInt(this.permPanel.timesField.getText());
    }

    public double getPValue() {
        return Double.parseDouble(this.pPanel.pValueInputField.getText());
    }

    public float getAlpha() {
        return Float.parseFloat(this.mPanel.ngPanel.alphaField.getText());
    }

    public int getFalseNum() {
        return Integer.parseInt(this.pPanel.falseNumField.getText());
    }

    public double getFalseProp() {
        return Double.parseDouble(this.pPanel.falsePropField.getText());
    }

    public boolean validateFalseNum() {
        int a;
        try {
            String falseNum = this.pPanel.falseNumField.getText();
            a = Integer.parseInt(falseNum);
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this, "False number must be an integer >= 0", "Input Error", 2);
            this.pPanel.falseNumField.requestFocus();
            this.pPanel.falseNumField.selectAll();
            return false;
        }
        if (a < 0) {
            JOptionPane.showMessageDialog(this, "False number must be an integer >= 0", "Input Error", 2);
            this.pPanel.falseNumField.requestFocus();
            this.pPanel.falseNumField.selectAll();
            return false;
        }
        return true;
    }

    public boolean validateFalseProp() {
        float a;
        try {
            String falseProp = this.pPanel.falsePropField.getText();
            a = Float.parseFloat(falseProp);
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this, "False proportion must be between 0 and 1", "Input Error", 2);
            this.pPanel.falsePropField.requestFocus();
            this.pPanel.falsePropField.selectAll();
            return false;
        }
        if (a <= 0.0f || a > 1.0f) {
            JOptionPane.showMessageDialog(this, "False proportion must be between 0 and 1", "Input Error", 2);
            this.pPanel.falsePropField.requestFocus();
            this.pPanel.falsePropField.selectAll();
            return false;
        }
        return true;
    }

    public int getCorrectionMethod() {
        int method = 1;
        if (this.pPanel.justAlphaButton.isSelected()) {
            method = 1;
        } else if (this.pPanel.stdBonfButton.isSelected()) {
            method = 2;
        } else if (this.pPanel.adjBonfButton.isSelected()) {
            method = 3;
        } else if (this.pPanel.maxTButton.isSelected()) {
            method = 9;
        } else if (this.pPanel.falseNumButton.isSelected()) {
            method = 12;
        } else if (this.pPanel.falsePropButton.isSelected()) {
            method = 13;
        }
        return method;
    }

    public static void main(String[] args) {
        JFrame dummyFrame = new JFrame();
        Vector<String> dummyVect = new Vector<String>();
        for (int i = 0; i < 24; ++i) {
            dummyVect.add("Expt " + i);
        }
        BETRInitBox oBox = new BETRInitBox(dummyFrame, true, dummyVect, null);
        oBox.setVisible(true);
    }

    public class EventListener
    extends WindowAdapter
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent ae) {
            block31: {
                String command = ae.getActionCommand();
                if (command.equals("ok-command")) {
                    int[] timeAssignments;
                    if (!BETRInitBox.this.okReady) {
                        return;
                    }
                    if (BETRInitBox.this.getTestDesign() == 15 && BETRInitBox.this.repository.isEmpty()) {
                        JOptionPane.showMessageDialog(null, "Cluster Repository is Empty.", "Error", 2);
                        return;
                    }
                    boolean tooFew = false;
                    if (BETRInitBox.this.getDataDesign() == 2) {
                        timeAssignments = BETRInitBox.this.getTimeAssignments();
                        int[] conditionAssignments = BETRInitBox.this.getConditionAssignments();
                        if (BETRInitBox.this.getTestDesign() == 15) {
                            timeAssignments = BETRInitBox.this.getClusterTimeAssignments();
                            conditionAssignments = BETRInitBox.this.getClusterConditionAssignments();
                        }
                        if (timeAssignments == null) {
                            return;
                        }
                        if (conditionAssignments == null) {
                            return;
                        }
                        int numTimePoints = BETRInitBox.this.getNumTimePoints();
                        int[] timePointGroupSize = new int[numTimePoints];
                        block2: for (int condition = 0; condition < 2; ++condition) {
                            int i;
                            for (i = 0; i < timePointGroupSize.length; ++i) {
                                timePointGroupSize[i] = 0;
                            }
                            for (i = 0; i < timeAssignments.length; ++i) {
                                int currentGroup = timeAssignments[i];
                                if (currentGroup == 0 || conditionAssignments[i] != condition + 1) continue;
                                int n = currentGroup - 1;
                                timePointGroupSize[n] = timePointGroupSize[n] + 1;
                            }
                            for (i = 0; i < timePointGroupSize.length; ++i) {
                                if (timePointGroupSize[i] >= 2) continue;
                                int ci = 0;
                                if (BETRInitBox.this.getTestDesign() == 15) {
                                    ci = 1;
                                }
                                JOptionPane.showMessageDialog(null, "Each condition must have at least two samples for each time point. \n \nCondition " + (condition + 1) + ", time point " + (i + ci) + " has " + timePointGroupSize[i] + " samples(s).", "Error: Insufficient Data", 2);
                                tooFew = true;
                                continue block2;
                            }
                        }
                    }
                    if (BETRInitBox.this.getDataDesign() == 1 || BETRInitBox.this.getDataDesign() == 3) {
                        int i;
                        timeAssignments = BETRInitBox.this.getTimeAssignments();
                        if (BETRInitBox.this.getTestDesign() == 15) {
                            timeAssignments = BETRInitBox.this.getClusterTimeAssignments();
                        }
                        if (timeAssignments == null) {
                            return;
                        }
                        int numTimePoints = BETRInitBox.this.getNumTimePoints();
                        int[] timePointGroupSize = new int[numTimePoints];
                        for (i = 0; i < timePointGroupSize.length; ++i) {
                            timePointGroupSize[i] = 0;
                        }
                        for (i = 0; i < timeAssignments.length; ++i) {
                            int currentGroup = timeAssignments[i];
                            if (currentGroup == 0) continue;
                            int n = currentGroup - 1;
                            timePointGroupSize[n] = timePointGroupSize[n] + 1;
                        }
                        for (i = 0; i < timePointGroupSize.length; ++i) {
                            if (timePointGroupSize[i] >= 2) continue;
                            int ci = 0;
                            if (BETRInitBox.this.getTestDesign() == 15) {
                                ci = 1;
                            }
                            JOptionPane.showMessageDialog(null, "Each condition must have at least two samples for each time point. \n \nTime point " + (i + ci) + " has " + timePointGroupSize[i] + " samples(s).", "Error: Insufficient Data", 2);
                            tooFew = true;
                            break;
                        }
                    }
                    if (!tooFew) {
                        try {
                            if (BETRInitBox.this.pPanel.falseNumButton.isSelected() && !BETRInitBox.this.validateFalseNum()) {
                                BETRInitBox.this.okPressed = false;
                                return;
                            }
                            if (BETRInitBox.this.pPanel.falsePropButton.isSelected() && !BETRInitBox.this.validateFalseProp()) {
                                BETRInitBox.this.okPressed = false;
                                return;
                            }
                            double d = Double.parseDouble(BETRInitBox.this.pPanel.pValueInputField.getText());
                            if (d <= 0.0 || d > 1.0 || BETRInitBox.this.usePerms() && BETRInitBox.this.getNumPerms() <= 1) {
                                JOptionPane.showMessageDialog(null, "Valid inputs: 0 < alpha < 1, and # of permutations (integer only) > 1", "Error!", 0);
                                break block31;
                            }
                            BETRInitBox.this.okPressed = true;
                            BETRInitBox.this.dispose();
                        }
                        catch (NumberFormatException nfe) {
                            JOptionPane.showMessageDialog(null, "Valid inputs: 0 < alpha < 1, and # of permutations (integer only) > 1", "Error!", 0);
                        }
                    }
                } else if (command.equals("reset-command")) {
                    BETRInitBox.this.mPanel.reset();
                    BETRInitBox.this.pPanel.reset();
                } else if (command.equals("cancel-command")) {
                    BETRInitBox.this.okPressed = false;
                    BETRInitBox.this.dispose();
                } else if (command.equals("info-command")) {
                    HelpWindow.launchBrowser(BETRInitBox.this, "Bayesian Estimation of Temporal Regulation- Initialization Dialog");
                }
            }
        }
    }

    class PValuePanel
    extends JPanel {
        JTextField pValueInputField;
        JTextField falseNumField;
        JTextField falsePropField;
        JRadioButton justAlphaButton;
        JRadioButton stdBonfButton;
        JRadioButton adjBonfButton;
        JRadioButton maxTButton;
        JRadioButton falseNumButton;
        JRadioButton falsePropButton;

        public PValuePanel() {
            this.setBorder(new TitledBorder(new EtchedBorder(), "P-value / false discovery parameters", 0, 0, new Font("Dialog", 1, 12), Color.black));
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints constraints = new GridBagConstraints();
            this.setBackground(Color.white);
            this.setLayout(gridbag);
            JLabel pValueLabel = new JLabel("Enter alpha (critical p-value): ");
            BETRInitBox.this.buildConstraints(constraints, 0, 0, 1, 1, 33, 25);
            constraints.anchor = 13;
            gridbag.setConstraints(pValueLabel, constraints);
            this.add(pValueLabel);
            this.pValueInputField = new JTextField("0.01", 7);
            BETRInitBox.this.buildConstraints(constraints, 1, 0, 1, 1, 33, 0);
            constraints.anchor = 17;
            gridbag.setConstraints(this.pValueInputField, constraints);
            this.add(this.pValueInputField);
            constraints.anchor = 10;
            this.justAlphaButton = new JRadioButton("Just alpha (no correction)", true);
            this.justAlphaButton.setBackground(Color.white);
            this.stdBonfButton = new JRadioButton("Standard Bonferroni", false);
            this.stdBonfButton.setBackground(Color.white);
            this.adjBonfButton = new JRadioButton("Adjusted Bonferroni", false);
            this.adjBonfButton.setBackground(Color.white);
            this.maxTButton = new JRadioButton("Westfall-Young step-down maxT", false);
            this.maxTButton.setBackground(Color.white);
            this.maxTButton.setEnabled(false);
            this.falseNumButton = new JRadioButton("EITHER, The number of false significant genes should not exceed", false);
            this.falseNumButton.setEnabled(false);
            this.falseNumButton.setFocusPainted(false);
            this.falseNumButton.setForeground(UIManager.getColor("Label.foreground"));
            this.falseNumButton.setBackground(Color.white);
            this.falsePropButton = new JRadioButton("OR, The proportion of false significant genes should not exceed", false);
            this.falsePropButton.setEnabled(false);
            this.falsePropButton.setFocusPainted(false);
            this.falsePropButton.setForeground(UIManager.getColor("Label.foreground"));
            this.falsePropButton.setBackground(Color.white);
            this.falseNumField = new JTextField(10);
            this.falseNumField.setText("10");
            this.falseNumField.setEnabled(false);
            this.falsePropField = new JTextField(10);
            this.falsePropField.setText("0.05");
            this.falsePropField.setEnabled(false);
            ButtonGroup chooseCorrection = new ButtonGroup();
            chooseCorrection.add(this.justAlphaButton);
            chooseCorrection.add(this.stdBonfButton);
            chooseCorrection.add(this.adjBonfButton);
            chooseCorrection.add(this.maxTButton);
            chooseCorrection.add(this.falseNumButton);
            chooseCorrection.add(this.falsePropButton);
            JPanel FDRPanel = new JPanel();
            FDRPanel.setBackground(Color.white);
            FDRPanel.setBorder(new TitledBorder(new EtchedBorder(1), "False discovery control (permutations only)", 0, 0, new Font("Dialog", 1, 12), Color.black));
            GridBagLayout grid3 = new GridBagLayout();
            FDRPanel.setLayout(grid3);
            JLabel FDRLabel = new JLabel("With confidence of [1 - alpha] : ");
            constraints.anchor = 17;
            BETRInitBox.this.buildConstraints(constraints, 0, 0, 2, 1, 100, 34);
            grid3.setConstraints(FDRLabel, constraints);
            FDRPanel.add(FDRLabel);
            constraints.anchor = 10;
            BETRInitBox.this.buildConstraints(constraints, 0, 1, 1, 1, 50, 33);
            constraints.anchor = 13;
            grid3.setConstraints(this.falseNumButton, constraints);
            FDRPanel.add(this.falseNumButton);
            BETRInitBox.this.buildConstraints(constraints, 1, 1, 1, 1, 50, 0);
            constraints.anchor = 17;
            grid3.setConstraints(this.falseNumField, constraints);
            FDRPanel.add(this.falseNumField);
            BETRInitBox.this.buildConstraints(constraints, 0, 2, 1, 1, 50, 33);
            constraints.anchor = 13;
            grid3.setConstraints(this.falsePropButton, constraints);
            FDRPanel.add(this.falsePropButton);
            BETRInitBox.this.buildConstraints(constraints, 1, 2, 1, 1, 50, 0);
            constraints.anchor = 17;
            grid3.setConstraints(this.falsePropField, constraints);
            FDRPanel.add(this.falsePropField);
            constraints.anchor = 10;
            BETRInitBox.this.buildConstraints(constraints, 0, 1, 1, 1, 25, 25);
            gridbag.setConstraints(this.justAlphaButton, constraints);
            this.add(this.justAlphaButton);
            BETRInitBox.this.buildConstraints(constraints, 1, 1, 1, 1, 25, 0);
            gridbag.setConstraints(this.stdBonfButton, constraints);
            this.add(this.stdBonfButton);
            BETRInitBox.this.buildConstraints(constraints, 2, 1, 1, 1, 25, 0);
            gridbag.setConstraints(this.adjBonfButton, constraints);
            this.add(this.adjBonfButton);
            BETRInitBox.this.buildConstraints(constraints, 3, 1, 1, 1, 25, 0);
            gridbag.setConstraints(this.maxTButton, constraints);
            this.add(this.maxTButton);
            BETRInitBox.this.buildConstraints(constraints, 0, 2, 4, 1, 100, 50);
            gridbag.setConstraints(FDRPanel, constraints);
            this.add(FDRPanel);
        }

        protected void reset() {
            this.pValueInputField.setText("0.01");
            this.justAlphaButton.setSelected(true);
        }
    }

    class PermOrFDistPanel
    extends JPanel {
        JRadioButton tDistButton;
        JRadioButton permutButton;
        JLabel numPermsLabel;
        JTextField timesField;

        PermOrFDistPanel() {
            this.setBorder(new TitledBorder(new EtchedBorder(1), "Permutations or F-distribution", 0, 0, new Font("Dialog", 1, 12), Color.black));
            this.setBackground(Color.white);
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints constraints = new GridBagConstraints();
            this.setLayout(gridbag);
            ButtonGroup chooseP = new ButtonGroup();
            this.tDistButton = new JRadioButton("p-values based on F-distribution", true);
            this.tDistButton.setFocusPainted(false);
            this.tDistButton.setForeground(UIManager.getColor("Label.foreground"));
            this.tDistButton.setBackground(Color.white);
            this.numPermsLabel = new JLabel("Enter number of permutations");
            this.numPermsLabel.setEnabled(false);
            this.timesField = new JTextField("1000", 7);
            this.timesField.setEnabled(false);
            this.timesField.setBackground(Color.darkGray);
            this.tDistButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    PermOrFDistPanel.this.numPermsLabel.setEnabled(false);
                    PermOrFDistPanel.this.timesField.setEnabled(false);
                    PermOrFDistPanel.this.timesField.setBackground(Color.darkGray);
                    if (BETRInitBox.this.pPanel.maxTButton.isSelected() || BETRInitBox.this.pPanel.falseNumButton.isSelected() || BETRInitBox.this.pPanel.falsePropButton.isSelected()) {
                        BETRInitBox.this.pPanel.justAlphaButton.setSelected(true);
                    }
                    BETRInitBox.this.pPanel.maxTButton.setEnabled(false);
                    BETRInitBox.this.pPanel.falseNumButton.setEnabled(false);
                    BETRInitBox.this.pPanel.falsePropButton.setEnabled(false);
                    BETRInitBox.this.pPanel.falseNumField.setEnabled(false);
                    BETRInitBox.this.pPanel.falsePropField.setEnabled(false);
                }
            });
            chooseP.add(this.tDistButton);
            this.permutButton = new JRadioButton("p-values based on permutation:  ", false);
            this.permutButton.setFocusPainted(false);
            this.permutButton.setForeground(UIManager.getColor("Label.foreground"));
            this.permutButton.setBackground(Color.white);
            this.permutButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    PermOrFDistPanel.this.numPermsLabel.setEnabled(true);
                    PermOrFDistPanel.this.timesField.setEnabled(true);
                    PermOrFDistPanel.this.timesField.setBackground(Color.white);
                    BETRInitBox.this.pPanel.maxTButton.setEnabled(true);
                    BETRInitBox.this.pPanel.falseNumButton.setEnabled(true);
                    BETRInitBox.this.pPanel.falsePropButton.setEnabled(true);
                    BETRInitBox.this.pPanel.falseNumField.setEnabled(true);
                    BETRInitBox.this.pPanel.falsePropField.setEnabled(true);
                }
            });
            chooseP.add(this.permutButton);
            BETRInitBox.this.buildConstraints(constraints, 0, 0, 3, 1, 100, 50);
            constraints.anchor = 17;
            gridbag.setConstraints(this.tDistButton, constraints);
            this.add(this.tDistButton);
            BETRInitBox.this.buildConstraints(constraints, 0, 1, 1, 1, 30, 50);
            constraints.anchor = 17;
            gridbag.setConstraints(this.permutButton, constraints);
            this.add(this.permutButton);
            BETRInitBox.this.buildConstraints(constraints, 1, 1, 1, 1, 30, 0);
            gridbag.setConstraints(this.numPermsLabel, constraints);
            this.add(this.numPermsLabel);
            BETRInitBox.this.buildConstraints(constraints, 2, 1, 1, 1, 40, 0);
            gridbag.setConstraints(this.timesField, constraints);
            this.add(this.timesField);
        }
    }

    class MultiClassPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        NumTimePointsPanel ngPanel;
        GridBagConstraints constraints = new GridBagConstraints();
        GridBagLayout gridbag = new GridBagLayout();
        JPanel dummyPanel;
        MultiGroupExperimentsPanel mulgPanel;
        JTabbedPane tabbedmulg;
        ClusterSelector clusterSelectorCondition;
        ClusterSelector clusterSelectorTime;
        JLabel infoLabel;
        JLabel infoLabel2;
        int numTimePoints;
        float alpha;

        public MultiClassPanel() {
            this.setBackground(Color.white);
            this.setLayout(this.gridbag);
            this.ngPanel = new NumTimePointsPanel();
            BETRInitBox.this.buildConstraints(this.constraints, 0, 0, 1, 1, 100, 10);
            this.constraints.fill = 1;
            this.gridbag.setConstraints(this.ngPanel, this.constraints);
            BETRInitBox.this.step2Button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    if (BETRInitBox.this.step2) {
                        MultiClassPanel.this.infoLabel.setVisible(true);
                        MultiClassPanel.this.infoLabel2.setVisible(true);
                        MultiClassPanel.this.ngPanel.numTimePointsField.setEnabled(true);
                        MultiClassPanel.this.ngPanel.alphaField.setEnabled(true);
                        MultiClassPanel.this.ngPanel.oneCondition.setEnabled(true);
                        MultiClassPanel.this.ngPanel.twoConditions.setEnabled(true);
                        MultiClassPanel.this.ngPanel.pairedData.setEnabled(true);
                        BETRInitBox.this.step2Button.setText("Continue...");
                        BETRInitBox.this.step2 = false;
                        MultiClassPanel.this.tabbedmulg.setVisible(false);
                        BETRInitBox.this.buildConstraints(MultiClassPanel.this.constraints, 0, 1, 2, 1, 0, 90);
                        MultiClassPanel.this.constraints.fill = 1;
                        BETRInitBox.this.buildConstraints(MultiClassPanel.this.constraints, 0, 3, 1, 1, 100, 90);
                        MultiClassPanel.this.gridbag.setConstraints(MultiClassPanel.this.dummyPanel, MultiClassPanel.this.constraints);
                        MultiClassPanel.this.add(MultiClassPanel.this.dummyPanel);
                        BETRInitBox.this.step2Button.setSelected(false);
                    } else {
                        MultiClassPanel.this.ngPanel.okPressed = true;
                        BETRInitBox.this.okReady = true;
                        try {
                            MultiClassPanel.this.alpha = Float.parseFloat(MultiClassPanel.this.ngPanel.alphaField.getText());
                            MultiClassPanel.this.numTimePoints = Integer.parseInt(MultiClassPanel.this.ngPanel.numTimePointsField.getText());
                            if (MultiClassPanel.this.alpha > 1.0f || MultiClassPanel.this.alpha < 0.0f) {
                                JOptionPane.showMessageDialog(null, "alpha must be between 0 and 1!", "Error", 0);
                            } else if (MultiClassPanel.this.numTimePoints < 2) {
                                JOptionPane.showMessageDialog(null, "Number of time points must be greater than 1!", "Error", 0);
                            } else {
                                MultiClassPanel.this.mulgPanel = new MultiGroupExperimentsPanel(BETRInitBox.this.exptNames, MultiClassPanel.this.numTimePoints, MultiClassPanel.this.ngPanel.getExperimentDesign());
                                MultiClassPanel.this.remove(MultiClassPanel.this.dummyPanel);
                                MultiClassPanel.this.tabbedmulg = new JTabbedPane();
                                MultiClassPanel.this.clusterSelectorCondition = new ClusterSelector(BETRInitBox.this.repository, 2, "Condition");
                                MultiClassPanel.this.clusterSelectorTime = new ClusterSelector(BETRInitBox.this.repository, MultiClassPanel.this.numTimePoints, "Time");
                                if (BETRInitBox.this.repository != null) {
                                    MultiClassPanel.this.clusterSelectorCondition.setClusterType("Condition");
                                    MultiClassPanel.this.clusterSelectorTime.setClusterType("Time Points");
                                }
                                JPanel clusterSelectorPanel = new JPanel();
                                clusterSelectorPanel.setLayout(new GridBagLayout());
                                String andconditions = "";
                                if (MultiClassPanel.this.ngPanel.getExperimentDesign() == 2) {
                                    andconditions = " and Conditions";
                                }
                                JLabel clusterInstructions = new JLabel("Use the drop-down menus to assign clusters of samples to their corresponding Time-Points" + andconditions + ".");
                                GridBagConstraints c = new GridBagConstraints();
                                c.gridwidth = 2;
                                clusterSelectorPanel.add((Component)clusterInstructions, c);
                                c.fill = 1;
                                c.weighty = 1.0;
                                c.weightx = 1.0;
                                c.gridx = 0;
                                c.gridy = 1;
                                c.gridwidth = 1;
                                c.anchor = 20;
                                if (MultiClassPanel.this.ngPanel.getExperimentDesign() == 2) {
                                    clusterSelectorPanel.add((Component)MultiClassPanel.this.clusterSelectorCondition, c);
                                }
                                c.gridx = 1;
                                clusterSelectorPanel.add((Component)MultiClassPanel.this.clusterSelectorTime, c);
                                MultiClassPanel.this.tabbedmulg.add("Button Selection", MultiClassPanel.this.mulgPanel);
                                MultiClassPanel.this.tabbedmulg.add("Cluster Selection", clusterSelectorPanel);
                                MultiClassPanel.this.tabbedmulg.setSelectedIndex(1);
                                if (BETRInitBox.this.repository == null || BETRInitBox.this.repository.isEmpty()) {
                                    MultiClassPanel.this.tabbedmulg.setSelectedIndex(0);
                                }
                                BETRInitBox.this.buildConstraints(MultiClassPanel.this.constraints, 0, 1, 2, 1, 0, 90);
                                MultiClassPanel.this.constraints.fill = 1;
                                MultiClassPanel.this.gridbag.setConstraints(MultiClassPanel.this.tabbedmulg, MultiClassPanel.this.constraints);
                                MultiClassPanel.this.add(MultiClassPanel.this.tabbedmulg);
                                MultiClassPanel.this.validate();
                                BETRInitBox.this.enableOK();
                                MultiClassPanel.this.ngPanel.numTimePointsField.setEnabled(false);
                                MultiClassPanel.this.ngPanel.alphaField.setEnabled(false);
                                MultiClassPanel.this.ngPanel.oneCondition.setEnabled(false);
                                MultiClassPanel.this.ngPanel.twoConditions.setEnabled(false);
                                MultiClassPanel.this.ngPanel.pairedData.setEnabled(false);
                                BETRInitBox.this.step2Button.setText("<<< Go Back");
                                MultiClassPanel.this.infoLabel.setVisible(false);
                                MultiClassPanel.this.infoLabel2.setVisible(false);
                                BETRInitBox.this.step2 = true;
                            }
                        }
                        catch (NumberFormatException nfe) {
                            JOptionPane.showMessageDialog(null, "Please enter a value greater than 0 and less than 1!", "Error", 0);
                        }
                    }
                }
            });
            JPanel topPanel = new JPanel();
            topPanel.setBackground(Color.white);
            topPanel.setLayout(this.gridbag);
            BETRInitBox.this.buildConstraints(this.constraints, 0, 0, 1, 2, 75, 100);
            this.gridbag.setConstraints(this.ngPanel, this.constraints);
            topPanel.add(this.ngPanel);
            BETRInitBox.this.hclOpsPanel = new HCLoptionPanel();
            BETRInitBox.this.hclOpsPanel.setBorder(null);
            BETRInitBox.this.buildConstraints(this.constraints, 1, 0, 1, 1, 25, 100);
            this.gridbag.setConstraints(BETRInitBox.this.hclOpsPanel, this.constraints);
            topPanel.add(BETRInitBox.this.hclOpsPanel);
            BETRInitBox.this.buildConstraints(this.constraints, 1, 1, 1, 1, 0, 10);
            this.gridbag.setConstraints(BETRInitBox.this.step2Button, this.constraints);
            topPanel.add(BETRInitBox.this.step2Button);
            topPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "BETR Parameters", 0, 0, null, Color.black));
            BETRInitBox.this.buildConstraints(this.constraints, 0, 0, 1, 1, 100, 10);
            this.gridbag.setConstraints(topPanel, this.constraints);
            this.add(topPanel);
            this.infoLabel = new JLabel("Sample Group Assignment");
            this.constraints.fill = 0;
            this.constraints.anchor = 10;
            this.infoLabel.setMaximumSize(new Dimension(50, 50));
            Font font = this.infoLabel.getFont();
            this.infoLabel.setFont(font.deriveFont(20.0f));
            BETRInitBox.this.buildConstraints(this.constraints, 0, 1, 1, 1, 0, 5);
            this.gridbag.setConstraints(this.infoLabel, this.constraints);
            this.add((Component)this.infoLabel, this.constraints);
            this.infoLabel2 = new JLabel("Please select the type of BETR analysis to be run, then click 'Continue'.");
            this.constraints.anchor = 10;
            BETRInitBox.this.buildConstraints(this.constraints, 0, 2, 1, 1, 100, 5);
            this.gridbag.setConstraints(this.infoLabel2, this.constraints);
            this.add((Component)this.infoLabel2, this.constraints);
            BETRInitBox.this.buildConstraints(this.constraints, 0, 3, 1, 1, 100, 90);
            this.dummyPanel = new JPanel();
            this.dummyPanel.setBackground(Color.white);
            this.gridbag.setConstraints(this.dummyPanel, this.constraints);
            this.add(this.dummyPanel);
        }

        protected void reset() {
            if (this.ngPanel.okPressed) {
                this.mulgPanel.reset();
            }
        }

        class MultiGroupExperimentsPanel
        extends JPanel {
            int numPanels = 0;
            JLabel[] expLabels;
            JRadioButton[][] exptTimeRadioButtons;
            JRadioButton[] notInTimeGroupRadioButtons;
            JRadioButton[][] exptConditionRadioButtons;

            MultiGroupExperimentsPanel(Vector<String> exptNames, int numTimePoints, int conditions) {
                int i;
                int i2;
                this.setBorder(new TitledBorder(new EtchedBorder(), "Time/Condition Assignments", 0, 0, new Font("Dialog", 1, 12), Color.black));
                this.setBackground(Color.white);
                this.expLabels = new JLabel[exptNames.size()];
                this.exptTimeRadioButtons = new JRadioButton[numTimePoints][exptNames.size()];
                if (conditions == 2) {
                    this.exptConditionRadioButtons = new JRadioButton[2][exptNames.size()];
                }
                this.numPanels = exptNames.size() / 512 + 1;
                this.notInTimeGroupRadioButtons = new JRadioButton[exptNames.size()];
                ButtonGroup[] chooseTime = new ButtonGroup[exptNames.size()];
                ButtonGroup[] chooseCondition = new ButtonGroup[exptNames.size()];
                GridBagLayout gridbag = new GridBagLayout();
                GridBagLayout gridbag2 = new GridBagLayout();
                GridBagConstraints constraints = new GridBagConstraints();
                this.setLayout(gridbag2);
                JPanel[] panels = new JPanel[this.numPanels];
                int currPanel = 0;
                for (i2 = 0; i2 < panels.length; ++i2) {
                    panels[i2] = new JPanel(gridbag);
                }
                for (i2 = 0; i2 < exptNames.size(); ++i2) {
                    String s1 = exptNames.get(i2);
                    this.expLabels[i2] = new JLabel(s1);
                    chooseTime[i2] = new ButtonGroup();
                    chooseCondition[i2] = new ButtonGroup();
                    for (int j = 0; j < numTimePoints; ++j) {
                        this.exptTimeRadioButtons[j][i2] = new JRadioButton("Time " + j + "     ", false);
                        chooseTime[i2].add(this.exptTimeRadioButtons[j][i2]);
                    }
                    currPanel = i2 / 512;
                    this.notInTimeGroupRadioButtons[i2] = new JRadioButton("Unassigned", true);
                    chooseTime[i2].add(this.notInTimeGroupRadioButtons[i2]);
                    int twoCondRoom = 0;
                    if (conditions == 2) {
                        this.exptConditionRadioButtons[0][i2] = new JRadioButton("Condition 1", true);
                        chooseCondition[i2].add(this.exptConditionRadioButtons[0][i2]);
                        this.exptConditionRadioButtons[1][i2] = new JRadioButton("Condition 2           |  ", true);
                        chooseCondition[i2].add(this.exptConditionRadioButtons[1][i2]);
                        twoCondRoom = 3;
                        BETRInitBox.this.buildConstraints(constraints, 0, i2 % 512, 1, 1, 100, 100);
                        gridbag.setConstraints(this.exptConditionRadioButtons[0][i2], constraints);
                        panels[currPanel].add(this.exptConditionRadioButtons[0][i2]);
                        BETRInitBox.this.buildConstraints(constraints, 1, i2 % 512, 1, 1, 100, 100);
                        gridbag.setConstraints(this.exptConditionRadioButtons[1][i2], constraints);
                        panels[currPanel].add(this.exptConditionRadioButtons[1][i2]);
                        JSeparator sep = new JSeparator(1);
                        sep.setSize(22, 22);
                        BETRInitBox.this.buildConstraints(constraints, 2, i2 % 512, 1, 1, 100, 100);
                        gridbag.setConstraints(sep, constraints);
                        panels[currPanel].setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
                        panels[currPanel].add(sep);
                    }
                    for (int j = 0; j < numTimePoints; ++j) {
                        BETRInitBox.this.buildConstraints(constraints, j + twoCondRoom, i2 % 512, 1, 1, 100, 100);
                        gridbag.setConstraints(this.exptTimeRadioButtons[j][i2], constraints);
                        panels[currPanel].add(this.exptTimeRadioButtons[j][i2]);
                    }
                    BETRInitBox.this.buildConstraints(constraints, numTimePoints + 1 + twoCondRoom, i2 % 512, 1, 1, 100, 100);
                    gridbag.setConstraints(this.notInTimeGroupRadioButtons[i2], constraints);
                    panels[currPanel].add(this.notInTimeGroupRadioButtons[i2]);
                }
                int maxLabelWidth = 0;
                for (int i3 = 0; i3 < this.expLabels.length; ++i3) {
                    if (!(this.expLabels[i3].getPreferredSize().getWidth() > (double)maxLabelWidth)) continue;
                    maxLabelWidth = (int)Math.ceil(this.expLabels[i3].getPreferredSize().getWidth());
                }
                JPanel bigPanel = new JPanel(new GridBagLayout());
                for (int i4 = 0; i4 < this.numPanels; ++i4) {
                    bigPanel.add((Component)panels[i4], new GridBagConstraints(0, i4, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
                }
                JScrollPane scroll = new JScrollPane(bigPanel);
                scroll.setHorizontalScrollBarPolicy(32);
                scroll.setVerticalScrollBarPolicy(22);
                JPanel[] exptNameHeaderPanels = new JPanel[this.numPanels];
                GridBagLayout exptHeaderGridbag = new GridBagLayout();
                for (i = 0; i < exptNameHeaderPanels.length; ++i) {
                    exptNameHeaderPanels[i] = new JPanel();
                    exptNameHeaderPanels[i].setSize(50, panels[i].getPreferredSize().height);
                    exptNameHeaderPanels[i].setPreferredSize(new Dimension(maxLabelWidth + 10, panels[i].getPreferredSize().height));
                    exptNameHeaderPanels[i].setLayout(exptHeaderGridbag);
                }
                for (i = 0; i < this.expLabels.length; ++i) {
                    currPanel = i / 512;
                    BETRInitBox.this.buildConstraints(constraints, 0, i % 512, 1, 1, 100, 100);
                    constraints.fill = 1;
                    exptHeaderGridbag.setConstraints(this.expLabels[i], constraints);
                    exptNameHeaderPanels[currPanel].add(this.expLabels[i]);
                }
                JPanel headerPanel = new JPanel(new GridBagLayout());
                for (int i5 = 0; i5 < exptNameHeaderPanels.length; ++i5) {
                    headerPanel.add((Component)exptNameHeaderPanels[i5], new GridBagConstraints(0, i5, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
                }
                scroll.setRowHeaderView(headerPanel);
                BETRInitBox.this.buildConstraints(constraints, 0, 0, 1, 1, 100, 90);
                constraints.fill = 1;
                gridbag2.setConstraints(scroll, constraints);
                this.add(scroll);
                JLabel label1 = new JLabel("Note: Each time-point MUST each contain more than one sample.");
                if (MultiClassPanel.this.ngPanel.getExperimentDesign() == 2) {
                    label1 = new JLabel("Note: Each time-point MUST each contain more than one sample for both conditions.");
                }
                label1.setHorizontalAlignment(0);
                BETRInitBox.this.buildConstraints(constraints, 0, 1, 1, 1, 0, 5);
                constraints.anchor = 13;
                gridbag2.setConstraints(label1, constraints);
                this.add(label1);
                JPanel panel2 = new JPanel();
                GridBagLayout gridbag3 = new GridBagLayout();
                panel2.setLayout(gridbag3);
                panel2.setBackground(Color.white);
                JButton saveButton = new JButton("  Save settings  ");
                saveButton.setFocusPainted(false);
                saveButton.setBorder(BorderFactory.createBevelBorder(0, Color.lightGray, Color.darkGray));
                JButton loadButton = new JButton("  Load settings  ");
                loadButton.setFocusPainted(false);
                loadButton.setBorder(BorderFactory.createBevelBorder(0, Color.lightGray, Color.darkGray));
                JButton resetButton = new JButton("  Reset  ");
                resetButton.setFocusPainted(false);
                resetButton.setBorder(BorderFactory.createBevelBorder(0, Color.lightGray, Color.darkGray));
                final int finNum = exptNames.size();
                resetButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        for (int i = 0; i < finNum; ++i) {
                            MultiGroupExperimentsPanel.this.notInTimeGroupRadioButtons[i].setSelected(true);
                            if (MultiClassPanel.this.ngPanel.getExperimentDesign() != 2) continue;
                            MultiGroupExperimentsPanel.this.exptConditionRadioButtons[0][i].setSelected(true);
                        }
                    }
                });
                JFileChooser fc = new JFileChooser(TMEV.getDataPath());
                saveButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        MultiGroupExperimentsPanel.this.saveAssignments();
                    }
                });
                loadButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        MultiGroupExperimentsPanel.this.loadAssignments();
                    }
                });
                constraints.anchor = 10;
                constraints.fill = 0;
                constraints.insets = new Insets(5, 5, 5, 5);
                BETRInitBox.this.buildConstraints(constraints, 0, 0, 1, 1, 33, 100);
                gridbag3.setConstraints(saveButton, constraints);
                panel2.add(saveButton);
                BETRInitBox.this.buildConstraints(constraints, 1, 0, 1, 1, 33, 0);
                gridbag3.setConstraints(loadButton, constraints);
                panel2.add(loadButton);
                BETRInitBox.this.buildConstraints(constraints, 2, 0, 1, 1, 34, 0);
                gridbag3.setConstraints(resetButton, constraints);
                panel2.add(resetButton);
                constraints.insets = new Insets(0, 0, 0, 0);
                BETRInitBox.this.buildConstraints(constraints, 0, 2, 1, 1, 0, 5);
                constraints.anchor = 10;
                gridbag2.setConstraints(panel2, constraints);
                this.add(panel2);
            }

            protected void reset() {
                for (int i = 0; i < BETRInitBox.this.exptNames.size(); ++i) {
                    this.notInTimeGroupRadioButtons[i].setSelected(true);
                    this.exptConditionRadioButtons[0][i].setSelected(true);
                }
            }

            private void saveAssignments() {
                JFileChooser fileChooser = new JFileChooser(TMEV.getDataPath());
                if (fileChooser.showSaveDialog(this) == 0) {
                    File file = fileChooser.getSelectedFile();
                    try {
                        PrintWriter pw = new PrintWriter(new FileWriter(file));
                        Date currDate = new Date(System.currentTimeMillis());
                        String dateString = currDate.toString();
                        String userName = System.getProperty("user.name");
                        pw.println("# Assignment File");
                        pw.println("# User: " + userName + " Save Date: " + dateString);
                        pw.println("#");
                        pw.print("Module:\t");
                        pw.println("BETR");
                        pw.print("Conditions:\t");
                        pw.println(MultiClassPanel.this.ngPanel.getExperimentDesign());
                        for (int i = 0; i < MultiClassPanel.this.numTimePoints; ++i) {
                            pw.print("Group " + (i + 1) + " Label:\t");
                            pw.println("Time " + i);
                        }
                        pw.println("#");
                        pw.println("Sample Index\tSample Name\tGroup Assignment");
                        int[] timeAssgn = BETRInitBox.this.getTimeAssignments();
                        if (MultiClassPanel.this.ngPanel.getExperimentDesign() != 2) {
                            for (int sample = 0; sample < BETRInitBox.this.exptNames.size(); ++sample) {
                                pw.print(String.valueOf(sample + 1) + "\t");
                                pw.print(BETRInitBox.this.exptNames.get(sample) + "\t");
                                if (timeAssgn[sample] != 0) {
                                    pw.println("Time " + (timeAssgn[sample] - 1));
                                    continue;
                                }
                                pw.println("Exclude");
                            }
                        } else {
                            int[] condAssgn = BETRInitBox.this.getConditionAssignments();
                            for (int sample = 0; sample < BETRInitBox.this.exptNames.size(); ++sample) {
                                pw.print(String.valueOf(sample + 1) + "\t");
                                pw.print(BETRInitBox.this.exptNames.get(sample) + "\t");
                                if (timeAssgn[sample] != 0) {
                                    pw.println("Time " + (timeAssgn[sample] - 1) + "\tCondition " + condAssgn[sample]);
                                    continue;
                                }
                                pw.println("Exclude\tExclude");
                            }
                        }
                        pw.flush();
                        pw.close();
                    }
                    catch (FileNotFoundException fnfe) {
                        fnfe.printStackTrace();
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                    }
                }
            }

            private void loadAssignments() {
                JFileChooser fileChooser = new JFileChooser(TMEV.getDataPath());
                if (fileChooser.showOpenDialog(this) == 0) {
                    File file = fileChooser.getSelectedFile();
                    try {
                        String line;
                        BufferedReader br = new BufferedReader(new FileReader(file));
                        Vector<String> data = new Vector<String>();
                        while ((line = br.readLine()) != null) {
                            data.add(line.trim());
                        }
                        br.close();
                        Vector<String> groupNames = new Vector<String>();
                        Vector<String> condNames = new Vector<String>();
                        Vector<Integer> sampleIndices = new Vector<Integer>();
                        Vector<String> sampleNames = new Vector<String>();
                        Vector<String> groupAssignments = new Vector<String>();
                        Vector<String> condAssignments = new Vector<String>();
                        int cond = 0;
                        for (int row = 0; row < data.size(); ++row) {
                            line = (String)data.get(row);
                            if (line.startsWith("#") || line.startsWith("SampleIndex")) continue;
                            String[] lineArray = line.split("\t");
                            if (lineArray[0].startsWith("Module:")) {
                                if (lineArray[1].equals("BETR")) continue;
                                Object[] optionst = new Object[]{"Continue", "Cancel"};
                                if (JOptionPane.showOptionDialog(null, "The saved file was saved using a different module, " + lineArray[1] + ". \n Would you like MeV to try to load it anyway?", "File type warning", 1, 3, null, optionst, optionst[0]) == 0) continue;
                                return;
                            }
                            if (lineArray[0].startsWith("Group ") && lineArray[0].endsWith("Label:")) {
                                groupNames.add(lineArray[1]);
                                continue;
                            }
                            if (lineArray[0].startsWith("Cond")) {
                                try {
                                    cond = Integer.parseInt(lineArray[1]);
                                }
                                catch (NumberFormatException nfe) {}
                                continue;
                            }
                            if (cond == 2) {
                                condNames.add("Condition 1");
                                condNames.add("Condition 2");
                            }
                            try {
                                Integer.parseInt(lineArray[0]);
                            }
                            catch (NumberFormatException nfe) {
                                continue;
                            }
                            sampleIndices.add(new Integer(lineArray[0]));
                            sampleNames.add(lineArray[1]);
                            groupAssignments.add(lineArray[2]);
                            if (cond != 2) continue;
                            condAssignments.add(lineArray[3]);
                        }
                        if (BETRInitBox.this.exptNames.size() != sampleNames.size()) {
                            System.out.println(BETRInitBox.this.exptNames.size() + "  " + sampleNames.size());
                            System.out.println(BETRInitBox.this.exptNames.size() + " s length " + sampleNames.size());
                            JOptionPane.showMessageDialog(this, "<html>Error -- number of samples designated in assignment file (" + String.valueOf(sampleNames.size()) + ")<br>" + "does not match the number of samples loaded in MeV (" + BETRInitBox.this.exptNames.size() + ").<br>" + "Assignments are not set.</html>", "File Compatibility Error", 0);
                            return;
                        }
                        Vector<String> currSampleVector = new Vector<String>();
                        for (int i = 0; i < BETRInitBox.this.exptNames.size(); ++i) {
                            currSampleVector.add(BETRInitBox.this.exptNames.get(i));
                        }
                        int fileSampleIndex = 0;
                        int groupIndex = 0;
                        int condIndex = 0;
                        for (int sample = 0; sample < BETRInitBox.this.exptNames.size(); ++sample) {
                            boolean doIndex = false;
                            for (int i = 0; i < BETRInitBox.this.exptNames.size(); ++i) {
                                if (i == sample || !BETRInitBox.this.exptNames.get(i).equals(BETRInitBox.this.exptNames.get(sample))) continue;
                                doIndex = true;
                            }
                            fileSampleIndex = sampleNames.indexOf(BETRInitBox.this.exptNames.get(sample));
                            if (fileSampleIndex == -1) {
                                doIndex = true;
                            }
                            if (doIndex) {
                                this.setStateBasedOnIndex(groupAssignments, groupNames, cond, condAssignments, condNames);
                                break;
                            }
                            String groupName = (String)groupAssignments.get(fileSampleIndex);
                            groupIndex = groupNames.indexOf(groupName);
                            if (cond == 2) {
                                String condName = condAssignments.get(fileSampleIndex);
                                condIndex = condNames.indexOf(condName);
                            }
                            try {
                                this.exptTimeRadioButtons[groupIndex][sample].setSelected(true);
                            }
                            catch (Exception e) {
                                this.notInTimeGroupRadioButtons[sample].setSelected(true);
                            }
                            if (cond != 2 || MultiClassPanel.this.ngPanel.getExperimentDesign() != 2) continue;
                            if (condIndex == 1) {
                                this.exptConditionRadioButtons[condIndex][sample].setSelected(true);
                                continue;
                            }
                            this.exptConditionRadioButtons[0][sample].setSelected(true);
                        }
                        this.repaint();
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(this, "<html>The file format cannot be read.</html>", "File Compatibility Error", 0);
                    }
                }
            }

            private void setStateBasedOnIndex(Vector<String> groupAssignments, Vector<String> groupNames, int cond, Vector<String> condAssignments, Vector<String> condNames) {
                Object[] optionst = new Object[]{"Continue", "Cancel"};
                if (JOptionPane.showOptionDialog(null, "The saved file was saved using a different sample annotation or has duplicate annotation. \n Would you like MeV to try to load it by index order?", "File type warning", 1, 3, null, optionst, optionst[0]) == 1) {
                    return;
                }
                int condIndex = 0;
                for (int sample = 0; sample < BETRInitBox.this.exptNames.size(); ++sample) {
                    if (cond == 2) {
                        String condName = condAssignments.get(sample);
                        condIndex = condNames.indexOf(condName);
                    }
                    try {
                        this.exptTimeRadioButtons[groupNames.indexOf(groupAssignments.get(sample))][sample].setSelected(true);
                        if (cond != 2 || MultiClassPanel.this.ngPanel.getExperimentDesign() != 2) continue;
                        if (condIndex == 1) {
                            this.exptConditionRadioButtons[condIndex][sample].setSelected(true);
                            continue;
                        }
                        this.exptConditionRadioButtons[0][sample].setSelected(true);
                        continue;
                    }
                    catch (Exception e) {
                        this.notInTimeGroupRadioButtons[sample].setSelected(true);
                    }
                }
            }
        }

        class NumTimePointsPanel
        extends JPanel {
            JTextField numTimePointsField;
            JTextField alphaField;
            boolean okPressed = false;
            JRadioButton oneCondition;
            JRadioButton twoConditions;
            JRadioButton pairedData;

            public NumTimePointsPanel() {
                this.setBackground(Color.white);
                GridBagLayout gridbag = new GridBagLayout();
                GridBagConstraints constraints = new GridBagConstraints();
                this.setLayout(gridbag);
                JLabel dataTypeLabel = new JLabel("Type of data to run:   ");
                BETRInitBox.this.buildConstraints(constraints, 0, 0, 1, 1, 30, 100);
                constraints.anchor = 13;
                gridbag.setConstraints(dataTypeLabel, constraints);
                this.add(dataTypeLabel);
                this.twoConditions = new JRadioButton("2 Conditions", true);
                this.oneCondition = new JRadioButton("1 Condition", false);
                this.pairedData = new JRadioButton("Paired", false);
                this.oneCondition.setBackground(Color.white);
                this.oneCondition.setBorder(null);
                this.twoConditions.setBackground(Color.white);
                this.twoConditions.setBorder(null);
                this.pairedData.setBackground(Color.white);
                this.pairedData.setBorder(null);
                ButtonGroup dataType = new ButtonGroup();
                dataType.add(this.oneCondition);
                dataType.add(this.twoConditions);
                dataType.add(this.pairedData);
                BETRInitBox.this.buildConstraints(constraints, 1, 0, 1, 1, 30, 100);
                constraints.anchor = 17;
                gridbag.setConstraints(this.twoConditions, constraints);
                this.add(this.twoConditions);
                BETRInitBox.this.buildConstraints(constraints, 1, 1, 1, 1, 30, 100);
                constraints.anchor = 17;
                gridbag.setConstraints(this.oneCondition, constraints);
                this.add(this.oneCondition);
                BETRInitBox.this.buildConstraints(constraints, 1, 2, 1, 1, 30, 100);
                constraints.anchor = 17;
                gridbag.setConstraints(this.pairedData, constraints);
                this.add(this.pairedData);
                JLabel numTimePointsLabel = new JLabel("Number of time-points: ");
                BETRInitBox.this.buildConstraints(constraints, 0, 3, 1, 1, 30, 100);
                constraints.anchor = 13;
                gridbag.setConstraints(numTimePointsLabel, constraints);
                this.add(numTimePointsLabel);
                this.numTimePointsField = new JTextField("4", 7);
                this.numTimePointsField.setMinimumSize(new Dimension(50, 20));
                constraints.anchor = 17;
                BETRInitBox.this.buildConstraints(constraints, 1, 3, 1, 1, 30, 0);
                gridbag.setConstraints(this.numTimePointsField, constraints);
                this.add(this.numTimePointsField);
                JLabel alphaLabel = new JLabel("Significance level: alpha = ");
                BETRInitBox.this.buildConstraints(constraints, 0, 4, 1, 1, 30, 100);
                constraints.anchor = 13;
                gridbag.setConstraints(alphaLabel, constraints);
                this.add(alphaLabel);
                this.alphaField = new JTextField(".05", 7);
                this.alphaField.setMinimumSize(new Dimension(50, 20));
                constraints.anchor = 17;
                BETRInitBox.this.buildConstraints(constraints, 1, 4, 1, 1, 30, 0);
                gridbag.setConstraints(this.alphaField, constraints);
                this.add(this.alphaField);
            }

            public int getExperimentDesign() {
                if (this.oneCondition.isSelected()) {
                    return 1;
                }
                if (this.twoConditions.isSelected()) {
                    return 2;
                }
                if (this.pairedData.isSelected()) {
                    return 3;
                }
                return 0;
            }

            @Override
            public void setVisible(boolean visible) {
                this.setLocation((MultiClassPanel.this.getWidth() - this.getSize().width) / 2, (MultiClassPanel.this.getHeight() - this.getSize().height) / 2);
                super.setVisible(visible);
                if (visible) {
                    // empty if block
                }
            }

            public boolean isOkPressed() {
                return this.okPressed;
            }
        }
    }

    class HCLoptionPanel
    extends JPanel {
        private JCheckBox hclCluster;
        private JRadioButton sigOnly;
        private JRadioButton allClusters;
        GridBagConstraints constraints = new GridBagConstraints();
        GridBagLayout gridbag = new GridBagLayout();

        public HCLoptionPanel() {
            this.setBackground(Color.white);
            Font font = new Font("Dialog", 1, 12);
            this.setLayout(this.gridbag);
            this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Hierarchical Clustering", 0, 0, font, Color.black));
            this.hclCluster = new JCheckBox("Construct Hierarchical Trees for :            ");
            this.hclCluster.setFocusPainted(false);
            this.hclCluster.setBackground(Color.white);
            this.hclCluster.setForeground(UIManager.getColor("Label.foreground"));
            this.sigOnly = new JRadioButton("Significant genes only", true);
            this.sigOnly.setBackground(Color.white);
            this.sigOnly.setForeground(UIManager.getColor("Label.foreground"));
            this.allClusters = new JRadioButton("All clusters", false);
            this.allClusters.setBackground(Color.white);
            this.allClusters.setForeground(UIManager.getColor("Label.foreground"));
            this.sigOnly.setEnabled(false);
            this.allClusters.setEnabled(false);
            ButtonGroup allOrSig = new ButtonGroup();
            allOrSig.add(this.sigOnly);
            allOrSig.add(this.allClusters);
            this.hclCluster.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 2) {
                        HCLoptionPanel.this.sigOnly.setEnabled(false);
                        HCLoptionPanel.this.allClusters.setEnabled(false);
                    } else {
                        HCLoptionPanel.this.sigOnly.setEnabled(true);
                        HCLoptionPanel.this.allClusters.setEnabled(true);
                    }
                }
            });
            this.constraints.anchor = 17;
            BETRInitBox.this.buildConstraints(this.constraints, 0, 0, 1, 1, 25, 10);
            this.gridbag.setConstraints(this.hclCluster, this.constraints);
            this.add(this.hclCluster);
            BETRInitBox.this.buildConstraints(this.constraints, 0, 1, 1, 1, 25, 10);
            this.gridbag.setConstraints(this.sigOnly, this.constraints);
            this.add(this.sigOnly);
            BETRInitBox.this.buildConstraints(this.constraints, 0, 2, 1, 1, 25, 10);
            this.gridbag.setConstraints(this.allClusters, this.constraints);
            this.add(this.allClusters);
            JPanel dummyPanel = new JPanel();
            BETRInitBox.this.buildConstraints(this.constraints, 0, 3, 1, 1, 25, 100);
            this.gridbag.setConstraints(dummyPanel, this.constraints);
            dummyPanel.setBackground(Color.white);
            this.add(dummyPanel);
        }

        public HCLoptionPanel(Color background) {
            this();
            this.setBackground(background);
        }

        public boolean isHCLSelected() {
            return this.hclCluster.isSelected();
        }

        public boolean drawSigTreesOnly() {
            return this.sigOnly.isSelected();
        }

        public void setHCLSelected(boolean value) {
            this.hclCluster.setSelected(value);
        }
    }
}

