/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.attract;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.beans.Expression;
import java.text.DecimalFormat;
import java.util.LinkedList;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.util.FloatMatrix;

public class SynExpressionViewer
extends JPanel
implements IViewer {
    private FloatMatrix synExpression;
    private FloatMatrix logSynGeneExpression;
    private FloatMatrix corrGeneExpression;
    private FloatMatrix logCorrGeneExpression;
    private int[][] groupAssignments;
    private int[] factorLevels;
    private float minYValue;
    private float maxYValue;
    private float stepsY;
    private LinkedList<Integer> reorderedSamples;
    private LinkedList<Integer> numSamplesPerGroup;
    private DecimalFormat coordinateFormat;
    private FontMetrics metrics;
    private boolean isAntiAliasing = false;

    public SynExpressionViewer(FloatMatrix expressionVals, FloatMatrix corGeneExpression, int[][] grpAssign, int[] fLevels) {
        this.synExpression = expressionVals;
        this.corrGeneExpression = corGeneExpression;
        this.groupAssignments = grpAssign;
        this.factorLevels = fLevels;
        this.setBackground(Color.WHITE);
        this.coordinateFormat = new DecimalFormat();
        this.coordinateFormat.setMaximumFractionDigits(3);
        this.logSynGeneExpression = this.findLog(this.synExpression);
        this.logCorrGeneExpression = this.findLog(this.corrGeneExpression);
        this.calculateMaxYValue(this.logSynGeneExpression, this.logCorrGeneExpression);
        this.calculateMinYValue(this.logSynGeneExpression, this.logCorrGeneExpression);
        this.reorderedSamples = this.reorderSamplesByGroups(this.groupAssignments, this.factorLevels);
    }

    public LinkedList<Integer> reorderSamplesByGroups(int[][] assignment, int[] factorLevels) {
        LinkedList<Integer> temp = new LinkedList<Integer>();
        this.numSamplesPerGroup = new LinkedList();
        for (int level = 1; level < factorLevels[0] + 1; ++level) {
            for (int index = 0; index < assignment[0].length; ++index) {
                if (assignment[0][index] != level) continue;
                temp.add(index);
            }
            if (temp.size() == assignment[0].length) continue;
            this.numSamplesPerGroup.add(level - 1, temp.size() - 1);
        }
        return temp;
    }

    public FloatMatrix findLog(FloatMatrix expressionVals) {
        FloatMatrix temp = new FloatMatrix(expressionVals.getRowDimension(), expressionVals.getColumnDimension());
        for (int col = 0; col < expressionVals.getColumnDimension(); ++col) {
            float log = new Float(Math.log(expressionVals.get(0, col)) / Math.log(2.0)).floatValue();
            temp.set(0, col, log);
        }
        return temp;
    }

    public void calculateMaxYValue(FloatMatrix synExpGrp, FloatMatrix corrExpGrp) {
        this.maxYValue = Float.MIN_VALUE;
        for (int colIndex = 0; colIndex < synExpGrp.getColumnDimension(); ++colIndex) {
            this.maxYValue = Math.max(this.maxYValue, synExpGrp.get(0, colIndex));
            this.maxYValue = Math.max(this.maxYValue, corrExpGrp.get(0, colIndex));
        }
    }

    public void calculateMinYValue(FloatMatrix synExpGrp, FloatMatrix corrExpGrp) {
        this.minYValue = Float.MAX_VALUE;
        for (int colIndex = 0; colIndex < synExpGrp.getColumnDimension(); ++colIndex) {
            this.minYValue = Math.min(this.minYValue, synExpGrp.get(0, colIndex));
            this.minYValue = Math.min(this.minYValue, corrExpGrp.get(0, colIndex));
        }
    }

    public int getMaxXValue() {
        return this.synExpression.getColumnDimension();
    }

    public float getMinYValue() {
        return this.minYValue;
    }

    public float getMaxYValue() {
        return this.maxYValue;
    }

    public void setStepsY(float stepY) {
        this.stepsY = stepY;
    }

    public float getStepsY() {
        return this.stepsY;
    }

    public int getMaximumStringWidth() {
        int maxWidth = Integer.MIN_VALUE;
        float step = this.getStepsY();
        for (float i = this.getMinYValue(); i <= this.getMaxYValue(); i += step) {
            String str = this.coordinateFormat.format(i);
            int strWidth = this.metrics.stringWidth(str);
            if (strWidth > maxWidth) {
                maxWidth = strWidth;
            }
            if ((strWidth = this.metrics.stringWidth(str = this.coordinateFormat.format(-i))) <= maxWidth) continue;
            maxWidth = strWidth;
        }
        return maxWidth;
    }

    public FontMetrics getFontMetrics() {
        return this.metrics;
    }

    public void setFontMetric(FontMetrics metrics) {
        this.metrics = metrics;
    }

    @Override
    public void paint(Graphics g) {
        FontMetrics metrics = g.getFontMetrics();
        this.paint((Graphics2D)g);
    }

    public void paint(Graphics2D g) {
        super.paint(g);
        FontMetrics metrics = g.getFontMetrics();
        this.setFontMetric(metrics);
        if (this.isAntiAliasing) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        float maxYValue = Math.max(Math.abs(this.getMaxYValue()), Math.abs(this.getMinYValue()));
        float minYValue = this.getMinYValue();
        this.stepsY = maxYValue / 5.0f;
        this.setStepsY(this.stepsY);
        Rectangle rectangle = new Rectangle(2 * this.getMaximumStringWidth(), 20, this.getWidth() - 80, this.getHeight() - 40 - this.getNamesWidth(metrics));
        if (rectangle.x + rectangle.width > this.getWidth()) {
            int diff = rectangle.x + rectangle.width - this.getWidth();
            rectangle = new Rectangle(2 * this.getMaximumStringWidth(), 20, this.getWidth() - this.getMaximumStringWidth() - diff - 80, this.getHeight() - 40 - this.getNamesWidth(metrics));
        }
        int left = rectangle.x;
        int top = rectangle.y;
        int width = rectangle.width;
        int height = rectangle.height;
        int zeroValue = top + Math.round((float)height / 2.0f);
        int numberOfSamples = this.getMaxXValue();
        int oldSynYCoord = 0;
        int oldSynXCoord = 0;
        int oldCorYCoord = 0;
        int oldCorXCoord = 0;
        float factor = height / 5;
        float stepX = (float)width / (float)numberOfSamples;
        int grpNumber = 1;
        int verticalLineCoord = -1;
        g.setStroke(new BasicStroke(2.0f));
        String xlabel = " Sample Groups";
        String ylabel = "Log2(expression)";
        Font font = new Font("Dialog", 0, 12);
        g.setFont(font);
        g.drawString(xlabel, this.getWidth() / 2, this.getHeight());
        g.rotate(-1.5707963267948966, left - this.getMaximumStringWidth(), zeroValue);
        g.drawString(ylabel, left - this.getMaximumStringWidth() - 18, zeroValue);
        g.rotate(1.5707963267948966, left - this.getMaximumStringWidth(), zeroValue);
        g.setColor(Color.black);
        g.drawRect(left, top, width, height);
        g.setStroke(new BasicStroke(2.0f));
        g.setColor(Color.black);
        for (int i = 1; i <= this.getMaxXValue(); ++i) {
            g.drawLine(left + Math.round((float)i * stepX), top + height - 5, left + Math.round((float)i * stepX), top + height);
            g.drawLine(left + Math.round((float)i * stepX), top, left + Math.round((float)i * stepX), top + 5);
        }
        int yaxis = (int)((float)(top + height) - factor);
        int strWidth = this.getMaximumStringWidth();
        for (float i = this.getStepsY(); i < this.getMaxYValue() + this.getStepsY(); i += this.getStepsY()) {
            g.drawLine(left, yaxis, left + 5, yaxis);
            g.drawString(this.coordinateFormat.format(i), left - 10 - strWidth, yaxis);
            if ((yaxis -= (int)factor) >= top || i != this.getMaxYValue()) continue;
            yaxis = top;
        }
        for (int index = 0; index < this.reorderedSamples.size(); ++index) {
            float synExpressionValue = this.logSynGeneExpression.get(0, this.reorderedSamples.get(index).intValue());
            float corExpressionValue = this.logCorrGeneExpression.get(0, this.reorderedSamples.get(index).intValue());
            int synXCoord = left + Math.round((float)index * stepX) + 3;
            int synYCoord = (int)((float)(top + height) - factor);
            int corXCoord = left + Math.round((float)index * stepX) + 3;
            int corYCoord = (int)((float)(top + height) - factor);
            int count = 0;
            g.setStroke(new BasicStroke(4.0f));
            for (float ind = this.getStepsY(); ind <= this.getMaxYValue() + this.getStepsY(); ind += this.getStepsY()) {
                float unknown;
                String t = this.coordinateFormat.format(ind);
                float tempVar = Float.parseFloat(t);
                float step = Float.parseFloat(this.coordinateFormat.format(this.getStepsY()));
                if (synExpressionValue < this.getStepsY()) {
                    synYCoord = top + height;
                    g.setColor(new Color(255, 69, 0));
                    g.drawLine(synXCoord, synYCoord, synXCoord, synYCoord);
                } else if (synExpressionValue < tempVar && synExpressionValue > tempVar - step) {
                    unknown = (10.0f * Math.abs(tempVar) - 10.0f * Math.abs(synExpressionValue)) / step;
                    synYCoord = (int)((float)synYCoord - factor * (float)count);
                    synYCoord = Math.round((float)synYCoord + unknown * 10.0f);
                    g.setColor(new Color(255, 69, 0));
                    g.drawLine(synXCoord, synYCoord, synXCoord, synYCoord);
                } else if (synExpressionValue == tempVar) {
                    if (synExpressionValue == this.getStepsY()) {
                        synYCoord = (int)((float)(top + height) - factor);
                        g.setColor(new Color(255, 69, 0));
                        g.drawLine(synXCoord, synYCoord, synXCoord, synYCoord);
                    } else {
                        synYCoord = (int)((float)synYCoord - factor * (float)count);
                        g.setColor(new Color(255, 69, 0));
                        g.drawLine(synXCoord, synYCoord, synXCoord, synYCoord);
                    }
                } else if (corExpressionValue < this.getStepsY()) {
                    corYCoord = top + height;
                    g.setColor(new Color(105, 105, 105));
                    g.drawLine(corXCoord, corYCoord, corXCoord, corYCoord);
                } else if (corExpressionValue < tempVar && corExpressionValue > tempVar - step) {
                    unknown = (10.0f * Math.abs(tempVar) - 10.0f * Math.abs(corExpressionValue)) / step;
                    corYCoord = (int)((float)corYCoord - factor * (float)count);
                    corYCoord = Math.round((float)corYCoord + unknown * 10.0f);
                    g.setColor(new Color(105, 105, 105));
                    g.drawLine(corXCoord, corYCoord, corXCoord, corYCoord);
                } else if (corExpressionValue == tempVar) {
                    if (corExpressionValue == this.getStepsY()) {
                        corYCoord = (int)((float)(top + height) - factor);
                        g.setColor(new Color(105, 105, 105));
                        g.drawLine(corXCoord, corYCoord, corXCoord, corYCoord);
                    } else {
                        corYCoord = (int)((float)corYCoord - factor * (float)count);
                        g.setColor(new Color(105, 105, 105));
                        g.drawLine(corXCoord, corYCoord, corXCoord, corYCoord);
                    }
                }
                if (count >= 4) continue;
                ++count;
            }
            if (this.numSamplesPerGroup.contains(index)) {
                g.setColor(Color.BLACK);
                g.drawLine(synXCoord, top, synXCoord, top + height);
                if (verticalLineCoord == -1) {
                    g.drawString("Group " + grpNumber, synXCoord / 2, this.getHeight() - 8);
                    verticalLineCoord = synXCoord;
                } else {
                    g.drawString("Group " + grpNumber, (synXCoord + verticalLineCoord) / 2, this.getHeight() - 8);
                    verticalLineCoord = synXCoord;
                }
                if (grpNumber <= this.factorLevels[0]) {
                    ++grpNumber;
                }
            }
            if (index == numberOfSamples - 1) {
                g.setColor(Color.BLACK);
                g.drawString("Group " + grpNumber, (synXCoord + verticalLineCoord) / 2, this.getHeight() - 8);
            }
            if (index == 0) {
                oldSynYCoord = synYCoord;
                oldSynXCoord = synXCoord;
                oldCorXCoord = corXCoord;
                oldCorYCoord = corYCoord;
                continue;
            }
            g.setColor(new Color(255, 69, 0));
            g.drawLine(oldSynXCoord, oldSynYCoord, synXCoord, synYCoord);
            oldSynXCoord = synXCoord;
            oldSynYCoord = synYCoord;
            g.setColor(new Color(105, 105, 105));
            g.drawLine(oldCorXCoord, oldCorYCoord, corXCoord, corYCoord);
            oldCorXCoord = corXCoord;
            oldCorYCoord = corYCoord;
        }
    }

    public JComponent getContentComponent() {
        return this;
    }

    protected int getNamesWidth(FontMetrics metrics) {
        int maxWidth = 0;
        maxWidth = Math.max(maxWidth, metrics.stringWidth("Group 1"));
        return maxWidth;
    }

    public int[][] getClusters() {
        return null;
    }

    public JComponent getCornerComponent(int cornerIndex) {
        return null;
    }

    public Experiment getExperiment() {
        return null;
    }

    public int getExperimentID() {
        return 0;
    }

    public Expression getExpression() {
        return new Expression(this, this.getClass(), "new", new Object[]{this.synExpression, this.corrGeneExpression, this.groupAssignments, this.factorLevels});
    }

    public JComponent getHeaderComponent() {
        return null;
    }

    public BufferedImage getImage() {
        return null;
    }

    public JComponent getRowHeaderComponent() {
        return null;
    }

    public int getViewerType() {
        return 0;
    }

    public void onClosed() {
    }

    public void onDataChanged(IData data) {
    }

    public void onDeselected() {
    }

    public void onMenuChanged(IDisplayMenu menu) {
    }

    public void onSelected(IFramework framework) {
    }

    public void setExperiment(Experiment e) {
    }

    public void setExperimentID(int id) {
    }
}

