/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.attract;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.Expression;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.cluster.gui.GSEAExperiment;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.helpers.GSEAURLLinkDialog;
import org.tigr.microarray.mev.cluster.gui.helpers.TableViewer;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;

public class SynExpressionTableViewer
extends TableViewer {
    private static final String SAVE_TABLE_COMMAND = "save_table_command";
    private static final String STORE_CLUSTER_COMMAND = "store_cluster_command";
    private static final String LINK_TO_URL_COMMAND = "link-to-url-command";
    private static final String CLEAR_ALL_COMMAND = "clear-all-cmd";
    private static final String SELECT_ALL_COMMAND = "select-all-cmd";
    private JPopupMenu menu;
    private DefaultMutableTreeNode attractRoot;
    private int[][] clusters;
    private JMenuItem urlMenuItem;
    int xColumn;

    public SynExpressionTableViewer(String[] headerNames, Object[][] data, DefaultMutableTreeNode analysisNode, GSEAExperiment experiment) {
    }

    public SynExpressionTableViewer(String[] headerNames, Object[][] data) {
        super(headerNames, data);
        this.menu = this.createPopupMenu();
        this.table.setRowSelectionAllowed(true);
        this.table.addMouseListener(new Listener());
        if (this.table.getRowCount() > 0) {
            this.table.getSelectionModel().setSelectionInterval(0, 0);
        }
    }

    public Expression getExpression() {
        return new Expression((Object)this, ((Object)((Object)this)).getClass(), "new", new Object[]{this.headerNames, this.data});
    }

    protected JPopupMenu createPopupMenu() {
        Listener listener = new Listener();
        JPopupMenu menu = new JPopupMenu();
        JMenuItem item = new JMenuItem("Store Selection as Cluster");
        item.setActionCommand(STORE_CLUSTER_COMMAND);
        item.addActionListener(listener);
        menu.add(item);
        menu.addSeparator();
        item = new JMenuItem(SAVE_TABLE_COMMAND);
        item.setActionCommand(SAVE_TABLE_COMMAND);
        item.addActionListener(listener);
        menu.add(item);
        menu.addSeparator();
        item = new JMenuItem("Select all rows...", GUIFactory.getIcon("TableViewerResult.gif"));
        item.setActionCommand(SELECT_ALL_COMMAND);
        item.addActionListener(listener);
        menu.add(item);
        menu.addSeparator();
        item = new JMenuItem("Clear all selections...", GUIFactory.getIcon("TableViewerResult.gif"));
        item.setActionCommand(CLEAR_ALL_COMMAND);
        item.addActionListener(listener);
        menu.add(item);
        menu.addSeparator();
        this.urlMenuItem = new JMenuItem("Link to URL");
        this.urlMenuItem.setActionCommand(LINK_TO_URL_COMMAND);
        this.urlMenuItem.addActionListener(listener);
        menu.add(this.urlMenuItem);
        return menu;
    }

    public void onSelected(IFramework framework) {
        super.onSelected(framework);
        if (this.attractRoot == null) {
            try {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)framework.getCurrentNode().getParent();
                Object userObject = node.getUserObject();
                if (userObject instanceof String && ((String)userObject).indexOf("GSEA") != -1) {
                    this.attractRoot = node;
                }
            }
            catch (Exception e) {
                System.out.println("selection exception");
                e.printStackTrace();
            }
        }
    }

    private void linkToURL2() {
        JFrame frame = (JFrame)JOptionPane.getFrameForComponent(this.table);
        this.xColumn = this.table.getSelectedColumn();
        String colName = this.table.getColumnName(this.xColumn);
        String Annotation2 = (String)this.table.getValueAt(this.table.getSelectedRow(), this.xColumn);
        File file = TMEV.getConfigurationFile((String)"annotation_URLs.txt");
        GSEAURLLinkDialog adialog = new GSEAURLLinkDialog(frame, false, Annotation2, this.table.getSelectedRow(), colName, file);
        adialog.setVisible(true);
    }

    protected void onStoreSelectedRows() {
        int[] tableIndices = this.table.getSelectedRows();
        if (tableIndices == null || tableIndices.length == 0) {
            return;
        }
        for (int i = 0; i < tableIndices.length; ++i) {
            tableIndices[i] = ((TableViewer.DefaultViewerTableModel)this.model).getRow(tableIndices[i]);
        }
        JFileChooser chooser = new JFileChooser(TMEV.getFile((String)"/Data"));
        String fileName = "";
        if (chooser.showSaveDialog((Component)((Object)this)) == 0) {
            File file = chooser.getSelectedFile();
            fileName = file.getName();
            try {
                PrintWriter pw = new PrintWriter(new FileOutputStream(file));
                int rows = tableIndices.length;
                int cols = this.table.getColumnCount();
                for (int row = 0; row < rows; ++row) {
                    for (int col = 0; col < cols; ++col) {
                        pw.print((String)this.table.getValueAt(tableIndices[row], col) + "\t");
                    }
                    pw.print("\n");
                }
                pw.flush();
                pw.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                JOptionPane.showMessageDialog((Component)((Object)this), "Error Saving Table to file: " + fileName, "Output Error", 2);
            }
        }
    }

    protected void onSaveTable() {
        JFileChooser chooser = new JFileChooser(TMEV.getFile((String)"/Data"));
        String fileName = "";
        if (chooser.showSaveDialog((Component)((Object)this)) == 0) {
            File file = chooser.getSelectedFile();
            fileName = file.getName();
            try {
                PrintWriter pw = new PrintWriter(new FileOutputStream(file));
                int rows = this.table.getRowCount();
                int cols = this.table.getColumnCount();
                for (int row = 0; row < rows; ++row) {
                    for (int col = 0; col < cols; ++col) {
                        pw.print((String)this.table.getValueAt(row, col) + "\t");
                    }
                    pw.print("\n");
                }
                pw.flush();
                pw.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                JOptionPane.showMessageDialog((Component)((Object)this), "Error Saving Table to file: " + fileName, "Output Error", 2);
            }
        }
    }

    protected int[] getGeneIndices(int[] rows) {
        int numGenes = 0;
        for (int i = 0; i < rows.length; ++i) {
            numGenes += this.clusters[rows[i]].length;
        }
        int[] indices = new int[numGenes];
        int cnt = 0;
        for (int i = 0; i < rows.length; ++i) {
            for (int j = 0; j < this.clusters[rows[i]].length; ++j) {
                indices[cnt] = this.clusters[rows[i]][j];
                ++cnt;
            }
        }
        return indices;
    }

    protected void validateMenuOptions() {
        int row = this.getSelectedRow();
        if (row < 0) {
            return;
        }
    }

    protected class Listener
    extends MouseAdapter
    implements ActionListener {
        protected Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            String command = ae.getActionCommand();
            if (command.equals(SynExpressionTableViewer.LINK_TO_URL_COMMAND)) {
                SynExpressionTableViewer.this.linkToURL2();
            } else if (command.equals(SynExpressionTableViewer.STORE_CLUSTER_COMMAND)) {
                SynExpressionTableViewer.this.onStoreSelectedRows();
            } else if (command.equals(SynExpressionTableViewer.SAVE_TABLE_COMMAND)) {
                SynExpressionTableViewer.this.onSaveTable();
            } else if (command.equals(SynExpressionTableViewer.CLEAR_ALL_COMMAND)) {
                SynExpressionTableViewer.this.table.clearSelection();
            } else if (command.equals(SynExpressionTableViewer.SELECT_ALL_COMMAND)) {
                SynExpressionTableViewer.this.table.selectAll();
            }
        }

        @Override
        public void mousePressed(MouseEvent me) {
            if (me.isPopupTrigger()) {
                if (SynExpressionTableViewer.this.table.getSelectedRowCount() != 1) {
                    SynExpressionTableViewer.this.urlMenuItem.setEnabled(false);
                } else {
                    SynExpressionTableViewer.this.urlMenuItem.setEnabled(true);
                }
                SynExpressionTableViewer.this.menu.show(me.getComponent(), me.getX(), me.getY());
            }
        }

        @Override
        public void mouseReleased(MouseEvent me) {
            if (me.isPopupTrigger()) {
                SynExpressionTableViewer.this.menu.show(me.getComponent(), me.getX(), me.getY());
            }
        }
    }
}

