/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.attract;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.filechooser.FileFilter;
import org.tigr.microarray.mev.GeneAnnotationImportDialog;
import org.tigr.microarray.mev.MultipleArrayData;
import org.tigr.microarray.mev.annotation.AnnotationFieldConstants;
import org.tigr.microarray.mev.annotation.AnnotationFileReader;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.IWizardParameterPanel;
import org.tigr.microarray.mev.cluster.gui.impl.gsea.BroadGeneSet;
import org.tigr.microarray.mev.cluster.gui.impl.gsea.BroadGeneSetList;
import org.tigr.microarray.mev.cluster.gui.impl.gsea.GSEAConstants;
import org.tigr.microarray.mev.cluster.gui.impl.gsea.GeneSigDbGeneSets;
import org.tigr.microarray.mev.file.AnnotationDownloadHandler;
import org.tigr.microarray.mev.file.GBA;
import org.tigr.microarray.mev.file.SuperExpressionFileLoader;
import org.tigr.microarray.mev.resources.FileResourceManager;
import org.tigr.microarray.mev.resources.ISupportFileDefinition;
import org.tigr.microarray.mev.resources.RepositoryInitializationError;
import org.tigr.microarray.mev.resources.SelectMultiFilesDialog;
import org.tigr.microarray.mev.resources.SupportFileAccessError;
import org.tigr.microarray.util.FileLoaderUtility;
import org.tigr.util.swing.GeneMatrixFileFilter;
import org.tigr.util.swing.GeneMatrixTransposeFileFilter;
import org.tigr.util.swing.TXTFileFilter;

public class ParameterPanel
extends JPanel
implements IWizardParameterPanel {
    private JPanel parameterPanel;
    private JLabel probeInformationLabel;
    private JLabel probe2GeneLabel;
    private JComboBox choiceBox;
    private JLabel minGeneLabel;
    private JTextField geneNumber;
    private JLabel SDCutoffLabel;
    private JTextField sdTextField;
    private JLabel permutationLabel;
    private JTextField permutationTextField;
    private JTextField LIMMACutoffTextField;
    private JTextField topPathwaysTextField;
    private JLabel LIMMACutoffLabel;
    private JLabel topPathwaysLabel;
    private AlgorithmData algData;
    private IFramework fwork;
    private GBA gba;
    private JPanel genesetPanel;
    private JPanel choicePanel;
    private JPanel fileSelectionPanel;
    private JPanel buttonPanel;
    private JPanel listPanel;
    private JPanel selectFilePanel;
    private JPanel identifierSelectionPanel;
    private JLabel selectFile;
    private JLabel availableLabel;
    private JLabel selectedLabel;
    private JList availableList;
    private JList selectedList;
    private JButton addButton;
    private JButton addAllButton;
    private JButton removeButton;
    private JButton removeAllButton;
    private JScrollPane availableScrollPane;
    private JScrollPane selectedScrollPane;
    private JLabel errorMessageLabel;
    private JTextField pathTextField;
    private JButton browse;
    private JLabel geneIdentifierLabel;
    private JComboBox geneIdentifierBox;
    private JComboBox geneSetSelectionBox;
    private JLabel genesetSelectionLabel;
    private String genesetFilePath;
    private String fileFilter = new String();
    private FileResourceManager frm;
    private JPanel annotationPanel;
    private AnnotationDownloadHandler adh;

    public ParameterPanel(AlgorithmData algData, JFrame parent, IFramework framework) {
        this.fwork = framework;
        this.algData = algData;
        this.initializePanel();
        this.initialize(GSEAConstants.MAX_PROBE, Integer.toString(5), "0.6", Integer.toString(1000), Double.toString(0.05), Integer.toString(5));
    }

    public void initializePanel() {
        this.setPreferredSize(new Dimension(1000, 850));
        this.setBackground(Color.WHITE);
        this.setLayout(new GridBagLayout());
        this.gba = new GBA();
        String[] Key2 = new String[]{"Max_Probe", "Median_Probe", "Standard_Deviation"};
        this.probe2GeneLabel = new JLabel();
        this.probe2GeneLabel.setText("Select a method to collapse probes");
        this.probe2GeneLabel.setHorizontalTextPosition(2);
        this.choiceBox = new JComboBox<String>(Key2);
        this.choiceBox.addActionListener(new Listener());
        this.probeInformationLabel = new JLabel();
        this.probeInformationLabel.setText("<html>( If multiple probes in the expression data map to one gene, MeV can use either the <br> 1. Probe with the maximum expression value. 2. Median of the expression values. 3. SD of the expression values...whichever you choose) </html>");
        this.probeInformationLabel.setHorizontalTextPosition(2);
        this.probeInformationLabel.setFont(new Font("Dialog", 2, 12));
        this.SDCutoffLabel = new JLabel();
        this.SDCutoffLabel.setText("Select a cut off, if you chose Standard Deviation to collapse probes");
        this.SDCutoffLabel.setHorizontalTextPosition(2);
        this.SDCutoffLabel.setEnabled(false);
        this.sdTextField = new JTextField();
        this.sdTextField.setPreferredSize(new Dimension(100, 30));
        this.sdTextField.setEditable(true);
        this.sdTextField.setEnabled(false);
        this.sdTextField.setActionCommand("standard-deviation");
        this.minGeneLabel = new JLabel();
        this.minGeneLabel.setText("Minimum number of genes per gene set");
        this.minGeneLabel.setHorizontalTextPosition(2);
        this.geneNumber = new JTextField();
        this.geneNumber.setPreferredSize(new Dimension(100, 30));
        this.geneNumber.setEditable(true);
        this.geneNumber.setActionCommand("gene-number");
        this.permutationLabel = new JLabel();
        this.permutationLabel.setText("Enter number of permutations");
        this.permutationLabel.setHorizontalTextPosition(2);
        this.permutationTextField = new JTextField();
        this.permutationTextField.setPreferredSize(new Dimension(100, 30));
        this.permutationTextField.setEditable(true);
        this.permutationTextField.setActionCommand("permutations");
        this.LIMMACutoffLabel = new JLabel("Select significance level: Alpha ");
        this.LIMMACutoffTextField = new JTextField();
        this.LIMMACutoffTextField.setActionCommand("limma-cutoff");
        this.topPathwaysLabel = new JLabel("Select maximum genesets for synexpression calculation");
        this.topPathwaysTextField = new JTextField();
        this.topPathwaysTextField.setEditable(true);
        this.topPathwaysTextField.setActionCommand("top-pathways");
        this.parameterPanel = new JPanel();
        this.parameterPanel.setBackground(Color.WHITE);
        this.parameterPanel.setLayout(new GridBagLayout());
        this.parameterPanel.setBorder(new EtchedBorder());
        this.gba.add((Container)this.parameterPanel, (Component)this.probe2GeneLabel, 0, 0, 1, 1, 1, 0, 2, 10, new Insets(2, 2, 2, 2), 0, 0);
        this.gba.add((Container)this.parameterPanel, (Component)this.choiceBox, 2, 0, -1, 1, 0, 0, 0, 10, new Insets(2, 2, 2, 2), 0, 0);
        this.gba.add((Container)this.parameterPanel, (Component)this.probeInformationLabel, 0, 3, 1, 1, 0, 0, 1, 10, new Insets(2, 2, 2, 2), 0, 0);
        this.gba.add((Container)this.parameterPanel, (Component)this.SDCutoffLabel, 0, 4, 2, 1, 0, 0, 2, 10, new Insets(2, 2, 2, 2), 0, 0);
        this.gba.add((Container)this.parameterPanel, (Component)this.sdTextField, 2, 4, -1, 1, 2, 0, 2, 10, new Insets(2, 2, 2, 2), 0, 0);
        this.gba.add((Container)this.parameterPanel, (Component)this.minGeneLabel, 0, 7, 2, 1, 0, 0, 2, 10, new Insets(2, 2, 2, 2), 0, 0);
        this.gba.add((Container)this.parameterPanel, (Component)this.geneNumber, 2, 7, -1, 1, 2, 0, 2, 10, new Insets(2, 2, 2, 2), 0, 0);
        this.gba.add((Container)this.parameterPanel, (Component)this.permutationLabel, 0, 8, 2, 1, 0, 0, 2, 10, new Insets(2, 2, 2, 2), 0, 0);
        this.gba.add((Container)this.parameterPanel, (Component)this.permutationTextField, 2, 8, -1, 1, 2, 0, 2, 10, new Insets(2, 2, 2, 2), 0, 0);
        this.gba.add((Container)this.parameterPanel, (Component)this.LIMMACutoffLabel, 0, 9, 2, 1, 0, 0, 2, 10, new Insets(2, 2, 2, 2), 0, 0);
        this.gba.add((Container)this.parameterPanel, (Component)this.LIMMACutoffTextField, 2, 9, -1, 1, 2, 0, 2, 10, new Insets(2, 2, 2, 2), 0, 0);
        this.gba.add((Container)this.parameterPanel, (Component)this.topPathwaysLabel, 0, 10, 2, 1, 0, 0, 2, 10, new Insets(2, 2, 2, 2), 0, 0);
        this.gba.add((Container)this.parameterPanel, (Component)this.topPathwaysTextField, 2, 10, -1, 1, 2, 0, 2, 10, new Insets(2, 2, 2, 2), 0, 0);
        this.genesetPanel = new JPanel();
        this.genesetPanel.setBackground(Color.WHITE);
        this.genesetPanel.setLayout(new GridBagLayout());
        this.genesetPanel.setBorder(new EtchedBorder());
        this.choicePanel = new JPanel();
        this.choicePanel.setBackground(Color.white);
        this.choicePanel.setLayout(new GridBagLayout());
        this.genesetSelectionLabel = new JLabel("Gene set selection method");
        String[] selectionMethods = new String[]{"Load local geneset file/files", "Download from MSigDB", "Download from GeneSigDB"};
        this.geneSetSelectionBox = new JComboBox<String>(selectionMethods);
        this.geneSetSelectionBox.addActionListener(new Listener());
        this.gba.add((Container)this.choicePanel, (Component)this.genesetSelectionLabel, 0, 0, 1, 1, 1, 0, 2, 10, new Insets(0, 0, 0, 0), 0, 0);
        this.gba.add((Container)this.choicePanel, (Component)this.geneSetSelectionBox, 2, 0, 1, 1, 1, 0, 2, 10, new Insets(0, 0, 0, 0), 0, 0);
        this.createDownloadPanel("Select the directory containing your gene sets", "Browse", "browse");
        this.identifierSelectionPanel = new JPanel();
        this.identifierSelectionPanel.setLayout(new GridBagLayout());
        this.identifierSelectionPanel.setBackground(Color.white);
        this.geneIdentifierLabel = new JLabel("Select the identifier used to annotate genes in selected gene set/s");
        Field[] fields = AnnotationFieldConstants.class.getFields();
        String[] annotation = new String[fields.length + 1];
        annotation[0] = "";
        try {
            for (int index = 0; index < fields.length; ++index) {
                annotation[index + 1] = (String)fields[index].get(new AnnotationFieldConstants());
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        this.geneIdentifierBox = new JComboBox<String>(annotation);
        this.geneIdentifierBox.addActionListener(new Listener());
        this.gba.add((Container)this.identifierSelectionPanel, (Component)this.geneIdentifierLabel, 0, 0, 1, 1, 1, 1, 1, 10, new Insets(2, 2, 2, 2), 0, 0);
        this.gba.add((Container)this.identifierSelectionPanel, (Component)this.geneIdentifierBox, 0, 1, 1, 1, 0, 0, 1, 10, new Insets(2, 2, 2, 2), 0, 0);
        this.gba.add((Container)this.genesetPanel, (Component)this.choicePanel, 0, 0, 1, 1, 1, 1, 1, 10, new Insets(2, 2, 2, 2), 0, 0);
        this.gba.add((Container)this.genesetPanel, (Component)this.fileSelectionPanel, 0, 1, 1, 1, 1, 1, 1, 10, new Insets(2, 2, 2, 2), 0, 0);
        this.gba.add((Container)this.genesetPanel, (Component)this.identifierSelectionPanel, 0, 5, 1, 1, 1, 1, 1, 10, new Insets(2, 2, 2, 2), 0, 0);
        this.annotationPanel = new JPanel();
        this.annotationPanel.setLayout(new GridBagLayout());
        this.annotationPanel.setBorder(new EtchedBorder());
        this.adh = new AnnotationDownloadHandler(this.fwork);
        if (this.fwork.getData().isAnnotationLoaded()) {
            this.annotationPanel.setVisible(false);
            this.adh.setOptionalMessage("Annotation is already loaded for array " + this.fwork.getData().getChipAnnotation().getChipType());
            this.adh.setAnnFilePath(this.fwork.getData().getChipAnnotation().getAnnFileName());
        }
        this.adh.addListener((ActionListener)new Listener());
        this.annotationPanel = this.adh.getAnnotationLoaderPanel(this.gba);
        this.annotationPanel.setBackground(Color.white);
        this.adh.setDownloadEnabled(!this.fwork.getData().isAnnotationLoaded());
        this.gba.add((Container)this, (Component)this.parameterPanel, 0, 0, 1, 1, 1, 1, 1, 10, new Insets(2, 2, 2, 2), 0, 0);
        this.gba.add((Container)this, (Component)this.genesetPanel, 0, 2, 1, 1, 100, 100, 1, 10, new Insets(2, 2, 2, 2), 0, 0);
        this.gba.add((Container)this, (Component)this.annotationPanel, 0, 4, 1, 1, 1, 1, 1, 10, new Insets(2, 2, 2, 2), 0, 0);
        this.revalidate();
    }

    public void initialize(String collapseMode, String minGenes, String SDcutoff, String num_Perms, String LIMMAcutoff, String numPathways) {
        this.choiceBox.setSelectedItem(collapseMode);
        this.geneNumber.setText(minGenes);
        this.sdTextField.setText(SDcutoff);
        this.permutationTextField.setText(num_Perms);
        this.LIMMACutoffTextField.setText(LIMMAcutoff);
        this.topPathwaysTextField.setText(numPathways);
    }

    public void createDownloadPanel(String label, String buttonName, String actionCommand) {
        this.fileSelectionPanel = new JPanel();
        this.fileSelectionPanel.setLayout(new GridBagLayout());
        this.fileSelectionPanel.setBackground(Color.white);
        this.selectFilePanel = new JPanel();
        this.selectFilePanel.setLayout(new GridBagLayout());
        this.selectFilePanel.setBackground(Color.white);
        this.selectFile = new JLabel(label);
        this.pathTextField = new JTextField();
        if (actionCommand.equalsIgnoreCase("msigdb_download")) {
            this.pathTextField.setEditable(true);
        }
        this.pathTextField.setFont(new Font("monospaced", 1, 12));
        this.pathTextField.setPreferredSize(new Dimension(500, 20));
        this.browse = new JButton(buttonName);
        this.browse.setName(buttonName);
        this.browse.setActionCommand(actionCommand);
        this.browse.setSize(new Dimension(100, 30));
        this.browse.setPreferredSize(new Dimension(100, 30));
        this.browse.addActionListener(new Listener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equalsIgnoreCase("browse")) {
                    ParameterPanel.this.onBrowse();
                } else if (e.getActionCommand().equalsIgnoreCase("msigdb_download")) {
                    if (ParameterPanel.this.pathTextField.getText().length() > 0) {
                        ParameterPanel.this.errorMessageLabel.setText("");
                        ParameterPanel.this.BROADDownloads(ParameterPanel.this.pathTextField.getText());
                        ParameterPanel.this.geneIdentifierBox.setSelectedItem("GENE_SYMBOL");
                        ParameterPanel.this.geneIdentifierBox.setEnabled(false);
                    } else {
                        String eMsg = "<html><font color=red>Please enter your registered MSigDB email address<br> </font></html>";
                        ParameterPanel.this.errorMessageLabel.setText(eMsg);
                    }
                } else if (e.getActionCommand().equalsIgnoreCase("genesigdb_download")) {
                    ParameterPanel.this.GeneSigDBDownloads();
                }
            }
        });
        this.gba.add((Container)this.selectFilePanel, (Component)this.selectFile, 0, 0, 1, 1, 0, 0, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.gba.add((Container)this.selectFilePanel, (Component)this.pathTextField, 1, 0, 1, 1, 1, 0, 2, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.gba.add((Container)this.selectFilePanel, (Component)this.browse, 2, 0, -1, 1, 0, 0, 0, 10, new Insets(5, 5, 5, 5), 0, 0);
        if (buttonName.equalsIgnoreCase("Download")) {
            this.errorMessageLabel = new JLabel();
            this.gba.add((Container)this.selectFilePanel, (Component)this.errorMessageLabel, 0, 2, 1, 1, 0, 0, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
        }
        this.listPanel = new JPanel();
        this.listPanel.setLayout(new GridBagLayout());
        this.listPanel.setBackground(Color.white);
        this.availableLabel = new JLabel("Available");
        this.selectedLabel = new JLabel("Selected");
        this.availableList = new JList(new DefaultListModel());
        this.availableList.setName("availableList");
        this.selectedList = new JList(new DefaultListModel());
        this.selectedList.setName("selectedList");
        this.availableScrollPane = new JScrollPane(this.availableList);
        this.availableScrollPane.setPreferredSize(new Dimension(250, 90));
        this.selectedScrollPane = new JScrollPane(this.selectedList);
        this.selectedScrollPane.setPreferredSize(new Dimension(250, 90));
        this.addButton = new JButton("Add");
        this.addButton.setPreferredSize(new Dimension(100, 20));
        this.addButton.addActionListener(new Listener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ParameterPanel.this.onAdd("availableList");
            }
        });
        this.addAllButton = new JButton("Add All");
        this.addAllButton.setPreferredSize(new Dimension(100, 20));
        this.addAllButton.addActionListener(new Listener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ParameterPanel.this.onAddAll("availableList");
            }
        });
        this.removeButton = new JButton("Remove");
        this.removeButton.setPreferredSize(new Dimension(100, 20));
        this.removeButton.addActionListener(new Listener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ParameterPanel.this.onRemove("selectedList");
            }
        });
        this.removeAllButton = new JButton("Remove All");
        this.removeAllButton.setPreferredSize(new Dimension(100, 20));
        this.removeAllButton.addActionListener(new Listener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ParameterPanel.this.onRemoveAll("selectedList");
            }
        });
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new GridBagLayout());
        this.buttonPanel.setBackground(Color.white);
        this.gba.add((Container)this.buttonPanel, (Component)this.addButton, 0, 0, 1, 1, 1, 1, 11, 10, new Insets(2, 2, 2, 2), 0, 0);
        this.gba.add((Container)this.buttonPanel, (Component)this.addAllButton, 0, 1, 1, 1, 1, 1, 11, 10, new Insets(2, 2, 2, 2), 0, 0);
        this.gba.add((Container)this.buttonPanel, (Component)this.removeButton, 0, 2, 1, 1, 1, 1, 11, 10, new Insets(2, 2, 2, 2), 0, 0);
        this.gba.add((Container)this.buttonPanel, (Component)this.removeAllButton, 0, 3, 1, 1, 1, 1, 11, 10, new Insets(2, 2, 2, 2), 0, 0);
        this.gba.add((Container)this.listPanel, (Component)this.availableLabel, 0, 0, 1, 1, 0, 0, 11, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.gba.add((Container)this.listPanel, (Component)this.availableScrollPane, 0, 1, 1, 4, 5, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.gba.add((Container)this.listPanel, (Component)this.buttonPanel, 1, 1, 1, 4, 1, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.gba.add((Container)this.listPanel, (Component)this.selectedLabel, 2, 0, 1, 1, 0, 0, 11, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.gba.add((Container)this.listPanel, (Component)this.selectedScrollPane, 2, 1, 1, 4, 5, 1, 1, 10, new Insets(5, 5, 5, 5), 0, 0);
        this.gba.add((Container)this.fileSelectionPanel, (Component)this.selectFilePanel, 0, 0, 1, 1, 1, 1, 1, 10, new Insets(2, 2, 2, 2), 0, 0);
        this.gba.add((Container)this.fileSelectionPanel, (Component)this.listPanel, 0, 2, 1, 1, 1, 1, 1, 10, new Insets(2, 2, 2, 2), 0, 0);
        this.gba.add((Container)this.genesetPanel, (Component)this.fileSelectionPanel, 0, 1, 1, 1, 1, 1, 1, 10, new Insets(2, 2, 2, 2), 0, 0);
        this.revalidate();
    }

    @Override
    public void populateAlgorithmData() {
        if (this.choiceBox.getSelectedItem() != null) {
            if (this.choiceBox.getSelectedItem().equals("Max_Probe")) {
                this.algData.addParam("probe_value", GSEAConstants.MAX_PROBE);
            }
            if (this.choiceBox.getSelectedItem().equals("Median_Probe")) {
                this.algData.addParam("probe_value", GSEAConstants.MEDIAN_PROBE);
            }
            if (this.choiceBox.getSelectedItem().equals("Standard_Deviation")) {
                this.algData.addParam("probe_value", GSEAConstants.SD);
                this.algData.addParam("standard-deviation-cutoff", this.sdTextField.getText());
            }
        } else {
            this.algData.addParam("probe_value", GSEAConstants.MAX_PROBE);
            this.algData.addParam("standard-deviation-cutoff", "NA");
        }
        if (this.geneNumber.getText().length() != 0) {
            this.algData.addParam("gene-number", this.geneNumber.getText());
        } else {
            this.algData.addParam("gene-number", "");
        }
        if (this.permutationTextField.getText().length() != 0) {
            this.algData.addParam("permutations", this.permutationTextField.getText());
        } else {
            this.algData.addParam("permutations", "");
        }
        if (this.topPathwaysTextField.getText().length() != 0) {
            this.algData.addParam("pathway-cutoff", this.topPathwaysTextField.getText());
        } else {
            this.algData.addParam("pathway-cutoff", "");
        }
        if (this.LIMMACutoffTextField.getText().length() != 0) {
            this.algData.addParam("LIMMA-cutoff", this.LIMMACutoffTextField.getText());
        } else {
            this.algData.addParam("LIMMA-cutoff", "");
        }
        if (((String)this.geneSetSelectionBox.getSelectedItem()).equalsIgnoreCase("Load local geneset file/files")) {
            this.algData.addParam("gene-set-directory", this.pathTextField.getText());
        } else if (((String)this.geneSetSelectionBox.getSelectedItem()).equalsIgnoreCase("Download from MSigDB")) {
            this.algData.addParam("gene-set-directory", this.genesetFilePath);
        } else if (((String)this.geneSetSelectionBox.getSelectedItem()).equalsIgnoreCase("Download from GeneSigDB")) {
            this.algData.addParam("gene-set-directory", this.genesetFilePath);
        } else {
            this.algData.addParam("gene-set-directory", "");
        }
        if (this.getFileFilter().equalsIgnoreCase("") && ((String)this.geneIdentifierBox.getSelectedItem()).equalsIgnoreCase("")) {
            this.algData.addParam("gene-identifier", "");
        } else if (this.getFileFilter().equalsIgnoreCase("Gene Matrix and Gene Matrix Transpose (*.gmt, *.gmx)")) {
            this.algData.addParam("gene-identifier", "GENE_SYMBOL");
        } else {
            this.algData.addParam("gene-identifier", (String)this.geneIdentifierBox.getSelectedItem());
        }
        this.algData.addStringArray("gene-set-files", this.getAllSelectedItems());
        if (this.adh.isAnnotationSelected()) {
            this.algData.addParam("annotation-file", this.adh.getAnnFilePath());
        } else if (this.fwork.getData().isAnnotationLoaded()) {
            this.algData.addParam("annotation-file", this.fwork.getData().getChipAnnotation().getAnnFileName());
        } else {
            this.algData.addParam("annotation-file", "");
        }
    }

    @Override
    public void clearValuesFromAlgorithmData() {
        this.algData.getParams().getMap().remove("probe_value");
        this.algData.getParams().getMap().remove("gene-number");
        this.algData.getParams().getMap().remove("standard-deviation-cutoff");
        this.algData.getParams().getMap().remove("permutations");
        this.algData.getParams().getMap().remove("pathway-cutoff");
        this.algData.getParams().getMap().remove("LIMMA-cutoff");
    }

    public void processAnnotationFile() {
        try {
            String[] dataFieldNames = this.fwork.getData().getFieldNames();
            AnnotationFileReader reader = AnnotationFileReader.createAnnotationFileReader((File)this.getAnnotationFile());
            GeneAnnotationImportDialog importDialog = new GeneAnnotationImportDialog(new JFrame(), dataFieldNames, reader.getAvailableAnnotations());
            if (importDialog.showModal() == 0) {
                ((MultipleArrayData)this.fwork.getData()).addResourcererGeneAnnotation(importDialog.getDataAnnotationKey(), reader.getAffyAnnotation());
                this.fwork.getData().setChipAnnotation(reader.getAffyChipAnnotation());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.fwork.getData().setAnnotationLoaded(true);
    }

    private File getAnnotationFile() {
        return new File(this.adh.getAnnFilePath());
    }

    private void GeneSigDBDownloads() {
        try {
            this.frm = new FileResourceManager(new File(new File(System.getProperty("user.home"), ".mev"), "repository"));
            GeneSigDbGeneSets temp = new GeneSigDbGeneSets();
            File geneSigs = this.frm.getSupportFile((ISupportFileDefinition)temp, true);
            if (temp.isValid(geneSigs)) {
                System.out.println("GeneSigDb download file is valid.");
                this.genesetFilePath = geneSigs.getParent();
                this.pathTextField.setText(this.genesetFilePath);
                ((DefaultListModel)this.selectedList.getModel()).addElement(new File(geneSigs.getName()));
            }
        }
        catch (SupportFileAccessError sfae) {
            System.out.println("Could not download GeneSigDbGeneSets file.");
        }
        catch (RepositoryInitializationError e) {
            e.printStackTrace();
        }
    }

    private void BROADDownloads(String emailID) {
        try {
            this.frm = new FileResourceManager(new File(new File(System.getProperty("user.home"), ".mev"), "repository"));
            File geneSetList = this.frm.getSupportFile((ISupportFileDefinition)new BroadGeneSetList(), true);
            try {
                ArrayList<String> genesetFilenames = BroadGeneSetList.getFileNames(geneSetList);
                String email = emailID;
                String[] genesetFileNameArray = new String[genesetFilenames.size()];
                int index = 0;
                ArrayList<BroadGeneSet> defs = new ArrayList<BroadGeneSet>();
                Iterator<String> it = genesetFilenames.iterator();
                while (it.hasNext()) {
                    genesetFileNameArray[index] = it.next();
                    ++index;
                }
                SelectMultiFilesDialog dialog = new SelectMultiFilesDialog(new JFrame(), "Select files to download", new BroadGeneSetList().getURL().getHost(), genesetFileNameArray);
                dialog.setVisible(true);
                int[] indices = dialog.getSelectedFilesIndices();
                String[] selectedFiles = new String[indices.length];
                for (int i = 0; i < indices.length; ++i) {
                    selectedFiles[i] = genesetFilenames.get(indices[i]);
                    defs.add(new BroadGeneSet(selectedFiles[i], email));
                }
                Hashtable results = this.frm.getSupportFiles(defs, true);
                Enumeration e = results.keys();
                while (e.hasMoreElements()) {
                    File temp;
                    ISupportFileDefinition thisDef = (ISupportFileDefinition)e.nextElement();
                    if (thisDef.isValid(temp = (File)results.get(thisDef))) {
                        this.genesetFilePath = temp.getParent();
                        ((DefaultListModel)this.selectedList.getModel()).addElement(new File(temp.getName()));
                        continue;
                    }
                    System.out.println("support file not downloaded " + temp.getAbsolutePath());
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        catch (SupportFileAccessError sfae) {
            sfae.printStackTrace();
        }
        catch (RepositoryInitializationError rie) {
            rie.printStackTrace();
        }
    }

    public void onAdd(String componentName) {
        int i;
        int[] chosenIndices = this.availableList.getSelectedIndices();
        Object[] chosenObjects = new Object[chosenIndices.length];
        for (i = chosenIndices.length - 1; i >= 0; --i) {
            Object addItem = ((DefaultListModel)this.availableList.getModel()).getElementAt(chosenIndices[i]);
            chosenObjects[i] = addItem;
        }
        for (i = 0; i < chosenIndices.length; ++i) {
            ((DefaultListModel)this.selectedList.getModel()).addElement(chosenObjects[i]);
        }
    }

    public void onAddAll(String componentName) {
        int elementCount = ((DefaultListModel)this.availableList.getModel()).size();
        for (int i = 0; i < elementCount; ++i) {
            Object addItem = ((DefaultListModel)this.availableList.getModel()).getElementAt(i);
            ((DefaultListModel)this.selectedList.getModel()).addElement(addItem);
        }
    }

    public void onRemove(String componentName) {
        int[] chosenIndices = this.selectedList.getSelectedIndices();
        for (int i = chosenIndices.length - 1; i >= 0; --i) {
            ((DefaultListModel)this.selectedList.getModel()).remove(chosenIndices[i]);
        }
    }

    public void onRemoveAll(String componentName) {
        ((DefaultListModel)this.selectedList.getModel()).removeAllElements();
    }

    public String[] getAllSelectedItems() {
        String[] selectedFiles = new String[this.selectedList.getModel().getSize()];
        for (int index = 0; index < selectedFiles.length; ++index) {
            selectedFiles[index] = ((File)this.selectedList.getModel().getElementAt(index)).getName();
        }
        return selectedFiles;
    }

    private void updateLabel(String name) {
        this.choiceBox.setSelectedItem(name);
    }

    public void onBrowse() {
        FileLoaderUtility fileLoad = new FileLoaderUtility();
        Vector retrievedFileNames = new Vector();
        JFileChooser fileChooser = new JFileChooser(SuperExpressionFileLoader.DATA_PATH);
        fileChooser.setFileSelectionMode(1);
        fileChooser.addChoosableFileFilter((FileFilter)new TXTFileFilter());
        fileChooser.addChoosableFileFilter((FileFilter)new GeneMatrixFileFilter());
        fileChooser.addChoosableFileFilter((FileFilter)new GeneMatrixTransposeFileFilter());
        fileChooser.setAcceptAllFileFilterUsed(false);
        int retVal = fileChooser.showOpenDialog(this);
        if (retVal == 0) {
            ((DefaultListModel)this.availableList.getModel()).clear();
            ((DefaultListModel)this.selectedList.getModel()).clear();
            File selectedFile = fileChooser.getSelectedFile();
            String path = selectedFile.getAbsolutePath();
            retrievedFileNames = fileLoad.getFileNameList(selectedFile.getAbsolutePath());
            this.pathTextField.setText(path);
            if (fileChooser.getFileFilter().getDescription().equalsIgnoreCase("Gene Matrix Files (*.gmx)") || fileChooser.getFileFilter().getDescription().equalsIgnoreCase("Gene Matrix Transpose File(*.gmt)")) {
                this.geneIdentifierBox.setSelectedItem("GENE_SYMBOL");
                this.geneIdentifierBox.setEnabled(false);
            } else {
                this.geneIdentifierBox.setSelectedItem(this.geneIdentifierBox.getItemAt(0));
                this.geneIdentifierBox.setEnabled(true);
            }
            if (retrievedFileNames.size() == 0) {
                this.pathTextField.setText("No files of type " + fileChooser.getFileFilter().getDescription() + "were found");
            }
            for (int i = 0; i < retrievedFileNames.size(); ++i) {
                Object fileName = retrievedFileNames.get(i);
                boolean acceptFile = fileChooser.getFileFilter().accept((File)fileName);
                if (!acceptFile) continue;
                this.pathTextField.setText(path);
                String Name = fileChooser.getName((File)fileName);
                this.setFileFilter(fileChooser.getFileFilter().getDescription());
                ((DefaultListModel)this.availableList.getModel()).addElement(new File(Name));
            }
            if (((DefaultListModel)this.availableList.getModel()).getSize() == 0) {
                String eMsg = "<html><font color=red>No files matching the selected filter<br> " + fileChooser.getFileFilter().getDescription() + "<br>" + "were found!!</font></html>";
                ((DefaultListModel)this.availableList.getModel()).add(0, eMsg);
            }
        }
    }

    private void setFileFilter(String filter) {
        this.fileFilter = filter;
    }

    private String getFileFilter() {
        if (this.fileFilter.length() > 0) {
            return this.fileFilter;
        }
        return "";
    }

    @Override
    public void onDisplayed() {
    }

    public GridBagConstraints buildConstraints(GridBagConstraints gbc, int gx, int gy, int gw, int gh, int wx, int wy) {
        gbc = new GridBagConstraints();
        gbc.gridx = gx;
        gbc.gridy = gy;
        gbc.gridwidth = gw;
        gbc.gridheight = gh;
        gbc.weightx = wx;
        gbc.weighty = wy;
        return gbc;
    }

    private class Listener
    implements ActionListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (e.getSource().equals(ParameterPanel.this.choiceBox)) {
                ParameterPanel.this.updateLabel((String)ParameterPanel.this.choiceBox.getSelectedItem());
                if (((String)ParameterPanel.this.choiceBox.getSelectedItem()).equalsIgnoreCase("Standard_Deviation")) {
                    ParameterPanel.this.SDCutoffLabel.setEnabled(true);
                    ParameterPanel.this.sdTextField.setEnabled(true);
                } else {
                    ParameterPanel.this.SDCutoffLabel.setEnabled(false);
                    ParameterPanel.this.sdTextField.setEnabled(false);
                }
            } else if (command.equalsIgnoreCase("gene-number")) {
                ParameterPanel.this.geneNumber.setText(ParameterPanel.this.geneNumber.getText());
            } else if (command.equalsIgnoreCase("standard-deviation")) {
                ParameterPanel.this.sdTextField.setText(ParameterPanel.this.sdTextField.getText());
            } else if (command.equalsIgnoreCase("permutations")) {
                ParameterPanel.this.permutationTextField.setText(ParameterPanel.this.permutationTextField.getText());
            } else if (command.equalsIgnoreCase("top-pathways")) {
                ParameterPanel.this.topPathwaysTextField.setText(ParameterPanel.this.topPathwaysTextField.getText());
            } else if (command.equalsIgnoreCase("limma-cutoff")) {
                ParameterPanel.this.LIMMACutoffTextField.setText(ParameterPanel.this.LIMMACutoffTextField.getText());
            } else if (command.equalsIgnoreCase("got-annotation-file")) {
                ParameterPanel.this.processAnnotationFile();
            } else if (e.getSource().equals(ParameterPanel.this.geneSetSelectionBox)) {
                ParameterPanel.this.updateLabel((String)ParameterPanel.this.geneSetSelectionBox.getSelectedItem());
                if (((String)ParameterPanel.this.geneSetSelectionBox.getSelectedItem()).equalsIgnoreCase("Download from MSigDB")) {
                    ParameterPanel.this.genesetPanel.removeAll();
                    ParameterPanel.this.revalidate();
                    ParameterPanel.this.gba.add((Container)ParameterPanel.this.genesetPanel, (Component)ParameterPanel.this.choicePanel, 0, 0, 1, 1, 1, 1, 1, 10, new Insets(2, 2, 2, 2), 0, 0);
                    ParameterPanel.this.createDownloadPanel("Please enter your MSigDB registration email address:", "Download", "msigdb_download");
                    ParameterPanel.this.gba.add((Container)ParameterPanel.this.genesetPanel, (Component)ParameterPanel.this.identifierSelectionPanel, 0, 5, 1, 1, 1, 1, 1, 10, new Insets(2, 2, 2, 2), 0, 0);
                    ParameterPanel.this.revalidate();
                } else if (((String)ParameterPanel.this.geneSetSelectionBox.getSelectedItem()).equalsIgnoreCase("Load local geneset file/files")) {
                    ParameterPanel.this.genesetPanel.removeAll();
                    ParameterPanel.this.revalidate();
                    ParameterPanel.this.gba.add((Container)ParameterPanel.this.genesetPanel, (Component)ParameterPanel.this.choicePanel, 0, 0, 1, 1, 1, 1, 1, 10, new Insets(2, 2, 2, 2), 0, 0);
                    ParameterPanel.this.createDownloadPanel("Select the directory containing your gene sets", "Browse", "browse");
                    ParameterPanel.this.gba.add((Container)ParameterPanel.this.genesetPanel, (Component)ParameterPanel.this.identifierSelectionPanel, 0, 5, 1, 1, 1, 1, 1, 10, new Insets(2, 2, 2, 2), 0, 0);
                    ParameterPanel.this.revalidate();
                } else if (((String)ParameterPanel.this.geneSetSelectionBox.getSelectedItem()).equalsIgnoreCase("Download from GeneSigDB")) {
                    ParameterPanel.this.genesetPanel.removeAll();
                    ParameterPanel.this.revalidate();
                    ParameterPanel.this.gba.add((Container)ParameterPanel.this.genesetPanel, (Component)ParameterPanel.this.choicePanel, 0, 0, 1, 1, 1, 1, 1, 10, new Insets(2, 2, 2, 2), 0, 0);
                    ParameterPanel.this.createDownloadPanel("Please select gene set files", "Download", "genesigdb_download");
                    ParameterPanel.this.gba.add((Container)ParameterPanel.this.genesetPanel, (Component)ParameterPanel.this.identifierSelectionPanel, 0, 5, 1, 1, 1, 1, 1, 10, new Insets(2, 2, 2, 2), 0, 0);
                    ParameterPanel.this.revalidate();
                }
            }
        }
    }
}

