/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.attract;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.Expression;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.TransferHandler;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDisplayMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.LeafInfo;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentViewer;
import org.tigr.microarray.mev.cluster.gui.impl.GUIFactory;
import org.tigr.util.QSort;

public class ATTRACTResultTable
implements IViewer {
    protected static final String STORE_CLUSTER_CMD = "store-cluster-cmd";
    protected static final String STORE_SELECTED_ROWS_CMD = "store-selected-rows-cmd";
    protected static final String SET_DEF_COLOR_CMD = "set-def-color-cmd";
    protected static final String SAVE_CLUSTER_CMD = "save-cluster-cmd";
    protected static final String SAVE_ALL_CLUSTERS_CMD = "save-all-clusters-cmd";
    protected static final String LAUNCH_NEW_SESSION_CMD = "launch-new-session-cmd";
    protected static final String LAUNCH_NEW_SESSION_WITH_SEL_ROWS_CMD = "launch-new-session-with-sel-rows-cmd";
    protected static final String SEARCH_CMD = "search-cmd";
    protected static final String CLEAR_ALL_CMD = "clear-all-cmd";
    protected static final String COPY_CMD = "copy-cells";
    protected static final String SELECT_ALL_CMD = "select-all-cmd";
    protected static final String SORT_ORIG_ORDER_CMD = "sort-orig-order-cmd";
    protected static final String BROADCAST_MATRIX_GAGGLE_CMD = "broadcast-matrix-to-gaggle";
    protected static final String BROADCAST_SELECTED_MATRIX_GAGGLE_CMD = "broadcast-selected-matrix-to-gaggle";
    protected static final String BROADCAST_NAMELIST_GAGGLE_CMD = "broadcast-namelist-to-gaggle";
    private static final String SAVE_TABLE_COMMAND = "save_pvalues_table_command";
    private static final String STORE_CLUSTER_COMMAND = "store_cluster_command";
    private static final String CLEAR_ALL_COMMAND = "clear-all-cmd";
    private static final String SELECT_ALL_COMMAND = "select-all-cmd";
    private static final String LAUNCH_EXPRESSION_GRAPH_COMMAND = "launch-expression-graph-command";
    private static final String TABLE_VIEW_COMMAND = "table-view-command";
    private static final String LAUNCH_CENTROID_GRAPH_COMMAND = "launch-centroid-graph-command";
    private static final String LAUNCH_EXPRESSION_IMAGE_COMMAND = "launch-expression-image-command";
    private static final String LAUNCH_EXPRESSION_CHART_COMMAND = "launch-expression-chart-command";
    public static final String BROADCAST_MATRIX_GENOME_BROWSER_CMD = "broadcast-matrix-to-genome-browser";
    public static final int INTEGER_TYPE = 10;
    public static final int FLOAT_TYPE = 11;
    public static final int DOUBLE_TYPE = 12;
    public static final int STRING_TYPE = 13;
    public static final int BOOLEAN_TYPE = 14;
    private JComponent header;
    private JPopupMenu popup;
    private Object[][] data;
    private int[] indices;
    private int[] sortedIndices;
    private String[] columnTitles;
    private boolean[] sortedAscending;
    private JTable clusterTable;
    private ClusterTableModel clusterModel;
    private int exptID = 0;
    private DefaultMutableTreeNode rootNode;
    IFramework framework;
    int nodeOffset = 0;

    public ATTRACTResultTable(Object[][] data, DefaultMutableTreeNode analysisNode, IFramework framework, String[] auxTitles, String title) {
        this.framework = framework;
        this.rootNode = analysisNode;
        this.data = data;
        this.indices = new int[data.length];
        this.sortedIndices = new int[data.length];
        for (int i = 0; i < data.length; ++i) {
            this.indices[i] = i;
            this.sortedIndices[i] = i;
        }
        if (title.contains("Correlated")) {
            this.nodeOffset = 7;
        }
        this.columnTitles = auxTitles;
        this.clusterModel = new ClusterTableModel();
        this.clusterTable = new JTable(this.clusterModel);
        this.clusterTable.setCellSelectionEnabled(true);
        TableColumn column = null;
        for (int i = 0; i < this.clusterModel.getColumnCount(); ++i) {
            column = this.clusterTable.getColumnModel().getColumn(i);
            column.setMinWidth(30);
        }
        this.sortedAscending = new boolean[this.clusterModel.getColumnCount()];
        for (int j = 0; j < this.sortedAscending.length; ++j) {
            this.sortedAscending[j] = false;
        }
        this.addMouseListenerToHeaderInTable(this.clusterTable);
        this.header = this.clusterTable.getTableHeader();
        this.setMaxWidth(this.getContentComponent(), this.getHeaderComponent());
        Listener listener = new Listener();
        this.popup = this.createJPopupMenu(listener);
        this.clusterTable.addMouseListener(listener);
    }

    public JTable getTable() {
        return this.clusterTable;
    }

    public Expression getExpression() {
        return new Expression(this, this.getClass(), "new", new Object[]{this.data, this.columnTitles});
    }

    protected String[] getAuxTitles() {
        return this.columnTitles;
    }

    public void setExperiment(Experiment e) {
        this.exptID = e.getId();
    }

    public int getExperimentID() {
        return this.exptID;
    }

    public void setExperimentID(int id) {
        this.exptID = id;
    }

    public JComponent getContentComponent() {
        JPanel panel = new JPanel();
        panel.setBackground(Color.gray);
        GridBagConstraints constraints = new GridBagConstraints();
        GridBagLayout gridbag = new GridBagLayout();
        panel.setLayout(gridbag);
        constraints.fill = 2;
        constraints.anchor = 11;
        this.buildConstraints(constraints, 0, 0, 1, 1, 100, 100);
        gridbag.setConstraints(this.clusterTable, constraints);
        panel.add(this.clusterTable);
        return panel;
    }

    public JComponent getCornerComponent(int cornerIndex) {
        return null;
    }

    public JComponent getHeaderComponent() {
        JPanel panel = new JPanel();
        panel.setBackground(Color.white);
        GridBagConstraints constraints = new GridBagConstraints();
        GridBagLayout gridbag = new GridBagLayout();
        panel.setLayout(gridbag);
        constraints.fill = 2;
        this.buildConstraints(constraints, 0, 0, 1, 1, 100, 100);
        gridbag.setConstraints(this.header, constraints);
        panel.add(this.header);
        return panel;
    }

    void buildConstraints(GridBagConstraints gbc, int gx, int gy, int gw, int gh, int wx, int wy) {
        gbc.gridx = gx;
        gbc.gridy = gy;
        gbc.gridwidth = gw;
        gbc.gridheight = gh;
        gbc.weightx = wx;
        gbc.weighty = wy;
    }

    public BufferedImage getImage() {
        return null;
    }

    public JComponent getRowHeaderComponent() {
        return null;
    }

    public void onClosed() {
    }

    public void onDataChanged(IData data) {
    }

    public void onDeselected() {
    }

    public void onMenuChanged(IDisplayMenu menu) {
    }

    public void onSelected(IFramework framework) {
    }

    public void setClusterIndex(int clusterIndex) {
    }

    public int getClusterIndex() {
        return 0;
    }

    public int[] getCluster() {
        return this.indices;
    }

    public int[][] getClusters() {
        int[][] cls = new int[][]{this.indices};
        return cls;
    }

    public int[] getSortedCluster() {
        return this.sortedIndices;
    }

    protected int getProbe(int row) {
        return this.indices[row];
    }

    public Experiment getExperiment() {
        return null;
    }

    public IData getData() {
        return null;
    }

    private int[] reverse(int[] arr) {
        int[] revArr = new int[arr.length];
        int revCount = 0;
        int count = arr.length - 1;
        for (int i = 0; i < arr.length; ++i) {
            revArr[revCount] = arr[count];
            ++revCount;
            --count;
        }
        return revArr;
    }

    public void addMouseListenerToHeaderInTable(JTable table) {
        final JTable tableView = table;
        tableView.setColumnSelectionAllowed(true);
        MouseAdapter listMouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TableColumnModel columnModel = tableView.getColumnModel();
                int viewColumn = columnModel.getColumnIndexAtX(e.getX());
                int column = tableView.convertColumnIndexToModel(viewColumn);
                if (e.getClickCount() == 1 && column != -1) {
                    int controlPressed = e.getModifiers() & 2;
                    boolean originalOrder = controlPressed != 0;
                    ATTRACTResultTable.this.sortByColumn(column, !ATTRACTResultTable.this.sortedAscending[column], originalOrder);
                    boolean bl = ((ATTRACTResultTable)ATTRACTResultTable.this).sortedAscending[column] = !ATTRACTResultTable.this.sortedAscending[column];
                    if (originalOrder) {
                        for (int i = 0; i < ATTRACTResultTable.this.clusterModel.getColumnCount(); ++i) {
                            ((ATTRACTResultTable)ATTRACTResultTable.this).sortedAscending[i] = false;
                        }
                    }
                }
            }
        };
        JTableHeader th = tableView.getTableHeader();
        th.addMouseListener(listMouseListener);
    }

    public void sortByColumn(int column, boolean ascending, boolean originalOrder) {
        if (originalOrder) {
            for (int i = 0; i < this.getSortedCluster().length; ++i) {
                this.sortedIndices[i] = this.getCluster()[i];
            }
            this.clusterTable.repaint();
            this.clusterTable.clearSelection();
            return;
        }
        int[] sortedArray = new int[this.getCluster().length];
        int obType = ATTRACTResultTable.getObjectType(this.data[0][column]);
        if (obType == 12 || obType == 11 || obType == 10) {
            double[] origArray = new double[this.getCluster().length];
            for (int i = 0; i < origArray.length; ++i) {
                if (this.data[this.getCluster()[i]][column] == null) continue;
                if (obType == 12) {
                    origArray[i] = (Double)this.data[this.getCluster()[i]][column];
                    continue;
                }
                if (obType == 11) {
                    origArray[i] = ((Float)this.data[this.getCluster()[i]][column]).doubleValue();
                    continue;
                }
                if (obType != 10) continue;
                origArray[i] = ((Integer)this.data[this.getCluster()[i]][column]).doubleValue();
            }
            QSort sortArray = new QSort(origArray);
            int[] sortedPrimaryIndices = sortArray.getOrigIndx();
            for (int i = 0; i < sortedPrimaryIndices.length; ++i) {
                sortedArray[i] = this.getCluster()[sortedPrimaryIndices[i]];
            }
        } else if (obType == 13) {
            int i;
            Object[] sortFields = new SortableField[this.getCluster().length];
            for (i = 0; i < sortFields.length; ++i) {
                int currIndex = this.getCluster()[i];
                String currField = (String)this.data[this.getCluster()[i]][column];
                sortFields[i] = new SortableField(currIndex, currField);
            }
            Arrays.sort(sortFields);
            for (i = 0; i < sortFields.length; ++i) {
                sortedArray[i] = ((SortableField)sortFields[i]).getIndex();
            }
        }
        if (!ascending) {
            sortedArray = this.reverse(sortedArray);
        }
        for (int i = 0; i < this.getSortedCluster().length; ++i) {
            this.sortedIndices[i] = sortedArray[i];
        }
        this.clusterTable.repaint();
        this.clusterTable.removeRowSelectionInterval(0, this.clusterTable.getRowCount() - 1);
    }

    private static int getObjectType(Object obj) {
        int obType = -1;
        if (obj instanceof Boolean) {
            return 14;
        }
        if (obj instanceof Double) {
            return 12;
        }
        if (obj instanceof Float) {
            return 11;
        }
        if (obj instanceof Integer) {
            return 10;
        }
        if (obj instanceof String) {
            return 13;
        }
        return obType;
    }

    private void setMaxWidth(JComponent content, JComponent header) {
        int c_width = content.getPreferredSize().width;
        int h_width = header.getPreferredSize().width;
        if (c_width > h_width) {
            header.setPreferredSize(new Dimension(c_width, header.getPreferredSize().height));
        } else {
            content.setPreferredSize(new Dimension(h_width, content.getPreferredSize().height));
        }
    }

    public void launchNewSession() {
    }

    public void launchNewSessionWithSelectedRows() {
    }

    public void copyCells() {
        TransferHandler th = this.clusterTable.getTransferHandler();
        if (th != null) {
            Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
            th.exportToClipboard(this.clusterTable, cb, 1);
        }
    }

    public void sortInOrigOrder() {
        int i;
        for (i = 0; i < this.getSortedCluster().length; ++i) {
            this.sortedIndices[i] = this.getCluster()[i];
        }
        this.clusterTable.repaint();
        this.clusterTable.clearSelection();
        for (i = 0; i < this.clusterModel.getColumnCount(); ++i) {
            this.sortedAscending[i] = false;
        }
    }

    private JPopupMenu createJPopupMenu(Listener listener) {
        JPopupMenu popup = new JPopupMenu();
        this.addMenuItems(popup, listener);
        return popup;
    }

    protected void addMenuItems(JPopupMenu menu, ActionListener listener) {
        menu.addSeparator();
        JMenuItem menuItem = new JMenuItem("Search...", GUIFactory.getIcon("ClusterInformationResult.gif"));
        menuItem.setActionCommand(SEARCH_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem("Copy", GUIFactory.getIcon("TableViewerResult.gif"));
        menuItem.setActionCommand(COPY_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem = new JMenuItem("Select all rows...", GUIFactory.getIcon("TableViewerResult.gif"));
        menuItem.setActionCommand("select-all-cmd");
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menuItem = new JMenuItem("Clear all selections...", GUIFactory.getIcon("TableViewerResult.gif"));
        menuItem.setActionCommand("clear-all-cmd");
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem("Sort table in original gene order...", GUIFactory.getIcon("TableViewerResult.gif"));
        menuItem.setActionCommand(SORT_ORIG_ORDER_CMD);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem("Store Selection as Cluster");
        menuItem.setActionCommand(STORE_CLUSTER_COMMAND);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menu.addSeparator();
        JMenu launchMenu = new JMenu("Open Viewer");
        menuItem = new JMenuItem("Expression Image");
        menuItem.setActionCommand(LAUNCH_EXPRESSION_IMAGE_COMMAND);
        menuItem.addActionListener(listener);
        launchMenu.add(menuItem);
        menuItem = new JMenuItem("Expression Chart");
        menuItem.setActionCommand(LAUNCH_EXPRESSION_CHART_COMMAND);
        menuItem.addActionListener(listener);
        launchMenu.add(menuItem);
        menuItem = new JMenuItem("Centroid Graph");
        menuItem.setActionCommand(LAUNCH_CENTROID_GRAPH_COMMAND);
        menuItem.addActionListener(listener);
        launchMenu.add(menuItem);
        menuItem = new JMenuItem("Expression Graph");
        menuItem.setActionCommand(LAUNCH_EXPRESSION_GRAPH_COMMAND);
        menuItem.addActionListener(listener);
        launchMenu.add(menuItem);
        menuItem = new JMenuItem("Table Viewer");
        menuItem.setActionCommand(TABLE_VIEW_COMMAND);
        menuItem.addActionListener(listener);
        launchMenu.add(menuItem);
        menu.add(launchMenu);
        menu.addSeparator();
        menuItem = new JMenuItem("Save Table");
        menuItem.setActionCommand(SAVE_TABLE_COMMAND);
        menuItem.addActionListener(listener);
        menu.add(menuItem);
        menu.addSeparator();
    }

    protected void onOpenViewer(String viewerType) {
        int index = this.clusterTable.getSelectedRow();
        if (index == -1 || this.rootNode == null) {
            return;
        }
        String nodeTitle = (String)this.clusterTable.getModel().getValueAt(index, 1);
        DefaultMutableTreeNode node = null;
        if (viewerType.equals("expression image")) {
            node = (DefaultMutableTreeNode)this.rootNode.getChildAt(1 + this.nodeOffset);
        } else if (viewerType.equals("expression chart")) {
            node = (DefaultMutableTreeNode)this.rootNode.getChildAt(2 + this.nodeOffset);
        } else if (viewerType.equals("centroid graph")) {
            node = (DefaultMutableTreeNode)this.rootNode.getChildAt(3 + this.nodeOffset);
        } else if (viewerType.equals("expression graph")) {
            node = (DefaultMutableTreeNode)this.rootNode.getChildAt(4 + this.nodeOffset);
        } else if (viewerType.equals("table view")) {
            node = (DefaultMutableTreeNode)this.rootNode.getChildAt(5 + this.nodeOffset);
        }
        if (this.framework != null) {
            int i;
            for (i = 0; i < node.getChildCount(); ++i) {
                if (!((DefaultMutableTreeNode)node.getChildAt(i)).toString().contains(nodeTitle)) continue;
                this.framework.setTreeNode((DefaultMutableTreeNode)node.getChildAt(i));
                return;
            }
            for (i = 0; i < this.rootNode.getChildCount(); ++i) {
                if (!"Not Enough Significant Genes".equals(((DefaultMutableTreeNode)this.rootNode.getChildAt(i)).toString())) continue;
                node = (DefaultMutableTreeNode)this.rootNode.getChildAt(i);
                for (int j = 0; j < node.getChildCount(); ++j) {
                    if (!((DefaultMutableTreeNode)node.getChildAt(j)).toString().contains(nodeTitle)) continue;
                    this.framework.setTreeNode((DefaultMutableTreeNode)node.getChildAt(j));
                    return;
                }
            }
        }
        System.out.println("node '" + nodeTitle + "' not found.");
    }

    protected void onSaveTable() {
        JFileChooser chooser = new JFileChooser(TMEV.getFile((String)"/Data"));
        String fileName = "";
        if (chooser.showSaveDialog(null) == 0) {
            File file = chooser.getSelectedFile();
            fileName = file.getName();
            try {
                PrintWriter pw = new PrintWriter(new FileOutputStream(file));
                int rows = this.clusterTable.getRowCount();
                int cols = this.clusterTable.getColumnCount();
                for (int row = 0; row < rows; ++row) {
                    for (int col = 0; col < cols; ++col) {
                        pw.print((String)this.clusterTable.getValueAt(row, col) + "\t");
                    }
                    pw.print("\n");
                }
                pw.flush();
                pw.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                JOptionPane.showMessageDialog(null, "Error Saving Table to file: " + fileName, "Output Error", 2);
            }
        }
    }

    protected void onStoreSelectedRows() {
        int[] tableIndices = this.clusterTable.getSelectedRows();
        if (tableIndices == null || tableIndices.length == 0 || this.rootNode == null) {
            return;
        }
        block0: for (int cluster = 0; cluster < tableIndices.length; ++cluster) {
            String nodeTitle = (String)this.clusterTable.getModel().getValueAt(tableIndices[cluster], 1);
            DefaultMutableTreeNode node = null;
            node = (DefaultMutableTreeNode)this.rootNode.getChildAt(1 + this.nodeOffset);
            for (int i = 0; i < node.getChildCount(); ++i) {
                if (!nodeTitle.equals(((DefaultMutableTreeNode)node.getChildAt(i)).toString())) continue;
                ExperimentViewer ev = (ExperimentViewer)((LeafInfo)((DefaultMutableTreeNode)node.getChildAt(i)).getUserObject()).getViewer();
                ev.storeCluster();
                continue block0;
            }
        }
    }

    public int getViewerType() {
        return -1;
    }

    protected void broadcastClusterGaggle() {
    }

    protected void broadcastSelectedClusterGaggle() {
    }

    protected void broadcastNamelistGaggle() {
    }

    public void broadcastGeneClusterToGenomeBrowser() {
    }

    private class Listener
    extends MouseAdapter
    implements ActionListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (!(command.equals(ATTRACTResultTable.LAUNCH_NEW_SESSION_WITH_SEL_ROWS_CMD) || command.equals(ATTRACTResultTable.SEARCH_CMD) || command.equals("clear-all-cmd"))) {
                if (command.equals(ATTRACTResultTable.COPY_CMD)) {
                    ATTRACTResultTable.this.copyCells();
                } else if (command.equals("select-all-cmd")) {
                    ATTRACTResultTable.this.clusterTable.selectAll();
                } else if (command.equals(ATTRACTResultTable.SORT_ORIG_ORDER_CMD)) {
                    ATTRACTResultTable.this.sortInOrigOrder();
                } else if (!(command.equals(ATTRACTResultTable.BROADCAST_MATRIX_GAGGLE_CMD) || command.equals(ATTRACTResultTable.BROADCAST_SELECTED_MATRIX_GAGGLE_CMD) || command.equals(ATTRACTResultTable.BROADCAST_NAMELIST_GAGGLE_CMD) || command.equals(ATTRACTResultTable.BROADCAST_MATRIX_GENOME_BROWSER_CMD))) {
                    if (command.equals(ATTRACTResultTable.STORE_CLUSTER_COMMAND)) {
                        ATTRACTResultTable.this.onStoreSelectedRows();
                    } else if (command.equals("clear-all-cmd")) {
                        ATTRACTResultTable.this.clusterTable.clearSelection();
                    } else if (command.equals("select-all-cmd")) {
                        ATTRACTResultTable.this.clusterTable.selectAll();
                    } else if (command.equals(ATTRACTResultTable.LAUNCH_EXPRESSION_IMAGE_COMMAND)) {
                        ATTRACTResultTable.this.onOpenViewer("expression image");
                    } else if (command.equals(ATTRACTResultTable.LAUNCH_EXPRESSION_CHART_COMMAND)) {
                        ATTRACTResultTable.this.onOpenViewer("expression chart");
                    } else if (command.equals(ATTRACTResultTable.LAUNCH_CENTROID_GRAPH_COMMAND)) {
                        ATTRACTResultTable.this.onOpenViewer("centroid graph");
                    } else if (command.equals(ATTRACTResultTable.LAUNCH_EXPRESSION_GRAPH_COMMAND)) {
                        ATTRACTResultTable.this.onOpenViewer("expression graph");
                    } else if (command.equals(ATTRACTResultTable.TABLE_VIEW_COMMAND)) {
                        ATTRACTResultTable.this.onOpenViewer("table view");
                    } else if (command.equals(ATTRACTResultTable.SAVE_TABLE_COMMAND)) {
                        ATTRACTResultTable.this.onSaveTable();
                    }
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            this.maybeShowPopup(event);
        }

        @Override
        public void mousePressed(MouseEvent event) {
            this.maybeShowPopup(event);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (!e.isPopupTrigger() || ATTRACTResultTable.this.getCluster() == null || ATTRACTResultTable.this.getCluster().length == 0) {
                return;
            }
            ATTRACTResultTable.this.popup.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    private class SortableField
    implements Comparable {
        private String field;
        private int index;

        SortableField(int index, String field) {
            this.index = index;
            this.field = field;
        }

        public int compareTo(Object other) {
            SortableField otherField = (SortableField)other;
            return this.field.compareTo(otherField.getField());
        }

        public int getIndex() {
            return this.index;
        }

        public String getField() {
            return this.field;
        }
    }

    class ClusterTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        String[] columnNames;
        boolean hasAnnotation = true;

        public ClusterTableModel() {
            this.columnNames = new String[ATTRACTResultTable.this.columnTitles.length];
            for (int i = 0; i < this.columnNames.length; ++i) {
                this.columnNames[i] = ATTRACTResultTable.this.columnTitles[i];
            }
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return ATTRACTResultTable.this.getCluster().length;
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            return String.valueOf(ATTRACTResultTable.this.data[ATTRACTResultTable.this.getSortedCluster()[row]][col]);
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }
    }
}

