/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.attract;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Date;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.tigr.microarray.mev.TMEV;
import org.tigr.microarray.mev.cluster.clusterUtil.ClusterRepository;
import org.tigr.microarray.mev.cluster.gui.helpers.ClusterSelector;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.AlgorithmDialog;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.dialogHelpUtil.HelpWindow;

public class ATTRACTInitBox
extends AlgorithmDialog {
    private static final long serialVersionUID = 1L;
    public static final int JUST_ALPHA = 1;
    public static final int STD_BONFERRONI = 2;
    public static final int ADJ_BONFERRONI = 3;
    public static final int MAX_T = 9;
    public static final int FALSE_NUM = 12;
    public static final int FALSE_PROP = 13;
    public static final int BUTTON_SELECTION = 14;
    public static final int CLUSTER_SELECTION = 15;
    boolean okPressed = false;
    boolean okReady = false;
    boolean step2 = false;
    Vector<String> exptNames;
    MultiClassPanel mPanel;
    JTabbedPane selectionPanel;
    HCLoptionPanel hclOpsPanel;
    ClusterRepository repository;
    JButton step2Button = new JButton("Continue...");
    private String initialChipType;

    public ATTRACTInitBox(JFrame parentFrame, boolean modality, Vector<String> exptNames, ClusterRepository repository, String initialChipType) {
        super(parentFrame, "ATTRACT Initialization", modality);
        this.exptNames = exptNames;
        this.repository = repository;
        this.initialChipType = initialChipType;
        this.setBounds(0, 0, 1000, 850);
        this.setBackground(Color.white);
        this.setDefaultCloseOperation(2);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 1;
        JPanel pane = new JPanel();
        pane.setLayout(gridbag);
        this.okButton.setEnabled(false);
        this.mPanel = new MultiClassPanel();
        this.showGroupNameTextFields();
        this.buildConstraints(constraints, 0, 0, 1, 1, 100, 80);
        gridbag.setConstraints(this.mPanel, constraints);
        pane.add(this.mPanel);
        this.addContent(pane);
        EventListener listener = new EventListener();
        this.setActionListeners(listener);
        this.addWindowListener(listener);
    }

    @Override
    public void setVisible(boolean visible) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getSize().width) / 2, (screenSize.height - this.getSize().height) / 2);
        super.setVisible(visible);
        if (visible) {
            // empty if block
        }
    }

    private void buildConstraints(GridBagConstraints gbc, int gx, int gy, int gw, int gh, int wx, int wy, int anc) {
        gbc.gridx = gx;
        gbc.gridy = gy;
        gbc.gridwidth = gw;
        gbc.gridheight = gh;
        gbc.weightx = wx;
        gbc.weighty = wy;
        gbc.anchor = anc;
    }

    private void buildConstraints(GridBagConstraints gbc, int gx, int gy, int gw, int gh, int wx, int wy, int anc, int fill) {
        gbc.gridx = gx;
        gbc.gridy = gy;
        gbc.gridwidth = gw;
        gbc.gridheight = gh;
        gbc.weightx = wx;
        gbc.weighty = wy;
        gbc.anchor = anc;
        gbc.fill = fill;
    }

    private void buildConstraints(GridBagConstraints gbc, int gx, int gy, int gw, int gh, int wx, int wy) {
        gbc.gridx = gx;
        gbc.gridy = gy;
        gbc.gridwidth = gw;
        gbc.gridheight = gh;
        gbc.weightx = wx;
        gbc.weighty = wy;
    }

    public boolean isOkPressed() {
        return this.okPressed;
    }

    public void enableOK() {
        this.okButton.setEnabled(true);
    }

    public boolean drawTrees() {
        return this.hclOpsPanel.isHCLSelected();
    }

    public boolean drawSigTreesOnly() {
        return this.hclOpsPanel.drawSigTreesOnly();
    }

    private void showGroupNameTextFields() {
        int i;
        int numGroups = this.getNumGroups();
        for (i = 0; i < 8; ++i) {
            this.mPanel.ngPanel.groupNameLabel[i].setVisible(false);
            this.mPanel.ngPanel.groupNameField[i].setVisible(false);
        }
        for (i = 0; i < numGroups; ++i) {
            this.mPanel.ngPanel.groupNameLabel[i].setVisible(true);
            this.mPanel.ngPanel.groupNameField[i].setVisible(true);
        }
    }

    private boolean isParamSufficient() {
        switch (this.getExperimentalDesign()) {
            case 2: {
                int[] inc = new int[2];
                int[] grpAssign = this.getGroupAssignments();
                for (int i = 0; i < grpAssign.length; ++i) {
                    if (grpAssign[i] == 0) continue;
                    int n = grpAssign[i] - 1;
                    inc[n] = inc[n] + 1;
                }
                if (inc[0] < 2 || inc[1] < 2) {
                    JOptionPane.showMessageDialog(null, "Please select at least 2 samples for each group.", "Error", 2);
                    return false;
                }
                return true;
            }
            case 3: {
                int i;
                int[] inc = new int[this.getNumGroups()];
                int[] grpAssign = this.getGroupAssignments();
                for (i = 0; i < grpAssign.length; ++i) {
                    if (grpAssign[i] == 0) continue;
                    int n = grpAssign[i] - 1;
                    inc[n] = inc[n] + 1;
                }
                for (i = 0; i < inc.length; ++i) {
                    if (inc[i] >= 2) continue;
                    JOptionPane.showMessageDialog(null, "Please select at least 2 samples for each group.", "Error", 2);
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public int[] getGroupAssignments() {
        if (this.getExperimentalDesign() < 4) {
            return this.getSimpleGroupAssignments();
        }
        return null;
    }

    private int[] getClusterSelectorGroupAssignments() {
        int j;
        int i;
        int[] groupAssignments = new int[this.exptNames.size()];
        ArrayList[] arraylistArray = new ArrayList[this.mPanel.numGroups];
        for (i = 0; i < this.mPanel.numGroups; ++i) {
            j = i + 1;
            arraylistArray[i] = this.mPanel.groupsCS.getGroupSamples("Class " + j);
        }
        for (i = 0; i < this.exptNames.size(); ++i) {
            boolean doubleAssigned = false;
            groupAssignments[i] = 0;
            for (j = 0; j < this.mPanel.numGroups; ++j) {
                if (!arraylistArray[j].contains(i)) continue;
                if (doubleAssigned) {
                    Object[] optionst = new Object[]{"OK"};
                    JOptionPane.showOptionDialog(null, "The clusters you have chosen have overlapping samples. \n Each group must contain unique samples.", "Multiple Ownership Error", 1, 3, null, optionst, optionst[0]);
                    return null;
                }
                groupAssignments[i] = j + 1;
                doubleAssigned = true;
            }
        }
        return groupAssignments;
    }

    private int[] getSimpleGroupAssignments() {
        if (this.getSelectionDesign() == 15) {
            return this.getClusterSelectorGroupAssignments();
        }
        int[] groupAssignments = new int[this.exptNames.size()];
        block0: for (int i = 0; i < this.exptNames.size(); ++i) {
            if (this.mPanel.sampleSelectionPanel.notInTimeGroupRadioButtons[i].isSelected()) {
                groupAssignments[i] = 0;
                continue;
            }
            for (int j = 0; j < this.mPanel.sampleSelectionPanel.assignmentRBs.length; ++j) {
                if (!this.mPanel.sampleSelectionPanel.assignmentRBs[j][i].isSelected()) continue;
                groupAssignments[i] = j + 1;
                continue block0;
            }
        }
        return groupAssignments;
    }

    public int[][] getGroupMatrix() {
        int[] timeAssignments = this.getGroupAssignments();
        int[] numEachTime = new int[this.getNumGroups()];
        for (int i = 0; i < timeAssignments.length; ++i) {
            if (timeAssignments[i] == 0) continue;
            int n = timeAssignments[i] - 1;
            numEachTime[n] = numEachTime[n] + 1;
        }
        int[][] timeMatrix = new int[this.getNumGroups()][];
        for (int i = 0; i < this.getNumGroups(); ++i) {
            timeMatrix[i] = new int[numEachTime[i]];
        }
        int[] nextEntry = new int[this.getNumGroups()];
        for (int i = 0; i < timeAssignments.length; ++i) {
            if (timeAssignments[i] == 0) continue;
            timeMatrix[timeAssignments[i] - 1][nextEntry[timeAssignments[i] - 1]] = i;
            int n = timeAssignments[i] - 1;
            nextEntry[n] = nextEntry[n] + 1;
        }
        return timeMatrix;
    }

    public int getExperimentalDesign() {
        int design = -1;
        if (this.mPanel.ngPanel.twoClass.isSelected()) {
            design = 2;
        }
        if (this.mPanel.ngPanel.multiClass.isSelected()) {
            design = 3;
        }
        return design;
    }

    public int getSelectionDesign() {
        int design = -1;
        design = this.mPanel.tabbedmulg.getSelectedIndex() == 0 ? 14 : 15;
        return design;
    }

    public String[] getGroupNames() {
        String[] ret = new String[this.getNumGroups()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.mPanel.ngPanel.groupNameField[i].getText();
        }
        return ret;
    }

    public int getNumGroups() {
        int numGroups = 0;
        if (this.getExperimentalDesign() == 2) {
            numGroups = 2;
        } else {
            try {
                numGroups = Integer.parseInt(this.mPanel.ngPanel.numGroupsField.getText());
                if (numGroups > 8 || numGroups < 2) {
                    JOptionPane.showMessageDialog(null, "The number of groups must be greater than 1 and less than 9.", "Error", 0);
                    numGroups = -1;
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Error reading parameter input.", "Error", 0);
            }
        }
        return numGroups;
    }

    public String getChipName() {
        return this.mPanel.chipName;
    }

    public float getAlpha() {
        return Float.parseFloat(this.mPanel.ngPanel.alphaField.getText());
    }

    public static void main(String[] args) {
        JFrame dummyFrame = new JFrame();
        Vector<String> dummyVect = new Vector<String>();
        for (int i = 0; i < 24; ++i) {
            dummyVect.add("Expt " + i);
        }
        String annot = "hgu133a";
        ATTRACTInitBox oBox = new ATTRACTInitBox(dummyFrame, true, dummyVect, null, annot);
        oBox.setVisible(true);
        for (int i = 0; i < oBox.getGroupNames().length; ++i) {
            System.out.println(oBox.getGroupNames()[i]);
        }
        System.exit(0);
    }

    public class EventListener
    extends WindowAdapter
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent ae) {
            String command = ae.getActionCommand();
            if (command.equals("ok-command")) {
                if (!ATTRACTInitBox.this.okReady) {
                    return;
                }
                if (ATTRACTInitBox.this.getSelectionDesign() == 15 && ATTRACTInitBox.this.repository.isEmpty()) {
                    JOptionPane.showMessageDialog(null, "Cluster Repository is Empty.", "Error", 2);
                    return;
                }
                if (!ATTRACTInitBox.this.isParamSufficient()) {
                    return;
                }
                ATTRACTInitBox.this.okPressed = true;
                ATTRACTInitBox.this.dispose();
            } else if (command.equals("reset-command")) {
                ATTRACTInitBox.this.mPanel.reset();
            } else if (command.equals("cancel-command")) {
                ATTRACTInitBox.this.okPressed = false;
                ATTRACTInitBox.this.dispose();
            } else if (command.equals("info-command")) {
                HelpWindow.launchBrowser(ATTRACTInitBox.this, "Linear Models for Microarray Data- Initialization Dialog");
            }
        }
    }

    public class RadioButtonListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent ae) {
            if (ATTRACTInitBox.this.getExperimentalDesign() == 3) {
                ATTRACTInitBox.this.mPanel.ngPanel.numGroupsLabel.setText("Number of Groups: ");
                ATTRACTInitBox.this.mPanel.ngPanel.numGroupsField.setVisible(true);
                ATTRACTInitBox.this.mPanel.ngPanel.numGroupsLabel.setVisible(true);
            } else {
                ATTRACTInitBox.this.mPanel.ngPanel.numGroupsField.setVisible(false);
                ATTRACTInitBox.this.mPanel.ngPanel.numGroupsLabel.setVisible(false);
            }
            ATTRACTInitBox.this.showGroupNameTextFields();
        }
    }

    class MultiClassPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        DesignPanel ngPanel;
        GridBagConstraints constraints = new GridBagConstraints();
        GridBagLayout gridbag = new GridBagLayout();
        JPanel dummyPanel;
        ExperimentsSelectionPanel sampleSelectionPanel;
        JTabbedPane tabbedmulg;
        ClusterSelector groupsCS;
        JLabel infoLabel;
        JLabel infoLabel2;
        int numGroups = -1;
        float alpha;
        public String chipName;

        public MultiClassPanel() {
            this.setBackground(Color.white);
            this.setLayout(this.gridbag);
            this.ngPanel = new DesignPanel();
            ATTRACTInitBox.this.buildConstraints(this.constraints, 0, 0, 1, 1, 100, 10);
            this.constraints.fill = 1;
            this.gridbag.setConstraints(this.ngPanel, this.constraints);
            ATTRACTInitBox.this.step2Button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    if (ATTRACTInitBox.this.step2) {
                        MultiClassPanel.this.goBack();
                        return;
                    }
                    MultiClassPanel.this.initiatePanels();
                }
            });
            JPanel topPanel = new JPanel();
            topPanel.setBackground(Color.white);
            topPanel.setLayout(this.gridbag);
            ATTRACTInitBox.this.buildConstraints(this.constraints, 0, 0, 1, 2, 75, 100);
            this.gridbag.setConstraints(this.ngPanel, this.constraints);
            topPanel.add(this.ngPanel);
            ATTRACTInitBox.this.hclOpsPanel = new HCLoptionPanel();
            ATTRACTInitBox.this.hclOpsPanel.setBorder(null);
            ATTRACTInitBox.this.buildConstraints(this.constraints, 1, 0, 1, 1, 25, 100);
            this.gridbag.setConstraints(ATTRACTInitBox.this.hclOpsPanel, this.constraints);
            topPanel.add(ATTRACTInitBox.this.hclOpsPanel);
            ATTRACTInitBox.this.buildConstraints(this.constraints, 1, 2, 1, 1, 0, 10);
            this.gridbag.setConstraints(ATTRACTInitBox.this.step2Button, this.constraints);
            topPanel.add(ATTRACTInitBox.this.step2Button);
            topPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "ATTRACT Parameters", 0, 0, null, Color.black));
            ATTRACTInitBox.this.buildConstraints(this.constraints, 0, 0, 1, 1, 100, 10);
            this.gridbag.setConstraints(topPanel, this.constraints);
            this.add(topPanel);
            this.infoLabel = new JLabel("Sample Group Assignment");
            this.infoLabel.setMaximumSize(new Dimension(50, 50));
            Font font = this.infoLabel.getFont();
            this.infoLabel.setFont(font.deriveFont(20.0f));
            ATTRACTInitBox.this.buildConstraints(this.constraints, 0, 1, 1, 1, 0, 5, 10, 0);
            this.gridbag.setConstraints(this.infoLabel, this.constraints);
            this.add((Component)this.infoLabel, this.constraints);
            this.infoLabel2 = new JLabel("Please select the type of ATTRACT analysis to be run, then click 'Continue'.");
            ATTRACTInitBox.this.buildConstraints(this.constraints, 0, 2, 1, 1, 100, 5, 10);
            this.gridbag.setConstraints(this.infoLabel2, this.constraints);
            this.add((Component)this.infoLabel2, this.constraints);
            ATTRACTInitBox.this.buildConstraints(this.constraints, 0, 3, 1, 1, 100, 90);
            this.dummyPanel = new JPanel();
            this.dummyPanel.setBackground(Color.white);
            this.gridbag.setConstraints(this.dummyPanel, this.constraints);
            this.add(this.dummyPanel);
        }

        private void goBack() {
            this.infoLabel.setVisible(true);
            this.infoLabel2.setVisible(true);
            this.ngPanel.numGroupsField.setEnabled(true);
            this.ngPanel.alphaField.setEnabled(true);
            this.ngPanel.chipNameBox.setEnabled(true);
            this.ngPanel.twoClass.setEnabled(true);
            this.ngPanel.multiClass.setEnabled(true);
            ATTRACTInitBox.this.step2Button.setText("Continue...");
            ATTRACTInitBox.this.step2 = false;
            this.tabbedmulg.setVisible(false);
            ATTRACTInitBox.this.buildConstraints(this.constraints, 0, 1, 2, 1, 0, 90);
            this.constraints.fill = 1;
            ATTRACTInitBox.this.buildConstraints(this.constraints, 0, 3, 1, 1, 100, 90);
            this.gridbag.setConstraints(this.dummyPanel, this.constraints);
            this.add(this.dummyPanel);
            ATTRACTInitBox.this.step2Button.setSelected(false);
        }

        private void initiatePanels() {
            this.ngPanel.okPressed = true;
            ATTRACTInitBox.this.okReady = true;
            try {
                this.alpha = Float.parseFloat(this.ngPanel.alphaField.getText());
                this.chipName = this.ngPanel.chipNameBox.getSelectedItem().toString();
                this.numGroups = 0;
                if (ATTRACTInitBox.this.getExperimentalDesign() == 2) {
                    this.numGroups = 2;
                }
                if (ATTRACTInitBox.this.getExperimentalDesign() == 3) {
                    this.numGroups = Integer.parseInt(this.ngPanel.numGroupsField.getText());
                }
            }
            catch (NumberFormatException nfe) {
                JOptionPane.showMessageDialog(null, "Error reading parameter input.", "Error", 0);
                return;
            }
            if (this.alpha > 1.0f || this.alpha < 0.0f) {
                JOptionPane.showMessageDialog(null, "Please enter an alpha value between 0 and 1.", "Error", 0);
                return;
            }
            if (this.numGroups < 2 || this.numGroups > 8) {
                JOptionPane.showMessageDialog(null, "The number of groups must be greater than 1 and less than 9.", "Error", 0);
                return;
            }
            JPanel selectionPanel = new JPanel();
            GridBagLayout gbg = new GridBagLayout();
            selectionPanel.setLayout(gbg);
            GridBagConstraints cnstr = new GridBagConstraints();
            ATTRACTInitBox.this.buildConstraints(cnstr, 0, 0, 1, 1, 1, 1);
            cnstr.fill = 1;
            JPanel clusterSelectorPanel = new JPanel();
            clusterSelectorPanel.setLayout(new GridBagLayout());
            JLabel clusterInstructions = new JLabel("Use the drop-down menus to assign clusters of samples to their corresponding groups.");
            GridBagConstraints c = new GridBagConstraints();
            c.gridwidth = 2;
            clusterSelectorPanel.add((Component)clusterInstructions, c);
            this.sampleSelectionPanel = new ExperimentsSelectionPanel(ATTRACTInitBox.this.exptNames, this.numGroups, this.ngPanel.getExperimentDesign(), "Group", true);
            selectionPanel.add((Component)this.sampleSelectionPanel, cnstr);
            ++cnstr.gridy;
            cnstr.weighty = 0.0;
            selectionPanel.add((Component)this.createSaveLoadPanel(), cnstr);
            if (ATTRACTInitBox.this.getExperimentalDesign() == 5) {
                this.groupsCS = new ClusterSelector(ATTRACTInitBox.this.repository, this.numGroups, "Timepoint");
                this.groupsCS.setClusterType("Timepoint");
            } else {
                this.groupsCS = new ClusterSelector(ATTRACTInitBox.this.repository, this.numGroups, "Class");
                this.groupsCS.setClusterType("Class");
            }
            ATTRACTInitBox.this.buildConstraints(c, 0, 1, 1, 1, 1, 1);
            c.fill = 1;
            c.gridx = 1;
            clusterSelectorPanel.add((Component)this.groupsCS, c);
            this.remove(this.dummyPanel);
            this.tabbedmulg = new JTabbedPane();
            this.tabbedmulg.add("Button Selection", selectionPanel);
            this.tabbedmulg.add("Cluster Selection", clusterSelectorPanel);
            this.tabbedmulg.setSelectedIndex(1);
            if (ATTRACTInitBox.this.repository == null || ATTRACTInitBox.this.repository.isEmpty()) {
                this.tabbedmulg.setSelectedIndex(0);
            }
            ATTRACTInitBox.this.buildConstraints(this.constraints, 0, 1, 2, 1, 0, 90);
            this.constraints.fill = 1;
            this.gridbag.setConstraints(this.tabbedmulg, this.constraints);
            this.add(this.tabbedmulg);
            this.validate();
            ATTRACTInitBox.this.enableOK();
            this.ngPanel.numGroupsField.setEnabled(false);
            this.ngPanel.alphaField.setEnabled(false);
            this.ngPanel.chipNameBox.setEnabled(false);
            this.ngPanel.twoClass.setEnabled(false);
            this.ngPanel.multiClass.setEnabled(false);
            ATTRACTInitBox.this.step2Button.setText("<<< Go Back");
            this.infoLabel.setVisible(false);
            this.infoLabel2.setVisible(false);
            ATTRACTInitBox.this.step2 = true;
        }

        private void saveAssignments() {
            JFileChooser fileChooser = new JFileChooser(TMEV.getDataPath());
            if (fileChooser.showSaveDialog(this) == 0) {
                File file = fileChooser.getSelectedFile();
                try {
                    PrintWriter pw = new PrintWriter(new FileWriter(file));
                    Date currDate = new Date(System.currentTimeMillis());
                    String dateString = currDate.toString();
                    String userName = System.getProperty("user.name");
                    pw.println("# Assignment File");
                    pw.println("# User: " + userName + " Save Date: " + dateString);
                    pw.println("#");
                    pw.print("Module:\t");
                    pw.println("ATTRACT");
                    pw.print("Design:\t");
                    pw.println(this.ngPanel.getExperimentDesign());
                    int groupMax = this.numGroups;
                    for (int i = 0; i < groupMax; ++i) {
                        pw.print("Group " + (i + 1) + " Label:\t");
                        pw.println("Group " + (i + 1));
                    }
                    pw.println("#");
                    pw.println("Sample Index\tSample Name\tGroup Assignment");
                    int[] groupAssgn = ATTRACTInitBox.this.getGroupAssignments();
                    for (int sample = 0; sample < ATTRACTInitBox.this.exptNames.size(); ++sample) {
                        pw.print(String.valueOf(sample + 1) + "\t");
                        pw.print(ATTRACTInitBox.this.exptNames.get(sample) + "\t");
                        if (groupAssgn[sample] != 0) {
                            pw.println("Group " + groupAssgn[sample]);
                            continue;
                        }
                        pw.println("Exclude");
                    }
                    pw.flush();
                    pw.close();
                }
                catch (FileNotFoundException fnfe) {
                    fnfe.printStackTrace();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }

        private void loadAssignments() {
            JFileChooser fileChooser = new JFileChooser("./data");
            if (fileChooser.showOpenDialog(this) == 0) {
                File file = fileChooser.getSelectedFile();
                try {
                    String line;
                    BufferedReader br = new BufferedReader(new FileReader(file));
                    Vector<String> data = new Vector<String>();
                    while ((line = br.readLine()) != null) {
                        data.add(line.trim());
                    }
                    br.close();
                    Vector<String> groupNames = new Vector<String>();
                    Vector<Integer> sampleIndices = new Vector<Integer>();
                    Vector<String> sampleNames = new Vector<String>();
                    Vector<String> groupAssignments = new Vector<String>();
                    Vector<String> group2Assignments = new Vector<String>();
                    int design = 0;
                    for (int row = 0; row < data.size(); ++row) {
                        line = (String)data.get(row);
                        if (line.startsWith("#") || line.startsWith("SampleIndex")) continue;
                        String[] lineArray = line.split("\t");
                        if (lineArray[0].startsWith("Module:")) {
                            if (lineArray[1].equals("ATTRACT")) continue;
                            Object[] optionst = new Object[]{"Continue", "Cancel"};
                            if (JOptionPane.showOptionDialog(null, "The saved file was saved using a different module, " + lineArray[1] + ". \n Would you like MeV to try to load it anyway?", "File type warning", 1, 3, null, optionst, optionst[0]) == 0) continue;
                            return;
                        }
                        if (lineArray[0].startsWith("Group ") && lineArray[0].endsWith("Label:")) {
                            groupNames.add(lineArray[1]);
                            continue;
                        }
                        if (lineArray[0].startsWith("Design")) {
                            try {
                                design = Integer.parseInt(lineArray[1]);
                            }
                            catch (NumberFormatException nfe) {}
                            continue;
                        }
                        try {
                            Integer.parseInt(lineArray[0]);
                        }
                        catch (NumberFormatException nfe) {
                            continue;
                        }
                        sampleIndices.add(new Integer(lineArray[0]));
                        sampleNames.add(lineArray[1]);
                        groupAssignments.add(lineArray[2]);
                        if (design != 4 && design != 5) continue;
                        group2Assignments.add(lineArray[3]);
                    }
                    if (ATTRACTInitBox.this.exptNames.size() != sampleNames.size()) {
                        System.out.println(ATTRACTInitBox.this.exptNames.size() + "  " + sampleNames.size());
                        System.out.println(ATTRACTInitBox.this.exptNames.size() + " s length " + sampleNames.size());
                        JOptionPane.showMessageDialog(this, "<html>Error -- number of samples designated in assignment file (" + String.valueOf(sampleNames.size()) + ")<br>" + "does not match the number of samples loaded in MeV (" + ATTRACTInitBox.this.exptNames.size() + ").<br>" + "Assignments are not set.</html>", "File Compatibility Error", 0);
                        return;
                    }
                    Vector<String> currSampleVector = new Vector<String>();
                    for (int i = 0; i < ATTRACTInitBox.this.exptNames.size(); ++i) {
                        currSampleVector.add(ATTRACTInitBox.this.exptNames.get(i));
                    }
                    int fileSampleIndex = 0;
                    int groupIndex = 0;
                    for (int sample = 0; sample < ATTRACTInitBox.this.exptNames.size(); ++sample) {
                        boolean doIndex = false;
                        for (int i = 0; i < ATTRACTInitBox.this.exptNames.size(); ++i) {
                            if (i == sample || !ATTRACTInitBox.this.exptNames.get(i).equals(ATTRACTInitBox.this.exptNames.get(sample))) continue;
                            doIndex = true;
                        }
                        fileSampleIndex = sampleNames.indexOf(ATTRACTInitBox.this.exptNames.get(sample));
                        if (fileSampleIndex == -1) {
                            doIndex = true;
                        }
                        if (doIndex) {
                            this.setStateBasedOnIndex(groupAssignments, groupNames, design, group2Assignments);
                            break;
                        }
                        String groupName = (String)groupAssignments.get(fileSampleIndex);
                        groupIndex = groupNames.indexOf(groupName);
                        try {
                            ATTRACTInitBox.this.mPanel.sampleSelectionPanel.assignmentRBs[groupIndex][sample].setSelected(true);
                            continue;
                        }
                        catch (Exception e) {
                            ATTRACTInitBox.this.mPanel.sampleSelectionPanel.notInTimeGroupRadioButtons[sample].setSelected(true);
                        }
                    }
                    this.repaint();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(this, "<html>The file format cannot be read.</html>", "File Compatibility Error", 0);
                }
            }
        }

        private void setStateBasedOnIndex(Vector<String> groupAssignments, Vector<String> groupNames, int cond, Vector<String> condAssignments) {
            Object[] optionst = new Object[]{"Continue", "Cancel"};
            if (JOptionPane.showOptionDialog(null, "The saved file was saved using a different sample annotation or has duplicate annotation. \n Would you like MeV to try to load it by index order?", "File type warning", 1, 3, null, optionst, optionst[0]) == 1) {
                return;
            }
            for (int sample = 0; sample < ATTRACTInitBox.this.exptNames.size(); ++sample) {
                try {
                    ATTRACTInitBox.this.mPanel.sampleSelectionPanel.assignmentRBs[groupNames.indexOf(groupAssignments.get(sample))][sample].setSelected(true);
                    continue;
                }
                catch (Exception e) {
                    ATTRACTInitBox.this.mPanel.sampleSelectionPanel.notInTimeGroupRadioButtons[sample].setSelected(true);
                }
            }
        }

        private JPanel createSaveLoadPanel() {
            JPanel panel2 = new JPanel();
            GridBagLayout gridbag3 = new GridBagLayout();
            panel2.setLayout(gridbag3);
            panel2.setBackground(Color.white);
            JButton saveButton = new JButton("  Save settings  ");
            saveButton.setFocusPainted(false);
            saveButton.setBorder(BorderFactory.createBevelBorder(0, Color.lightGray, Color.darkGray));
            JButton loadButton = new JButton("  Load settings  ");
            loadButton.setFocusPainted(false);
            loadButton.setBorder(BorderFactory.createBevelBorder(0, Color.lightGray, Color.darkGray));
            JButton resetButton = new JButton("  Reset  ");
            resetButton.setFocusPainted(false);
            resetButton.setBorder(BorderFactory.createBevelBorder(0, Color.lightGray, Color.darkGray));
            final int finNum = ATTRACTInitBox.this.exptNames.size();
            resetButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    for (int i = 0; i < finNum; ++i) {
                        ATTRACTInitBox.this.mPanel.sampleSelectionPanel.notInTimeGroupRadioButtons[i].setSelected(true);
                    }
                }
            });
            JFileChooser fc = new JFileChooser();
            fc.setCurrentDirectory(new File("Data"));
            saveButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    MultiClassPanel.this.saveAssignments();
                }
            });
            loadButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    MultiClassPanel.this.loadAssignments();
                }
            });
            this.constraints.anchor = 10;
            this.constraints.fill = 0;
            this.constraints.insets = new Insets(5, 5, 5, 5);
            ATTRACTInitBox.this.buildConstraints(this.constraints, 0, 0, 1, 1, 33, 100);
            gridbag3.setConstraints(saveButton, this.constraints);
            panel2.add(saveButton);
            ATTRACTInitBox.this.buildConstraints(this.constraints, 1, 0, 1, 1, 33, 0);
            gridbag3.setConstraints(loadButton, this.constraints);
            panel2.add(loadButton);
            ATTRACTInitBox.this.buildConstraints(this.constraints, 2, 0, 1, 1, 34, 0);
            gridbag3.setConstraints(resetButton, this.constraints);
            panel2.add(resetButton);
            this.constraints.insets = new Insets(0, 0, 0, 0);
            ATTRACTInitBox.this.buildConstraints(this.constraints, 0, 2, 1, 1, 0, 5);
            this.constraints.anchor = 10;
            return panel2;
        }

        protected void reset() {
            if (this.ngPanel.okPressed) {
                this.sampleSelectionPanel.reset();
            }
        }

        class ExperimentsSelectionPanel
        extends JPanel {
            private static final long serialVersionUID = 1L;
            int design = 0;
            int numPanels = 0;
            JLabel[] expLabels;
            JRadioButton[][] assignmentRBs;
            JRadioButton[] notInTimeGroupRadioButtons;

            ExperimentsSelectionPanel(Vector<String> exptNames, int numGroups, int design, String title, boolean firstPanel) {
                int i;
                int i2;
                this.design = design;
                this.setBorder(new TitledBorder(new EtchedBorder(), title + " Assignments", 0, 0, new Font("Dialog", 1, 12), Color.black));
                this.setBackground(Color.white);
                this.expLabels = new JLabel[exptNames.size()];
                this.assignmentRBs = new JRadioButton[numGroups][exptNames.size()];
                this.numPanels = exptNames.size() / 512 + 1;
                this.notInTimeGroupRadioButtons = new JRadioButton[exptNames.size()];
                ButtonGroup[] chooseTime = new ButtonGroup[exptNames.size()];
                ButtonGroup[] chooseCondition = new ButtonGroup[exptNames.size()];
                GridBagLayout gridbag = new GridBagLayout();
                GridBagLayout gridbag2 = new GridBagLayout();
                GridBagConstraints constraints = new GridBagConstraints();
                this.setLayout(gridbag2);
                JPanel[] panels = new JPanel[this.numPanels];
                int currPanel = 0;
                for (i2 = 0; i2 < panels.length; ++i2) {
                    panels[i2] = new JPanel(gridbag);
                }
                for (i2 = 0; i2 < exptNames.size(); ++i2) {
                    String s1 = exptNames.get(i2);
                    this.expLabels[i2] = new JLabel(s1);
                    chooseTime[i2] = new ButtonGroup();
                    chooseCondition[i2] = new ButtonGroup();
                    String[] groupNames = ATTRACTInitBox.this.getGroupNames();
                    for (int j = 0; j < numGroups; ++j) {
                        this.assignmentRBs[j][i2] = new JRadioButton(groupNames[j] + "     ", true);
                        chooseTime[i2].add(this.assignmentRBs[j][i2]);
                    }
                    currPanel = i2 / 512;
                    this.notInTimeGroupRadioButtons[i2] = new JRadioButton("Unassigned", false);
                    chooseTime[i2].add(this.notInTimeGroupRadioButtons[i2]);
                    int twoCondRoom = 0;
                    for (int j = 0; j < numGroups; ++j) {
                        ATTRACTInitBox.this.buildConstraints(constraints, j + twoCondRoom, i2 % 512, 1, 1, 100, 100);
                        gridbag.setConstraints(this.assignmentRBs[j][i2], constraints);
                        panels[currPanel].add(this.assignmentRBs[j][i2]);
                    }
                    ATTRACTInitBox.this.buildConstraints(constraints, numGroups + 1 + twoCondRoom, i2 % 512, 1, 1, 100, 100);
                    gridbag.setConstraints(this.notInTimeGroupRadioButtons[i2], constraints);
                }
                int maxLabelWidth = 0;
                for (int i3 = 0; i3 < this.expLabels.length; ++i3) {
                    if (!(this.expLabels[i3].getPreferredSize().getWidth() > (double)maxLabelWidth)) continue;
                    maxLabelWidth = (int)Math.ceil(this.expLabels[i3].getPreferredSize().getWidth());
                }
                JPanel bigPanel = new JPanel(new GridBagLayout());
                for (int i4 = 0; i4 < this.numPanels; ++i4) {
                    bigPanel.add((Component)panels[i4], new GridBagConstraints(0, i4, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
                }
                JScrollPane scroll = new JScrollPane(bigPanel);
                scroll.setHorizontalScrollBarPolicy(32);
                scroll.setVerticalScrollBarPolicy(22);
                JPanel[] exptNameHeaderPanels = new JPanel[this.numPanels];
                GridBagLayout exptHeaderGridbag = new GridBagLayout();
                for (i = 0; i < exptNameHeaderPanels.length; ++i) {
                    exptNameHeaderPanels[i] = new JPanel();
                    exptNameHeaderPanels[i].setSize(50, panels[i].getPreferredSize().height);
                    exptNameHeaderPanels[i].setPreferredSize(new Dimension(maxLabelWidth + 10, panels[i].getPreferredSize().height));
                    exptNameHeaderPanels[i].setLayout(exptHeaderGridbag);
                }
                for (i = 0; i < this.expLabels.length; ++i) {
                    currPanel = i / 512;
                    ATTRACTInitBox.this.buildConstraints(constraints, 0, i % 512, 1, 1, 100, 100);
                    constraints.fill = 1;
                    exptHeaderGridbag.setConstraints(this.expLabels[i], constraints);
                    exptNameHeaderPanels[currPanel].add(this.expLabels[i]);
                }
                JPanel headerPanel = new JPanel(new GridBagLayout());
                for (int i5 = 0; i5 < exptNameHeaderPanels.length; ++i5) {
                    headerPanel.add((Component)exptNameHeaderPanels[i5], new GridBagConstraints(0, i5, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
                }
                scroll.setRowHeaderView(headerPanel);
                ATTRACTInitBox.this.buildConstraints(constraints, 0, 0, 1, 1, 100, 90, 10, 1);
                gridbag2.setConstraints(scroll, constraints);
                this.add(scroll);
            }

            protected void reset() {
                for (int i = 0; i < ATTRACTInitBox.this.exptNames.size(); ++i) {
                    this.notInTimeGroupRadioButtons[i].setSelected(true);
                }
            }
        }

        class DesignPanel
        extends JPanel {
            private static final long serialVersionUID = 1L;
            JTextField numGroupsField;
            JTextField alphaField;
            JComboBox chipNameBox;
            JLabel numGroupsLabel;
            boolean okPressed = false;
            JRadioButton twoClass;
            JRadioButton multiClass;
            private JLabel[] groupNameLabel;
            private JTextField[] groupNameField;

            public DesignPanel() {
                int i;
                this.setBackground(Color.white);
                GridBagLayout gridbag = new GridBagLayout();
                GridBagConstraints constraints = new GridBagConstraints();
                this.setLayout(gridbag);
                this.setMinimumSize(new Dimension(300, 100));
                JLabel dataTypeLabel = new JLabel("Experimental Design:   ");
                ATTRACTInitBox.this.buildConstraints(constraints, 0, 0, 1, 1, 30, 100, 13);
                gridbag.setConstraints(dataTypeLabel, constraints);
                this.add(dataTypeLabel);
                this.twoClass = new JRadioButton("Two Class", true);
                this.multiClass = new JRadioButton("Multi-Class", false);
                this.twoClass.setBackground(Color.white);
                this.twoClass.setBorder(null);
                this.multiClass.setBackground(Color.white);
                this.multiClass.setBorder(null);
                ButtonGroup dataType = new ButtonGroup();
                dataType.add(this.twoClass);
                dataType.add(this.multiClass);
                this.twoClass.addActionListener(new RadioButtonListener());
                this.multiClass.addActionListener(new RadioButtonListener());
                ATTRACTInitBox.this.buildConstraints(constraints, 1, 0, 1, 1, 30, 100);
                constraints.anchor = 17;
                gridbag.setConstraints(this.twoClass, constraints);
                this.add(this.twoClass);
                ATTRACTInitBox.this.buildConstraints(constraints, 1, 1, 1, 1, 30, 100);
                constraints.anchor = 17;
                gridbag.setConstraints(this.multiClass, constraints);
                this.add(this.multiClass);
                this.numGroupsLabel = new JLabel("Number of groups: ");
                this.numGroupsLabel.setVisible(false);
                ATTRACTInitBox.this.buildConstraints(constraints, 0, 5, 1, 1, 30, 100);
                constraints.anchor = 13;
                gridbag.setConstraints(this.numGroupsLabel, constraints);
                this.add(this.numGroupsLabel);
                this.numGroupsField = new JTextField("4", 7);
                this.numGroupsField.setVisible(false);
                this.numGroupsField.setMinimumSize(new Dimension(50, 20));
                constraints.anchor = 17;
                ATTRACTInitBox.this.buildConstraints(constraints, 1, 5, 1, 1, 30, 0);
                gridbag.setConstraints(this.numGroupsField, constraints);
                this.add(this.numGroupsField);
                this.numGroupsField.addKeyListener(new KeyListener(){

                    @Override
                    public void keyPressed(KeyEvent e) {
                    }

                    @Override
                    public void keyReleased(KeyEvent e) {
                        ATTRACTInitBox.this.showGroupNameTextFields();
                    }

                    @Override
                    public void keyTyped(KeyEvent e) {
                    }
                });
                constraints.ipady = 0;
                JLabel alphaLabel = new JLabel("Limma significance Level: Alpha = ");
                ATTRACTInitBox.this.buildConstraints(constraints, 0, 6, 1, 1, 30, 100);
                constraints.anchor = 13;
                gridbag.setConstraints(alphaLabel, constraints);
                this.add(alphaLabel);
                this.alphaField = new JTextField(".2", 7);
                this.alphaField.setMinimumSize(new Dimension(50, 20));
                constraints.anchor = 17;
                ATTRACTInitBox.this.buildConstraints(constraints, 1, 6, 1, 1, 30, 0);
                gridbag.setConstraints(this.alphaField, constraints);
                this.add(this.alphaField);
                JLabel chipNameLabel = new JLabel("Chip Name: ");
                ATTRACTInitBox.this.buildConstraints(constraints, 0, 7, 1, 1, 30, 100);
                constraints.anchor = 13;
                gridbag.setConstraints(chipNameLabel, constraints);
                this.add(chipNameLabel);
                ArrayList<String> bioCAnnotations = new ArrayList<String>();
                try {
                    String urlString;
                    String fullURL = urlString = "ftp://occams.dfci.harvard.edu/pub/bio/MeV_Etc/R_MeV_Support_devel/R2.11/win/attract/annotationSupported.txt";
                    URL url = new URL(fullURL);
                    URLConnection url_conn = url.openConnection();
                    url_conn.setDoInput(true);
                    url_conn.setUseCaches(true);
                    BufferedReader inp = new BufferedReader(new InputStreamReader(url_conn.getInputStream()));
                    String s = inp.readLine();
                    while (s != null) {
                        bioCAnnotations.add(s);
                        s = inp.readLine();
                    }
                }
                catch (Exception e) {
                    System.out.println("Error reading supported Bioconductor annotations");
                }
                String[] bioCAnnotationsArray = new String[bioCAnnotations.size()];
                int defaultIndex = -1;
                for (i = 0; i < bioCAnnotationsArray.length; ++i) {
                    bioCAnnotationsArray[i] = (String)bioCAnnotations.get(i);
                    if (!bioCAnnotationsArray[i].equals(ATTRACTInitBox.this.initialChipType) && !bioCAnnotationsArray[i].equals(ATTRACTInitBox.this.initialChipType + ".db")) continue;
                    defaultIndex = i;
                }
                this.chipNameBox = new JComboBox<String>(bioCAnnotationsArray);
                if (defaultIndex == -1 || ATTRACTInitBox.this.initialChipType.equals("NA")) {
                    this.chipNameBox.setSelectedItem("hgu133plus2.db");
                } else {
                    this.chipNameBox.setSelectedIndex(defaultIndex);
                }
                this.chipNameBox.setMinimumSize(new Dimension(50, 20));
                constraints.anchor = 17;
                ATTRACTInitBox.this.buildConstraints(constraints, 1, 7, 1, 1, 30, 0);
                gridbag.setConstraints(this.chipNameBox, constraints);
                this.add(this.chipNameBox);
                this.groupNameLabel = new JLabel[8];
                this.groupNameField = new JTextField[8];
                for (i = 0; i < 8; ++i) {
                    this.groupNameLabel[i] = new JLabel("Group " + (i + 1) + " Name: ");
                    ATTRACTInitBox.this.buildConstraints(constraints, 0, 8 + i, 1, 1, 30, 100);
                    constraints.anchor = 13;
                    gridbag.setConstraints(this.groupNameLabel[i], constraints);
                    this.add(this.groupNameLabel[i]);
                    this.groupNameLabel[i].setVisible(false);
                    this.groupNameField[i] = new JTextField("Group " + (i + 1), 7);
                    this.groupNameField[i].setMinimumSize(new Dimension(50, 20));
                    constraints.anchor = 17;
                    ATTRACTInitBox.this.buildConstraints(constraints, 1, 8 + i, 1, 1, 30, 0);
                    gridbag.setConstraints(this.groupNameField[i], constraints);
                    this.add(this.groupNameField[i]);
                    this.groupNameField[i].setVisible(false);
                }
            }

            public int getExperimentDesign() {
                if (this.twoClass.isSelected()) {
                    return 2;
                }
                if (this.multiClass.isSelected()) {
                    return 3;
                }
                return 0;
            }

            @Override
            public void setVisible(boolean visible) {
                this.setLocation((MultiClassPanel.this.getWidth() - this.getSize().width) / 2, (MultiClassPanel.this.getHeight() - this.getSize().height) / 2);
                super.setVisible(visible);
                if (visible) {
                    // empty if block
                }
            }

            public boolean isOkPressed() {
                return this.okPressed;
            }
        }
    }

    class HCLoptionPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private JCheckBox hclCluster;
        private JRadioButton sigOnly;
        private JRadioButton allClusters;
        GridBagConstraints constraints = new GridBagConstraints();
        GridBagLayout gridbag = new GridBagLayout();

        public HCLoptionPanel() {
            this.setBackground(Color.white);
            Font font = new Font("Dialog", 1, 12);
            this.setLayout(this.gridbag);
            this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Hierarchical Clustering", 0, 0, font, Color.black));
            this.hclCluster = new JCheckBox("Construct Hierarchical Trees for :            ");
            this.hclCluster.setFocusPainted(false);
            this.hclCluster.setBackground(Color.white);
            this.hclCluster.setForeground(UIManager.getColor("Label.foreground"));
            this.sigOnly = new JRadioButton("Significant genes only", true);
            this.sigOnly.setBackground(Color.white);
            this.sigOnly.setForeground(UIManager.getColor("Label.foreground"));
            this.allClusters = new JRadioButton("All clusters", false);
            this.allClusters.setBackground(Color.white);
            this.allClusters.setForeground(UIManager.getColor("Label.foreground"));
            this.sigOnly.setEnabled(false);
            this.allClusters.setEnabled(false);
            ButtonGroup allOrSig = new ButtonGroup();
            allOrSig.add(this.sigOnly);
            allOrSig.add(this.allClusters);
            this.hclCluster.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 2) {
                        HCLoptionPanel.this.sigOnly.setEnabled(false);
                        HCLoptionPanel.this.allClusters.setEnabled(false);
                    } else {
                        HCLoptionPanel.this.sigOnly.setEnabled(true);
                        HCLoptionPanel.this.allClusters.setEnabled(true);
                    }
                }
            });
            ATTRACTInitBox.this.buildConstraints(this.constraints, 0, 0, 1, 1, 25, 10, 17);
            this.gridbag.setConstraints(this.hclCluster, this.constraints);
            this.add(this.hclCluster);
            ATTRACTInitBox.this.buildConstraints(this.constraints, 0, 1, 1, 1, 25, 10);
            this.gridbag.setConstraints(this.sigOnly, this.constraints);
            this.add(this.sigOnly);
            ATTRACTInitBox.this.buildConstraints(this.constraints, 0, 2, 1, 1, 25, 10);
            this.gridbag.setConstraints(this.allClusters, this.constraints);
            this.add(this.allClusters);
            JPanel dummyPanel = new JPanel();
            ATTRACTInitBox.this.buildConstraints(this.constraints, 0, 3, 1, 1, 25, 100);
            this.gridbag.setConstraints(dummyPanel, this.constraints);
            dummyPanel.setBackground(Color.white);
            this.add(dummyPanel);
        }

        public HCLoptionPanel(Color background) {
            this();
            this.setBackground(background);
        }

        public boolean isHCLSelected() {
            return this.hclCluster.isSelected();
        }

        public boolean drawSigTreesOnly() {
            return this.sigOnly.isSelected();
        }

        public void setHCLSelected(boolean value) {
            this.hclCluster.setSelected(value);
        }
    }
}

