/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl.attract;

import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;
import org.tigr.microarray.mev.cluster.Cluster;
import org.tigr.microarray.mev.cluster.Node;
import org.tigr.microarray.mev.cluster.NodeList;
import org.tigr.microarray.mev.cluster.NodeValueList;
import org.tigr.microarray.mev.cluster.algorithm.Algorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmListener;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IClusterGUI;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.IDistanceMenu;
import org.tigr.microarray.mev.cluster.gui.IFramework;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.LeafInfo;
import org.tigr.microarray.mev.cluster.gui.helpers.BoxChartViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.CentroidUserObject;
import org.tigr.microarray.mev.cluster.gui.helpers.ClusterTableViewer;
import org.tigr.microarray.mev.cluster.gui.impl.attract.ATTRACTCentroidViewer;
import org.tigr.microarray.mev.cluster.gui.impl.attract.ATTRACTExperimentViewer;
import org.tigr.microarray.mev.cluster.gui.impl.attract.ATTRACTInfoViewer;
import org.tigr.microarray.mev.cluster.gui.impl.attract.ATTRACTInitBox;
import org.tigr.microarray.mev.cluster.gui.impl.attract.ATTRACTResultTable;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.DialogListener;
import org.tigr.microarray.mev.cluster.gui.impl.dialogs.Progress;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLGUI;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLInitDialog;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLTreeData;
import org.tigr.microarray.mev.cluster.gui.impl.hcl.HCLViewer;
import org.tigr.microarray.mev.script.scriptGUI.IScriptGUI;
import org.tigr.util.FloatMatrix;

public class ATTRACTGUI
implements IClusterGUI,
IScriptGUI {
    protected Algorithm algorithm;
    protected Progress progress;
    protected Experiment experiment;
    protected int[][] keggSynArrays;
    protected int[][] keggCorArrays;
    protected int[][] errorGenesArray = new int[1][];
    protected FloatMatrix means;
    protected FloatMatrix variances;
    protected int[][] sigGenesArrays;
    protected String[] auxTitles;
    protected Object[][] auxData;
    protected float[][] geneGroupMeans;
    protected float[][] geneGroupSDs;
    protected boolean drawSigTreesOnly;
    Vector<String> exptNamesVector;
    protected int[] groupAssignments;
    protected double falseProp;
    protected IData data;
    protected int numGroups;
    protected int dataDesign;
    protected int numFactorAGroups;
    protected int numFactorBGroups;
    protected float alpha;
    protected String factorAName;
    protected String factorBName;
    protected boolean errorGenes;
    protected boolean isHierarchicalTree;
    protected int iterations;
    protected ArrayList<String> geneLabels;
    protected ArrayList<String> sampleLabels;
    private Object[][] synResultMatrix;
    private String chipName;
    private IFramework framework;
    private String[] resultColumns;
    private String[] groupNames;
    private String[] nodeTitlesSyn;
    private String[] nodeTitlesCor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultMutableTreeNode execute(IFramework framework) throws AlgorithmException {
        IDistanceMenu menu;
        int function;
        int i;
        if (this.sysMsg() != 0) {
            return null;
        }
        this.framework = framework;
        this.experiment = framework.getData().getExperiment();
        this.data = framework.getData();
        this.exptNamesVector = new Vector();
        int number_of_samples = this.experiment.getNumberOfSamples();
        int[] columnIndices = this.experiment.getColumnIndicesCopy();
        this.sampleLabels = new ArrayList();
        this.geneLabels = new ArrayList();
        for (i = 0; i < number_of_samples; ++i) {
            this.exptNamesVector.add(framework.getData().getFullSampleName(columnIndices[i]));
            this.sampleLabels.add(framework.getData().getFullSampleName(columnIndices[i]));
        }
        for (i = 0; i < this.experiment.getNumberOfGenes(); ++i) {
            this.geneLabels.add(String.valueOf(i));
        }
        String initialChipType = framework.getData().getChipAnnotation().getChipType();
        ATTRACTInitBox ATTRACTDialog = new ATTRACTInitBox((JFrame)framework.getFrame(), true, this.exptNamesVector, framework.getClusterRepository(1), initialChipType);
        ATTRACTDialog.setVisible(true);
        if (!ATTRACTDialog.isOkPressed()) {
            return null;
        }
        this.alpha = ATTRACTDialog.getAlpha();
        this.dataDesign = ATTRACTDialog.getExperimentalDesign();
        this.numGroups = ATTRACTDialog.getNumGroups();
        this.chipName = ATTRACTDialog.getChipName();
        this.groupNames = ATTRACTDialog.getGroupNames();
        this.groupAssignments = ATTRACTDialog.getGroupAssignments();
        if (this.groupAssignments == null) {
            return null;
        }
        this.isHierarchicalTree = ATTRACTDialog.drawTrees();
        this.drawSigTreesOnly = true;
        if (this.isHierarchicalTree) {
            this.drawSigTreesOnly = ATTRACTDialog.drawSigTreesOnly();
        }
        if ((function = (menu = framework.getDistanceMenu()).getDistanceFunction()) == 0) {
            function = 1;
        }
        int hcl_method = 0;
        boolean hcl_samples = false;
        boolean hcl_genes = false;
        int hcl_function = 4;
        boolean hcl_absolute = false;
        boolean hcl_samples_ordered = false;
        boolean hcl_genes_ordered = false;
        if (this.isHierarchicalTree) {
            HCLInitDialog hcl_dialog = new HCLInitDialog(framework.getFrame(), menu.getFunctionName(function), menu.isAbsoluteDistance(), true);
            if (hcl_dialog.showModal() != 0) {
                return null;
            }
            hcl_method = hcl_dialog.getMethod();
            hcl_samples = hcl_dialog.isClusterExperiments();
            hcl_genes = hcl_dialog.isClusterGenes();
            hcl_function = hcl_dialog.getDistanceMetric();
            hcl_absolute = hcl_dialog.getAbsoluteSelection();
            hcl_genes_ordered = hcl_dialog.isGeneOrdering();
            hcl_samples_ordered = hcl_dialog.isSampleOrdering();
        }
        Listener listener = new Listener();
        try {
            int i2;
            this.algorithm = framework.getAlgorithmFactory().getAlgorithm("ATTRACT");
            this.algorithm.addAlgorithmListener((AlgorithmListener)listener);
            this.progress = new Progress(framework.getFrame(), "ATTRACT", listener);
            this.progress.setIndeterminate(true);
            this.progress.setIndeterminantString("Attract analysis is running...");
            this.progress.show();
            AlgorithmData data = new AlgorithmData();
            data.addMatrix("experiment", this.experiment.getMatrix());
            data.addIntArray("group_assignments", this.groupAssignments);
            data.addParam("dataDesign", String.valueOf(this.dataDesign));
            data.addParam("numGroups", String.valueOf(this.numGroups));
            data.addParam("alpha", String.valueOf(this.alpha));
            data.addParam("chipName", this.chipName);
            data.addStringArray("geneLabels", this.geneLabels.toArray(new String[this.geneLabels.size()]));
            data.addStringArray("sampleLabels", this.sampleLabels.toArray(new String[this.sampleLabels.size()]));
            data.addStringArray("probeIDs", framework.getData().getAnnotationList("PROBE_ID"));
            if (this.isHierarchicalTree) {
                data.addParam("hierarchical-tree", String.valueOf(true));
                data.addParam("draw-sig-trees-only", String.valueOf(this.drawSigTreesOnly));
                data.addParam("method-linkage", String.valueOf(hcl_method));
                data.addParam("calculate-genes", String.valueOf(hcl_genes));
                data.addParam("calculate-experiments", String.valueOf(hcl_samples));
                data.addParam("hcl-distance-function", String.valueOf(hcl_function));
                data.addParam("hcl-distance-absolute", String.valueOf(hcl_absolute));
                data.addParam("hcl-genes-ordered", String.valueOf(hcl_genes_ordered));
                data.addParam("hcl-samples-ordered", String.valueOf(hcl_samples_ordered));
            }
            long start = System.currentTimeMillis();
            AlgorithmData result = this.algorithm.execute(data);
            long time = System.currentTimeMillis() - start;
            this.means = result.getMatrix("clusters_means");
            this.variances = result.getMatrix("clusters_variances");
            this.synResultMatrix = result.getObjectMatrix("synResultMatrix");
            this.resultColumns = result.getStringArray("resultColumns");
            this.nodeTitlesSyn = result.getStringArray("nodeTitlesSyn");
            this.nodeTitlesCor = result.getStringArray("nodeTitlesCor");
            this.keggSynArrays = result.getIntMatrix("keggSynArrays");
            this.keggCorArrays = result.getIntMatrix("keggCorArrays");
            FloatMatrix geneGroupMeansMatrix = result.getMatrix("geneGroupMeansMatrix");
            FloatMatrix geneGroupSDsMatrix = result.getMatrix("geneGroupSDsMatrix");
            this.iterations = result.getParams().getInt("iterations");
            this.geneGroupMeans = new float[geneGroupMeansMatrix.getRowDimension()][geneGroupMeansMatrix.getColumnDimension()];
            this.geneGroupSDs = new float[geneGroupSDsMatrix.getRowDimension()][geneGroupSDsMatrix.getColumnDimension()];
            for (int i3 = 0; i3 < this.geneGroupMeans.length; ++i3) {
                for (int j = 0; j < this.geneGroupMeans[i3].length; ++j) {
                    this.geneGroupMeans[i3][j] = geneGroupMeansMatrix.A[i3][j];
                    this.geneGroupSDs[i3][j] = geneGroupSDsMatrix.A[i3][j];
                }
            }
            GeneralInfo info = new GeneralInfo();
            info.time = time;
            info.alpha = this.alpha;
            info.function = menu.getFunctionName(function);
            info.hcl = this.isHierarchicalTree;
            info.hcl_genes = hcl_genes;
            info.hcl_samples = hcl_samples;
            info.hcl_method = hcl_method;
            Vector<String> titlesVector = new Vector<String>();
            for (int i4 = 0; i4 < this.geneGroupMeans[0].length; ++i4) {
                titlesVector.add("Group " + (i4 + 1) + " mean");
                titlesVector.add("Group " + (i4 + 1) + " std.dev");
            }
            titlesVector.add("F-values");
            int x = 1;
            int y = 2;
            for (i2 = 0; i2 < this.getTotalInteractions(this.numGroups); ++i2) {
                titlesVector.add("significance-values, " + x + "vs." + y);
                titlesVector.add("adj-p-values, " + x + "vs." + y);
                titlesVector.add("log fold change, " + x + "vs." + y);
                titlesVector.add("t-statistic, " + x + "vs." + y);
                titlesVector.add("log-odds, " + x + "vs." + y);
                if (++y <= this.numGroups) continue;
                y = ++x + 1;
            }
            this.auxTitles = new String[titlesVector.size()];
            for (i2 = 0; i2 < this.auxTitles.length; ++i2) {
                this.auxTitles[i2] = (String)titlesVector.get(i2);
            }
            this.auxData = new Object[this.experiment.getNumberOfGenes()][this.auxTitles.length];
            for (i2 = 0; i2 < this.auxData.length; ++i2) {
                int counter = 0;
                for (int j = 0; j < this.geneGroupMeans[i2].length; ++j) {
                    this.auxData[i2][counter++] = new Float(this.geneGroupMeans[i2][j]);
                    this.auxData[i2][counter++] = new Float(this.geneGroupSDs[i2][j]);
                }
            }
            DefaultMutableTreeNode defaultMutableTreeNode = this.createResultTree(info);
            return defaultMutableTreeNode;
        }
        finally {
            if (this.algorithm != null) {
                this.algorithm.removeAlgorithmListener((AlgorithmListener)listener);
            }
            if (this.progress != null) {
                this.progress.dispose();
            }
        }
    }

    public AlgorithmData getScriptParameters(IFramework framework) {
        return null;
    }

    public DefaultMutableTreeNode executeScript(IFramework framework, AlgorithmData algData, Experiment experiment) throws AlgorithmException {
        return null;
    }

    private int getTotalInteractions(int groups) {
        if (groups <= 1) {
            return 0;
        }
        return groups - 1 + this.getTotalInteractions(groups - 1);
    }

    public static void main(String[] args) {
    }

    protected String getNodeTitle(int ind, boolean syn) {
        if (syn) {
            return this.nodeTitlesSyn[ind];
        }
        return this.nodeTitlesCor[ind];
    }

    protected DefaultMutableTreeNode createResultTree(GeneralInfo info) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("ATTRACT");
        this.addResultNodes(root, info);
        return root;
    }

    protected void addResultNodes(DefaultMutableTreeNode root, GeneralInfo info) {
        int i;
        String title = "Synexpression";
        this.addGeneSetInfo(root, this.synResultMatrix, title);
        boolean resultsFound = false;
        if (this.keggSynArrays != null) {
            for (i = 0; i < this.keggSynArrays.length; ++i) {
                if (this.keggSynArrays[i].length <= 0) continue;
                resultsFound = true;
                break;
            }
        }
        if (!resultsFound) {
            this.addNoResultsNode(root);
        } else {
            this.addExpressionImages(root, this.keggSynArrays, title, true);
            this.addExpressionCharts(root, this.keggSynArrays, title, true);
            this.addCentroidViews(root, this.keggSynArrays, title, true);
            this.addTableViews(root, this.keggSynArrays, title, true);
            this.addClusterInfo(root, this.keggSynArrays, title, true);
        }
        title = "Correlated Partners";
        resultsFound = false;
        if (this.keggCorArrays != null) {
            for (i = 0; i < this.keggCorArrays.length; ++i) {
                if (this.keggCorArrays[i].length <= 0) continue;
                resultsFound = true;
                break;
            }
        }
        if (!resultsFound) {
            this.addNoResultsNode(root);
        } else {
            this.addExpressionImages(root, this.keggCorArrays, title, false);
            this.addExpressionCharts(root, this.keggCorArrays, title, false);
            this.addCentroidViews(root, this.keggCorArrays, title, false);
            this.addTableViews(root, this.keggCorArrays, title, false);
            this.addClusterInfo(root, this.keggCorArrays, title, false);
        }
        this.addNotEnoughGenesFolder(root, this.keggCorArrays, true);
        this.addGeneralInfo(root, info);
    }

    private void addExpressionCharts(DefaultMutableTreeNode root, int[][] keggArrays, String title, boolean syn) {
        int i;
        ArrayList[] groups = new ArrayList[this.numGroups];
        for (i = 0; i < groups.length; ++i) {
            groups[i] = new ArrayList();
        }
        for (i = 0; i < this.groupAssignments.length; ++i) {
            groups[this.groupAssignments[i] - 1].add(i);
        }
        int[][] sampleGroups = new int[this.numGroups][];
        for (int i2 = 0; i2 < sampleGroups.length; ++i2) {
            sampleGroups[i2] = new int[groups[i2].size()];
            for (int j = 0; j < sampleGroups[i2].length; ++j) {
                sampleGroups[i2][j] = (Integer)groups[i2].get(j);
            }
        }
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(title + " Expression Charts");
        for (int i3 = 0; i3 < keggArrays.length; ++i3) {
            if (keggArrays[i3].length <= 0) continue;
            BoxChartViewer echartViewer = new BoxChartViewer(this.framework, (int[][])sampleGroups, keggArrays[i3], this.getNodeTitle(i3, syn), this.groupNames);
            node.add(new DefaultMutableTreeNode(new LeafInfo(this.getNodeTitle(i3, syn), (IViewer)echartViewer, (Object)new Integer(i3))));
        }
        root.add(node);
    }

    protected void addExpressionImages(DefaultMutableTreeNode root, int[][] keggArrays, String title, boolean syn) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(title + " Expression Images");
        ATTRACTExperimentViewer expViewer = new ATTRACTExperimentViewer(this.experiment, keggArrays, (float[][])null, (float[][])null, null, null, null, null, null, null, null);
        for (int i = 0; i < keggArrays.length; ++i) {
            if (keggArrays[i].length <= 0) continue;
            node.add(new DefaultMutableTreeNode(new LeafInfo(this.getNodeTitle(i, syn), (IViewer)expViewer, (Object)new Integer(i))));
        }
        root.add(node);
    }

    private void addNoResultsNode(DefaultMutableTreeNode root) {
        root.add(new DefaultMutableTreeNode("No Results Found"));
    }

    private void addNotEnoughGenesFolder(DefaultMutableTreeNode root, int[][] keggArrays, boolean syn) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("Not Enough Significant Genes");
        boolean pathwaysExist = false;
        for (int i = 0; i < keggArrays.length; ++i) {
            if (keggArrays[i].length != 0) continue;
            node.add(new DefaultMutableTreeNode(new LeafInfo(this.getNodeTitle(i, syn), null, (Object)new Integer(i))));
            pathwaysExist = true;
        }
        if (pathwaysExist) {
            root.add(node);
        }
    }

    private void addGeneSetInfo(DefaultMutableTreeNode root, Object[][] matrix, String title) {
        Object[][] results = new Object[matrix[0].length][matrix.length];
        for (int i = 0; i < results.length; ++i) {
            for (int j = 0; j < results[0].length; ++j) {
                results[i][j] = matrix[j][i];
            }
        }
        ATTRACTResultTable tabViewer1 = new ATTRACTResultTable(results, root, this.framework, this.resultColumns, title);
        root.add(new DefaultMutableTreeNode(new LeafInfo(title + " Results Table", (IViewer)tabViewer1, (Object)new Integer(0))));
    }

    protected void addTableViews(DefaultMutableTreeNode root, int[][] keggArrays, String title, boolean syn) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(title + " Table Views");
        ClusterTableViewer tabViewer = new ClusterTableViewer(this.experiment, keggArrays, this.data, this.auxTitles, this.auxData);
        for (int i = 0; i < keggArrays.length; ++i) {
            if (keggArrays[i].length <= 0) continue;
            node.add(new DefaultMutableTreeNode(new LeafInfo(this.getNodeTitle(i, syn), (IViewer)tabViewer, (Object)new Integer(i))));
        }
        root.add(node);
    }

    protected void addHierarchicalTrees(DefaultMutableTreeNode root, Cluster result_cluster, GeneralInfo info) {
        if (!info.hcl) {
            return;
        }
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("Hierarchical Trees");
        NodeList nodeList = result_cluster.getNodeList();
        if (!this.drawSigTreesOnly) {
            for (int i = 0; i < nodeList.getSize(); ++i) {
                if (i < nodeList.getSize() - 1) {
                    node.add(new DefaultMutableTreeNode(new LeafInfo("Significant Genes ", this.createHCLViewer(nodeList.getNode(i), info))));
                    continue;
                }
                if (i != nodeList.getSize() - 1) continue;
                node.add(new DefaultMutableTreeNode(new LeafInfo("Non-significant Genes ", this.createHCLViewer(nodeList.getNode(i), info))));
            }
        } else {
            node.add(new DefaultMutableTreeNode(new LeafInfo("Significant Genes ", this.createHCLViewer(nodeList.getNode(0), info))));
        }
        root.add(node);
    }

    protected IViewer createHCLViewer(Node clusterNode, GeneralInfo info) {
        HCLTreeData genes_result;
        HCLTreeData hCLTreeData = genes_result = info.hcl_genes ? this.getResult(clusterNode, 0) : null;
        HCLTreeData samples_result = info.hcl_samples ? this.getResult(clusterNode, info.hcl_genes ? 4 : 0) : null;
        return new HCLViewer(this.experiment, clusterNode.getFeaturesIndexes(), genes_result, samples_result);
    }

    protected HCLTreeData getResult(Node clusterNode, int pos) {
        HCLTreeData data = new HCLTreeData();
        NodeValueList valueList = clusterNode.getValues();
        data.child_1_array = (int[])valueList.getNodeValue((int)pos).value;
        data.child_2_array = (int[])valueList.getNodeValue((int)(pos + 1)).value;
        data.node_order = (int[])valueList.getNodeValue((int)(pos + 2)).value;
        data.height = (float[])valueList.getNodeValue((int)(pos + 3)).value;
        return data;
    }

    protected void addClusterInfo(DefaultMutableTreeNode root, int[][] keggArrays, String title, boolean syn) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(title + " Pathway Information");
        node.add(new DefaultMutableTreeNode(new LeafInfo("Results", (IViewer)new ATTRACTInfoViewer(keggArrays, this.experiment.getNumberOfGenes(), this.dataDesign, this.numGroups, syn ? this.nodeTitlesSyn : this.nodeTitlesCor))));
        root.add(node);
    }

    protected void addCentroidViews(DefaultMutableTreeNode root, int[][] keggArrays, String title, boolean syn) {
        DefaultMutableTreeNode centroidNode = new DefaultMutableTreeNode(title + " Centroid Graphs");
        DefaultMutableTreeNode expressionNode = new DefaultMutableTreeNode(title + " Expression Graphs");
        ATTRACTCentroidViewer centroidViewer = new ATTRACTCentroidViewer(this.experiment, keggArrays, null, null, null, null, null, null, null, null, null);
        centroidViewer.setMeans(this.means.A);
        centroidViewer.setVariances(this.variances.A);
        for (int i = 0; i < keggArrays.length; ++i) {
            if (keggArrays[i].length <= 0) continue;
            centroidNode.add(new DefaultMutableTreeNode(new LeafInfo(this.getNodeTitle(i, syn), (IViewer)centroidViewer, (Object)new CentroidUserObject(i, 0))));
            expressionNode.add(new DefaultMutableTreeNode(new LeafInfo(this.getNodeTitle(i, syn), (IViewer)centroidViewer, (Object)new CentroidUserObject(i, 1))));
        }
        root.add(centroidNode);
        root.add(expressionNode);
    }

    protected void addGeneralInfo(DefaultMutableTreeNode root, GeneralInfo info) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode("General Information");
        if (this.isHierarchicalTree) {
            node.add(new DefaultMutableTreeNode("HCL: " + info.getMethodName()));
        }
        node.add(this.getGroupAssignmentInfo());
        node.add(new DefaultMutableTreeNode("Number of groups: " + this.numGroups));
        node.add(new DefaultMutableTreeNode("LIMMA cutoff, alpha: " + this.alpha));
        node.add(new DefaultMutableTreeNode("Bioconductor annotation: " + this.chipName));
        node.add(new DefaultMutableTreeNode("Execution Time: " + String.valueOf(info.time - 1L) + " ms"));
        root.add(node);
    }

    protected DefaultMutableTreeNode getGroupAssignmentInfo() {
        int i;
        DefaultMutableTreeNode groupAssignmentInfo = new DefaultMutableTreeNode("Group assignments ");
        DefaultMutableTreeNode notInGroups = new DefaultMutableTreeNode("Not in groups");
        DefaultMutableTreeNode[] groups = new DefaultMutableTreeNode[this.numGroups];
        for (i = 0; i < this.numGroups; ++i) {
            groups[i] = new DefaultMutableTreeNode("Group " + (i + 1));
        }
        for (i = 0; i < this.groupAssignments.length; ++i) {
            int currentGroup = this.groupAssignments[i];
            if (currentGroup == 0) {
                notInGroups.add(new DefaultMutableTreeNode(this.exptNamesVector.get(i)));
                continue;
            }
            groups[currentGroup - 1].add(new DefaultMutableTreeNode(this.exptNamesVector.get(i)));
        }
        for (i = 0; i < groups.length; ++i) {
            groupAssignmentInfo.add(groups[i]);
        }
        if (notInGroups.getChildCount() > 0) {
            groupAssignmentInfo.add(notInGroups);
        }
        return groupAssignmentInfo;
    }

    private int sysMsg() {
        String os = System.getProperty("os.name");
        String arch = System.getProperty("os.arch");
        String ver = System.getProperty("os.version");
        String message = "System Config:\n";
        message = message + "OS: " + os + " | Architecture: " + arch + " | Version: " + ver + "\n";
        message = message + "Please note:\n";
        if (arch.toLowerCase().contains("64") && os.toLowerCase().contains("mac")) {
            message = message + "You need to have 32Bit JVM as default for ATTRACT\n";
            message = message + "Please contact MeV Support if you need help.\n";
            message = message + "You also need to have R 2.11.x installed for ATTRACT\n";
            message = message + "Cancel if either is not installed. Ok to continue.";
            return JOptionPane.showConfirmDialog(null, message, "R Engine Warning", 2, 2);
        }
        if (arch.toLowerCase().contains("64")) {
            message = message + "You need to have 32Bit JVM as default for ATTRACT\n";
            message = message + "Please contact MeV Support if you need help.\n";
            message = message + "Cancel if 32 Bit JVM is not installed. Ok to continue.";
            return JOptionPane.showConfirmDialog(null, message, "R Engine Warning", 2, 2);
        }
        if (os.toLowerCase().contains("mac")) {
            message = message + "You need to have R 2.11.x installed for ATTRACT\n";
            message = message + "Cancel if R is not installed. Ok to continue.";
            return JOptionPane.showConfirmDialog(null, message, "R Engine Warning", 2, 2);
        }
        return 0;
    }

    protected class GeneralInfo {
        public int clusters;
        public String correctionMethod;
        public float alpha;
        public long time;
        public String function;
        protected boolean hcl;
        protected boolean usePerms;
        protected int hcl_method;
        protected int numPerms;
        protected boolean hcl_genes;
        protected boolean hcl_samples;

        protected GeneralInfo() {
        }

        public String getMethodName() {
            return this.hcl ? HCLGUI.GeneralInfo.getMethodName(this.hcl_method) : "no linkage";
        }
    }

    protected class Listener
    extends DialogListener
    implements AlgorithmListener {
        protected Listener() {
        }

        public void valueChanged(AlgorithmEvent event) {
            switch (event.getId()) {
                case 1: {
                    ATTRACTGUI.this.progress.setUnits(event.getIntValue());
                    ATTRACTGUI.this.progress.setDescription(event.getDescription());
                    break;
                }
                case 2: {
                    ATTRACTGUI.this.progress.setValue(event.getIntValue());
                    ATTRACTGUI.this.progress.setDescription(event.getDescription());
                    break;
                }
                case 3: {
                    int value = event.getIntValue();
                    if (value != -1) break;
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("cancel-command")) {
                ATTRACTGUI.this.algorithm.abort();
                ATTRACTGUI.this.progress.dispose();
            }
        }

        @Override
        public void windowClosing(WindowEvent e) {
            ATTRACTGUI.this.algorithm.abort();
            ATTRACTGUI.this.progress.dispose();
        }
    }
}

