/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.gui.impl;

import java.net.URL;
import java.util.ArrayList;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.tigr.microarray.mev.cluster.gui.AnalysisDescription;
import org.tigr.microarray.mev.cluster.gui.IGUIFactory;

public class GUIFactory
implements IGUIFactory {
    private ResourceBundle bundle;
    private static String BUNDLE_NAME = "org.tigr.microarray.mev.cluster.gui.impl.factory";

    public GUIFactory() {
        try {
            this.bundle = ResourceBundle.getBundle(BUNDLE_NAME);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public AnalysisDescription[] getAnalysisDescriptions() {
        if (this.bundle == null) {
            return null;
        }
        return this.createAnalysisDescription();
    }

    private AnalysisDescription[] createAnalysisDescription() {
        String names = null;
        try {
            names = this.bundle.getString("gui.names");
        }
        catch (MissingResourceException e) {
            e.printStackTrace();
        }
        if (names == null) {
            return null;
        }
        ArrayList<AnalysisDescription> list = new ArrayList<AnalysisDescription>();
        StringTokenizer tokenizer = new StringTokenizer(names, ":");
        while (tokenizer.hasMoreTokens()) {
            try {
                String key = tokenizer.nextToken();
                if (key.trim().equals("")) continue;
                String name = this.bundle.getString(key + ".name").trim();
                String clazz = this.bundle.getString(key + ".class").trim();
                String category = this.bundle.getString(key + ".category").trim();
                String tooltip = this.bundle.getString(key + ".tooltip").trim();
                ImageIcon smallIcon = GUIFactory.getIcon(this.bundle.getString(key + ".smallIcon").trim());
                ImageIcon largeIcon = GUIFactory.getIcon(this.bundle.getString(key + ".largeIcon").trim());
                list.add(new AnalysisDescription(name, clazz, category, (Icon)smallIcon, (Icon)largeIcon, tooltip));
            }
            catch (Exception e) {
                System.out.println("Error while reading " + BUNDLE_NAME + ".properties file: ");
                e.printStackTrace();
            }
        }
        return list.toArray(new AnalysisDescription[list.size()]);
    }

    public static ImageIcon getIcon(String name) {
        URL url = GUIFactory.class.getResource("/org/tigr/microarray/mev/cluster/gui/impl/images/" + name);
        if (url == null) {
            return null;
        }
        return new ImageIcon(url);
    }
}

