/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.algorithm;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class AlgorithmParameters
implements Serializable {
    private static final long serialVersionUID = 2921695136119710825L;
    protected Properties properties = new Properties();

    public void setProperty(String name, String value) {
        this.properties.setProperty(name, value);
    }

    public String getString(String key) {
        return this.properties.getProperty(key);
    }

    public String getString(String key, String defValue) {
        String value = this.properties.getProperty(key);
        if (value == null) {
            return defValue;
        }
        return value;
    }

    public boolean getBoolean(String key) {
        return Boolean.valueOf(this.properties.getProperty(key));
    }

    public boolean getBoolean(String key, boolean defValue) {
        String bool = this.properties.getProperty(key);
        if (bool == null) {
            return defValue;
        }
        return Boolean.valueOf(bool);
    }

    public int getInt(String key) {
        return Integer.parseInt(this.properties.getProperty(key));
    }

    public int getInt(String key, int defValue) {
        int value;
        try {
            value = Integer.parseInt(this.properties.getProperty(key));
        }
        catch (Exception nfe) {
            return defValue;
        }
        return value;
    }

    public long getLong(String key) {
        return Long.parseLong(this.properties.getProperty(key));
    }

    public long getLong(String key, long defValue) {
        long value;
        try {
            value = Long.parseLong(this.properties.getProperty(key));
        }
        catch (Exception nfe) {
            return defValue;
        }
        return value;
    }

    public float getFloat(String key) {
        return Float.parseFloat(this.properties.getProperty(key));
    }

    public double getDouble(String key) {
        return Double.parseDouble(this.properties.getProperty(key));
    }

    public float getFloat(String key, float defValue) {
        float value;
        try {
            value = Float.parseFloat(this.properties.getProperty(key));
        }
        catch (Exception nfe) {
            return defValue;
        }
        return value;
    }

    public URL getURL(String key) throws MalformedURLException {
        return new URL(this.properties.getProperty(key));
    }

    public Map getMap() {
        return this.properties;
    }

    public Set entrySet() {
        return this.properties.entrySet();
    }

    public Properties getProperty() {
        return this.properties;
    }
}

