/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.BehaviorRetained;
import javax.media.j3d.BehaviorStructure;
import javax.media.j3d.Bounds;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.Sensor;
import javax.media.j3d.WakeupCriterion;

public final class WakeupOnSensorExit
extends WakeupCriterion {
    Bounds region;
    Bounds transformedRegion;
    Sensor armingSensor;

    public WakeupOnSensorExit(Bounds bounds) {
        this.region = (Bounds)bounds.clone();
    }

    void addBehaviorCondition(BehaviorStructure behaviorStructure) {
        behaviorStructure.addSensorExitCondition(this);
    }

    public Bounds getBounds() {
        return (Bounds)this.region.clone();
    }

    public Sensor getTriggeringSensor() {
        BehaviorRetained behaviorRetained = this.behav;
        synchronized (behaviorRetained) {
            if (this.behav == null || !this.behav.inCallback) {
                throw new IllegalStateException(J3dI18N.getString("WakeupOnSensorExit0"));
            }
        }
        return this.armingSensor;
    }

    void removeBehaviorCondition(BehaviorStructure behaviorStructure) {
        behaviorStructure.removeSensorExitCondition(this);
    }

    void setTarget(Sensor sensor) {
        this.armingSensor = sensor;
    }

    void updateTransformRegion() {
        if (this.transformedRegion != null) {
            this.transformedRegion.set(this.region);
        } else {
            this.transformedRegion = (Bounds)this.region.clone();
        }
        this.transformedRegion.transform(this.behav.getCurrentLocalToVworld(null));
    }
}

