/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import javax.media.j3d.BehaviorScheduler;
import javax.media.j3d.BehaviorStructure;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.GeometryStructure;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.Locale;
import javax.media.j3d.MasterControl;
import javax.media.j3d.ObjectUpdate;
import javax.media.j3d.RenderingEnvironmentStructure;
import javax.media.j3d.SetLiveState;
import javax.media.j3d.SoundStructure;
import javax.media.j3d.TransformStructure;
import javax.media.j3d.View;
import javax.media.j3d.ViewPlatformRetained;

public class VirtualUniverse {
    static final int TRAVERSE = 0;
    static final int BRANCH_GROUP_DETACH = 1;
    static final int LOCALE_ADD_BRANCH_GRAPH = 2;
    static final int LOCALE_REMOVE_BRANCH_GRAPH = 3;
    static final int LOCALE_REPLACE_BRANCH_GRAPH = 4;
    static final int GROUP_SET_CHILD = 5;
    static final int GROUP_INSERT_CHILD = 6;
    static final int GROUP_REMOVE_CHILD = 7;
    static final int GROUP_ADD_CHILD = 8;
    static final int GROUP_MOVE_TO = 9;
    static final int COLL_TRAVERSE = 10;
    static MasterControl mc = null;
    Object sceneGraphLock = new Object();
    Object behaviorLock = new Object();
    Vector listOfLocales = new Vector();
    ArrayList viewPlatforms = new ArrayList();
    Object[] viewPlatformList = null;
    boolean vpChanged = false;
    Vector backgrounds = new Vector();
    Vector clips = new Vector();
    Vector sounds = new Vector();
    Vector soundscapes = new Vector();
    BehaviorScheduler behaviorScheduler = null;
    GeometryStructure geometryStructure = null;
    TransformStructure transformStructure = null;
    BehaviorStructure behaviorStructure = null;
    SoundStructure soundStructure = null;
    RenderingEnvironmentStructure renderingEnvironmentStructure = null;
    int renderingEnvironmentStructureRefCount = 0;
    long nodeIdCount = 0L;
    int viewIdCount = 0;
    Vector nodeIdFreeList = new Vector();
    ArrayList viewIdFreeList = new ArrayList();
    int numNodes = 0;
    SetLiveState setLiveState;
    ObjectUpdate[] updateObjects = new ObjectUpdate[16];
    int updateObjectsLen = 0;
    ArrayList dirtyGeomList = new ArrayList();
    View currentView;
    boolean inBehavior = false;
    boolean enableComponent = false;
    boolean enableFocus = false;
    boolean enableKey = false;
    boolean enableMouse = false;
    boolean enableMouseMotion = false;
    int activeViewCount = 0;
    static ThreadGroup rootThreadGroup;

    static {
        mc = new MasterControl();
    }

    public VirtualUniverse() {
        this.setLiveState = new SetLiveState(this);
        this.geometryStructure = new GeometryStructure(this);
        this.transformStructure = new TransformStructure(this);
        this.behaviorStructure = new BehaviorStructure(this);
        this.soundStructure = new SoundStructure(this);
        this.renderingEnvironmentStructure = new RenderingEnvironmentStructure(this);
    }

    void addLocale(Locale locale) {
        this.listOfLocales.addElement(locale);
    }

    void addViewIdToFreeList(Integer n) {
        ArrayList arrayList = this.viewIdFreeList;
        synchronized (arrayList) {
            this.viewIdFreeList.add(n);
        }
    }

    void addViewPlatform(ViewPlatformRetained viewPlatformRetained) {
        this.vpChanged = true;
        this.viewPlatforms.add(viewPlatformRetained);
    }

    void checkForEnableEvents() {
        this.enableComponentEvents();
        if (this.enableFocus) {
            this.enableFocusEvents();
        }
        if (this.enableKey) {
            this.enableKeyEvents();
        }
        if (this.enableMouse) {
            this.enableMouseEvents();
        }
        if (this.enableMouseMotion) {
            this.enableMouseMotionEvents();
        }
    }

    void enableComponentEvents() {
        Object[] objectArray = this.getViewPlatformList();
        if (objectArray != null) {
            int n = 0;
            while (n < objectArray.length) {
                ViewPlatformRetained viewPlatformRetained = (ViewPlatformRetained)objectArray[n];
                View[] viewArray = viewPlatformRetained.getViewList();
                int n2 = viewArray.length - 1;
                while (n2 >= 0) {
                    Enumeration enumeration = viewArray[n2].getAllCanvas3Ds();
                    while (enumeration.hasMoreElements()) {
                        Canvas3D canvas3D = (Canvas3D)enumeration.nextElement();
                        if (canvas3D.eventCatcher == null) continue;
                        canvas3D.eventCatcher.enableComponentEvents();
                    }
                    --n2;
                }
                ++n;
            }
        }
    }

    void enableFocusEvents() {
        Object[] objectArray = this.getViewPlatformList();
        this.enableFocus = true;
        if (objectArray != null) {
            int n = 0;
            while (n < objectArray.length) {
                ViewPlatformRetained viewPlatformRetained = (ViewPlatformRetained)objectArray[n];
                View[] viewArray = viewPlatformRetained.getViewList();
                int n2 = viewArray.length - 1;
                while (n2 >= 0) {
                    Enumeration enumeration = viewArray[n2].getAllCanvas3Ds();
                    while (enumeration.hasMoreElements()) {
                        Canvas3D canvas3D = (Canvas3D)enumeration.nextElement();
                        if (canvas3D.eventCatcher == null) continue;
                        canvas3D.eventCatcher.enableFocusEvents();
                    }
                    --n2;
                }
                ++n;
            }
        }
    }

    void enableKeyEvents() {
        Object[] objectArray = this.getViewPlatformList();
        this.enableKey = true;
        if (objectArray != null) {
            int n = 0;
            while (n < objectArray.length) {
                ViewPlatformRetained viewPlatformRetained = (ViewPlatformRetained)objectArray[n];
                View[] viewArray = viewPlatformRetained.getViewList();
                int n2 = viewArray.length - 1;
                while (n2 >= 0) {
                    Enumeration enumeration = viewArray[n2].getAllCanvas3Ds();
                    while (enumeration.hasMoreElements()) {
                        Canvas3D canvas3D = (Canvas3D)enumeration.nextElement();
                        if (canvas3D.eventCatcher == null) continue;
                        canvas3D.eventCatcher.enableKeyEvents();
                    }
                    --n2;
                }
                ++n;
            }
        }
    }

    void enableMouseEvents() {
        Object[] objectArray = this.getViewPlatformList();
        this.enableMouse = true;
        if (objectArray != null) {
            int n = 0;
            while (n < objectArray.length) {
                ViewPlatformRetained viewPlatformRetained = (ViewPlatformRetained)objectArray[n];
                View[] viewArray = viewPlatformRetained.getViewList();
                int n2 = viewArray.length - 1;
                while (n2 >= 0) {
                    Enumeration enumeration = viewArray[n2].getAllCanvas3Ds();
                    while (enumeration.hasMoreElements()) {
                        Canvas3D canvas3D = (Canvas3D)enumeration.nextElement();
                        if (canvas3D.eventCatcher == null) continue;
                        canvas3D.eventCatcher.enableMouseEvents();
                    }
                    --n2;
                }
                ++n;
            }
        }
    }

    void enableMouseMotionEvents() {
        Object[] objectArray = this.getViewPlatformList();
        this.enableMouseMotion = true;
        if (objectArray != null) {
            int n = 0;
            while (n < objectArray.length) {
                ViewPlatformRetained viewPlatformRetained = (ViewPlatformRetained)objectArray[n];
                View[] viewArray = viewPlatformRetained.getViewList();
                int n2 = viewArray.length - 1;
                while (n2 >= 0) {
                    Enumeration enumeration = viewArray[n2].getAllCanvas3Ds();
                    while (enumeration.hasMoreElements()) {
                        Canvas3D canvas3D = (Canvas3D)enumeration.nextElement();
                        if (canvas3D.eventCatcher == null) continue;
                        canvas3D.eventCatcher.enableMouseMotionEvents();
                    }
                    --n2;
                }
                ++n;
            }
        }
    }

    public Enumeration getAllLocales() {
        return this.listOfLocales.elements();
    }

    final View getCurrentView() {
        return this.currentView;
    }

    public static int getJ3DThreadPriority() {
        return mc.getThreadPriority();
    }

    String getNodeId() {
        String string;
        if (this.nodeIdFreeList.size() == 0) {
            string = Long.toString(this.nodeIdCount);
            ++this.nodeIdCount;
        } else {
            string = (String)this.nodeIdFreeList.lastElement();
            this.nodeIdFreeList.removeElement(string);
        }
        return string;
    }

    static ThreadGroup getRootThreadGroup() {
        return rootThreadGroup;
    }

    Integer getViewId() {
        Integer n;
        ArrayList arrayList = this.viewIdFreeList;
        synchronized (arrayList) {
            int n2 = this.viewIdFreeList.size();
            n = n2 == 0 ? new Integer(this.viewIdCount++) : (Integer)this.viewIdFreeList.remove(n2 - 1);
        }
        return n;
    }

    synchronized Object[] getViewPlatformList() {
        if (this.vpChanged) {
            this.viewPlatformList = this.viewPlatforms.toArray();
            this.vpChanged = false;
        }
        return this.viewPlatformList;
    }

    boolean isEmpty() {
        Enumeration enumeration = this.listOfLocales.elements();
        while (enumeration.hasMoreElements()) {
            Locale locale = (Locale)enumeration.nextElement();
            if (locale.branchGroups.isEmpty()) continue;
            return false;
        }
        return true;
    }

    static void loadLibraries() {
    }

    public int numLocales() {
        return this.listOfLocales.size();
    }

    public void removeAllLocales() {
        int n = this.listOfLocales.size() - 1;
        while (n > 0) {
            ((Locale)this.listOfLocales.get(n)).removeFromUniverse();
            --n;
        }
        if (n >= 0) {
            Locale locale = (Locale)this.listOfLocales.get(0);
            this.listOfLocales.clear();
            locale.removeFromUniverse();
        }
        mc.postRequest(MasterControl.EMPTY_UNIVERSE, this);
    }

    public void removeLocale(Locale locale) {
        if (locale.getVirtualUniverse() != this) {
            throw new IllegalArgumentException(J3dI18N.getString("VirtualUniverse0"));
        }
        this.listOfLocales.removeElement(locale);
        locale.removeFromUniverse();
        if (this.isEmpty()) {
            mc.postRequest(MasterControl.EMPTY_UNIVERSE, this);
        }
    }

    void removeViewPlatform(ViewPlatformRetained viewPlatformRetained) {
        this.vpChanged = true;
        this.viewPlatforms.remove(this.viewPlatforms.indexOf(viewPlatformRetained));
    }

    final void setCurrentView(View view) {
        this.currentView = view;
    }

    public static void setJ3DThreadPriority(int n) {
        if (n > 10) {
            n = 10;
        } else if (n < 1) {
            n = 1;
        }
        mc.setThreadPriority(n);
    }
}

