/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.PhysicalBody;
import javax.media.j3d.PhysicalEnvironment;
import javax.media.j3d.Transform3D;
import javax.media.j3d.View;
import javax.media.j3d.ViewPlatform;
import javax.media.j3d.ViewPlatformRetained;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;

class ViewCache {
    View view;
    int viewAttachPolicy;
    Point3d leftEyePosInHead = new Point3d();
    Point3d rightEyePosInHead = new Point3d();
    Point3d leftEarPosInHead = new Point3d();
    Point3d rightEarPosInHead = new Point3d();
    double nominalEyeHeightFromGround;
    double nominalEyeOffsetFromNominalScreen;
    Transform3D headToHeadTracker = new Transform3D();
    Transform3D coexistenceToTrackerBase = new Transform3D();
    Transform3D headTrackerToTrackerBase = new Transform3D();
    Transform3D trackerBaseToHeadTracker = new Transform3D();
    boolean trackingAvailable;
    int headIndex;
    int coexistenceCenterInPworldPolicy;
    boolean compatibilityModeEnable;
    boolean coexistenceCenteringEnable;
    Point3d leftManualEyeInCoexistence = new Point3d();
    Point3d rightManualEyeInCoexistence = new Point3d();
    int viewPolicy;
    int projectionPolicy;
    int screenScalePolicy;
    double screenScale;
    int windowResizePolicy;
    int windowMovementPolicy;
    int windowEyepointPolicy;
    int monoscopicViewPolicy;
    double fieldOfView;
    double frontClipDistance;
    double backClipDistance;
    int frontClipPolicy;
    int backClipPolicy;
    ViewPlatformRetained vpRetained;
    int visibilityPolicy;
    boolean trackingEnable;
    boolean userHeadToVworldEnable;
    Transform3D compatVpcToEc = new Transform3D();
    Transform3D compatLeftProjection = new Transform3D();
    Transform3D compatRightProjection = new Transform3D();
    int vcDirtyMask = 0;
    private boolean doHeadTracking;
    Transform3D userHeadToVworld = new Transform3D();

    ViewCache(View view) {
        this.view = view;
    }

    synchronized void computeDerivedData() {
        if (this.doHeadTracking) {
            this.trackerBaseToHeadTracker.invert(this.headTrackerToTrackerBase);
        } else {
            this.trackerBaseToHeadTracker.setIdentity();
        }
        this.userHeadToVworld.setIdentity();
    }

    boolean getDoHeadTracking() {
        return this.doHeadTracking;
    }

    synchronized void snapshot() {
        this.vcDirtyMask = this.view.vDirtyMask;
        this.view.vDirtyMask = 0;
        this.compatibilityModeEnable = this.view.compatibilityModeEnable;
        this.coexistenceCenteringEnable = this.view.coexistenceCenteringEnable;
        this.leftManualEyeInCoexistence.set((Tuple3d)this.view.leftManualEyeInCoexistence);
        this.rightManualEyeInCoexistence.set((Tuple3d)this.view.rightManualEyeInCoexistence);
        this.viewPolicy = this.view.viewPolicy;
        this.projectionPolicy = this.view.projectionPolicy;
        this.screenScalePolicy = this.view.screenScalePolicy;
        this.windowResizePolicy = this.view.windowResizePolicy;
        this.windowMovementPolicy = this.view.windowMovementPolicy;
        this.windowEyepointPolicy = this.view.windowEyepointPolicy;
        this.monoscopicViewPolicy = this.view.monoscopicViewPolicy;
        this.fieldOfView = this.view.fieldOfView;
        this.screenScale = this.view.screenScale;
        this.frontClipDistance = this.view.frontClipDistance;
        this.backClipDistance = this.view.backClipDistance;
        this.frontClipPolicy = this.view.frontClipPolicy;
        this.backClipPolicy = this.view.backClipPolicy;
        this.visibilityPolicy = this.view.visibilityPolicy;
        this.trackingEnable = this.view.trackingEnable;
        this.userHeadToVworldEnable = this.view.userHeadToVworldEnable;
        this.view.compatVpcToEc.getWithLock(this.compatVpcToEc);
        this.view.compatLeftProjection.getWithLock(this.compatLeftProjection);
        this.view.compatRightProjection.getWithLock(this.compatRightProjection);
        ViewPlatform viewPlatform = this.view.getViewPlatform();
        if (viewPlatform == null) {
            return;
        }
        this.vpRetained = (ViewPlatformRetained)viewPlatform.retained;
        Object object = this.vpRetained;
        synchronized (object) {
            this.vcDirtyMask |= this.vpRetained.vprDirtyMask;
            this.vpRetained.vprDirtyMask = 0;
            this.viewAttachPolicy = this.vpRetained.viewAttachPolicy;
        }
        Object object2 = object = this.view.getPhysicalEnvironment();
        synchronized (object2) {
            this.vcDirtyMask |= ((PhysicalEnvironment)object).peDirtyMask;
            ((PhysicalEnvironment)object).peDirtyMask = 0;
            ((PhysicalEnvironment)object).coexistenceToTrackerBase.getWithLock(this.coexistenceToTrackerBase);
            this.trackingAvailable = ((PhysicalEnvironment)object).trackingAvailable;
            this.coexistenceCenterInPworldPolicy = ((PhysicalEnvironment)object).coexistenceCenterInPworldPolicy;
            boolean bl = this.doHeadTracking = this.trackingEnable && this.trackingAvailable;
            if (this.doHeadTracking) {
                this.headIndex = ((PhysicalEnvironment)object).getHeadIndex();
                ((PhysicalEnvironment)object).getSensor(this.headIndex).getRead(this.headTrackerToTrackerBase);
                this.vcDirtyMask |= 0x800;
            } else {
                this.headTrackerToTrackerBase.setIdentity();
            }
        }
        Object object3 = object2 = this.view.getPhysicalBody();
        synchronized (object3) {
            this.vcDirtyMask |= ((PhysicalBody)object2).pbDirtyMask;
            ((PhysicalBody)object2).pbDirtyMask = 0;
            this.leftEyePosInHead.set((Tuple3d)((PhysicalBody)object2).leftEyePosition);
            this.rightEyePosInHead.set((Tuple3d)((PhysicalBody)object2).rightEyePosition);
            this.leftEarPosInHead.set((Tuple3d)((PhysicalBody)object2).leftEarPosition);
            this.rightEarPosInHead.set((Tuple3d)((PhysicalBody)object2).rightEarPosition);
            this.nominalEyeHeightFromGround = ((PhysicalBody)object2).nominalEyeHeightFromGround;
            this.nominalEyeOffsetFromNominalScreen = ((PhysicalBody)object2).nominalEyeOffsetFromNominalScreen;
        }
        ((PhysicalBody)object2).headToHeadTracker.getWithLock(this.headToHeadTracker);
    }
}

