/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;

class UnorderList
implements Cloneable,
Serializable {
    transient Object[] elementData;
    transient Object[] cloneData;
    transient int cloneSize;
    transient boolean isDirty = true;
    Class componentType;
    int size;
    static /* synthetic */ Class class$java$lang$Object;

    UnorderList() {
        this(10, class$java$lang$Object != null ? class$java$lang$Object : (class$java$lang$Object = UnorderList.class$("java.lang.Object")));
    }

    UnorderList(int n) {
        this(n, class$java$lang$Object != null ? class$java$lang$Object : (class$java$lang$Object = UnorderList.class$("java.lang.Object")));
    }

    UnorderList(int n, Class clazz) {
        this.componentType = clazz;
        this.elementData = (Object[])Array.newInstance(clazz, n);
    }

    UnorderList(Class clazz) {
        this(10, clazz);
    }

    final synchronized void add(Object object) {
        if (this.elementData.length == this.size) {
            Object[] objectArray = this.elementData;
            this.elementData = (Object[])Array.newInstance(this.componentType, this.size << 1);
            System.arraycopy(objectArray, 0, this.elementData, 0, this.size);
        }
        this.elementData[this.size++] = object;
        this.isDirty = true;
    }

    final synchronized boolean addUnique(Object object) {
        if (!this.contains(object)) {
            this.add(object);
            return true;
        }
        return false;
    }

    final int arraySize() {
        return this.cloneSize;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    final synchronized void clear() {
        int n = this.size - 1;
        while (n >= 0) {
            this.elementData[n] = null;
            --n;
        }
        this.size = 0;
        this.isDirty = true;
    }

    final synchronized void clearMirror() {
        if (this.cloneData != null) {
            int n = this.cloneData.length - 1;
            while (n >= 0) {
                this.cloneData[n] = null;
                --n;
            }
        }
        this.cloneSize = 0;
        this.isDirty = true;
    }

    protected final synchronized Object clone() {
        try {
            UnorderList unorderList = (UnorderList)super.clone();
            unorderList.elementData = (Object[])Array.newInstance(this.componentType, this.size);
            System.arraycopy(this.elementData, 0, unorderList.elementData, 0, this.size);
            this.isDirty = true;
            return unorderList;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    final synchronized boolean contains(Object object) {
        if (object != null) {
            int n = this.size - 1;
            while (n >= 0) {
                if (object.equals(this.elementData[n])) {
                    return true;
                }
                --n;
            }
        } else {
            int n = this.size - 1;
            while (n >= 0) {
                if (this.elementData[n] == null) {
                    return true;
                }
                --n;
            }
        }
        return false;
    }

    final synchronized Object get(int n) {
        return this.elementData[n];
    }

    final Class getComponentType() {
        return this.componentType;
    }

    final synchronized int indexOf(Object object) {
        if (object != null) {
            int n = this.size - 1;
            while (n >= 0) {
                if (object.equals(this.elementData[n])) {
                    return n;
                }
                --n;
            }
        } else {
            int n = this.size - 1;
            while (n >= 0) {
                if (this.elementData[n] == null) {
                    return n;
                }
                --n;
            }
        }
        return -1;
    }

    final boolean isEmpty() {
        return this.size == 0;
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.elementData = (Object[])Array.newInstance(this.componentType, n);
        int n2 = 0;
        while (n2 < this.size) {
            this.elementData[n2] = objectInputStream.readObject();
            ++n2;
        }
    }

    final synchronized void remove(int n) {
        this.elementData[n] = this.elementData[--this.size];
        this.elementData[this.size] = null;
        this.isDirty = true;
    }

    final synchronized boolean remove(Object object) {
        --this.size;
        if (object != null) {
            int n = this.size;
            while (n >= 0) {
                if (object.equals(this.elementData[n])) {
                    this.elementData[n] = this.elementData[this.size];
                    this.elementData[this.size] = null;
                    this.isDirty = true;
                    return true;
                }
                --n;
            }
        } else {
            int n = this.size;
            while (n >= 0) {
                if (this.elementData[n] == null) {
                    this.elementData[n] = this.elementData[this.size];
                    this.elementData[this.size] = null;
                    this.isDirty = true;
                    return true;
                }
                --n;
            }
        }
        ++this.size;
        return false;
    }

    final synchronized Object removeLastElement() {
        Object object = this.elementData[--this.size];
        this.elementData[this.size] = null;
        this.isDirty = true;
        return object;
    }

    final synchronized void set(int n, Object object) {
        this.elementData[n] = object;
        this.isDirty = true;
    }

    final int size() {
        return this.size;
    }

    final synchronized Object[] toArray() {
        return this.toArray(true);
    }

    final Object[] toArray(Object object) {
        int n = this.indexOf(object);
        if (n < 0) {
            return (Object[])Array.newInstance(this.componentType, 0);
        }
        int n2 = this.size - n;
        Object[] objectArray = (Object[])Array.newInstance(this.componentType, n2);
        System.arraycopy(this.elementData, n, objectArray, 0, n2);
        return objectArray;
    }

    final synchronized Object[] toArray(boolean bl) {
        if (bl) {
            if (this.isDirty) {
                if (this.cloneData == null || this.cloneData.length < this.size) {
                    this.cloneData = (Object[])Array.newInstance(this.componentType, this.size);
                }
                System.arraycopy(this.elementData, 0, this.cloneData, 0, this.size);
                this.cloneSize = this.size;
                this.isDirty = false;
            }
            return this.cloneData;
        }
        this.cloneSize = this.size;
        return this.elementData;
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer("Size = " + this.size + "\n[");
        int n = this.size - 1;
        int n2 = 0;
        while (n2 < this.size) {
            Object object = this.elementData[n2];
            if (object != null) {
                stringBuffer.append(this.elementData[n2].toString());
            } else {
                stringBuffer.append("NULL");
            }
            if (n2 != n) {
                stringBuffer.append(", ");
            }
            ++n2;
        }
        stringBuffer.append("]\n");
        return stringBuffer.toString();
    }

    final synchronized void trimToSize() {
        if (this.elementData.length > this.size) {
            Object[] objectArray = this.elementData;
            this.elementData = (Object[])Array.newInstance(this.componentType, this.size);
            System.arraycopy(objectArray, 0, this.elementData, 0, this.size);
        }
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.elementData.length);
        int n = 0;
        while (n < this.size) {
            objectOutputStream.writeObject(this.elementData[n]);
            ++n;
        }
    }
}

