/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.BoundingBox;
import javax.media.j3d.BoundingPolytope;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.GeometryArrayRetained;
import javax.media.j3d.GeometryRetained;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.PickBounds;
import javax.media.j3d.PickCone;
import javax.media.j3d.PickCylinder;
import javax.media.j3d.PickPoint;
import javax.media.j3d.PickRay;
import javax.media.j3d.PickSegment;
import javax.media.j3d.PickShape;
import javax.media.j3d.Transform3D;
import javax.vecmath.Point3d;

class TriangleArrayRetained
extends GeometryArrayRetained {
    TriangleArrayRetained() {
        this.geoType = 2;
    }

    boolean intersect(Transform3D transform3D, Bounds bounds) {
        int n = 0;
        Point3d[] point3dArray = new Point3d[3];
        int n2 = 0;
        while (n2 < 3) {
            point3dArray[n2] = new Point3d();
            ++n2;
        }
        if (bounds instanceof BoundingBox) {
            n = 1;
        } else if (bounds instanceof BoundingSphere) {
            n = 2;
        }
        n2 = 0;
        while (n2 < this.vertexCount) {
            int n3 = n2;
            while (n3 < n2 + 3) {
                int n4 = this.stride * n3 + this.coordinateOffset;
                int n5 = n3 - n2;
                point3dArray[n5].x = this.vertexData[n4];
                point3dArray[n5].y = this.vertexData[n4 + 1];
                point3dArray[n5].z = this.vertexData[n4 + 2];
                transform3D.transform(point3dArray[n5], point3dArray[n5]);
                ++n3;
            }
            switch (n) {
                case 0: {
                    if (!this.intersectBoundingPolytope(point3dArray, (BoundingPolytope)bounds)) break;
                    return true;
                }
                case 1: {
                    if (!this.intersectBoundingBox(point3dArray, (BoundingBox)bounds)) break;
                    return true;
                }
                case 2: {
                    if (!this.intersectBoundingSphere(point3dArray, (BoundingSphere)bounds)) break;
                    return true;
                }
            }
            n2 += 3;
        }
        return false;
    }

    boolean intersect(Transform3D transform3D, PickRay pickRay, double[] dArray) {
        double[] dArray2 = new double[1];
        boolean bl = false;
        Point3d[] point3dArray = new Point3d[3];
        int n = 0;
        while (n < 3) {
            point3dArray[n] = new Point3d();
            ++n;
        }
        dArray[0] = Double.MAX_VALUE;
        n = 0;
        while (n < this.vertexCount) {
            int n2 = n;
            while (n2 < n + 3) {
                int n3 = this.stride * n2 + this.coordinateOffset;
                int n4 = n2 - n;
                point3dArray[n4].x = this.vertexData[n3];
                point3dArray[n4].y = this.vertexData[n3 + 1];
                point3dArray[n4].z = this.vertexData[n3 + 2];
                transform3D.transform(point3dArray[n4], point3dArray[n4]);
                ++n2;
            }
            if (this.intersectRay(point3dArray, pickRay, dArray2)) {
                bl = true;
                if (dArray2[0] < dArray[0]) {
                    dArray[0] = dArray2[0];
                }
            }
            n += 3;
        }
        return bl;
    }

    boolean intersect(Transform3D transform3D, PickShape pickShape) {
        int n = 0;
        boolean bl = true;
        double[] dArray = new double[1];
        Bounds bounds = null;
        Point3d[] point3dArray = new Point3d[3];
        if (pickShape instanceof PickRay) {
            n = 1;
        } else if (pickShape instanceof PickSegment) {
            n = 2;
        } else if (pickShape instanceof PickBounds) {
            bounds = ((PickBounds)pickShape).bounds;
            if (bounds instanceof BoundingBox) {
                n = 4;
            } else if (bounds instanceof BoundingSphere) {
                n = 5;
            } else if (bounds instanceof BoundingPolytope) {
                n = 6;
            }
        } else {
            if (pickShape instanceof PickPoint) {
                throw new IllegalArgumentException(J3dI18N.getString("TriangleArrayRetained0"));
            }
            if (pickShape instanceof PickCylinder) {
                n = 7;
            } else if (pickShape instanceof PickCone) {
                n = 8;
            } else {
                throw new RuntimeException("PickShape not supported for intersection");
            }
        }
        int n2 = 0;
        while (n2 < 3) {
            point3dArray[n2] = new Point3d();
            ++n2;
        }
        n2 = 0;
        while (n2 < this.vertexCount) {
            int n3 = n2;
            while (n3 < n2 + 3) {
                int n4 = this.stride * n3 + this.coordinateOffset;
                int n5 = n3 - n2;
                point3dArray[n5].x = this.vertexData[n4];
                point3dArray[n5].y = this.vertexData[n4 + 1];
                point3dArray[n5].z = this.vertexData[n4 + 2];
                transform3D.transform(point3dArray[n5], point3dArray[n5]);
                ++n3;
            }
            switch (n) {
                case 1: {
                    if (!this.intersectRay(point3dArray, (PickRay)pickShape, dArray)) break;
                    return true;
                }
                case 2: {
                    if (!this.intersectSegment(point3dArray, (PickSegment)pickShape, dArray)) break;
                    return true;
                }
                case 4: {
                    if (!this.intersectBoundingBox(point3dArray, (BoundingBox)((PickBounds)pickShape).bounds)) break;
                    return true;
                }
                case 5: {
                    if (!this.intersectBoundingSphere(point3dArray, (BoundingSphere)((PickBounds)pickShape).bounds)) break;
                    return true;
                }
                case 6: {
                    if (!this.intersectBoundingPolytope(point3dArray, (BoundingPolytope)((PickBounds)pickShape).bounds)) break;
                    return true;
                }
                case 7: {
                    if (!this.intersectCylinder(point3dArray, (PickCylinder)pickShape, dArray)) break;
                    return true;
                }
                case 8: {
                    if (!this.intersectCone(point3dArray, (PickCone)pickShape, dArray)) break;
                    return true;
                }
            }
            n2 += 3;
        }
        return n == 3;
    }

    boolean intersect(Transform3D transform3D, Transform3D transform3D2, GeometryRetained geometryRetained) {
        Point3d[] point3dArray = new Point3d[3];
        int n = 0;
        while (n < 3) {
            point3dArray[n] = new Point3d();
            ++n;
        }
        n = 0;
        while (n < this.vertexCount) {
            int n2 = n;
            while (n2 < n + 3) {
                int n3 = this.stride * n2 + this.coordinateOffset;
                int n4 = n2 - n;
                point3dArray[n4].x = this.vertexData[n3];
                point3dArray[n4].y = this.vertexData[n3 + 1];
                point3dArray[n4].z = this.vertexData[n3 + 2];
                transform3D.transform(point3dArray[n4], point3dArray[n4]);
                ++n2;
            }
            if (geometryRetained.intersect(transform3D2, point3dArray)) {
                return true;
            }
            n += 3;
        }
        return false;
    }

    boolean intersect(Transform3D transform3D, Point3d[] point3dArray) {
        Point3d[] point3dArray2 = new Point3d[3];
        int n = 0;
        while (n < 3) {
            point3dArray2[n] = new Point3d();
            ++n;
        }
        n = 0;
        while (n < this.vertexCount) {
            int n2 = n;
            while (n2 < n + 3) {
                int n3 = this.stride * n2 + this.coordinateOffset;
                int n4 = n2 - n;
                point3dArray2[n4].x = this.vertexData[n3];
                point3dArray2[n4].y = this.vertexData[n3 + 1];
                point3dArray2[n4].z = this.vertexData[n3 + 2];
                transform3D.transform(point3dArray2[n4], point3dArray2[n4]);
                ++n2;
            }
            if (point3dArray.length == 1) {
                return false;
            }
            if (this.intersectPolygon(point3dArray2, point3dArray, true)) {
                return true;
            }
            n += 3;
        }
        return false;
    }
}

