/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.Enumeration;
import javax.media.j3d.Alpha;
import javax.media.j3d.Interpolator;
import javax.media.j3d.Node;
import javax.media.j3d.NodeReferenceTable;
import javax.media.j3d.TransparencyAttributes;

public class TransparencyInterpolator
extends Interpolator {
    TransparencyAttributes target;
    float minimumTransparency;
    float maximumTransparency;

    TransparencyInterpolator() {
    }

    public TransparencyInterpolator(Alpha alpha, TransparencyAttributes transparencyAttributes) {
        super(alpha);
        this.target = transparencyAttributes;
        this.minimumTransparency = 0.0f;
        this.maximumTransparency = 1.0f;
    }

    public TransparencyInterpolator(Alpha alpha, TransparencyAttributes transparencyAttributes, float f, float f2) {
        super(alpha);
        this.target = transparencyAttributes;
        this.minimumTransparency = f;
        this.maximumTransparency = f2;
    }

    public Node cloneNode(boolean bl) {
        TransparencyInterpolator transparencyInterpolator = new TransparencyInterpolator();
        transparencyInterpolator.duplicateNode(this, bl);
        return transparencyInterpolator;
    }

    void duplicateAttributes(Node node, boolean bl) {
        super.duplicateAttributes(node, bl);
        TransparencyInterpolator transparencyInterpolator = (TransparencyInterpolator)node;
        this.setMinimumTransparency(transparencyInterpolator.getMinimumTransparency());
        this.setMaximumTransparency(transparencyInterpolator.getMaximumTransparency());
        this.setTarget(transparencyInterpolator.getTarget());
    }

    public float getMaximumTransparency() {
        return this.maximumTransparency;
    }

    public float getMinimumTransparency() {
        return this.minimumTransparency;
    }

    public TransparencyAttributes getTarget() {
        return this.target;
    }

    public void processStimulus(Enumeration enumeration) {
        if (this.alpha != null) {
            float f = this.alpha.value();
            float f2 = (float)((1.0 - (double)f) * (double)this.minimumTransparency + (double)(f * this.maximumTransparency));
            this.target.setTransparency(f2);
        }
        this.wakeupOn(this.defaultWakeupCriterion);
    }

    public void setMaximumTransparency(float f) {
        this.maximumTransparency = f;
    }

    public void setMinimumTransparency(float f) {
        this.minimumTransparency = f;
    }

    public void setTarget(TransparencyAttributes transparencyAttributes) {
        this.target = transparencyAttributes;
    }

    public void updateNodeReferences(NodeReferenceTable nodeReferenceTable) {
        super.updateNodeReferences(nodeReferenceTable);
        TransparencyAttributes transparencyAttributes = this.getTarget();
        if (transparencyAttributes != null) {
            this.setTarget((TransparencyAttributes)nodeReferenceTable.getNewObjectReference(transparencyAttributes));
        }
    }
}

