/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.AbstractCollection;
import java.util.ArrayList;
import javax.media.j3d.BadTransformException;
import javax.media.j3d.BoundingLeafRetained;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.GroupRetained;
import javax.media.j3d.HashKey;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.LinkRetained;
import javax.media.j3d.NodeRetained;
import javax.media.j3d.SetLiveState;
import javax.media.j3d.SharedGroupRetained;
import javax.media.j3d.Transform3D;
import javax.media.j3d.ViewPlatformRetained;
import javax.media.j3d.VirtualUniverse;
import javax.media.j3d.WakeupOnTransformChange;

class TransformGroupRetained
extends GroupRetained {
    Transform3D transform = new Transform3D();
    Transform3D currentTransform = new Transform3D();
    Transform3D[] currentChildLocalToVworld = null;
    Transform3D[] lastChildLocalToVworld = null;
    Transform3D[] currentChildTrans = null;
    Transform3D[] lastChildTrans = null;
    Object[] targets = null;
    int targetThreads = 0;
    ArrayList transformChange = null;
    boolean[] isDirty = null;
    int boundingLeafTargetStartIndex = 0;
    ArrayList childTransformLinks = new ArrayList(1);
    HashKey currentKey = new HashKey();
    boolean aboveAViewPlatform = false;

    TransformGroupRetained() {
        this.nodeType = 24;
    }

    synchronized void addCondition(WakeupOnTransformChange wakeupOnTransformChange) {
        this.transformChange.add(wakeupOnTransformChange);
    }

    void clearLive(SetLiveState setLiveState) {
        super.clearLive(setLiveState);
        if (!this.inSharedGroup || this.localToVworldKeys == null) {
            ArrayList arrayList;
            if (this.parentTransformLink != null) {
                arrayList = this.parentTransformLink instanceof TransformGroupRetained ? ((TransformGroupRetained)this.parentTransformLink).childTransformLinks : ((SharedGroupRetained)this.parentTransformLink).childTransformLinks;
                ArrayList arrayList2 = arrayList;
                synchronized (arrayList2) {
                    ((AbstractCollection)arrayList).remove(this);
                }
            }
            arrayList = this.childTransformLinks;
            synchronized (arrayList) {
                this.childTransformLinks.clear();
            }
            this.parentTransformLink = null;
            this.aboveAViewPlatform = false;
        }
    }

    void computeCombineBounds(Bounds bounds) {
        BoundingSphere boundingSphere = new BoundingSphere();
        boundingSphere.setRadius(-1.0);
        if (this.boundsAutoCompute) {
            int n = this.children.size() - 1;
            while (n >= 0) {
                NodeRetained nodeRetained = (NodeRetained)this.children.elementAt(n);
                if (nodeRetained != null) {
                    nodeRetained.computeCombineBounds(boundingSphere);
                }
                --n;
            }
        } else {
            Bounds bounds2 = this.localBounds;
            synchronized (bounds2) {
                boundingSphere.set(this.localBounds);
            }
        }
        Transform3D transform3D = this.transform;
        synchronized (transform3D) {
            boundingSphere.transform(this.transform);
        }
        bounds.combine(boundingSphere);
    }

    void getTransform(Transform3D transform3D) {
        this.transform.getWithLock(transform3D);
    }

    synchronized void notifyConditions() {
        int n = 0;
        while (n < this.transformChange.size()) {
            ((WakeupOnTransformChange)this.transformChange.get(n)).setTriggered();
            ++n;
        }
    }

    synchronized void removeCondition(WakeupOnTransformChange wakeupOnTransformChange) {
        this.transformChange.remove(this.transformChange.indexOf(wakeupOnTransformChange));
    }

    void setLive(SetLiveState setLiveState) {
        int n;
        int n2;
        Transform3D transform3D = null;
        Transform3D[] transform3DArray = null;
        Transform3D[] transform3DArray2 = null;
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = null;
        ArrayList arrayList4 = null;
        int n3 = 0;
        ArrayList arrayList5 = null;
        GroupRetained groupRetained = null;
        arrayList3 = setLiveState.transformTargets;
        arrayList4 = setLiveState.transformBLTargets;
        n3 = setLiveState.transformTargetThreads;
        setLiveState.transformTargets = arrayList;
        setLiveState.transformBLTargets = arrayList2;
        setLiveState.transformTargetThreads = 0;
        this.inSharedGroup = setLiveState.inSharedGroup;
        transform3D = VirtualUniverse.mc.getTransform3D(null);
        this.transform.getWithLock(transform3D);
        this.currentTransform.set(transform3D);
        Cloneable cloneable = this;
        synchronized (cloneable) {
            this.currentChildTrans = new Transform3D[setLiveState.currentTransforms.length];
            this.lastChildTrans = new Transform3D[setLiveState.lastTransforms.length];
            n2 = 0;
            while (n2 < setLiveState.currentTransforms.length) {
                this.currentChildTrans[n2] = new Transform3D();
                this.lastChildTrans[n2] = new Transform3D();
                this.currentChildTrans[n2].mul(setLiveState.currentTransforms[n2], transform3D);
                this.lastChildTrans[n2].set(this.currentChildTrans[n2]);
                ++n2;
            }
            n2 = 0;
            while (n2 < setLiveState.parentTransformGroups.length) {
                setLiveState.parentTransformGroups[n2].add(this);
                ++n2;
            }
            if (!setLiveState.inSharedGroup) {
                this.setLocalToVworld(setLiveState.currentTransforms[0], setLiveState.lastTransforms[0], setLiveState.parentTransformGroups[0], this.currentChildTrans[0], this.lastChildTrans[0], null, setLiveState.branchGroupPaths.get(0));
            } else {
                n2 = 0;
                while (n2 < setLiveState.keys.length) {
                    this.setLocalToVworld(setLiveState.currentTransforms[n2], setLiveState.lastTransforms[n2], setLiveState.parentTransformGroups[n2], this.currentChildTrans[n2], this.lastChildTrans[n2], setLiveState.keys[n2], setLiveState.branchGroupPaths.get(n2));
                    ++n2;
                }
            }
        }
        arrayList5 = setLiveState.childTransformLinks;
        groupRetained = setLiveState.parentTransformLink;
        transform3DArray = setLiveState.currentTransforms;
        transform3DArray2 = setLiveState.lastTransforms;
        setLiveState.childTransformLinks = this.childTransformLinks;
        setLiveState.parentTransformLink = this;
        setLiveState.currentTransforms = this.currentChildTrans;
        setLiveState.lastTransforms = this.lastChildTrans;
        super.doSetLive(setLiveState);
        if (arrayList5 != null) {
            cloneable = arrayList5;
            synchronized (cloneable) {
                if (!this.inSharedGroup || !arrayList5.contains(this)) {
                    arrayList5.add(this);
                }
            }
        }
        setLiveState.childTransformLinks = arrayList5;
        this.parentTransformLink = setLiveState.parentTransformLink = groupRetained;
        n2 = 0;
        while (n2 < setLiveState.parentTransformGroups.length) {
            ((AbstractCollection)setLiveState.parentTransformGroups[n2]).remove(this);
            ++n2;
        }
        setLiveState.currentTransforms = transform3DArray;
        setLiveState.lastTransforms = transform3DArray2;
        this.targetThreads = setLiveState.transformTargetThreads | 0x2000 | 0x100;
        setLiveState.transformTargets = arrayList3;
        if (arrayList3 != null) {
            setLiveState.transformTargetThreads |= n3;
            n = arrayList.size();
            n2 = 0;
            while (n2 < n) {
                setLiveState.transformTargets.add(arrayList.get(n2));
                ++n2;
            }
        }
        setLiveState.transformBLTargets = arrayList4;
        if (arrayList4 != null) {
            n = arrayList2.size();
            n2 = 0;
            while (n2 < n) {
                setLiveState.transformBLTargets.add(arrayList2.get(n2));
                ++n2;
            }
        }
        n = arrayList.size();
        this.targets = new Object[n + arrayList2.size()];
        n2 = 0;
        while (n2 < n) {
            this.targets[n2] = arrayList.get(n2);
            if (this.targets[n2] instanceof ViewPlatformRetained) {
                this.aboveAViewPlatform = true;
            }
            ++n2;
        }
        if (this.aboveAViewPlatform && (transform3D.getType() & 0x40) == 0) {
            throw new BadTransformException(J3dI18N.getString("ViewPlatformRetained0"));
        }
        this.boundingLeafTargetStartIndex = n;
        n = arrayList2.size();
        n2 = 0;
        while (n2 < n) {
            this.targets[this.boundingLeafTargetStartIndex + n2] = arrayList2.get(n2);
            ++n2;
        }
        super.markAsLive();
    }

    void setTransform(Transform3D transform3D) {
        J3dMessage j3dMessage = null;
        Transform3D transform3D2 = null;
        this.transform.setWithLock(transform3D);
        if (this.transformChange != null) {
            this.notifyConditions();
        }
        if (this.source.isLive()) {
            int n;
            if (this.aboveAViewPlatform && (transform3D.getType() & 0x40) == 0) {
                throw new BadTransformException(J3dI18N.getString("ViewPlatformRetained0"));
            }
            transform3D2 = VirtualUniverse.mc.getTransform3D(this.transform);
            if (this.targets.length > this.boundingLeafTargetStartIndex) {
                n = this.boundingLeafTargetStartIndex;
                while (n < this.targets.length) {
                    this.targetThreads |= ((BoundingLeafRetained)this.targets[n]).transformTargetThreads;
                    ++n;
                }
            }
            j3dMessage = VirtualUniverse.mc.getMessage();
            j3dMessage.type = 3;
            j3dMessage.threads = this.targetThreads;
            j3dMessage.args[0] = this.targets;
            j3dMessage.args[1] = this;
            j3dMessage.args[2] = transform3D2;
            if (this.boundingLeafTargetStartIndex < this.targets.length) {
                ArrayList arrayList = new ArrayList();
                n = this.boundingLeafTargetStartIndex;
                while (n < this.targets.length) {
                    ArrayList arrayList2;
                    ArrayList arrayList3 = arrayList2 = ((BoundingLeafRetained)this.targets[n]).users;
                    synchronized (arrayList3) {
                        int n2 = 0;
                        while (n2 < arrayList2.size()) {
                            arrayList.add(arrayList2.get(n2));
                            ++n2;
                        }
                    }
                    ++n;
                }
                j3dMessage.args[3] = arrayList;
            } else {
                j3dMessage.args[3] = null;
            }
            j3dMessage.universe = this.universe;
            VirtualUniverse.mc.processMessage(j3dMessage);
        }
    }

    void updateChildLocalToVworld(ArrayList arrayList, ArrayList arrayList2) {
        block13: {
            block14: {
                if (this.currentLocalToVworld == null) break block13;
                if (!this.inSharedGroup) break block14;
                if (this.localToVworldKeys == null) break block13;
                int n = 0;
                while (n < this.localToVworldKeys.length) {
                    this.updateChildLocalToVworld(this.localToVworldKeys[n], n, arrayList, arrayList2);
                    ++n;
                }
                break block13;
            }
            arrayList.add(this);
            Cloneable cloneable = this;
            synchronized (cloneable) {
                Transform3D transform3D = this.currentLocalToVworld[0];
                Transform3D transform3D2 = this.currentChildLocalToVworld[0];
                transform3D2.mul(transform3D, this.currentTransform);
            }
            cloneable = this.childTransformLinks;
            synchronized (cloneable) {
                int n = 0;
                while (n < this.childTransformLinks.size()) {
                    Object e = this.childTransformLinks.get(n);
                    if (e instanceof TransformGroupRetained) {
                        TransformGroupRetained transformGroupRetained = (TransformGroupRetained)e;
                        transformGroupRetained.updateChildLocalToVworld(arrayList, arrayList2);
                    } else {
                        LinkRetained linkRetained = (LinkRetained)e;
                        this.currentKey.reset();
                        this.currentKey.append(this.locale.nodeId);
                        this.currentKey.append(LinkRetained.plus).append(linkRetained.nodeId);
                        if (linkRetained.sharedGroup.localToVworldKeys != null) {
                            int n2 = 0;
                            while (n2 < linkRetained.sharedGroup.localToVworldKeys.length) {
                                if (linkRetained.sharedGroup.localToVworldKeys[n2].equals(this.currentKey)) break;
                                ++n2;
                            }
                            if (n2 < linkRetained.sharedGroup.localToVworldKeys.length) {
                                linkRetained.sharedGroup.updateChildLocalToVworld(linkRetained.sharedGroup.localToVworldKeys[n2], n2, arrayList, arrayList2);
                            }
                        }
                    }
                    ++n;
                }
            }
        }
    }

    void updateChildLocalToVworld(HashKey hashKey, int n, ArrayList arrayList, ArrayList arrayList2) {
        if (this.currentLocalToVworld != null) {
            arrayList.add(this);
            arrayList2.add(hashKey);
            Cloneable cloneable = this;
            synchronized (cloneable) {
                Transform3D transform3D = this.currentLocalToVworld[n];
                Transform3D transform3D2 = this.currentChildLocalToVworld[n];
                transform3D2.mul(transform3D, this.currentTransform);
            }
            cloneable = this.childTransformLinks;
            synchronized (cloneable) {
                int n2 = 0;
                while (n2 < this.childTransformLinks.size()) {
                    Object e = this.childTransformLinks.get(n2);
                    if (e instanceof TransformGroupRetained) {
                        TransformGroupRetained transformGroupRetained = (TransformGroupRetained)e;
                        transformGroupRetained.updateChildLocalToVworld(transformGroupRetained.localToVworldKeys[n], n, arrayList, arrayList2);
                    } else {
                        LinkRetained linkRetained = (LinkRetained)e;
                        this.currentKey.set(this.localToVworldKeys[n]);
                        this.currentKey.append(LinkRetained.plus).append(linkRetained.nodeId);
                        if (linkRetained.sharedGroup.localToVworldKeys != null) {
                            int n3 = 0;
                            while (n3 < linkRetained.sharedGroup.localToVworldKeys.length) {
                                if (linkRetained.sharedGroup.localToVworldKeys[n3].equals(this.currentKey)) break;
                                ++n3;
                            }
                            if (n3 < linkRetained.sharedGroup.localToVworldKeys.length) {
                                linkRetained.sharedGroup.updateChildLocalToVworld(linkRetained.sharedGroup.localToVworldKeys[n3], n3, arrayList, arrayList2);
                            }
                        }
                    }
                    ++n2;
                }
            }
        }
    }

    final void updateTargets(ArrayList arrayList, ArrayList arrayList2) {
        this.updateTargets(arrayList, arrayList2, null, null, 0);
    }

    void updateTargets(ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3, ArrayList arrayList4, int n) {
        int n2;
        Object object;
        int n3 = 0;
        if (this.targets == null) {
            int n4 = 0;
            if (arrayList2 != null) {
                n4 = arrayList2.size();
            }
            if (arrayList4 != null) {
                n4 += arrayList4.size();
            }
            if (n4 == 0) {
                return;
            }
            Object[] objectArray = new Object[n4];
            if (arrayList2 != null) {
                int n5 = arrayList2.size();
                n3 = 0;
                while (n3 < n5) {
                    objectArray[n3] = arrayList2.get(n3);
                    ++n3;
                }
            }
            this.boundingLeafTargetStartIndex = n3;
            if (arrayList4 != null) {
                n3 = this.boundingLeafTargetStartIndex;
                while (n3 < n4) {
                    objectArray[n3] = arrayList4.get(n3);
                    ++n3;
                }
            }
            this.targets = objectArray;
            this.targetThreads = n;
            return;
        }
        ArrayList<Object> arrayList5 = new ArrayList<Object>();
        this.targetThreads |= n;
        if (arrayList != null) {
            n3 = 0;
            while (n3 < this.boundingLeafTargetStartIndex) {
                object = this.targets[n3];
                if (!arrayList.contains(object)) {
                    arrayList5.add(object);
                }
                ++n3;
            }
        } else {
            n3 = 0;
            while (n3 < this.boundingLeafTargetStartIndex) {
                arrayList5.add(this.targets[n3]);
                ++n3;
            }
        }
        if (arrayList2 != null) {
            n2 = arrayList2.size();
            n3 = 0;
            while (n3 < n2) {
                arrayList5.add(arrayList2.get(n3));
                ++n3;
            }
        }
        int n6 = arrayList5.size();
        if (arrayList3 != null) {
            n3 = this.boundingLeafTargetStartIndex;
            while (n3 < this.targets.length) {
                object = this.targets[n3];
                if (!arrayList3.contains(object)) {
                    arrayList5.add(object);
                }
                ++n3;
            }
        }
        if (arrayList4 != null) {
            n2 = arrayList4.size();
            n3 = 0;
            while (n3 < n2) {
                arrayList5.add(arrayList4.get(n3));
                ++n3;
            }
        }
        this.boundingLeafTargetStartIndex = n6;
        this.targets = arrayList5.toArray();
    }
}

