/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.BitSet;
import javax.media.j3d.HashKey;
import javax.media.j3d.SceneGraphObject;
import javax.media.j3d.SetLiveState;
import javax.media.j3d.VirtualUniverse;

abstract class SceneGraphObjectRetained
implements Cloneable {
    SceneGraphObject source;
    boolean inBackgroundGroup = false;
    boolean onUpdateList = false;
    static final BitSet emptyBitSet = new BitSet();
    boolean inSetLive = false;

    SceneGraphObjectRetained() {
    }

    void clearLive() {
        this.inBackgroundGroup = false;
        this.source.clearLive();
    }

    void clearLive(VirtualUniverse virtualUniverse, int n, boolean bl, HashKey[] hashKeyArray) {
        this.inBackgroundGroup = false;
        this.source.clearLive();
    }

    protected Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    void doSetLive(SetLiveState setLiveState) {
        this.inSetLive = true;
        this.inBackgroundGroup = setLiveState.inBackgroundGroup;
    }

    void doSetLive(boolean bl) {
        this.inSetLive = true;
        this.inBackgroundGroup = bl;
    }

    SceneGraphObject getSource() {
        return this.source;
    }

    boolean isInSetLive() {
        return this.inSetLive;
    }

    boolean isStatic() {
        return this.source.capabilities.equals(emptyBitSet);
    }

    void markAsLive() {
        this.source.setLive();
        this.inSetLive = false;
    }

    void setCompiled() {
        this.source.setCompiled();
    }

    void setLive(SetLiveState setLiveState) {
        this.doSetLive(setLiveState);
        this.markAsLive();
    }

    void setLive(boolean bl) {
        this.doSetLive(bl);
        this.markAsLive();
    }

    void setSource(SceneGraphObject sceneGraphObject) {
        this.source = sceneGraphObject;
    }
}

