/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.Enumeration;
import javax.media.j3d.Alpha;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.Node;
import javax.media.j3d.NodeReferenceTable;
import javax.media.j3d.PathInterpolator;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Quat4f;
import javax.vecmath.Tuple4f;

public class RotationPathInterpolator
extends PathInterpolator {
    private TransformGroup target;
    private Transform3D axis = new Transform3D();
    private Transform3D axisInverse = new Transform3D();
    private Transform3D rotation = new Transform3D();
    private Transform3D temp = new Transform3D();
    private Quat4f tQuat = new Quat4f();
    private Quat4f[] quats;

    RotationPathInterpolator() {
    }

    public RotationPathInterpolator(Alpha alpha, TransformGroup transformGroup, Transform3D transform3D, float[] fArray, Quat4f[] quat4fArray) {
        super(alpha, fArray);
        if (fArray.length != quat4fArray.length) {
            throw new IllegalArgumentException(J3dI18N.getString("RotationPathInterpolator0"));
        }
        this.target = transformGroup;
        this.axis.set(transform3D);
        this.axisInverse.invert(this.axis);
        this.setPathArrays(quat4fArray);
    }

    public Node cloneNode(boolean bl) {
        RotationPathInterpolator rotationPathInterpolator = new RotationPathInterpolator();
        rotationPathInterpolator.duplicateNode(this, bl);
        return rotationPathInterpolator;
    }

    void duplicateAttributes(Node node, boolean bl) {
        super.duplicateAttributes(node, bl);
        RotationPathInterpolator rotationPathInterpolator = (RotationPathInterpolator)node;
        this.setAxisOfRotation(rotationPathInterpolator.getAxisOfRotation());
        int n = rotationPathInterpolator.getArrayLengths();
        this.quats = new Quat4f[n];
        Quat4f quat4f = new Quat4f();
        int n2 = 0;
        while (n2 < n) {
            this.quats[n2] = new Quat4f();
            rotationPathInterpolator.getQuat(n2, quat4f);
            this.setQuat(n2, quat4f);
            ++n2;
        }
        this.setTarget(rotationPathInterpolator.getTarget());
    }

    public Transform3D getAxisOfRotation() {
        return new Transform3D(this.axis);
    }

    public void getQuat(int n, Quat4f quat4f) {
        quat4f.set((Tuple4f)this.quats[n]);
    }

    public void getQuats(Quat4f[] quat4fArray) {
        int n = 0;
        while (n < this.quats.length) {
            quat4fArray[n].set((Tuple4f)this.quats[n]);
            ++n;
        }
    }

    public TransformGroup getTarget() {
        return this.target;
    }

    public void processStimulus(Enumeration enumeration) {
        if (this.alpha != null) {
            this.computePathInterpolation();
            if (this.currentKnotIndex == 0 && this.currentInterpolationValue == 0.0f) {
                this.tQuat.x = this.quats[0].x;
                this.tQuat.y = this.quats[0].y;
                this.tQuat.z = this.quats[0].z;
                this.tQuat.w = this.quats[0].w;
            } else {
                double d = this.quats[this.currentKnotIndex].x * this.quats[this.currentKnotIndex + 1].x + this.quats[this.currentKnotIndex].y * this.quats[this.currentKnotIndex + 1].y + this.quats[this.currentKnotIndex].z * this.quats[this.currentKnotIndex + 1].z + this.quats[this.currentKnotIndex].w * this.quats[this.currentKnotIndex + 1].w;
                if (d < 0.0) {
                    this.tQuat.x = this.quats[this.currentKnotIndex].x + (-this.quats[this.currentKnotIndex + 1].x - this.quats[this.currentKnotIndex].x) * this.currentInterpolationValue;
                    this.tQuat.y = this.quats[this.currentKnotIndex].y + (-this.quats[this.currentKnotIndex + 1].y - this.quats[this.currentKnotIndex].y) * this.currentInterpolationValue;
                    this.tQuat.z = this.quats[this.currentKnotIndex].z + (-this.quats[this.currentKnotIndex + 1].z - this.quats[this.currentKnotIndex].z) * this.currentInterpolationValue;
                    this.tQuat.w = this.quats[this.currentKnotIndex].w + (-this.quats[this.currentKnotIndex + 1].w - this.quats[this.currentKnotIndex].w) * this.currentInterpolationValue;
                } else {
                    this.tQuat.x = this.quats[this.currentKnotIndex].x + (this.quats[this.currentKnotIndex + 1].x - this.quats[this.currentKnotIndex].x) * this.currentInterpolationValue;
                    this.tQuat.y = this.quats[this.currentKnotIndex].y + (this.quats[this.currentKnotIndex + 1].y - this.quats[this.currentKnotIndex].y) * this.currentInterpolationValue;
                    this.tQuat.z = this.quats[this.currentKnotIndex].z + (this.quats[this.currentKnotIndex + 1].z - this.quats[this.currentKnotIndex].z) * this.currentInterpolationValue;
                    this.tQuat.w = this.quats[this.currentKnotIndex].w + (this.quats[this.currentKnotIndex + 1].w - this.quats[this.currentKnotIndex].w) * this.currentInterpolationValue;
                }
            }
            this.tQuat.normalize();
            this.rotation.set(this.tQuat);
            this.temp.mul(this.axis, this.rotation);
            this.temp.mul(this.temp, this.axisInverse);
            this.target.setTransform(this.temp);
        }
        this.wakeupOn(this.defaultWakeupCriterion);
    }

    public void setAxisOfRotation(Transform3D transform3D) {
        this.axis.set(transform3D);
        this.axisInverse.invert(this.axis);
    }

    public void setPathArrays(float[] fArray, Quat4f[] quat4fArray) {
        if (fArray.length != quat4fArray.length) {
            throw new IllegalArgumentException(J3dI18N.getString("RotationPathInterpolator0"));
        }
        this.setKnots(fArray);
        this.setPathArrays(quat4fArray);
    }

    private void setPathArrays(Quat4f[] quat4fArray) {
        this.quats = new Quat4f[quat4fArray.length];
        int n = 0;
        while (n < quat4fArray.length) {
            this.quats[n] = new Quat4f();
            this.quats[n].set((Tuple4f)quat4fArray[n]);
            ++n;
        }
    }

    public void setQuat(int n, Quat4f quat4f) {
        this.quats[n].set((Tuple4f)quat4f);
    }

    public void setTarget(TransformGroup transformGroup) {
        this.target = transformGroup;
    }

    public void updateNodeReferences(NodeReferenceTable nodeReferenceTable) {
        super.updateNodeReferences(nodeReferenceTable);
        TransformGroup transformGroup = this.getTarget();
        if (transformGroup != null) {
            this.setTarget((TransformGroup)nodeReferenceTable.getNewObjectReference(transformGroup));
        }
    }
}

