/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import javax.media.j3d.Appearance;
import javax.media.j3d.AuralAttributes;
import javax.media.j3d.Background;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.CanvasViewCache;
import javax.media.j3d.Fog;
import javax.media.j3d.Geometry;
import javax.media.j3d.HiResCoord;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.J3dThread;
import javax.media.j3d.Light;
import javax.media.j3d.ModelClip;
import javax.media.j3d.NodeComponentRetained;
import javax.media.j3d.Raster;
import javax.media.j3d.RenderBin;
import javax.media.j3d.RendererStructure;
import javax.media.j3d.Screen3D;
import javax.media.j3d.Sound;
import javax.media.j3d.Transform3D;
import javax.media.j3d.View;
import javax.media.j3d.VirtualUniverse;

class Renderer
extends J3dThread {
    static final int WAIT = 0;
    static final int NOTIFY_AND_WAIT = 1;
    static final int NOTIFY = 2;
    static final int DECAL_NONE = 0;
    static final int DECAL_1ST_CHILD = 1;
    static final int DECAL_NTH_CHILD = 2;
    static final int NUM_ACCUMULATION_SAMPLES = 8;
    static final float[] ACCUM_SAMPLES_X = new float[]{-0.054818f, 0.056438f, 0.039462f, -0.054498f, -0.02379f, -0.039263f, 0.032254f, 0.024216f};
    static final float[] ACCUM_SAMPLES_Y = new float[]{0.055331f, -0.053495f, 0.04154f, -0.052829f, 0.022102f, -0.027383f, 0.009133f, -0.044399f};
    static final float accumValue = 0.125f;
    static final int RENDER = 0;
    static final int SWAP = 1;
    static final int RESOURCE = 2;
    static final int REQUESTRENDER = 3;
    RenderBin renderBin = null;
    RendererStructure rendererStructure = new RendererStructure();
    Canvas3D canvas;
    Transform3D bgVworldToVpc = new Transform3D();
    long lasttime;
    long currtime;
    float numframes = 0.0f;
    static final boolean doTiming = false;
    Object[] swapArray = null;
    boolean swapFlag = false;
    boolean rendererReady = false;
    private static int numInstances = 0;
    private int instanceNum = -1;
    int sharedCtx = 0;
    private int display;
    int rendererBit = 0;
    ArrayList dirtyRenderMoleculeList = new ArrayList();
    ArrayList textureIdResourceFreeList = new ArrayList();
    ArrayList displayListResourceFreeList = new ArrayList();
    CanvasViewCache copyOfCvCache = new CanvasViewCache(null, null, null);
    J3dMessage[] renderMessage;
    Screen3D onScreen;
    Screen3D offScreen;
    double[] accumLeftProjMat = new double[16];
    double[] accumRightProjMat = new double[16];
    double[] accumInfLeftProjMat = new double[16];
    double[] accumInfRightProjMat = new double[16];
    J3dMessage[] m;
    int nmesg = 0;
    ArrayList listOfCtxs = new ArrayList();
    ArrayList listOfCanvases = new ArrayList();

    Renderer(ThreadGroup threadGroup) {
        super(threadGroup);
        this.setName("J3D-Renderer-" + this.getInstanceNum());
        this.type = 16;
        this.rendererBit = VirtualUniverse.mc.getRendererBit();
        this.renderMessage = new J3dMessage[1];
    }

    native void D3DCleanUp();

    void doWork(long l) {
        block125: {
            View view = null;
            int n = 1;
            boolean bl = false;
            float f = 0.0f;
            float f2 = 0.0f;
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            double d6 = 0.0;
            double d7 = 0.0;
            double d8 = 0.0;
            boolean bl2 = true;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            int n2 = (Integer)this.args[0];
            try {
                if (n2 == 1) {
                    bl2 = VirtualUniverse.mc.doDsiRenderLock;
                    this.swapArray = (Object[])this.args[2];
                    view = (View)this.args[3];
                    int n3 = 0;
                    while (n3 < this.swapArray.length) {
                        block124: {
                            Canvas3D canvas3D = (Canvas3D)this.swapArray[n3];
                            if (canvas3D.isRunning) {
                                try {
                                    if (!canvas3D.active || canvas3D.ctx == 0 || canvas3D.view == null || !canvas3D.imageReady) break block124;
                                    if (canvas3D.useDoubleBuffer) {
                                        if (!this.canvas.drawingSurfaceObject.renderLock(bl2)) break block124;
                                        canvas3D.syncRender(canvas3D.ctx, true);
                                        canvas3D.swapBuffers(canvas3D.ctx, canvas3D.screen.display, canvas3D.window);
                                        this.canvas.drawingSurfaceObject.unLock(bl2);
                                    }
                                    this.canvas.view.inCanvasCallback = true;
                                    try {
                                        canvas3D.postSwap();
                                    }
                                    catch (RuntimeException runtimeException) {
                                        System.err.println("Exception occurred during Canvas3D callback:");
                                        runtimeException.printStackTrace();
                                    }
                                    canvas3D.imageReady = false;
                                    this.canvas.view.inCanvasCallback = false;
                                    if (!canvas3D.ctxChanged) {
                                        canvas3D.canvasDirty = 7743;
                                    } else {
                                        canvas3D.ctxChanged = false;
                                    }
                                }
                                catch (NullPointerException nullPointerException) {
                                    this.canvas.drawingSurfaceObject.unLock(bl2);
                                }
                            }
                        }
                        ++n3;
                    }
                    if (view != null && view.viewCache.getDoHeadTracking()) {
                        VirtualUniverse.mc.sendRunMessage(view, 128);
                    }
                    break block125;
                }
                this.nmesg = 0;
                if (n2 == 0) {
                    this.m = this.renderMessage;
                    this.m[0] = VirtualUniverse.mc.getMessage();
                    this.m[0].type = 43;
                    this.m[0].incRefcount();
                    this.m[0].args[0] = this.args[1];
                } else {
                    this.m = this.rendererStructure.getMessages();
                    if (this.m == null) {
                        return;
                    }
                    bl2 = false;
                }
                while (this.nmesg < this.m.length) {
                    int n4;
                    int n5;
                    boolean bl6;
                    this.canvas = (Canvas3D)this.m[this.nmesg].args[0];
                    int n6 = this.m[this.nmesg].type;
                    if (this.canvas.view == null || !this.canvas.firstPaintCalled) {
                        if (n6 == 42) {
                            this.canvas.offScreenRendering = false;
                        }
                        this.m[this.nmesg++].decRefcount();
                        continue;
                    }
                    if (n6 == 44) {
                        int n7 = (Integer)this.m[this.nmesg].args[1];
                        switch (n7) {
                            case 0: {
                                this.canvas.graphicsContext3D.doClear();
                                break;
                            }
                            case 1: {
                                this.canvas.graphicsContext3D.doDraw((Geometry)this.m[this.nmesg].args[2]);
                                break;
                            }
                            case 2: {
                                this.canvas.doSwap();
                                break;
                            }
                            case 3: {
                                this.canvas.graphicsContext3D.doReadRaster((Raster)this.m[this.nmesg].args[2]);
                                break;
                            }
                            case 4: {
                                this.canvas.graphicsContext3D.doSetAppearance((Appearance)this.m[this.nmesg].args[2]);
                                break;
                            }
                            case 5: {
                                this.canvas.graphicsContext3D.doSetBackground((Background)this.m[this.nmesg].args[2]);
                                break;
                            }
                            case 6: {
                                this.canvas.graphicsContext3D.doSetFog((Fog)this.m[this.nmesg].args[2]);
                                break;
                            }
                            case 7: {
                                this.canvas.graphicsContext3D.doSetLight((Light)this.m[this.nmesg].args[2], (Integer)this.m[this.nmesg].args[3]);
                                break;
                            }
                            case 8: {
                                this.canvas.graphicsContext3D.doInsertLight((Light)this.m[this.nmesg].args[2], (Integer)this.m[this.nmesg].args[3]);
                                break;
                            }
                            case 9: {
                                this.canvas.graphicsContext3D.doRemoveLight((Integer)this.m[this.nmesg].args[2]);
                                break;
                            }
                            case 10: {
                                this.canvas.graphicsContext3D.doAddLight((Light)this.m[this.nmesg].args[2]);
                                break;
                            }
                            case 11: {
                                this.canvas.graphicsContext3D.doSetHiRes((HiResCoord)this.m[this.nmesg].args[2]);
                                break;
                            }
                            case 12: {
                                this.canvas.graphicsContext3D.doSetModelTransform((Transform3D)this.m[this.nmesg].args[2]);
                                break;
                            }
                            case 13: {
                                this.canvas.graphicsContext3D.doMultiplyModelTransform((Transform3D)this.m[this.nmesg].args[2]);
                                break;
                            }
                            case 14: {
                                this.canvas.graphicsContext3D.doSetSound((Sound)this.m[this.nmesg].args[2], (Integer)this.m[this.nmesg].args[3]);
                                break;
                            }
                            case 15: {
                                this.canvas.graphicsContext3D.doInsertSound((Sound)this.m[this.nmesg].args[2], (Integer)this.m[this.nmesg].args[3]);
                                break;
                            }
                            case 16: {
                                this.canvas.graphicsContext3D.doRemoveSound((Integer)this.m[this.nmesg].args[2]);
                                break;
                            }
                            case 17: {
                                this.canvas.graphicsContext3D.doAddSound((Sound)this.m[this.nmesg].args[2]);
                                break;
                            }
                            case 18: {
                                this.canvas.graphicsContext3D.doSetAuralAttributes((AuralAttributes)this.m[this.nmesg].args[2]);
                                break;
                            }
                            case 19: {
                                this.canvas.graphicsContext3D.doSetBufferOverride((Boolean)this.m[this.nmesg].args[2]);
                                break;
                            }
                            case 20: {
                                this.canvas.graphicsContext3D.doSetFrontBufferRendering((Boolean)this.m[this.nmesg].args[2]);
                                break;
                            }
                            case 21: {
                                this.canvas.graphicsContext3D.doSetStereoMode((Integer)this.m[this.nmesg].args[2]);
                                break;
                            }
                            case 22: {
                                this.canvas.graphicsContext3D.doFlush((Boolean)this.m[this.nmesg].args[2]);
                                break;
                            }
                            case 23: {
                                this.canvas.graphics2D.doFlush();
                                break;
                            }
                            case 24: {
                                this.canvas.graphicsContext3D.doSetModelClip((ModelClip)this.m[this.nmesg].args[2]);
                                break;
                            }
                        }
                        this.m[this.nmesg++].decRefcount();
                        continue;
                    }
                    this.m[this.nmesg++].decRefcount();
                    if (!(n6 != 42 || this.canvas.window != 0 && this.canvas.active)) {
                        this.canvas.offScreenRendering = false;
                        continue;
                    }
                    if (!this.canvas.active) continue;
                    this.renderBin = this.canvas.view.renderBin;
                    if (!this.canvas.drawingSurfaceObject.contextLock(bl2)) break;
                    if (this.canvas.useSharedCtx && this.sharedCtx == 0) {
                        this.display = this.canvas.screen.display;
                        Object object = VirtualUniverse.mc.contextCreationLock;
                        synchronized (object) {
                            this.sharedCtx = this.canvas.createContext(this.canvas.screen.display, this.canvas.window, this.canvas.vid, 0, this.canvas.offScreen);
                        }
                    }
                    if (this.canvas.ctx == 0) {
                        Object object = VirtualUniverse.mc.contextCreationLock;
                        synchronized (object) {
                            this.canvas.ctx = this.canvas.createContext(this.canvas.screen.display, this.canvas.window, this.canvas.vid, this.sharedCtx, this.canvas.offScreen);
                            this.listOfCtxs.add(new Integer(this.canvas.ctx));
                            this.listOfCanvases.add(this.canvas);
                            if (this.renderBin.nodeComponentList.size() > 0) {
                                int n8 = 0;
                                while (n8 < this.renderBin.nodeComponentList.size()) {
                                    NodeComponentRetained nodeComponentRetained = (NodeComponentRetained)this.renderBin.nodeComponentList.get(n8);
                                    nodeComponentRetained.evaluateExtensions(this.canvas.extensionsSupported);
                                    ++n8;
                                }
                            }
                            if (this.canvas.multiTexAccelerated) {
                                this.canvas.numTexUnitSupported = this.canvas.getTextureUnitCount(this.canvas.ctx);
                            }
                        }
                        this.canvas.canvasDirty = 65535;
                        this.canvas.setSceneAmbient(this.canvas.ctx, 0.0f, 0.0f, 0.0f);
                        this.canvas.disableFog(this.canvas.ctx);
                        this.canvas.resetRenderingAttributes(this.canvas.ctx, false, false);
                        this.canvas.resetTexture(this.canvas.ctx, -1);
                        this.canvas.resetTexCoordGeneration(this.canvas.ctx);
                        this.canvas.resetTextureAttributes(this.canvas.ctx);
                        this.canvas.resetPolygonAttributes(this.canvas.ctx);
                        this.canvas.resetLineAttributes(this.canvas.ctx);
                        this.canvas.resetPointAttributes(this.canvas.ctx);
                        this.canvas.resetTransparency(this.canvas.ctx, 2, false, false);
                        this.canvas.resetColoringAttributes(this.canvas.ctx, 1.0f, 1.0f, 1.0f, 1.0f, false);
                        this.canvas.updateMaterial(this.canvas.ctx, 1.0f, 1.0f, 1.0f, 1.0f);
                        this.canvas.makeCtxCurrent();
                        this.canvas.drawingSurfaceObject.contextValidated();
                        if (!this.canvas.useSharedCtx) {
                            bl4 = true;
                        }
                    } else if (this.canvas.isRunning) {
                        this.canvas.makeCtxCurrent();
                    }
                    this.canvas.drawingSurfaceObject.unLock(bl2);
                    if (this.renderBin == null) continue;
                    if (this.canvas.useSharedCtx) {
                        if (this.textureIdResourceFreeList.size() > 0 || this.displayListResourceFreeList.size() > 0) {
                            this.renderBin.freeResource(this.canvas, this.displayListResourceFreeList, this.textureIdResourceFreeList, true);
                            this.textureIdResourceFreeList.clear();
                            this.displayListResourceFreeList.clear();
                        }
                    } else if (this.canvas.textureIdResourceFreeList.size() > 0 || this.canvas.displayListResourceFreeList.size() > 0) {
                        this.renderBin.freeResource(this.canvas, this.canvas.displayListResourceFreeList, this.canvas.textureIdResourceFreeList, false);
                        this.canvas.textureIdResourceFreeList.clear();
                        this.canvas.displayListResourceFreeList.clear();
                    }
                    this.canvas.updateViewCache(false, this.copyOfCvCache, null, this.renderBin.geometryBackground != null);
                    boolean bl7 = bl2 = bl2 && VirtualUniverse.mc.doDsiRenderLock;
                    if (!this.canvas.drawingSurfaceObject.renderLock(bl2)) break;
                    this.canvas.setViewport(this.canvas.ctx, 0, 0, this.copyOfCvCache.getCanvasWidth(), this.copyOfCvCache.getCanvasHeight());
                    if (this.canvas.useSharedCtx) {
                        if (this.dirtyRenderMoleculeList.size() > 0) {
                            this.renderBin.updateDirtyRenderMolecule(this.canvas, this.dirtyRenderMoleculeList, true);
                            this.dirtyRenderMoleculeList.clear();
                        }
                    } else if (bl4) {
                        this.renderBin.updateAllRenderMolecule(this.canvas);
                        bl4 = false;
                    } else if (this.canvas.dirtyRenderMoleculeList.size() > 0) {
                        this.renderBin.updateDirtyRenderMolecule(this.canvas, this.canvas.dirtyRenderMoleculeList, false);
                        this.canvas.dirtyRenderMoleculeList.clear();
                    }
                    if (this.canvas.localEyeLightingEnable != this.canvas.ctxEyeLightingEnable) {
                        this.canvas.ctxUpdateEyeLightingEnable(this.canvas.ctx, this.canvas.localEyeLightingEnable);
                        this.canvas.ctxEyeLightingEnable = this.canvas.localEyeLightingEnable;
                    }
                    if (bl6 = this.copyOfCvCache.getUseStereo()) {
                        n5 = 2;
                        n4 = 0;
                    } else {
                        n5 = 1;
                        n4 = 2;
                    }
                    if (this.canvas.view.getSceneAntialiasingEnable() && this.canvas.sceneAntialiasingAvailable) {
                        if (!VirtualUniverse.mc.isD3D()) {
                            bl = true;
                            n = 8;
                            this.canvas.clearAccum(this.canvas.ctx, this.renderBin.background.color.x, this.renderBin.background.color.y, this.renderBin.background.color.z, 1.0f);
                            System.arraycopy(this.copyOfCvCache.getLeftProjection().mat, 0, this.accumLeftProjMat, 0, 16);
                            if (bl6) {
                                System.arraycopy(this.copyOfCvCache.getRightProjection().mat, 0, this.accumRightProjMat, 0, 16);
                            }
                            if (this.renderBin.geometryBackground != null) {
                                System.arraycopy(this.copyOfCvCache.getInfLeftProjection().mat, 0, this.accumInfLeftProjMat, 0, 16);
                                if (bl6) {
                                    System.arraycopy(this.copyOfCvCache.getInfRightProjection().mat, 0, this.accumInfRightProjMat, 0, 16);
                                }
                            }
                        } else {
                            this.canvas.setFullSceneAntialiasing(this.canvas.ctx, true);
                            bl5 = true;
                        }
                    }
                    if (this.renderBin.geometryBackground != null) {
                        this.renderBin.updateInfVworldToVpc();
                    }
                    this.canvas.setRenderMode(this.canvas.ctx, 2, this.canvas.useDoubleBuffer);
                    if (!bl) {
                        this.canvas.clear(this.canvas.ctx, this.renderBin.background.color.x, this.renderBin.background.color.y, this.renderBin.background.color.z, this.renderBin.background.image);
                        d = this.accumLeftProjMat[3];
                        d2 = this.accumLeftProjMat[7];
                        if (bl6) {
                            d3 = this.accumRightProjMat[3];
                            d4 = this.accumRightProjMat[7];
                        }
                        if (this.renderBin.geometryBackground != null) {
                            d5 = this.accumInfLeftProjMat[3];
                            d6 = this.accumInfLeftProjMat[7];
                            if (bl6) {
                                d7 = this.accumInfRightProjMat[3];
                                d8 = this.accumInfRightProjMat[7];
                            }
                        }
                    }
                    this.canvas.drawingSurfaceObject.unLock(bl2);
                    this.canvas.view.inCanvasCallback = true;
                    try {
                        this.canvas.preRender();
                    }
                    catch (RuntimeException runtimeException) {
                        System.err.println("Exception occurred during Canvas3D callback:");
                        runtimeException.printStackTrace();
                    }
                    this.canvas.view.inCanvasCallback = false;
                    if (!this.canvas.drawingSurfaceObject.renderLock(bl2)) break;
                    int n9 = 0;
                    while (n9 < n5) {
                        if (bl) {
                            this.canvas.clearAccum(this.canvas.ctx, this.renderBin.background.color.x, this.renderBin.background.color.y, this.renderBin.background.color.z, 1.0f);
                        }
                        this.canvas.setRenderMode(this.canvas.ctx, n4, this.canvas.useDoubleBuffer);
                        int n10 = 0;
                        while (n10 < n) {
                            if (bl) {
                                f = ACCUM_SAMPLES_X[n10] / (float)this.canvas.screen.getSize().width;
                                f2 = ACCUM_SAMPLES_Y[n10] / (float)this.canvas.screen.getSize().height;
                                this.accumLeftProjMat[3] = d + (double)f;
                                this.accumLeftProjMat[7] = d2 + (double)f2;
                                if (bl6) {
                                    this.accumRightProjMat[3] = d3 + (double)f;
                                    this.accumRightProjMat[7] = d4 + (double)f2;
                                }
                                if (this.renderBin.geometryBackground != null) {
                                    this.accumInfLeftProjMat[3] = d5 + (double)f;
                                    this.accumInfLeftProjMat[7] = d6 + (double)f2;
                                    if (bl6) {
                                        this.accumInfRightProjMat[3] = d7 + (double)f;
                                        this.accumInfRightProjMat[7] = d8 + (double)f2;
                                    }
                                }
                                this.canvas.clear(this.canvas.ctx, this.renderBin.background.color.x, this.renderBin.background.color.y, this.renderBin.background.color.z, this.renderBin.background.image);
                            }
                            if (this.renderBin.geometryBackground != null) {
                                if (n9 == 0) {
                                    this.canvas.vpcToEc = this.copyOfCvCache.getInfLeftVpcToEc();
                                    if (bl) {
                                        this.canvas.setProjectionMatrix(this.canvas.ctx, this.accumInfLeftProjMat);
                                    } else {
                                        this.canvas.setProjectionMatrix(this.canvas.ctx, this.copyOfCvCache.getInfLeftProjection().mat);
                                    }
                                } else {
                                    this.canvas.vpcToEc = this.copyOfCvCache.getInfRightVpcToEc();
                                    if (bl) {
                                        this.canvas.setProjectionMatrix(this.canvas.ctx, this.accumInfRightProjMat);
                                    } else {
                                        this.canvas.setProjectionMatrix(this.canvas.ctx, this.copyOfCvCache.getInfRightProjection().mat);
                                    }
                                }
                                this.canvas.vworldToEc.mul(this.canvas.vpcToEc, this.copyOfCvCache.getInfVworldToVpc());
                                this.renderBin.renderBackground(this.canvas);
                            }
                            if (n9 == 0) {
                                this.canvas.vpcToEc = this.copyOfCvCache.getLeftVpcToEc();
                                if (bl) {
                                    this.canvas.setProjectionMatrix(this.canvas.ctx, this.accumLeftProjMat);
                                } else {
                                    this.canvas.setProjectionMatrix(this.canvas.ctx, this.copyOfCvCache.getLeftProjection().mat);
                                }
                            } else {
                                this.canvas.vpcToEc = this.copyOfCvCache.getRightVpcToEc();
                                if (bl) {
                                    this.canvas.setProjectionMatrix(this.canvas.ctx, this.accumRightProjMat);
                                } else {
                                    this.canvas.setProjectionMatrix(this.canvas.ctx, this.copyOfCvCache.getRightProjection().mat);
                                }
                            }
                            this.canvas.vworldToEc.mul(this.canvas.vpcToEc, this.copyOfCvCache.getVworldToVpc());
                            CanvasViewCache canvasViewCache = this.copyOfCvCache;
                            synchronized (canvasViewCache) {
                                if (n9 == 0) {
                                    this.canvas.setFrustumPlanes(this.copyOfCvCache.getLeftFrustumPlanesInVworld());
                                } else {
                                    this.canvas.setFrustumPlanes(this.copyOfCvCache.getRightFrustumPlanesInVworld());
                                }
                            }
                            this.renderBin.renderOpaque(this.canvas);
                            this.renderBin.renderOrdered(this.canvas);
                            this.canvas.drawingSurfaceObject.unLock(bl2);
                            this.canvas.view.inCanvasCallback = true;
                            try {
                                this.canvas.renderField(n4);
                            }
                            catch (RuntimeException runtimeException) {
                                System.err.println("Exception occurred during Canvas3D callback:");
                                runtimeException.printStackTrace();
                            }
                            this.canvas.view.inCanvasCallback = false;
                            if (this.canvas.drawingSurfaceObject.renderLock(bl2)) {
                                this.renderBin.renderTransparent(this.canvas);
                                if (bl) {
                                    this.canvas.accum(this.canvas.ctx, 0.125f);
                                }
                                ++n10;
                                continue;
                            }
                            break block125;
                        }
                        if (bl) {
                            this.canvas.accumReturn(this.canvas.ctx);
                        }
                        if (bl6) {
                            n4 = 1;
                        }
                        ++n9;
                    }
                    this.canvas.imageReady = true;
                    this.canvas.setRenderMode(this.canvas.ctx, 2, this.canvas.useDoubleBuffer);
                    this.canvas.drawingSurfaceObject.unLock(bl2);
                    this.canvas.view.inCanvasCallback = true;
                    try {
                        this.canvas.postRender();
                    }
                    catch (RuntimeException runtimeException) {
                        System.err.println("Exception occurred during Canvas3D callback:");
                        runtimeException.printStackTrace();
                    }
                    this.canvas.view.inCanvasCallback = false;
                    if (this.canvas.offScreenRendering) {
                        this.canvas.syncRender(this.canvas.ctx, true);
                        this.canvas.endOffScreenRendering();
                        this.canvas.view.inCanvasCallback = true;
                        try {
                            this.canvas.postSwap();
                        }
                        catch (RuntimeException runtimeException) {
                            System.err.println("Exception occurred during Canvas 3D callback:");
                            runtimeException.printStackTrace();
                        }
                        this.canvas.view.inCanvasCallback = false;
                    }
                    if (!bl5) continue;
                    this.canvas.setFullSceneAntialiasing(this.canvas.ctx, false);
                    bl5 = false;
                }
            }
            catch (NullPointerException nullPointerException) {
                this.canvas.drawingSurfaceObject.unLock(bl2);
            }
        }
    }

    native void freeContext(int var1, int var2);

    int getInstanceNum() {
        if (this.instanceNum == -1) {
            this.instanceNum = this.newInstanceNum();
        }
        return this.instanceNum;
    }

    private synchronized int newInstanceNum() {
        return ++numInstances;
    }

    void removeAllCtxs() {
        Object object = VirtualUniverse.mc.contextCreationLock;
        synchronized (object) {
            if (this.sharedCtx != 0) {
                this.freeContext(this.display, this.sharedCtx);
                this.sharedCtx = 0;
            }
            int n = 0;
            while (n < this.listOfCanvases.size()) {
                Canvas3D canvas3D = (Canvas3D)this.listOfCanvases.get(n);
                if (canvas3D.screen != null && canvas3D.ctx != 0) {
                    this.freeContext(canvas3D.screen.display, canvas3D.ctx);
                    canvas3D.ctx = 0;
                }
                ++n;
            }
            this.listOfCanvases.clear();
            this.listOfCtxs.clear();
        }
    }

    void removeCtx(Canvas3D canvas3D) {
        Object object = VirtualUniverse.mc.contextCreationLock;
        synchronized (object) {
            if (canvas3D.ctx != 0) {
                int n = this.listOfCtxs.indexOf(new Integer(canvas3D.ctx));
                if (n >= 0) {
                    this.listOfCtxs.remove(n);
                    this.listOfCanvases.remove(n);
                }
                if (canvas3D.screen != null) {
                    this.freeContext(canvas3D.screen.display, canvas3D.ctx);
                }
                canvas3D.ctx = 0;
            }
        }
    }

    void setCanvas(Canvas3D canvas3D) {
        this.canvas = canvas3D;
    }

    void setSwapArray(Object[] objectArray) {
        this.swapArray = objectArray;
    }

    void setSwapFlag(boolean bl) {
        this.swapFlag = bl;
    }

    void shutdown() {
        this.removeAllCtxs();
        if (VirtualUniverse.mc.isD3D()) {
            this.D3DCleanUp();
        }
    }
}

