/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.AppearanceRetained;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.EnvironmentSet;
import javax.media.j3d.FogRetained;
import javax.media.j3d.GeometryAtom;
import javax.media.j3d.GeometryRetained;
import javax.media.j3d.LightRetained;
import javax.media.j3d.ModelClipRetained;
import javax.media.j3d.ObjectUpdate;
import javax.media.j3d.OrientedShape3DRetained;
import javax.media.j3d.RenderMolecule;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransparencyAttributesRetained;
import javax.media.j3d.VirtualUniverse;

class RenderAtom
implements ObjectUpdate {
    GeometryAtom geometryAtom = null;
    RenderMolecule renderMolecule = null;
    LightRetained[] lights = null;
    FogRetained fog = null;
    ModelClipRetained modelClip = null;
    AppearanceRetained app = null;
    Transform3D localToVworld = null;
    boolean inRenderBin = false;
    EnvironmentSet envSet;
    long lastVisibleTime = -1L;
    RenderAtom next = null;
    RenderAtom prev = null;
    Transform3D modelMatrix = new Transform3D();
    int inPrimaryArray = 0;
    static int TEXT3D = 1;
    static int DLIST = 2;
    static int CG = 4;
    static int OTHER = 8;
    boolean onUpdateList = false;
    Transform3D infLocalToVworld = new Transform3D();
    boolean isOriented = false;
    boolean inDirtyOrientedRAs = false;
    BoundingBox localeVwcBounds = null;

    RenderAtom() {
    }

    boolean isOpaque() {
        AppearanceRetained appearanceRetained = this.geometryAtom.source.appearance;
        GeometryRetained geometryRetained = this.geometryAtom.geometry;
        if (appearanceRetained == null) {
            return true;
        }
        TransparencyAttributesRetained transparencyAttributesRetained = appearanceRetained.transparencyAttributes;
        if (transparencyAttributesRetained != null && transparencyAttributesRetained.transparencyMode != 4 && (VirtualUniverse.mc.isD3D() || !VirtualUniverse.mc.isD3D() && transparencyAttributesRetained.transparencyMode != 3)) {
            return false;
        }
        switch (geometryRetained.geoType) {
            case 3: 
            case 10: {
                if (appearanceRetained.pointAttributes == null || !appearanceRetained.pointAttributes.pointAntialiasing) break;
                return false;
            }
            case 4: 
            case 7: 
            case 11: 
            case 14: {
                if (appearanceRetained.lineAttributes == null || !VirtualUniverse.mc.isD3D() && (VirtualUniverse.mc.isD3D() || !appearanceRetained.lineAttributes.lineAntialiasing)) break;
                return false;
            }
            default: {
                if (appearanceRetained.polygonAttributes == null) break;
                if (appearanceRetained.polygonAttributes.polygonMode == 0 && appearanceRetained.pointAttributes != null && (VirtualUniverse.mc.isD3D() || !VirtualUniverse.mc.isD3D() && appearanceRetained.pointAttributes.pointAntialiasing)) {
                    return false;
                }
                if (appearanceRetained.polygonAttributes.polygonMode != 1 || appearanceRetained.lineAttributes == null || !VirtualUniverse.mc.isD3D() && (VirtualUniverse.mc.isD3D() || !appearanceRetained.lineAttributes.lineAntialiasing)) break;
                return false;
            }
            case 15: 
            case 17: 
        }
        return true;
    }

    synchronized void setRenderBin(boolean bl) {
        this.inRenderBin = bl;
        if (!bl) {
            this.app = null;
        }
    }

    public void updateObject() {
        if (this.inRenderBin) {
            if (this.geometryAtom.source.inBackgroundGroup) {
                this.renderMolecule.localToVworld.getRotation(this.infLocalToVworld);
                this.infLocalToVworld.mul(this.geometryAtom.lastLocalTransform);
            } else {
                this.localToVworld.mul(this.renderMolecule.localeLocalToVworld, this.geometryAtom.lastLocalTransform);
            }
        }
        this.onUpdateList = false;
    }

    void updateOrientedTransform() {
        Transform3D transform3D = ((OrientedShape3DRetained)this.geometryAtom.source).orientedTransform;
        if (this.geometryAtom.geoType == 16) {
            if (this.geometryAtom.source.inBackgroundGroup) {
                this.infLocalToVworld.mul(this.renderMolecule.infLocalToVworld, transform3D);
                this.infLocalToVworld.mul(this.geometryAtom.lastLocalTransform);
            } else {
                this.localToVworld.mul(this.renderMolecule.localeLocalToVworld, transform3D);
                this.localToVworld.mul(this.geometryAtom.lastLocalTransform);
            }
        } else if (this.geometryAtom.source.inBackgroundGroup) {
            this.infLocalToVworld.mul(this.renderMolecule.infLocalToVworld, transform3D);
        } else {
            this.localToVworld.mul(this.renderMolecule.localeLocalToVworld, transform3D);
        }
    }
}

