/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.NodeComponentRetained;
import javax.media.j3d.Shape3DRetained;
import javax.media.j3d.VirtualUniverse;

class PolygonAttributesRetained
extends NodeComponentRetained {
    static final int POLYGON_MODE_CHANGED = 1;
    static final int POLYGON_CULL_CHANGED = 2;
    static final int POLYGON_OFFSET_CHANGED = 4;
    static final int POLYGON_BACKFACENORMALFLIP_CHANGED = 8;
    static final int POLYGON_OFFSETFACTOR_CHANGED = 16;
    int polygonMode = 2;
    int cullFace = 1;
    boolean backFaceNormalFlip = false;
    float polygonOffset;
    float polygonOffsetFactor;

    PolygonAttributesRetained() {
    }

    synchronized void createMirrorObject() {
        if (this.mirror == null) {
            if (this.isStatic()) {
                this.mirror = this;
            } else {
                PolygonAttributesRetained polygonAttributesRetained = new PolygonAttributesRetained();
                polygonAttributesRetained.set(this);
                polygonAttributesRetained.source = this.source;
                this.mirror = polygonAttributesRetained;
            }
        } else {
            ((PolygonAttributesRetained)this.mirror).set(this);
        }
    }

    boolean equivalent(PolygonAttributesRetained polygonAttributesRetained) {
        return polygonAttributesRetained != null && polygonAttributesRetained.cullFace == this.cullFace && polygonAttributesRetained.backFaceNormalFlip == this.backFaceNormalFlip && polygonAttributesRetained.polygonOffset == this.polygonOffset && polygonAttributesRetained.polygonMode == this.polygonMode && polygonAttributesRetained.polygonOffsetFactor == this.polygonOffsetFactor;
    }

    final boolean getBackFaceNormalFlip() {
        return this.backFaceNormalFlip;
    }

    final int getCullFace() {
        return this.cullFace;
    }

    final int getPolygonMode() {
        return this.polygonMode;
    }

    final float getPolygonOffset() {
        return this.polygonOffset;
    }

    final float getPolygonOffsetFactor() {
        return this.polygonOffsetFactor;
    }

    final void initBackFaceNormalFlip(boolean bl) {
        this.backFaceNormalFlip = bl;
    }

    final void initCullFace(int n) {
        this.cullFace = n;
    }

    synchronized void initMirrorObject() {
        ((PolygonAttributesRetained)this.mirror).set(this);
    }

    final void initPolygonMode(int n) {
        this.polygonMode = n;
    }

    final void initPolygonOffset(float f) {
        this.polygonOffset = f;
    }

    final void initPolygonOffsetFactor(float f) {
        this.polygonOffsetFactor = f;
    }

    final void sendMessage(int n, Object object) {
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = Shape3DRetained.getGeomAtomsList(this.mirror.users, arrayList);
        J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
        j3dMessage.threads = 1024;
        j3dMessage.type = 9;
        j3dMessage.universe = null;
        j3dMessage.args[0] = this;
        j3dMessage.args[1] = new Integer(n);
        j3dMessage.args[2] = object;
        VirtualUniverse.mc.processMessage(j3dMessage);
        int n2 = 0;
        while (n2 < arrayList.size()) {
            j3dMessage = VirtualUniverse.mc.getMessage();
            j3dMessage.threads = 128;
            j3dMessage.type = 9;
            j3dMessage.universe = (VirtualUniverse)arrayList.get(n2);
            j3dMessage.args[0] = this;
            j3dMessage.args[1] = new Integer(n);
            j3dMessage.args[2] = object;
            j3dMessage.args[3] = arrayList2.get(n2);
            VirtualUniverse.mc.processMessage(j3dMessage);
            ++n2;
        }
    }

    protected void set(PolygonAttributesRetained polygonAttributesRetained) {
        this.cullFace = polygonAttributesRetained.cullFace;
        this.backFaceNormalFlip = polygonAttributesRetained.backFaceNormalFlip;
        this.polygonMode = polygonAttributesRetained.polygonMode;
        this.polygonOffset = polygonAttributesRetained.polygonOffset;
        this.polygonOffsetFactor = polygonAttributesRetained.polygonOffsetFactor;
    }

    final void setBackFaceNormalFlip(boolean bl) {
        this.initBackFaceNormalFlip(bl);
        this.sendMessage(8, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    final void setCullFace(int n) {
        this.initCullFace(n);
        this.sendMessage(2, new Integer(n));
    }

    final void setPolygonMode(int n) {
        this.initPolygonMode(n);
        this.sendMessage(1, new Integer(n));
    }

    final void setPolygonOffset(float f) {
        this.initPolygonOffset(f);
        this.sendMessage(4, new Float(f));
    }

    final void setPolygonOffsetFactor(float f) {
        this.initPolygonOffsetFactor(f);
        this.sendMessage(16, new Float(f));
    }

    synchronized void updateMirrorObject(int n, Object object) {
        PolygonAttributesRetained polygonAttributesRetained = (PolygonAttributesRetained)this.mirror;
        if ((n & 1) != 0) {
            polygonAttributesRetained.polygonMode = (Integer)object;
        } else if ((n & 2) != 0) {
            polygonAttributesRetained.cullFace = (Integer)object;
        } else if ((n & 8) != 0) {
            polygonAttributesRetained.backFaceNormalFlip = (Boolean)object;
        } else if ((n & 4) != 0) {
            polygonAttributesRetained.polygonOffset = ((Float)object).floatValue();
        } else if ((n & 0x10) != 0) {
            polygonAttributesRetained.polygonOffsetFactor = ((Float)object).floatValue();
        }
    }

    void updateNative(int n) {
        this.updateNative(n, this.polygonMode, this.cullFace, this.backFaceNormalFlip, this.polygonOffset, this.polygonOffsetFactor);
    }

    native void updateNative(int var1, int var2, int var3, boolean var4, float var5, float var6);
}

