/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import javax.media.j3d.BadTransformException;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.Transform3D;
import javax.media.j3d.View;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class PhysicalBody {
    private static final double HALF_IPD = 0.033;
    private static final double EAR_X = 0.08;
    private static final double EAR_Y = -0.03;
    private static final double EAR_Z = 0.095;
    Point3d leftEyePosition = new Point3d(-0.033, 0.0, 0.0);
    Point3d rightEyePosition = new Point3d(0.033, 0.0, 0.0);
    Point3d leftEarPosition = new Point3d(-0.08, -0.03, 0.095);
    Point3d rightEarPosition = new Point3d(0.08, -0.03, 0.095);
    double nominalEyeHeightFromGround = 1.68;
    double nominalEyeOffsetFromNominalScreen = 0.4572;
    Transform3D headToHeadTracker = new Transform3D();
    ArrayList users = new ArrayList();
    int pbDirtyMask = 0xF000000;

    public PhysicalBody() {
        this.initHeadToHeadTracker();
    }

    public PhysicalBody(Point3d point3d, Point3d point3d2) {
        this.leftEyePosition.set((Tuple3d)point3d);
        this.rightEyePosition.set((Tuple3d)point3d2);
        this.initHeadToHeadTracker();
    }

    public PhysicalBody(Point3d point3d, Point3d point3d2, Point3d point3d3, Point3d point3d4) {
        this.leftEyePosition.set((Tuple3d)point3d);
        this.rightEyePosition.set((Tuple3d)point3d2);
        this.leftEarPosition.set((Tuple3d)point3d3);
        this.rightEarPosition.set((Tuple3d)point3d4);
        this.initHeadToHeadTracker();
    }

    synchronized void addUser(View view) {
        this.users.add(view);
    }

    public void getHeadToHeadTracker(Transform3D transform3D) {
        transform3D.set(this.headToHeadTracker);
    }

    public void getLeftEarPosition(Point3d point3d) {
        point3d.set((Tuple3d)this.leftEarPosition);
    }

    public void getLeftEyePosition(Point3d point3d) {
        point3d.set((Tuple3d)this.leftEyePosition);
    }

    public double getNominalEyeHeightFromGround() {
        return this.nominalEyeHeightFromGround;
    }

    public double getNominalEyeOffsetFromNominalScreen() {
        return this.nominalEyeOffsetFromNominalScreen;
    }

    public void getRightEarPosition(Point3d point3d) {
        point3d.set((Tuple3d)this.rightEarPosition);
    }

    public void getRightEyePosition(Point3d point3d) {
        point3d.set((Tuple3d)this.rightEyePosition);
    }

    private void initHeadToHeadTracker() {
        Vector3d vector3d = new Vector3d(0.0, 0.02, 0.035);
        this.headToHeadTracker.set(vector3d);
    }

    synchronized void notifyUsers() {
        int n = this.users.size() - 1;
        while (n >= 0) {
            View view = (View)this.users.get(n);
            if (view.soundScheduler != null) {
                view.soundScheduler.setDirtyFlag(3);
            }
            view.repaint();
            --n;
        }
    }

    synchronized void removeUser(View view) {
        this.users.remove(this.users.indexOf(view));
    }

    public void setHeadToHeadTracker(Transform3D transform3D) {
        if ((transform3D.getType() & 0x20) == 0) {
            throw new BadTransformException(J3dI18N.getString("PhysicalBody0"));
        }
        this.headToHeadTracker.setWithLock(transform3D);
        this.notifyUsers();
    }

    public void setLeftEarPosition(Point3d point3d) {
        PhysicalBody physicalBody = this;
        synchronized (physicalBody) {
            this.leftEarPosition.set((Tuple3d)point3d);
            this.pbDirtyMask |= 0x2000000;
        }
        this.notifyUsers();
    }

    public void setLeftEyePosition(Point3d point3d) {
        PhysicalBody physicalBody = this;
        synchronized (physicalBody) {
            this.leftEyePosition.set((Tuple3d)point3d);
            this.pbDirtyMask |= 0x1000000;
        }
        this.notifyUsers();
    }

    public void setNominalEyeHeightFromGround(double d) {
        PhysicalBody physicalBody = this;
        synchronized (physicalBody) {
            this.nominalEyeHeightFromGround = d;
            this.pbDirtyMask |= 0x4000000;
        }
        this.notifyUsers();
    }

    public void setNominalEyeOffsetFromNominalScreen(double d) {
        PhysicalBody physicalBody = this;
        synchronized (physicalBody) {
            this.nominalEyeOffsetFromNominalScreen = d;
            this.pbDirtyMask |= 0x8000000;
        }
        this.notifyUsers();
    }

    public void setRightEarPosition(Point3d point3d) {
        PhysicalBody physicalBody = this;
        synchronized (physicalBody) {
            this.rightEarPosition.set((Tuple3d)point3d);
            this.pbDirtyMask |= 0x2000000;
        }
        this.notifyUsers();
    }

    public void setRightEyePosition(Point3d point3d) {
        PhysicalBody physicalBody = this;
        synchronized (physicalBody) {
            this.rightEyePosition.set((Tuple3d)point3d);
            this.pbDirtyMask |= 0x1000000;
        }
        this.notifyUsers();
    }

    public String toString() {
        return "eyePosition = (" + this.leftEyePosition + ", " + this.rightEyePosition + ")\n" + "earPosition = (" + this.leftEarPosition + ", " + this.rightEarPosition + ")";
    }
}

