/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import java.util.Vector;
import javax.media.j3d.BackgroundRetained;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroupRetained;
import javax.media.j3d.GroupRetained;
import javax.media.j3d.HashKey;
import javax.media.j3d.IllegalSharingException;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.Locale;
import javax.media.j3d.SceneGraphObjectRetained;
import javax.media.j3d.SceneGraphPath;
import javax.media.j3d.SetLiveState;
import javax.media.j3d.SharedGroupRetained;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroupRetained;
import javax.media.j3d.VirtualUniverse;

abstract class NodeRetained
extends SceneGraphObjectRetained {
    static final int BACKGROUND = 1;
    static final int CLIP = 2;
    static final int LINEARFOG = 3;
    static final int EXPONENTIALFOG = 4;
    static final int AMBIENTLIGHT = 5;
    static final int DIRECTIONALLIGHT = 6;
    static final int POINTLIGHT = 7;
    static final int SPOTLIGHT = 8;
    static final int LINK = 9;
    static final int MORPH = 10;
    static final int SHAPE = 11;
    static final int BACKGROUNDSOUND = 12;
    static final int POINTSOUND = 13;
    static final int CONESOUND = 14;
    static final int SOUNDSCAPE = 15;
    static final int VIEWPLATFORM = 16;
    static final int BEHAVIOR = 17;
    static final int SWITCH = 18;
    static final int BRANCHGROUP = 19;
    static final int ORDEREDGROUP = 20;
    static final int DECALGROUP = 21;
    static final int SHAREDGROUP = 22;
    static final int GROUP = 23;
    static final int TRANSFORMGROUP = 24;
    static final int BOUNDINGLEAF = 25;
    static final int MODELCLIP = 26;
    static final int ALTERNATEAPPEARANCE = 27;
    static final int ORIENTEDSHAPE3D = 28;
    static final int NUMNODES = 28;
    VirtualUniverse universe = null;
    Locale locale = null;
    NodeRetained parent = null;
    String nodeId = null;
    int nodeType;
    int refCount = 0;
    int childIndex = -1;
    boolean inSharedGroup = false;
    boolean pickable = true;
    boolean collidable = true;
    Transform3D[] currentLocalToVworld = null;
    Transform3D[] lastLocalToVworld = null;
    ArrayList[] parentTransformGroups = null;
    HashKey[] localToVworldKeys = null;
    ArrayList transformTargets = null;
    ArrayList transformBLTargets = null;
    boolean boundsAutoCompute = true;
    Bounds localBounds;
    Object changeLock = new Object();
    boolean inOrderedGroup = false;
    ArrayList branchGroupPaths = new ArrayList(1);
    BackgroundRetained geometryBackground = null;
    GroupRetained parentTransformLink = null;
    GroupRetained parentSwitchLink = null;

    NodeRetained() {
        this.localBounds = new BoundingBox();
        ((BoundingBox)this.localBounds).setUpper(-1.0, -1.0, -1.0);
        ((BoundingBox)this.localBounds).setLower(1.0, 1.0, 1.0);
    }

    void clearLive(SetLiveState setLiveState) {
        this.refCount -= setLiveState.refCount;
        if (this.refCount <= 0) {
            super.clearLive();
            if (this.nodeId != null) {
                this.universe.nodeIdFreeList.addElement(this.nodeId);
                this.nodeId = null;
            }
        }
        --this.universe.numNodes;
        if (this.inSharedGroup) {
            if (this.nodeType != 24) {
                this.removeLocalToVworld(setLiveState.keys);
            } else {
                this.removeLocalToVworldForTG(setLiveState.keys);
            }
        } else {
            this.branchGroupPaths.clear();
        }
        this.locale = null;
        this.geometryBackground = null;
    }

    void computeCombineBounds(Bounds bounds) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void computeLocalToVworld(NodeRetained nodeRetained, NodeRetained nodeRetained2, HashKey hashKey, Transform3D transform3D) {
        if (nodeRetained2 instanceof SharedGroupRetained) {
            String string = hashKey.getLastNodeId();
            SharedGroupRetained sharedGroupRetained = (SharedGroupRetained)nodeRetained2;
            int n = 0;
            while (n < sharedGroupRetained.parents.size()) {
                if (string.equals(((NodeRetained)sharedGroupRetained.parents.elementAt((int)n)).nodeId)) {
                    this.computeLocalToVworld(nodeRetained, (NodeRetained)sharedGroupRetained.parents.elementAt(n), hashKey, transform3D);
                    return;
                }
                ++n;
            }
            throw new RuntimeException(J3dI18N.getString("NodeRetained4"));
        }
        Object object = nodeRetained2.getParent();
        if (object == null) {
            if (((BranchGroupRetained)nodeRetained2).locale == null) throw new RuntimeException(J3dI18N.getString("NodeRetained5"));
            transform3D.setIdentity();
        } else {
            this.computeLocalToVworld(nodeRetained, (NodeRetained)object, hashKey, transform3D);
        }
        if (!(nodeRetained2 instanceof TransformGroupRetained) || nodeRetained2 == nodeRetained) return;
        object = VirtualUniverse.mc.getTransform3D(null);
        ((TransformGroupRetained)nodeRetained2).transform.getWithLock((Transform3D)object);
        transform3D.mul((Transform3D)object);
        VirtualUniverse.mc.addToTransformFreeList((Transform3D)object);
    }

    void doSetLive(SetLiveState setLiveState) {
        int n = this.refCount;
        this.refCount += setLiveState.refCount;
        if (this.universe != null && this.universe != setLiveState.universe) {
            throw new IllegalSharingException(J3dI18N.getString("NodeRetained3"));
        }
        if (setLiveState.locale == null) {
            System.out.println("NodeRetained.setLive() locale is null");
        }
        this.locale = setLiveState.locale;
        this.inSharedGroup = setLiveState.inSharedGroup;
        this.inOrderedGroup = setLiveState.inOrderedGroup;
        this.universe = setLiveState.universe;
        ++setLiveState.universe.numNodes;
        this.parentTransformLink = setLiveState.parentTransformLink;
        this.parentSwitchLink = setLiveState.parentSwitchLink;
        int n2 = 0;
        while (n2 < setLiveState.pickable.length) {
            if (!this.pickable) {
                setLiveState.pickable[n2] = false;
            }
            if (!this.collidable) {
                setLiveState.collidable[n2] = false;
            }
            ++n2;
        }
        if (n <= 0) {
            super.doSetLive(setLiveState);
        }
        if (this.inBackgroundGroup) {
            this.geometryBackground = setLiveState.geometryBackground;
        }
        if (this.nodeType != 24) {
            if (!this.inSharedGroup) {
                this.setLocalToVworld(setLiveState.currentTransforms[0], setLiveState.lastTransforms[0], setLiveState.parentTransformGroups[0], null, setLiveState.branchGroupPaths.get(0));
            } else {
                n2 = 0;
                while (n2 < setLiveState.keys.length) {
                    this.setLocalToVworld(setLiveState.currentTransforms[n2], setLiveState.lastTransforms[n2], setLiveState.parentTransformGroups[n2], setLiveState.keys[n2], setLiveState.branchGroupPaths.get(n2));
                    ++n2;
                }
            }
        }
    }

    void findCollidableFlags(boolean[] blArray) {
        NodeRetained nodeRetained = this;
        if (!this.inSharedGroup) {
            blArray[0] = true;
            nodeRetained = nodeRetained.parent;
            while (nodeRetained != null) {
                if (!nodeRetained.collidable) {
                    blArray[0] = false;
                    break;
                }
                nodeRetained = nodeRetained.parent;
            }
        } else {
            int n = 0;
            while (n < blArray.length) {
                block12: {
                    nodeRetained = this;
                    blArray[n] = true;
                    HashKey hashKey = new HashKey(this.localToVworldKeys[n]);
                    do {
                        if (nodeRetained instanceof SharedGroupRetained) {
                            String string = hashKey.getLastNodeId();
                            Vector vector = ((SharedGroupRetained)nodeRetained).parents;
                            int n2 = vector.size();
                            NodeRetained nodeRetained2 = nodeRetained;
                            int n3 = 0;
                            while (n3 < n2) {
                                NodeRetained nodeRetained3 = (NodeRetained)vector.elementAt(n3);
                                if (nodeRetained3.nodeId.equals(string)) {
                                    nodeRetained = nodeRetained3;
                                    break;
                                }
                                ++n3;
                            }
                            if (nodeRetained == nodeRetained2) {
                                return;
                            }
                        } else {
                            nodeRetained = nodeRetained.parent;
                        }
                        if (nodeRetained == null) break block12;
                    } while (nodeRetained.collidable);
                    blArray[n] = false;
                }
                ++n;
            }
        }
    }

    void findPickableFlags(boolean[] blArray) {
        NodeRetained nodeRetained = this;
        if (!this.inSharedGroup) {
            blArray[0] = true;
            nodeRetained = nodeRetained.parent;
            while (nodeRetained != null) {
                if (!nodeRetained.pickable) {
                    blArray[0] = false;
                    break;
                }
                nodeRetained = nodeRetained.parent;
            }
        } else {
            int n = 0;
            while (n < blArray.length) {
                block12: {
                    nodeRetained = this;
                    blArray[n] = true;
                    HashKey hashKey = new HashKey(this.localToVworldKeys[n]);
                    do {
                        if (nodeRetained instanceof SharedGroupRetained) {
                            String string = hashKey.getLastNodeId();
                            Vector vector = ((SharedGroupRetained)nodeRetained).parents;
                            int n2 = vector.size();
                            NodeRetained nodeRetained2 = nodeRetained;
                            int n3 = 0;
                            while (n3 < n2) {
                                NodeRetained nodeRetained3 = (NodeRetained)vector.elementAt(n3);
                                if (nodeRetained3.nodeId.equals(string)) {
                                    nodeRetained = nodeRetained3;
                                    break;
                                }
                                ++n3;
                            }
                            if (nodeRetained2 == nodeRetained) {
                                return;
                            }
                        } else {
                            nodeRetained = nodeRetained.parent;
                        }
                        if (nodeRetained == null) break block12;
                    } while (nodeRetained.pickable);
                    blArray[n] = false;
                }
                ++n;
            }
        }
    }

    Bounds getBounds() {
        if (this.localBounds != null) {
            return (Bounds)this.localBounds.clone();
        }
        return null;
    }

    boolean getBoundsAutoCompute() {
        return this.boundsAutoCompute;
    }

    boolean getCollidable() {
        return this.collidable;
    }

    Transform3D getCurrentChildLocalToVworld(HashKey hashKey) {
        TransformGroupRetained transformGroupRetained = (TransformGroupRetained)this;
        if (!this.inSharedGroup) {
            return transformGroupRetained.currentChildLocalToVworld[0];
        }
        int n = this.localToVworldKeys.length - 1;
        while (n >= 0) {
            if (this.localToVworldKeys[n].equals(hashKey)) {
                return transformGroupRetained.currentChildLocalToVworld[n];
            }
            --n;
        }
        return new Transform3D();
    }

    Transform3D getCurrentLocalToVworld(HashKey hashKey) {
        if (this.currentLocalToVworld != null) {
            if (!this.inSharedGroup) {
                return this.currentLocalToVworld[0];
            }
            int n = this.localToVworldKeys.length - 1;
            while (n >= 0) {
                if (this.localToVworldKeys[n].equals(hashKey)) {
                    return this.currentLocalToVworld[n];
                }
                --n;
            }
        }
        return new Transform3D();
    }

    Transform3D getLastChildLocalToVworld(HashKey hashKey) {
        TransformGroupRetained transformGroupRetained = (TransformGroupRetained)this;
        if (!this.inSharedGroup) {
            return transformGroupRetained.lastChildLocalToVworld[0];
        }
        int n = this.localToVworldKeys.length - 1;
        while (n >= 0) {
            if (this.localToVworldKeys[n].equals(hashKey)) {
                return transformGroupRetained.lastChildLocalToVworld[n];
            }
            --n;
        }
        return new Transform3D();
    }

    Transform3D getLastLocalToVworld(HashKey hashKey) {
        if (this.lastLocalToVworld != null) {
            if (!this.inSharedGroup) {
                return this.lastLocalToVworld[0];
            }
            int n = this.localToVworldKeys.length - 1;
            while (n >= 0) {
                if (this.localToVworldKeys[n].equals(hashKey)) {
                    return this.lastLocalToVworld[n];
                }
                --n;
            }
        }
        return new Transform3D();
    }

    void getLocalToVworld(SceneGraphPath sceneGraphPath, Transform3D transform3D) {
        HashKey hashKey = new HashKey("");
        if (!this.inSharedGroup) {
            throw new IllegalSharingException(J3dI18N.getString("NodeRetained1"));
        }
        sceneGraphPath.validate(hashKey);
        this.computeLocalToVworld(this, this, hashKey, transform3D);
    }

    void getLocalToVworld(Transform3D transform3D) {
        if (this.inSharedGroup) {
            throw new IllegalSharingException(J3dI18N.getString("NodeRetained0"));
        }
        if (this.currentLocalToVworld[0] == null) {
            transform3D.setIdentity();
        } else {
            this.computeLocalToVworld(this, this, null, transform3D);
        }
    }

    void getLocalToVworld(Transform3D transform3D, HashKey hashKey) {
        HashKey hashKey2 = new HashKey(hashKey);
        this.computeLocalToVworld(this, this, hashKey2, transform3D);
    }

    NodeRetained getParent() {
        return this.parent;
    }

    boolean getPickable() {
        return this.pickable;
    }

    void notifySceneGraphChanged(boolean bl) {
    }

    void recombineAbove() {
    }

    void removeLocalToVworld(HashKey[] hashKeyArray) {
        Transform3D[] transform3DArray = null;
        Transform3D[] transform3DArray2 = null;
        HashKey[] hashKeyArray2 = null;
        ArrayList[] arrayListArray = null;
        Object var8_6 = null;
        Object var9_7 = null;
        int n = 0;
        if (hashKeyArray.length == this.currentLocalToVworld.length) {
            this.currentLocalToVworld = null;
            this.lastLocalToVworld = null;
            this.localToVworldKeys = null;
            this.parentTransformGroups = null;
            this.branchGroupPaths.clear();
            return;
        }
        transform3DArray = new Transform3D[this.currentLocalToVworld.length - hashKeyArray.length];
        transform3DArray2 = new Transform3D[this.currentLocalToVworld.length - hashKeyArray.length];
        hashKeyArray2 = new HashKey[this.currentLocalToVworld.length - hashKeyArray.length];
        arrayListArray = new ArrayList[this.currentLocalToVworld.length - hashKeyArray.length];
        ArrayList arrayList = new ArrayList();
        int n2 = 0;
        while (n2 < this.currentLocalToVworld.length) {
            int n3 = 0;
            while (n3 < hashKeyArray.length) {
                HashKey hashKey = hashKeyArray[n3];
                if (!this.localToVworldKeys[n2].equals(hashKey)) {
                    transform3DArray[n] = this.currentLocalToVworld[n2];
                    transform3DArray2[n] = this.lastLocalToVworld[n2];
                    hashKeyArray2[n] = this.localToVworldKeys[n2];
                    arrayListArray[n] = this.parentTransformGroups[n2];
                    arrayList.add(this.branchGroupPaths.get(n2));
                    ++n;
                    break;
                }
                ++n3;
            }
            ++n2;
        }
        this.currentLocalToVworld = transform3DArray;
        this.lastLocalToVworld = transform3DArray2;
        this.localToVworldKeys = hashKeyArray2;
        this.parentTransformGroups = arrayListArray;
        this.branchGroupPaths = arrayList;
    }

    void removeLocalToVworldForTG(HashKey[] hashKeyArray) {
        Transform3D[] transform3DArray = null;
        Transform3D[] transform3DArray2 = null;
        HashKey[] hashKeyArray2 = null;
        ArrayList[] arrayListArray = null;
        Transform3D[] transform3DArray3 = null;
        Transform3D[] transform3DArray4 = null;
        TransformGroupRetained transformGroupRetained = (TransformGroupRetained)this;
        int n = 0;
        if (hashKeyArray.length == this.currentLocalToVworld.length) {
            this.currentLocalToVworld = null;
            this.lastLocalToVworld = null;
            this.localToVworldKeys = null;
            transformGroupRetained.isDirty = null;
            this.parentTransformGroups = null;
            transformGroupRetained.currentChildLocalToVworld = null;
            transformGroupRetained.lastChildLocalToVworld = null;
            this.branchGroupPaths.clear();
            return;
        }
        transform3DArray = new Transform3D[this.currentLocalToVworld.length - hashKeyArray.length];
        transform3DArray2 = new Transform3D[this.currentLocalToVworld.length - hashKeyArray.length];
        hashKeyArray2 = new HashKey[this.currentLocalToVworld.length - hashKeyArray.length];
        arrayListArray = new ArrayList[this.currentLocalToVworld.length - hashKeyArray.length];
        transformGroupRetained.isDirty = new boolean[this.currentLocalToVworld.length - hashKeyArray.length];
        transform3DArray3 = new Transform3D[this.currentLocalToVworld.length - 1];
        transform3DArray4 = new Transform3D[this.currentLocalToVworld.length - 1];
        ArrayList arrayList = new ArrayList();
        int n2 = 0;
        while (n2 < this.currentLocalToVworld.length) {
            int n3 = 0;
            while (n3 < hashKeyArray.length) {
                HashKey hashKey = hashKeyArray[n3];
                if (!this.localToVworldKeys[n2].equals(hashKey)) {
                    transform3DArray[n] = this.currentLocalToVworld[n2];
                    transform3DArray2[n] = this.lastLocalToVworld[n2];
                    hashKeyArray2[n] = this.localToVworldKeys[n2];
                    arrayListArray[n] = this.parentTransformGroups[n2];
                    transform3DArray3[n] = transformGroupRetained.currentChildLocalToVworld[n2];
                    transform3DArray4[n] = transformGroupRetained.lastChildLocalToVworld[n2];
                    arrayList.add(this.branchGroupPaths.get(n2));
                    ++n;
                    break;
                }
                ++n3;
            }
            ++n2;
        }
        this.currentLocalToVworld = transform3DArray;
        this.lastLocalToVworld = transform3DArray2;
        this.localToVworldKeys = hashKeyArray2;
        this.parentTransformGroups = arrayListArray;
        transformGroupRetained.currentChildLocalToVworld = transform3DArray3;
        transformGroupRetained.lastChildLocalToVworld = transform3DArray4;
        this.branchGroupPaths = arrayList;
    }

    void setBounds(Bounds bounds) {
        if (this.source.isLive()) {
            if (!this.boundsAutoCompute) {
                this.localBounds = bounds != null ? (Bounds)bounds.clone() : null;
            }
        } else {
            this.localBounds = bounds != null ? (Bounds)bounds.clone() : null;
        }
    }

    void setBoundsAutoCompute(boolean bl) {
        this.boundsAutoCompute = bl;
    }

    void setCollidable(boolean bl) {
        if (this.collidable == bl) {
            return;
        }
        this.collidable = bl;
        if (this.source.isLive()) {
            Object object = this.universe.sceneGraphLock;
            synchronized (object) {
                boolean[] blArray = !this.inSharedGroup ? new boolean[1] : new boolean[this.localToVworldKeys.length];
                this.findCollidableFlags(blArray);
                this.updateCollidable(this.localToVworldKeys, blArray);
            }
        }
    }

    void setLive(SetLiveState setLiveState) {
        int n = this.refCount;
        this.doSetLive(setLiveState);
        if (n <= 0) {
            super.markAsLive();
        }
    }

    void setLocalToVworld(Transform3D transform3D, Transform3D transform3D2, ArrayList arrayList, HashKey hashKey, Object object) {
        Transform3D[] transform3DArray = null;
        Transform3D[] transform3DArray2 = null;
        HashKey[] hashKeyArray = null;
        ArrayList[] arrayListArray = null;
        if (this.currentLocalToVworld == null) {
            this.currentLocalToVworld = new Transform3D[1];
            this.lastLocalToVworld = new Transform3D[1];
            this.parentTransformGroups = new ArrayList[1];
            if (this.inSharedGroup) {
                this.localToVworldKeys = new HashKey[1];
                this.localToVworldKeys[0] = hashKey;
            }
        }
        if (!this.inSharedGroup) {
            this.currentLocalToVworld[0] = transform3D;
            this.lastLocalToVworld[0] = transform3D2;
            this.parentTransformGroups[0] = (ArrayList)arrayList.clone();
            this.branchGroupPaths.add(object);
        } else {
            int n = 0;
            while (n < this.currentLocalToVworld.length) {
                if (this.localToVworldKeys[n].equals(hashKey)) break;
                ++n;
            }
            if (n == this.currentLocalToVworld.length) {
                transform3DArray = new Transform3D[this.currentLocalToVworld.length + 1];
                transform3DArray2 = new Transform3D[this.currentLocalToVworld.length + 1];
                hashKeyArray = new HashKey[this.currentLocalToVworld.length + 1];
                arrayListArray = new ArrayList[this.currentLocalToVworld.length + 1];
                n = 0;
                while (n < this.currentLocalToVworld.length) {
                    transform3DArray[n] = this.currentLocalToVworld[n];
                    transform3DArray2[n] = this.lastLocalToVworld[n];
                    hashKeyArray[n] = this.localToVworldKeys[n];
                    arrayListArray[n] = this.parentTransformGroups[n];
                    ++n;
                }
                this.currentLocalToVworld = transform3DArray;
                this.lastLocalToVworld = transform3DArray2;
                this.localToVworldKeys = hashKeyArray;
                this.parentTransformGroups = arrayListArray;
                this.localToVworldKeys[n] = hashKey;
            }
            this.currentLocalToVworld[n] = transform3D;
            this.lastLocalToVworld[n] = transform3D2;
            this.parentTransformGroups[n] = (ArrayList)arrayList.clone();
            if (n >= this.branchGroupPaths.size()) {
                this.branchGroupPaths.add(object);
            } else {
                this.branchGroupPaths.set(n, object);
            }
        }
    }

    void setLocalToVworld(Transform3D transform3D, Transform3D transform3D2, ArrayList arrayList, Transform3D transform3D3, Transform3D transform3D4, HashKey hashKey, Object object) {
        Transform3D[] transform3DArray = null;
        Transform3D[] transform3DArray2 = null;
        Transform3D[] transform3DArray3 = null;
        Transform3D[] transform3DArray4 = null;
        HashKey[] hashKeyArray = null;
        ArrayList[] arrayListArray = null;
        TransformGroupRetained transformGroupRetained = (TransformGroupRetained)this;
        if (this.currentLocalToVworld == null) {
            this.currentLocalToVworld = new Transform3D[1];
            this.lastLocalToVworld = new Transform3D[1];
            this.parentTransformGroups = new ArrayList[1];
            transformGroupRetained.currentChildLocalToVworld = new Transform3D[1];
            transformGroupRetained.lastChildLocalToVworld = new Transform3D[1];
            if (this.inSharedGroup) {
                this.localToVworldKeys = new HashKey[1];
                this.localToVworldKeys[0] = hashKey;
                transformGroupRetained.isDirty = new boolean[1];
            }
        }
        if (!this.inSharedGroup) {
            this.currentLocalToVworld[0] = transform3D;
            this.lastLocalToVworld[0] = transform3D2;
            this.parentTransformGroups[0] = (ArrayList)arrayList.clone();
            transformGroupRetained.currentChildLocalToVworld[0] = transform3D3;
            transformGroupRetained.lastChildLocalToVworld[0] = transform3D4;
            this.branchGroupPaths.add(object);
        } else {
            int n = 0;
            while (n < this.currentLocalToVworld.length) {
                if (this.localToVworldKeys[n].equals(hashKey)) break;
                ++n;
            }
            if (n == this.currentLocalToVworld.length) {
                transform3DArray = new Transform3D[this.currentLocalToVworld.length + 1];
                transform3DArray2 = new Transform3D[this.currentLocalToVworld.length + 1];
                hashKeyArray = new HashKey[this.currentLocalToVworld.length + 1];
                arrayListArray = new ArrayList[this.currentLocalToVworld.length + 1];
                transform3DArray3 = new Transform3D[this.currentLocalToVworld.length + 1];
                transform3DArray4 = new Transform3D[this.currentLocalToVworld.length + 1];
                transformGroupRetained.isDirty = new boolean[this.currentLocalToVworld.length + 1];
                n = 0;
                while (n < this.currentLocalToVworld.length) {
                    transform3DArray[n] = this.currentLocalToVworld[n];
                    transform3DArray2[n] = this.lastLocalToVworld[n];
                    hashKeyArray[n] = this.localToVworldKeys[n];
                    arrayListArray[n] = this.parentTransformGroups[n];
                    transform3DArray3[n] = transformGroupRetained.currentChildLocalToVworld[n];
                    transform3DArray4[n] = transformGroupRetained.lastChildLocalToVworld[n];
                    ++n;
                }
                this.currentLocalToVworld = transform3DArray;
                this.lastLocalToVworld = transform3DArray2;
                this.localToVworldKeys = hashKeyArray;
                this.parentTransformGroups = arrayListArray;
                this.localToVworldKeys[n] = hashKey;
                transformGroupRetained.currentChildLocalToVworld = transform3DArray3;
                transformGroupRetained.lastChildLocalToVworld = transform3DArray4;
            }
            this.currentLocalToVworld[n] = transform3D;
            this.lastLocalToVworld[n] = transform3D2;
            this.parentTransformGroups[n] = (ArrayList)arrayList.clone();
            transformGroupRetained.currentChildLocalToVworld[n] = transform3D3;
            transformGroupRetained.lastChildLocalToVworld[n] = transform3D4;
            if (n >= this.branchGroupPaths.size()) {
                this.branchGroupPaths.add(object);
            } else {
                this.branchGroupPaths.set(n, object);
            }
        }
    }

    void setParent(NodeRetained nodeRetained) {
        this.parent = nodeRetained;
    }

    void setPickable(boolean bl) {
        if (this.pickable == bl) {
            return;
        }
        this.pickable = bl;
        if (this.source.isLive()) {
            Object object = this.universe.sceneGraphLock;
            synchronized (object) {
                boolean[] blArray = !this.inSharedGroup ? new boolean[1] : new boolean[this.localToVworldKeys.length];
                this.findPickableFlags(blArray);
                this.updatePickable(this.localToVworldKeys, blArray);
            }
        }
    }

    void transformBounds(SceneGraphPath sceneGraphPath, Bounds bounds) {
        if (!((NodeRetained)sceneGraphPath.item.retained).inSharedGroup) {
            bounds.transform(this.currentLocalToVworld[0]);
        } else {
            HashKey hashKey = new HashKey("");
            sceneGraphPath.getHashKey(hashKey);
            Transform3D transform3D = VirtualUniverse.mc.getTransform3D(null);
            this.getLocalToVworld(transform3D, hashKey);
            bounds.transform(transform3D);
            VirtualUniverse.mc.addToTransformFreeList(transform3D);
        }
    }

    void updateCollidable(HashKey[] hashKeyArray, boolean[] blArray) {
        int n = 0;
        while (n < blArray.length) {
            if (!this.collidable) {
                blArray[n] = false;
            }
            ++n;
        }
    }

    synchronized void updateLocalToVworld() {
    }

    void updatePickable(HashKey[] hashKeyArray, boolean[] blArray) {
        int n = 0;
        while (n < blArray.length) {
            if (!this.pickable) {
                blArray[n] = false;
            }
            ++n;
        }
    }
}

