/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import javax.media.j3d.BoundingLeaf;
import javax.media.j3d.BoundingLeafRetained;
import javax.media.j3d.Bounds;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.ContainsNodes;
import javax.media.j3d.Group;
import javax.media.j3d.GroupRetained;
import javax.media.j3d.HashKey;
import javax.media.j3d.IllegalSharingException;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.LeafRetained;
import javax.media.j3d.Node;
import javax.media.j3d.SceneGraphObject;
import javax.media.j3d.SetLiveState;
import javax.media.j3d.Shape3DRetained;
import javax.media.j3d.Transform3D;
import javax.media.j3d.VirtualUniverse;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple4d;
import javax.vecmath.Vector4d;

class ModelClipRetained
extends LeafRetained {
    static final int PLANE_CHANGED = 1;
    static final int PLANES_CHANGED = 2;
    static final int ENABLE_CHANGED = 4;
    static final int ENABLES_CHANGED = 8;
    static final int BOUNDS_CHANGED = 16;
    static final int BOUNDINGLEAF_CHANGED = 32;
    static final int SCOPE_CHANGED = 64;
    static final int LAST_DEFINED_BIT = 64;
    Vector4d[] planes = new Vector4d[6];
    boolean[] enables = new boolean[6];
    boolean enableFlag = false;
    Bounds regionOfInfluence = null;
    BoundingLeafRetained boundingLeaf = null;
    Bounds region = null;
    Vector scopes = new Vector();
    boolean isScoped = false;
    HashKey tempKey = new HashKey(250);
    boolean inImmCtx = false;
    ModelClipRetained mirrorModelClip = null;
    ModelClipRetained sgModelClip = null;
    static final int targetThreads = 4224;
    ArrayList environmentSets = new ArrayList();

    ModelClipRetained() {
        this.planes[0] = new Vector4d(1.0, 0.0, 0.0, -1.0);
        this.planes[1] = new Vector4d(-1.0, 0.0, 0.0, -1.0);
        this.planes[2] = new Vector4d(0.0, 1.0, 0.0, -1.0);
        this.planes[3] = new Vector4d(0.0, -1.0, 0.0, -1.0);
        this.planes[4] = new Vector4d(0.0, 0.0, 1.0, -1.0);
        this.planes[5] = new Vector4d(0.0, 0.0, -1.0, -1.0);
        this.enables[5] = true;
        this.enables[4] = true;
        this.enables[3] = true;
        this.enables[2] = true;
        this.enables[1] = true;
        this.enables[0] = true;
    }

    void addScope(Group group) {
        Object[] objectArray = new Object[3];
        ArrayList arrayList = new ArrayList();
        GroupRetained groupRetained = (GroupRetained)group.retained;
        this.initAddScope(group);
        this.tempKey.reset();
        groupRetained.getAllScopedNodes(arrayList, this.tempKey);
        objectArray[0] = arrayList;
        objectArray[1] = null;
        objectArray[2] = this.scopes.size() > 0 ? Boolean.TRUE : Boolean.FALSE;
        this.sendMessage(64, objectArray, null);
    }

    void clearLive(SetLiveState setLiveState) {
        super.clearLive(setLiveState);
        setLiveState.notifyThreads |= 0x1080;
        if (this.mirrorModelClip.boundingLeaf != null) {
            this.mirrorModelClip.boundingLeaf.removeUser(this.mirrorModelClip);
        }
        setLiveState.nodeList.add(this.mirrorModelClip);
    }

    protected Object clone() {
        ModelClipRetained modelClipRetained = (ModelClipRetained)super.clone();
        modelClipRetained.planes = new Vector4d[6];
        modelClipRetained.planes[0] = new Vector4d(this.planes[0]);
        modelClipRetained.planes[1] = new Vector4d(this.planes[1]);
        modelClipRetained.planes[2] = new Vector4d(this.planes[2]);
        modelClipRetained.planes[3] = new Vector4d(this.planes[3]);
        modelClipRetained.planes[4] = new Vector4d(this.planes[4]);
        modelClipRetained.planes[5] = new Vector4d(this.planes[5]);
        modelClipRetained.enables = new boolean[6];
        this.getEnables(modelClipRetained.enables);
        modelClipRetained.inImmCtx = false;
        modelClipRetained.region = null;
        modelClipRetained.sgModelClip = null;
        modelClipRetained.mirrorModelClip = null;
        modelClipRetained.environmentSets = new ArrayList();
        if (this.regionOfInfluence != null) {
            modelClipRetained.regionOfInfluence = (Bounds)this.regionOfInfluence.clone();
        }
        return modelClipRetained;
    }

    Enumeration getAllScopes() {
        Enumeration enumeration = this.scopes.elements();
        Vector<SceneGraphObject> vector = new Vector<SceneGraphObject>(this.scopes.size());
        while (enumeration.hasMoreElements()) {
            vector.add(((GroupRetained)enumeration.nextElement()).source);
        }
        return vector.elements();
    }

    boolean getEnable(int n) {
        if (n < 0 || n > 5) {
            throw new IllegalArgumentException(J3dI18N.getString("ModelClip6"));
        }
        return this.enables[n];
    }

    void getEnables(boolean[] blArray) {
        blArray[0] = this.enables[0];
        blArray[1] = this.enables[1];
        blArray[2] = this.enables[2];
        blArray[3] = this.enables[3];
        blArray[4] = this.enables[4];
        blArray[5] = this.enables[5];
    }

    boolean getInImmCtx() {
        return this.inImmCtx;
    }

    BoundingLeaf getInfluencingBoundingLeaf() {
        return this.boundingLeaf != null ? (BoundingLeaf)this.boundingLeaf.source : null;
    }

    Bounds getInfluencingBounds() {
        return this.regionOfInfluence != null ? (Bounds)this.regionOfInfluence.clone() : null;
    }

    void getPlane(int n, Vector4d vector4d) {
        if (n < 0 || n > 5) {
            throw new IllegalArgumentException(J3dI18N.getString("ModelClip6"));
        }
        vector4d.set((Tuple4d)this.planes[n]);
    }

    void getPlanes(Vector4d[] vector4dArray) {
        vector4dArray[0].set((Tuple4d)this.planes[0]);
        vector4dArray[1].set((Tuple4d)this.planes[1]);
        vector4dArray[2].set((Tuple4d)this.planes[2]);
        vector4dArray[3].set((Tuple4d)this.planes[3]);
        vector4dArray[4].set((Tuple4d)this.planes[4]);
        vector4dArray[5].set((Tuple4d)this.planes[5]);
    }

    Group getScope(int n) {
        return (Group)((GroupRetained)this.scopes.elementAt((int)n)).source;
    }

    void initAddScope(Group group) {
        this.scopes.addElement((GroupRetained)group.retained);
    }

    synchronized void initEnable(int n, boolean bl) {
        if (n < 0 || n > 5) {
            throw new IllegalArgumentException(J3dI18N.getString("ModelClip6"));
        }
        this.enables[n] = bl;
    }

    synchronized void initEnables(boolean[] blArray) {
        this.enables[0] = blArray[0];
        this.enables[1] = blArray[1];
        this.enables[2] = blArray[2];
        this.enables[3] = blArray[3];
        this.enables[4] = blArray[4];
        this.enables[5] = blArray[5];
    }

    void initInfluencingBoundingLeaf(BoundingLeaf boundingLeaf) {
        this.boundingLeaf = boundingLeaf != null ? (BoundingLeafRetained)boundingLeaf.retained : null;
    }

    void initInfluencingBounds(Bounds bounds) {
        this.regionOfInfluence = bounds != null ? (Bounds)bounds.clone() : null;
    }

    void initInsertScope(Node node, int n) {
        this.scopes.insertElementAt((GroupRetained)node.retained, n);
    }

    synchronized void initMirrorObject() {
        this.mirrorModelClip.parent = this.parent;
        if (this.boundingLeaf != null) {
            if (this.mirrorModelClip.boundingLeaf != null) {
                this.mirrorModelClip.boundingLeaf.removeUser(this.mirrorModelClip);
            }
            this.mirrorModelClip.boundingLeaf = this.boundingLeaf.mirrorBoundingLeaf;
            this.mirrorModelClip.boundingLeaf.addUser(this.mirrorModelClip);
            this.region = this.mirrorModelClip.boundingLeaf.transformedRegion;
        } else {
            this.mirrorModelClip.boundingLeaf = null;
        }
        if (this.regionOfInfluence != null) {
            this.mirrorModelClip.regionOfInfluence = (Bounds)this.regionOfInfluence.clone();
            if (this.mirrorModelClip.region == null) {
                this.mirrorModelClip.region = (Bounds)this.mirrorModelClip.regionOfInfluence.clone();
                this.mirrorModelClip.region.transform(this.mirrorModelClip.regionOfInfluence, this.lastLocalToVworld[0]);
            }
        } else {
            this.mirrorModelClip.regionOfInfluence = null;
        }
        int n = 0;
        while (n < this.scopes.size()) {
            GroupRetained groupRetained = (GroupRetained)this.scopes.get(n);
            this.tempKey.reset();
            groupRetained.markAllNodesForScopedModelClip(this.mirrorModelClip, this.tempKey);
            ++n;
        }
        this.mirrorModelClip.isScoped = this.scopes.size() > 0;
        this.mirrorModelClip.enableFlag = this.mirrorModelClip.enables[0] | this.mirrorModelClip.enables[1] | this.mirrorModelClip.enables[2] | this.mirrorModelClip.enables[3] | this.mirrorModelClip.enables[4] | this.mirrorModelClip.enables[5];
        this.mirrorModelClip.sgModelClip = this;
    }

    synchronized void initPlane(int n, Vector4d vector4d) {
        if (n < 0 || n > 5) {
            throw new IllegalArgumentException(J3dI18N.getString("ModelClip6"));
        }
        this.planes[n].set((Tuple4d)vector4d);
    }

    synchronized void initPlanes(Vector4d[] vector4dArray) {
        this.planes[0].set((Tuple4d)vector4dArray[0]);
        this.planes[1].set((Tuple4d)vector4dArray[1]);
        this.planes[2].set((Tuple4d)vector4dArray[2]);
        this.planes[3].set((Tuple4d)vector4dArray[3]);
        this.planes[4].set((Tuple4d)vector4dArray[4]);
        this.planes[5].set((Tuple4d)vector4dArray[5]);
    }

    void initRemoveScope(int n) {
        this.scopes.removeElementAt(n);
    }

    void initScope(Group group, int n) {
        this.scopes.setElementAt((GroupRetained)group.retained, n);
    }

    void insertScope(Node node, int n) {
        Object[] objectArray = new Object[3];
        ArrayList arrayList = new ArrayList();
        this.scopes.insertElementAt((GroupRetained)node.retained, n);
        GroupRetained groupRetained = (GroupRetained)node.retained;
        this.tempKey.reset();
        groupRetained.getAllScopedNodes(arrayList, this.tempKey);
        objectArray[0] = arrayList;
        objectArray[1] = null;
        objectArray[2] = this.scopes.size() > 0 ? Boolean.TRUE : Boolean.FALSE;
        this.sendMessage(64, objectArray, null);
    }

    int numScopes() {
        return this.scopes.size();
    }

    void printEnables(String string, boolean[] blArray) {
        System.err.println(string);
        System.err.println("[0] : < " + blArray[0] + " >");
        System.err.println("[1] : < " + blArray[1] + " >");
        System.err.println("[2] : < " + blArray[2] + " >");
        System.err.println("[3] : < " + blArray[3] + " >");
        System.err.println("[4] : < " + blArray[4] + " >");
        System.err.println("[5] : < " + blArray[5] + " >");
    }

    void printPlanes(String string, Vector4d[] vector4dArray) {
        System.err.println(string);
        System.err.println("[0] : < " + vector4dArray[0].toString() + " >");
        System.err.println("[1] : < " + vector4dArray[1].toString() + " >");
        System.err.println("[2] : < " + vector4dArray[2].toString() + " >");
        System.err.println("[3] : < " + vector4dArray[3].toString() + " >");
        System.err.println("[4] : < " + vector4dArray[4].toString() + " >");
        System.err.println("[5] : < " + vector4dArray[5].toString() + " >");
    }

    void removeScope(int n) {
        Object[] objectArray = new Object[3];
        ArrayList arrayList = new ArrayList();
        GroupRetained groupRetained = (GroupRetained)this.scopes.elementAt(n);
        this.tempKey.reset();
        groupRetained.getAllScopedNodes(arrayList, this.tempKey);
        this.scopes.removeElementAt(n);
        objectArray[0] = null;
        objectArray[1] = arrayList;
        objectArray[2] = this.scopes.size() > 0 ? Boolean.TRUE : Boolean.FALSE;
        this.sendMessage(64, objectArray, null);
    }

    final void sendMessage(int n, Object object, Object object2) {
        J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
        j3dMessage.threads = 4224;
        j3dMessage.type = 36;
        j3dMessage.universe = this.universe;
        j3dMessage.args[0] = this;
        j3dMessage.args[1] = new Integer(n);
        j3dMessage.args[2] = object;
        j3dMessage.args[3] = object2;
        VirtualUniverse.mc.processMessage(j3dMessage);
    }

    synchronized void setEnable(int n, boolean bl) {
        this.initEnable(n, bl);
        this.sendMessage(4, new Integer(n), bl ? Boolean.TRUE : Boolean.FALSE);
    }

    synchronized void setEnables(boolean[] blArray) {
        Boolean[] booleanArray = new Boolean[6];
        this.initEnables(blArray);
        booleanArray[0] = blArray[0] ? Boolean.TRUE : Boolean.FALSE;
        booleanArray[1] = blArray[1] ? Boolean.TRUE : Boolean.FALSE;
        booleanArray[2] = blArray[2] ? Boolean.TRUE : Boolean.FALSE;
        booleanArray[3] = blArray[3] ? Boolean.TRUE : Boolean.FALSE;
        booleanArray[4] = blArray[4] ? Boolean.TRUE : Boolean.FALSE;
        booleanArray[5] = blArray[5] ? Boolean.TRUE : Boolean.FALSE;
        this.sendMessage(8, booleanArray, null);
    }

    void setInImmCtx(boolean bl) {
        this.inImmCtx = bl;
    }

    void setInfluencingBoundingLeaf(BoundingLeaf boundingLeaf) {
        if (this.boundingLeaf != null) {
            this.boundingLeaf.mirrorBoundingLeaf.removeUser(this.mirrorModelClip);
        }
        if (boundingLeaf != null) {
            this.boundingLeaf = (BoundingLeafRetained)boundingLeaf.retained;
            this.boundingLeaf.mirrorBoundingLeaf.addUser(this.mirrorModelClip);
        } else {
            this.boundingLeaf = null;
        }
        this.sendMessage(32, this.boundingLeaf != null ? this.boundingLeaf.mirrorBoundingLeaf : null, null);
    }

    void setInfluencingBounds(Bounds bounds) {
        this.initInfluencingBounds(bounds);
        this.sendMessage(16, bounds != null ? (Bounds)bounds.clone() : null, null);
    }

    void setLive(SetLiveState setLiveState) {
        if (this.inImmCtx) {
            throw new IllegalSharingException(J3dI18N.getString("ModelClipRetained7"));
        }
        super.doSetLive(setLiveState);
        if (this.inBackgroundGroup) {
            throw new IllegalSharingException(J3dI18N.getString("ModelClipRetained0"));
        }
        if (this.mirrorModelClip == null) {
            this.mirrorModelClip = (ModelClipRetained)this.clone();
            this.mirrorModelClip.boundingLeaf = null;
            this.mirrorModelClip.sgModelClip = this;
        }
        this.initMirrorObject();
        setLiveState.nodeList.add(this.mirrorModelClip);
        if (setLiveState.inSharedGroup) {
            int n = 0;
            while (n < setLiveState.keys.length) {
                if (setLiveState.switchLevels[n] >= 0) {
                    this.mirrorModelClip.clearCompositeSwitchMask();
                    this.mirrorModelClip.isNewSwitchLeaf = true;
                    ContainsNodes containsNodes = setLiveState.containsNodesList.getContainsNodes(setLiveState.keys[n]);
                    containsNodes.envNodes.add(this.mirrorModelClip);
                }
                ++n;
            }
        } else if (setLiveState.switchLevels[0] >= 0) {
            this.mirrorModelClip.clearCompositeSwitchMask();
            this.mirrorModelClip.isNewSwitchLeaf = true;
            ContainsNodes containsNodes = setLiveState.containsNodesList.getContainsNodes(0);
            containsNodes.envNodes.add(this.mirrorModelClip);
        }
        if (setLiveState.transformTargets != null) {
            setLiveState.transformTargets.add(this.mirrorModelClip);
            setLiveState.transformTargetThreads |= 0x1080;
        }
        setLiveState.notifyThreads |= 0x1080;
        super.markAsLive();
    }

    synchronized void setPlane(int n, Vector4d vector4d) {
        this.initPlane(n, vector4d);
        this.sendMessage(1, new Integer(n), new Vector4d(vector4d));
    }

    synchronized void setPlanes(Vector4d[] vector4dArray) {
        Vector4d[] vector4dArray2 = new Vector4d[6];
        this.initPlanes(vector4dArray);
        vector4dArray2[0] = new Vector4d(vector4dArray[0]);
        vector4dArray2[1] = new Vector4d(vector4dArray[1]);
        vector4dArray2[2] = new Vector4d(vector4dArray[2]);
        vector4dArray2[3] = new Vector4d(vector4dArray[3]);
        vector4dArray2[4] = new Vector4d(vector4dArray[4]);
        vector4dArray2[5] = new Vector4d(vector4dArray[5]);
        this.sendMessage(2, vector4dArray2, null);
    }

    void setScope(Group group, int n) {
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        Object[] objectArray = new Object[3];
        GroupRetained groupRetained = (GroupRetained)this.scopes.get(n);
        this.tempKey.reset();
        groupRetained.getAllScopedNodes(arrayList2, this.tempKey);
        groupRetained = (GroupRetained)group.retained;
        this.initScope(group, n);
        this.tempKey.reset();
        groupRetained.getAllScopedNodes(arrayList, this.tempKey);
        objectArray[0] = arrayList;
        objectArray[1] = arrayList2;
        objectArray[2] = this.scopes.size() > 0 ? Boolean.TRUE : Boolean.FALSE;
        this.sendMessage(64, objectArray, null);
    }

    native void update(int var1, int var2, boolean var3, double var4, double var6, double var8, double var10);

    void update(int n, Transform3D transform3D) {
        if (!VirtualUniverse.mc.isD3D()) {
            this.update(n, 0, this.enables[0], this.planes[0].x, this.planes[0].y, this.planes[0].z, this.planes[0].w);
            this.update(n, 1, this.enables[1], this.planes[1].x, this.planes[1].y, this.planes[1].z, this.planes[1].w);
            this.update(n, 2, this.enables[2], this.planes[2].x, this.planes[2].y, this.planes[2].z, this.planes[2].w);
            this.update(n, 3, this.enables[3], this.planes[3].x, this.planes[3].y, this.planes[3].z, this.planes[3].w);
            this.update(n, 4, this.enables[4], this.planes[4].x, this.planes[4].y, this.planes[4].z, this.planes[4].w);
            this.update(n, 5, this.enables[5], this.planes[5].x, this.planes[5].y, this.planes[5].z, this.planes[5].w);
            return;
        }
        Transform3D transform3D2 = VirtualUniverse.mc.getTransform3D(null);
        transform3D2.invert(transform3D);
        transform3D2.transpose();
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        int n2 = 0;
        while (n2 < 6) {
            if (this.enables[n2]) {
                if (this.planes[n2].x != 0.0) {
                    d = -this.planes[n2].w / this.planes[n2].x;
                } else if (this.planes[n2].y != 0.0) {
                    d2 = -this.planes[n2].w / this.planes[n2].y;
                } else if (this.planes[n2].z != 0.0) {
                    d3 = -this.planes[n2].w / this.planes[n2].z;
                }
                Vector4d vector4d = new Vector4d(this.planes[n2].x, this.planes[n2].y, this.planes[n2].z, 0.0);
                vector4d.normalize();
                transform3D2.transform(vector4d);
                Point3d point3d = new Point3d(d, d2, d3);
                transform3D.transform(point3d);
                this.update(n, n2, true, vector4d.x, vector4d.y, vector4d.z, -vector4d.x * point3d.x - vector4d.y * point3d.y - vector4d.z * point3d.z);
            } else {
                this.update(n, n2, false, 0.0, 0.0, 0.0, 0.0);
            }
            ++n2;
        }
    }

    void update(Canvas3D canvas3D) {
        canvas3D.setModelViewMatrix(canvas3D.ctx, canvas3D.vworldToEc.mat, this.lastLocalToVworld[0].mat);
        this.update(canvas3D.ctx, this.lastLocalToVworld[0]);
    }

    void updateBoundingLeaf() {
        if (this.boundingLeaf != null && this.boundingLeaf.currentSwitchOn) {
            this.region = this.boundingLeaf.transformedRegion;
        } else if (this.regionOfInfluence != null) {
            this.region = (Bounds)this.regionOfInfluence.clone();
            this.region.transform(this.regionOfInfluence, this.currentLocalToVworld[0]);
        } else {
            this.region = null;
        }
    }

    void updateImmediateMirrorObject(Object[] objectArray) {
        int n = (Integer)objectArray[1];
        if ((n & 0x20) != 0) {
            this.mirrorModelClip.boundingLeaf = (BoundingLeafRetained)objectArray[2];
            if (objectArray[2] != null) {
                this.mirrorModelClip.region = this.mirrorModelClip.boundingLeaf.transformedRegion;
            } else if (this.mirrorModelClip.regionOfInfluence != null) {
                this.mirrorModelClip.region = (Bounds)this.mirrorModelClip.regionOfInfluence.clone();
                this.mirrorModelClip.region.transform(this.mirrorModelClip.regionOfInfluence, this.currentLocalToVworld[0]);
            } else {
                this.mirrorModelClip.region = null;
            }
        } else if ((n & 0x10) != 0) {
            this.mirrorModelClip.regionOfInfluence = (Bounds)objectArray[2];
            if (this.mirrorModelClip.boundingLeaf == null) {
                if (objectArray[2] != null) {
                    this.mirrorModelClip.region = (Bounds)this.mirrorModelClip.regionOfInfluence.clone();
                    this.mirrorModelClip.region.transform(this.mirrorModelClip.regionOfInfluence, this.currentLocalToVworld[0]);
                } else {
                    this.mirrorModelClip.region = null;
                }
            }
        } else if ((n & 0x40) != 0) {
            Object e;
            int n2;
            Object[] objectArray2 = (Object[])objectArray[2];
            ArrayList arrayList = (ArrayList)objectArray2[0];
            ArrayList arrayList2 = (ArrayList)objectArray2[1];
            boolean bl = (Boolean)objectArray2[2];
            if (arrayList != null) {
                this.mirrorModelClip.isScoped = bl;
                n2 = 0;
                while (n2 < arrayList.size()) {
                    e = arrayList.get(n2);
                    if (e instanceof GroupRetained) {
                        ((GroupRetained)e).addModelClip(this.mirrorModelClip);
                    } else if (e instanceof Shape3DRetained) {
                        ((Shape3DRetained)e).addModelClip(this.mirrorModelClip);
                    }
                    ++n2;
                }
            }
            if (arrayList2 != null) {
                this.mirrorModelClip.isScoped = bl;
                n2 = 0;
                while (n2 < arrayList2.size()) {
                    e = arrayList2.get(n2);
                    if (e instanceof GroupRetained) {
                        ((GroupRetained)e).removeModelClip(this.mirrorModelClip);
                    } else if (e instanceof Shape3DRetained) {
                        ((Shape3DRetained)e).removeModelClip(this.mirrorModelClip);
                    }
                    ++n2;
                }
            }
        }
    }

    void updateImmediateTransformChange() {
        if (this.boundingLeaf == null && this.regionOfInfluence != null) {
            this.region = (Bounds)this.regionOfInfluence.clone();
            this.region.transform(this.regionOfInfluence, this.sgModelClip.currentLocalToVworld[0]);
        }
    }

    void updateMirrorObject(Object[] objectArray) {
        Object[] objectArray2;
        int n = (Integer)objectArray[1];
        if ((n & 2) != 0) {
            objectArray2 = (Vector4d[])objectArray[2];
            this.mirrorModelClip.planes[0].set((Tuple4d)objectArray2[0]);
            this.mirrorModelClip.planes[1].set((Tuple4d)objectArray2[1]);
            this.mirrorModelClip.planes[2].set((Tuple4d)objectArray2[2]);
            this.mirrorModelClip.planes[3].set((Tuple4d)objectArray2[3]);
            this.mirrorModelClip.planes[4].set((Tuple4d)objectArray2[4]);
            this.mirrorModelClip.planes[5].set((Tuple4d)objectArray2[5]);
        } else if ((n & 1) != 0) {
            int n2 = (Integer)objectArray[2];
            this.mirrorModelClip.planes[n2].set((Tuple4d)((Vector4d)objectArray[3]));
        }
        if ((n & 8) != 0) {
            objectArray2 = (Boolean[])objectArray[2];
            this.mirrorModelClip.enables[0] = objectArray2[0].booleanValue();
            this.mirrorModelClip.enables[1] = objectArray2[1].booleanValue();
            this.mirrorModelClip.enables[2] = objectArray2[2].booleanValue();
            this.mirrorModelClip.enables[3] = objectArray2[3].booleanValue();
            this.mirrorModelClip.enables[4] = objectArray2[4].booleanValue();
            this.mirrorModelClip.enables[5] = objectArray2[5].booleanValue();
            this.mirrorModelClip.enableFlag = this.mirrorModelClip.enables[0] | this.mirrorModelClip.enables[1] | this.mirrorModelClip.enables[2] | this.mirrorModelClip.enables[3] | this.mirrorModelClip.enables[4] | this.mirrorModelClip.enables[5];
        } else if ((n & 4) != 0) {
            int n3 = (Integer)objectArray[2];
            this.mirrorModelClip.enables[n3] = (Boolean)objectArray[3];
            this.mirrorModelClip.enableFlag = this.mirrorModelClip.enables[0] | this.mirrorModelClip.enables[1] | this.mirrorModelClip.enables[2] | this.mirrorModelClip.enables[3] | this.mirrorModelClip.enables[4] | this.mirrorModelClip.enables[5];
        }
    }
}

