/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.FogRetained;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.VirtualUniverse;

class LinearFogRetained
extends FogRetained {
    double frontDistance = 0.1;
    double backDistance = 1.0;
    double localToVworldScale = 1.0;
    double frontDistanceInEc;
    double backDistanceInEc;
    double vworldToCoexistenceScale;
    static final int FRONT_DISTANCE_CHANGED = 16;
    static final int BACK_DISTANCE_CHANGED = 32;

    LinearFogRetained() {
        this.nodeType = 3;
    }

    double getBackDistance() {
        return this.backDistance;
    }

    double getFrontDistance() {
        return this.frontDistance;
    }

    synchronized void initBackDistance(double d) {
        this.backDistance = d;
    }

    synchronized void initFrontDistance(double d) {
        this.frontDistance = d;
    }

    void initMirrorObject() {
        super.initMirrorObject();
        ((LinearFogRetained)this.mirrorFog).frontDistance = this.frontDistance;
        ((LinearFogRetained)this.mirrorFog).backDistance = this.backDistance;
        ((LinearFogRetained)this.mirrorFog).localToVworldScale = this.lastLocalToVworld[0].getDistanceScale();
    }

    synchronized void setBackDistance(double d) {
        this.backDistance = d;
        J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
        j3dMessage.threads = 4224;
        j3dMessage.type = 22;
        j3dMessage.universe = this.universe;
        j3dMessage.args[0] = this;
        j3dMessage.args[1] = new Integer(32);
        j3dMessage.args[2] = new Double(d);
        VirtualUniverse.mc.processMessage(j3dMessage);
    }

    synchronized void setFrontDistance(double d) {
        this.frontDistance = d;
        J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
        j3dMessage.threads = 4224;
        j3dMessage.type = 22;
        j3dMessage.universe = this.universe;
        j3dMessage.args[0] = this;
        j3dMessage.args[1] = new Integer(16);
        j3dMessage.args[2] = new Double(d);
        VirtualUniverse.mc.processMessage(j3dMessage);
    }

    void update(int n, double d) {
        this.validateDistancesInEc(d);
        this.update(n, this.color.x, this.color.y, this.color.z, this.frontDistanceInEc, this.backDistanceInEc);
    }

    native void update(int var1, float var2, float var3, float var4, double var5, double var7);

    synchronized void updateMirrorObject(Object[] objectArray) {
        int n = (Integer)objectArray[1];
        if ((n & 0x10) != 0) {
            ((LinearFogRetained)this.mirrorFog).frontDistance = (Double)objectArray[2];
        }
        if ((n & 0x20) != 0) {
            ((LinearFogRetained)this.mirrorFog).backDistance = (Double)objectArray[2];
        }
        ((LinearFogRetained)this.mirrorFog).localToVworldScale = this.lastLocalToVworld[0].getDistanceScale();
        super.updateMirrorObject(objectArray);
    }

    void updateTransformChange() {
        super.updateTransformChange();
        this.localToVworldScale = this.sgFog.lastLocalToVworld[0].getDistanceScale();
    }

    void validateDistancesInEc(double d) {
        double d2 = this.localToVworldScale * d;
        this.frontDistanceInEc = this.frontDistance * d2;
        this.backDistanceInEc = this.backDistance * d2;
    }
}

