/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.BoundingBox;
import javax.media.j3d.BoundingPolytope;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.GeometryArrayRetained;
import javax.media.j3d.GeometryRetained;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.PickBounds;
import javax.media.j3d.PickCone;
import javax.media.j3d.PickCylinder;
import javax.media.j3d.PickPoint;
import javax.media.j3d.PickRay;
import javax.media.j3d.PickSegment;
import javax.media.j3d.PickShape;
import javax.media.j3d.Transform3D;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;

class LineArrayRetained
extends GeometryArrayRetained
implements Cloneable {
    LineArrayRetained() {
        this.geoType = 4;
    }

    boolean intersect(Transform3D transform3D, Bounds bounds) {
        int n = 0;
        Point3d[] point3dArray = new Point3d[2];
        int n2 = 0;
        while (n2 < 2) {
            point3dArray[n2] = new Point3d();
            ++n2;
        }
        if (bounds instanceof BoundingBox) {
            n = 1;
        } else if (bounds instanceof BoundingSphere) {
            n = 2;
        }
        n2 = 0;
        while (n2 < this.vertexCount) {
            int n3 = n2;
            while (n3 < n2 + 2) {
                int n4 = this.stride * n3 + this.coordinateOffset;
                int n5 = n3 - n2;
                point3dArray[n5].x = this.vertexData[n4];
                point3dArray[n5].y = this.vertexData[n4 + 1];
                point3dArray[n5].z = this.vertexData[n4 + 2];
                transform3D.transform(point3dArray[n5], point3dArray[n5]);
                ++n3;
            }
            switch (n) {
                case 0: {
                    if (!this.intersectBoundingPolytope(point3dArray, (BoundingPolytope)bounds)) break;
                    return true;
                }
                case 1: {
                    if (!this.intersectBoundingBox(point3dArray, (BoundingBox)bounds)) break;
                    return true;
                }
                case 2: {
                    if (!this.intersectBoundingSphere(point3dArray, (BoundingSphere)bounds)) break;
                    return true;
                }
            }
            n2 += 2;
        }
        return false;
    }

    boolean intersect(Transform3D transform3D, PickRay pickRay, double[] dArray) {
        double[] dArray2 = new double[1];
        boolean bl = false;
        Object var10_6 = null;
        Object var11_7 = null;
        Object var12_8 = null;
        Point3d[] point3dArray = new Point3d[2];
        int n = 0;
        while (n < 2) {
            point3dArray[n] = new Point3d();
            ++n;
        }
        dArray[0] = Double.MAX_VALUE;
        n = 0;
        while (n < this.vertexCount) {
            int n2 = n;
            while (n2 < n + 2) {
                int n3 = this.stride * n2 + this.coordinateOffset;
                int n4 = n2 - n;
                point3dArray[n4].x = this.vertexData[n3];
                point3dArray[n4].y = this.vertexData[n3 + 1];
                point3dArray[n4].z = this.vertexData[n3 + 2];
                transform3D.transform(point3dArray[n4], point3dArray[n4]);
                ++n2;
            }
            if (this.intersectLineAndRay(point3dArray[0], point3dArray[1], pickRay.origin, pickRay.direction, dArray2)) {
                bl = true;
                if (dArray2[0] < dArray[0]) {
                    dArray[0] = dArray2[0];
                }
            }
            n += 2;
        }
        return bl;
    }

    boolean intersect(Transform3D transform3D, PickShape pickShape) {
        int n = 0;
        boolean bl = true;
        double[] dArray = new double[1];
        Vector3d vector3d = null;
        Point3d point3d = null;
        Point3d point3d2 = null;
        Bounds bounds = null;
        Point3d[] point3dArray = new Point3d[2];
        if (pickShape instanceof PickRay) {
            n = 1;
        } else if (pickShape instanceof PickSegment) {
            point3d = ((PickSegment)pickShape).start;
            point3d2 = ((PickSegment)pickShape).end;
            vector3d = new Vector3d(point3d2.x - point3d.x, point3d2.y - point3d.y, point3d2.z - point3d.z);
            n = 2;
        } else if (pickShape instanceof PickBounds) {
            bounds = ((PickBounds)pickShape).bounds;
            if (bounds instanceof BoundingBox) {
                n = 4;
            } else if (bounds instanceof BoundingSphere) {
                n = 5;
            } else if (bounds instanceof BoundingPolytope) {
                n = 6;
            }
        } else {
            if (pickShape instanceof PickPoint) {
                throw new IllegalArgumentException(J3dI18N.getString("LineArrayRetained0"));
            }
            if (pickShape instanceof PickCylinder) {
                n = 7;
            } else if (pickShape instanceof PickCone) {
                n = 8;
            } else {
                throw new RuntimeException("PickShape not supported for intersection");
            }
        }
        int n2 = 0;
        while (n2 < 2) {
            point3dArray[n2] = new Point3d();
            ++n2;
        }
        n2 = 0;
        while (n2 < this.vertexCount) {
            int n3 = n2;
            while (n3 < n2 + 2) {
                int n4 = this.stride * n3 + this.coordinateOffset;
                int n5 = n3 - n2;
                point3dArray[n5].x = this.vertexData[n4];
                point3dArray[n5].y = this.vertexData[n4 + 1];
                point3dArray[n5].z = this.vertexData[n4 + 2];
                transform3D.transform(point3dArray[n5], point3dArray[n5]);
                ++n3;
            }
            switch (n) {
                case 1: {
                    if (!this.intersectLineAndRay(point3dArray[0], point3dArray[1], ((PickRay)pickShape).origin, ((PickRay)pickShape).direction, dArray)) break;
                    return true;
                }
                case 2: {
                    if (!this.intersectLineAndRay(point3dArray[0], point3dArray[1], point3d, vector3d, dArray) || !(dArray[0] <= 1.0)) break;
                    return true;
                }
                case 4: {
                    if (!this.intersectBoundingBox(point3dArray, (BoundingBox)((PickBounds)pickShape).bounds)) break;
                    return true;
                }
                case 5: {
                    if (!this.intersectBoundingSphere(point3dArray, (BoundingSphere)((PickBounds)pickShape).bounds)) break;
                    return true;
                }
                case 6: {
                    if (!this.intersectBoundingPolytope(point3dArray, (BoundingPolytope)((PickBounds)pickShape).bounds)) break;
                    return true;
                }
                case 7: {
                    if (!this.intersectCylinder(point3dArray, (PickCylinder)pickShape, dArray)) break;
                    return true;
                }
                case 8: {
                    if (!this.intersectCone(point3dArray, (PickCone)pickShape, dArray)) break;
                    return true;
                }
            }
            n2 += 2;
        }
        return n == 3;
    }

    boolean intersect(Transform3D transform3D, Transform3D transform3D2, GeometryRetained geometryRetained) {
        Point3d[] point3dArray = new Point3d[2];
        int n = 0;
        while (n < 2) {
            point3dArray[n] = new Point3d();
            ++n;
        }
        n = 0;
        while (n < this.vertexCount) {
            int n2 = n;
            while (n2 < n + 2) {
                int n3 = this.stride * n2 + this.coordinateOffset;
                int n4 = n2 - n;
                point3dArray[n4].x = this.vertexData[n3];
                point3dArray[n4].y = this.vertexData[n3 + 1];
                point3dArray[n4].z = this.vertexData[n3 + 2];
                transform3D.transform(point3dArray[n4], point3dArray[n4]);
                ++n2;
            }
            if (geometryRetained.intersect(transform3D2, point3dArray)) {
                return true;
            }
            n += 2;
        }
        return false;
    }

    boolean intersect(Transform3D transform3D, Point3d[] point3dArray) {
        Point3d[] point3dArray2 = new Point3d[2];
        int n = 0;
        while (n < 2) {
            point3dArray2[n] = new Point3d();
            ++n;
        }
        n = 0;
        while (n < this.vertexCount) {
            int n2 = n;
            while (n2 < n + 2) {
                int n3 = this.stride * n2 + this.coordinateOffset;
                int n4 = n2 - n;
                point3dArray2[n4].x = this.vertexData[n3];
                point3dArray2[n4].y = this.vertexData[n3 + 1];
                point3dArray2[n4].z = this.vertexData[n3 + 2];
                transform3D.transform(point3dArray2[n4], point3dArray2[n4]);
                ++n2;
            }
            if (point3dArray.length < 3) {
                return false;
            }
            if (this.intersectPolygon(point3dArray, point3dArray2, true)) {
                return true;
            }
            n += 2;
        }
        return false;
    }
}

