/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.BoundingBox;
import javax.media.j3d.BoundingPolytope;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.GeometryRetained;
import javax.media.j3d.IndexedGeometryArrayRetained;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.PickBounds;
import javax.media.j3d.PickCone;
import javax.media.j3d.PickCylinder;
import javax.media.j3d.PickPoint;
import javax.media.j3d.PickRay;
import javax.media.j3d.PickSegment;
import javax.media.j3d.PickShape;
import javax.media.j3d.Transform3D;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;

class IndexedPointArrayRetained
extends IndexedGeometryArrayRetained {
    IndexedPointArrayRetained() {
        this.geoType = 10;
    }

    boolean intersect(Transform3D transform3D, Bounds bounds) {
        Point3d point3d = new Point3d();
        int n = 0;
        while (n < this.indexCount) {
            int n2 = this.stride * this.indexCoord[n] + this.coordinateOffset;
            point3d.x = this.vertexData[n2];
            point3d.y = this.vertexData[n2 + 1];
            point3d.z = this.vertexData[n2 + 2];
            transform3D.transform(point3d, point3d);
            if (bounds.intersect(point3d)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    boolean intersect(Transform3D transform3D, PickRay pickRay, double[] dArray) {
        double[] dArray2 = new double[1];
        boolean bl = false;
        Object var10_6 = null;
        Point3d point3d = new Point3d();
        dArray[0] = Double.MAX_VALUE;
        int n = 0;
        while (n < this.indexCount) {
            int n2 = this.stride * this.indexCoord[n] + this.coordinateOffset;
            point3d.x = this.vertexData[n2];
            point3d.y = this.vertexData[n2 + 1];
            point3d.z = this.vertexData[n2 + 2];
            transform3D.transform(point3d, point3d);
            if (this.intersectPntAndRay(point3d, pickRay.origin, pickRay.direction, dArray2)) {
                bl = true;
                if (dArray2[0] < dArray[0]) {
                    dArray[0] = dArray2[0];
                }
            }
            ++n;
        }
        return bl;
    }

    boolean intersect(Transform3D transform3D, PickShape pickShape) {
        int n = 0;
        double[] dArray = new double[1];
        Vector3d vector3d = null;
        Bounds bounds = null;
        Point3d point3d = new Point3d();
        if (pickShape instanceof PickRay) {
            n = 1;
        } else if (pickShape instanceof PickSegment) {
            Point3d point3d2 = ((PickSegment)pickShape).start;
            Point3d point3d3 = ((PickSegment)pickShape).end;
            vector3d = new Vector3d(point3d3.x - point3d2.x, point3d3.y - point3d2.y, point3d3.z - point3d2.z);
            n = 2;
        } else if (pickShape instanceof PickBounds) {
            bounds = ((PickBounds)pickShape).bounds;
            if (bounds instanceof BoundingBox) {
                n = 4;
            } else if (bounds instanceof BoundingSphere) {
                n = 5;
            } else if (bounds instanceof BoundingPolytope) {
                n = 6;
            }
        } else {
            if (pickShape instanceof PickPoint) {
                throw new IllegalArgumentException(J3dI18N.getString("IndexedPointArrayRetained0"));
            }
            if (pickShape instanceof PickCylinder) {
                n = 7;
            } else if (pickShape instanceof PickCone) {
                n = 8;
            } else {
                throw new RuntimeException("PickShape not supported for intersection");
            }
        }
        int n2 = 0;
        while (n2 < this.indexCount) {
            int n3 = this.stride * this.indexCoord[n2] + this.coordinateOffset;
            point3d.x = this.vertexData[n3];
            point3d.y = this.vertexData[n3 + 1];
            point3d.z = this.vertexData[n3 + 2];
            transform3D.transform(point3d, point3d);
            switch (n) {
                case 1: {
                    if (!this.intersectPntAndRay(point3d, ((PickRay)pickShape).origin, ((PickRay)pickShape).direction, dArray)) break;
                    return true;
                }
                case 2: {
                    if (!this.intersectPntAndRay(point3d, ((PickSegment)pickShape).start, vector3d, dArray) || !(dArray[0] <= 1.0)) break;
                    return true;
                }
                case 4: {
                    if (!((BoundingBox)((PickBounds)pickShape).bounds).intersect(point3d)) break;
                    return true;
                }
                case 5: {
                    if (!((BoundingSphere)((PickBounds)pickShape).bounds).intersect(point3d)) break;
                    return true;
                }
                case 6: {
                    if (!((BoundingPolytope)((PickBounds)pickShape).bounds).intersect(point3d)) break;
                    return true;
                }
                case 7: {
                    if (!this.intersectCylinder(point3d, (PickCylinder)pickShape, dArray)) break;
                    return true;
                }
                case 8: {
                    if (!this.intersectCone(point3d, (PickCone)pickShape, dArray)) break;
                    return true;
                }
            }
            ++n2;
        }
        return n == 3;
    }

    boolean intersect(Transform3D transform3D, Transform3D transform3D2, GeometryRetained geometryRetained) {
        Point3d[] point3dArray = new Point3d[1];
        int n = 0;
        while (n < this.indexCount) {
            int n2 = this.stride * this.indexCoord[n] + this.coordinateOffset;
            point3dArray[0].x = this.vertexData[n2];
            point3dArray[0].y = this.vertexData[n2 + 1];
            point3dArray[0].z = this.vertexData[n2 + 2];
            transform3D.transform(point3dArray[0], point3dArray[0]);
            if (geometryRetained.intersect(transform3D2, point3dArray)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    boolean intersect(Transform3D transform3D, Point3d[] point3dArray) {
        Point3d point3d = new Point3d();
        int n = 0;
        while (n < this.indexCount) {
            int n2 = this.stride * this.indexCoord[n] + this.coordinateOffset;
            point3d.x = this.vertexData[n2];
            point3d.y = this.vertexData[n2 + 1];
            point3d.z = this.vertexData[n2 + 2];
            transform3D.transform(point3d, point3d);
            if (point3dArray.length != 1) {
                return false;
            }
            if (point3d.x == point3dArray[0].x && point3d.y == point3dArray[0].y && point3d.z == point3dArray[0].z) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

