/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.GeometryArrayRetained;
import javax.media.j3d.GeometryStripArrayRetained;
import javax.media.j3d.IndexedGeometryArrayRetained;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.LineStripArrayRetained;
import javax.media.j3d.TriangleFanArrayRetained;
import javax.media.j3d.TriangleStripArrayRetained;

abstract class IndexedGeometryStripArrayRetained
extends IndexedGeometryArrayRetained {
    int[] stripIndexCounts;
    static final int STRIP_INDEX_CHANGED = 1024;

    IndexedGeometryStripArrayRetained() {
    }

    Object cloneNonIndexedGeometry() {
        GeometryStripArrayRetained geometryStripArrayRetained = null;
        switch (this.geoType) {
            case 14: {
                geometryStripArrayRetained = new LineStripArrayRetained();
                break;
            }
            case 13: {
                geometryStripArrayRetained = new TriangleFanArrayRetained();
                break;
            }
            case 12: {
                geometryStripArrayRetained = new TriangleStripArrayRetained();
                break;
            }
        }
        geometryStripArrayRetained.createGeometryArrayData(this.indexCount, this.vertexFormat & 0xFFFFFF7F | 0x100);
        geometryStripArrayRetained.unIndexify(this);
        geometryStripArrayRetained.stripVertexCounts = new int[this.stripIndexCounts.length];
        System.arraycopy(this.stripIndexCounts, 0, geometryStripArrayRetained.stripVertexCounts, 0, this.stripIndexCounts.length);
        geometryStripArrayRetained.stripStartIndices = new int[this.stripIndexCounts.length];
        geometryStripArrayRetained.stripStartIndices[0] = 0;
        int n = 0;
        while (n < this.stripIndexCounts.length - 1) {
            geometryStripArrayRetained.stripStartIndices[n + 1] = geometryStripArrayRetained.stripStartIndices[n] + geometryStripArrayRetained.stripVertexCounts[n];
            ++n;
        }
        return geometryStripArrayRetained;
    }

    int getNumStrips() {
        return this.stripIndexCounts.length;
    }

    void getStripIndexCounts(int[] nArray) {
        int n = nArray.length - 1;
        while (n >= 0) {
            nArray[n] = this.stripIndexCounts[n];
            --n;
        }
    }

    synchronized void setStripIndexCounts(int[] nArray) {
        int n = nArray.length;
        int n2 = 0;
        this.stripIndexCounts = new int[n];
        int n3 = 0;
        while (n3 < n) {
            this.stripIndexCounts[n3] = nArray[n3];
            n2 += nArray[n3];
            ++n3;
        }
        this.isDirty |= 0x400;
        this.notifyUsers();
        if (n2 != this.indexCount) {
            throw new IllegalArgumentException(J3dI18N.getString("IndexedGeometryStripArrayRetained0"));
        }
    }

    void updateD3Ddata(GeometryArrayRetained geometryArrayRetained) {
        int n = 0;
        int n2 = 0;
        IndexedGeometryStripArrayRetained indexedGeometryStripArrayRetained = (IndexedGeometryStripArrayRetained)geometryArrayRetained;
        int n3 = 0;
        while (n3 < this.stripIndexCounts.length) {
            int n4;
            this.vertexData[n++] = this.stripIndexCounts[n3];
            if ((indexedGeometryStripArrayRetained.vertexFormat & 4) != 0) {
                if ((indexedGeometryStripArrayRetained.isDirty & 4) != 0) {
                    n4 = indexedGeometryStripArrayRetained.indexColor[n2] * indexedGeometryStripArrayRetained.stride + indexedGeometryStripArrayRetained.colorOffset;
                    this.vertexData[n] = indexedGeometryStripArrayRetained.vertexData[n4];
                    this.vertexData[n + 1] = indexedGeometryStripArrayRetained.vertexData[n4 + 1];
                    this.vertexData[n + 2] = indexedGeometryStripArrayRetained.vertexData[n4 + 2];
                    this.vertexData[n + 3] = indexedGeometryStripArrayRetained.vertexData[n4 + 3];
                }
                n += 4;
            }
            int n5 = 0;
            while (n5 < this.stripIndexCounts[n3]) {
                if ((indexedGeometryStripArrayRetained.isDirty & 1) != 0) {
                    n4 = indexedGeometryStripArrayRetained.indexCoord[n2] * indexedGeometryStripArrayRetained.stride + indexedGeometryStripArrayRetained.coordinateOffset;
                    this.vertexData[n] = indexedGeometryStripArrayRetained.vertexData[n4];
                    this.vertexData[n + 1] = indexedGeometryStripArrayRetained.vertexData[n4 + 1];
                    this.vertexData[n + 2] = indexedGeometryStripArrayRetained.vertexData[n4 + 2];
                }
                n += 3;
                if ((indexedGeometryStripArrayRetained.isDirty & 2) != 0) {
                    if ((indexedGeometryStripArrayRetained.vertexFormat & 2) != 0) {
                        n4 = indexedGeometryStripArrayRetained.indexNormal[n2] * indexedGeometryStripArrayRetained.stride + indexedGeometryStripArrayRetained.normalOffset;
                        this.vertexData[n] = indexedGeometryStripArrayRetained.vertexData[n4];
                        this.vertexData[n + 1] = indexedGeometryStripArrayRetained.vertexData[n4 + 1];
                        this.vertexData[n + 2] = indexedGeometryStripArrayRetained.vertexData[n4 + 2];
                    } else {
                        this.vertexData[n] = 0.0f;
                        this.vertexData[n + 1] = 0.0f;
                        this.vertexData[n + 2] = 0.0f;
                    }
                }
                n += 3;
                if ((indexedGeometryStripArrayRetained.isDirty & 8) != 0) {
                    int n6;
                    if ((indexedGeometryStripArrayRetained.vertexFormat & 0x60) != 0) {
                        n6 = 0;
                        while (n6 < indexedGeometryStripArrayRetained.texCoordSetCount) {
                            n4 = ((int[])indexedGeometryStripArrayRetained.indexTexCoord[n6])[n2] * indexedGeometryStripArrayRetained.stride + indexedGeometryStripArrayRetained.textureOffset;
                            this.vertexData[n] = indexedGeometryStripArrayRetained.vertexData[n4];
                            this.vertexData[n + 1] = indexedGeometryStripArrayRetained.vertexData[n4 + 1];
                            n += 2;
                            ++n6;
                        }
                    } else {
                        n6 = 0;
                        while (n6 < indexedGeometryStripArrayRetained.texCoordSetCount) {
                            this.vertexData[n] = 0.0f;
                            this.vertexData[n + 1] = 0.0f;
                            n += 2;
                            ++n6;
                        }
                    }
                } else {
                    n += 2 * indexedGeometryStripArrayRetained.texCoordSetCount;
                }
                ++n5;
                ++n2;
            }
            ++n3;
        }
    }
}

