/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import javax.media.j3d.AlternateAppearanceRetained;
import javax.media.j3d.BHLeafInterface;
import javax.media.j3d.BHLeafNode;
import javax.media.j3d.BehaviorRetained;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.BranchGroupRetained;
import javax.media.j3d.ContainsNodes;
import javax.media.j3d.ContainsNodesList;
import javax.media.j3d.FogRetained;
import javax.media.j3d.HashKey;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.LightRetained;
import javax.media.j3d.LinkRetained;
import javax.media.j3d.Locale;
import javax.media.j3d.ModelClipRetained;
import javax.media.j3d.MorphRetained;
import javax.media.j3d.MultipleParentException;
import javax.media.j3d.Node;
import javax.media.j3d.NodeRetained;
import javax.media.j3d.OrderedGroupRetained;
import javax.media.j3d.SceneGraphObject;
import javax.media.j3d.SceneGraphObjectRetained;
import javax.media.j3d.SetLiveState;
import javax.media.j3d.Shape3DRetained;
import javax.media.j3d.SharedGroupRetained;
import javax.media.j3d.SwitchRetained;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroupRetained;
import javax.media.j3d.VirtualUniverse;

class GroupRetained
extends NodeRetained
implements BHLeafInterface {
    Vector children = new Vector(5);
    Bounds collisionBound = null;
    Locale locale = null;
    ArrayList lights = new ArrayList(1);
    ArrayList fogs = new ArrayList(0);
    ArrayList modelClips = new ArrayList(0);
    ArrayList altAppearances = new ArrayList(0);
    boolean collisionTarget = false;
    ArrayList childrenContainsNodesList = new ArrayList();
    ArrayList childrenSwitchLinks = new ArrayList(1);
    ArrayList orderedGroupsPath = null;
    ArrayList orderedChildIdsPath = null;
    BoundingBox vwcBounds;
    ArrayList mirrorGroup;
    HashKey key;
    GroupRetained sourceNode;
    BHLeafNode bhLeafNode = null;
    SwitchRetained closestSwitchParent = null;
    int closestSwitchIndex = -1;
    int switchIndexCount = 0;

    GroupRetained() {
        this.nodeType = 23;
        this.localBounds = new BoundingSphere();
        ((BoundingSphere)this.localBounds).setRadius(-1.0);
    }

    void addAltApp(AlternateAppearanceRetained alternateAppearanceRetained) {
        this.altAppearances.add(alternateAppearanceRetained);
    }

    void addChild(Node node) {
        this.checkValidChild(node, "GroupRetained2");
        if (this.source.isLive()) {
            Object object = this.universe.sceneGraphLock;
            synchronized (object) {
                this.doAddChild(node, null, 0);
            }
        } else {
            this.doAddChild(node, null, 0);
        }
    }

    void addFog(FogRetained fogRetained) {
        this.fogs.add(fogRetained);
    }

    void addLight(LightRetained lightRetained) {
        this.lights.add(lightRetained);
    }

    void addModelClip(ModelClipRetained modelClipRetained) {
        this.modelClips.add(modelClipRetained);
    }

    void appendChildrenSwitchData() {
        this.childrenContainsNodesList.add(new ContainsNodesList());
        this.childrenSwitchLinks.add(new ArrayList(1));
    }

    void checkClearLive(NodeRetained nodeRetained, HashKey[] hashKeyArray, boolean bl, J3dMessage[] j3dMessageArray, int n, int n2) {
        SceneGraphObject sceneGraphObject = this.source;
        if (sceneGraphObject.isLive()) {
            SetLiveState setLiveState = this.universe.setLiveState;
            setLiveState.reset(this.locale);
            setLiveState.refCount = this.refCount;
            setLiveState.inSharedGroup = bl;
            setLiveState.inBackgroundGroup = this.inBackgroundGroup;
            setLiveState.inOrderedGroup = this.inOrderedGroup;
            setLiveState.keys = hashKeyArray;
            setLiveState.fogs = this.fogs;
            setLiveState.lights = this.lights;
            setLiveState.altAppearances = this.altAppearances;
            setLiveState.modelClips = this.modelClips;
            if (this instanceof OrderedGroupRetained) {
                setLiveState.ogList.add(this);
                setLiveState.ogChildIdList.add(new Integer(n2));
            }
            nodeRetained.clearLive(setLiveState);
            if (this instanceof TransformGroupRetained) {
                ((TransformGroupRetained)this).updateTargets(setLiveState.nodeList, null, setLiveState.transformBLTargets, null, 0);
            }
            if (this.parentTransformGroups != null) {
                int n3 = 0;
                while (n3 < this.parentTransformGroups.length) {
                    ArrayList arrayList = this.parentTransformGroups[n3];
                    int n4 = arrayList.size() - 1;
                    while (n4 >= 0) {
                        TransformGroupRetained transformGroupRetained = (TransformGroupRetained)arrayList.get(n4);
                        transformGroupRetained.updateTargets(setLiveState.nodeList, null, setLiveState.transformBLTargets, null, 0);
                        --n4;
                    }
                    ++n3;
                }
            }
            J3dMessage j3dMessage = j3dMessageArray == null ? VirtualUniverse.mc.getMessage() : j3dMessageArray[n++];
            j3dMessage.threads = setLiveState.notifyThreads;
            j3dMessage.type = 1;
            j3dMessage.universe = this.universe;
            j3dMessage.args[0] = setLiveState.nodeList.toArray();
            if (j3dMessageArray == null) {
                VirtualUniverse.mc.processMessage(j3dMessage);
            }
            j3dMessage = j3dMessageArray == null ? VirtualUniverse.mc.getMessage() : j3dMessageArray[n++];
            j3dMessage.threads = 128;
            j3dMessage.type = 33;
            j3dMessage.universe = this.universe;
            j3dMessage.args[0] = setLiveState.ogList.toArray();
            j3dMessage.args[1] = setLiveState.ogChildIdList.toArray();
            if (j3dMessageArray == null) {
                VirtualUniverse.mc.processMessage(j3dMessage);
            }
            setLiveState.reset(this.locale);
        }
    }

    void checkClearLive(NodeRetained nodeRetained, J3dMessage[] j3dMessageArray, int n, int n2) {
        this.checkClearLive(nodeRetained, this.localToVworldKeys, this.inSharedGroup, j3dMessageArray, n, n2);
    }

    void checkSetLive(NodeRetained nodeRetained, HashKey[] hashKeyArray, boolean bl, J3dMessage[] j3dMessageArray, int n, NodeRetained nodeRetained2) {
        SceneGraphObject sceneGraphObject = this.source;
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        Object var17_10 = null;
        Transform3D[] transform3DArray = null;
        Transform3D[] transform3DArray2 = null;
        if (sceneGraphObject.isLive()) {
            Cloneable cloneable;
            int n2;
            boolean[] blArray;
            Object object;
            TransformGroupRetained transformGroupRetained;
            SetLiveState setLiveState = this.universe.setLiveState;
            setLiveState.reset(this.locale);
            setLiveState.refCount = this.refCount;
            transform3DArray = setLiveState.currentTransforms;
            transform3DArray2 = setLiveState.lastTransforms;
            if (this.nodeType == 24) {
                setLiveState.currentTransforms = ((TransformGroupRetained)this).currentChildLocalToVworld;
                setLiveState.lastTransforms = ((TransformGroupRetained)this).lastChildLocalToVworld;
                setLiveState.parentTransformGroups = this.parentTransformGroups;
                setLiveState.transformTargets = arrayList;
                setLiveState.transformBLTargets = arrayList2;
                setLiveState.transformTargetThreads = 0;
                setLiveState.childTransformLinks = ((TransformGroupRetained)this).childTransformLinks;
                setLiveState.parentTransformLink = this;
            } else {
                setLiveState.currentTransforms = this.currentLocalToVworld;
                setLiveState.lastTransforms = this.lastLocalToVworld;
                if (this.parentTransformGroups != null) {
                    setLiveState.transformTargets = arrayList;
                    setLiveState.transformBLTargets = arrayList2;
                    setLiveState.transformTargetThreads = 0;
                }
                setLiveState.parentTransformGroups = this.parentTransformGroups;
                if (this.nodeType == 22) {
                    setLiveState.childTransformLinks = ((SharedGroupRetained)this).childTransformLinks;
                    setLiveState.parentTransformLink = this;
                } else if (this.parentTransformLink != null) {
                    if (this.parentTransformLink instanceof TransformGroupRetained) {
                        transformGroupRetained = (TransformGroupRetained)this.parentTransformLink;
                        setLiveState.childTransformLinks = transformGroupRetained.childTransformLinks;
                    } else {
                        object = (SharedGroupRetained)this.parentTransformLink;
                        setLiveState.childTransformLinks = ((SharedGroupRetained)object).childTransformLinks;
                    }
                }
            }
            setLiveState.inSharedGroup = bl;
            setLiveState.inBackgroundGroup = this.inBackgroundGroup;
            setLiveState.inOrderedGroup = this.inOrderedGroup;
            setLiveState.keys = hashKeyArray;
            if (this.orderedGroupsPath != null) {
                setLiveState.orderedGroupsPath.addAll(this.orderedGroupsPath);
                setLiveState.orderedChildIdsPath.addAll(this.orderedChildIdsPath);
            }
            if (this instanceof OrderedGroupRetained) {
                setLiveState.inOrderedGroup = true;
                setLiveState.orderedGroupsPath.add(this);
                setLiveState.orderedChildIdsPath.add(((OrderedGroupRetained)this).newChildId);
            }
            if (this.fogs.size() > 0) {
                setLiveState.fogs = this.fogs;
            }
            if (this.altAppearances.size() > 0) {
                setLiveState.altAppearances = this.altAppearances;
            }
            if (this.lights.size() > 0) {
                setLiveState.lights = this.lights;
            }
            if (this.modelClips.size() > 0) {
                setLiveState.modelClips = this.modelClips;
            }
            setLiveState.branchGroupPaths = this.branchGroupPaths;
            if (!this.inSharedGroup) {
                object = new boolean[1];
                blArray = new boolean[1];
            } else {
                object = new boolean[this.localToVworldKeys.length];
                blArray = new boolean[this.localToVworldKeys.length];
            }
            this.findPickableFlags((boolean[])object);
            super.updatePickable(null, (boolean[])object);
            setLiveState.pickable = (boolean[])object;
            this.findCollidableFlags(blArray);
            super.updateCollidable(null, blArray);
            setLiveState.collidable = blArray;
            if (this.inSharedGroup) {
                setLiveState.switchLevels = new int[this.localToVworldKeys.length];
                setLiveState.closestSwitchParents = new SwitchRetained[this.localToVworldKeys.length];
                setLiveState.closestSwitchIndices = new int[this.localToVworldKeys.length];
                n2 = 0;
                while (n2 < this.localToVworldKeys.length) {
                    setLiveState.switchLevels[n2] = -1;
                    setLiveState.closestSwitchParents[n2] = null;
                    setLiveState.closestSwitchIndices[n2] = -1;
                    ++n2;
                }
            }
            this.resetSwitchStates(setLiveState, this, nodeRetained, nodeRetained2);
            nodeRetained.setLive(setLiveState);
            if (this.parentSwitchLink != null) {
                if (this.parentSwitchLink instanceof SwitchRetained) {
                    ((SwitchRetained)this.parentSwitchLink).traverseSwitchParent();
                } else if (this.parentSwitchLink instanceof SharedGroupRetained) {
                    ((SharedGroupRetained)this.parentSwitchLink).traverseSwitchParent();
                }
            }
            setLiveState.currentTransforms = transform3DArray;
            setLiveState.lastTransforms = transform3DArray2;
            if (this.nodeType == 24) {
                transformGroupRetained = (TransformGroupRetained)this;
                transformGroupRetained.targetThreads |= setLiveState.transformTargetThreads;
                Object[] objectArray = new Object[transformGroupRetained.targets.length + arrayList.size() + arrayList2.size()];
                int n3 = 0;
                n2 = 0;
                while (n2 < transformGroupRetained.targets.length) {
                    objectArray[n3] = transformGroupRetained.targets[n2];
                    ++n2;
                    ++n3;
                }
                n2 = 0;
                while (n2 < arrayList.size()) {
                    objectArray[n3] = arrayList.get(n2);
                    ++n2;
                    ++n3;
                }
                transformGroupRetained.boundingLeafTargetStartIndex = n3;
                n2 = 0;
                while (n2 < arrayList2.size()) {
                    objectArray[n3] = arrayList2.get(n2);
                    ++n2;
                    ++n3;
                }
                transformGroupRetained.targets = objectArray;
            }
            if (this.parentTransformGroups != null) {
                n2 = 0;
                while (n2 < this.parentTransformGroups.length) {
                    cloneable = this.parentTransformGroups[n2];
                    int n4 = 0;
                    while (n4 < ((ArrayList)cloneable).size()) {
                        transformGroupRetained = (TransformGroupRetained)((ArrayList)cloneable).get(n4);
                        transformGroupRetained.updateTargets(null, setLiveState.transformTargets, null, setLiveState.transformBLTargets, setLiveState.transformTargetThreads);
                        ++n4;
                    }
                    ++n2;
                }
            }
            J3dMessage j3dMessage = j3dMessageArray == null ? VirtualUniverse.mc.getMessage() : j3dMessageArray[n++];
            j3dMessage.threads = setLiveState.notifyThreads;
            j3dMessage.type = 0;
            j3dMessage.universe = this.universe;
            j3dMessage.args[0] = setLiveState.nodeList.toArray();
            if (j3dMessageArray == null) {
                VirtualUniverse.mc.processMessage(j3dMessage);
            }
            n2 = 0;
            while (n2 < setLiveState.behaviorNodes.size()) {
                cloneable = (BehaviorRetained)setLiveState.behaviorNodes.get(n2);
                ((BehaviorRetained)cloneable).executeInitialize();
                ++n2;
            }
            setLiveState.behaviorNodes.clear();
            j3dMessage = VirtualUniverse.mc.getMessage();
            j3dMessage.threads = 256;
            j3dMessage.type = 49;
            j3dMessage.universe = this.universe;
            VirtualUniverse.mc.processMessage(j3dMessage);
            if (this.nodeType == 18) {
                cloneable = (SwitchRetained)this;
                ((SwitchRetained)cloneable).setWhichChild(((SwitchRetained)cloneable).whichChild, true);
            }
            setLiveState.fogs = null;
            setLiveState.lights = null;
            setLiveState.modelClips = null;
            setLiveState.altAppearances = null;
        }
    }

    void checkSetLive(NodeRetained nodeRetained, J3dMessage[] j3dMessageArray, int n, NodeRetained nodeRetained2) {
        this.checkSetLive(nodeRetained, this.localToVworldKeys, this.inSharedGroup, j3dMessageArray, n, nodeRetained2);
    }

    void checkValidChild(Node node, String string) {
        if (node != null && (node instanceof BranchGroup && ((BranchGroupRetained)node.retained).attachedToLocale || ((NodeRetained)node.retained).parent != null)) {
            throw new MultipleParentException(J3dI18N.getString(string));
        }
    }

    void clearLive(SetLiveState setLiveState) {
        NodeRetained nodeRetained;
        int n;
        int n2;
        int n3;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        if (setLiveState.fogs != null || this.fogs.size() > 0 || setLiveState.lights != null || this.lights.size() > 0 || setLiveState.altAppearances != null || this.altAppearances.size() > 0 || setLiveState.modelClips != null || this.modelClips.size() > 0) {
            if (setLiveState.fogs != null) {
                n5 = setLiveState.fogs.size();
                n3 = 0;
                while (n3 < n5) {
                    ((AbstractCollection)this.fogs).remove(setLiveState.fogs.get(n3));
                    ++n3;
                }
            } else if (this.fogs.size() > 0) {
                setLiveState.fogs = new ArrayList();
            }
            if (setLiveState.lights != null) {
                n4 = setLiveState.lights.size();
                n3 = 0;
                while (n3 < n4) {
                    ((AbstractCollection)this.lights).remove(setLiveState.lights.get(n3));
                    ++n3;
                }
            } else if (this.lights.size() > 0) {
                setLiveState.lights = new ArrayList();
            }
            if (setLiveState.modelClips != null) {
                n6 = setLiveState.modelClips.size();
                n3 = 0;
                while (n3 < n6) {
                    ((AbstractCollection)this.modelClips).remove(setLiveState.modelClips.get(n3));
                    ++n3;
                }
            } else if (this.modelClips.size() > 0) {
                setLiveState.modelClips = new ArrayList();
            }
            if (setLiveState.altAppearances != null) {
                n7 = setLiveState.altAppearances.size();
                n3 = 0;
                while (n3 < n7) {
                    ((AbstractCollection)this.altAppearances).remove(setLiveState.altAppearances.get(n3));
                    ++n3;
                }
            } else if (this.altAppearances.size() > 0) {
                setLiveState.altAppearances = new ArrayList();
            }
            int n8 = this.lights.size();
            n3 = 0;
            while (n3 < n8) {
                setLiveState.lights.add(this.lights.get(n3));
                ++n3;
            }
            int n9 = this.fogs.size();
            n3 = 0;
            while (n3 < n9) {
                setLiveState.fogs.add(this.fogs.get(n3));
                ++n3;
            }
            n2 = this.modelClips.size();
            n3 = 0;
            while (n3 < n2) {
                setLiveState.modelClips.add(this.modelClips.get(n3));
                ++n3;
            }
            int n10 = this.altAppearances.size();
            n3 = 0;
            while (n3 < n10) {
                setLiveState.altAppearances.add(this.altAppearances.get(n3));
                ++n3;
            }
            n = this.children.size();
            n3 = 0;
            while (n3 < n) {
                nodeRetained = (NodeRetained)this.children.elementAt(n3);
                if (nodeRetained != null) {
                    nodeRetained.clearLive(setLiveState);
                    if (this instanceof OrderedGroupRetained) {
                        setLiveState.ogList.add(this);
                        setLiveState.ogChildIdList.add(new Integer(n3));
                    }
                }
                ++n3;
            }
            n3 = n5 + n9 - 1;
            while (n3 >= n5) {
                setLiveState.fogs.remove(n5);
                --n3;
            }
            n3 = n6 + n2 - 1;
            while (n3 >= n6) {
                setLiveState.fogs.remove(n6);
                --n3;
            }
            n3 = n4 + n8 - 1;
            while (n3 >= n4) {
                setLiveState.lights.remove(n4);
                --n3;
            }
            n3 = n7 + n10 - 1;
            while (n3 >= n7) {
                setLiveState.altAppearances.remove(n7);
                --n3;
            }
        } else {
            n = this.children.size();
            n3 = 0;
            while (n3 < n) {
                nodeRetained = (NodeRetained)this.children.elementAt(n3);
                if (nodeRetained != null) {
                    nodeRetained.clearLive(setLiveState);
                }
                if (this instanceof OrderedGroupRetained) {
                    setLiveState.ogList.add(this);
                    setLiveState.ogChildIdList.add(new Integer(n3));
                }
                ++n3;
            }
        }
        if (this.inOrderedGroup) {
            this.orderedGroupsPath = null;
            this.orderedChildIdsPath = null;
        }
        if (this.collisionTarget) {
            if (this.inSharedGroup) {
                n3 = setLiveState.keys.length - 1;
                while (n3 >= 0) {
                    HashKey hashKey = setLiveState.keys[n3];
                    n2 = this.mirrorGroup.size() - 1;
                    if (n2 >= 0) {
                        GroupRetained groupRetained = (GroupRetained)this.mirrorGroup.get(n2);
                        if (groupRetained.key.equals(hashKey)) {
                            setLiveState.nodeList.add(this.mirrorGroup.remove(n2));
                        }
                    }
                    --n3;
                }
            } else {
                setLiveState.nodeList.add(this.mirrorGroup.remove(0));
            }
        }
        this.closestSwitchParent = null;
        this.closestSwitchIndex = -1;
        super.clearLive(setLiveState);
    }

    public BoundingBox computeBoundingHull() {
        return this.vwcBounds;
    }

    void computeCombineBounds(Bounds bounds) {
        if (this.boundsAutoCompute) {
            int n = this.children.size() - 1;
            while (n >= 0) {
                NodeRetained nodeRetained = (NodeRetained)this.children.elementAt(n);
                if (nodeRetained != null) {
                    nodeRetained.computeCombineBounds(bounds);
                }
                --n;
            }
        } else {
            Bounds bounds2 = this.localBounds;
            synchronized (bounds2) {
                bounds.combine(this.localBounds);
            }
        }
    }

    void createMirrorGroup() {
        Bounds bounds;
        this.mirrorGroup = new ArrayList();
        Bounds bounds2 = bounds = this.collisionBound != null ? this.collisionBound : this.getBounds();
        if (this.inSharedGroup) {
            int n = 0;
            while (n < this.localToVworldKeys.length) {
                GroupRetained groupRetained = new GroupRetained();
                groupRetained.key = this.localToVworldKeys[n];
                groupRetained.currentLocalToVworld = new Transform3D[1];
                groupRetained.currentLocalToVworld[0] = this.currentLocalToVworld[n];
                groupRetained.vwcBounds = new BoundingBox();
                groupRetained.vwcBounds.transform(bounds, groupRetained.currentLocalToVworld[0]);
                groupRetained.sourceNode = this;
                groupRetained.locale = this.locale;
                this.mirrorGroup.add(groupRetained);
                ++n;
            }
        } else {
            GroupRetained groupRetained = new GroupRetained();
            groupRetained.currentLocalToVworld = new Transform3D[1];
            groupRetained.currentLocalToVworld[0] = this.currentLocalToVworld[0];
            groupRetained.vwcBounds = new BoundingBox();
            groupRetained.vwcBounds.transform(bounds, groupRetained.currentLocalToVworld[0]);
            groupRetained.sourceNode = this;
            groupRetained.locale = this.locale;
            this.mirrorGroup.add(groupRetained);
        }
    }

    void doAddChild(Node node, J3dMessage[] j3dMessageArray, int n) {
        if (this instanceof SwitchRetained || this instanceof SharedGroupRetained) {
            this.appendChildrenSwitchData();
        }
        if (node == null) {
            this.children.addElement(null);
            return;
        }
        NodeRetained nodeRetained = (NodeRetained)node.retained;
        nodeRetained.setParent(this);
        this.children.addElement(nodeRetained);
        if (this instanceof OrderedGroupRetained && this.source.isLive()) {
            J3dMessage j3dMessage;
            OrderedGroupRetained orderedGroupRetained = (OrderedGroupRetained)this;
            orderedGroupRetained.newChildId = orderedGroupRetained.getOrderedChildId();
            if (j3dMessageArray == null) {
                j3dMessage = VirtualUniverse.mc.getMessage();
            } else {
                j3dMessage = j3dMessageArray[n];
                ++n;
            }
            j3dMessage.threads = 128;
            j3dMessage.type = 32;
            j3dMessage.universe = this.universe;
            j3dMessage.args[0] = this;
            j3dMessage.args[1] = new Integer(this.children.size() - 1);
            j3dMessage.args[2] = orderedGroupRetained.newChildId;
            if (j3dMessageArray == null) {
                VirtualUniverse.mc.processMessage(j3dMessage);
            }
        }
        this.checkSetLive(nodeRetained, j3dMessageArray, n, null);
        if (this.source.isLive()) {
            ((BranchGroupRetained)nodeRetained).isNew = true;
        }
    }

    void doInsertChild(Node node, int n) {
        if (this instanceof SwitchRetained || this instanceof SharedGroupRetained) {
            this.insertChildrenSwitchData(n);
        }
        int n2 = n;
        while (n2 < this.children.size()) {
            NodeRetained nodeRetained = (NodeRetained)this.children.elementAt(n2);
            if (nodeRetained != null) {
                ++nodeRetained.childIndex;
            }
            ++n2;
        }
        if (node == null) {
            this.children.insertElementAt(null, n);
            return;
        }
        NodeRetained nodeRetained = (NodeRetained)node.retained;
        nodeRetained.setParent(this);
        this.children.insertElementAt(nodeRetained, n);
        if (this instanceof OrderedGroupRetained && this.source.isLive()) {
            OrderedGroupRetained orderedGroupRetained = (OrderedGroupRetained)this;
            orderedGroupRetained.newChildId = orderedGroupRetained.getOrderedChildId();
            J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
            j3dMessage.threads = 128;
            j3dMessage.type = 32;
            j3dMessage.universe = this.universe;
            j3dMessage.args[0] = this;
            j3dMessage.args[1] = new Integer(n);
            j3dMessage.args[2] = orderedGroupRetained.newChildId;
            VirtualUniverse.mc.processMessage(j3dMessage);
        }
        this.checkSetLive(nodeRetained, null, 0, null);
        if (this.source.isLive()) {
            ((BranchGroupRetained)nodeRetained).isNew = true;
        }
    }

    void doMoveTo(BranchGroup branchGroup) {
        J3dMessage[] j3dMessageArray = null;
        int n = 2;
        int n2 = 0;
        int n3 = 1;
        if (branchGroup != null) {
            BranchGroupRetained branchGroupRetained = (BranchGroupRetained)branchGroup.retained;
            GroupRetained groupRetained = (GroupRetained)branchGroupRetained.parent;
            int n4 = groupRetained.children.indexOf(branchGroupRetained);
            if (groupRetained instanceof OrderedGroupRetained) {
                ++n;
                ++n3;
            }
            if (this instanceof OrderedGroupRetained) {
                ++n;
            }
            j3dMessageArray = new J3dMessage[n];
            int n5 = 0;
            while (n5 < n) {
                j3dMessageArray[n5] = VirtualUniverse.mc.getMessage();
                ++n5;
            }
            if (groupRetained == null) {
                if (branchGroupRetained.locale != null) {
                    branchGroupRetained.locale.doRemoveBranchGraph(branchGroup, j3dMessageArray, n2);
                }
            } else {
                groupRetained.doRemoveChild(n4, j3dMessageArray, n2);
            }
        }
        this.doAddChild(branchGroup, j3dMessageArray, n3);
        if (branchGroup != null) {
            VirtualUniverse.mc.processMessage(j3dMessageArray);
        }
    }

    void doRemoveChild(int n, J3dMessage[] j3dMessageArray, int n2) {
        NodeRetained nodeRetained = (NodeRetained)this.children.elementAt(n);
        int n3 = n;
        while (n3 < this.children.size()) {
            NodeRetained nodeRetained2 = (NodeRetained)this.children.elementAt(n3);
            if (nodeRetained2 != null) {
                --nodeRetained2.childIndex;
            }
            ++n3;
        }
        if (nodeRetained != null) {
            nodeRetained.setParent(null);
            this.checkClearLive(nodeRetained, j3dMessageArray, n2, n);
        }
        this.children.removeElementAt(n);
        if (this instanceof SwitchRetained || this instanceof SharedGroupRetained) {
            this.removeChildrenSwitchData(n);
        }
        if (this.nodeType == 18) {
            SwitchRetained switchRetained = (SwitchRetained)this;
            switchRetained.setWhichChild(switchRetained.whichChild, true);
        }
    }

    void doSetChild(Node node, int n) {
        NodeRetained nodeRetained;
        if (this instanceof SwitchRetained || this instanceof SharedGroupRetained) {
            this.replaceChildrenSwitchData(n);
        }
        if ((nodeRetained = (NodeRetained)this.children.elementAt(n)) != null) {
            nodeRetained.setParent(null);
            this.checkClearLive(nodeRetained, null, 0, n);
        }
        if (node == null) {
            this.children.setElementAt(null, n);
            return;
        }
        NodeRetained nodeRetained2 = (NodeRetained)node.retained;
        nodeRetained2.setParent(this);
        this.children.setElementAt(nodeRetained2, n);
        if (this instanceof OrderedGroupRetained && this.source.isLive()) {
            OrderedGroupRetained orderedGroupRetained = (OrderedGroupRetained)this;
            orderedGroupRetained.newChildId = orderedGroupRetained.getOrderedChildId();
            J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
            j3dMessage.threads = 128;
            j3dMessage.type = 32;
            j3dMessage.universe = this.universe;
            j3dMessage.args[0] = this;
            j3dMessage.args[1] = new Integer(n);
            j3dMessage.args[2] = orderedGroupRetained.newChildId;
            VirtualUniverse.mc.processMessage(j3dMessage);
        }
        this.checkSetLive(nodeRetained2, null, 0, null);
        if (this.source.isLive()) {
            ((BranchGroupRetained)nodeRetained2).isNew = true;
        }
    }

    void doSetLive(SetLiveState setLiveState) {
        Cloneable cloneable;
        int n;
        Object object;
        int n2;
        int n3 = -1;
        BoundingSphere boundingSphere = new BoundingSphere();
        super.doSetLive(setLiveState);
        this.locale = setLiveState.locale;
        int n4 = this.children.size();
        boolean bl = setLiveState.fogs != null || this.fogs.size() > 0 || setLiveState.lights != null || this.lights.size() > 0 || setLiveState.modelClips != null || this.modelClips.size() > 0 || setLiveState.altAppearances != null || this.altAppearances.size() > 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        if (bl) {
            if (setLiveState.fogs != null) {
                n5 = setLiveState.fogs.size();
            } else if (this.fogs.size() > 0) {
                setLiveState.fogs = new ArrayList();
            }
            if (setLiveState.lights != null) {
                n6 = setLiveState.lights.size();
            } else if (this.lights.size() > 0) {
                setLiveState.lights = new ArrayList();
            }
            if (setLiveState.modelClips != null) {
                n7 = setLiveState.modelClips.size();
            } else if (this.modelClips.size() > 0) {
                setLiveState.modelClips = new ArrayList();
            }
            if (setLiveState.altAppearances != null) {
                n8 = setLiveState.altAppearances.size();
            } else if (this.altAppearances.size() > 0) {
                setLiveState.altAppearances = new ArrayList();
            }
            n10 = n6;
            n9 = n5;
            n11 = n7;
            n12 = n8;
            n2 = 0;
            while (n2 < this.fogs.size()) {
                setLiveState.fogs.add(this.fogs.get(n2));
                ++n2;
            }
            if (setLiveState.fogs != null) {
                n9 = setLiveState.fogs.size();
            }
            n2 = 0;
            while (n2 < this.lights.size()) {
                setLiveState.lights.add(this.lights.get(n2));
                ++n2;
            }
            if (setLiveState.lights != null) {
                n10 = setLiveState.lights.size();
            }
            n2 = 0;
            while (n2 < this.modelClips.size()) {
                setLiveState.modelClips.add(this.modelClips.get(n2));
                ++n2;
            }
            if (setLiveState.modelClips != null) {
                n11 = setLiveState.modelClips.size();
            }
            n2 = 0;
            while (n2 < this.altAppearances.size()) {
                setLiveState.altAppearances.add(this.altAppearances.get(n2));
                ++n2;
            }
            if (setLiveState.altAppearances != null) {
                n12 = setLiveState.altAppearances.size();
            }
            n2 = 0;
            while (n2 < n5) {
                this.fogs.add(setLiveState.fogs.get(n2));
                ++n2;
            }
            n2 = 0;
            while (n2 < n6) {
                this.lights.add(setLiveState.lights.get(n2));
                ++n2;
            }
            n2 = 0;
            while (n2 < n7) {
                this.modelClips.add(setLiveState.modelClips.get(n2));
                ++n2;
            }
            n2 = 0;
            while (n2 < n8) {
                this.altAppearances.add(setLiveState.altAppearances.get(n2));
                ++n2;
            }
        }
        if (this.inOrderedGroup) {
            this.orderedGroupsPath = (ArrayList)setLiveState.orderedGroupsPath.clone();
            this.orderedChildIdsPath = (ArrayList)setLiveState.orderedChildIdsPath.clone();
        }
        if (this instanceof OrderedGroupRetained) {
            setLiveState.inOrderedGroup = true;
            setLiveState.orderedGroupsPath.add(this);
            n3 = setLiveState.orderedGroupsPath.size() - 1;
        }
        ArrayList arrayList = setLiveState.branchGroupPaths;
        boolean[] blArray = (boolean[])setLiveState.pickable.clone();
        boolean[] blArray2 = (boolean[])setLiveState.collidable.clone();
        boolean[] blArray3 = new boolean[blArray.length];
        boolean[] blArray4 = new boolean[blArray2.length];
        int n13 = this.lights.size();
        int n14 = this.fogs.size();
        int n15 = this.modelClips.size();
        int n16 = this.altAppearances.size();
        n2 = 0;
        while (n2 < n4) {
            int n17;
            if (this instanceof SwitchRetained) {
                object = (SwitchRetained)this;
                setLiveState.childSwitchLinks = (ArrayList)((GroupRetained)object).childrenSwitchLinks.get(n2);
                setLiveState.containsNodesList = (ContainsNodesList)((GroupRetained)object).childrenContainsNodesList.get(n2);
                n = 0;
                while (n < setLiveState.switchLevels.length) {
                    setLiveState.closestSwitchIndices[n] = this.switchIndexCount;
                    setLiveState.closestSwitchParents[n] = object;
                    ++n;
                }
                ++this.switchIndexCount;
            } else if (this instanceof SharedGroupRetained) {
                object = (SharedGroupRetained)this;
                setLiveState.childSwitchLinks = (ArrayList)((GroupRetained)object).childrenSwitchLinks.get(n2);
                setLiveState.containsNodesList = (ContainsNodesList)((GroupRetained)object).childrenContainsNodesList.get(n2);
            }
            NodeRetained nodeRetained = (NodeRetained)this.children.elementAt(n2);
            if (this instanceof OrderedGroupRetained) {
                cloneable = (OrderedGroupRetained)this;
                cloneable.newChildId = cloneable.getOrderedChildId();
                object = VirtualUniverse.mc.getMessage();
                ((J3dMessage)object).threads = 128;
                ((J3dMessage)object).type = 32;
                ((J3dMessage)object).universe = this.universe;
                ((J3dMessage)object).args[0] = this;
                ((J3dMessage)object).args[1] = new Integer(n2);
                ((J3dMessage)object).args[2] = cloneable.newChildId;
                VirtualUniverse.mc.processMessage((J3dMessage)object);
                setLiveState.orderedChildIdsPath.add(cloneable.newChildId);
            }
            System.arraycopy(blArray, 0, blArray3, 0, blArray.length);
            System.arraycopy(blArray2, 0, blArray4, 0, blArray2.length);
            setLiveState.pickable = blArray3;
            setLiveState.collidable = blArray4;
            setLiveState.branchGroupPaths = arrayList;
            if (n13 < this.lights.size()) {
                if (setLiveState.lights == null) {
                    setLiveState.lights = new ArrayList();
                }
                n17 = n13;
                while (n17 < this.lights.size()) {
                    setLiveState.lights.add(this.lights.get(n17));
                    ++n10;
                    ++n17;
                }
                n13 = this.lights.size();
                bl = true;
            }
            if (n14 < this.fogs.size()) {
                if (setLiveState.fogs == null) {
                    setLiveState.fogs = new ArrayList();
                }
                n17 = n14;
                while (n17 < this.fogs.size()) {
                    setLiveState.fogs.add(this.fogs.get(n17));
                    ++n9;
                    ++n17;
                }
                n14 = this.fogs.size();
                bl = true;
            }
            if (n15 < this.modelClips.size()) {
                if (setLiveState.modelClips == null) {
                    setLiveState.modelClips = new ArrayList();
                }
                n17 = n15;
                while (n17 < this.modelClips.size()) {
                    setLiveState.modelClips.add(this.modelClips.get(n17));
                    ++n11;
                    ++n17;
                }
                n15 = this.modelClips.size();
                bl = true;
            }
            if (n16 < this.altAppearances.size()) {
                if (setLiveState.altAppearances == null) {
                    setLiveState.altAppearances = new ArrayList();
                }
                n17 = n16;
                while (n17 < this.altAppearances.size()) {
                    setLiveState.altAppearances.add(this.altAppearances.get(n17));
                    ++n12;
                    ++n17;
                }
                n16 = this.altAppearances.size();
                bl = true;
            }
            if (nodeRetained != null) {
                nodeRetained.setLive(setLiveState);
            }
            if (this instanceof OrderedGroupRetained) {
                setLiveState.orderedChildIdsPath.remove(n3);
            }
            ++n2;
        }
        setLiveState.inOrderedGroup = this.inOrderedGroup;
        if (this instanceof OrderedGroupRetained) {
            setLiveState.orderedGroupsPath.remove(n3);
        }
        if (bl) {
            n2 = n5;
            while (n2 < n9) {
                setLiveState.fogs.remove(n5);
                ++n2;
            }
            n2 = n7;
            while (n2 < n11) {
                setLiveState.modelClips.remove(n7);
                ++n2;
            }
            n2 = n6;
            while (n2 < n10) {
                setLiveState.lights.remove(n6);
                ++n2;
            }
            n2 = n8;
            while (n2 < n12) {
                setLiveState.altAppearances.remove(n8);
                ++n2;
            }
        }
        if (this.collisionTarget) {
            if (this.mirrorGroup == null) {
                this.mirrorGroup = new ArrayList();
            }
            Cloneable cloneable2 = cloneable = this.collisionBound != null ? this.collisionBound : this.getBounds();
            if (this.inSharedGroup) {
                n2 = 0;
                while (n2 < setLiveState.keys.length) {
                    object = new GroupRetained();
                    ((GroupRetained)object).key = setLiveState.keys[n2];
                    ((NodeRetained)object).currentLocalToVworld = new Transform3D[1];
                    n = 0;
                    while (n < this.currentLocalToVworld.length) {
                        if (this.localToVworldKeys[n].equals(((GroupRetained)object).key)) break;
                        ++n;
                    }
                    ((GroupRetained)object).vwcBounds = new BoundingBox();
                    ((NodeRetained)object).currentLocalToVworld[0] = this.currentLocalToVworld[n];
                    ((GroupRetained)object).vwcBounds.transform((Bounds)cloneable, ((NodeRetained)object).currentLocalToVworld[0]);
                    ((GroupRetained)object).sourceNode = this;
                    ((GroupRetained)object).locale = this.locale;
                    this.mirrorGroup.add(object);
                    setLiveState.transformTargets.add(object);
                    setLiveState.nodeList.add(object);
                    ++n2;
                }
            } else {
                object = new GroupRetained();
                ((NodeRetained)object).currentLocalToVworld = new Transform3D[1];
                ((NodeRetained)object).currentLocalToVworld[0] = this.currentLocalToVworld[0];
                ((GroupRetained)object).vwcBounds = new BoundingBox();
                ((GroupRetained)object).vwcBounds.transform((Bounds)cloneable, ((NodeRetained)object).currentLocalToVworld[0]);
                ((GroupRetained)object).sourceNode = this;
                ((GroupRetained)object).locale = this.locale;
                this.mirrorGroup.add(object);
                setLiveState.transformTargets.add(object);
                setLiveState.nodeList.add(object);
            }
        }
    }

    Enumeration getAllChildren() {
        Vector<SceneGraphObject> vector = new Vector<SceneGraphObject>(this.children.size());
        Enumeration enumeration = this.children.elements();
        while (enumeration.hasMoreElements()) {
            SceneGraphObjectRetained sceneGraphObjectRetained = (SceneGraphObjectRetained)enumeration.nextElement();
            if (sceneGraphObjectRetained == null) {
                vector.addElement(null);
                continue;
            }
            vector.addElement(sceneGraphObjectRetained.source);
        }
        return vector.elements();
    }

    void getAllScopedNodes(ArrayList arrayList, HashKey hashKey) {
        arrayList.add(this);
        if (this.source.isLive() || this.isInSetLive()) {
            int n = this.children.size() - 1;
            while (n >= 0) {
                NodeRetained nodeRetained = (NodeRetained)this.children.elementAt(n);
                if (nodeRetained != null) {
                    if (nodeRetained instanceof GroupRetained && (nodeRetained.source.isLive() || nodeRetained.isInSetLive())) {
                        ((GroupRetained)nodeRetained).getAllScopedNodes(arrayList, hashKey);
                    } else if (nodeRetained instanceof LinkRetained && (nodeRetained.source.isLive() || nodeRetained.isInSetLive())) {
                        int n2 = hashKey.count;
                        LinkRetained linkRetained = (LinkRetained)nodeRetained;
                        if (hashKey.count == 0) {
                            hashKey.append(this.locale.nodeId);
                        }
                        linkRetained.sharedGroup.getAllScopedNodes(arrayList, hashKey.append("+").append(linkRetained.nodeId));
                        hashKey.count = n2;
                    } else if (nodeRetained instanceof Shape3DRetained && nodeRetained.source.isLive()) {
                        ((Shape3DRetained)nodeRetained).getAllScopedNodes(arrayList, hashKey);
                    } else if (nodeRetained instanceof MorphRetained && nodeRetained.source.isLive()) {
                        ((MorphRetained)nodeRetained).getAllScopedNodes(arrayList, hashKey);
                    }
                }
                --n;
            }
        }
    }

    boolean getAlternateCollisionTarget() {
        return this.collisionTarget;
    }

    Bounds getBounds() {
        if (this.boundsAutoCompute) {
            BoundingSphere boundingSphere = new BoundingSphere();
            boundingSphere.setRadius(-1.0);
            int n = this.children.size() - 1;
            while (n >= 0) {
                NodeRetained nodeRetained = (NodeRetained)this.children.elementAt(n);
                if (nodeRetained != null) {
                    nodeRetained.computeCombineBounds(boundingSphere);
                }
                --n;
            }
            if (boundingSphere.getRadius() == -1.0) {
                return super.getBounds();
            }
            return boundingSphere;
        }
        return super.getBounds();
    }

    Node getChild(int n) {
        SceneGraphObjectRetained sceneGraphObjectRetained = (SceneGraphObjectRetained)this.children.elementAt(n);
        if (sceneGraphObjectRetained == null) {
            return null;
        }
        return (Node)sceneGraphObjectRetained.source;
    }

    Bounds getCollisionBounds() {
        return this.collisionBound == null ? null : (Bounds)this.collisionBound.clone();
    }

    public Locale getLocale2() {
        return this.locale;
    }

    void insertChild(Node node, int n) {
        this.checkValidChild(node, "GroupRetained1");
        if (this.source.isLive()) {
            Object object = this.universe.sceneGraphLock;
            synchronized (object) {
                this.doInsertChild(node, n);
            }
        } else {
            this.doInsertChild(node, n);
        }
    }

    void insertChildrenSwitchData(int n) {
        this.childrenContainsNodesList.add(n, new ContainsNodesList());
        this.childrenSwitchLinks.add(n, new ArrayList(1));
    }

    public boolean isEnable() {
        return GroupRetained.isNodeSwitchOn(this.sourceNode, this.key);
    }

    public boolean isEnable(int n) {
        return GroupRetained.isNodeSwitchOn(this.sourceNode, this.key);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean isNodeSwitchOn(NodeRetained nodeRetained, HashKey hashKey) {
        NodeRetained nodeRetained2 = null;
        if (hashKey != null) {
            hashKey = new HashKey(hashKey);
        }
        Object object = nodeRetained.universe.sceneGraphLock;
        synchronized (object) {
            do {
                if (nodeRetained instanceof SwitchRetained && nodeRetained2 != null && !GroupRetained.validSwitchChild((SwitchRetained)nodeRetained, nodeRetained2)) {
                    return false;
                }
                nodeRetained2 = nodeRetained;
                if (nodeRetained instanceof SharedGroupRetained) {
                    String string = hashKey.getLastNodeId();
                    Vector vector = ((SharedGroupRetained)nodeRetained).parents;
                    int n = vector.size() - 1;
                    while (n >= 0) {
                        NodeRetained nodeRetained3 = (NodeRetained)vector.elementAt(n);
                        if (nodeRetained3.nodeId.equals(string)) {
                            nodeRetained = nodeRetained3;
                            break;
                        }
                        --n;
                    }
                    if (nodeRetained != nodeRetained2) continue;
                    return false;
                }
                nodeRetained = nodeRetained.parent;
            } while (nodeRetained != null);
            return true;
        }
    }

    boolean isStaticChildren() {
        return !this.source.getCapability(12) && !this.source.getCapability(13) && !this.source.getCapability(1);
    }

    void markAllNodesForScopedAltApp(AlternateAppearanceRetained alternateAppearanceRetained, HashKey hashKey) {
        this.addAltApp(alternateAppearanceRetained);
        if (this.source.isLive() || this.isInSetLive()) {
            int n = this.children.size() - 1;
            while (n >= 0) {
                NodeRetained nodeRetained = (NodeRetained)this.children.elementAt(n);
                if (nodeRetained != null) {
                    if (nodeRetained instanceof GroupRetained && (nodeRetained.source.isLive() || nodeRetained.isInSetLive())) {
                        ((GroupRetained)nodeRetained).markAllNodesForScopedAltApp(alternateAppearanceRetained, hashKey);
                    } else if (nodeRetained instanceof LinkRetained && (nodeRetained.source.isLive() || nodeRetained.isInSetLive())) {
                        int n2 = hashKey.count;
                        LinkRetained linkRetained = (LinkRetained)nodeRetained;
                        if (hashKey.count == 0) {
                            hashKey.append(this.locale.nodeId);
                        }
                        linkRetained.sharedGroup.markAllNodesForScopedAltApp(alternateAppearanceRetained, hashKey.append("+").append(linkRetained.nodeId));
                        hashKey.count = n2;
                    } else if (nodeRetained instanceof Shape3DRetained && nodeRetained.source.isLive()) {
                        ((Shape3DRetained)nodeRetained).markAllNodesForScopedAltApp(alternateAppearanceRetained, hashKey);
                    } else if (nodeRetained instanceof MorphRetained && nodeRetained.source.isLive()) {
                        ((MorphRetained)nodeRetained).markAllNodesForScopedAltApp(alternateAppearanceRetained, hashKey);
                    }
                }
                --n;
            }
        }
    }

    void markAllNodesForScopedFog(FogRetained fogRetained, HashKey hashKey) {
        this.addFog(fogRetained);
        if (this.source.isLive() || this.isInSetLive()) {
            int n = this.children.size() - 1;
            while (n >= 0) {
                NodeRetained nodeRetained = (NodeRetained)this.children.elementAt(n);
                if (nodeRetained != null) {
                    if (nodeRetained instanceof GroupRetained && (nodeRetained.source.isLive() || nodeRetained.isInSetLive())) {
                        ((GroupRetained)nodeRetained).markAllNodesForScopedFog(fogRetained, hashKey);
                    } else if (nodeRetained instanceof LinkRetained && (nodeRetained.source.isLive() || nodeRetained.isInSetLive())) {
                        int n2 = hashKey.count;
                        LinkRetained linkRetained = (LinkRetained)nodeRetained;
                        if (hashKey.count == 0) {
                            hashKey.append(this.locale.nodeId);
                        }
                        linkRetained.sharedGroup.markAllNodesForScopedFog(fogRetained, hashKey.append("+").append(linkRetained.nodeId));
                        hashKey.count = n2;
                    } else if (nodeRetained instanceof Shape3DRetained && nodeRetained.source.isLive()) {
                        ((Shape3DRetained)nodeRetained).markAllNodesForScopedFog(fogRetained, hashKey);
                    } else if (nodeRetained instanceof MorphRetained && nodeRetained.source.isLive()) {
                        ((MorphRetained)nodeRetained).markAllNodesForScopedFog(fogRetained, hashKey);
                    }
                }
                --n;
            }
        }
    }

    void markAllNodesForScopedLight(LightRetained lightRetained, HashKey hashKey) {
        this.addLight(lightRetained);
        if (this.source.isLive() || this.isInSetLive()) {
            int n = this.children.size() - 1;
            while (n >= 0) {
                NodeRetained nodeRetained = (NodeRetained)this.children.elementAt(n);
                if (nodeRetained != null) {
                    if (nodeRetained instanceof GroupRetained && (nodeRetained.source.isLive() || nodeRetained.isInSetLive())) {
                        ((GroupRetained)nodeRetained).markAllNodesForScopedLight(lightRetained, hashKey);
                    } else if (nodeRetained instanceof LinkRetained && (nodeRetained.source.isLive() || nodeRetained.isInSetLive())) {
                        int n2 = hashKey.count;
                        LinkRetained linkRetained = (LinkRetained)nodeRetained;
                        if (hashKey.count == 0) {
                            hashKey.append(this.locale.nodeId);
                        }
                        linkRetained.sharedGroup.markAllNodesForScopedLight(lightRetained, hashKey.append("+").append(linkRetained.nodeId));
                        hashKey.count = n2;
                    } else if (nodeRetained instanceof Shape3DRetained && nodeRetained.source.isLive()) {
                        ((Shape3DRetained)nodeRetained).markAllNodesForScopedLight(lightRetained, hashKey);
                    } else if (nodeRetained instanceof MorphRetained && nodeRetained.source.isLive()) {
                        ((MorphRetained)nodeRetained).markAllNodesForScopedLight(lightRetained, hashKey);
                    }
                }
                --n;
            }
        }
    }

    void markAllNodesForScopedModelClip(ModelClipRetained modelClipRetained, HashKey hashKey) {
        this.addModelClip(modelClipRetained);
        if (this.source.isLive() || this.isInSetLive()) {
            int n = this.children.size() - 1;
            while (n >= 0) {
                NodeRetained nodeRetained = (NodeRetained)this.children.elementAt(n);
                if (nodeRetained != null) {
                    if (nodeRetained instanceof GroupRetained && (nodeRetained.source.isLive() || nodeRetained.isInSetLive())) {
                        ((GroupRetained)nodeRetained).markAllNodesForScopedModelClip(modelClipRetained, hashKey);
                    } else if (nodeRetained instanceof LinkRetained && (nodeRetained.source.isLive() || nodeRetained.isInSetLive())) {
                        int n2 = hashKey.count;
                        LinkRetained linkRetained = (LinkRetained)nodeRetained;
                        if (hashKey.count == 0) {
                            hashKey.append(this.locale.nodeId);
                        }
                        linkRetained.sharedGroup.markAllNodesForScopedModelClip(modelClipRetained, hashKey.append("+").append(linkRetained.nodeId));
                        hashKey.count = n2;
                    } else if (nodeRetained instanceof Shape3DRetained && nodeRetained.source.isLive()) {
                        ((Shape3DRetained)nodeRetained).markAllNodesForScopedModelClip(modelClipRetained, hashKey);
                    } else if (nodeRetained instanceof MorphRetained && nodeRetained.source.isLive()) {
                        ((MorphRetained)nodeRetained).markAllNodesForScopedModelClip(modelClipRetained, hashKey);
                    }
                }
                --n;
            }
        }
    }

    void moveTo(BranchGroup branchGroup) {
        if (this.source.isLive()) {
            Object object = this.universe.sceneGraphLock;
            synchronized (object) {
                this.doMoveTo(branchGroup);
            }
        } else {
            this.doMoveTo(branchGroup);
        }
    }

    int numChildren() {
        return this.children.size();
    }

    void removeAltApp(AlternateAppearanceRetained alternateAppearanceRetained) {
        int n = this.altAppearances.indexOf(alternateAppearanceRetained);
        if (n >= 0) {
            this.altAppearances.remove(n);
        }
    }

    void removeChild(int n) {
        if (this.source.isLive()) {
            Object object = this.universe.sceneGraphLock;
            synchronized (object) {
                this.doRemoveChild(n, null, 0);
            }
        } else {
            this.doRemoveChild(n, null, 0);
        }
    }

    void removeChildrenSwitchData(int n) {
        ContainsNodesList containsNodesList = (ContainsNodesList)this.childrenContainsNodesList.get(n);
        containsNodesList.clearListAndClearContainsNodes();
        this.childrenContainsNodesList.remove(n);
        ArrayList arrayList = (ArrayList)this.childrenSwitchLinks.get(n);
        arrayList.clear();
        this.childrenSwitchLinks.remove(n);
    }

    void removeFog(FogRetained fogRetained) {
        int n = this.fogs.indexOf(fogRetained);
        if (n >= 0) {
            this.fogs.remove(n);
        }
    }

    void removeLight(LightRetained lightRetained) {
        int n = this.lights.indexOf(lightRetained);
        if (n >= 0) {
            this.lights.remove(n);
        }
    }

    void removeModelClip(ModelClipRetained modelClipRetained) {
        int n = this.modelClips.indexOf(modelClipRetained);
        if (n >= 0) {
            this.modelClips.remove(n);
        }
    }

    void replaceChildrenSwitchData(int n) {
        ContainsNodesList containsNodesList = (ContainsNodesList)this.childrenContainsNodesList.get(n);
        containsNodesList.clearListAndClearContainsNodes();
        this.childrenContainsNodesList.set(n, new ContainsNodesList());
        ArrayList arrayList = (ArrayList)this.childrenSwitchLinks.get(n);
        arrayList.clear();
        this.childrenSwitchLinks.set(n, new ArrayList(1));
    }

    void resetSwitchStates(SetLiveState setLiveState, GroupRetained groupRetained, NodeRetained nodeRetained, NodeRetained nodeRetained2) {
        int n;
        int n2;
        NodeRetained nodeRetained3;
        NodeRetained nodeRetained4;
        int n3 = -1;
        if (!this.inSharedGroup) {
            nodeRetained4 = nodeRetained2 == null ? nodeRetained : nodeRetained2;
            nodeRetained3 = groupRetained;
            while (nodeRetained3 != null) {
                if (nodeRetained3 instanceof SwitchRetained) {
                    setLiveState.switchLevels[0] = setLiveState.switchLevels[0] + 1;
                    if (setLiveState.closestSwitchParents[0] == null) {
                        setLiveState.closestSwitchParents[0] = (SwitchRetained)nodeRetained3;
                        setLiveState.closestSwitchIndices[0] = nodeRetained3.children.indexOf(nodeRetained4);
                    }
                    if (n3 == -1) {
                        n3 = nodeRetained3.children.indexOf(nodeRetained4);
                    }
                } else if (nodeRetained3 instanceof SharedGroupRetained && n3 == -1) {
                    n3 = nodeRetained3.children.indexOf(nodeRetained4);
                }
                nodeRetained4 = nodeRetained3;
                nodeRetained3 = nodeRetained4.parent;
            }
        } else {
            n2 = 0;
            while (n2 < this.localToVworldKeys.length) {
                nodeRetained4 = nodeRetained2 == null ? nodeRetained : nodeRetained2;
                nodeRetained3 = groupRetained;
                HashKey hashKey = new HashKey(this.localToVworldKeys[n2]);
                while (nodeRetained3 != null) {
                    if (nodeRetained3 instanceof SwitchRetained) {
                        int n4 = n2;
                        setLiveState.switchLevels[n4] = setLiveState.switchLevels[n4] + 1;
                        if (setLiveState.closestSwitchParents[n2] == null) {
                            setLiveState.closestSwitchParents[n2] = (SwitchRetained)nodeRetained3;
                            setLiveState.closestSwitchIndices[n2] = nodeRetained3.children.indexOf(nodeRetained4);
                        }
                        if (n3 == -1) {
                            n3 = nodeRetained3.children.indexOf(nodeRetained4);
                        }
                    } else if (nodeRetained3 instanceof SharedGroupRetained) {
                        String string = hashKey.getLastNodeId();
                        Vector vector = ((SharedGroupRetained)nodeRetained3).parents;
                        if (n3 == -1) {
                            n3 = nodeRetained3.children.indexOf(nodeRetained4);
                        }
                        n = 0;
                        while (n < vector.size()) {
                            NodeRetained nodeRetained5 = (NodeRetained)vector.elementAt(n);
                            if (nodeRetained5.nodeId.equals(string)) {
                                nodeRetained3 = nodeRetained5;
                                break;
                            }
                            ++n;
                        }
                    }
                    nodeRetained4 = nodeRetained3;
                    nodeRetained3 = nodeRetained4.parent;
                }
                ++n2;
            }
        }
        if (this.nodeType == 18) {
            nodeRetained4 = nodeRetained2 == null ? nodeRetained : nodeRetained2;
            n2 = groupRetained.children.indexOf(nodeRetained4);
            setLiveState.childSwitchLinks = (ArrayList)this.childrenSwitchLinks.get(n2);
            setLiveState.parentSwitchLink = this;
            ContainsNodesList containsNodesList = (ContainsNodesList)this.childrenContainsNodesList.get(n2);
            if (setLiveState.inSharedGroup) {
                n = 0;
                while (n < setLiveState.keys.length) {
                    ContainsNodes containsNodes = new ContainsNodes(setLiveState.keys[n]);
                    containsNodesList.addContainsNodes(containsNodes);
                    ++n;
                }
            } else {
                ContainsNodes containsNodes = new ContainsNodes(null);
                containsNodesList.addContainsNodes(containsNodes);
            }
            setLiveState.containsNodesList = containsNodesList;
        } else if (this.nodeType == 22) {
            nodeRetained4 = nodeRetained2 == null ? nodeRetained : nodeRetained2;
            n2 = groupRetained.children.indexOf(nodeRetained4);
            setLiveState.childSwitchLinks = (ArrayList)this.childrenSwitchLinks.get(n2);
            setLiveState.parentSwitchLink = this;
            ContainsNodesList containsNodesList = (ContainsNodesList)this.childrenContainsNodesList.get(n2);
            if (setLiveState.inSharedGroup) {
                n = 0;
                while (n < setLiveState.keys.length) {
                    ContainsNodes containsNodes = setLiveState.switchLevels[n] >= 0 ? new ContainsNodes(setLiveState.keys[n]) : null;
                    containsNodesList.addContainsNodes(containsNodes);
                    ++n;
                }
            } else {
                ContainsNodes containsNodes = setLiveState.switchLevels[0] >= 0 ? new ContainsNodes(null) : null;
                containsNodesList.addContainsNodes(containsNodes);
            }
            setLiveState.containsNodesList = containsNodesList;
        } else {
            setLiveState.parentSwitchLink = this.parentSwitchLink;
            if (this.parentSwitchLink != null) {
                nodeRetained4 = nodeRetained;
                nodeRetained3 = groupRetained;
                while (nodeRetained3 != this.parentSwitchLink) {
                    nodeRetained4 = nodeRetained3;
                    nodeRetained3 = nodeRetained4.parent;
                }
                n2 = nodeRetained3.children.indexOf(nodeRetained4);
                setLiveState.childSwitchLinks = (ArrayList)this.parentSwitchLink.childrenSwitchLinks.get(n2);
                setLiveState.containsNodesList = (ContainsNodesList)this.parentSwitchLink.childrenContainsNodesList.get(n3);
            }
        }
    }

    void setAlternateCollisionTarget(boolean bl) {
        if (this.collisionTarget == bl) {
            return;
        }
        this.collisionTarget = bl;
        if (this.source.isLive()) {
            J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
            j3dMessage.threads = 64;
            j3dMessage.universe = this.universe;
            if (bl) {
                this.createMirrorGroup();
                if (this.parentTransformGroups != null) {
                    int n = 0;
                    while (n < this.parentTransformGroups.length) {
                        int n2 = 0;
                        while (n2 < this.parentTransformGroups[n].size()) {
                            TransformGroupRetained transformGroupRetained = (TransformGroupRetained)this.parentTransformGroups[n].get(n2);
                            transformGroupRetained.updateTargets(null, this.mirrorGroup);
                            ++n2;
                        }
                        ++n;
                    }
                }
                j3dMessage.type = 0;
                j3dMessage.args[0] = this.mirrorGroup.toArray();
            } else {
                if (this.parentTransformGroups != null) {
                    int n = 0;
                    while (n < this.parentTransformGroups.length) {
                        int n3 = 0;
                        while (n3 < this.parentTransformGroups[n].size()) {
                            TransformGroupRetained transformGroupRetained = (TransformGroupRetained)this.parentTransformGroups[n].get(n3);
                            transformGroupRetained.updateTargets(this.mirrorGroup, null);
                            ++n3;
                        }
                        ++n;
                    }
                }
                j3dMessage.type = 1;
                j3dMessage.args[0] = this.mirrorGroup.toArray();
                this.mirrorGroup = null;
            }
            VirtualUniverse.mc.processMessage(j3dMessage);
        }
    }

    void setBounds(Bounds bounds) {
        super.setBounds(bounds);
        if (this.source.isLive() && !this.boundsAutoCompute && this.collisionBound == null && this.mirrorGroup != null) {
            J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
            j3dMessage.type = 34;
            j3dMessage.threads = 8256;
            j3dMessage.universe = this.universe;
            j3dMessage.args[0] = this;
            VirtualUniverse.mc.processMessage(j3dMessage);
        }
    }

    void setBoundsAutoCompute(boolean bl) {
        if (bl != this.boundsAutoCompute) {
            super.setBoundsAutoCompute(bl);
            if (!bl) {
                this.localBounds = this.getBounds();
            }
            if (this.source.isLive() && this.collisionBound == null && bl && this.mirrorGroup != null) {
                J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
                j3dMessage.type = 34;
                j3dMessage.threads = 8256;
                j3dMessage.universe = this.universe;
                j3dMessage.args[0] = this;
                VirtualUniverse.mc.processMessage(j3dMessage);
            }
        }
    }

    void setChild(Node node, int n) {
        this.checkValidChild(node, "GroupRetained0");
        if (this.source.isLive()) {
            Object object = this.universe.sceneGraphLock;
            synchronized (object) {
                this.doSetChild(node, n);
            }
        } else {
            this.doSetChild(node, n);
        }
    }

    void setCollisionBounds(Bounds bounds) {
        this.collisionBound = bounds == null ? null : (Bounds)bounds.clone();
        if (this.source.isLive()) {
            J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
            j3dMessage.type = 34;
            j3dMessage.threads = 8256;
            j3dMessage.universe = this.universe;
            j3dMessage.args[0] = this;
            VirtualUniverse.mc.processMessage(j3dMessage);
        }
    }

    void setCompiled() {
        super.setCompiled();
        int n = this.children.size() - 1;
        while (n >= 0) {
            SceneGraphObjectRetained sceneGraphObjectRetained = (SceneGraphObjectRetained)this.children.get(n);
            if (sceneGraphObjectRetained != null) {
                sceneGraphObjectRetained.setCompiled();
            }
            --n;
        }
    }

    void setLive(SetLiveState setLiveState) {
        this.doSetLive(setLiveState);
        super.markAsLive();
    }

    void updateCollidable(HashKey[] hashKeyArray, boolean[] blArray) {
        NodeRetained nodeRetained;
        int n = this.children.size() - 1;
        super.updateCollidable(hashKeyArray, blArray);
        int n2 = 0;
        n2 = 0;
        while (n2 < n) {
            nodeRetained = (NodeRetained)this.children.elementAt(n2);
            if (nodeRetained != null) {
                nodeRetained.updateCollidable(hashKeyArray, (boolean[])blArray.clone());
            }
            ++n2;
        }
        nodeRetained = (NodeRetained)this.children.elementAt(n2);
        if (nodeRetained != null) {
            nodeRetained.updateCollidable(hashKeyArray, blArray);
        }
    }

    synchronized void updateLocalToVworld() {
        int n = this.children.size() - 1;
        while (n >= 0) {
            NodeRetained nodeRetained = (NodeRetained)this.children.elementAt(n);
            if (nodeRetained != null) {
                nodeRetained.updateLocalToVworld();
            }
            --n;
        }
    }

    void updatePickable(HashKey[] hashKeyArray, boolean[] blArray) {
        NodeRetained nodeRetained;
        int n = this.children.size() - 1;
        super.updatePickable(hashKeyArray, blArray);
        int n2 = 0;
        n2 = 0;
        while (n2 < n) {
            nodeRetained = (NodeRetained)this.children.elementAt(n2);
            if (nodeRetained != null) {
                nodeRetained.updatePickable(hashKeyArray, (boolean[])blArray.clone());
            }
            ++n2;
        }
        nodeRetained = (NodeRetained)this.children.elementAt(n2);
        if (nodeRetained != null) {
            nodeRetained.updatePickable(hashKeyArray, blArray);
        }
    }

    static boolean validSwitchChild(SwitchRetained switchRetained, NodeRetained nodeRetained) {
        int n = switchRetained.whichChild;
        if (n == -1) {
            return false;
        }
        if (n == -2) {
            return true;
        }
        Vector vector = switchRetained.children;
        if (n >= 0) {
            return vector.elementAt(n) == nodeRetained;
        }
        int n2 = vector.size() - 1;
        while (n2 >= 0) {
            if (switchRetained.childMask.get(n2) && vector.elementAt(n2) == nodeRetained) {
                return true;
            }
            --n2;
        }
        return false;
    }
}

