/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import javax.media.j3d.AppearanceRetained;
import javax.media.j3d.BHLeafInterface;
import javax.media.j3d.BHLeafNode;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.Bounds;
import javax.media.j3d.GeometryArrayRetained;
import javax.media.j3d.GeometryRetained;
import javax.media.j3d.Locale;
import javax.media.j3d.RasterRetained;
import javax.media.j3d.RenderAtom;
import javax.media.j3d.Shape3DRetained;
import javax.media.j3d.Transform3D;
import javax.vecmath.Vector3d;

class GeometryAtom
implements BHLeafInterface {
    GeometryRetained geometry = null;
    Bounds bounds = null;
    Locale locale = null;
    BoundingBox vwcBounds = new BoundingBox();
    Bounds collisionBound = null;
    Shape3DRetained source = null;
    BHLeafNode bhLeafNode = null;
    Transform3D currentLocalTransform = null;
    Transform3D lastLocalTransform = null;
    boolean alphaEditable;
    boolean visible = true;
    int geoType = -1;
    RenderAtom[] renderAtoms = new RenderAtom[0];
    ArrayList orderedGroupsPath = null;
    ArrayList orderedChildIdsPath = null;
    Vector3d localeTranslation = new Vector3d();

    GeometryAtom() {
    }

    public BoundingBox computeBoundingHull() {
        return this.vwcBounds;
    }

    void evalAlphaEditable() {
        this.alphaEditable = false;
        if (this.geometry != null && this.geometry.noAlpha && this.source.appearance != null) {
            AppearanceRetained appearanceRetained = this.source.appearance;
            if (this.source.source.capabilities.get(15) || appearanceRetained.source.capabilities.get(13) || appearanceRetained.source.capabilities.get(11) || appearanceRetained.renderingAttributes != null && appearanceRetained.renderingAttributes.source.capabilities.get(3) || appearanceRetained.transparencyAttributes != null && (appearanceRetained.transparencyAttributes.source.capabilities.get(1) || appearanceRetained.transparencyAttributes.source.capabilities.get(3))) {
                this.alphaEditable = true;
            } else if (this.geometry instanceof GeometryArrayRetained && (appearanceRetained.source.capabilities.get(7) || appearanceRetained.textureAttributes != null && appearanceRetained.textureAttributes.source.capabilities.get(1))) {
                this.alphaEditable = true;
            } else if (this.geometry instanceof RasterRetained && (((RasterRetained)this.geometry).type & 1) != 0 && ((RasterRetained)this.geometry).source.capabilities.get(5)) {
                this.alphaEditable = true;
            }
        }
    }

    public Locale getLocale2() {
        return this.locale;
    }

    RenderAtom getRenderAtom(int n) {
        RenderAtom[] renderAtomArray = this.renderAtoms;
        synchronized (renderAtomArray) {
            if (n >= this.renderAtoms.length) {
                RenderAtom[] renderAtomArray2 = new RenderAtom[n + 1];
                int n2 = 0;
                while (n2 < this.renderAtoms.length) {
                    renderAtomArray2[n2] = this.renderAtoms[n2];
                    ++n2;
                }
                renderAtomArray2[n] = new RenderAtom();
                renderAtomArray2[n].geometryAtom = this;
                this.renderAtoms = renderAtomArray2;
            } else if (this.renderAtoms[n] == null) {
                this.renderAtoms[n] = new RenderAtom();
                this.renderAtoms[n].geometryAtom = this;
            }
        }
        return this.renderAtoms[n];
    }

    public boolean isEnable() {
        return this.vwcBounds != null && !this.vwcBounds.isEmpty() && this.source.currentSwitchOn;
    }

    public boolean isEnable(int n) {
        if (this.vwcBounds != null && !this.vwcBounds.isEmpty() && this.source.currentSwitchOn) {
            switch (n) {
                case 0: {
                    return this.visible;
                }
                case 1: {
                    return this.visible ^ true;
                }
                case 2: {
                    return true;
                }
            }
        }
        return false;
    }

    void updateLocaleBounds() {
        int n = 0;
        while (n < this.renderAtoms.length) {
            RenderAtom renderAtom = this.renderAtoms[n];
            if (renderAtom.inRenderBin) {
                if (renderAtom.renderMolecule.renderBin.locale != this.source.locale) {
                    this.source.locale.hiRes.difference(renderAtom.renderMolecule.renderBin.locale.hiRes, this.localeTranslation);
                    renderAtom.localeVwcBounds.translate(this.vwcBounds, this.localeTranslation);
                }
            } else {
                renderAtom.localeVwcBounds = null;
            }
            ++n;
        }
    }
}

