/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import javax.media.j3d.AttributeBin;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.FogRetained;
import javax.media.j3d.LightBin;
import javax.media.j3d.LightRetained;
import javax.media.j3d.LinearFogRetained;
import javax.media.j3d.ModelClipRetained;
import javax.media.j3d.ObjectUpdate;
import javax.media.j3d.RenderAtom;
import javax.media.j3d.RenderBin;
import javax.media.j3d.RenderMolecule;
import javax.media.j3d.SwitchRetained;
import javax.vecmath.Color3f;

class EnvironmentSet
implements ObjectUpdate {
    static final int LIGHTENABLE_CHANGED = 1;
    static final int AMBIENT_CHANGED = 2;
    static final int FOG_CHANGED = 4;
    static final int MODELCLIP_CHANGED = 8;
    ArrayList lights = new ArrayList();
    int[] ltPos = null;
    ArrayList ambLights = new ArrayList();
    LightBin lightBin = null;
    long enableMask = 0L;
    Color3f sceneAmbient = new Color3f();
    RenderBin renderBin = null;
    FogRetained fog = null;
    ModelClipRetained modelClip = null;
    EnvironmentSet next = null;
    EnvironmentSet prev = null;
    ArrayList addAttributeBins = new ArrayList();
    int canvasDirty = 0;
    long enableMaskCache = 0L;
    boolean onUpdateList = false;
    AttributeBin attributeBinList = null;
    SwitchRetained closestSwitchParent = null;
    int closestSwitchIndex = -1;

    EnvironmentSet(RenderAtom renderAtom, LightRetained[] lightRetainedArray, FogRetained fogRetained, ModelClipRetained modelClipRetained, RenderBin renderBin) {
        this.renderBin = renderBin;
        this.reset(renderAtom, lightRetainedArray, fogRetained, modelClipRetained);
    }

    void addAttributeBin(AttributeBin attributeBin, RenderBin renderBin) {
        attributeBin.environmentSet = this;
        this.addAttributeBins.add(attributeBin);
        if (!this.onUpdateList) {
            renderBin.objUpdateList.add(this);
            this.onUpdateList = true;
        }
    }

    boolean equalLights(LightRetained[] lightRetainedArray) {
        if (lightRetainedArray == null && this.ambLights == null && this.lights.size() == 0) {
            return true;
        }
        if (this.lights.size() + this.ambLights.size() != lightRetainedArray.length) {
            return false;
        }
        int n = 0;
        while (n < lightRetainedArray.length) {
            if (lightRetainedArray[n].nodeType == 5 ? !this.ambLights.contains(lightRetainedArray[n]) : !this.lights.contains(lightRetainedArray[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    boolean equals(RenderAtom renderAtom, LightRetained[] lightRetainedArray, FogRetained fogRetained, ModelClipRetained modelClipRetained) {
        if (renderAtom.geometryAtom.source.closestSwitchParent != this.closestSwitchParent || renderAtom.geometryAtom.source.closestSwitchIndex != this.closestSwitchIndex) {
            return false;
        }
        if (lightRetainedArray == null && this.ambLights == null) {
            if (this.lights.size() == 0) {
                return this.fog == fogRetained;
            }
            return false;
        }
        if (this.lights.size() + this.ambLights.size() != lightRetainedArray.length) {
            return false;
        }
        int n = 0;
        while (n < lightRetainedArray.length) {
            if (lightRetainedArray[n].nodeType == 5 ? !this.ambLights.contains(lightRetainedArray[n]) : !this.lights.contains(lightRetainedArray[n])) {
                return false;
            }
            ++n;
        }
        if (this.fog != fogRetained) {
            return false;
        }
        return this.modelClip == modelClipRetained;
    }

    void removeAttributeBin(AttributeBin attributeBin) {
        attributeBin.environmentSet = null;
        if (attributeBin.prev == null) {
            this.attributeBinList = attributeBin.next;
            if (attributeBin.next != null) {
                attributeBin.next.prev = null;
            }
        } else {
            attributeBin.prev.next = attributeBin.next;
            if (attributeBin.next != null) {
                attributeBin.next.prev = attributeBin.prev;
            }
        }
        attributeBin.prev = null;
        attributeBin.next = null;
        this.renderBin.attrBinFreelist.add(attributeBin);
        if (this.attributeBinList == null && this.addAttributeBins.size() == 0) {
            LightRetained lightRetained;
            int n = 0;
            while (n < this.lights.size()) {
                lightRetained = (LightRetained)this.lights.get(n);
                lightRetained.environmentSets.remove(lightRetained.environmentSets.indexOf(this));
                ++n;
            }
            n = 0;
            while (n < this.ambLights.size()) {
                lightRetained = (LightRetained)this.ambLights.get(n);
                lightRetained.environmentSets.remove(lightRetained.environmentSets.indexOf(this));
                ++n;
            }
            if (this.fog != null) {
                this.fog.environmentSets.remove(this.fog.environmentSets.indexOf(this));
            }
            this.lightBin.removeEnvironmentSet(this);
        }
    }

    void render(Canvas3D canvas3D) {
        double d;
        boolean bl = false;
        if (this.attributeBinList != null && this.attributeBinList.textureBinList != null && this.attributeBinList.textureBinList.renderMoleculeList != null) {
            RenderMolecule renderMolecule = this.attributeBinList.textureBinList.renderMoleculeList;
            if (renderMolecule.primaryRenderAtomList != null) {
                bl = renderMolecule.primaryRenderAtomList.geometryAtom.source.lastSwitchOn;
            } else if (renderMolecule.vertexArrayRenderAtomList != null) {
                bl = renderMolecule.vertexArrayRenderAtomList.geometryAtom.source.lastSwitchOn;
            }
        }
        if (!bl) {
            return;
        }
        if (canvas3D.environmentSet != this) {
            canvas3D.setLightEnables(canvas3D.ctx, this.enableMask, this.renderBin.maxLights);
            canvas3D.setSceneAmbient(canvas3D.ctx, this.sceneAmbient.x, this.sceneAmbient.y, this.sceneAmbient.z);
            if (this.fog != null) {
                d = this.lightBin.geometryBackground == null ? canvas3D.canvasViewCache.getVworldToCoexistenceScale() : canvas3D.canvasViewCache.getInfVworldToCoexistenceScale();
                this.fog.update(canvas3D.ctx, d);
            } else {
                canvas3D.disableFog(canvas3D.ctx);
            }
            if (this.modelClip != null) {
                this.modelClip.update(canvas3D);
            } else {
                canvas3D.disableModelClip(canvas3D.ctx);
            }
            canvas3D.environmentSet = this;
            canvas3D.canvasDirty &= 0xFFFF9E7F;
        } else if ((canvas3D.canvasDirty & 0x6180) != 0) {
            if ((canvas3D.canvasDirty & 0x80) != 0) {
                canvas3D.setLightEnables(canvas3D.ctx, this.enableMask, this.renderBin.maxLights);
            }
            if ((canvas3D.canvasDirty & 0x100) != 0) {
                canvas3D.setSceneAmbient(canvas3D.ctx, this.sceneAmbient.x, this.sceneAmbient.y, this.sceneAmbient.z);
            }
            if ((canvas3D.canvasDirty & 0x2000) != 0) {
                if (this.fog != null) {
                    d = this.lightBin.geometryBackground == null ? canvas3D.canvasViewCache.getVworldToCoexistenceScale() : canvas3D.canvasViewCache.getInfVworldToCoexistenceScale();
                    this.fog.update(canvas3D.ctx, d);
                } else {
                    canvas3D.disableFog(canvas3D.ctx);
                }
            }
            if ((canvas3D.canvasDirty & 0x4000) != 0) {
                if (this.modelClip != null) {
                    this.modelClip.update(canvas3D);
                } else {
                    canvas3D.disableModelClip(canvas3D.ctx);
                }
            }
            canvas3D.canvasDirty &= 0xFFFF9E7F;
        } else if (this.fog instanceof LinearFogRetained && (canvas3D.canvasDirty & 0x8000) != 0) {
            if (this.fog != null) {
                d = this.lightBin.geometryBackground == null ? canvas3D.canvasViewCache.getVworldToCoexistenceScale() : canvas3D.canvasViewCache.getInfVworldToCoexistenceScale();
                this.fog.update(canvas3D.ctx, d);
            } else {
                canvas3D.disableFog(canvas3D.ctx);
            }
        }
        AttributeBin attributeBin = this.attributeBinList;
        while (attributeBin != null) {
            attributeBin.render(canvas3D);
            attributeBin = attributeBin.next;
        }
    }

    void reset(RenderAtom renderAtom, LightRetained[] lightRetainedArray, FogRetained fogRetained, ModelClipRetained modelClipRetained) {
        this.closestSwitchParent = renderAtom.geometryAtom.source.closestSwitchParent;
        this.closestSwitchIndex = renderAtom.geometryAtom.source.closestSwitchIndex;
        this.prev = null;
        this.next = null;
        this.onUpdateList = false;
        this.attributeBinList = null;
        this.lights.clear();
        this.ambLights.clear();
        this.sceneAmbient.x = 0.0f;
        this.sceneAmbient.y = 0.0f;
        this.sceneAmbient.z = 0.0f;
        if (lightRetainedArray != null) {
            int n = 0;
            while (n < lightRetainedArray.length) {
                if (lightRetainedArray[n].nodeType == 5) {
                    this.ambLights.add(lightRetainedArray[n]);
                    this.sceneAmbient.x += lightRetainedArray[n].color.x;
                    this.sceneAmbient.y += lightRetainedArray[n].color.y;
                    this.sceneAmbient.z += lightRetainedArray[n].color.z;
                } else {
                    this.lights.add(lightRetainedArray[n]);
                }
                lightRetainedArray[n].environmentSets.add(this);
                ++n;
            }
            if (this.sceneAmbient.x > 1.0f) {
                this.sceneAmbient.x = 1.0f;
            }
            if (this.sceneAmbient.y > 1.0f) {
                this.sceneAmbient.y = 1.0f;
            }
            if (this.sceneAmbient.z > 1.0f) {
                this.sceneAmbient.z = 1.0f;
            }
        }
        this.fog = fogRetained;
        if (fogRetained != null) {
            fogRetained.environmentSets.add(this);
        }
        this.modelClip = modelClipRetained;
        if (modelClipRetained != null) {
            modelClipRetained.environmentSets.add(this);
        }
        this.ltPos = new int[this.lights.size()];
        this.enableMask = 0L;
    }

    public void updateObject() {
        int n;
        if (this.addAttributeBins.size() > 0) {
            AttributeBin attributeBin = (AttributeBin)this.addAttributeBins.get(0);
            if (this.attributeBinList == null) {
                this.attributeBinList = attributeBin;
            } else {
                attributeBin.next = this.attributeBinList;
                this.attributeBinList.prev = attributeBin;
                this.attributeBinList = attributeBin;
            }
            n = 1;
            while (n < this.addAttributeBins.size()) {
                attributeBin = (AttributeBin)this.addAttributeBins.get(n);
                attributeBin.next = this.attributeBinList;
                this.attributeBinList.prev = attributeBin;
                this.attributeBinList = attributeBin;
                ++n;
            }
        }
        this.addAttributeBins.clear();
        if (this.canvasDirty != 0) {
            if ((this.canvasDirty & 0x100) != 0) {
                this.updateSceneAmbient();
            }
            Canvas3D[] canvas3DArray = this.renderBin.view.getCanvases();
            n = 0;
            while (n < canvas3DArray.length) {
                canvas3DArray[n].canvasDirty |= this.canvasDirty;
                ++n;
            }
            if ((this.canvasDirty & 0x80) != 0) {
                this.enableMask = this.enableMaskCache;
            }
            this.canvasDirty = 0;
        }
        this.onUpdateList = false;
    }

    void updateSceneAmbient() {
        this.sceneAmbient.x = 0.0f;
        this.sceneAmbient.y = 0.0f;
        this.sceneAmbient.z = 0.0f;
        int n = 0;
        while (n < this.ambLights.size()) {
            LightRetained lightRetained = (LightRetained)this.ambLights.get(n);
            if (lightRetained.lightOn) {
                this.sceneAmbient.x += lightRetained.color.x;
                this.sceneAmbient.y += lightRetained.color.y;
                this.sceneAmbient.z += lightRetained.color.z;
            }
            ++n;
        }
        if (this.sceneAmbient.x > 1.0f) {
            this.sceneAmbient.x = 1.0f;
        }
        if (this.sceneAmbient.y > 1.0f) {
            this.sceneAmbient.y = 1.0f;
        }
        if (this.sceneAmbient.z > 1.0f) {
            this.sceneAmbient.z = 1.0f;
        }
    }
}

