/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.Enumeration;
import javax.media.j3d.Alpha;
import javax.media.j3d.Interpolator;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.NodeReferenceTable;
import javax.vecmath.Color3f;
import javax.vecmath.Tuple3f;

public class ColorInterpolator
extends Interpolator {
    Material target;
    Color3f startColor = new Color3f();
    Color3f endColor = new Color3f();
    Color3f newColor = new Color3f();

    ColorInterpolator() {
    }

    public ColorInterpolator(Alpha alpha, Material material) {
        super(alpha);
        this.target = material;
        this.startColor.set(0.0f, 0.0f, 0.0f);
        this.endColor.set(1.0f, 1.0f, 1.0f);
    }

    public ColorInterpolator(Alpha alpha, Material material, Color3f color3f, Color3f color3f2) {
        super(alpha);
        this.target = material;
        this.startColor.set((Tuple3f)color3f);
        this.endColor.set((Tuple3f)color3f2);
    }

    public Node cloneNode(boolean bl) {
        ColorInterpolator colorInterpolator = new ColorInterpolator();
        colorInterpolator.duplicateNode(this, bl);
        return colorInterpolator;
    }

    void duplicateAttributes(Node node, boolean bl) {
        super.duplicateAttributes(node, bl);
        ColorInterpolator colorInterpolator = (ColorInterpolator)node;
        colorInterpolator.getStartColor(this.startColor);
        colorInterpolator.getEndColor(this.endColor);
        this.setTarget(colorInterpolator.getTarget());
    }

    public void getEndColor(Color3f color3f) {
        color3f.set((Tuple3f)this.endColor);
    }

    public void getStartColor(Color3f color3f) {
        color3f.set((Tuple3f)this.startColor);
    }

    public Material getTarget() {
        return this.target;
    }

    public void processStimulus(Enumeration enumeration) {
        if (this.alpha != null) {
            float f = this.alpha.value();
            this.newColor.x = (1.0f - f) * this.startColor.x + f * this.endColor.x;
            this.newColor.y = (1.0f - f) * this.startColor.y + f * this.endColor.y;
            this.newColor.z = (1.0f - f) * this.startColor.z + f * this.endColor.z;
            this.target.setDiffuseColor(this.newColor);
        }
        this.wakeupOn(this.defaultWakeupCriterion);
    }

    public void setEndColor(Color3f color3f) {
        this.endColor.set((Tuple3f)color3f);
    }

    public void setStartColor(Color3f color3f) {
        this.startColor.set((Tuple3f)color3f);
    }

    public void setTarget(Material material) {
        this.target = material;
    }

    public void updateNodeReferences(NodeReferenceTable nodeReferenceTable) {
        super.updateNodeReferences(nodeReferenceTable);
        Material material = this.getTarget();
        if (material != null) {
            this.setTarget((Material)nodeReferenceTable.getNewObjectReference(material));
        }
    }
}

