/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.BoundingBox;
import javax.media.j3d.BoundingLeaf;
import javax.media.j3d.BoundingLeafRetained;
import javax.media.j3d.Bounds;
import javax.media.j3d.ContainsNodes;
import javax.media.j3d.IllegalSharingException;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.LeafRetained;
import javax.media.j3d.SetLiveState;
import javax.media.j3d.VirtualUniverse;

class ClipRetained
extends LeafRetained {
    static final int BOUNDS_CHANGED = 1;
    static final int BOUNDINGLEAF_CHANGED = 2;
    static final int BACKDISTANCE_CHANGED = 4;
    double backDistance = 100.0;
    double backDistanceInVworld;
    Bounds applicationRegion = null;
    BoundingLeafRetained boundingLeaf = null;
    Bounds transformedRegion = null;
    boolean inImmCtx = false;
    static final int targetThreads = 4224;

    ClipRetained() {
        this.nodeType = 2;
        this.localBounds = new BoundingBox();
        ((BoundingBox)this.localBounds).setLower(1.0, 1.0, 1.0);
        ((BoundingBox)this.localBounds).setUpper(-1.0, -1.0, -1.0);
    }

    void clearLive(SetLiveState setLiveState) {
        super.clearLive(setLiveState);
        setLiveState.nodeList.add(this);
        setLiveState.notifyThreads |= 0x1080;
    }

    BoundingLeaf getApplicationBoundingLeaf() {
        return this.boundingLeaf != null ? (BoundingLeaf)this.boundingLeaf.source : null;
    }

    final Bounds getApplicationBounds() {
        return this.applicationRegion != null ? (Bounds)this.applicationRegion.clone() : null;
    }

    final double getBackDistance() {
        return this.backDistance;
    }

    boolean getInImmCtx() {
        return this.inImmCtx;
    }

    void initApplicationBoundingLeaf(BoundingLeaf boundingLeaf) {
        this.boundingLeaf = boundingLeaf != null ? (BoundingLeafRetained)boundingLeaf.retained : null;
    }

    final void initApplicationBounds(Bounds bounds) {
        this.applicationRegion = bounds != null ? (Bounds)bounds.clone() : null;
    }

    final void initBackDistance(double d) {
        this.backDistance = d;
    }

    void initMirrorObject() {
        if (this.boundingLeaf != null) {
            this.transformedRegion = this.boundingLeaf.mirrorBoundingLeaf.transformedRegion;
        } else if (this.applicationRegion != null) {
            this.transformedRegion = (Bounds)this.applicationRegion.clone();
            this.transformedRegion.transform(this.applicationRegion, this.lastLocalToVworld[0]);
        } else {
            this.transformedRegion = null;
        }
        this.backDistanceInVworld = this.backDistance * this.lastLocalToVworld[0].getDistanceScale();
    }

    final void sendMessage(int n, Object object, Object object2) {
        J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
        j3dMessage.threads = 4224;
        j3dMessage.type = 21;
        j3dMessage.universe = this.universe;
        j3dMessage.args[0] = this;
        j3dMessage.args[1] = new Integer(n);
        j3dMessage.args[2] = object;
        j3dMessage.args[3] = object2;
        VirtualUniverse.mc.processMessage(j3dMessage);
    }

    void setApplicationBoundingLeaf(BoundingLeaf boundingLeaf) {
        if (this.boundingLeaf != null) {
            this.boundingLeaf.mirrorBoundingLeaf.removeUser(this);
        }
        if (boundingLeaf != null) {
            this.boundingLeaf = (BoundingLeafRetained)boundingLeaf.retained;
            this.boundingLeaf.mirrorBoundingLeaf.addUser(this);
        } else {
            this.boundingLeaf = null;
        }
        this.sendMessage(2, this.boundingLeaf != null ? this.boundingLeaf.mirrorBoundingLeaf : null, this.applicationRegion != null ? this.applicationRegion.clone() : null);
    }

    final void setApplicationBounds(Bounds bounds) {
        this.initApplicationBounds(bounds);
        if (this.boundingLeaf == null) {
            this.sendMessage(1, bounds != null ? bounds.clone() : null, null);
        }
    }

    final void setBackDistance(double d) {
        this.backDistance = d;
        this.sendMessage(4, new Double(d), null);
    }

    void setInImmCtx(boolean bl) {
        this.inImmCtx = bl;
    }

    void setLive(SetLiveState setLiveState) {
        if (this.inImmCtx) {
            throw new IllegalSharingException(J3dI18N.getString("ClipRetained0"));
        }
        if (this.inBackgroundGroup) {
            throw new IllegalSharingException(J3dI18N.getString("ClipRetained1"));
        }
        super.doSetLive(setLiveState);
        this.initMirrorObject();
        setLiveState.nodeList.add(this);
        if (setLiveState.inSharedGroup) {
            int n = 0;
            while (n < setLiveState.keys.length) {
                if (setLiveState.switchLevels[n] >= 0) {
                    this.clearCompositeSwitchMask();
                    this.isNewSwitchLeaf = true;
                    ContainsNodes containsNodes = setLiveState.containsNodesList.getContainsNodes(setLiveState.keys[n]);
                    containsNodes.envNodes.add(this);
                }
                ++n;
            }
        } else if (setLiveState.switchLevels[0] >= 0) {
            this.clearCompositeSwitchMask();
            this.isNewSwitchLeaf = true;
            ContainsNodes containsNodes = setLiveState.containsNodesList.getContainsNodes(0);
            containsNodes.envNodes.add(this);
        }
        setLiveState.notifyThreads |= 0x1080;
        super.markAsLive();
    }

    void updateBoundingLeaf() {
        if (this.boundingLeaf != null && this.boundingLeaf.mirrorBoundingLeaf.currentSwitchOn) {
            this.transformedRegion = this.boundingLeaf.mirrorBoundingLeaf.transformedRegion;
        } else if (this.applicationRegion != null) {
            this.transformedRegion = (Bounds)this.applicationRegion.clone();
            this.transformedRegion.transform(this.applicationRegion, this.currentLocalToVworld[0]);
        } else {
            this.transformedRegion = null;
        }
    }

    void updateImmediateMirrorObject(Object[] objectArray) {
        int n = (Integer)objectArray[1];
        if ((n & 1) != 0) {
            if (objectArray[2] != null) {
                this.transformedRegion = (Bounds)((Bounds)objectArray[2]).clone();
                this.transformedRegion.transform(this.transformedRegion, this.currentLocalToVworld[0]);
            } else {
                this.transformedRegion = null;
            }
        } else if ((n & 2) != 0) {
            if (objectArray[2] != null) {
                this.transformedRegion = ((BoundingLeafRetained)objectArray[2]).transformedRegion;
            } else {
                Bounds bounds = (Bounds)objectArray[3];
                if (bounds != null) {
                    this.transformedRegion = (Bounds)bounds.clone();
                    this.transformedRegion.transform(bounds, this.currentLocalToVworld[0]);
                } else {
                    this.transformedRegion = null;
                }
            }
        } else if ((n & 4) != 0) {
            this.backDistanceInVworld = (Double)objectArray[2] * this.currentLocalToVworld[0].getDistanceScale();
        }
    }
}

