/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.awt.AWTEvent;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import javax.media.j3d.AppearanceRetained;
import javax.media.j3d.AttributeBin;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.CachedFrustum;
import javax.media.j3d.CanvasViewCache;
import javax.media.j3d.CanvasViewEventCatcher;
import javax.media.j3d.ColoringAttributesRetained;
import javax.media.j3d.DrawingSurfaceObject;
import javax.media.j3d.DrawingSurfaceObjectDSI;
import javax.media.j3d.EnvironmentSet;
import javax.media.j3d.EventCatcher;
import javax.media.j3d.GraphicsConfigTemplate3D;
import javax.media.j3d.GraphicsContext3D;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.ImageComponent2DRetained;
import javax.media.j3d.J3DGraphics2D;
import javax.media.j3d.J3DGraphics2DImpl;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.J3dQueryProps;
import javax.media.j3d.LightBin;
import javax.media.j3d.LightRetained;
import javax.media.j3d.LineAttributesRetained;
import javax.media.j3d.MasterControl;
import javax.media.j3d.MaterialRetained;
import javax.media.j3d.NativeWSInfo;
import javax.media.j3d.PointAttributesRetained;
import javax.media.j3d.PolygonAttributesRetained;
import javax.media.j3d.RenderMolecule;
import javax.media.j3d.RenderingAttributesRetained;
import javax.media.j3d.RestrictedAccessException;
import javax.media.j3d.Screen3D;
import javax.media.j3d.TexCoordGenerationRetained;
import javax.media.j3d.TextureAttributesRetained;
import javax.media.j3d.TextureBin;
import javax.media.j3d.TextureRetained;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransparencyAttributesRetained;
import javax.media.j3d.View;
import javax.media.j3d.ViewPlatformRetained;
import javax.media.j3d.VirtualUniverse;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector4d;

public class Canvas3D
extends Canvas {
    public static final int FIELD_LEFT = 0;
    public static final int FIELD_RIGHT = 1;
    public static final int FIELD_ALL = 2;
    static final int POLYGONATTRS_DIRTY = 1;
    static final int LINEATTRS_DIRTY = 2;
    static final int POINTATTRS_DIRTY = 4;
    static final int MATERIAL_DIRTY = 8;
    static final int TRANSPARENCYATTRS_DIRTY = 16;
    static final int COLORINGATTRS_DIRTY = 32;
    static final int LIGHTBIN_DIRTY = 64;
    static final int LIGHTENABLES_DIRTY = 128;
    static final int AMBIENTLIGHT_DIRTY = 256;
    static final int ATTRIBUTEBIN_DIRTY = 512;
    static final int TEXTUREBIN_DIRTY = 1024;
    static final int TEXTURESETTINGBIN_DIRTY = 2048;
    static final int RENDERMOLECULE_DIRTY = 4096;
    static final int FOG_DIRTY = 8192;
    static final int MODELCLIP_DIRTY = 16384;
    static final int VWORLD_SCALE_DIRTY = 32768;
    static final int RESIZE = 1;
    static final int TOGGLEFULLSCREEN = 2;
    boolean offScreen = false;
    Point offScreenCanvasLoc;
    Dimension offScreenCanvasSize;
    Point offScreenCanvasClippedLoc;
    Dimension offScreenCanvasClippedSize;
    boolean offScreenRendering = false;
    boolean waitingForOffScreenRendering = false;
    ImageComponent2D offScreenBuffer = null;
    byte[] byteBuffer = new byte[1];
    boolean useSharedCtx = true;
    boolean stereoAvailable;
    boolean stereoEnable = true;
    boolean useStereo;
    int monoscopicViewPolicy = 2;
    boolean doubleBufferAvailable;
    boolean doubleBufferEnable = true;
    boolean useDoubleBuffer;
    boolean sceneAntialiasingAvailable;
    boolean texture3DAvailable;
    int textureColorTableSize;
    boolean multiTexAccelerated = false;
    int numTexUnitSupported = 1;
    boolean textureColorTableAvailable = false;
    J3dQueryProps queryProps;
    Point3d leftManualEyeInImagePlate = new Point3d(0.142, 0.135, 0.4572);
    Point3d rightManualEyeInImagePlate = new Point3d(0.208, 0.135, 0.4572);
    View view = null;
    CanvasViewCache canvasViewCache = null;
    static final int STEREO_DIRTY = 1;
    static final int MONOSCOPIC_VIEW_POLICY_DIRTY = 2;
    static final int EYE_IN_IMAGE_PLATE_DIRTY = 4;
    static final int MOVED_OR_RESIZED_DIRTY = 8;
    int cvDirtyMask = 15;
    boolean resizeGraphics2D = true;
    boolean isRunning = true;
    boolean isRunningStatus = true;
    boolean active = false;
    boolean visible = false;
    Screen3D screen = null;
    boolean imageReady = false;
    private static Hashtable deviceScreenMap = new Hashtable();
    int fogOn = 0;
    GraphicsContext3D graphicsContext3D = null;
    boolean waiting = false;
    boolean swapDone = false;
    J3DGraphics2DImpl graphics2D = null;
    Object gfxCreationLock = new Object();
    Transform3D localToVWorldSrc = null;
    Transform3D vworldToEc = new Transform3D();
    Transform3D vpcToEc;
    int window = 0;
    int vid = 0;
    NativeWSInfo nativeWSobj = new NativeWSInfo();
    boolean firstPaintCalled = false;
    boolean added = false;
    int ctx = 0;
    boolean localEyeLightingEnable = false;
    boolean ctxEyeLightingEnable = false;
    AppearanceRetained currentAppear = new AppearanceRetained();
    MaterialRetained currentMaterial = new MaterialRetained();
    CachedFrustum viewFrustum = new CachedFrustum();
    LightBin lightBin = null;
    EnvironmentSet environmentSet = null;
    AttributeBin attributeBin = null;
    TextureBin textureBin = null;
    RenderMolecule renderMolecule = null;
    PolygonAttributesRetained polygonAttributes = null;
    LineAttributesRetained lineAttributes = null;
    PointAttributesRetained pointAttributes = null;
    MaterialRetained material = null;
    TransparencyAttributesRetained transparency = null;
    ColoringAttributesRetained coloringAttributes = null;
    TextureRetained texture = null;
    TextureAttributesRetained texAttrs = null;
    TexCoordGenerationRetained texCoordGeneration = null;
    RenderingAttributesRetained renderingAttrs = null;
    int canvasDirty = 65535;
    ArrayList dirtyRenderMoleculeList = new ArrayList();
    ArrayList displayListResourceFreeList = new ArrayList();
    ArrayList textureIdResourceFreeList = new ArrayList();
    int canvasBit = 0;
    Object cvLock = new Object();
    Object evaluateLock = new Object();
    Object dirtyMaskLock = new Object();
    boolean fullScreenMode = false;
    int reEvaluateCanvasCmd = 0;
    static final int GLOBAL_ALPHA_SUN = 1;
    static final int EXT_ABGR = 2;
    static final int EXT_BGR = 4;
    static final int EXT_RESCALE_NORMAL = 8;
    static final int EXT_MULTI_DRAW_ARRAYS = 16;
    static final int SUN_MULTI_DRAW_ARRAYS = 32;
    static final int SUN_CONSTANT_DATA = 64;
    static final int ARB_MULTITEXTURE = 128;
    static final int SGI_TEXTURE_COLOR_TABLE = 256;
    static final int EXT_TEXTURE3D = 512;
    int extensionsSupported = 0;
    LightRetained[] currentLights = null;
    boolean depthBufferWriteEnableOverride = false;
    boolean depthBufferEnableOverride = false;
    boolean vfPlanesValid = false;
    EventCatcher eventCatcher;
    CanvasViewEventCatcher canvasViewEventCatcher;
    Container parent;
    boolean lightChanged = false;
    DrawingSurfaceObject drawingSurfaceObject;
    boolean validCtx = false;
    boolean validCanvas = false;
    boolean ctxChanged = false;
    private static GraphicsConfiguration defaultGcfg = null;

    static {
        VirtualUniverse.loadLibraries();
    }

    public Canvas3D(GraphicsConfiguration graphicsConfiguration) {
        this(graphicsConfiguration == null ? Canvas3D.defaultGraphicsConfiguration() : graphicsConfiguration, false);
        if (graphicsConfiguration == null) {
            System.err.println(J3dI18N.getString("Canvas3D7"));
        }
    }

    public Canvas3D(GraphicsConfiguration graphicsConfiguration, boolean bl) {
        super(graphicsConfiguration);
        this.drawingSurfaceObject = VirtualUniverse.mc.jvm13 ? new DrawingSurfaceObjectDSI(this) : new DrawingSurfaceObjectDSI(this);
        this.offScreen = bl;
        GraphicsDevice graphicsDevice = graphicsConfiguration.getDevice();
        this.vid = this.nativeWSobj.getCanvasVid(graphicsConfiguration);
        if (bl) {
            this.screen = new Screen3D(graphicsDevice, bl);
            this.screen.addUser(this);
            this.doubleBufferAvailable = false;
            this.stereoAvailable = false;
            this.added = true;
            Object object = this.dirtyMaskLock;
            synchronized (object) {
                this.cvDirtyMask |= 8;
            }
            this.firstPaintCalled = true;
            this.ctx = 0;
            this.evaluateActive();
            this.offScreenCanvasLoc = new Point(0, 0);
            this.offScreenCanvasSize = new Dimension(0, 0);
            this.offScreenCanvasClippedLoc = new Point(0, 0);
            this.offScreenCanvasClippedSize = new Dimension(0, 0);
            this.setLocation(this.offScreenCanvasLoc);
            this.setSize(this.offScreenCanvasSize);
        } else {
            this.eventCatcher = new EventCatcher(this);
            this.canvasViewEventCatcher = new CanvasViewEventCatcher(this);
            Hashtable hashtable = deviceScreenMap;
            synchronized (hashtable) {
                this.screen = (Screen3D)deviceScreenMap.get(graphicsDevice);
                if (this.screen == null) {
                    this.screen = new Screen3D(graphicsDevice, bl);
                    deviceScreenMap.put(graphicsDevice, this.screen);
                }
            }
            this.screen.addUser(this);
            this.doubleBufferAvailable = GraphicsConfigTemplate3D.hasDoubleBuffer(graphicsConfiguration);
            this.stereoAvailable = GraphicsConfigTemplate3D.hasStereo(graphicsConfiguration);
        }
        this.useDoubleBuffer = this.doubleBufferEnable && this.doubleBufferAvailable;
        this.useStereo = this.stereoEnable && this.stereoAvailable;
        this.sceneAntialiasingAvailable = GraphicsConfigTemplate3D.hasSceneAntialiasing(graphicsConfiguration);
        this.useSharedCtx = (VirtualUniverse.mc.sharedCtxOverride ^ true) & this.useSharedCtx() | VirtualUniverse.mc.sharedCtxOverride & VirtualUniverse.mc.isSharedCtx;
    }

    native void accum(int var1, float var2);

    native void accumReturn(int var1);

    public void addNotify() {
        Component component;
        super.addNotify();
        this.parent = this.getParent();
        while (!(this.parent instanceof Window)) {
            this.parent = this.parent.getParent();
        }
        ((Window)this.parent).addWindowListener(this.eventCatcher);
        this.added = true;
        if (this.canvasViewEventCatcher.parentList.size() > 0) {
            int n = 0;
            while (n < this.canvasViewEventCatcher.parentList.size()) {
                component = (Component)this.canvasViewEventCatcher.parentList.get(n);
                component.removeComponentListener(this.canvasViewEventCatcher);
                ++n;
            }
            this.canvasViewEventCatcher.parentList.clear();
        }
        component = this.getParent();
        while (component != null) {
            component.addComponentListener(this.canvasViewEventCatcher);
            this.canvasViewEventCatcher.parentList.add(component);
            component = component.getParent();
        }
        this.addComponentListener(this.canvasViewEventCatcher);
        Object object = this.dirtyMaskLock;
        synchronized (object) {
            this.cvDirtyMask |= 8;
        }
        this.canvasBit = VirtualUniverse.mc.getCanvasBit();
        this.validCanvas = true;
        if (this.isRunning) {
            this.isRunningStatus = true;
        }
    }

    native void callDisplayList(int var1, int var2, boolean var3);

    native void clear(int var1, float var2, float var3, float var4, ImageComponent2DRetained var5);

    native void clearAccum(int var1, float var2, float var3, float var4, float var5);

    native void composite(int var1, int var2, int var3, int var4, int var5, int var6, int var7, byte[] var8);

    native int createContext(int var1, int var2, int var3, int var4, boolean var5);

    native int createOffScreenBuffer(int var1, int var2, int var3, int var4, int var5);

    native int createQueryContext(int var1, int var2, int var3, boolean var4);

    private void createQueryProps() {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Comparable<Boolean>> arrayList2 = new ArrayList<Comparable<Boolean>>();
        arrayList.add("doubleBufferAvailable");
        arrayList2.add(new Boolean(this.doubleBufferAvailable));
        arrayList.add("stereoAvailable");
        arrayList2.add(new Boolean(this.stereoAvailable));
        arrayList.add("sceneAntialiasingAvailable");
        arrayList2.add(new Boolean(this.sceneAntialiasingAvailable));
        arrayList.add("texture3DAvailable");
        arrayList2.add(new Boolean(this.texture3DAvailable));
        arrayList.add("textureColorTableSize");
        arrayList2.add(new Integer(this.textureColorTableSize));
        arrayList.add("compressedGeometry.majorVersionNumber");
        arrayList2.add(new Integer(1));
        arrayList.add("compressedGeometry.minorVersionNumber");
        arrayList2.add(new Integer(0));
        arrayList.add("compressedGeometry.minorMinorVersionNumber");
        arrayList2.add(new Integer(2));
        this.queryProps = new J3dQueryProps(arrayList.toArray(new String[0]), arrayList2.toArray());
    }

    native void ctxUpdateEyeLightingEnable(int var1, boolean var2);

    native boolean decal1stChildSetup(int var1);

    native void decalNthChildSetup(int var1);

    native void decalReset(int var1, boolean var2);

    private static synchronized GraphicsConfiguration defaultGraphicsConfiguration() {
        if (defaultGcfg == null) {
            GraphicsConfigTemplate3D graphicsConfigTemplate3D = new GraphicsConfigTemplate3D();
            defaultGcfg = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getBestConfiguration(graphicsConfigTemplate3D);
        }
        return defaultGcfg;
    }

    native int destroyContext(int var1, int var2, int var3);

    native int destroyOffScreenBuffer(int var1, int var2, int var3);

    native void disableFog(int var1);

    native void disableModelClip(int var1);

    void doSwap() {
        if (this.firstPaintCalled && this.useDoubleBuffer) {
            try {
                if (!this.drawingSurfaceObject.renderLock(true)) {
                    return;
                }
                this.syncRender(this.ctx, true);
                this.swapBuffers(this.ctx, this.screen.display, this.window);
                this.drawingSurfaceObject.unLock(true);
            }
            catch (NullPointerException nullPointerException) {
                this.drawingSurfaceObject.unLock(true);
            }
        }
        this.view.universe.behaviorStructure.incElapsedFrames();
        if (this.reEvaluateCanvasCmd != 0) {
            if (this.reEvaluateCanvasCmd == 1) {
                this.resizeD3DCanvas(this.ctx);
            } else {
                this.toggleFullScreenMode(this.ctx);
            }
            this.canvasDirty = 65535;
            this.polygonAttributes = null;
            this.lineAttributes = null;
            this.pointAttributes = null;
            this.material = null;
            this.transparency = null;
            this.coloringAttributes = null;
            this.texture = null;
            this.texAttrs = null;
            this.texCoordGeneration = null;
            this.renderingAttrs = null;
            this.reEvaluateCanvasCmd = 0;
        }
        this.runMonitor(2);
    }

    native void endDisplayList(int var1);

    void endOffScreenRendering() {
        int n = this.offScreenCanvasSize.width * this.offScreenCanvasSize.height * ((ImageComponent2DRetained)this.offScreenBuffer.retained).bytesPerPixelStored;
        if (this.byteBuffer.length < n) {
            this.byteBuffer = new byte[n];
        }
        this.readOffScreenBuffer(this.ctx, ((ImageComponent2DRetained)this.offScreenBuffer.retained).storedFormat, this.offScreenCanvasSize.width, this.offScreenCanvasSize.height);
        ((ImageComponent2DRetained)this.offScreenBuffer.retained).retrieveImage(this.byteBuffer, this.offScreenCanvasClippedLoc.x, this.offScreenCanvasClippedLoc.y, this.offScreenCanvasClippedSize.width, this.offScreenCanvasClippedSize.height);
        this.offScreenRendering = false;
    }

    void evaluateActive() {
        Object object = this.evaluateLock;
        synchronized (object) {
            if ((this.visible || this.offScreen) && this.firstPaintCalled) {
                if (!this.active) {
                    this.active = true;
                    if (this.view != null) {
                        this.view.evaluateActive();
                    }
                }
            } else if (this.active) {
                this.active = false;
                if (this.view != null) {
                    this.view.evaluateActive();
                }
            }
        }
    }

    native void freeDisplayList(int var1, int var2);

    native void freeTexture(int var1, int var2);

    public void getCenterEyeInImagePlate(Point3d point3d) {
        if (this.canvasViewCache != null) {
            CanvasViewCache canvasViewCache = this.canvasViewCache;
            synchronized (canvasViewCache) {
                point3d.set((Tuple3d)this.canvasViewCache.getCenterEyeInImagePlate());
            }
        } else {
            Point3d point3d2 = new Point3d();
            point3d2.add((Tuple3d)this.leftManualEyeInImagePlate, (Tuple3d)this.rightManualEyeInImagePlate);
            point3d2.scale(0.5);
            point3d.set((Tuple3d)point3d2);
        }
    }

    public boolean getDoubleBufferAvailable() {
        return (Boolean)this.queryProperties().get("doubleBufferAvailable");
    }

    public boolean getDoubleBufferEnable() {
        return this.doubleBufferEnable;
    }

    public J3DGraphics2D getGraphics2D() {
        Object object = this.gfxCreationLock;
        synchronized (object) {
            if (this.graphics2D == null) {
                this.graphics2D = new J3DGraphics2DImpl(this);
            }
        }
        return this.graphics2D;
    }

    public GraphicsContext3D getGraphicsContext3D() {
        Object object = this.gfxCreationLock;
        synchronized (object) {
            if (this.graphicsContext3D == null) {
                this.graphicsContext3D = new GraphicsContext3D(this);
            }
        }
        return this.graphicsContext3D;
    }

    public void getImagePlateToVworld(Transform3D transform3D) {
        if (this.canvasViewCache != null) {
            CanvasViewCache canvasViewCache = this.canvasViewCache;
            synchronized (canvasViewCache) {
                transform3D.set(this.canvasViewCache.getImagePlateToVworld());
            }
        } else {
            transform3D.setIdentity();
        }
    }

    public void getLeftEyeInImagePlate(Point3d point3d) {
        if (this.canvasViewCache != null) {
            CanvasViewCache canvasViewCache = this.canvasViewCache;
            synchronized (canvasViewCache) {
                point3d.set((Tuple3d)this.canvasViewCache.getLeftEyeInImagePlate());
            }
        } else {
            point3d.set((Tuple3d)this.leftManualEyeInImagePlate);
        }
    }

    public void getLeftManualEyeInImagePlate(Point3d point3d) {
        point3d.set((Tuple3d)this.leftManualEyeInImagePlate);
    }

    public int getMonoscopicViewPolicy() {
        return this.monoscopicViewPolicy;
    }

    native int getNumCtxLights(int var1);

    public ImageComponent2D getOffScreenBuffer() {
        if (!this.offScreen) {
            throw new IllegalStateException(J3dI18N.getString("Canvas3D1"));
        }
        return this.offScreenBuffer;
    }

    public Point getOffScreenLocation() {
        if (!this.offScreen) {
            throw new IllegalStateException(J3dI18N.getString("Canvas3D1"));
        }
        return new Point(this.offScreenCanvasLoc);
    }

    public Point getOffScreenLocation(Point point) {
        if (!this.offScreen) {
            throw new IllegalStateException(J3dI18N.getString("Canvas3D1"));
        }
        if (point == null) {
            return new Point(this.offScreenCanvasLoc);
        }
        point.setLocation(this.offScreenCanvasLoc);
        return point;
    }

    public double getPhysicalHeight() {
        double d = 0.0;
        if (this.canvasViewCache != null) {
            CanvasViewCache canvasViewCache = this.canvasViewCache;
            synchronized (canvasViewCache) {
                d = this.canvasViewCache.getPhysicalWindowHeight();
            }
        }
        return d;
    }

    public double getPhysicalWidth() {
        double d = 0.0;
        if (this.canvasViewCache != null) {
            CanvasViewCache canvasViewCache = this.canvasViewCache;
            synchronized (canvasViewCache) {
                d = this.canvasViewCache.getPhysicalWindowWidth();
            }
        }
        return d;
    }

    public void getPixelLocationFromImagePlate(Point3d point3d, Point2d point2d) {
        if (this.canvasViewCache != null) {
            CanvasViewCache canvasViewCache = this.canvasViewCache;
            synchronized (canvasViewCache) {
                this.canvasViewCache.getPixelLocationFromImagePlate(point3d, point2d);
            }
        } else {
            point2d.set(0.0, 0.0);
        }
    }

    public void getPixelLocationInImagePlate(int n, int n2, Point3d point3d) {
        if (this.canvasViewCache != null) {
            CanvasViewCache canvasViewCache = this.canvasViewCache;
            synchronized (canvasViewCache) {
                point3d.x = this.canvasViewCache.getWindowXInImagePlate(n);
                point3d.y = this.canvasViewCache.getWindowYInImagePlate(n2);
                point3d.z = 0.0;
            }
        } else {
            point3d.set(0.0, 0.0, 0.0);
        }
    }

    public void getPixelLocationInImagePlate(Point2d point2d, Point3d point3d) {
        if (this.canvasViewCache != null) {
            CanvasViewCache canvasViewCache = this.canvasViewCache;
            synchronized (canvasViewCache) {
                point3d.x = this.canvasViewCache.getWindowXInImagePlate(point2d.x);
                point3d.y = this.canvasViewCache.getWindowYInImagePlate(point2d.y);
                point3d.z = 0.0;
            }
        } else {
            point3d.set(0.0, 0.0, 0.0);
        }
    }

    public void getRightEyeInImagePlate(Point3d point3d) {
        if (this.canvasViewCache != null) {
            CanvasViewCache canvasViewCache = this.canvasViewCache;
            synchronized (canvasViewCache) {
                point3d.set((Tuple3d)this.canvasViewCache.getRightEyeInImagePlate());
            }
        } else {
            point3d.set((Tuple3d)this.rightManualEyeInImagePlate);
        }
    }

    public void getRightManualEyeInImagePlate(Point3d point3d) {
        point3d.set((Tuple3d)this.rightManualEyeInImagePlate);
    }

    public boolean getSceneAntialiasingAvailable() {
        return (Boolean)this.queryProperties().get("sceneAntialiasingAvailable");
    }

    public Screen3D getScreen3D() {
        return this.screen;
    }

    public Dimension getSize() {
        if (!this.fullScreenMode) {
            return super.getSize();
        }
        return this.screen.screenSize;
    }

    public boolean getStereoAvailable() {
        return (Boolean)this.queryProperties().get("stereoAvailable");
    }

    public boolean getStereoEnable() {
        return this.stereoEnable;
    }

    native int getTextureColorTableSize(int var1);

    native int getTextureUnitCount(int var1);

    public View getView() {
        return this.view;
    }

    public void getVworldToImagePlate(Transform3D transform3D) {
        if (this.canvasViewCache != null) {
            CanvasViewCache canvasViewCache = this.canvasViewCache;
            synchronized (canvasViewCache) {
                transform3D.set(this.canvasViewCache.getVworldToImagePlate());
            }
        } else {
            transform3D.setIdentity();
        }
    }

    public boolean isOffScreen() {
        return this.offScreen;
    }

    public final boolean isRendererRunning() {
        return this.isRunning;
    }

    void makeCtxCurrent() {
        if (this.ctx != VirtualUniverse.mc.currentCtx) {
            this.useCtx(this.ctx, this.screen.display, this.window);
            VirtualUniverse.mc.currentCtx = this.ctx;
        }
    }

    void makeCtxCurrent(int n) {
        if (n != VirtualUniverse.mc.currentCtx) {
            this.useCtx(n, this.screen.display, this.window);
            VirtualUniverse.mc.currentCtx = n;
        }
    }

    native void newDisplayList(int var1, int var2);

    void notifyD3DPeer(int n) {
        if (this.active) {
            if (this.isRunning) {
                VirtualUniverse.mc.postRequest(MasterControl.STOP_RENDERER, this);
                while (this.isRunningStatus) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (n == 1) {
                    this.resizeD3DCanvas(this.ctx);
                } else {
                    this.toggleFullScreenMode(this.ctx);
                }
                this.canvasDirty = 65535;
                this.lightBin = null;
                this.environmentSet = null;
                this.texAttrs = null;
                this.texCoordGeneration = null;
                VirtualUniverse.mc.postRequest(MasterControl.START_RENDERER, this);
            } else {
                this.reEvaluateCanvasCmd = n;
            }
        }
    }

    public void paint(Graphics graphics) {
        if (!this.firstPaintCalled) {
            this.drawingSurfaceObject.getDrawingSurfaceObjectInfo();
            this.firstPaintCalled = true;
            this.visible = true;
            this.ctx = 0;
            this.evaluateActive();
        }
        this.redraw();
    }

    public void postRender() {
    }

    public void postSwap() {
    }

    public void preRender() {
    }

    public final Map queryProperties() {
        int n = 0;
        if (this.queryProps == null) {
            if (this.ctx == 0) {
                if (this.window == 0) {
                    n = this.createOffScreenBuffer(this.ctx, this.screen.display, this.vid, 10, 10);
                    this.ctx = this.createQueryContext(this.screen.display, n, this.vid, true);
                } else {
                    this.createQueryContext(this.screen.display, this.window, this.vid, this.offScreen);
                }
                if (this.textureColorTableAvailable) {
                    this.textureColorTableSize = this.getTextureColorTableSize(this.ctx);
                    if (this.textureColorTableSize > 256) {
                        this.textureColorTableSize = 256;
                    }
                }
                if (this.window == 0) {
                    this.destroyContext(this.screen.display, n, this.ctx);
                    this.destroyOffScreenBuffer(this.ctx, this.screen.display, n);
                    this.ctx = 0;
                }
            } else if (this.textureColorTableAvailable) {
                this.makeCtxCurrent();
                this.textureColorTableSize = this.getTextureColorTableSize(this.ctx);
                if (this.textureColorTableSize > 256) {
                    this.textureColorTableSize = 256;
                }
            }
            this.createQueryProps();
        }
        return this.queryProps;
    }

    native int readOffScreenBuffer(int var1, int var2, int var3, int var4);

    void redraw() {
        if (this.view != null && this.active && this.isRunning) {
            this.view.repaint();
        }
    }

    public void removeNotify() {
        this.validCtx = false;
        this.validCanvas = false;
        super.removeNotify();
        ((Window)this.parent).removeWindowListener(this.eventCatcher);
        this.visible = false;
        if (!this.offScreen) {
            this.added = false;
            this.firstPaintCalled = false;
        }
        if (this.screen != null && this.screen.renderer != null && this.ctx != 0) {
            VirtualUniverse.mc.postRequest(MasterControl.FREE_CONTEXT, this);
        }
        this.evaluateActive();
        if (this.canvasViewEventCatcher.parentList.size() > 0) {
            int n = this.canvasViewEventCatcher.parentList.size() - 1;
            while (n >= 0) {
                Component component = (Component)this.canvasViewEventCatcher.parentList.get(n);
                component.removeComponentListener(this.canvasViewEventCatcher);
                --n;
            }
            this.canvasViewEventCatcher.parentList.clear();
        }
        this.removeComponentListener(this.canvasViewEventCatcher);
        VirtualUniverse.mc.freeCanvasBit(this.canvasBit);
    }

    public void renderField(int n) {
    }

    public void renderOffScreenBuffer() {
        int n;
        if (!this.offScreen) {
            throw new IllegalStateException(J3dI18N.getString("Canvas3D1"));
        }
        if (this.offScreenBuffer == null) {
            throw new NullPointerException(J3dI18N.getString("Canvas3D10"));
        }
        Dimension dimension = this.screen.getSize();
        if (dimension.width <= 0) {
            throw new IllegalStateException(J3dI18N.getString("Canvas3D8"));
        }
        if (dimension.height <= 0) {
            throw new IllegalStateException(J3dI18N.getString("Canvas3D9"));
        }
        if (this.screen.getPhysicalScreenWidth() <= 0.0) {
            throw new IllegalStateException(J3dI18N.getString("Canvas3D12"));
        }
        if (this.screen.getPhysicalScreenHeight() <= 0.0) {
            throw new IllegalStateException(J3dI18N.getString("Canvas3D13"));
        }
        if (this.offScreenRendering) {
            throw new RestrictedAccessException(J3dI18N.getString("Canvas3D2"));
        }
        if (!this.isRunning) {
            throw new RestrictedAccessException(J3dI18N.getString("Canvas3D11"));
        }
        if (!this.active) {
            return;
        }
        if (this.offScreenCanvasLoc.x >= dimension.width || this.offScreenCanvasLoc.y >= dimension.height) {
            return;
        }
        if (this.offScreenCanvasLoc.x < 0) {
            this.offScreenCanvasClippedLoc.x = -this.offScreenCanvasLoc.x;
            this.offScreenCanvasClippedSize.width = this.offScreenCanvasSize.width - this.offScreenCanvasClippedLoc.x;
            if (this.offScreenCanvasClippedSize.width > dimension.width) {
                this.offScreenCanvasClippedSize.width = dimension.width;
            }
        } else {
            this.offScreenCanvasClippedLoc.x = 0;
            this.offScreenCanvasClippedSize.width = this.offScreenCanvasSize.width;
            if (this.offScreenCanvasLoc.x + this.offScreenCanvasClippedSize.width > dimension.width) {
                this.offScreenCanvasClippedSize.width = dimension.width - this.offScreenCanvasLoc.x;
            }
        }
        if ((n = this.offScreenCanvasLoc.y + this.offScreenCanvasSize.height) < 0) {
            return;
        }
        if (n <= dimension.height) {
            this.offScreenCanvasClippedLoc.y = 0;
            this.offScreenCanvasClippedSize.height = this.offScreenCanvasLoc.y < 0 ? n : this.offScreenCanvasSize.height;
        } else if (n > dimension.height) {
            this.offScreenCanvasClippedSize.height = dimension.height - this.offScreenCanvasLoc.y;
            this.offScreenCanvasClippedLoc.y = n - dimension.height;
        }
        this.offScreenRendering = true;
        if (this.view.inCanvasCallback) {
            J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
            j3dMessage.threads = 16;
            j3dMessage.type = 42;
            j3dMessage.universe = this.view.universe;
            j3dMessage.view = this.view;
            j3dMessage.args[0] = this;
            this.screen.renderer.rendererStructure.addMessage(j3dMessage);
            this.screen.renderer.args = new Object[3];
            this.screen.renderer.args[0] = new Integer(3);
            this.screen.renderer.args[1] = this;
            this.screen.renderer.args[2] = this.view;
            this.screen.renderer.doWork(0L);
        } else if (Thread.currentThread() == this.view.universe.behaviorScheduler) {
            J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
            j3dMessage.threads = 16;
            j3dMessage.type = 42;
            j3dMessage.universe = this.view.universe;
            j3dMessage.view = this.view;
            j3dMessage.args[0] = this;
            this.screen.renderer.rendererStructure.addMessage(j3dMessage);
            VirtualUniverse.mc.setWorkForRequestRenderer();
        } else {
            J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
            j3dMessage.threads = 128;
            j3dMessage.type = 42;
            j3dMessage.universe = this.view.universe;
            j3dMessage.view = this.view;
            j3dMessage.args[0] = this;
            j3dMessage.args[1] = this.offScreenBuffer;
            VirtualUniverse.mc.processMessage(j3dMessage);
        }
    }

    native void resetColoringAttributes(int var1, float var2, float var3, float var4, float var5, boolean var6);

    native void resetLineAttributes(int var1);

    native void resetPointAttributes(int var1);

    native void resetPolygonAttributes(int var1);

    native void resetRenderingAttributes(int var1, boolean var2, boolean var3);

    native void resetTexCoordGeneration(int var1);

    void resetTexture(int n, int n2) {
        this.resetTextureNative(n, n2);
        if (n2 <= 0) {
            this.texture = null;
        }
    }

    native void resetTextureAttributes(int var1);

    native void resetTextureNative(int var1, int var2);

    native void resetTransparency(int var1, int var2, boolean var3, boolean var4);

    native void resizeD3DCanvas(int var1);

    synchronized void runMonitor(int n) {
        if (n == 0) {
            while (!this.swapDone) {
                this.waiting = true;
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
                this.waiting = false;
            }
            this.swapDone = false;
        } else {
            this.swapDone = true;
            if (this.waiting) {
                this.notify();
            }
        }
    }

    void sendEventToBehaviorScheduler(AWTEvent aWTEvent) {
        VirtualUniverse virtualUniverse;
        if (this.view != null && this.view.viewPlatform != null && (virtualUniverse = ((ViewPlatformRetained)this.view.viewPlatform.retained).universe) != null) {
            virtualUniverse.behaviorStructure.handleAWTEvent(aWTEvent);
        }
    }

    native void setBlendFunc(int var1, int var2, int var3);

    void setDepthBufferEnableOverride(boolean bl) {
        this.depthBufferEnableOverride = bl;
    }

    native void setDepthBufferWriteEnable(int var1, boolean var2);

    void setDepthBufferWriteEnableOverride(boolean bl) {
        this.depthBufferWriteEnableOverride = bl;
    }

    native void setDepthFunc(int var1, int var2);

    public void setDoubleBufferEnable(boolean bl) {
        this.doubleBufferEnable = bl;
        boolean bl2 = this.useDoubleBuffer = this.doubleBufferEnable && this.doubleBufferAvailable;
        if (Thread.currentThread() == this.screen.renderer) {
            this.setRenderMode(this.ctx, 2, this.useDoubleBuffer);
        }
        this.redraw();
    }

    native void setFogEnableFlag(int var1, boolean var2);

    void setFrustumPlanes(Vector4d[] vector4dArray) {
        this.viewFrustum.set(vector4dArray);
    }

    native void setFullSceneAntialiasing(int var1, boolean var2);

    public void setLeftManualEyeInImagePlate(Point3d point3d) {
        this.leftManualEyeInImagePlate.set((Tuple3d)point3d);
        Object object = this.dirtyMaskLock;
        synchronized (object) {
            this.cvDirtyMask |= 4;
        }
        this.redraw();
    }

    native void setLightEnables(int var1, long var2, int var4);

    void setLocalEyeLightingEnable(boolean bl) {
        this.localEyeLightingEnable = bl;
    }

    native void setModelViewMatrix(int var1, double[] var2, double[] var3);

    public void setMonoscopicViewPolicy(int n) {
        if (this.view != null && this.view.viewPolicy == 1 && this.monoscopicViewPolicy == 2 && !this.useStereo) {
            throw new IllegalStateException(J3dI18N.getString("View31"));
        }
        this.monoscopicViewPolicy = n;
        Object object = this.dirtyMaskLock;
        synchronized (object) {
            this.cvDirtyMask |= 2;
        }
        this.redraw();
    }

    public void setOffScreenBuffer(ImageComponent2D imageComponent2D) {
        ImageComponent2DRetained imageComponent2DRetained = (ImageComponent2DRetained)imageComponent2D.retained;
        if (!this.offScreen) {
            throw new IllegalStateException(J3dI18N.getString("Canvas3D1"));
        }
        if (this.offScreenRendering) {
            throw new RestrictedAccessException(J3dI18N.getString("Canvas3D2"));
        }
        if (this.offScreenCanvasSize.width != imageComponent2DRetained.width || this.offScreenCanvasSize.height != imageComponent2DRetained.height) {
            if (this.window != 0) {
                this.destroyContext(this.screen.display, this.window, this.ctx);
                this.destroyOffScreenBuffer(this.ctx, this.screen.display, this.window);
                this.window = 0;
            }
            this.offScreenCanvasSize.setSize(imageComponent2DRetained.width, imageComponent2DRetained.height);
            this.setSize(this.offScreenCanvasSize);
            this.window = this.createOffScreenBuffer(this.ctx, this.screen.display, this.vid, this.offScreenCanvasSize.width, this.offScreenCanvasSize.height);
            this.ctx = 0;
        }
        this.offScreenBuffer = imageComponent2D;
        Object object = this.dirtyMaskLock;
        synchronized (object) {
            this.cvDirtyMask |= 8;
        }
    }

    public void setOffScreenLocation(int n, int n2) {
        if (!this.offScreen) {
            throw new IllegalStateException(J3dI18N.getString("Canvas3D1"));
        }
        Object object = this.cvLock;
        synchronized (object) {
            this.offScreenCanvasLoc.setLocation(n, n2);
        }
    }

    public void setOffScreenLocation(Point point) {
        if (!this.offScreen) {
            throw new IllegalStateException(J3dI18N.getString("Canvas3D1"));
        }
        Object object = this.cvLock;
        synchronized (object) {
            this.offScreenCanvasLoc.setLocation(point);
        }
    }

    native void setProjectionMatrix(int var1, double[] var2);

    native void setRenderMode(int var1, int var2, boolean var3);

    public void setRightManualEyeInImagePlate(Point3d point3d) {
        this.rightManualEyeInImagePlate.set((Tuple3d)point3d);
        Object object = this.dirtyMaskLock;
        synchronized (object) {
            this.cvDirtyMask |= 4;
        }
        this.redraw();
    }

    native void setSceneAmbient(int var1, float var2, float var3, float var4);

    native void setSpecular(int var1, boolean var2);

    public void setStereoEnable(boolean bl) {
        this.stereoEnable = bl;
        this.useStereo = this.stereoEnable && this.stereoAvailable;
        Object object = this.dirtyMaskLock;
        synchronized (object) {
            this.cvDirtyMask |= 1;
        }
        this.redraw();
    }

    void setView(View view) {
        boolean bl = false;
        if (this.view != null) {
            if (!this.offScreen) {
                this.stopRenderer();
            }
            bl = true;
        }
        Object object = this.cvLock;
        synchronized (object) {
            this.view = view;
            if (view == null) {
                this.canvasViewCache = null;
            } else {
                this.canvasViewCache = new CanvasViewCache(this, this.screen.screenViewCache, view.viewCache);
                Object object2 = this.dirtyMaskLock;
                synchronized (object2) {
                    this.cvDirtyMask = 15;
                }
            }
        }
        if (bl) {
            this.startRenderer();
        }
    }

    native void setViewport(int var1, int var2, int var3, int var4, int var5);

    public final void startRenderer() {
        if (!this.isRunning) {
            VirtualUniverse.mc.postRequest(MasterControl.START_RENDERER, this);
            this.isRunning = true;
        }
    }

    public final void stopRenderer() {
        if (this.offScreen) {
            throw new IllegalStateException(J3dI18N.getString("Canvas3D14"));
        }
        if (this.isRunning) {
            VirtualUniverse.mc.postRequest(MasterControl.STOP_RENDERER, this);
            this.isRunning = false;
        }
    }

    public void swap() {
        if (this.offScreen) {
            throw new IllegalStateException(J3dI18N.getString("Canvas3D14"));
        }
        if (this.isRunning) {
            throw new RestrictedAccessException(J3dI18N.getString("Canvas3D0"));
        }
        if (this.view != null) {
            if (this.view.universe != null && Thread.currentThread() == this.view.universe.behaviorScheduler) {
                this.graphicsContext3D.sendRenderMessage(false, 2, null, null);
            } else {
                this.graphicsContext3D.sendRenderMessage(true, 2, null, null);
            }
            this.runMonitor(0);
        }
    }

    native void swapBuffers(int var1, int var2, int var3);

    native void syncRender(int var1, boolean var2);

    native void texturemapping(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, byte[] var10);

    native void toggleFullScreenMode(int var1);

    native void updateMaterial(int var1, float var2, float var3, float var4, float var5);

    void updateViewCache(boolean bl, CanvasViewCache canvasViewCache, BoundingBox boundingBox, boolean bl2) {
        Object object = this.cvLock;
        synchronized (object) {
            if (this.firstPaintCalled && this.canvasViewCache != null) {
                this.canvasViewCache.snapshot();
                this.canvasViewCache.computeDerivedData(bl, canvasViewCache, boundingBox, bl2);
            }
        }
    }

    native void useCtx(int var1, int var2, int var3);

    native boolean useSharedCtx();

    public void waitForOffScreenRendering() {
        while (this.offScreenRendering) {
            Thread.currentThread();
            Thread.yield();
        }
    }
}

