/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.GroupRetained;
import javax.media.j3d.Locale;
import javax.media.j3d.SetLiveState;

class BranchGroupRetained
extends GroupRetained {
    boolean isDirty = false;
    boolean isNew = false;
    boolean attachedToLocale = false;

    BranchGroupRetained() {
        this.nodeType = 19;
    }

    void compile() {
        this.setCompiled();
    }

    void detach() {
        if (this.universe != null) {
            Object object = this.universe.sceneGraphLock;
            synchronized (object) {
                if (this.source.isLive()) {
                    this.notifySceneGraphChanged(true);
                }
                this.do_detach();
            }
        } else {
            this.do_detach();
        }
    }

    void do_detach() {
        if (this.attachedToLocale) {
            this.locale.doRemoveBranchGraph((BranchGroup)this.source, null, 0);
        } else if (this.parent != null) {
            GroupRetained groupRetained = (GroupRetained)this.parent;
            groupRetained.doRemoveChild(groupRetained.children.indexOf(this), null, 0);
        }
    }

    Locale getLocale() {
        return this.locale;
    }

    void setLive(SetLiveState setLiveState) {
        int n = setLiveState.branchGroupPaths.size();
        ArrayList<BranchGroupRetained[]> arrayList = new ArrayList<BranchGroupRetained[]>(n);
        int n2 = 0;
        while (n2 < n) {
            BranchGroupRetained[] branchGroupRetainedArray = (BranchGroupRetained[])setLiveState.branchGroupPaths.get(n2);
            BranchGroupRetained[] branchGroupRetainedArray2 = new BranchGroupRetained[branchGroupRetainedArray.length + 1];
            System.arraycopy(branchGroupRetainedArray, 0, branchGroupRetainedArray2, 0, branchGroupRetainedArray.length);
            branchGroupRetainedArray2[branchGroupRetainedArray.length] = this;
            arrayList.add(branchGroupRetainedArray2);
            ++n2;
        }
        setLiveState.branchGroupPaths = arrayList;
        super.doSetLive(setLiveState);
        super.markAsLive();
    }

    void setLocale(Locale locale) {
        this.locale = locale;
    }
}

