/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.Behavior;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.BoundingLeaf;
import javax.media.j3d.BoundingLeafRetained;
import javax.media.j3d.Bounds;
import javax.media.j3d.ContainsNodes;
import javax.media.j3d.IllegalSharingException;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.LeafRetained;
import javax.media.j3d.SetLiveState;
import javax.media.j3d.View;
import javax.media.j3d.ViewPlatformRetained;
import javax.media.j3d.VirtualUniverse;
import javax.media.j3d.WakeupCondition;

class BehaviorRetained
extends LeafRetained {
    static final int WAKEUP_ACTIVATE_INDEX = 0;
    static final int WAKEUP_DEACTIVATE_INDEX = 1;
    static final int WAKEUP_VP_ENTRY_INDEX = 2;
    static final int WAKEUP_VP_EXIT_INDEX = 3;
    static final int WAKEUP_TIME_INDEX = 4;
    static final int NUM_WAKEUPS = 5;
    static final int WAKEUP_ACTIVATE = 1;
    static final int WAKEUP_DEACTIVATE = 2;
    static final int WAKEUP_VP_ENTRY = 4;
    static final int WAKEUP_VP_EXIT = 8;
    static final int WAKEUP_TIME = 16;
    Bounds schedulingRegion = null;
    BoundingLeafRetained boundingLeaf = null;
    WakeupCondition wakeupCondition = null;
    ViewPlatformRetained vp = null;
    boolean active = false;
    boolean enable = true;
    boolean conditionSet = false;
    boolean inCallback = false;
    boolean inInitCallback = false;
    Bounds transformedRegion = null;
    int isDirty = 65535;
    int wakeupMask = 0;
    int[] wakeupArray = new int[5];
    Object[] targets = new Object[1];

    BehaviorRetained() {
        this.nodeType = 17;
        this.localBounds = new BoundingBox();
        ((BoundingBox)this.localBounds).setLower(1.0, 1.0, 1.0);
        ((BoundingBox)this.localBounds).setUpper(-1.0, -1.0, -1.0);
        this.targets[0] = this;
    }

    void addWakeupCondition() {
    }

    synchronized void clearLive(SetLiveState setLiveState) {
        super.clearLive(setLiveState);
        setLiveState.nodeList.add(this);
        setLiveState.notifyThreads |= 0x100;
        if (this.boundingLeaf != null) {
            this.boundingLeaf.mirrorBoundingLeaf.removeUser(this);
        }
    }

    void executeInitialize() {
        BehaviorRetained behaviorRetained = this;
        synchronized (behaviorRetained) {
            boolean bl = this.inCallback;
            boolean bl2 = this.inInitCallback;
            this.inCallback = true;
            this.inInitCallback = true;
            try {
                ((Behavior)this.source).initialize();
            }
            catch (RuntimeException runtimeException) {
                this.inCallback = bl;
                this.inInitCallback = bl2;
                System.err.println("Exception occurred during Behavior initialization:");
                runtimeException.printStackTrace();
            }
            this.inCallback = bl;
            this.inInitCallback = bl2;
        }
    }

    boolean getEnable() {
        return this.enable;
    }

    BoundingLeaf getSchedulingBoundingLeaf() {
        return this.boundingLeaf != null ? (BoundingLeaf)this.boundingLeaf.source : null;
    }

    Bounds getSchedulingBounds() {
        return this.schedulingRegion == null ? null : (Bounds)this.schedulingRegion.clone();
    }

    protected View getView() {
        return this.universe != null ? this.universe.getCurrentView() : null;
    }

    void postId(int n) {
        if (this.source != null && this.source.isLive()) {
            this.universe.behaviorStructure.handleBehaviorPost((Behavior)this.source, n);
        }
    }

    final void sendMessage(int n) {
        J3dMessage j3dMessage = VirtualUniverse.mc.getMessage();
        j3dMessage.threads = 256;
        j3dMessage.type = n;
        j3dMessage.universe = this.universe;
        j3dMessage.args[0] = this.targets;
        j3dMessage.args[1] = this;
        VirtualUniverse.mc.processMessage(j3dMessage);
    }

    void setEnable(boolean bl) {
        if (this.enable != bl) {
            this.enable = bl;
            if (this.source != null && this.source.isLive()) {
                this.sendMessage(bl ? 29 : 30);
            }
        }
    }

    synchronized void setLive(SetLiveState setLiveState) {
        super.doSetLive(setLiveState);
        if (this.inBackgroundGroup) {
            throw new IllegalSharingException(J3dI18N.getString("BehaviorRetained0"));
        }
        setLiveState.nodeList.add(this);
        setLiveState.behaviorNodes.add(this);
        setLiveState.notifyThreads |= 0x101;
        if (setLiveState.inSharedGroup) {
            int n = 0;
            while (n < setLiveState.keys.length) {
                if (setLiveState.switchLevels[n] >= 0) {
                    this.clearCompositeSwitchMask();
                    this.isNewSwitchLeaf = true;
                    ContainsNodes containsNodes = setLiveState.containsNodesList.getContainsNodes(setLiveState.keys[n]);
                    containsNodes.behaviorNodes.add(this);
                }
                ++n;
            }
        } else if (setLiveState.switchLevels[0] >= 0) {
            this.clearCompositeSwitchMask();
            this.isNewSwitchLeaf = true;
            ContainsNodes containsNodes = setLiveState.containsNodesList.getContainsNodes(0);
            containsNodes.behaviorNodes.add(this);
        }
        if (this.boundingLeaf != null) {
            this.boundingLeaf.mirrorBoundingLeaf.addUser(this);
        }
        if (setLiveState.transformTargets != null) {
            setLiveState.transformTargets.add(this);
        }
        super.markAsLive();
    }

    synchronized void setSchedulingBoundingLeaf(BoundingLeaf boundingLeaf) {
        if (this.source != null && this.source.isLive() && this.boundingLeaf != null) {
            this.boundingLeaf.mirrorBoundingLeaf.removeUser(this);
        }
        this.boundingLeaf = boundingLeaf != null ? (BoundingLeafRetained)boundingLeaf.retained : null;
        if (this.source != null && this.source.isLive()) {
            if (this.boundingLeaf != null) {
                this.boundingLeaf.mirrorBoundingLeaf.addUser(this);
            }
            this.sendMessage(3);
        }
    }

    synchronized void setSchedulingBounds(Bounds bounds) {
        this.schedulingRegion = bounds != null ? (Bounds)bounds.clone() : null;
        if (this.source != null && this.source.isLive()) {
            this.sendMessage(3);
        }
    }

    void updateBoundingLeaf(long l) {
        this.transformedRegion = this.boundingLeaf.mirrorBoundingLeaf.transformedRegion;
    }

    synchronized void updateTransformRegion() {
        if (this.boundingLeaf == null || !this.boundingLeaf.mirrorBoundingLeaf.currentSwitchOn) {
            if (this.schedulingRegion == null) {
                this.transformedRegion = null;
            } else {
                if (this.transformedRegion != null) {
                    this.transformedRegion.set(this.schedulingRegion);
                } else {
                    this.transformedRegion = (Bounds)this.schedulingRegion.clone();
                }
                this.transformedRegion.transform(this.getCurrentLocalToVworld(null));
            }
        } else {
            this.transformedRegion = this.boundingLeaf.mirrorBoundingLeaf.transformedRegion;
        }
    }

    synchronized void updateTransformRegion(Bounds bounds) {
        if (this.boundingLeaf == null) {
            this.updateTransformRegion();
        } else if (bounds == null) {
            this.transformedRegion = null;
        } else {
            this.transformedRegion = (Bounds)bounds.clone();
            this.transformedRegion.transform(this.boundingLeaf.mirrorBoundingLeaf.currentLocalToVworld[0]);
        }
    }

    synchronized void wakeupOn(WakeupCondition wakeupCondition) {
        if (this.conditionSet && this.wakeupCondition != null) {
            this.conditionSet = false;
            this.wakeupCondition.cleanTree();
        }
        this.wakeupCondition = wakeupCondition;
        if (!this.inInitCallback) {
            wakeupCondition.buildTree(null, 0, this);
            this.conditionSet = true;
        }
    }
}

