/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.Bounds;
import javax.media.j3d.NodeComponentRetained;
import javax.vecmath.Point2f;

class AuralAttributesRetained
extends NodeComponentRetained {
    float attributeGain = 1.0f;
    float rolloff = 1.0f;
    static final float SPEED_OF_SOUND = 0.344f;
    float reflectionCoefficient = 0.0f;
    float reverbDelay = 0.0f;
    Bounds reverbBounds = null;
    int reverbOrder = 0;
    static final int NO_FILTERING = -1;
    static final int LOW_PASS = 1;
    int filterType = -1;
    float[] distance = null;
    float[] frequencyCutoff = null;
    float frequencyScaleFactor = 1.0f;
    float velocityScaleFactor = 0.0f;
    boolean aaDirty = true;
    AuralAttributesRetained mirrorAa = null;
    static final boolean debugFlag = false;
    static final boolean internalErrors = false;

    AuralAttributesRetained() {
    }

    void debugPrint(String string) {
    }

    float getAttributeGain() {
        return this.attributeGain;
    }

    void getDistanceFilter(float[] fArray, float[] fArray2) {
        if (fArray == null || fArray2 == null) {
            return;
        }
        if (this.distance == null || this.frequencyCutoff == null) {
            return;
        }
        int n = this.distance.length;
        if (fArray.length < n) {
            n = fArray.length;
        }
        System.arraycopy(this.distance, 0, fArray, 0, n);
        int n2 = this.frequencyCutoff.length;
        if (fArray2.length < n2) {
            n2 = fArray2.length;
        }
        if (this.filterType == -1) {
            int n3 = 0;
            while (n3 < n2) {
                fArray2[n3] = -1.0f;
                ++n3;
            }
        }
        if (this.filterType == 1) {
            System.arraycopy(this.frequencyCutoff, 0, fArray2, 0, n2);
        }
    }

    void getDistanceFilter(Point2f[] point2fArray) {
        if (point2fArray == null) {
            return;
        }
        if (this.distance == null || this.frequencyCutoff == null) {
            return;
        }
        int n = this.distance.length;
        if (n > point2fArray.length) {
            n = point2fArray.length;
        }
        int n2 = 0;
        while (n2 < n) {
            point2fArray[n2].x = this.distance[n2];
            if (this.filterType == -1) {
                point2fArray[n2].y = -1.0f;
            } else if (this.filterType == 1) {
                point2fArray[n2].y = this.frequencyCutoff[n2];
            }
            ++n2;
        }
    }

    int getDistanceFilterLength() {
        if (this.distance == null) {
            return 0;
        }
        return this.distance.length;
    }

    float getFrequencyScaleFactor() {
        return this.frequencyScaleFactor;
    }

    float getReflectionCoefficient() {
        return this.reflectionCoefficient;
    }

    Bounds getReverbBounds() {
        return this.reverbBounds;
    }

    float getReverbDelay() {
        return this.reverbDelay;
    }

    int getReverbOrder() {
        return this.reverbOrder;
    }

    float getRolloff() {
        return this.rolloff;
    }

    float getVelocityScaleFactor() {
        return this.velocityScaleFactor;
    }

    synchronized void reset(AuralAttributesRetained auralAttributesRetained) {
        this.attributeGain = auralAttributesRetained.attributeGain;
        this.rolloff = auralAttributesRetained.rolloff;
        this.reflectionCoefficient = auralAttributesRetained.reflectionCoefficient;
        this.reverbDelay = auralAttributesRetained.reverbDelay;
        this.reverbBounds = auralAttributesRetained.reverbBounds;
        this.reverbOrder = auralAttributesRetained.reverbOrder;
        this.frequencyScaleFactor = auralAttributesRetained.frequencyScaleFactor;
        this.velocityScaleFactor = auralAttributesRetained.velocityScaleFactor;
        if (auralAttributesRetained.distance != null) {
            this.distance = new float[auralAttributesRetained.distance.length];
            System.arraycopy(auralAttributesRetained.distance, 0, this.distance, 0, this.distance.length);
        }
        if (auralAttributesRetained.frequencyCutoff != null) {
            this.frequencyCutoff = new float[auralAttributesRetained.frequencyCutoff.length];
            System.arraycopy(auralAttributesRetained.frequencyCutoff, 0, this.frequencyCutoff, 0, this.frequencyCutoff.length);
        }
        this.aaDirty = false;
        auralAttributesRetained.aaDirty = false;
    }

    void setAttributeGain(float f) {
        this.attributeGain = f;
        this.aaDirty = true;
        this.notifyUsers();
    }

    synchronized void setDistanceFilter(float[] fArray, float[] fArray2) {
        if (fArray == null || fArray2 == null) {
            this.filterType = -1;
            return;
        }
        int n = fArray.length;
        int n2 = fArray2.length;
        if (n == 0 || n2 == 0) {
            this.filterType = -1;
            return;
        }
        if (this.distance == null || this.distance != null && this.distance.length != n2) {
            this.distance = new float[n];
            this.frequencyCutoff = new float[n];
        }
        this.filterType = 1;
        System.arraycopy(fArray, 0, this.distance, 0, n);
        if (n <= n2) {
            System.arraycopy(fArray2, 0, this.frequencyCutoff, 0, n);
        } else {
            System.arraycopy(fArray2, 0, this.frequencyCutoff, 0, n2);
            int n3 = n2;
            while (n3 < n) {
                this.frequencyCutoff[n3] = fArray2[n2 - 1];
                ++n3;
            }
        }
        this.aaDirty = true;
        this.notifyUsers();
    }

    synchronized void setDistanceFilter(Point2f[] point2fArray) {
        if (point2fArray == null) {
            this.filterType = -1;
            return;
        }
        int n = point2fArray.length;
        if (n == 0) {
            this.filterType = -1;
            return;
        }
        this.filterType = 1;
        if (this.distance == null || this.distance != null && this.distance.length != n) {
            this.distance = new float[n];
            this.frequencyCutoff = new float[n];
        }
        int n2 = 0;
        while (n2 < n) {
            this.distance[n2] = point2fArray[n2].x;
            this.frequencyCutoff[n2] = point2fArray[n2].y;
            ++n2;
        }
        this.aaDirty = true;
        this.notifyUsers();
    }

    void setFrequencyScaleFactor(float f) {
        this.frequencyScaleFactor = f;
        this.aaDirty = true;
        this.notifyUsers();
    }

    void setReflectionCoefficient(float f) {
        this.reflectionCoefficient = f;
        this.aaDirty = true;
        this.notifyUsers();
    }

    synchronized void setReverbBounds(Bounds bounds) {
        this.reverbBounds = bounds;
        this.aaDirty = true;
        this.notifyUsers();
    }

    void setReverbDelay(float f) {
        this.reverbDelay = f;
        this.aaDirty = true;
        this.notifyUsers();
    }

    void setReverbOrder(int n) {
        this.reverbOrder = n;
        this.aaDirty = true;
        this.notifyUsers();
    }

    void setRolloff(float f) {
        this.rolloff = f;
        this.aaDirty = true;
        this.notifyUsers();
    }

    void setVelocityScaleFactor(float f) {
        this.velocityScaleFactor = f;
        this.aaDirty = true;
        this.notifyUsers();
    }

    void update(AuralAttributesRetained auralAttributesRetained) {
        this.reset(auralAttributesRetained);
    }
}

