/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.geometry;

import com.sun.j3d.utils.geometry.Edge;
import com.sun.j3d.utils.geometry.EdgeTable;
import com.sun.j3d.utils.geometry.GeometryInfo;
import com.sun.j3d.utils.geometry.Triangulator;
import java.util.ArrayList;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

public class NormalGenerator {
    private double creaseAngle;
    private Vector3f[] facetNorms;
    private ArrayList tally;
    private GeometryInfo gi;
    private int[] coordInds;
    private int[] normalInds;
    private int[] colorInds;
    private int[] texInds;
    private int[] stripCounts;
    private static long t1 = 0L;
    private static long t2 = 0L;
    private static long t3 = 0L;
    private static long t4 = 0L;
    private static long t5 = 0L;
    private static long t6 = 0L;
    private Triangulator tr = null;
    private static final int DEBUG = 0;

    public NormalGenerator() {
        this(0.767944870877505);
    }

    public NormalGenerator(double d) {
        this.creaseAngle = d;
    }

    private void calculateVertexNormals(int n) {
        Vector3f[] vector3fArray;
        if (this.creaseAngle != 0.0) {
            Vector3f[] vector3fArray2 = new Vector3f[n];
            vector3fArray = new Vector3f[this.tally.size()];
            this.normalInds = new int[this.coordInds.length];
            int n2 = 0;
            while (n2 < this.tally.size()) {
                ArrayList arrayList = (ArrayList)this.tally.get(n2);
                int n3 = 0;
                vector3fArray[n2] = new Vector3f();
                int n4 = 0;
                while (n4 < arrayList.size()) {
                    int n5 = (Integer)arrayList.get(n4);
                    if (n5 != -1) {
                        int n6 = n5 / 3;
                        if (!Float.isNaN(this.facetNorms[n6].x)) {
                            int n7 = 0;
                            while (n7 < n3) {
                                if (vector3fArray2[n7].equals((Tuple3f)this.facetNorms[n6])) break;
                                ++n7;
                            }
                            this.normalInds[n5] = n2;
                            if (n7 == n3) {
                                vector3fArray[n2].add((Tuple3f)this.facetNorms[n6]);
                                vector3fArray2[n3++] = this.facetNorms[n6];
                            }
                        }
                    }
                    ++n4;
                }
                vector3fArray[n2].normalize();
                if (Float.isNaN(vector3fArray[n2].x)) {
                    vector3fArray[n2].x = 1.0f;
                    vector3fArray[n2].z = 0.0f;
                    vector3fArray[n2].y = 0.0f;
                }
                ++n2;
            }
        } else {
            vector3fArray = this.facetNorms;
            this.normalInds = new int[this.facetNorms.length * 3];
            int n8 = 0;
            while (n8 < this.facetNorms.length) {
                this.normalInds[n8 * 3] = n8;
                this.normalInds[n8 * 3 + 1] = n8;
                this.normalInds[n8 * 3 + 2] = n8;
                ++n8;
            }
        }
        this.gi.setNormals(vector3fArray);
    }

    private void calculatefacetNorms() {
        Point3f[] point3fArray = this.gi.getCoordinates();
        this.facetNorms = new Vector3f[this.coordInds.length / 3];
        Vector3f vector3f = new Vector3f();
        Vector3f vector3f2 = new Vector3f();
        if (this.gi.getOldPrim() != 2) {
            int n = 0;
            while (n < this.coordInds.length) {
                vector3f.sub((Tuple3f)point3fArray[this.coordInds[n + 2]], (Tuple3f)point3fArray[this.coordInds[n + 1]]);
                vector3f2.sub((Tuple3f)point3fArray[this.coordInds[n]], (Tuple3f)point3fArray[this.coordInds[n + 1]]);
                this.facetNorms[n / 3] = new Vector3f();
                this.facetNorms[n / 3].cross(vector3f, vector3f2);
                this.facetNorms[n / 3].normalize();
                if (Float.isNaN(this.facetNorms[n / 3].x)) {
                    this.facetNorms[n / 3].x = 1.0f;
                    this.facetNorms[n / 3].z = 0.0f;
                    this.facetNorms[n / 3].y = 0.0f;
                }
                n += 3;
            }
        } else {
            int n = 0;
            while (n < this.coordInds.length) {
                vector3f.sub((Tuple3f)point3fArray[this.coordInds[n + 2]], (Tuple3f)point3fArray[this.coordInds[n]]);
                vector3f2.sub((Tuple3f)point3fArray[this.coordInds[n + 5]], (Tuple3f)point3fArray[this.coordInds[n + 1]]);
                this.facetNorms[n / 3] = new Vector3f();
                this.facetNorms[n / 3].cross(vector3f, vector3f2);
                this.facetNorms[n / 3].normalize();
                if (Float.isNaN(this.facetNorms[n / 3].x)) {
                    this.facetNorms[n / 3].x = 1.0f;
                    this.facetNorms[n / 3].z = 0.0f;
                    this.facetNorms[n / 3].y = 0.0f;
                }
                this.facetNorms[n / 3 + 1] = new Vector3f(this.facetNorms[n / 3]);
                n += 6;
            }
        }
    }

    void convertBackToOldPrim(GeometryInfo geometryInfo, int n, int[] nArray) {
        if (n == 1) {
            return;
        }
        switch (n) {
            case 2: {
                this.convertTriToQuad(geometryInfo);
                break;
            }
            case 3: {
                this.convertTriToFan(geometryInfo, nArray);
                break;
            }
            case 4: {
                this.convertTriToStrip(geometryInfo, nArray);
                break;
            }
        }
    }

    private void convertTriToFan(GeometryInfo geometryInfo, int[] nArray) {
        int n;
        int[] nArray2 = geometryInfo.getNormalIndices();
        int n2 = 0;
        ArrayList<Integer> arrayList = new ArrayList<Integer>(nArray.length + 100);
        int n3 = 0;
        while (n3 < nArray.length) {
            int n4 = 3;
            n = 0;
            while (n < nArray[n3] - 3) {
                if (nArray2[n2 * 3] == nArray2[(n2 + 1) * 3] && nArray2[n2 * 3 + 2] == nArray2[(n2 + 1) * 3 + 1]) {
                    ++n4;
                } else {
                    arrayList.add(new Integer(n4));
                    n4 = 3;
                }
                ++n2;
                ++n;
            }
            ++n2;
            arrayList.add(new Integer(n4));
            ++n3;
        }
        int[] nArray3 = new int[arrayList.size()];
        n = 0;
        while (n < nArray3.length) {
            nArray3[n] = (Integer)arrayList.get(n);
            ++n;
        }
        arrayList = null;
        int n5 = 0;
        int n6 = 0;
        while (n6 < nArray3.length) {
            n5 += nArray3[n6];
            ++n6;
        }
        geometryInfo.setCoordinateIndices(this.triToFanIndices(nArray3, geometryInfo.getCoordinateIndices(), n5));
        geometryInfo.setColorIndices(this.triToFanIndices(nArray3, geometryInfo.getColorIndices(), n5));
        geometryInfo.setNormalIndices(this.triToFanIndices(nArray3, geometryInfo.getNormalIndices(), n5));
        geometryInfo.setTextureCoordinateIndices(this.triToFanIndices(nArray3, geometryInfo.getTextureCoordinateIndices(), n5));
        geometryInfo.setStripCounts(nArray3);
        geometryInfo.setPrimitive(3);
    }

    private void convertTriToQuad(GeometryInfo geometryInfo) {
        geometryInfo.setCoordinateIndices(this.triToQuadIndices(geometryInfo.getCoordinateIndices()));
        geometryInfo.setColorIndices(this.triToQuadIndices(geometryInfo.getColorIndices()));
        geometryInfo.setNormalIndices(this.triToQuadIndices(geometryInfo.getNormalIndices()));
        geometryInfo.setTextureCoordinateIndices(this.triToQuadIndices(geometryInfo.getTextureCoordinateIndices()));
        geometryInfo.setPrimitive(2);
    }

    private void convertTriToStrip(GeometryInfo geometryInfo, int[] nArray) {
        int n;
        int[] nArray2 = geometryInfo.getNormalIndices();
        int n2 = 0;
        ArrayList<Integer> arrayList = new ArrayList<Integer>(nArray.length + 100);
        int n3 = 0;
        while (n3 < nArray.length) {
            int n4 = 3;
            n = 0;
            while (n < nArray[n3] - 3) {
                if (n % 2 == 0) {
                    if (nArray2[n2 * 3 + 1] == nArray2[(n2 + 1) * 3] && nArray2[n2 * 3 + 2] == nArray2[(n2 + 1) * 3 + 2]) {
                        ++n4;
                    } else {
                        arrayList.add(new Integer(n4));
                        n4 = 3;
                        if (n < nArray[n3] - 4) {
                            arrayList.add(new Integer(3));
                            ++n;
                        }
                    }
                } else if (nArray2[n2 * 3 + 1] == nArray2[(n2 + 1) * 3 + 1] && nArray2[n2 * 3 + 2] == nArray2[(n2 + 1) * 3]) {
                    ++n4;
                } else {
                    arrayList.add(new Integer(n4));
                    n4 = 3;
                }
                ++n2;
                ++n;
            }
            ++n2;
            arrayList.add(new Integer(n4));
            ++n3;
        }
        int[] nArray3 = new int[arrayList.size()];
        n = 0;
        while (n < nArray3.length) {
            nArray3[n] = (Integer)arrayList.get(n);
            ++n;
        }
        arrayList = null;
        int n5 = 0;
        int n6 = 0;
        while (n6 < nArray3.length) {
            n5 += nArray3[n6];
            ++n6;
        }
        geometryInfo.setCoordinateIndices(this.triToStripIndices(nArray3, geometryInfo.getCoordinateIndices(), n5));
        geometryInfo.setColorIndices(this.triToStripIndices(nArray3, geometryInfo.getColorIndices(), n5));
        geometryInfo.setNormalIndices(this.triToStripIndices(nArray3, geometryInfo.getNormalIndices(), n5));
        geometryInfo.setTextureCoordinateIndices(this.triToStripIndices(nArray3, geometryInfo.getTextureCoordinateIndices(), n5));
        geometryInfo.setStripCounts(nArray3);
        geometryInfo.setPrimitive(4);
    }

    private int createHardEdges() {
        EdgeTable edgeTable = new EdgeTable(this.coordInds);
        this.tally = new ArrayList();
        int[] nArray = new int[this.coordInds.length];
        int n = 1;
        float f = (float)Math.cos(this.creaseAngle);
        int n2 = 0;
        while (n2 < this.coordInds.length) {
            nArray[n2] = Integer.MAX_VALUE;
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.coordInds.length) {
            if (nArray[n3] == Integer.MAX_VALUE) {
                boolean bl;
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                this.tally.add(arrayList);
                arrayList.add(new Integer(n3));
                nArray[n3] = this.tally.size() - 1;
                boolean bl2 = true;
                Edge edge = new Edge(this.coordInds[n3], this.coordInds[(n3 + 1) % 3 == 0 ? n3 - 2 : n3 + 1]);
                int n4 = this.coordInds[n3 % 3 == 0 ? n3 + 2 : n3 - 1];
                int n5 = n3;
                do {
                    Integer n6;
                    if ((n6 = edgeTable.get(edge.v2, edge.v1)) == null) {
                        bl = false;
                    } else {
                        int n7 = n6;
                        float f2 = this.facetNorms[n5 / 3].dot(this.facetNorms[n7 / 3]);
                        boolean bl3 = bl = f2 > f;
                        if (bl) {
                            int n8;
                            int n9 = n8 = (n7 + 1) % 3 == 0 ? n7 - 2 : n7 + 1;
                            if (this.coordInds[n3] != this.coordInds[n8]) {
                                int n10 = n8 = n7 % 3 == 0 ? n7 + 2 : n7 - 1;
                            }
                            if (nArray[n8] != Integer.MAX_VALUE) {
                                bl = false;
                            } else {
                                nArray[n8] = this.tally.size() - 1;
                                arrayList.add(new Integer(n8));
                                if (arrayList.size() > n) {
                                    n = arrayList.size();
                                }
                                n5 = n7;
                                if (bl2) {
                                    edge.v2 = this.coordInds[n5];
                                } else {
                                    edge.v1 = this.coordInds[n5];
                                }
                            }
                        }
                    }
                    if (bl || !bl2) continue;
                    bl2 = false;
                    bl = true;
                    n5 = n3;
                    edge = new Edge(this.coordInds[n3 % 3 == 0 ? n3 + 2 : n3 - 1], this.coordInds[n3]);
                } while (bl && (bl2 && edge.v2 != n4 || !bl2));
            }
            ++n3;
        }
        return n;
    }

    public void generateNormals(GeometryInfo geometryInfo) {
        this.gi = geometryInfo;
        this.gi.setNormals((float[])null);
        this.gi.setNormalIndices(null);
        this.gi.checkForBadData();
        long l = 0L;
        if (this.gi.getPrimitive() == 5) {
            if (this.tr == null) {
                this.tr = new Triangulator();
            }
            this.tr.triangulate(this.gi);
        }
        this.gi.rememberOldPrim();
        this.gi.convertToIndexedTriangles();
        this.coordInds = this.gi.getCoordinateIndices();
        this.colorInds = this.gi.getColorIndices();
        this.normalInds = this.gi.getNormalIndices();
        this.texInds = this.gi.getTextureCoordinateIndices();
        this.stripCounts = this.gi.getStripCounts();
        this.calculatefacetNorms();
        int n = this.createHardEdges();
        this.calculateVertexNormals(n);
        this.gi.setCoordinateIndices(this.coordInds);
        this.gi.setColorIndices(this.colorInds);
        this.gi.setNormalIndices(this.normalInds);
        this.gi.setTextureCoordinateIndices(this.texInds);
        this.gi.setStripCounts(this.stripCounts);
    }

    public double getCreaseAngle() {
        return this.creaseAngle;
    }

    public void setCreaseAngle(double d) {
        if (d > Math.PI) {
            d = Math.PI;
        }
        if (d < 0.0) {
            d = 0.0;
        }
        this.creaseAngle = d;
    }

    private int[] triToFanIndices(int[] nArray, int[] nArray2, int n) {
        if (nArray2 == null) {
            return null;
        }
        int[] nArray3 = new int[n];
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < nArray.length) {
            nArray3[n3++] = nArray2[n2++];
            nArray3[n3++] = nArray2[n2++];
            nArray3[n3++] = nArray2[n2++];
            int n5 = 3;
            while (n5 < nArray[n4]) {
                nArray3[n3++] = nArray2[n2 + 2];
                n2 += 3;
                ++n5;
            }
            ++n4;
        }
        return nArray3;
    }

    private int[] triToQuadIndices(int[] nArray) {
        if (nArray == null) {
            return null;
        }
        int[] nArray2 = new int[nArray.length / 6 * 4];
        int n = 0;
        while (n < nArray.length / 6) {
            nArray2[n * 4] = nArray[n * 6];
            nArray2[n * 4 + 1] = nArray[n * 6 + 1];
            nArray2[n * 4 + 2] = nArray[n * 6 + 2];
            nArray2[n * 4 + 3] = nArray[n * 6 + 5];
            ++n;
        }
        return nArray2;
    }

    private int[] triToStripIndices(int[] nArray, int[] nArray2, int n) {
        if (nArray2 == null) {
            return null;
        }
        int[] nArray3 = new int[n];
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < nArray.length) {
            nArray3[n3++] = nArray2[n2++];
            nArray3[n3++] = nArray2[n2++];
            nArray3[n3++] = nArray2[n2++];
            int n5 = 3;
            while (n5 < nArray[n4]) {
                nArray3[n3++] = nArray2[n2 + 2 - n5 % 2];
                n2 += 3;
                ++n5;
            }
            ++n4;
        }
        return nArray3;
    }
}

