/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.geometry;

import com.sun.j3d.internal.J3dUtilsI18N;
import com.sun.j3d.utils.geometry.NormalGenerator;
import com.sun.j3d.utils.geometry.Triangulator;
import java.util.Hashtable;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.IndexedGeometryArray;
import javax.media.j3d.IndexedQuadArray;
import javax.media.j3d.IndexedTriangleArray;
import javax.media.j3d.IndexedTriangleFanArray;
import javax.media.j3d.IndexedTriangleStripArray;
import javax.media.j3d.QuadArray;
import javax.media.j3d.TriangleArray;
import javax.media.j3d.TriangleFanArray;
import javax.media.j3d.TriangleStripArray;
import javax.vecmath.Color3b;
import javax.vecmath.Color3f;
import javax.vecmath.Color4b;
import javax.vecmath.Color4f;
import javax.vecmath.Point2f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;

public class GeometryInfo {
    public static final int TRIANGLE_ARRAY = 1;
    public static final int QUAD_ARRAY = 2;
    public static final int TRIANGLE_FAN_ARRAY = 3;
    public static final int TRIANGLE_STRIP_ARRAY = 4;
    public static final int POLYGON_ARRAY = 5;
    private int prim;
    private static final int DEBUG = 0;
    private Point3f[] coordinates = null;
    private Color3f[] colors3 = null;
    private Color4f[] colors4 = null;
    private Vector3f[] normals = null;
    private Point2f[] texCoords2 = null;
    private Point3f[] texCoords3 = null;
    private int[] coordinateIndices = null;
    private int[] colorIndices = null;
    private int[] normalIndices = null;
    private int[] texCoordIndices = null;
    private int[] stripCounts = null;
    private int[] contourCounts = null;
    private Triangulator tr = null;
    private NormalGenerator ng = null;
    private int oldPrim = 0;
    private int[] oldStripCounts = null;

    public GeometryInfo(int n) {
        if (n < 1 || n > 5) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryInfo0"));
        }
        this.prim = n;
    }

    private void changeBackToOldPrim() {
        if (this.oldPrim != 0) {
            if (this.ng == null) {
                this.ng = new NormalGenerator();
            }
            this.ng.convertBackToOldPrim(this, this.oldPrim, this.oldStripCounts);
            this.oldPrim = 0;
            this.oldStripCounts = null;
        }
    }

    void checkForBadData() {
        int n;
        int n2;
        if (this.coordinates == null) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryInfo3"));
        }
        if (this.colors3 == null && this.colors4 == null && this.colorIndices != null) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryInfo4"));
        }
        if (this.normals == null && this.normalIndices != null) {
            throw new IllegalArgumentException("Inconsistent normal data.");
        }
        if (this.texCoords2 == null && this.texCoords3 == null && this.texCoordIndices != null) {
            throw new IllegalArgumentException("Inconsistent texCoord data.");
        }
        boolean bl = false;
        if (this.coordinateIndices != null) {
            if ((this.colors3 != null || this.colors4 != null) && this.colorIndices.length != this.coordinateIndices.length) {
                bl = true;
            }
            if (this.normals != null && this.normalIndices.length != this.coordinateIndices.length) {
                bl = true;
            }
            if ((this.texCoords2 != null || this.texCoords3 != null) && this.texCoordIndices.length != this.coordinateIndices.length) {
                bl = true;
            }
        } else if (this.colorIndices != null || this.normalIndices != null || this.texCoordIndices != null) {
            bl = true;
        }
        if (bl) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryInfo5"));
        }
        if (this.prim == 4 || this.prim == 3 || this.prim == 5) {
            if (this.stripCounts == null) {
                bl = true;
            }
        } else if (this.stripCounts != null) {
            bl = true;
        }
        if (bl) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryInfo6"));
        }
        int n3 = this.coordinateIndices == null ? this.coordinates.length : this.coordinateIndices.length;
        if (this.prim == 4 || this.prim == 3 || this.prim == 5) {
            n2 = 0;
            n = 0;
            while (n < this.stripCounts.length) {
                n2 += this.stripCounts[n];
                ++n;
            }
            if (n2 != n3) {
                throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryInfo7"));
            }
        } else if (this.prim == 1) {
            if (n3 % 3 != 0) {
                throw new IllegalArgumentException("For triangles, number of vertices must be multiple of 3.");
            }
        } else if (this.prim == 2 && n3 % 4 != 0) {
            throw new IllegalArgumentException("For quads, number of vertices must be multiple of 4.");
        }
        if (this.prim == 5) {
            if (this.contourCounts != null) {
                n2 = 0;
                n = 0;
                while (n < this.contourCounts.length) {
                    n2 += this.contourCounts[n];
                    ++n;
                }
                if (n2 != this.stripCounts.length) {
                    throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryInfo8"));
                }
            }
        } else if (this.contourCounts != null) {
            throw new IllegalArgumentException("contourCounts only useful when primitive is POLYGON_ARRAY");
        }
    }

    void compact() {
        this.compactCoordinates();
        this.compactColors();
        this.compactNormals();
        this.compactTexCoords();
    }

    private void compactColors() {
        if (this.colorIndices != null) {
            int n;
            int n2;
            Object[] objectArray;
            int[] nArray = this.colors3 != null ? new int[this.colors3.length] : new int[this.colors4.length];
            int n3 = 0;
            int n4 = 0;
            while (n4 < this.colorIndices.length) {
                if (nArray[this.colorIndices[n4]] == 0) {
                    ++n3;
                    nArray[this.colorIndices[n4]] = 1;
                }
                ++n4;
            }
            if (this.colors3 != null) {
                objectArray = new Color3f[n3];
                n2 = 0;
                n = 0;
                while (n < nArray.length) {
                    if (nArray[n] != 0) {
                        objectArray[n2] = this.colors3[n];
                        nArray[n] = n2++;
                    }
                    ++n;
                }
                this.colors3 = objectArray;
            } else {
                objectArray = new Color4f[n3];
                n2 = 0;
                n = 0;
                while (n < nArray.length) {
                    if (nArray[n] != 0) {
                        objectArray[n2] = this.colors4[n];
                        nArray[n] = n2++;
                    }
                    ++n;
                }
                this.colors4 = objectArray;
            }
            objectArray = new int[this.colorIndices.length];
            n2 = 0;
            while (n2 < this.colorIndices.length) {
                objectArray[n2] = (Color3f)nArray[this.colorIndices[n2]];
                ++n2;
            }
            this.colorIndices = (int[])objectArray;
        }
    }

    private void compactCoordinates() {
        if (this.coordinateIndices != null) {
            int[] nArray = new int[this.coordinates.length];
            int n = 0;
            int n2 = 0;
            while (n2 < this.coordinateIndices.length) {
                if (nArray[this.coordinateIndices[n2]] == 0) {
                    ++n;
                    nArray[this.coordinateIndices[n2]] = 1;
                }
                ++n2;
            }
            Point3f[] point3fArray = new Point3f[n];
            int n3 = 0;
            int n4 = 0;
            while (n4 < nArray.length) {
                if (nArray[n4] != 0) {
                    point3fArray[n3] = this.coordinates[n4];
                    nArray[n4] = n3++;
                }
                ++n4;
            }
            this.coordinates = point3fArray;
            int[] nArray2 = new int[this.coordinateIndices.length];
            int n5 = 0;
            while (n5 < this.coordinateIndices.length) {
                nArray2[n5] = nArray[this.coordinateIndices[n5]];
                ++n5;
            }
            this.coordinateIndices = nArray2;
        }
    }

    private void compactNormals() {
        if (this.normalIndices != null) {
            int[] nArray = new int[this.normals.length];
            int n = 0;
            int n2 = 0;
            while (n2 < this.normalIndices.length) {
                if (nArray[this.normalIndices[n2]] == 0) {
                    ++n;
                    nArray[this.normalIndices[n2]] = 1;
                }
                ++n2;
            }
            Vector3f[] vector3fArray = new Vector3f[n];
            int n3 = 0;
            int n4 = 0;
            while (n4 < nArray.length) {
                if (nArray[n4] != 0) {
                    vector3fArray[n3] = this.normals[n4];
                    nArray[n4] = n3++;
                }
                ++n4;
            }
            this.normals = vector3fArray;
            int[] nArray2 = new int[this.normalIndices.length];
            int n5 = 0;
            while (n5 < this.normalIndices.length) {
                nArray2[n5] = nArray[this.normalIndices[n5]];
                ++n5;
            }
            this.normalIndices = nArray2;
        }
    }

    private void compactTexCoords() {
        if (this.texCoordIndices != null) {
            int n;
            int n2;
            Object[] objectArray;
            int[] nArray = this.texCoords2 != null ? new int[this.texCoords2.length] : new int[this.texCoords3.length];
            int n3 = 0;
            int n4 = 0;
            while (n4 < this.texCoordIndices.length) {
                if (nArray[this.texCoordIndices[n4]] == 0) {
                    ++n3;
                    nArray[this.texCoordIndices[n4]] = 1;
                }
                ++n4;
            }
            if (this.texCoords2 != null) {
                objectArray = new Point2f[n3];
                n2 = 0;
                n = 0;
                while (n < nArray.length) {
                    if (nArray[n] != 0) {
                        objectArray[n2] = this.texCoords2[n];
                        nArray[n] = n2++;
                    }
                    ++n;
                }
                this.texCoords2 = objectArray;
            } else {
                objectArray = new Point3f[n3];
                n2 = 0;
                n = 0;
                while (n < nArray.length) {
                    if (nArray[n] != 0) {
                        objectArray[n2] = this.texCoords3[n];
                        nArray[n] = n2++;
                    }
                    ++n;
                }
                this.texCoords3 = objectArray;
            }
            objectArray = new int[this.texCoordIndices.length];
            n2 = 0;
            while (n2 < this.texCoordIndices.length) {
                objectArray[n2] = (Point2f)nArray[this.texCoordIndices[n2]];
                ++n2;
            }
            this.texCoordIndices = (int[])objectArray;
        }
    }

    void convertToIndexedTriangles() {
        int n = 0;
        this.indexify();
        if (this.prim == 1) {
            return;
        }
        switch (this.prim) {
            case 2: {
                this.coordinateIndices = this.expandQuad(this.coordinateIndices);
                if (this.colorIndices != null) {
                    this.colorIndices = this.expandQuad(this.colorIndices);
                }
                if (this.normalIndices != null) {
                    this.normalIndices = this.expandQuad(this.normalIndices);
                }
                if (this.texCoordIndices == null) break;
                this.texCoordIndices = this.expandQuad(this.texCoordIndices);
                break;
            }
            case 3: {
                int n2 = 0;
                while (n2 < this.stripCounts.length) {
                    n += this.stripCounts[n2] - 2;
                    ++n2;
                }
                this.coordinateIndices = this.expandTriFan(n, this.coordinateIndices);
                if (this.colorIndices != null) {
                    this.colorIndices = this.expandTriFan(n, this.colorIndices);
                }
                if (this.normalIndices != null) {
                    this.normalIndices = this.expandTriFan(n, this.normalIndices);
                }
                if (this.texCoordIndices == null) break;
                this.texCoordIndices = this.expandTriFan(n, this.texCoordIndices);
                break;
            }
            case 4: {
                int n3 = 0;
                while (n3 < this.stripCounts.length) {
                    n += this.stripCounts[n3] - 2;
                    ++n3;
                }
                this.coordinateIndices = this.expandTriStrip(n, this.coordinateIndices);
                if (this.colorIndices != null) {
                    this.colorIndices = this.expandTriStrip(n, this.colorIndices);
                }
                if (this.normalIndices != null) {
                    this.normalIndices = this.expandTriStrip(n, this.normalIndices);
                }
                if (this.texCoordIndices == null) break;
                this.texCoordIndices = this.expandTriStrip(n, this.texCoordIndices);
                break;
            }
            case 5: {
                if (this.tr == null) {
                    this.tr = new Triangulator();
                }
                this.tr.triangulate(this);
                break;
            }
        }
        this.prim = 1;
        this.stripCounts = null;
    }

    private int[] expandQuad(int[] nArray) {
        int[] nArray2 = new int[nArray.length / 4 * 6];
        int n = 0;
        while (n < nArray.length / 4) {
            nArray2[n * 6] = nArray[n * 4];
            nArray2[n * 6 + 1] = nArray[n * 4 + 1];
            nArray2[n * 6 + 2] = nArray[n * 4 + 2];
            nArray2[n * 6 + 3] = nArray[n * 4];
            nArray2[n * 6 + 4] = nArray[n * 4 + 2];
            nArray2[n * 6 + 5] = nArray[n * 4 + 3];
            ++n;
        }
        return nArray2;
    }

    private int[] expandTriFan(int n, int[] nArray) {
        int[] nArray2 = new int[n * 3];
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.stripCounts.length) {
            int n5 = 0;
            while (n5 < this.stripCounts[n4] - 2) {
                nArray2[n2++] = nArray[n3];
                nArray2[n2++] = nArray[n3 + n5 + 1];
                nArray2[n2++] = nArray[n3 + n5 + 2];
                ++n5;
            }
            n3 += this.stripCounts[n4];
            ++n4;
        }
        return nArray2;
    }

    private int[] expandTriStrip(int n, int[] nArray) {
        int[] nArray2 = new int[n * 3];
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.stripCounts.length) {
            int n5 = 0;
            while (n5 < this.stripCounts[n4] - 2) {
                if (n5 % 2 == 0) {
                    nArray2[n2++] = nArray[n3 + n5];
                    nArray2[n2++] = nArray[n3 + n5 + 1];
                    nArray2[n2++] = nArray[n3 + n5 + 2];
                } else {
                    nArray2[n2++] = nArray[n3 + n5];
                    nArray2[n2++] = nArray[n3 + n5 + 2];
                    nArray2[n2++] = nArray[n3 + n5 + 1];
                }
                ++n5;
            }
            n3 += this.stripCounts[n4];
            ++n4;
        }
        return nArray2;
    }

    private void fillIn(GeometryArray geometryArray) {
        IndexedGeometryArray indexedGeometryArray = null;
        geometryArray.setCoordinates(0, this.coordinates);
        if (this.coordinateIndices != null) {
            indexedGeometryArray = (IndexedGeometryArray)geometryArray;
            indexedGeometryArray.setCoordinateIndices(0, this.coordinateIndices);
        }
        if (this.colors3 != null) {
            geometryArray.setColors(0, this.colors3);
        } else if (this.colors4 != null) {
            geometryArray.setColors(0, this.colors4);
        }
        if (this.colorIndices != null) {
            indexedGeometryArray.setColorIndices(0, this.colorIndices);
        }
        if (this.normals != null) {
            geometryArray.setNormals(0, this.normals);
        }
        if (this.normalIndices != null) {
            indexedGeometryArray.setNormalIndices(0, this.normalIndices);
        }
        if (this.texCoords2 != null) {
            geometryArray.setTextureCoordinates(0, this.texCoords2);
        } else if (this.texCoords3 != null) {
            geometryArray.setTextureCoordinates(0, this.texCoords3);
        }
        if (this.texCoordIndices != null) {
            indexedGeometryArray.setTextureCoordinateIndices(0, 0, this.texCoordIndices);
        }
    }

    void forgetOldPrim() {
        this.oldPrim = 0;
        this.oldStripCounts = null;
    }

    public int[] getColorIndices() {
        return this.colorIndices;
    }

    public Object[] getColors() {
        if (this.colors3 != null) {
            return this.colors3;
        }
        return this.colors4;
    }

    public int[] getContourCounts() {
        return this.contourCounts;
    }

    public int[] getCoordinateIndices() {
        return this.coordinateIndices;
    }

    public Point3f[] getCoordinates() {
        return this.coordinates;
    }

    public GeometryArray getGeometryArray() {
        this.checkForBadData();
        if (this.prim == 5) {
            if (this.tr == null) {
                this.tr = new Triangulator();
            }
            this.tr.triangulate(this);
        } else {
            this.changeBackToOldPrim();
        }
        this.unindexify();
        int n = this.getVertexFormat();
        int n2 = this.getVertexCount();
        TriangleArray triangleArray = null;
        switch (this.prim) {
            case 1: {
                TriangleArray triangleArray2;
                triangleArray = triangleArray2 = new TriangleArray(n2, n);
                break;
            }
            case 2: {
                QuadArray quadArray = new QuadArray(n2, n);
                triangleArray = quadArray;
                break;
            }
            case 4: {
                TriangleStripArray triangleStripArray = new TriangleStripArray(n2, n, this.stripCounts);
                triangleArray = triangleStripArray;
                break;
            }
            case 3: {
                TriangleFanArray triangleFanArray = new TriangleFanArray(n2, n, this.stripCounts);
                triangleArray = triangleFanArray;
                break;
            }
        }
        this.fillIn((GeometryArray)triangleArray);
        return triangleArray;
    }

    public IndexedGeometryArray getIndexedGeometryArray() {
        return this.getIndexedGeometryArray(false);
    }

    public IndexedGeometryArray getIndexedGeometryArray(boolean bl) {
        this.checkForBadData();
        this.indexify();
        if (bl) {
            this.compact();
        }
        if (this.prim == 5) {
            if (this.tr == null) {
                this.tr = new Triangulator();
            }
            this.tr.triangulate(this);
        } else {
            this.changeBackToOldPrim();
        }
        int n = this.getVertexFormat();
        int n2 = this.getVertexCount();
        IndexedTriangleArray indexedTriangleArray = null;
        switch (this.prim) {
            case 1: {
                IndexedTriangleArray indexedTriangleArray2;
                indexedTriangleArray = indexedTriangleArray2 = new IndexedTriangleArray(n2, n, this.coordinateIndices.length);
                break;
            }
            case 2: {
                IndexedQuadArray indexedQuadArray = new IndexedQuadArray(n2, n, this.coordinateIndices.length);
                indexedTriangleArray = indexedQuadArray;
                break;
            }
            case 4: {
                IndexedTriangleStripArray indexedTriangleStripArray = new IndexedTriangleStripArray(n2, n, this.coordinateIndices.length, this.stripCounts);
                indexedTriangleArray = indexedTriangleStripArray;
                break;
            }
            case 3: {
                IndexedTriangleFanArray indexedTriangleFanArray = new IndexedTriangleFanArray(n2, n, this.coordinateIndices.length, this.stripCounts);
                indexedTriangleArray = indexedTriangleFanArray;
                break;
            }
        }
        this.fillIn((GeometryArray)indexedTriangleArray);
        return indexedTriangleArray;
    }

    int[] getListIndices(Object[] objectArray) {
        int[] nArray = new int[objectArray.length];
        Hashtable<Object, Integer> hashtable = new Hashtable<Object, Integer>(objectArray.length, 0.5f);
        int n = 0;
        while (n < objectArray.length) {
            Integer n2 = (Integer)hashtable.get(objectArray[n]);
            if (n2 == null) {
                nArray[n] = n;
                hashtable.put(objectArray[n], new Integer(n));
            } else {
                nArray[n] = n2;
            }
            ++n;
        }
        return nArray;
    }

    public int[] getNormalIndices() {
        return this.normalIndices;
    }

    public Vector3f[] getNormals() {
        return this.normals;
    }

    public int getNumColorComponents() {
        if (this.colors3 != null) {
            return 3;
        }
        if (this.colors4 != null) {
            return 4;
        }
        return 0;
    }

    public int getNumTexCoordComponents() {
        if (this.texCoords2 != null) {
            return 2;
        }
        if (this.texCoords3 != null) {
            return 3;
        }
        return 0;
    }

    int getOldPrim() {
        return this.oldPrim;
    }

    public int getPrimitive() {
        return this.prim;
    }

    public int[] getStripCounts() {
        return this.stripCounts;
    }

    public int[] getTextureCoordinateIndices() {
        return this.texCoordIndices;
    }

    public Object[] getTextureCoordinates() {
        if (this.texCoords2 != null) {
            return this.texCoords2;
        }
        return this.texCoords3;
    }

    private int getVertexCount() {
        int n = this.coordinates.length;
        if (this.colors3 != null) {
            if (this.colors3.length > n) {
                n = this.colors3.length;
            }
        } else if (this.colors4 != null && this.colors4.length > n) {
            n = this.colors4.length;
        }
        if (this.normals != null && this.normals.length > n) {
            n = this.normals.length;
        }
        if (this.texCoords2 != null) {
            if (this.texCoords2.length > n) {
                n = this.texCoords2.length;
            }
        } else if (this.texCoords3 != null && this.texCoords3.length > n) {
            n = this.texCoords3.length;
        }
        return n;
    }

    private int getVertexFormat() {
        int n = 1;
        if (this.colors3 != null) {
            n |= 4;
        } else if (this.colors4 != null) {
            n |= 0xC;
        }
        if (this.normals != null) {
            n |= 2;
        }
        if (this.texCoords2 != null) {
            n |= 0x20;
        } else if (this.texCoords3 != null) {
            n |= 0x40;
        }
        return n;
    }

    void indexify() {
        if (this.coordinateIndices != null) {
            return;
        }
        this.coordinateIndices = this.getListIndices(this.coordinates);
        if (this.colors3 != null) {
            this.colorIndices = this.getListIndices(this.colors3);
        } else if (this.colors4 != null) {
            this.colorIndices = this.getListIndices(this.colors4);
        }
        if (this.normals != null) {
            this.normalIndices = this.getListIndices(this.normals);
        }
        if (this.texCoords2 != null) {
            this.texCoordIndices = this.getListIndices(this.texCoords2);
        } else if (this.texCoords3 != null) {
            this.texCoordIndices = this.getListIndices(this.texCoords3);
        }
    }

    public void recomputeIndices() {
        this.unindexify();
        this.indexify();
    }

    void rememberOldPrim() {
        this.oldPrim = this.prim;
        this.oldStripCounts = this.stripCounts;
    }

    public void reset(int n) {
        if (n < 1 || n > 5) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryInfo0"));
        }
        this.prim = n;
        this.coordinates = null;
        this.colors3 = null;
        this.colors4 = null;
        this.normals = null;
        this.texCoords2 = null;
        this.texCoords3 = null;
        this.coordinateIndices = null;
        this.colorIndices = null;
        this.normalIndices = null;
        this.texCoordIndices = null;
        this.stripCounts = null;
        this.contourCounts = null;
        this.oldPrim = 0;
        this.oldStripCounts = null;
    }

    public void reverse() {
        this.checkForBadData();
        this.indexify();
        this.reverseList(this.stripCounts);
        this.reverseList(this.oldStripCounts);
        this.reverseList(this.contourCounts);
        this.reverseList(this.coordinateIndices);
        this.reverseList(this.colorIndices);
        this.reverseList(this.normalIndices);
        this.reverseList(this.texCoordIndices);
    }

    private void reverseList(int[] nArray) {
        if (nArray == null) {
            return;
        }
        int n = 0;
        while (n < nArray.length / 2) {
            int n2 = nArray[n];
            nArray[n] = nArray[nArray.length - n - 1];
            nArray[nArray.length - n - 1] = n2;
            ++n;
        }
    }

    public void setColorIndices(int[] nArray) {
        this.colorIndices = nArray;
    }

    public void setColors(Color3b[] color3bArray) {
        if (color3bArray == null) {
            this.colors3 = null;
            this.colors4 = null;
        } else {
            this.colors3 = new Color3f[color3bArray.length];
            this.colors4 = null;
            int n = 0;
            while (n < color3bArray.length) {
                this.colors3[n] = new Color3f((float)(color3bArray[n].x & 0xFF) / 255.0f, (float)(color3bArray[n].y & 0xFF) / 255.0f, (float)(color3bArray[n].z & 0xFF) / 255.0f);
                ++n;
            }
        }
    }

    public void setColors(Color3f[] color3fArray) {
        this.colors3 = color3fArray;
        this.colors4 = null;
    }

    public void setColors(Color4b[] color4bArray) {
        if (color4bArray == null) {
            this.colors3 = null;
            this.colors4 = null;
        } else {
            this.colors3 = null;
            this.colors4 = new Color4f[color4bArray.length];
            int n = 0;
            while (n < color4bArray.length) {
                this.colors4[n] = new Color4f((float)(color4bArray[n].x & 0xFF) / 255.0f, (float)(color4bArray[n].y & 0xFF) / 255.0f, (float)(color4bArray[n].z & 0xFF) / 255.0f, (float)(color4bArray[n].w & 0xFF) / 255.0f);
                ++n;
            }
        }
    }

    public void setColors(Color4f[] color4fArray) {
        this.colors3 = null;
        this.colors4 = color4fArray;
    }

    public void setColors3(byte[] byArray) {
        if (byArray == null) {
            this.colors3 = null;
            this.colors4 = null;
        } else {
            this.colors3 = new Color3f[byArray.length / 3];
            this.colors4 = null;
            int n = 0;
            while (n < byArray.length / 3) {
                this.colors3[n] = new Color3f((float)(byArray[n * 3] & 0xFF) / 255.0f, (float)(byArray[n * 3 + 1] & 0xFF) / 255.0f, (float)(byArray[n * 3 + 2] & 0xFF) / 255.0f);
                ++n;
            }
        }
    }

    public void setColors3(float[] fArray) {
        if (fArray == null) {
            this.colors3 = null;
            this.colors4 = null;
        } else {
            this.colors3 = new Color3f[fArray.length / 3];
            this.colors4 = null;
            int n = 0;
            while (n < fArray.length / 3) {
                this.colors3[n] = new Color3f(fArray[n * 3], fArray[n * 3 + 1], fArray[n * 3 + 2]);
                ++n;
            }
        }
    }

    public void setColors4(byte[] byArray) {
        if (byArray == null) {
            this.colors3 = null;
            this.colors4 = null;
        } else {
            this.colors3 = null;
            this.colors4 = new Color4f[byArray.length / 4];
            int n = 0;
            while (n < byArray.length / 4) {
                this.colors4[n] = new Color4f((float)(byArray[n * 4] & 0xFF) / 255.0f, (float)(byArray[n * 4 + 1] & 0xFF) / 255.0f, (float)(byArray[n * 4 + 2] & 0xFF) / 255.0f, (float)(byArray[n * 4 + 3] & 0xFF) / 255.0f);
                ++n;
            }
        }
    }

    public void setColors4(float[] fArray) {
        if (fArray == null) {
            this.colors3 = null;
            this.colors4 = null;
        } else {
            this.colors3 = null;
            this.colors4 = new Color4f[fArray.length / 4];
            int n = 0;
            while (n < fArray.length / 4) {
                this.colors4[n] = new Color4f(fArray[n * 4], fArray[n * 4 + 1], fArray[n * 4 + 2], fArray[n * 4 + 3]);
                ++n;
            }
        }
    }

    public void setContourCounts(int[] nArray) {
        this.contourCounts = nArray;
    }

    public void setCoordinateIndices(int[] nArray) {
        this.coordinateIndices = nArray;
    }

    public void setCoordinates(double[] dArray) {
        if (dArray == null) {
            this.coordinates = null;
        } else {
            this.coordinates = new Point3f[dArray.length / 3];
            int n = 0;
            while (n < dArray.length / 3) {
                this.coordinates[n] = new Point3f((float)dArray[n * 3], (float)dArray[n * 3 + 1], (float)dArray[n * 3 + 2]);
                ++n;
            }
        }
    }

    public void setCoordinates(float[] fArray) {
        if (fArray == null) {
            this.coordinates = null;
        } else {
            this.coordinates = new Point3f[fArray.length / 3];
            int n = 0;
            while (n < this.coordinates.length) {
                this.coordinates[n] = new Point3f(fArray[n * 3], fArray[n * 3 + 1], fArray[n * 3 + 2]);
                ++n;
            }
        }
    }

    public void setCoordinates(Point3d[] point3dArray) {
        if (point3dArray == null) {
            this.coordinates = null;
        } else {
            this.coordinates = new Point3f[point3dArray.length];
            int n = 0;
            while (n < point3dArray.length) {
                this.coordinates[n] = new Point3f((float)point3dArray[n].x, (float)point3dArray[n].y, (float)point3dArray[n].z);
                ++n;
            }
        }
    }

    public void setCoordinates(Point3f[] point3fArray) {
        this.coordinates = point3fArray;
    }

    public void setNormalIndices(int[] nArray) {
        this.normalIndices = nArray;
    }

    public void setNormals(float[] fArray) {
        if (fArray == null) {
            this.normals = null;
        } else {
            this.normals = new Vector3f[fArray.length / 3];
            int n = 0;
            while (n < fArray.length / 3) {
                this.normals[n] = new Vector3f(fArray[n * 3], fArray[n * 3 + 1], fArray[n * 3 + 2]);
                ++n;
            }
        }
    }

    public void setNormals(Vector3f[] vector3fArray) {
        this.normals = vector3fArray;
    }

    void setPrimitive(int n) {
        if (this.prim < 1 || this.prim > 5) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryInfo0"));
        }
        this.prim = n;
    }

    public void setStripCounts(int[] nArray) {
        this.stripCounts = nArray;
    }

    public void setTextureCoordinateIndices(int[] nArray) {
        this.texCoordIndices = nArray;
    }

    public void setTextureCoordinates(Point2f[] point2fArray) {
        this.texCoords2 = point2fArray;
        this.texCoords3 = null;
    }

    public void setTextureCoordinates(Point3f[] point3fArray) {
        this.texCoords2 = null;
        this.texCoords3 = point3fArray;
    }

    public void setTextureCoordinates2(float[] fArray) {
        if (fArray == null) {
            this.texCoords2 = null;
            this.texCoords3 = null;
        } else {
            this.texCoords2 = new Point2f[fArray.length / 2];
            this.texCoords3 = null;
            int n = 0;
            while (n < fArray.length / 2) {
                this.texCoords2[n] = new Point2f(fArray[n * 2], fArray[n * 2 + 1]);
                ++n;
            }
        }
    }

    public void setTextureCoordinates3(float[] fArray) {
        if (fArray == null) {
            this.texCoords2 = null;
            this.texCoords3 = null;
        } else {
            this.texCoords2 = null;
            this.texCoords3 = new Point3f[fArray.length / 3];
            int n = 0;
            while (n < fArray.length / 3) {
                this.texCoords3[n] = new Point3f(fArray[n * 3], fArray[n * 3 + 1], fArray[n * 3 + 2]);
                ++n;
            }
        }
    }

    private void unindexify() {
        int n;
        Point3f[] point3fArray;
        if (this.coordinateIndices != null) {
            point3fArray = new Point3f[this.coordinateIndices.length];
            n = 0;
            while (n < this.coordinateIndices.length) {
                point3fArray[n] = this.coordinates[this.coordinateIndices[n]];
                ++n;
            }
            this.coordinates = point3fArray;
            this.coordinateIndices = null;
        }
        if (this.colorIndices != null) {
            if (this.colors3 != null) {
                point3fArray = new Color3f[this.colorIndices.length];
                n = 0;
                while (n < this.colorIndices.length) {
                    point3fArray[n] = this.colors3[this.colorIndices[n]];
                    ++n;
                }
                this.colors3 = point3fArray;
            } else {
                point3fArray = new Color4f[this.colorIndices.length];
                n = 0;
                while (n < this.colorIndices.length) {
                    point3fArray[n] = this.colors4[this.colorIndices[n]];
                    ++n;
                }
                this.colors4 = point3fArray;
            }
            this.colorIndices = null;
        }
        if (this.normalIndices != null) {
            point3fArray = new Vector3f[this.normalIndices.length];
            n = 0;
            while (n < this.normalIndices.length) {
                point3fArray[n] = this.normals[this.normalIndices[n]];
                ++n;
            }
            this.normals = point3fArray;
            this.normalIndices = null;
        }
        if (this.texCoordIndices != null) {
            if (this.texCoords2 != null) {
                point3fArray = new Point2f[this.texCoordIndices.length];
                n = 0;
                while (n < this.texCoordIndices.length) {
                    point3fArray[n] = this.texCoords2[this.texCoordIndices[n]];
                    ++n;
                }
                this.texCoords2 = point3fArray;
            } else {
                point3fArray = new Point3f[this.texCoordIndices.length];
                n = 0;
                while (n < this.texCoordIndices.length) {
                    point3fArray[n] = this.texCoords3[this.texCoordIndices[n]];
                    ++n;
                }
                this.texCoords3 = point3fArray;
            }
            this.texCoordIndices = null;
        }
    }
}

