/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.compression;

import com.sun.j3d.utils.compression.CommandStream;
import com.sun.j3d.utils.compression.CompressionStream;
import com.sun.j3d.utils.compression.HuffmanTable;

abstract class CompressionStreamElement {
    int length;
    int shift;
    boolean absolute;
    static final int[] quantizationMask = new int[]{-65536, Short.MIN_VALUE, -16384, -8192, -4096, -2048, -1024, -512, -256, -128, -64, -32, -16, -8, -4, -2, -1};
    static final long[] lengthMask;

    static {
        long[] lArray = new long[65];
        lArray[1] = 1L;
        lArray[2] = 3L;
        lArray[3] = 7L;
        lArray[4] = 15L;
        lArray[5] = 31L;
        lArray[6] = 63L;
        lArray[7] = 127L;
        lArray[8] = 255L;
        lArray[9] = 511L;
        lArray[10] = 1023L;
        lArray[11] = 2047L;
        lArray[12] = 4095L;
        lArray[13] = 8191L;
        lArray[14] = 16383L;
        lArray[15] = 32767L;
        lArray[16] = 65535L;
        lArray[17] = 131071L;
        lArray[18] = 262143L;
        lArray[19] = 524287L;
        lArray[20] = 1048575L;
        lArray[21] = 0x1FFFFFL;
        lArray[22] = 0x3FFFFFL;
        lArray[23] = 0x7FFFFFL;
        lArray[24] = 0xFFFFFFL;
        lArray[25] = 0x1FFFFFFL;
        lArray[26] = 0x3FFFFFFL;
        lArray[27] = 0x7FFFFFFL;
        lArray[28] = 0xFFFFFFFL;
        lArray[29] = 0x1FFFFFFFL;
        lArray[30] = 0x3FFFFFFFL;
        lArray[31] = Integer.MAX_VALUE;
        lArray[32] = 0xFFFFFFFFL;
        lArray[33] = 0x1FFFFFFFFL;
        lArray[34] = 0x3FFFFFFFFL;
        lArray[35] = 0x7FFFFFFFFL;
        lArray[36] = 0xFFFFFFFFFL;
        lArray[37] = 0x1FFFFFFFFFL;
        lArray[38] = 0x3FFFFFFFFFL;
        lArray[39] = 0x7FFFFFFFFFL;
        lArray[40] = 0xFFFFFFFFFFL;
        lArray[41] = 0x1FFFFFFFFFFL;
        lArray[42] = 0x3FFFFFFFFFFL;
        lArray[43] = 0x7FFFFFFFFFFL;
        lArray[44] = 0xFFFFFFFFFFFL;
        lArray[45] = 0x1FFFFFFFFFFFL;
        lArray[46] = 0x3FFFFFFFFFFFL;
        lArray[47] = 0x7FFFFFFFFFFFL;
        lArray[48] = 0xFFFFFFFFFFFFL;
        lArray[49] = 0x1FFFFFFFFFFFFL;
        lArray[50] = 0x3FFFFFFFFFFFFL;
        lArray[51] = 0x7FFFFFFFFFFFFL;
        lArray[52] = 0xFFFFFFFFFFFFFL;
        lArray[53] = 0x1FFFFFFFFFFFFFL;
        lArray[54] = 0x3FFFFFFFFFFFFFL;
        lArray[55] = 0x7FFFFFFFFFFFFFL;
        lArray[56] = 0xFFFFFFFFFFFFFFL;
        lArray[57] = 0x1FFFFFFFFFFFFFFL;
        lArray[58] = 0x3FFFFFFFFFFFFFFL;
        lArray[59] = 0x7FFFFFFFFFFFFFFL;
        lArray[60] = 0xFFFFFFFFFFFFFFFL;
        lArray[61] = 0x1FFFFFFFFFFFFFFFL;
        lArray[62] = 0x3FFFFFFFFFFFFFFFL;
        lArray[63] = Long.MAX_VALUE;
        lArray[64] = -1L;
        lengthMask = lArray;
    }

    CompressionStreamElement() {
    }

    final void computeLengthShift(int n, int n2) {
        int n3 = n & 0x8000;
        int n4 = n2 & 0x8000;
        this.length = n3 == n4 ? (n3 == 0 ? CompressionStreamElement.getLength(n | n2) : CompressionStreamElement.getLength(n & n2)) : CompressionStreamElement.getMaximum(CompressionStreamElement.getLength(n), CompressionStreamElement.getLength(n2));
        this.shift = CompressionStreamElement.getShift(n | n2);
    }

    final void computeLengthShift(int n, int n2, int n3) {
        int n4 = n & 0x8000;
        int n5 = n2 & 0x8000;
        int n6 = n3 & 0x8000;
        this.length = n4 == n5 ? (n5 == n6 ? (n6 == 0 ? CompressionStreamElement.getLength(n | n2 | n3) : CompressionStreamElement.getLength(n & n2 & n3)) : (n5 == 0 ? CompressionStreamElement.getMaximum(CompressionStreamElement.getLength(n | n2), CompressionStreamElement.getLength(n3)) : CompressionStreamElement.getMaximum(CompressionStreamElement.getLength(n & n2), CompressionStreamElement.getLength(n3)))) : (n5 == n6 ? (n6 == 0 ? CompressionStreamElement.getMaximum(CompressionStreamElement.getLength(n2 | n3), CompressionStreamElement.getLength(n)) : CompressionStreamElement.getMaximum(CompressionStreamElement.getLength(n2 & n3), CompressionStreamElement.getLength(n))) : (n4 == 0 ? CompressionStreamElement.getMaximum(CompressionStreamElement.getLength(n | n3), CompressionStreamElement.getLength(n2)) : CompressionStreamElement.getMaximum(CompressionStreamElement.getLength(n & n3), CompressionStreamElement.getLength(n2))));
        this.shift = CompressionStreamElement.getShift(n | n2 | n3);
    }

    final void computeLengthShift(int n, int n2, int n3, int n4) {
        this.length = CompressionStreamElement.getMaximum(CompressionStreamElement.getLength(n), CompressionStreamElement.getLength(n2), CompressionStreamElement.getLength(n3), CompressionStreamElement.getLength(n4));
        this.shift = CompressionStreamElement.getShift(n | n2 | n3 | n4);
    }

    private static final int getLength(int n) {
        if (n == 0) {
            return 0;
        }
        if ((n & 0x8000) > 0) {
            if ((n & 0x4000) == 0) {
                return 16;
            }
            if ((n & 0x2000) == 0) {
                return 15;
            }
            if ((n & 0x1000) == 0) {
                return 14;
            }
            if ((n & 0x800) == 0) {
                return 13;
            }
            if ((n & 0x400) == 0) {
                return 12;
            }
            if ((n & 0x200) == 0) {
                return 11;
            }
            if ((n & 0x100) == 0) {
                return 10;
            }
            if ((n & 0x80) == 0) {
                return 9;
            }
            if ((n & 0x40) == 0) {
                return 8;
            }
            if ((n & 0x20) == 0) {
                return 7;
            }
            if ((n & 0x10) == 0) {
                return 6;
            }
            if ((n & 8) == 0) {
                return 5;
            }
            if ((n & 4) == 0) {
                return 4;
            }
            if ((n & 2) == 0) {
                return 3;
            }
            if ((n & 1) == 0) {
                return 2;
            }
            return 1;
        }
        if ((n & 0x4000) > 0) {
            return 16;
        }
        if ((n & 0x2000) > 0) {
            return 15;
        }
        if ((n & 0x1000) > 0) {
            return 14;
        }
        if ((n & 0x800) > 0) {
            return 13;
        }
        if ((n & 0x400) > 0) {
            return 12;
        }
        if ((n & 0x200) > 0) {
            return 11;
        }
        if ((n & 0x100) > 0) {
            return 10;
        }
        if ((n & 0x80) > 0) {
            return 9;
        }
        if ((n & 0x40) > 0) {
            return 8;
        }
        if ((n & 0x20) > 0) {
            return 7;
        }
        if ((n & 0x10) > 0) {
            return 6;
        }
        if ((n & 8) > 0) {
            return 5;
        }
        if ((n & 4) > 0) {
            return 4;
        }
        if ((n & 2) > 0) {
            return 3;
        }
        return 2;
    }

    private static final int getMaximum(int n, int n2) {
        if (n > n2) {
            return n;
        }
        return n2;
    }

    private static final int getMaximum(int n, int n2, int n3) {
        if (n > n2) {
            if (n > n3) {
                return n;
            }
            return n3;
        }
        if (n2 > n3) {
            return n2;
        }
        return n3;
    }

    private static final int getMaximum(int n, int n2, int n3, int n4) {
        int n5;
        int n6 = n > n2 ? n : n2;
        if (n6 > (n5 = n3 > n4 ? n3 : n4)) {
            return n6;
        }
        return n5;
    }

    private static final int getShift(int n) {
        if (n == 0) {
            return 0;
        }
        if ((n & 1) > 0) {
            return 0;
        }
        if ((n & 2) > 0) {
            return 1;
        }
        if ((n & 4) > 0) {
            return 2;
        }
        if ((n & 8) > 0) {
            return 3;
        }
        if ((n & 0x10) > 0) {
            return 4;
        }
        if ((n & 0x20) > 0) {
            return 5;
        }
        if ((n & 0x40) > 0) {
            return 6;
        }
        if ((n & 0x80) > 0) {
            return 7;
        }
        if ((n & 0x100) > 0) {
            return 8;
        }
        if ((n & 0x200) > 0) {
            return 9;
        }
        if ((n & 0x400) > 0) {
            return 10;
        }
        if ((n & 0x800) > 0) {
            return 11;
        }
        if ((n & 0x1000) > 0) {
            return 12;
        }
        if ((n & 0x2000) > 0) {
            return 13;
        }
        if ((n & 0x4000) > 0) {
            return 14;
        }
        return 15;
    }

    void outputCommand(HuffmanTable huffmanTable, CommandStream commandStream) {
    }

    abstract void quantize(CompressionStream var1, HuffmanTable var2);
}

