/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.behaviors.mouse;

import com.sun.j3d.utils.behaviors.mouse.MouseBehavior;
import com.sun.j3d.utils.behaviors.mouse.MouseBehaviorCallback;
import java.awt.AWTEvent;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupCriterion;
import javax.media.j3d.WakeupOnAWTEvent;
import javax.vecmath.Vector3d;

public class MouseTranslate
extends MouseBehavior {
    double x_factor = 0.02;
    double y_factor = 0.02;
    Vector3d translation = new Vector3d();
    private MouseBehaviorCallback callback = null;

    public MouseTranslate() {
        super(0);
    }

    public MouseTranslate(int n) {
        super(n);
    }

    public MouseTranslate(TransformGroup transformGroup) {
        super(transformGroup);
    }

    public double getXFactor() {
        return this.x_factor;
    }

    public double getYFactor() {
        return this.y_factor;
    }

    public void initialize() {
        super.initialize();
        if ((this.flags & 2) == 2) {
            this.invert = true;
            this.x_factor *= -1.0;
            this.y_factor *= -1.0;
        }
    }

    public void processStimulus(Enumeration enumeration) {
        while (enumeration.hasMoreElements()) {
            AWTEvent[] aWTEventArray;
            WakeupCriterion wakeupCriterion = (WakeupCriterion)enumeration.nextElement();
            if (!(wakeupCriterion instanceof WakeupOnAWTEvent) || (aWTEventArray = ((WakeupOnAWTEvent)wakeupCriterion).getAWTEvent()).length <= 0) continue;
            MouseEvent mouseEvent = (MouseEvent)aWTEventArray[aWTEventArray.length - 1];
            this.processMouseEvent(mouseEvent);
            if ((!this.buttonPress || (this.flags & 1) != 0) && (!this.wakeUp || (this.flags & 1) == 0)) continue;
            int n = mouseEvent.getID();
            if (n == 506 && !mouseEvent.isAltDown() && mouseEvent.isMetaDown()) {
                this.x = mouseEvent.getX();
                this.y = mouseEvent.getY();
                int n2 = this.x - this.x_last;
                int n3 = this.y - this.y_last;
                if (!this.reset && Math.abs(n3) < 50 && Math.abs(n2) < 50) {
                    this.transformGroup.getTransform(this.currXform);
                    this.translation.x = (double)n2 * this.x_factor;
                    this.translation.y = (double)(-n3) * this.y_factor;
                    this.transformX.set(this.translation);
                    if (this.invert) {
                        this.currXform.mul(this.currXform, this.transformX);
                    } else {
                        this.currXform.mul(this.transformX, this.currXform);
                    }
                    this.transformGroup.setTransform(this.currXform);
                    this.transformChanged(this.currXform);
                    if (this.callback != null) {
                        this.callback.transformChanged(1, this.currXform);
                    }
                } else {
                    this.reset = false;
                }
                this.x_last = this.x;
                this.y_last = this.y;
                continue;
            }
            if (n != 501) continue;
            this.x_last = mouseEvent.getX();
            this.y_last = mouseEvent.getY();
        }
        this.wakeupOn((WakeupCondition)this.mouseCriterion);
    }

    public void setFactor(double d) {
        this.x_factor = this.y_factor = d;
    }

    public void setFactor(double d, double d2) {
        this.x_factor = d;
        this.y_factor = d2;
    }

    public void setupCallback(MouseBehaviorCallback mouseBehaviorCallback) {
        this.callback = mouseBehaviorCallback;
    }

    public void transformChanged(Transform3D transform3D) {
    }
}

