/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.behaviors.interpolators;

import com.sun.j3d.internal.J3dUtilsI18N;
import com.sun.j3d.utils.behaviors.interpolators.TCBKeyFrame;
import javax.media.j3d.Alpha;
import javax.media.j3d.Interpolator;
import javax.media.j3d.Node;

public abstract class TCBSplinePathInterpolator
extends Interpolator {
    private int keysLength;
    protected TCBKeyFrame[] keyFrames;
    protected float currentU;
    protected int lowerKnot;
    protected int upperKnot;

    TCBSplinePathInterpolator() {
    }

    public TCBSplinePathInterpolator(Alpha alpha, TCBKeyFrame[] tCBKeyFrameArray) {
        super(alpha);
        this.keysLength = tCBKeyFrameArray.length;
        if (this.keysLength < 2) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("TCBSplinePathInterpolator0"));
        }
        if ((double)tCBKeyFrameArray[0].knot < -1.0E-4 || (double)tCBKeyFrameArray[0].knot > 1.0E-4) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("TCBSplinePathInterpolator1"));
        }
        if ((double)tCBKeyFrameArray[this.keysLength - 1].knot - 1.0 < -1.0E-4 || (double)tCBKeyFrameArray[this.keysLength - 1].knot - 1.0 > 1.0E-4) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("TCBSplinePathInterpolator2"));
        }
        int n = 0;
        while (n < this.keysLength) {
            if (n > 0 && tCBKeyFrameArray[n].knot < tCBKeyFrameArray[n - 1].knot) {
                throw new IllegalArgumentException(J3dUtilsI18N.getString("TCBSplinePathInterpolator3"));
            }
            ++n;
        }
        this.keyFrames = new TCBKeyFrame[this.keysLength + 2];
        this.keyFrames[0] = new TCBKeyFrame();
        this.keyFrames[0] = tCBKeyFrameArray[0];
        int n2 = 1;
        while (n2 < this.keysLength + 1) {
            this.keyFrames[n2] = tCBKeyFrameArray[n2 - 1];
            ++n2;
        }
        this.keyFrames[this.keysLength + 1] = new TCBKeyFrame();
        this.keyFrames[this.keysLength + 1] = tCBKeyFrameArray[this.keysLength - 1];
        this.keysLength += 2;
    }

    protected void computePathInterpolation() {
        float f = this.getAlpha().value();
        int n = 1;
        int n2 = this.keysLength - 2;
        while (f > this.keyFrames[n].knot && n < n2) {
            ++n;
        }
        if (n == 1) {
            this.currentU = 0.0f;
            this.lowerKnot = 1;
            this.upperKnot = 2;
        } else {
            this.currentU = (f - this.keyFrames[n - 1].knot) / (this.keyFrames[n].knot - this.keyFrames[n - 1].knot);
            this.lowerKnot = n - 1;
            this.upperKnot = n;
        }
    }

    public void duplicateNode(Node node, boolean bl) {
        super.duplicateNode(node, bl);
        TCBSplinePathInterpolator tCBSplinePathInterpolator = (TCBSplinePathInterpolator)node;
        this.setAlpha(tCBSplinePathInterpolator.getAlpha());
        this.keysLength = tCBSplinePathInterpolator.keysLength;
        this.keyFrames = new TCBKeyFrame[this.keysLength];
        System.arraycopy(tCBSplinePathInterpolator.keyFrames, 0, this.keyFrames, 0, this.keysLength);
    }

    public int getArrayLength() {
        return this.keysLength;
    }

    public TCBKeyFrame getKeyFrame(int n) {
        return this.keyFrames[n + 1];
    }
}

